(ns leiningen.kap.commands.generate
  (:require [clojure.java.io :as io]
            [leiningen.kap.migrations :refer [migrations-directory args-to-migration-filename filepath-to-name-space-string]]
            [leiningen.kap.templates :refer [render-template]]))

(defn run
  [example? [template-name & template-args :as args]]
  (let [basename  (if (= template-name "custom")
                    (args-to-migration-filename template-args)
                    (args-to-migration-filename args))
        filepath  (str migrations-directory basename ".clj")
        namespace (filepath-to-name-space-string filepath)
        params    {:namespace namespace :example example?}
        params    (into params (map-indexed #(vector (str "arg" %1) %2) template-args))
        content   (render-template template-name params)]
    (if content
      (do
        (io/copy content (io/file filepath))
        (println "New migration file:" filepath))
      (recur example? (cons "custom" args)))))
