/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.Loader;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pointer {
    private static final ReferenceQueue<Pointer> referenceQueue = new ReferenceQueue();
    protected long address = 0L;
    protected int position = 0;
    protected int limit = 0;
    protected int capacity = 0;
    private Deallocator deallocator = null;

    public Pointer() {
    }

    public Pointer(final Pointer p) {
        if (p != null) {
            this.address = p.address;
            this.position = p.position;
            this.limit = p.limit;
            this.capacity = p.capacity;
            if (p.deallocator != null) {
                this.deallocator = new Deallocator(){

                    public void deallocate() {
                        p.deallocate();
                    }
                };
            }
        }
    }

    public Pointer(final Buffer b) {
        if (b != null) {
            this.allocate(b);
        }
        if (!this.isNull()) {
            this.position = b.position();
            this.limit = b.limit();
            this.capacity = b.capacity();
            this.deallocator = new Deallocator(){
                Buffer bb;
                {
                    this.bb = b;
                }

                public void deallocate() {
                    this.bb = null;
                }
            };
        }
    }

    private native void allocate(Buffer var1);

    void init(long allocatedAddress, int allocatedCapacity, long deallocatorAddress) {
        this.address = allocatedAddress;
        this.position = 0;
        this.limit = allocatedCapacity;
        this.capacity = allocatedCapacity;
        this.deallocator(new NativeDeallocator(this, deallocatorAddress));
    }

    protected static <P extends Pointer> P withDeallocator(P p) {
        return p.deallocator(new CustomDeallocator(p));
    }

    public static void deallocateReferences() {
        DeallocatorReference r = null;
        while ((r = (DeallocatorReference)referenceQueue.poll()) != null) {
            r.clear();
            r.remove();
        }
    }

    public boolean isNull() {
        return this.address == 0L;
    }

    public void setNull() {
        this.address = 0L;
    }

    public int position() {
        return this.position;
    }

    public <P extends Pointer> P position(int position) {
        this.position = position;
        return (P)this;
    }

    public int limit() {
        return this.limit;
    }

    public <P extends Pointer> P limit(int limit) {
        this.limit = limit;
        return (P)this;
    }

    public int capacity() {
        return this.capacity;
    }

    public <P extends Pointer> P capacity(int capacity) {
        this.limit = capacity;
        this.capacity = capacity;
        return (P)this;
    }

    protected Deallocator deallocator() {
        return this.deallocator;
    }

    protected <P extends Pointer> P deallocator(Deallocator deallocator) {
        if (this.deallocator != null) {
            this.deallocator.deallocate();
            this.deallocator = null;
        }
        Pointer.deallocateReferences();
        if (deallocator != null && !deallocator.equals(null)) {
            this.deallocator = deallocator;
            DeallocatorReference r = deallocator instanceof DeallocatorReference ? (DeallocatorReference)((Object)deallocator) : new DeallocatorReference(this, deallocator);
            r.add();
        }
        return (P)this;
    }

    public void deallocate() {
        this.deallocator.deallocate();
        this.address = 0L;
    }

    public int offsetof(String member) {
        int offset = -1;
        try {
            Class<?> c = this.getClass();
            if (c != Pointer.class) {
                offset = Loader.offsetof(c, member);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return offset;
    }

    public int sizeof() {
        Class<?> c = this.getClass();
        if (c == Pointer.class || c == BytePointer.class) {
            return 1;
        }
        return this.offsetof("sizeof");
    }

    private native ByteBuffer asDirectBuffer();

    public ByteBuffer asByteBuffer() {
        if (this.isNull()) {
            return null;
        }
        if (this.limit > 0 && this.limit < this.position) {
            throw new IllegalArgumentException("limit < position: (" + this.limit + " < " + this.position + ")");
        }
        int valueSize = this.sizeof();
        int arrayPosition = this.position;
        int arrayLimit = this.limit;
        this.position = valueSize * arrayPosition;
        this.limit = valueSize * (arrayLimit <= 0 ? arrayPosition + 1 : arrayLimit);
        ByteBuffer b = this.asDirectBuffer().order(ByteOrder.nativeOrder());
        this.position = arrayPosition;
        this.limit = arrayLimit;
        return b;
    }

    public Buffer asBuffer() {
        return this.asByteBuffer();
    }

    public static native Pointer memchr(Pointer var0, int var1, long var2);

    public static native int memcmp(Pointer var0, Pointer var1, long var2);

    public static native Pointer memcpy(Pointer var0, Pointer var1, long var2);

    public static native Pointer memmove(Pointer var0, Pointer var1, long var2);

    public static native Pointer memset(Pointer var0, int var1, long var2);

    public <P extends Pointer> P put(Pointer p) {
        if (p.limit > 0 && p.limit < p.position) {
            throw new IllegalArgumentException("limit < position: (" + p.limit + " < " + p.position + ")");
        }
        int size = this.sizeof();
        int psize = p.sizeof();
        int length = psize * (p.limit <= 0 ? 1 : p.limit - p.position);
        this.position *= size;
        p.position *= psize;
        Pointer.memcpy(this, p, length);
        this.position /= size;
        p.position /= psize;
        return (P)this;
    }

    public <P extends Pointer> P fill(int b) {
        if (this.limit > 0 && this.limit < this.position) {
            throw new IllegalArgumentException("limit < position: (" + this.limit + " < " + this.position + ")");
        }
        int size = this.sizeof();
        int length = size * (this.limit <= 0 ? 1 : this.limit - this.position);
        this.position *= size;
        Pointer.memset(this, b, length);
        this.position /= size;
        return (P)this;
    }

    public <P extends Pointer> P zero() {
        return this.fill(0);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return this.isNull();
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Pointer other = (Pointer)obj;
        return this.address == other.address && this.position == other.position;
    }

    public int hashCode() {
        return (int)this.address;
    }

    public String toString() {
        return this.getClass().getName() + "[address=0x" + Long.toHexString(this.address) + ",position=" + this.position + ",limit=" + this.limit + ",capacity=" + this.capacity + ",deallocator=" + this.deallocator + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeallocatorReference
    extends PhantomReference<Pointer> {
        static DeallocatorReference head = null;
        DeallocatorReference prev = null;
        DeallocatorReference next = null;
        Deallocator deallocator;

        DeallocatorReference(Pointer p, Deallocator deallocator) {
            super(p, referenceQueue);
            this.deallocator = deallocator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void add() {
            Class<DeallocatorReference> clazz = DeallocatorReference.class;
            synchronized (DeallocatorReference.class) {
                if (head == null) {
                    head = this;
                } else {
                    this.next = head;
                    this.next.prev = head = this;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void remove() {
            Class<DeallocatorReference> clazz = DeallocatorReference.class;
            synchronized (DeallocatorReference.class) {
                if (this.prev == this && this.next == this) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (this.prev == null) {
                    head = this.next;
                } else {
                    this.prev.next = this.next;
                }
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
                this.prev = this.next = this;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.deallocator.deallocate();
        }
    }

    protected static class NativeDeallocator
    extends DeallocatorReference
    implements Deallocator {
        private long allocatedAddress;
        private long deallocatorAddress;

        NativeDeallocator(Pointer p, long deallocatorAddress) {
            super(p, (Deallocator)null);
            this.deallocator = this;
            this.allocatedAddress = p.address;
            this.deallocatorAddress = deallocatorAddress;
        }

        public void deallocate() {
            if (this.allocatedAddress != 0L && this.deallocatorAddress != 0L) {
                this.deallocate(this.allocatedAddress, this.deallocatorAddress);
                this.deallocatorAddress = 0L;
                this.allocatedAddress = 0L;
            }
        }

        private native void deallocate(long var1, long var3);
    }

    protected static class CustomDeallocator
    extends DeallocatorReference
    implements Deallocator {
        Pointer pointer = null;
        Method method = null;

        public CustomDeallocator(Pointer p) {
            super(p, (Deallocator)null);
            this.deallocator = this;
            Class<?> cls = p.getClass();
            for (Method m : cls.getDeclaredMethods()) {
                Class<?>[] parameters = m.getParameterTypes();
                if (!Modifier.isStatic(m.getModifiers()) || !m.getReturnType().equals(Void.TYPE) || !m.getName().equals("deallocate") || parameters.length != 1 || !Pointer.class.isAssignableFrom(parameters[0])) continue;
                m.setAccessible(true);
                this.method = m;
                break;
            }
            if (this.method == null) {
                throw new RuntimeException(new NoSuchMethodException("static void " + cls.getCanonicalName() + ".deallocate(" + Pointer.class.getCanonicalName() + ")"));
            }
            try {
                Constructor<?> c = cls.getConstructor(Pointer.class);
                c.setAccessible(true);
                this.pointer = (Pointer)c.newInstance(p);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public void deallocate() {
            try {
                this.method.invoke(null, this.pointer);
                this.pointer.setNull();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected static interface Deallocator {
        public void deallocate();
    }
}

