/*
 * Decompiled with CFR 0.152.
 */
package org.jblas.ranges;

import org.jblas.ranges.Range;

public class IntervalRange
implements Range {
    private int start;
    private int end;
    private int value;

    public IntervalRange(int a, int b) {
        this.start = a;
        this.end = b;
    }

    public void init(int lower, int upper) {
        this.value = this.start;
        if (this.start < lower || this.end > upper + 1) {
            throw new IllegalArgumentException("Bounds " + lower + " to " + upper + " are beyond range interval " + this.start + " to " + this.end + ".");
        }
    }

    public int length() {
        return this.end - this.start;
    }

    public void next() {
        ++this.value;
    }

    public int index() {
        return this.value;
    }

    public int value() {
        return this.value;
    }

    public boolean hasMore() {
        return this.value < this.end;
    }
}

