/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.mapped;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.util.mapped.CacheUtil;
import org.lwjgl.util.mapped.MappedHelper;
import org.lwjgl.util.mapped.MappedObjectUnsafe;

final class CacheLineSize {
    private CacheLineSize() {
    }

    static int getCacheLineSize() {
        int THREADS = 2;
        int REPEATS = 200000;
        int LOCAL_REPEATS = 100000;
        int MAX_SIZE = LWJGLUtil.getPrivilegedInteger((String)"org.lwjgl.util.mapped.CacheLineMaxSize", (int)1024) / 4;
        double TIME_THRESHOLD = 1.0 + (double)LWJGLUtil.getPrivilegedInteger((String)"org.lwjgl.util.mapped.CacheLineTimeThreshold", (int)50).intValue() / 100.0;
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        ExecutorCompletionService<Long> completionService = new ExecutorCompletionService<Long>(executorService);
        try {
            IntBuffer memory = CacheLineSize.getMemory(MAX_SIZE);
            int WARMUP = 10;
            int i = 0;
            while (i < 10) {
                CacheLineSize.doTest(2, 100000, 0, memory, completionService);
                ++i;
            }
            long totalTime = 0L;
            int count = 0;
            int cacheLineSize = 64;
            boolean found = false;
            int i2 = MAX_SIZE;
            while (i2 >= 1) {
                long avgTime;
                long time = CacheLineSize.doTest(2, 100000, i2, memory, completionService);
                if (totalTime > 0L && (double)time / (double)(avgTime = totalTime / (long)count) > TIME_THRESHOLD) {
                    cacheLineSize = (i2 << 1) * 4;
                    found = true;
                    break;
                }
                totalTime += time;
                ++count;
                i2 >>= 1;
            }
            if (LWJGLUtil.DEBUG) {
                if (found) {
                    LWJGLUtil.log((CharSequence)("Cache line size detected: " + cacheLineSize + " bytes"));
                } else {
                    LWJGLUtil.log((CharSequence)("Failed to detect cache line size, assuming " + cacheLineSize + " bytes"));
                }
            }
            int n = cacheLineSize;
            return n;
        }
        finally {
            executorService.shutdown();
        }
    }

    public static void main(String[] args) {
        CacheUtil.getCacheLineSize();
    }

    static long memoryLoop(int index, int repeats, IntBuffer memory, int padding) {
        long address = MemoryUtil.getAddress((IntBuffer)memory) + (long)(index * padding * 4);
        long time = System.nanoTime();
        int i = 0;
        while (i < repeats) {
            MappedHelper.ivput(MappedHelper.ivget(address) + 1, address);
            ++i;
        }
        return System.nanoTime() - time;
    }

    private static IntBuffer getMemory(int START_SIZE) {
        int PAGE_SIZE = MappedObjectUnsafe.INSTANCE.pageSize();
        ByteBuffer buffer = ByteBuffer.allocateDirect(START_SIZE * 4 + PAGE_SIZE).order(ByteOrder.nativeOrder());
        if (MemoryUtil.getAddress((ByteBuffer)buffer) % (long)PAGE_SIZE != 0L) {
            buffer.position(PAGE_SIZE - (int)(MemoryUtil.getAddress((ByteBuffer)buffer) & (long)(PAGE_SIZE - 1)));
        }
        return buffer.asIntBuffer();
    }

    private static long doTest(int threads, int repeats, int padding, IntBuffer memory, ExecutorCompletionService<Long> completionService) {
        int i = 0;
        while (i < threads) {
            CacheLineSize.submitTest(completionService, i, repeats, memory, padding);
            ++i;
        }
        return CacheLineSize.waitForResults(threads, completionService);
    }

    private static void submitTest(ExecutorCompletionService<Long> completionService, final int index, final int repeats, final IntBuffer memory, final int padding) {
        completionService.submit(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return CacheLineSize.memoryLoop(index, repeats, memory, padding);
            }
        });
    }

    private static long waitForResults(int count, ExecutorCompletionService<Long> completionService) {
        try {
            long totalTime = 0L;
            int i = 0;
            while (i < count) {
                totalTime += completionService.take().get().longValue();
                ++i;
            }
            return totalTime;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

