/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.core.distribute;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Category;
import org.neat4j.core.distribute.Experiment;
import org.neat4j.core.distribute.ExperimentNotRunException;
import org.neat4j.core.distribute.ExperimentServer;
import org.neat4j.core.distribute.MonitorTask;

class ExperimentConnection
implements Runnable {
    private static final Category cat;
    private static final int INIT = 0;
    private static final int REGISTERING = 1;
    private static final int WAITING_ON_EXPERIMENT_REQUEST = 2;
    private static final int WAITING_ON_EXPERIMENT_RESULT = 3;
    private static final int WAITING_ON_FUNCTION_REQUEST = 4;
    private static final int FINISHED = 5;
    private static final int MESSAGE_MARKER = 1;
    private static final int COMMAND_REGISTER = 16;
    private static final int COMMAND_REQUEST_EXPERIMENT = 32;
    private static final int COMMAND_REQUEST_FUNCTION = 64;
    private static final int COMMAND_INVALID = 0;
    private Socket handlerConnection;
    private int id;
    private ExperimentServer server;
    private boolean resultAccepted = true;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.neat4j.core.distribute.ExperimentConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cat = Category.getInstance((Class)clazz);
    }

    public ExperimentConnection(Socket handlerConnection, int id, ExperimentServer server) {
        this.handlerConnection = handlerConnection;
        this.id = id;
        this.server = server;
    }

    public void cancelExperiment(Experiment e) {
        this.server.returnFailedExperimentToPool(e);
    }

    public int id() {
        return this.id;
    }

    public void run() {
        this.stateMachine();
    }

    public void allowResult(boolean allow) {
        this.resultAccepted = allow;
    }

    private void stateMachine() {
        int state = 0;
        DataInputStream dis = null;
        FilterOutputStream dos = null;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        Experiment exp = null;
        Timer monitor = null;
        try {
            try {
                dis = new DataInputStream(this.handlerConnection.getInputStream());
                dos = new DataOutputStream(this.handlerConnection.getOutputStream());
                ois = new ObjectInputStream(dis);
                oos = new ObjectOutputStream(dos);
                while (state != 5) {
                    switch (state) {
                        case 0: {
                            int command = this.readCommand(dis);
                            if (command == 16) {
                                state = 1;
                                break;
                            }
                            cat.warn((Object)("Invalid command for INIT:" + command));
                            state = 5;
                            break;
                        }
                        case 1: {
                            this.writeRegistrationResponse((DataOutputStream)dos);
                            state = 4;
                            break;
                        }
                        case 4: {
                            int command = this.readCommand(dis);
                            if (command == 64) {
                                this.writeExperimentfunction(oos);
                                state = 2;
                                break;
                            }
                            cat.warn((Object)("Invalid command for WAITING_ON_FUNCTION_REQUEST:" + command));
                            state = 5;
                            break;
                        }
                        case 2: {
                            int command = this.readCommand(dis);
                            if (command == 32) {
                                this.resultAccepted = true;
                                exp = this.server.createExperiment();
                                this.writeExperimentResponse(exp, oos);
                                state = 3;
                                monitor = new Timer();
                                monitor.schedule((TimerTask)new MonitorTask(this, exp), 1000L);
                                break;
                            }
                            cat.warn((Object)("Invalid command for WAITING_ON_EXPERIMENT_REQUEST:" + command));
                            state = 5;
                            break;
                        }
                        case 3: {
                            exp = this.readResult(ois);
                            if (this.resultAccepted && exp != null) {
                                monitor.cancel();
                                this.server.finishedExperiment(exp);
                            } else {
                                cat.error((Object)("Failed to finish experiment:" + this.resultAccepted));
                            }
                            state = 2;
                            break;
                        }
                    }
                }
            }
            catch (IOException e) {
                state = 5;
                this.cancelExperiment(exp);
                e.printStackTrace();
            }
            catch (ExperimentNotRunException e) {
                state = 5;
                this.cancelExperiment(exp);
                e.printStackTrace();
            }
            catch (Exception e) {
                state = 5;
                this.cancelExperiment(exp);
                e.printStackTrace();
            }
        }
        finally {
            try {
                ois.close();
                oos.close();
                dis.close();
                dos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeExperimentResponse(Experiment exp, ObjectOutputStream oos) {
        try {
            oos.writeObject(exp);
            oos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeRegistrationResponse(DataOutputStream dos) {
        try {
            dos = new DataOutputStream(this.handlerConnection.getOutputStream());
            dos.write(1);
            dos.write(this.id);
            dos.write(1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeExperimentfunction(ObjectOutputStream oos) {
        try {
            oos.writeObject(this.server.function());
            oos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Experiment readResult(ObjectInputStream ois) {
        Experiment exp = null;
        try {
            exp = (Experiment)ois.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return exp;
    }

    private int readCommand(DataInputStream dis) {
        int command = 0;
        try {
            int data = dis.read();
            if (data == 1) {
                command = dis.read();
                data = dis.read();
                if (data != 1) {
                    command = 0;
                }
            }
        }
        catch (IOException e) {
            command = 0;
        }
        return command;
    }
}

