/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.applications.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import org.apache.log4j.Category;
import org.neat4j.neat.applications.gui.DisplayNeuron;
import org.neat4j.neat.core.NEATNeuralNet;
import org.neat4j.neat.core.NEATNeuron;

class NEATCanvas
extends Canvas {
    private static final Category cat;
    private NEATNeuralNet net;
    private int canvasH;
    private int canvasW;
    private static final int X_OFFSET = 50;
    private static final int Y_OFFSET = 30;
    private static final int R_OFFSET = 10;
    private static final int F_OFFSET = 20;
    private static final int N_SIZE = 15;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.neat4j.neat.applications.gui.NEATCanvas");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cat = Category.getInstance((Class)clazz);
    }

    public NEATCanvas(NEATNeuralNet net, int height, int width) {
        this.net = net;
        this.canvasH = height;
        this.canvasW = width;
        this.setBackground(Color.DARK_GRAY);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.canvasW, this.canvasH);
    }

    public void display() {
    }

    private NEATNeuron[][] analyseNeuronStructure() {
        int maxDepth = 1;
        int maxWidth = 0;
        int row = 0;
        int col = 0;
        NEATNeuron[] neurons = this.net.neurons();
        int[] nDepthWidth = new int[neurons.length];
        int inputs = this.net.netDescriptor().numInputs();
        int i = 0;
        while (i < neurons.length) {
            if (neurons[i].neuronDepth() >= 0 && neurons[i].neuronType() != 2) {
                if (neurons[i].neuronType() == 1) {
                    nDepthWidth[0] = nDepthWidth[0] + 1;
                } else if (neurons[i].neuronType() == 0) {
                    if (neurons[i].neuronDepth() > maxDepth - 1) {
                        maxDepth = neurons[i].neuronDepth() + 1;
                    }
                    int n = neurons[i].neuronDepth();
                    nDepthWidth[n] = nDepthWidth[n] + 1;
                }
                if (nDepthWidth[neurons[i].neuronDepth()] > maxWidth) {
                    maxWidth = nDepthWidth[neurons[i].neuronDepth()];
                }
            }
            ++i;
        }
        ++maxDepth;
        if (inputs > maxWidth) {
            maxWidth = inputs;
        }
        NEATNeuron[][] neuronStructure = new NEATNeuron[maxDepth][maxWidth];
        nDepthWidth = new int[neurons.length];
        i = 0;
        while (i < neurons.length) {
            NEATNeuron neuron = neurons[i];
            if (neuron.neuronDepth() >= 0) {
                row = neuron.neuronType() == 2 ? maxDepth - 1 : neuron.neuronDepth();
                col = nDepthWidth[row];
                neuronStructure[row][col] = neuron;
                int n = row;
                nDepthWidth[n] = nDepthWidth[n] + 1;
            }
            ++i;
        }
        return neuronStructure;
    }

    public void paint(Graphics g) {
        NEATNeuron neuron;
        ArrayList rowList;
        int row = 0;
        int col = 0;
        NEATNeuron[][] structure = this.analyseNeuronStructure();
        DisplayNeuron[] displayNeurons = new DisplayNeuron[structure.length * structure[0].length];
        ArrayList<ArrayList> structureList = new ArrayList<ArrayList>();
        row = 0;
        while (row < structure.length) {
            rowList = new ArrayList();
            col = 0;
            while (col < structure[0].length) {
                neuron = structure[row][col];
                if (neuron != null) {
                    rowList.add(neuron);
                }
                ++col;
            }
            structureList.add(rowList);
            ++row;
        }
        row = 0;
        while (row < structureList.size()) {
            rowList = (ArrayList)structureList.get(row);
            col = 0;
            while (col < rowList.size()) {
                neuron = (NEATNeuron)rowList.get(col);
                displayNeurons[row * structure[0].length + col] = new DisplayNeuron(neuron, this.canvasW / (rowList.size() + 1) * (col + 1), (this.canvasH / structureList.size() - 40) * (row + 1));
                ++col;
            }
            ++row;
        }
        int i = 0;
        while (i < displayNeurons.length) {
            DisplayNeuron from = displayNeurons[i];
            if (from != null) {
                DisplayNeuron[] displaySources = this.findDisplaySources(displayNeurons, from);
                int j = 0;
                while (j < displaySources.length) {
                    this.drawLink(from, displaySources[j], g);
                    ++j;
                }
                this.drawNeuron(from, g);
            }
            ++i;
        }
    }

    private DisplayNeuron[] findDisplaySources(DisplayNeuron[] displayNeurons, DisplayNeuron from) {
        ArrayList sourceNeurons = from.neuron().sourceNeurons();
        DisplayNeuron[] targets = new DisplayNeuron[sourceNeurons.size()];
        int i = 0;
        while (i < targets.length) {
            targets[i] = this.findTarget(displayNeurons, ((NEATNeuron)sourceNeurons.get(i)).id());
            ++i;
        }
        return targets;
    }

    private DisplayNeuron findTarget(DisplayNeuron[] displayNeurons, int id) {
        int i = 0;
        boolean found = false;
        DisplayNeuron target = null;
        while (i < displayNeurons.length && !found) {
            if (displayNeurons[i] != null && displayNeurons[i].neuron().id() == id) {
                target = displayNeurons[i];
                found = true;
            }
            ++i;
        }
        return target;
    }

    private void drawNeuron(DisplayNeuron neuron, Graphics g) {
        if (neuron.neuron().neuronType() == 2) {
            g.setColor(Color.MAGENTA);
        } else if (neuron.neuron().sourceNeurons().size() == 0) {
            g.setColor(Color.GREEN);
        } else if (neuron.neuron().neuronType() == 1) {
            g.setColor(Color.ORANGE);
        } else {
            g.setColor(Color.LIGHT_GRAY);
        }
        g.fillRoundRect(neuron.x(), neuron.y(), 15, 15, 5, 5);
        g.setColor(Color.WHITE);
        g.drawString("id=" + neuron.neuron().id(), neuron.x(), neuron.y());
    }

    private void drawLink(DisplayNeuron from, DisplayNeuron to, Graphics g) {
        if (from.neuron().id() == to.neuron().id()) {
            g.setColor(Color.BLUE);
            g.drawLine(from.x() + 15, from.y() + 10, to.x() + 15 + 10, to.y() + 10);
            g.drawLine(to.x() + 15 + 10, to.y() + 10, to.x() + 15 + 10, to.y() + 10 + 15);
            g.drawLine(to.x() + 15 + 10, to.y() + 10 + 15, to.x() + 10, to.y() + 10 + 15);
            g.drawLine(to.x() + 10, to.y() + 10 + 15, to.x() + 10, to.y());
        } else if (from.neuron().neuronDepth() >= to.neuron().neuronDepth()) {
            g.setColor(Color.YELLOW);
            g.drawLine(to.x(), to.y(), to.x() - 10, to.y() - 10);
            g.drawLine(to.x() - 10, to.y() - 10, to.x() - 10, to.y() + 10);
            g.drawLine(to.x() - 10, to.y() + 10, from.x(), from.y());
        } else {
            g.setColor(Color.RED);
            g.drawLine(to.x() + 7, to.y() + 7, to.x() + 7 - 20, to.y() + 7);
            g.drawLine(to.x() + 7 - 20, to.y() + 7, to.x() + 7 - 20, to.y() + 7 - 20);
            g.drawLine(to.x() + 7 - 20, to.y() + 7 - 20, from.x() + 7, from.y() + 7);
        }
    }
}

