/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.neat4j.neat.core.NEATChromosome;
import org.neat4j.neat.core.NEATFeatureGene;
import org.neat4j.neat.core.NEATFeatureInnovation;
import org.neat4j.neat.core.NEATInnovation;
import org.neat4j.neat.core.NEATLinkGene;
import org.neat4j.neat.core.NEATLinkInnovation;
import org.neat4j.neat.core.NEATNodeGene;
import org.neat4j.neat.core.NEATNodeInnovation;
import org.neat4j.neat.ga.core.Chromosome;
import org.neat4j.neat.ga.core.Gene;
import org.neat4j.neat.utils.MathUtils;

public class InnovationDatabase {
    private Random ran = new Random();
    private HashMap innovations = new HashMap();
    private static int innovationId = 1;
    private static int neuronId = 1;
    private static final InnovationDatabase database = new InnovationDatabase();
    public static int hits = 0;
    public static int misses = 0;

    private InnovationDatabase() {
    }

    private int nextInnovationNumber() {
        return innovationId++;
    }

    private int nextNodeNumber() {
        return neuronId++;
    }

    public static InnovationDatabase database() {
        return database;
    }

    public Chromosome[] initialiseInnovations(int popSize, int inputs, int outputs, boolean featureSelection, int extraFeatureCount) {
        NEATNodeGene[] nodes = new NEATNodeGene[inputs + outputs];
        NEATFeatureGene[] features = new NEATFeatureGene[extraFeatureCount];
        Chromosome[] templates = new Chromosome[popSize];
        int i = 0;
        while (i < extraFeatureCount) {
            features[i] = this.createFeatureGene();
            ++i;
        }
        i = 0;
        while (i < inputs) {
            nodes[i] = this.createNewNodeGene(2);
            ++i;
        }
        i = inputs;
        while (i < nodes.length) {
            nodes[i] = this.createNewNodeGene(1);
            ++i;
        }
        int popIdx = 0;
        while (popIdx < templates.length) {
            NEATLinkGene[] links;
            if (featureSelection) {
                links = new NEATLinkGene[outputs];
                i = 0;
                while (i < outputs) {
                    links[i] = this.submitLinkInnovation(nodes[this.ran.nextInt(inputs)].id(), nodes[inputs + i].id());
                    links[i].setWeight(MathUtils.nextPlusMinusOne());
                    ++i;
                }
            } else {
                links = new NEATLinkGene[inputs * outputs];
                i = 0;
                while (i < outputs) {
                    int j = 0;
                    while (j < inputs) {
                        links[i * outputs + j] = this.submitLinkInnovation(nodes[j].id(), nodes[inputs + i].id());
                        links[i * outputs + j].setWeight(MathUtils.nextPlusMinusOne());
                        ++j;
                    }
                    ++i;
                }
            }
            templates[popIdx] = this.createNEATChromosome(nodes, links, features);
            ++popIdx;
        }
        return templates;
    }

    private Chromosome createNEATChromosome(NEATNodeGene[] nodes, NEATLinkGene[] links, NEATFeatureGene[] features) {
        Gene[] genes = new Gene[nodes.length + links.length + features.length];
        System.arraycopy(features, 0, genes, 0, features.length);
        System.arraycopy(nodes, 0, genes, features.length, nodes.length);
        System.arraycopy(links, 0, genes, features.length + nodes.length, links.length);
        return new NEATChromosome(genes);
    }

    private NEATFeatureGene createFeatureGene() {
        int innovationNumber = this.nextInnovationNumber();
        NEATFeatureInnovation databaseEntry = new NEATFeatureInnovation();
        databaseEntry.setInnovationId(innovationNumber);
        this.innovations.put(new Integer(innovationNumber), databaseEntry);
        return new NEATFeatureGene(innovationNumber, MathUtils.nextDouble());
    }

    private NEATNodeGene createNewNodeGene(int type) {
        int innovationNumber = this.nextInnovationNumber();
        NEATNodeInnovation databaseEntry = new NEATNodeInnovation();
        databaseEntry.setInnovationId(innovationNumber);
        databaseEntry.setNodeId(this.nextNodeNumber());
        this.innovations.put(new Integer(innovationNumber), databaseEntry);
        NEATNodeGene nodeGene = new NEATNodeGene(innovationNumber, databaseEntry.getNodeId(), MathUtils.nextDouble(), type, MathUtils.nextPlusMinusOne());
        return nodeGene;
    }

    private NEATInnovation findNodeInnovation(int linkInnovationId) {
        NEATNodeInnovation nodeInnovation = new NEATNodeInnovation(linkInnovationId);
        NEATInnovation databaseEntry = null;
        boolean found = false;
        if (this.innovations.containsValue(nodeInnovation)) {
            Set keySet = this.innovations.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext() && !found) {
                Integer key = (Integer)it.next();
                databaseEntry = (NEATInnovation)this.innovations.get(key);
                if (!(databaseEntry instanceof NEATNodeInnovation) || databaseEntry == null || ((NEATNodeInnovation)databaseEntry).getLinkInnovationId() != linkInnovationId) continue;
                found = true;
            }
        }
        return databaseEntry;
    }

    public NEATNodeGene submitNodeInnovation(NEATLinkGene linkGene) {
        NEATInnovation databaseEntry = this.findNodeInnovation(linkGene.getInnovationNumber());
        NEATNodeGene gene = null;
        if (databaseEntry == null) {
            ++misses;
            int innovationNumber = this.nextInnovationNumber();
            databaseEntry = new NEATNodeInnovation(linkGene.getInnovationNumber());
            ((NEATNodeInnovation)databaseEntry).setNodeId(this.nextNodeNumber());
            databaseEntry.setInnovationId(innovationNumber);
            this.innovations.put(new Integer(innovationNumber), databaseEntry);
        } else {
            ++hits;
        }
        gene = new NEATNodeGene(databaseEntry.innovationId(), ((NEATNodeInnovation)databaseEntry).getNodeId(), MathUtils.nextDouble(), 0, MathUtils.nextPlusMinusOne());
        return gene;
    }

    public NEATLinkGene submitLinkInnovation(int fromId, int toId) {
        NEATInnovation databaseEntry = this.findLinkInnovation(fromId, toId);
        if (databaseEntry == null) {
            ++misses;
            int innovationNumber = this.nextInnovationNumber();
            databaseEntry = new NEATLinkInnovation(fromId, toId);
            databaseEntry.setInnovationId(innovationNumber);
            this.innovations.put(new Integer(innovationNumber), databaseEntry);
        } else {
            ++hits;
        }
        NEATLinkGene gene = new NEATLinkGene(databaseEntry.innovationId(), true, fromId, toId, 0.0);
        return gene;
    }

    private NEATInnovation findLinkInnovation(int fromId, int toId) {
        NEATLinkInnovation linkInnovation = new NEATLinkInnovation(fromId, toId);
        NEATInnovation databaseEntry = null;
        boolean found = false;
        if (this.innovations.containsValue(linkInnovation)) {
            Set keySet = this.innovations.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext() && !found) {
                Integer key = (Integer)it.next();
                databaseEntry = (NEATInnovation)this.innovations.get(key);
                if (!(databaseEntry instanceof NEATLinkInnovation) || databaseEntry == null || ((NEATLinkInnovation)databaseEntry).getFromId() != fromId || ((NEATLinkInnovation)databaseEntry).getToId() != toId) continue;
                found = true;
            }
        }
        return databaseEntry;
    }
}

