/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.core;

import org.neat4j.neat.core.NEATGene;
import org.neat4j.neat.ga.core.Chromosome;
import org.neat4j.neat.ga.core.Gene;

public class NEATChromosome
implements Chromosome {
    private Gene[] genes;
    private double fitness;
    private int specieId = -1;
    private boolean nOrder = false;

    public NEATChromosome(Gene[] genes) {
        this.updateChromosome(genes);
    }

    public int getSpecieId() {
        return this.specieId;
    }

    public void setSpecieId(int specieId) {
        this.specieId = specieId;
    }

    public Gene[] genes() {
        return this.genes;
    }

    public int size() {
        return this.genes.length;
    }

    public void updateChromosome(Gene[] newGenes) {
        this.genes = new NEATGene[newGenes.length];
        System.arraycopy(newGenes, 0, this.genes, 0, this.genes.length);
    }

    public void updateFitness(double fitness) {
        this.fitness = fitness;
    }

    public double fitness() {
        return this.fitness;
    }

    public void setNaturalOrder(boolean nOrder) {
        this.nOrder = nOrder;
    }

    public int compareTo(Object o) {
        int returnVal = 0;
        NEATChromosome test = (NEATChromosome)o;
        if (this.fitness > test.fitness()) {
            returnVal = this.nOrder ? 1 : -1;
        } else if (this.fitness < test.fitness()) {
            returnVal = this.nOrder ? -1 : 1;
        }
        return returnVal;
    }
}

