/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.core;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Category;
import org.neat4j.neat.core.NEATLinkGene;
import org.neat4j.neat.core.NEATNetDescriptor;
import org.neat4j.neat.core.NEATNetOutput;
import org.neat4j.neat.core.NEATNetOutputSet;
import org.neat4j.neat.core.NEATNeuron;
import org.neat4j.neat.core.NEATNodeGene;
import org.neat4j.neat.data.core.NetworkInput;
import org.neat4j.neat.data.core.NetworkOutputSet;
import org.neat4j.neat.ga.core.Chromosome;
import org.neat4j.neat.ga.core.Gene;
import org.neat4j.neat.nn.core.ActivationFunction;
import org.neat4j.neat.nn.core.NeuralNet;
import org.neat4j.neat.nn.core.NeuralNetDescriptor;
import org.neat4j.neat.nn.core.NeuralNetLayer;
import org.neat4j.neat.nn.core.Neuron;
import org.neat4j.neat.nn.core.Synapse;
import org.neat4j.neat.nn.core.functions.LinearFunction;
import org.neat4j.neat.nn.core.functions.SigmoidFunction;
import org.neat4j.neat.nn.core.functions.TanhFunction;

public class NEATNeuralNet
implements NeuralNet {
    private static final Category cat;
    private NEATNetDescriptor descriptor;
    private Synapse[] connections;
    private NEATNeuron[] neurons;
    private int level = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.neat4j.neat.core.NEATNeuralNet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cat = Category.getInstance((Class)clazz);
    }

    public NEATNeuron[] neurons() {
        return this.neurons;
    }

    public NetworkOutputSet execute(NetworkInput netInput) {
        this.level = 0;
        Object[] outputNeurons = this.outputNeurons().toArray();
        if (outputNeurons.length == 0) {
            cat.debug((Object)"No output neurons");
        }
        double[] outputs = new double[outputNeurons.length];
        int i = 0;
        while (i < outputs.length) {
            outputs[i] = this.neuronOutput((NEATNeuron)outputNeurons[i], netInput);
            ++i;
        }
        NEATNetOutputSet opSet = new NEATNetOutputSet();
        opSet.addNetworkOutput(new NEATNetOutput(outputs));
        return opSet;
    }

    public ArrayList outputNeurons() {
        ArrayList<NEATNeuron> outputNeurons = new ArrayList<NEATNeuron>();
        int i = 0;
        while (i < this.neurons.length) {
            if (this.neurons[i].neuronType() == 1) {
                outputNeurons.add(this.neurons[i]);
            }
            ++i;
        }
        return outputNeurons;
    }

    private double neuronOutput(NEATNeuron neuron, NetworkInput netInput) {
        double[] inputPattern;
        double output = 0.0;
        Object[] sourceNodes = neuron.sourceNeurons().toArray();
        Object[] incomingSynapses = neuron.incomingSynapses().toArray();
        ++this.level;
        if (neuron.neuronType() == 2) {
            inputPattern = new double[]{netInput.pattern()[neuron.id() - 1]};
        } else {
            inputPattern = new double[sourceNodes.length];
            int i = 0;
            while (i < sourceNodes.length) {
                inputPattern[i] = neuron.id() == ((NEATNeuron)sourceNodes[i]).id() ? neuron.lastActivation() : (neuron.neuronDepth() > ((NEATNeuron)sourceNodes[i]).neuronDepth() ? ((NEATNeuron)sourceNodes[i]).lastActivation() : this.neuronOutput((NEATNeuron)sourceNodes[i], netInput));
                ++i;
            }
        }
        output = neuron.activate(inputPattern);
        --this.level;
        return output;
    }

    public void updateNetStructure() {
        Chromosome netStructure = this.descriptor.neatStructure();
        ArrayList<Gene> nodes = new ArrayList<Gene>();
        ArrayList<Gene> links = new ArrayList<Gene>();
        Gene[] genes = netStructure.genes();
        int i = 0;
        while (i < netStructure.size()) {
            if (genes[i] instanceof NEATNodeGene) {
                nodes.add(genes[i]);
            } else if (genes[i] instanceof NEATLinkGene && ((NEATLinkGene)genes[i]).isEnabled()) {
                links.add(genes[i]);
            }
            ++i;
        }
        this.connections = this.createLinks(links, this.createNeurons(nodes));
        this.assignNeuronDepth(this.outputNeurons(), 0);
    }

    private void assignNeuronDepth(ArrayList neurons, int depth) {
        int i = 0;
        while (i < neurons.size()) {
            NEATNeuron neuron = (NEATNeuron)neurons.get(i);
            if (neuron.neuronType() == 1) {
                if (neuron.neuronDepth() == -1) {
                    neuron.setNeuronDepth(depth);
                    this.assignNeuronDepth(neuron.sourceNeurons(), depth + 1);
                }
            } else if (neuron.neuronType() == 0) {
                if (neuron.neuronDepth() == -1) {
                    neuron.setNeuronDepth(depth);
                    this.assignNeuronDepth(neuron.sourceNeurons(), depth + 1);
                }
            } else if (neuron.neuronType() == 2) {
                neuron.setNeuronDepth(Integer.MAX_VALUE);
            }
            ++i;
        }
    }

    private NEATNeuron[] createNeurons(ArrayList nodes) {
        this.neurons = new NEATNeuron[nodes.size()];
        int i = 0;
        while (i < this.neurons.length) {
            NEATNodeGene gene = (NEATNodeGene)nodes.get(i);
            this.neurons[i] = new NEATNeuron(this.createActivationFunction(gene), gene.id(), gene.getType());
            this.neurons[i].modifyBias(gene.bias(), 0.0, true);
            ++i;
        }
        return this.neurons;
    }

    private ActivationFunction createActivationFunction(NEATNodeGene gene) {
        ActivationFunction function = null;
        function = gene.getType() == 2 ? new LinearFunction() : (gene.getType() == 1 ? new SigmoidFunction(gene.sigmoidFactor()) : new TanhFunction());
        return function;
    }

    private Synapse[] createLinks(ArrayList links, NEATNeuron[] neurons) {
        Synapse[] synapses = new Synapse[links.size()];
        int i = 0;
        while (i < links.size()) {
            NEATLinkGene gene = (NEATLinkGene)links.get(i);
            NEATNeuron from = this.findNeuronById(neurons, gene.getFromId());
            NEATNeuron to = this.findNeuronById(neurons, gene.getToId());
            to.addSourceNeuron(from);
            synapses[i] = new Synapse(from, to, gene.getWeight());
            synapses[i].setEnabled(gene.isEnabled());
            to.addIncomingSynapse(synapses[i]);
            ++i;
        }
        return synapses;
    }

    private NEATNeuron findNeuronById(NEATNeuron[] neurons, int id) {
        boolean found = false;
        NEATNeuron neuron = null;
        int i = 0;
        while (!found) {
            if (neurons[i].id() == id) {
                neuron = neurons[i];
                found = true;
                continue;
            }
            ++i;
        }
        return neuron;
    }

    public void createNetStructure(NeuralNetDescriptor descriptor) {
        this.descriptor = (NEATNetDescriptor)descriptor;
    }

    public NeuralNetDescriptor netDescriptor() {
        return this.descriptor;
    }

    public Collection hiddenLayers() {
        return null;
    }

    public NeuralNetLayer outputLayer() {
        return null;
    }

    public void seedNet(double[] weights) {
    }

    public int requiredWeightCount() {
        return 0;
    }

    public int netID() {
        return 0;
    }

    public Neuron neuronAt(int x, int y) {
        return null;
    }
}

