/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.core;

import org.neat4j.neat.core.NEATGene;
import org.neat4j.neat.core.NEATLinkGene;
import org.neat4j.neat.ga.core.Chromosome;
import org.neat4j.neat.ga.core.Gene;

public class NEATSpecieManager {
    private static final NEATSpecieManager manager = new NEATSpecieManager();

    private NEATSpecieManager() {
    }

    public static NEATSpecieManager specieManager() {
        return manager;
    }

    public double compatibilityScore(Chromosome specieApplicant, Chromosome specieRepresentative, double excessCoeff, double disjointCoeff, double weightCoeff) {
        int disjoints = 0;
        int excess = 0;
        boolean genesToProcess = true;
        int applicantIdx = 0;
        boolean applicantIdxEnded = false;
        int repIdx = 0;
        boolean repIdxEnded = false;
        double avWeightDiff = 0.0;
        double weightDiffTotal = 0.0;
        double compatabilityScore = 2.147483647E9;
        Gene[] applicantGenes = specieApplicant.genes();
        Gene[] repGenes = specieRepresentative.genes();
        int N = specieApplicant.size() > specieRepresentative.size() ? specieApplicant.size() : specieRepresentative.size();
        while (genesToProcess) {
            if (((NEATGene)applicantGenes[applicantIdx]).getInnovationNumber() == ((NEATGene)repGenes[repIdx]).getInnovationNumber()) {
                if (applicantGenes[applicantIdx] instanceof NEATLinkGene) {
                    weightDiffTotal += ((NEATLinkGene)applicantGenes[applicantIdx]).getWeight() - ((NEATLinkGene)repGenes[repIdx]).getWeight();
                }
                ++applicantIdx;
                ++repIdx;
            } else if (((NEATGene)applicantGenes[applicantIdx]).getInnovationNumber() > ((NEATGene)repGenes[repIdx]).getInnovationNumber()) {
                if (repIdx < repGenes.length && !repIdxEnded) {
                    ++repIdx;
                    ++disjoints;
                } else {
                    ++applicantIdx;
                    ++excess;
                }
            } else if (((NEATGene)applicantGenes[applicantIdx]).getInnovationNumber() < ((NEATGene)repGenes[repIdx]).getInnovationNumber()) {
                if (applicantIdx < applicantGenes.length && !applicantIdxEnded) {
                    ++applicantIdx;
                    ++disjoints;
                } else {
                    ++repIdx;
                    ++excess;
                }
            }
            if (applicantIdx == N || repIdx == N) {
                genesToProcess = false;
            }
            if (applicantIdx == applicantGenes.length) {
                applicantIdx %= applicantGenes.length;
                applicantIdxEnded = true;
                continue;
            }
            if (repIdx != repGenes.length) continue;
            repIdx %= repGenes.length;
            repIdxEnded = true;
        }
        avWeightDiff = Math.abs(weightDiffTotal / (double)(N - disjoints - excess));
        compatabilityScore = excessCoeff * (double)excess / (double)N + disjointCoeff * (double)disjoints / (double)N + weightCoeff * avWeightDiff;
        return compatabilityScore;
    }
}

