/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.core.control;

import java.lang.reflect.Constructor;
import org.apache.log4j.Category;
import org.neat4j.core.AIConfig;
import org.neat4j.core.AIController;
import org.neat4j.core.InitialisationFailedException;
import org.neat4j.neat.core.NEATNetDescriptor;
import org.neat4j.neat.data.core.NetworkDataSet;
import org.neat4j.neat.data.csv.CSVDataLoader;
import org.neat4j.neat.nn.core.Learnable;
import org.neat4j.neat.nn.core.LearningEnvironment;
import org.neat4j.neat.nn.core.NeuralNet;
import org.neat4j.neat.nn.core.NeuralNetDescriptor;
import org.neat4j.neat.nn.core.NeuralNetFactory;

public class NEATNetManager
implements AIController {
    private static final Category cat;
    private NeuralNet net;
    private AIConfig config;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.neat4j.neat.core.control.NEATNetManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cat = Category.getInstance((Class)clazz);
    }

    public boolean save(String fileName) {
        return false;
    }

    public NeuralNetDescriptor createNetDescriptor() {
        return this.createNetDescriptor(this.config);
    }

    public NeuralNetDescriptor createNetDescriptor(AIConfig config) {
        NEATNetDescriptor descriptor = null;
        int inputLayerSize = Integer.parseInt(config.configElement("INPUT_SIZE"));
        int outputLayerSize = Integer.parseInt(config.configElement("OUTPUT_SIZE"));
        Learnable learnable = this.createLearnable(config, outputLayerSize);
        descriptor = new NEATNetDescriptor(inputLayerSize, learnable);
        return descriptor;
    }

    public void initialise(AIConfig config) throws InitialisationFailedException {
        this.config = config;
        NeuralNetDescriptor descriptor = this.createNetDescriptor();
        this.net = NeuralNetFactory.getFactory().createNN(descriptor);
    }

    public NetworkDataSet dataSet(String keyName, AIConfig config, int opSize) {
        NetworkDataSet dSet = null;
        String fileName = config.configElement(keyName);
        if (fileName != null) {
            dSet = new CSVDataLoader(fileName, opSize).loadData();
        }
        return dSet;
    }

    public Learnable createLearnable(AIConfig config, int numOutputs) {
        Learnable learnable = null;
        String learnableClassName = config.configElement("LEARNABLE");
        if (learnableClassName != null) {
            cat.debug((Object)("learnableClassName:" + learnableClassName));
            LearningEnvironment le = new LearningEnvironment();
            NetworkDataSet dSet = this.dataSet("TRAINING.SET", config, numOutputs);
            le.addEnvironmentParameter("TRAINING.SET", dSet);
            try {
                Class<?> lClass = Class.forName(learnableClassName);
                Class[] classArray = new Class[1];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.neat4j.neat.nn.core.LearningEnvironment");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Constructor<?> c = lClass.getConstructor(classArray);
                learnable = (Learnable)c.newInstance(le);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return learnable;
    }

    public NeuralNet managedNet() {
        return this.net;
    }
}

