/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.core.mutators;

import java.util.ArrayList;
import java.util.Random;
import org.apache.log4j.Category;
import org.neat4j.neat.core.InnovationDatabase;
import org.neat4j.neat.core.NEATChromosome;
import org.neat4j.neat.core.NEATFeatureGene;
import org.neat4j.neat.core.NEATLinkGene;
import org.neat4j.neat.core.NEATNodeGene;
import org.neat4j.neat.ga.core.Chromosome;
import org.neat4j.neat.ga.core.Gene;
import org.neat4j.neat.ga.core.Mutator;
import org.neat4j.neat.utils.MathUtils;

public class NEATMutator
implements Mutator {
    private static final Category cat;
    private double pAddLink;
    private double pAddNode;
    private double pPerturb;
    private double pToggle;
    private double pWeightReplaced;
    private double pMutateBias;
    private boolean featureSelection = false;
    private boolean recurrencyAllowed = true;
    private double perturb = 5.0;
    private double biasPerturb = 0.1;
    private static final int MAX_LINK_ATTEMPTS = 5;
    private static final Random linkRand;
    private static final Random nodeRand;
    private static final Random perturbRand;
    private static final Random disableRand;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.neat4j.neat.core.mutators.NEATMutator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cat = Category.getInstance((Class)clazz);
        linkRand = new Random();
        nodeRand = new Random(linkRand.nextLong());
        perturbRand = new Random(linkRand.nextLong());
        disableRand = new Random(linkRand.nextLong());
    }

    public NEATMutator() {
    }

    public NEATMutator(double pAddNode, double pAddLink, double pDisable) {
        this.pAddNode = pAddNode;
        this.pAddLink = pAddLink;
        this.pToggle = pDisable;
    }

    public void setRecurrencyAllowed(boolean allowed) {
        this.recurrencyAllowed = allowed;
    }

    public void setProbability(double prob) {
        this.pPerturb = prob;
    }

    public void setPWeightReplaced(double pWR) {
        this.pWeightReplaced = pWR;
    }

    public Chromosome mutate(Chromosome mutatee) {
        Gene[] genes = mutatee.genes();
        int i = 0;
        while (i < genes.length) {
            if (genes[i] instanceof NEATLinkGene) {
                genes[i] = this.mutateLink((NEATLinkGene)genes[i]);
            } else if (genes[i] instanceof NEATNodeGene) {
                genes[i] = this.mutateNode((NEATNodeGene)genes[i]);
            } else if (genes[i] instanceof NEATFeatureGene) {
                genes[i] = this.mutateFeature((NEATFeatureGene)genes[i]);
            }
            ++i;
        }
        NEATChromosome mutated = new NEATChromosome(genes);
        mutated.setSpecieId(((NEATChromosome)mutatee).getSpecieId());
        this.mutateAddLink(mutated);
        this.mutateAddNode(mutated);
        this.updateDepthInfo(mutated);
        mutated.updateChromosome(this.ensureLegalLinks(mutated.genes()));
        return mutated;
    }

    private Gene mutateFeature(NEATFeatureGene mutatee) {
        double perturbRandVal = perturbRand.nextDouble();
        NEATFeatureGene mutated = mutatee;
        if (perturbRandVal < this.pPerturb) {
            mutated = new NEATFeatureGene(mutatee.getInnovationNumber(), mutatee.geneAsNumber().doubleValue() + MathUtils.nextClampedDouble(-this.perturb, this.perturb));
        }
        return mutated;
    }

    private Gene mutateLink(NEATLinkGene mutatee) {
        double perturbRandVal = perturbRand.nextDouble();
        double disableRandVal = disableRand.nextDouble();
        NEATLinkGene mutated = mutatee;
        if (perturbRandVal < this.pPerturb) {
            double newWeight = this.pWeightReplaced > perturbRand.nextDouble() ? MathUtils.nextPlusMinusOne() : mutatee.getWeight() + MathUtils.nextClampedDouble(-this.perturb, this.perturb);
            mutated = new NEATLinkGene(mutatee.getInnovationNumber(), mutatee.isEnabled(), mutatee.getFromId(), mutatee.getToId(), newWeight);
        }
        if (disableRandVal < this.pToggle && this.featureSelection) {
            mutated.setEnabled(!mutated.isEnabled());
        }
        return mutated;
    }

    private Gene mutateNode(NEATNodeGene mutatee) {
        double perturbRandVal = perturbRand.nextDouble();
        double mutateBias = perturbRand.nextDouble();
        NEATNodeGene mutated = mutatee;
        double newSF = mutatee.sigmoidFactor();
        double newBias = mutatee.bias();
        if (perturbRandVal < this.pPerturb) {
            newSF = mutatee.sigmoidFactor() + MathUtils.nextClampedDouble(-this.perturb, this.perturb);
            mutated = new NEATNodeGene(mutated.getInnovationNumber(), mutated.id(), newSF, mutated.getType(), mutated.bias());
        }
        if (mutateBias < this.pMutateBias) {
            mutated = new NEATNodeGene(mutated.getInnovationNumber(), mutated.id(), mutated.sigmoidFactor(), mutated.getType(), newBias += MathUtils.nextClampedDouble(-this.biasPerturb, this.biasPerturb));
        }
        return mutated;
    }

    /*
     * Unable to fully structure code
     */
    private boolean linkIllegal(NEATNodeGene from, NEATNodeGene to, ArrayList links) {
        block2: {
            illegal = false;
            idx = 0;
            if (to.getType() != 2) ** GOTO lbl10
            illegal = true;
            break block2;
lbl-1000:
            // 1 sources

            {
                linkGene = (NEATLinkGene)links.get(idx);
                if (linkGene.getFromId() == from.id() && linkGene.getToId() == to.id()) {
                    illegal = true;
                }
                ++idx;
lbl10:
                // 2 sources

                ** while (!illegal && idx < links.size())
            }
        }
        return illegal;
    }

    private void mutateAddLink(Chromosome mutatee) {
        double linkRandVal = linkRand.nextDouble();
        int i = 0;
        Gene[] genes = new Gene[mutatee.size() + 1];
        System.arraycopy(mutatee.genes(), 0, genes, 0, mutatee.genes().length);
        NEATLinkGene newLink = null;
        if (linkRandVal < this.pAddLink) {
            ArrayList nodes = this.candidateNodes(mutatee.genes());
            ArrayList links = this.candidateLinks(mutatee.genes(), false);
            while (newLink == null && i < 5) {
                int rIdx = linkRand.nextInt(nodes.size());
                NEATNodeGene from = (NEATNodeGene)nodes.get(rIdx);
                rIdx = linkRand.nextInt(nodes.size());
                NEATNodeGene to = (NEATNodeGene)nodes.get(rIdx);
                if (from.getInnovationNumber() == 2 && to.getInnovationNumber() == 5) {
                    System.out.println("a");
                }
                if (!this.linkIllegal(from, to, links)) {
                    newLink = InnovationDatabase.database().submitLinkInnovation(from.id(), to.id());
                    newLink.setWeight(MathUtils.nextPlusMinusOne());
                    genes[genes.length - 1] = newLink;
                    mutatee.updateChromosome(genes);
                }
                ++i;
            }
        }
    }

    private void mutateAddNode(Chromosome mutatee) {
        ArrayList nodeLinks;
        double nodeRandVal = nodeRand.nextDouble();
        int newChromoIdx = mutatee.genes().length;
        Gene[] newChromo = new Gene[newChromoIdx + 2];
        System.arraycopy(mutatee.genes(), 0, newChromo, 0, newChromoIdx);
        if (nodeRandVal < this.pAddNode && (nodeLinks = this.candidateLinks(mutatee.genes(), true)).size() > 0) {
            int linkIdx = nodeRand.nextInt(nodeLinks.size());
            NEATLinkGene chosen = (NEATLinkGene)nodeLinks.get(linkIdx);
            chosen.setEnabled(false);
            NEATNodeGene newNode = InnovationDatabase.database().submitNodeInnovation(chosen);
            NEATLinkGene newLower = InnovationDatabase.database().submitLinkInnovation(chosen.getFromId(), newNode.id());
            NEATLinkGene newUpper = InnovationDatabase.database().submitLinkInnovation(newNode.id(), chosen.getToId());
            newLower.setWeight(1.0);
            newUpper.setWeight(chosen.getWeight());
            newChromo[this.findChosenIndex((NEATLinkGene)chosen, (Chromosome)mutatee)] = newNode;
            newChromo[newChromoIdx++] = newLower;
            newChromo[newChromoIdx] = newUpper;
            mutatee.updateChromosome(newChromo);
        }
    }

    private void updateDepthInfo(Chromosome mutated) {
        ArrayList<Gene> nodes = new ArrayList<Gene>();
        ArrayList<Gene> links = new ArrayList<Gene>();
        Gene[] genes = mutated.genes();
        int i = 0;
        while (i < genes.length) {
            if (genes[i] instanceof NEATNodeGene) {
                nodes.add(genes[i]);
            } else if (genes[i] instanceof NEATLinkGene && ((NEATLinkGene)genes[i]).isEnabled()) {
                links.add(genes[i]);
            }
            ++i;
        }
        this.assignNeuronDepth(this.findOutputNodes(this.candidateNodes(genes)), 1, mutated);
    }

    private void assignNeuronDepth(Gene[] nodeGenes, int depth, Chromosome mutated) {
        int i = 0;
        while (i < nodeGenes.length) {
            NEATNodeGene node = (NEATNodeGene)nodeGenes[i];
            if (node.getType() == 1) {
                if (depth == 1) {
                    node.setDepth(depth);
                    this.assignNeuronDepth(this.findSourceNodes(node.id(), mutated.genes()), depth + 1, mutated);
                }
            } else if (node.getType() == 0) {
                if (node.getDepth() == 0.0) {
                    node.setDepth(depth);
                    this.assignNeuronDepth(this.findSourceNodes(node.id(), mutated.genes()), depth + 1, mutated);
                }
            } else if (node.getType() == 2) {
                node.setDepth(2.147483647E9);
            }
            ++i;
        }
    }

    private Gene[] findSourceNodes(int nodeId, Gene[] genes) {
        Gene[] sourceNodes = null;
        ArrayList links = this.candidateLinks(genes, true);
        ArrayList<NEATNodeGene> sources = new ArrayList<NEATNodeGene>();
        int i = 0;
        while (i < links.size()) {
            NEATLinkGene link = (NEATLinkGene)links.get(i);
            if (nodeId == link.getToId()) {
                sources.add(this.findNode(link.getFromId(), genes));
            }
            ++i;
        }
        sourceNodes = new NEATNodeGene[sources.size()];
        i = 0;
        while (i < sourceNodes.length) {
            sourceNodes[i] = (NEATNodeGene)sources.get(i);
            ++i;
        }
        return sourceNodes;
    }

    private Gene[] findOutputNodes(ArrayList nodes) {
        ArrayList<NEATNodeGene> outputNodes = new ArrayList<NEATNodeGene>();
        int i = 0;
        while (i < nodes.size()) {
            NEATNodeGene node = (NEATNodeGene)nodes.get(i);
            if (node.getType() == 1) {
                outputNodes.add(node);
            }
            ++i;
        }
        Gene[] nodeGenes = new NEATNodeGene[outputNodes.size()];
        i = 0;
        while (i < nodeGenes.length) {
            nodeGenes[i] = (NEATNodeGene)outputNodes.get(i);
            ++i;
        }
        return nodeGenes;
    }

    private int findChosenIndex(NEATLinkGene chosen, Chromosome mutatee) {
        int idx = -1;
        int i = 0;
        Gene[] genes = mutatee.genes();
        int mutateeSize = genes.length;
        while (i < mutateeSize && idx == -1) {
            if (genes[i] instanceof NEATLinkGene && ((NEATLinkGene)genes[i]).getFromId() == chosen.getFromId() && ((NEATLinkGene)genes[i]).getToId() == chosen.getToId()) {
                idx = i;
                continue;
            }
            ++i;
        }
        return idx;
    }

    private NEATNodeGene findNode(int id, Gene[] genes) {
        int i = 0;
        NEATNodeGene node = null;
        boolean found = false;
        while (i < genes.length && !found) {
            Gene gene = genes[i];
            if (gene instanceof NEATNodeGene && (node = (NEATNodeGene)genes[i]).id() == id) {
                found = true;
            }
            ++i;
        }
        return node;
    }

    private ArrayList candidateLinks(Gene[] genes, boolean statusImportant) {
        ArrayList<Gene> nodeLinks = new ArrayList<Gene>();
        int i = 0;
        while (i < genes.length) {
            Gene gene = genes[i];
            if (gene instanceof NEATLinkGene && (!statusImportant || statusImportant && ((NEATLinkGene)gene).isEnabled())) {
                nodeLinks.add(gene);
            }
            ++i;
        }
        return nodeLinks;
    }

    private ArrayList candidateNodes(Gene[] genes) {
        ArrayList<Gene> nodes = new ArrayList<Gene>();
        int i = 0;
        while (i < genes.length) {
            Gene gene = genes[i];
            if (gene instanceof NEATNodeGene) {
                nodes.add(gene);
            }
            ++i;
        }
        return nodes;
    }

    private Gene[] ensureLegalLinks(Gene[] genes) {
        Gene[] newGenes = null;
        ArrayList<Gene> tmpGenes = new ArrayList<Gene>();
        if (!this.recurrencyAllowed) {
            ArrayList links = this.candidateLinks(genes, false);
            int i = 0;
            while (i < genes.length) {
                if (genes[i] instanceof NEATLinkGene) {
                    NEATLinkGene link = (NEATLinkGene)genes[i];
                    NEATNodeGene from = this.findNode(link.getFromId(), genes);
                    NEATNodeGene to = this.findNode(link.getToId(), genes);
                    if (from.getDepth() > to.getDepth()) {
                        tmpGenes.add(genes[i]);
                    }
                } else {
                    tmpGenes.add(genes[i]);
                }
                ++i;
            }
            newGenes = new Gene[tmpGenes.size()];
            i = 0;
            while (i < newGenes.length) {
                newGenes[i] = (Gene)tmpGenes.get(i);
                ++i;
            }
        } else {
            newGenes = genes;
        }
        return newGenes;
    }

    public void setPAddLink(double addLink) {
        this.pAddLink = addLink;
    }

    public void setPAddNode(double addNode) {
        this.pAddNode = addNode;
    }

    public void setPToggle(double toggle) {
        this.pToggle = toggle;
    }

    public void setPPerturb(double perturb) {
        this.pPerturb = perturb;
    }

    public void setFeatureSelection(boolean featureSelection) {
        this.featureSelection = featureSelection;
    }

    public void setPMutateBias(double mutateBias) {
        this.pMutateBias = mutateBias;
    }

    public void setBiasPerturb(double biasPerturb) {
        this.biasPerturb = biasPerturb;
    }

    public void setPerturb(double perturb) {
        this.perturb = perturb;
    }
}

