/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.core.xover;

import java.util.ArrayList;
import java.util.Random;
import org.apache.log4j.Category;
import org.neat4j.neat.core.NEATChromosome;
import org.neat4j.neat.core.NEATGene;
import org.neat4j.neat.ga.core.Chromosome;
import org.neat4j.neat.ga.core.ChromosomeSet;
import org.neat4j.neat.ga.core.CrossOver;
import org.neat4j.neat.ga.core.Gene;

public class NEATCrossover
implements CrossOver {
    private static final long serialVersionUID = 1L;
    private static final Category cat;
    private static final Random rand;
    private double pXOver;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.neat4j.neat.core.xover.NEATCrossover");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cat = Category.getInstance((Class)clazz);
        rand = new Random();
    }

    public void setProbability(double prob) {
        this.pXOver = prob;
    }

    public ChromosomeSet crossOver(ChromosomeSet parents) {
        Chromosome worst;
        Chromosome best;
        ChromosomeSet childSet = new ChromosomeSet(false);
        ArrayList<NEATGene> childGenes = new ArrayList<NEATGene>();
        Chromosome pOne = null;
        Chromosome pTwo = null;
        int bestIdx = 0;
        int worstIdx = 0;
        boolean childBorn = false;
        pOne = parents.nextChromosome();
        pTwo = parents.nextChromosome();
        if (pOne.fitness() == pTwo.fitness()) {
            if (pOne.genes().length == pTwo.genes().length) {
                best = pOne;
                worst = pTwo;
            } else if (pOne.genes().length < pTwo.genes().length) {
                best = pOne;
                worst = pTwo;
            } else {
                best = pTwo;
                worst = pOne;
            }
        } else {
            best = pOne.fitness() > pTwo.fitness() ? pOne : pTwo;
            worst = pOne.fitness() > pTwo.fitness() ? pTwo : pOne;
        }
        NEATGene[] bestGenes = (NEATGene[])best.genes();
        NEATGene[] worstGenes = (NEATGene[])worst.genes();
        while (!childBorn) {
            if (worstIdx >= worstGenes.length) {
                while (bestIdx < bestGenes.length) {
                    childGenes.add(bestGenes[bestIdx++]);
                }
                childBorn = true;
                continue;
            }
            if (bestIdx >= bestGenes.length) {
                childBorn = true;
                continue;
            }
            if (bestGenes[bestIdx].getInnovationNumber() == worstGenes[worstIdx].getInnovationNumber()) {
                childGenes.add(rand.nextBoolean() ? bestGenes[bestIdx] : worstGenes[worstIdx]);
                ++bestIdx;
                ++worstIdx;
                continue;
            }
            if (bestGenes[bestIdx].getInnovationNumber() > worstGenes[worstIdx].getInnovationNumber()) {
                ++worstIdx;
                continue;
            }
            if (bestGenes[bestIdx].getInnovationNumber() >= worstGenes[worstIdx].getInnovationNumber()) continue;
            childGenes.add(bestGenes[bestIdx]);
            ++bestIdx;
        }
        childSet.add(this.createChromosome(childGenes));
        return childSet;
    }

    private NEATChromosome createChromosome(ArrayList genes) {
        NEATChromosome chromo = null;
        Gene[] geneSet = new NEATGene[genes.size()];
        int i = 0;
        while (i < geneSet.length) {
            geneSet[i] = (NEATGene)genes.get(i);
            ++i;
        }
        chromo = new NEATChromosome(geneSet);
        return chromo;
    }
}

