/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.data.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.neat4j.neat.data.core.DataLoader;
import org.neat4j.neat.data.core.NetworkDataSet;
import org.neat4j.neat.data.core.NetworkInput;
import org.neat4j.neat.data.core.NetworkOutput;
import org.neat4j.neat.data.csv.CSVDataSet;
import org.neat4j.neat.data.csv.CSVExpectedOutput;
import org.neat4j.neat.data.csv.CSVExpectedOutputSet;
import org.neat4j.neat.data.csv.CSVInput;
import org.neat4j.neat.data.csv.CSVInputSet;

public class CSVDataLoader
implements DataLoader {
    private static final Category cat;
    private String fileName;
    private int opCols;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.neat4j.neat.data.csv.CSVDataLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        cat = Category.getInstance((Class)clazz);
    }

    public CSVDataLoader(String fileName, int opCols) {
        this.fileName = fileName;
        this.opCols = opCols;
    }

    public NetworkDataSet loadData() {
        cat.info((Object)("Loading data from " + this.fileName));
        return this.createDataSets();
    }

    private NetworkDataSet createDataSets() {
        cat.debug((Object)"Creating data sets");
        CSVDataSet dataSet = new CSVDataSet();
        File csvFile = new File(this.fileName);
        ArrayList<NetworkOutput> eOps = new ArrayList<NetworkOutput>();
        ArrayList<NetworkInput> ips = new ArrayList<NetworkInput>();
        try {
            String line;
            FileInputStream fis = new FileInputStream(csvFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            while ((line = br.readLine()) != null) {
                StringTokenizer sTok = new StringTokenizer(line, ",");
                ips.add(this.createInputPattern(sTok));
                eOps.add(this.createExpectedOutput(sTok));
            }
            CSVInputSet ipSet = new CSVInputSet(ips);
            CSVExpectedOutputSet opSet = new CSVExpectedOutputSet(eOps);
            dataSet = new CSVDataSet(ipSet, opSet);
        }
        catch (FileNotFoundException e) {
            cat.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            cat.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            cat.error((Object)e.getMessage());
            e.printStackTrace();
        }
        cat.debug((Object)"Creating data sets...Done");
        return dataSet;
    }

    private NetworkInput createInputPattern(StringTokenizer sTok) {
        double[] pattern = new double[sTok.countTokens() - this.opCols];
        int i = 0;
        while (sTok.hasMoreTokens() && i < pattern.length) {
            pattern[i++] = Double.parseDouble(sTok.nextToken());
        }
        CSVInput ip = new CSVInput(pattern);
        return ip;
    }

    private NetworkOutput createExpectedOutput(StringTokenizer sTok) {
        double[] pattern = new double[sTok.countTokens()];
        int i = 0;
        while (sTok.hasMoreTokens() && i < pattern.length) {
            pattern[i++] = Double.parseDouble(sTok.nextToken());
        }
        CSVExpectedOutput op = new CSVExpectedOutput(pattern);
        return op;
    }
}

