/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.ga.core;

import java.util.ArrayList;
import org.neat4j.neat.core.NEATChromosome;
import org.neat4j.neat.core.NEATFeatureGene;
import org.neat4j.neat.core.NEATGene;
import org.neat4j.neat.core.NEATLinkGene;
import org.neat4j.neat.core.NEATNodeGene;
import org.neat4j.neat.ga.core.Chromosome;
import org.neat4j.neat.ga.core.ChromosomeSet;
import org.neat4j.neat.ga.core.CrossOver;
import org.neat4j.neat.ga.core.Gene;
import org.neat4j.neat.ga.core.Mutator;
import org.neat4j.neat.ga.core.ParentSelector;

public abstract class Specie
implements Comparable {
    private ArrayList specieMembers = new ArrayList();
    private double bestFitness;
    private double avFitness = 0.0;
    private int maxFitnessAge;
    private int currentFitnessAge = 0;
    private boolean extinct = false;
    private double threshold;
    private Chromosome specieRepresentative = null;
    private int specieId = -1;
    private double bestAvFitness = 0.0;
    private double survivalThreshold = 0.3;

    public Specie(double threshold, int id) {
        this.threshold = threshold;
        this.specieId = id;
    }

    public int id() {
        return this.specieId;
    }

    public void ageFitness() {
        double totalFitness = 0.0;
        if (this.specieMembers.size() > 0) {
            int i = 0;
            while (i < this.specieMembers.size()) {
                totalFitness += ((Chromosome)this.specieMembers.get(i)).fitness();
                ++i;
            }
            this.avFitness = totalFitness / (double)this.specieMembers.size();
            if (this.avFitness > this.bestAvFitness) {
                this.currentFitnessAge = 0;
                this.bestAvFitness = this.avFitness;
            } else if (this.specieRepresentative.fitness() > this.bestFitness) {
                this.currentFitnessAge = 0;
                this.bestFitness = this.specieRepresentative.fitness();
            } else {
                ++this.currentFitnessAge;
            }
        }
    }

    public void resetSpecie(double threshold) {
        int specieSize = this.specieMembers.size();
        if (this.currentFitnessAge >= this.maxFitnessAge || specieSize == 0) {
            this.extinct = true;
        } else {
            this.threshold = threshold;
        }
        this.clearSpecieMembers();
    }

    protected void clearSpecieMembers() {
        this.specieMembers = new ArrayList();
    }

    public Chromosome findBestMember() {
        return this.specieRepresentative;
    }

    public boolean addSpecieMember(Chromosome specieMember) {
        boolean addedOk = false;
        boolean isCompat = false;
        if (this.specieMembers.size() == 0 && this.specieRepresentative == null) {
            this.specieRepresentative = this.cloneChromosome(specieMember);
            this.specieRepresentative.updateFitness(specieMember.fitness());
            this.specieMembers.add(specieMember);
            addedOk = true;
        } else {
            isCompat = this.isCompatable(specieMember, this.specieRepresentative);
            if (isCompat) {
                if (specieMember.fitness() > this.specieRepresentative.fitness()) {
                    this.specieRepresentative = this.cloneChromosome(specieMember);
                    this.specieRepresentative.updateFitness(specieMember.fitness());
                }
                this.specieMembers.add(specieMember);
                addedOk = true;
            }
        }
        return addedOk;
    }

    protected void addMatable(Chromosome specieMember) {
        this.specieMembers.add(specieMember);
    }

    public boolean isExtinct() {
        return this.extinct;
    }

    public void setExtinct() {
        this.extinct = true;
    }

    public void reprieve() {
        this.extinct = false;
        this.currentFitnessAge = 0;
    }

    public double specieThreshold() {
        return this.threshold;
    }

    public ArrayList specieMembers() {
        return this.specieMembers;
    }

    public double averageFitness() {
        return this.avFitness;
    }

    public ChromosomeSet specieOffspring(int offspringCount, Mutator mut, ParentSelector selector, CrossOver xOver) {
        Chromosome[] offspring = this.produceOffspring(offspringCount, mut, selector, xOver);
        ChromosomeSet specieOffspring = new ChromosomeSet();
        int i = 0;
        while (i < offspring.length) {
            specieOffspring.add(offspring[i]);
            ++i;
        }
        return specieOffspring;
    }

    protected abstract void adjustFitness();

    protected abstract boolean isCompatable(Chromosome var1, Chromosome var2);

    protected abstract Chromosome[] produceOffspring(int var1, Mutator var2, ParentSelector var3, CrossOver var4);

    protected abstract double fitnessMultiplier();

    public int getCurrentFitnessAge() {
        return this.currentFitnessAge;
    }

    public double getAverageFitness() {
        return this.avFitness;
    }

    public void setMaxFitnessAge(int maxFitnessAge) {
        this.maxFitnessAge = maxFitnessAge;
    }

    public int maxFittnessAge() {
        return this.maxFitnessAge;
    }

    public Chromosome cloneChromosome(Chromosome clonee) {
        Gene[] genes = clonee.genes();
        NEATChromosome clone = new NEATChromosome(this.cloneGenes(genes));
        clone.setSpecieId(((NEATChromosome)clonee).getSpecieId());
        return clone;
    }

    public Gene[] cloneGenes(Gene[] clonee) {
        Gene[] cloned = new Gene[clonee.length];
        int i = 0;
        while (i < clonee.length) {
            if (clonee[i] instanceof NEATLinkGene) {
                cloned[i] = new NEATLinkGene(((NEATGene)clonee[i]).getInnovationNumber(), ((NEATLinkGene)clonee[i]).isEnabled(), ((NEATLinkGene)clonee[i]).getFromId(), ((NEATLinkGene)clonee[i]).getToId(), ((NEATLinkGene)clonee[i]).getWeight());
            } else if (clonee[i] instanceof NEATNodeGene) {
                cloned[i] = new NEATNodeGene(((NEATGene)clonee[i]).getInnovationNumber(), ((NEATNodeGene)clonee[i]).id(), ((NEATNodeGene)clonee[i]).sigmoidFactor(), ((NEATNodeGene)clonee[i]).getType(), ((NEATNodeGene)clonee[i]).bias());
            } else if (clonee[i] instanceof NEATFeatureGene) {
                cloned[i] = new NEATFeatureGene(((NEATGene)clonee[i]).getInnovationNumber(), ((NEATFeatureGene)clonee[i]).geneAsNumber().doubleValue());
            }
            ++i;
        }
        return cloned;
    }

    public boolean containsMember(NEATChromosome member) {
        return this.id() == member.getSpecieId();
    }

    public double getSurvivalThreshold() {
        return this.survivalThreshold;
    }

    public void setSurvivalThreshold(double survivalThreshold) {
        this.survivalThreshold = survivalThreshold;
    }
}

