/*
 * Decompiled with CFR 0.152.
 */
package org.neat4j.neat.nn.core.functions;

import org.neat4j.neat.nn.core.ActivationFunction;

public class SigmoidFunction
implements ActivationFunction {
    private double factor;

    public SigmoidFunction() {
        this(-4.9);
    }

    public SigmoidFunction(double factor) {
        this.factor = factor;
    }

    public double activate(double neuronIp) {
        return 1.0 / (1.0 + Math.exp(this.factor * neuronIp));
    }

    public double derivative(double neuronIp) {
        return neuronIp * (1.0 - neuronIp);
    }

    public void setFactor(double mod) {
        this.factor = mod;
    }
}

