/*
 * Decompiled with CFR 0.152.
 */
package penumbra;

public class PenumbraSystem {
    private static boolean is64Bit(String string) {
        if (string.equals("x86")) {
            return false;
        }
        if (string.equals("amd64")) {
            return true;
        }
        if (string.equals("x86_64")) {
            return true;
        }
        if (string.equals("ppc") || string.equals("PowerPC")) {
            return false;
        }
        if (string.equals("ppc64")) {
            return true;
        }
        if (string.equals("i386") || string.equals("i686")) {
            return false;
        }
        throw new UnsupportedOperationException("Unsupported architecture: " + string);
    }

    public static Platform getPlatform() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        boolean bl = PenumbraSystem.is64Bit(string2);
        if (string.contains("windows")) {
            return bl ? Platform.Windows64 : Platform.Windows32;
        }
        if (string.contains("linux") || string.contains("freebsd") || string.contains("sunos")) {
            return bl ? Platform.Linux64 : Platform.Linux32;
        }
        if (string.contains("mac os x")) {
            if (string2.startsWith("ppc")) {
                return bl ? Platform.MacOSX_PPC64 : Platform.MacOSX_PPC32;
            }
            return bl ? Platform.MacOSX64 : Platform.MacOSX32;
        }
        throw new UnsupportedOperationException("The specified platform: " + string + " is not supported.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Platform {
        Windows32,
        Windows64,
        Linux32,
        Linux64,
        MacOSX32,
        MacOSX64,
        MacOSX_PPC32,
        MacOSX_PPC64,
        Android;

    }
}

