/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AMapEntry;
import clojure.lang.APersistentMap;
import clojure.lang.ASeq;
import clojure.lang.Box;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Obj;
import clojure.lang.RT;
import clojure.lang.Reversible;
import clojure.lang.Sorted;
import clojure.lang.Util;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class PersistentTreeMap
extends APersistentMap
implements IObj,
Reversible,
Sorted {
    public final Comparator comp;
    public final Node tree;
    public final int _count;
    final IPersistentMap _meta;
    public static final PersistentTreeMap EMPTY = new PersistentTreeMap();

    public static IPersistentMap create(Map other) {
        IPersistentMap ret = EMPTY;
        Iterator i$ = other.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry e2 = o = i$.next();
            ret = ret.assoc(e2.getKey(), e2.getValue());
        }
        return ret;
    }

    public PersistentTreeMap() {
        this(RT.DEFAULT_COMPARATOR);
    }

    public PersistentTreeMap withMeta(IPersistentMap meta2) {
        return new PersistentTreeMap(meta2, this.comp, this.tree, this._count);
    }

    private PersistentTreeMap(Comparator comp2) {
        this(null, comp2);
    }

    public PersistentTreeMap(IPersistentMap meta2, Comparator comp2) {
        this.comp = comp2;
        this._meta = meta2;
        this.tree = null;
        this._count = 0;
    }

    PersistentTreeMap(IPersistentMap meta2, Comparator comp2, Node tree, int _count) {
        this._meta = meta2;
        this.comp = comp2;
        this.tree = tree;
        this._count = _count;
    }

    public static PersistentTreeMap create(ISeq items) {
        IPersistentMap ret = EMPTY;
        while (items != null) {
            if (items.next() == null) {
                throw new IllegalArgumentException(String.format("No value supplied for key: %s", items.first()));
            }
            ret = ret.assoc(items.first(), RT.second(items));
            items = items.next().next();
        }
        return ret;
    }

    public static PersistentTreeMap create(Comparator comp2, ISeq items) {
        IPersistentMap ret = new PersistentTreeMap(comp2);
        while (items != null) {
            if (items.next() == null) {
                throw new IllegalArgumentException(String.format("No value supplied for key: %s", items.first()));
            }
            ret = ret.assoc(items.first(), RT.second(items));
            items = items.next().next();
        }
        return ret;
    }

    public boolean containsKey(Object key2) {
        return this.entryAt(key2) != null;
    }

    public PersistentTreeMap assocEx(Object key2, Object val2) {
        Box found = new Box(null);
        Node t = this.add(this.tree, key2, val2, found);
        if (t == null) {
            throw Util.runtimeException("Key already present");
        }
        return new PersistentTreeMap(this.comp, t.blacken(), this._count + 1, this.meta());
    }

    public PersistentTreeMap assoc(Object key2, Object val2) {
        Box found = new Box(null);
        Node t = this.add(this.tree, key2, val2, found);
        if (t == null) {
            Node foundNode = (Node)found.val;
            if (foundNode.val() == val2) {
                return this;
            }
            return new PersistentTreeMap(this.comp, this.replace(this.tree, key2, val2), this._count, this.meta());
        }
        return new PersistentTreeMap(this.comp, t.blacken(), this._count + 1, this.meta());
    }

    public PersistentTreeMap without(Object key2) {
        Box found = new Box(null);
        Node t = this.remove(this.tree, key2, found);
        if (t == null) {
            if (found.val == null) {
                return this;
            }
            return new PersistentTreeMap(this.meta(), this.comp);
        }
        return new PersistentTreeMap(this.comp, t.blacken(), this._count - 1, this.meta());
    }

    public ISeq seq() {
        if (this._count > 0) {
            return Seq.create(this.tree, true, this._count);
        }
        return null;
    }

    public IPersistentCollection empty() {
        return new PersistentTreeMap(this.meta(), this.comp);
    }

    public ISeq rseq() {
        if (this._count > 0) {
            return Seq.create(this.tree, false, this._count);
        }
        return null;
    }

    public Comparator comparator() {
        return this.comp;
    }

    public Object entryKey(Object entry) {
        return ((IMapEntry)entry).key();
    }

    public ISeq seq(boolean ascending) {
        if (this._count > 0) {
            return Seq.create(this.tree, ascending, this._count);
        }
        return null;
    }

    public ISeq seqFrom(Object key2, boolean ascending) {
        if (this._count > 0) {
            ISeq stack = null;
            Node t = this.tree;
            while (t != null) {
                int c = this.doCompare(key2, t.key);
                if (c == 0) {
                    stack = RT.cons(t, stack);
                    return new Seq(stack, ascending);
                }
                if (ascending) {
                    if (c < 0) {
                        stack = RT.cons(t, stack);
                        t = t.left();
                        continue;
                    }
                    t = t.right();
                    continue;
                }
                if (c > 0) {
                    stack = RT.cons(t, stack);
                    t = t.right();
                    continue;
                }
                t = t.left();
            }
            if (stack != null) {
                return new Seq(stack, ascending);
            }
        }
        return null;
    }

    public NodeIterator iterator() {
        return new NodeIterator(this.tree, true);
    }

    public Object kvreduce(IFn f, Object init) {
        if (this.tree != null) {
            return this.tree.kvreduce(f, init);
        }
        return init;
    }

    public NodeIterator reverseIterator() {
        return new NodeIterator(this.tree, false);
    }

    public Iterator keys() {
        return this.keys(this.iterator());
    }

    public Iterator vals() {
        return this.vals(this.iterator());
    }

    public Iterator keys(NodeIterator it) {
        return new KeyIterator(it);
    }

    public Iterator vals(NodeIterator it) {
        return new ValIterator(it);
    }

    public Object minKey() {
        Node t = this.min();
        return t != null ? t.key : null;
    }

    public Node min() {
        Node t = this.tree;
        if (t != null) {
            while (t.left() != null) {
                t = t.left();
            }
        }
        return t;
    }

    public Object maxKey() {
        Node t = this.max();
        return t != null ? t.key : null;
    }

    public Node max() {
        Node t = this.tree;
        if (t != null) {
            while (t.right() != null) {
                t = t.right();
            }
        }
        return t;
    }

    public int depth() {
        return this.depth(this.tree);
    }

    int depth(Node t) {
        if (t == null) {
            return 0;
        }
        return 1 + Math.max(this.depth(t.left()), this.depth(t.right()));
    }

    public Object valAt(Object key2, Object notFound) {
        Node n = this.entryAt(key2);
        return n != null ? n.val() : notFound;
    }

    public Object valAt(Object key2) {
        return this.valAt(key2, null);
    }

    public int capacity() {
        return this._count;
    }

    public int count() {
        return this._count;
    }

    public Node entryAt(Object key2) {
        Node t = this.tree;
        while (t != null) {
            int c = this.doCompare(key2, t.key);
            if (c == 0) {
                return t;
            }
            if (c < 0) {
                t = t.left();
                continue;
            }
            t = t.right();
        }
        return t;
    }

    public int doCompare(Object k1, Object k2) {
        return this.comp.compare(k1, k2);
    }

    Node add(Node t, Object key2, Object val2, Box found) {
        Node ins;
        if (t == null) {
            if (val2 == null) {
                return new Red(key2);
            }
            return new RedVal(key2, val2);
        }
        int c = this.doCompare(key2, t.key);
        if (c == 0) {
            found.val = t;
            return null;
        }
        Node node2 = ins = c < 0 ? this.add(t.left(), key2, val2, found) : this.add(t.right(), key2, val2, found);
        if (ins == null) {
            return null;
        }
        if (c < 0) {
            return t.addLeft(ins);
        }
        return t.addRight(ins);
    }

    Node remove(Node t, Object key2, Box found) {
        Node del;
        if (t == null) {
            return null;
        }
        int c = this.doCompare(key2, t.key);
        if (c == 0) {
            found.val = t;
            return PersistentTreeMap.append(t.left(), t.right());
        }
        Node node2 = del = c < 0 ? this.remove(t.left(), key2, found) : this.remove(t.right(), key2, found);
        if (del == null && found.val == null) {
            return null;
        }
        if (c < 0) {
            if (t.left() instanceof Black) {
                return PersistentTreeMap.balanceLeftDel(t.key, t.val(), del, t.right());
            }
            return PersistentTreeMap.red(t.key, t.val(), del, t.right());
        }
        if (t.right() instanceof Black) {
            return PersistentTreeMap.balanceRightDel(t.key, t.val(), t.left(), del);
        }
        return PersistentTreeMap.red(t.key, t.val(), t.left(), del);
    }

    static Node append(Node left2, Node right2) {
        if (left2 == null) {
            return right2;
        }
        if (right2 == null) {
            return left2;
        }
        if (left2 instanceof Red) {
            if (right2 instanceof Red) {
                Node app = PersistentTreeMap.append(left2.right(), right2.left());
                if (app instanceof Red) {
                    return PersistentTreeMap.red(app.key, app.val(), PersistentTreeMap.red(left2.key, left2.val(), left2.left(), app.left()), PersistentTreeMap.red(right2.key, right2.val(), app.right(), right2.right()));
                }
                return PersistentTreeMap.red(left2.key, left2.val(), left2.left(), PersistentTreeMap.red(right2.key, right2.val(), app, right2.right()));
            }
            return PersistentTreeMap.red(left2.key, left2.val(), left2.left(), PersistentTreeMap.append(left2.right(), right2));
        }
        if (right2 instanceof Red) {
            return PersistentTreeMap.red(right2.key, right2.val(), PersistentTreeMap.append(left2, right2.left()), right2.right());
        }
        Node app = PersistentTreeMap.append(left2.right(), right2.left());
        if (app instanceof Red) {
            return PersistentTreeMap.red(app.key, app.val(), PersistentTreeMap.black(left2.key, left2.val(), left2.left(), app.left()), PersistentTreeMap.black(right2.key, right2.val(), app.right(), right2.right()));
        }
        return PersistentTreeMap.balanceLeftDel(left2.key, left2.val(), left2.left(), PersistentTreeMap.black(right2.key, right2.val(), app, right2.right()));
    }

    static Node balanceLeftDel(Object key2, Object val2, Node del, Node right2) {
        if (del instanceof Red) {
            return PersistentTreeMap.red(key2, val2, del.blacken(), right2);
        }
        if (right2 instanceof Black) {
            return PersistentTreeMap.rightBalance(key2, val2, del, right2.redden());
        }
        if (right2 instanceof Red && right2.left() instanceof Black) {
            return PersistentTreeMap.red(right2.left().key, right2.left().val(), PersistentTreeMap.black(key2, val2, del, right2.left().left()), PersistentTreeMap.rightBalance(right2.key, right2.val(), right2.left().right(), right2.right().redden()));
        }
        throw new UnsupportedOperationException("Invariant violation");
    }

    static Node balanceRightDel(Object key2, Object val2, Node left2, Node del) {
        if (del instanceof Red) {
            return PersistentTreeMap.red(key2, val2, left2, del.blacken());
        }
        if (left2 instanceof Black) {
            return PersistentTreeMap.leftBalance(key2, val2, left2.redden(), del);
        }
        if (left2 instanceof Red && left2.right() instanceof Black) {
            return PersistentTreeMap.red(left2.right().key, left2.right().val(), PersistentTreeMap.leftBalance(left2.key, left2.val(), left2.left().redden(), left2.right().left()), PersistentTreeMap.black(key2, val2, left2.right().right(), del));
        }
        throw new UnsupportedOperationException("Invariant violation");
    }

    static Node leftBalance(Object key2, Object val2, Node ins, Node right2) {
        if (ins instanceof Red && ins.left() instanceof Red) {
            return PersistentTreeMap.red(ins.key, ins.val(), ins.left().blacken(), PersistentTreeMap.black(key2, val2, ins.right(), right2));
        }
        if (ins instanceof Red && ins.right() instanceof Red) {
            return PersistentTreeMap.red(ins.right().key, ins.right().val(), PersistentTreeMap.black(ins.key, ins.val(), ins.left(), ins.right().left()), PersistentTreeMap.black(key2, val2, ins.right().right(), right2));
        }
        return PersistentTreeMap.black(key2, val2, ins, right2);
    }

    static Node rightBalance(Object key2, Object val2, Node left2, Node ins) {
        if (ins instanceof Red && ins.right() instanceof Red) {
            return PersistentTreeMap.red(ins.key, ins.val(), PersistentTreeMap.black(key2, val2, left2, ins.left()), ins.right().blacken());
        }
        if (ins instanceof Red && ins.left() instanceof Red) {
            return PersistentTreeMap.red(ins.left().key, ins.left().val(), PersistentTreeMap.black(key2, val2, left2, ins.left().left()), PersistentTreeMap.black(ins.key, ins.val(), ins.left().right(), ins.right()));
        }
        return PersistentTreeMap.black(key2, val2, left2, ins);
    }

    Node replace(Node t, Object key2, Object val2) {
        int c = this.doCompare(key2, t.key);
        return t.replace(t.key, c == 0 ? val2 : t.val(), c < 0 ? this.replace(t.left(), key2, val2) : t.left(), c > 0 ? this.replace(t.right(), key2, val2) : t.right());
    }

    PersistentTreeMap(Comparator comp2, Node tree, int count2, IPersistentMap meta2) {
        this._meta = meta2;
        this.comp = comp2;
        this.tree = tree;
        this._count = count2;
    }

    static Red red(Object key2, Object val2, Node left2, Node right2) {
        if (left2 == null && right2 == null) {
            if (val2 == null) {
                return new Red(key2);
            }
            return new RedVal(key2, val2);
        }
        if (val2 == null) {
            return new RedBranch(key2, left2, right2);
        }
        return new RedBranchVal(key2, val2, left2, right2);
    }

    static Black black(Object key2, Object val2, Node left2, Node right2) {
        if (left2 == null && right2 == null) {
            if (val2 == null) {
                return new Black(key2);
            }
            return new BlackVal(key2, val2);
        }
        if (val2 == null) {
            return new BlackBranch(key2, left2, right2);
        }
        return new BlackBranchVal(key2, val2, left2, right2);
    }

    public IPersistentMap meta() {
        return this._meta;
    }

    static class ValIterator
    implements Iterator {
        NodeIterator it;

        ValIterator(NodeIterator it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return ((Node)this.it.next()).val();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class KeyIterator
    implements Iterator {
        NodeIterator it;

        KeyIterator(NodeIterator it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return ((Node)this.it.next()).key;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class NodeIterator
    implements Iterator {
        Stack stack = new Stack();
        boolean asc;

        NodeIterator(Node t, boolean asc) {
            this.asc = asc;
            this.push(t);
        }

        void push(Node t) {
            while (t != null) {
                this.stack.push(t);
                t = this.asc ? t.left() : t.right();
            }
        }

        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        public Object next() {
            Node t = (Node)this.stack.pop();
            this.push(this.asc ? t.right() : t.left());
            return t;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Seq
    extends ASeq {
        final ISeq stack;
        final boolean asc;
        final int cnt;

        public Seq(ISeq stack, boolean asc) {
            this.stack = stack;
            this.asc = asc;
            this.cnt = -1;
        }

        public Seq(ISeq stack, boolean asc, int cnt) {
            this.stack = stack;
            this.asc = asc;
            this.cnt = cnt;
        }

        Seq(IPersistentMap meta2, ISeq stack, boolean asc, int cnt) {
            super(meta2);
            this.stack = stack;
            this.asc = asc;
            this.cnt = cnt;
        }

        static Seq create(Node t, boolean asc, int cnt) {
            return new Seq(Seq.push(t, null, asc), asc, cnt);
        }

        static ISeq push(Node t, ISeq stack, boolean asc) {
            while (t != null) {
                stack = RT.cons(t, stack);
                t = asc ? t.left() : t.right();
            }
            return stack;
        }

        public Object first() {
            return this.stack.first();
        }

        public ISeq next() {
            Node t = (Node)this.stack.first();
            ISeq nextstack = Seq.push(this.asc ? t.right() : t.left(), this.stack.next(), this.asc);
            if (nextstack != null) {
                return new Seq(nextstack, this.asc, this.cnt - 1);
            }
            return null;
        }

        public int count() {
            if (this.cnt < 0) {
                return super.count();
            }
            return this.cnt;
        }

        public Obj withMeta(IPersistentMap meta2) {
            return new Seq(meta2, this.stack, this.asc, this.cnt);
        }
    }

    static class RedBranchVal
    extends RedBranch {
        final Object val;

        public RedBranchVal(Object key2, Object val2, Node left2, Node right2) {
            super(key2, left2, right2);
            this.val = val2;
        }

        public Object val() {
            return this.val;
        }

        Node blacken() {
            return new BlackBranchVal(this.key, this.val, this.left, this.right);
        }
    }

    static class RedBranch
    extends Red {
        final Node left;
        final Node right;

        public RedBranch(Object key2, Node left2, Node right2) {
            super(key2);
            this.left = left2;
            this.right = right2;
        }

        public Node left() {
            return this.left;
        }

        public Node right() {
            return this.right;
        }

        Node balanceLeft(Node parent) {
            if (this.left instanceof Red) {
                return PersistentTreeMap.red(this.key, this.val(), this.left.blacken(), PersistentTreeMap.black(parent.key, parent.val(), this.right, parent.right()));
            }
            if (this.right instanceof Red) {
                return PersistentTreeMap.red(this.right.key, this.right.val(), PersistentTreeMap.black(this.key, this.val(), this.left, this.right.left()), PersistentTreeMap.black(parent.key, parent.val(), this.right.right(), parent.right()));
            }
            return super.balanceLeft(parent);
        }

        Node balanceRight(Node parent) {
            if (this.right instanceof Red) {
                return PersistentTreeMap.red(this.key, this.val(), PersistentTreeMap.black(parent.key, parent.val(), parent.left(), this.left), this.right.blacken());
            }
            if (this.left instanceof Red) {
                return PersistentTreeMap.red(this.left.key, this.left.val(), PersistentTreeMap.black(parent.key, parent.val(), parent.left(), this.left.left()), PersistentTreeMap.black(this.key, this.val(), this.left.right(), this.right));
            }
            return super.balanceRight(parent);
        }

        Node blacken() {
            return new BlackBranch(this.key, this.left, this.right);
        }
    }

    static class RedVal
    extends Red {
        final Object val;

        public RedVal(Object key2, Object val2) {
            super(key2);
            this.val = val2;
        }

        public Object val() {
            return this.val;
        }

        Node blacken() {
            return new BlackVal(this.key, this.val);
        }
    }

    static class Red
    extends Node {
        public Red(Object key2) {
            super(key2);
        }

        Node addLeft(Node ins) {
            return PersistentTreeMap.red(this.key, this.val(), ins, this.right());
        }

        Node addRight(Node ins) {
            return PersistentTreeMap.red(this.key, this.val(), this.left(), ins);
        }

        Node removeLeft(Node del) {
            return PersistentTreeMap.red(this.key, this.val(), del, this.right());
        }

        Node removeRight(Node del) {
            return PersistentTreeMap.red(this.key, this.val(), this.left(), del);
        }

        Node blacken() {
            return new Black(this.key);
        }

        Node redden() {
            throw new UnsupportedOperationException("Invariant violation");
        }

        Node replace(Object key2, Object val2, Node left2, Node right2) {
            return PersistentTreeMap.red(key2, val2, left2, right2);
        }
    }

    static class BlackBranchVal
    extends BlackBranch {
        final Object val;

        public BlackBranchVal(Object key2, Object val2, Node left2, Node right2) {
            super(key2, left2, right2);
            this.val = val2;
        }

        public Object val() {
            return this.val;
        }

        Node redden() {
            return new RedBranchVal(this.key, this.val, this.left, this.right);
        }
    }

    static class BlackBranch
    extends Black {
        final Node left;
        final Node right;

        public BlackBranch(Object key2, Node left2, Node right2) {
            super(key2);
            this.left = left2;
            this.right = right2;
        }

        public Node left() {
            return this.left;
        }

        public Node right() {
            return this.right;
        }

        Node redden() {
            return new RedBranch(this.key, this.left, this.right);
        }
    }

    static class BlackVal
    extends Black {
        final Object val;

        public BlackVal(Object key2, Object val2) {
            super(key2);
            this.val = val2;
        }

        public Object val() {
            return this.val;
        }

        Node redden() {
            return new RedVal(this.key, this.val);
        }
    }

    static class Black
    extends Node {
        public Black(Object key2) {
            super(key2);
        }

        Node addLeft(Node ins) {
            return ins.balanceLeft(this);
        }

        Node addRight(Node ins) {
            return ins.balanceRight(this);
        }

        Node removeLeft(Node del) {
            return PersistentTreeMap.balanceLeftDel(this.key, this.val(), del, this.right());
        }

        Node removeRight(Node del) {
            return PersistentTreeMap.balanceRightDel(this.key, this.val(), this.left(), del);
        }

        Node blacken() {
            return this;
        }

        Node redden() {
            return new Red(this.key);
        }

        Node replace(Object key2, Object val2, Node left2, Node right2) {
            return PersistentTreeMap.black(key2, val2, left2, right2);
        }
    }

    static abstract class Node
    extends AMapEntry {
        final Object key;

        Node(Object key2) {
            this.key = key2;
        }

        public Object key() {
            return this.key;
        }

        public Object val() {
            return null;
        }

        public Object getKey() {
            return this.key();
        }

        public Object getValue() {
            return this.val();
        }

        Node left() {
            return null;
        }

        Node right() {
            return null;
        }

        abstract Node addLeft(Node var1);

        abstract Node addRight(Node var1);

        abstract Node removeLeft(Node var1);

        abstract Node removeRight(Node var1);

        abstract Node blacken();

        abstract Node redden();

        Node balanceLeft(Node parent) {
            return PersistentTreeMap.black(parent.key, parent.val(), this, parent.right());
        }

        Node balanceRight(Node parent) {
            return PersistentTreeMap.black(parent.key, parent.val(), parent.left(), this);
        }

        abstract Node replace(Object var1, Object var2, Node var3, Node var4);

        public Object kvreduce(IFn f, Object init) {
            init = f.invoke(init, this.key(), this.val());
            if (this.left() != null) {
                init = this.left().kvreduce(f, init);
            }
            if (this.right() != null) {
                init = this.right().kvreduce(f, init);
            }
            return init;
        }
    }
}

