(ns kepler16.github
  (:require
   [clj-http.client :as client]
   [jsonista.core :as json]))

(def query "
query ($repo: String!, $org: String!, $version: String!) {
  repository(name: $repo, owner: $org) {
    packages(packageType: MAVEN, first: 1) {
      edges {
        node {
          version(version: $version) {
            id
          }
        }
      }
    }
  }
}")

(defn package-exists? [{:keys [repo org version token] :as package}]
  (let [req (client/post
             "https://api.github.com/graphql"
             {:headers {:Content-Type "application/json"
                        :Authorization (str "Bearer " token)}
              :body (json/write-value-as-string
                     {:query query
                      :variables package})})]
    (some-> req
            :body
            json/read-value
            (get-in ["data" "repository" "packages" "edges" 0 "node" "version"]))))
