/*
 * Decompiled with CFR 0.152.
 */
package overlock.threadpool;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.scala.Instrumented;
import com.yammer.metrics.scala.Meter;
import com.yammer.metrics.scala.MetricsGroup;
import com.yammer.metrics.scala.Timer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overlock.threadpool.InstrumentedThreadPoolExecutor$;
import scala.Function0;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001\u001d\u0011a$\u00138tiJ,X.\u001a8uK\u0012$\u0006N]3bIB{w\u000e\\#yK\u000e,Ho\u001c:\u000b\u0005\r!\u0011A\u0003;ie\u0016\fG\r]8pY*\tQ!\u0001\u0005pm\u0016\u0014Hn\\2l\u0007\u0001\u0019B\u0001\u0001\u0005\u0013=A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u000bG>t7-\u001e:sK:$(BA\u0007\u000f\u0003\u0011)H/\u001b7\u000b\u0003=\tAA[1wC&\u0011\u0011C\u0003\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'\u000f\u0005\u0002\u001495\tAC\u0003\u0002\u0016-\u0005)1oY1mC*\u0011q\u0003G\u0001\b[\u0016$(/[2t\u0015\tI\"$\u0001\u0004zC6lWM\u001d\u0006\u00027\u0005\u00191m\\7\n\u0005u!\"\u0001D%ogR\u0014X/\\3oi\u0016$\u0007CA\u0010\"\u001b\u0005\u0001#\"A\u000b\n\u0005\t\u0002#aC*dC2\fwJ\u00196fGRD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0005a\u0006$\b\u000e\u0005\u0002'S9\u0011qdJ\u0005\u0003Q\u0001\na\u0001\u0015:fI\u00164\u0017B\u0001\u0016,\u0005\u0019\u0019FO]5oO*\u0011\u0001\u0006\t\u0005\t[\u0001\u0011\t\u0011)A\u0005K\u0005!a.Y7f\u0011!y\u0003A!A!\u0002\u0013\u0001\u0014\u0001D2pe\u0016\u0004vn\u001c7TSj,\u0007CA\u00102\u0013\t\u0011\u0004EA\u0002J]RD\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\u0010[\u0006D\u0018.\\;n!>|GnU5{K\"Aa\u0007\u0001B\u0001B\u0003%q'A\u0007lK\u0016\u0004\u0018\t\\5wKRKW.\u001a\t\u0003?aJ!!\u000f\u0011\u0003\t1{gn\u001a\u0005\tw\u0001\u0011\t\u0011)A\u0005y\u0005!QO\\5u!\tIQ(\u0003\u0002?\u0015\tAA+[7f+:LG\u000f\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0003%9xN]6Rk\u0016,X\rE\u0002\n\u0005\u0012K!a\u0011\u0006\u0003\u001b\tcwnY6j]\u001e\fV/Z;f!\t)\u0005*D\u0001G\u0015\t9e\"\u0001\u0003mC:<\u0017BA%G\u0005!\u0011VO\u001c8bE2,\u0007\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\u0002\u000f\u0019\f7\r^8ssB\u0011\u0011\"T\u0005\u0003\u001d*\u0011Q\u0002\u00165sK\u0006$g)Y2u_JL\b\"\u0002)\u0001\t\u0003\t\u0016A\u0002\u001fj]&$h\bF\u0005S)V3v\u000bW-[7B\u00111\u000bA\u0007\u0002\u0005!)Ae\u0014a\u0001K!)Qf\u0014a\u0001K!)qf\u0014a\u0001a!)Ag\u0014a\u0001a!)ag\u0014a\u0001o!)1h\u0014a\u0001y!)\u0001i\u0014a\u0001\u0003\")1j\u0014a\u0001\u0019\"AQ\f\u0001EC\u0002\u0013Ea,A\u0002m_\u001e,\u0012a\u0018\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\fQa\u001d7gi)T\u0011\u0001Z\u0001\u0004_J<\u0017B\u00014b\u0005\u0019aunZ4fe\"A\u0001\u000e\u0001E\u0001B\u0003&q,\u0001\u0003m_\u001e\u0004\u0003b\u00026\u0001\u0005\u0004%\ta[\u0001\fe\u0016\fX/Z:u%\u0006$X-F\u0001m!\t\u0019R.\u0003\u0002o)\t)Q*\u001a;fe\"1\u0001\u000f\u0001Q\u0001\n1\fAB]3rk\u0016\u001cHOU1uK\u0002BqA\u001d\u0001C\u0002\u0013\u00051.\u0001\u0007sK*,7\r^3e%\u0006$X\r\u0003\u0004u\u0001\u0001\u0006I\u0001\\\u0001\u000ee\u0016TWm\u0019;fIJ\u000bG/\u001a\u0011\t\u000fY\u0004!\u0019!C\u0001o\u0006qQ\r_3dkRLwN\u001c+j[\u0016\u0014X#\u0001=\u0011\u0005MI\u0018B\u0001>\u0015\u0005\u0015!\u0016.\\3s\u0011\u0019a\b\u0001)A\u0005q\u0006yQ\r_3dkRLwN\u001c+j[\u0016\u0014\b\u0005C\u0004\u007f\u0001\t\u0007I\u0011A@\u0002\u0015E,X-^3HCV<W-\u0006\u0002\u0002\u0002A)\u00111AA\u0005a5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f1\u0012\u0001B2pe\u0016LA!a\u0003\u0002\u0006\t)q)Y;hK\"A\u0011q\u0002\u0001!\u0002\u0013\t\t!A\u0006rk\u0016,XmR1vO\u0016\u0004\u0003\u0002CA\n\u0001\t\u0007I\u0011A@\u0002\u0017QD'/Z1e\u000f\u0006,x-\u001a\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\u0002\u0005aA\u000f\u001b:fC\u0012<\u0015-^4fA!A\u00111\u0004\u0001C\u0002\u0013\u0005q0A\tbGRLg/\u001a+ie\u0016\fGmR1vO\u0016D\u0001\"a\b\u0001A\u0003%\u0011\u0011A\u0001\u0013C\u000e$\u0018N^3UQJ,\u0017\rZ$bk\u001e,\u0007\u0005C\u0005\u0002$\u0001\u0011\r\u0011\"\u0001\u0002&\u0005I1\u000f^1siRKW.Z\u000b\u0003\u0003O\u0001B!RA\u0015o%\u0019\u00111\u0006$\u0003\u0017QC'/Z1e\u0019>\u001c\u0017\r\u001c\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002(\u0005Q1\u000f^1siRKW.\u001a\u0011\t\u000f\u0005M\u0002\u0001\"\u0011\u00026\u00059Q\r_3dkR,G\u0003BA\u001c\u0003{\u00012aHA\u001d\u0013\r\tY\u0004\t\u0002\u0005+:LG\u000fC\u0004\u0002@\u0005E\u0002\u0019\u0001#\u0002\u0003IDq!a\u0011\u0001\t#\n)%A\u0007cK\u001a|'/Z#yK\u000e,H/\u001a\u000b\u0007\u0003o\t9%!\u0015\t\u0011\u0005%\u0013\u0011\ta\u0001\u0003\u0017\n\u0011\u0001\u001e\t\u0004\u000b\u00065\u0013bAA(\r\n1A\u000b\u001b:fC\u0012Dq!a\u0010\u0002B\u0001\u0007A\tC\u0004\u0002V\u0001!\t&a\u0016\u0002\u0019\u00054G/\u001a:Fq\u0016\u001cW\u000f^3\u0015\r\u0005]\u0012\u0011LA.\u0011\u001d\ty$a\u0015A\u0002\u0011C\u0001\"!\u0013\u0002T\u0001\u0007\u0011Q\f\t\u0005\u0003?\nyG\u0004\u0003\u0002b\u0005-d\u0002BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001dd!\u0001\u0004=e>|GOP\u0005\u0002+%\u0019\u0011Q\u000e\u0011\u0002\u000fA\f7m[1hK&!\u0011\u0011OA:\u0005%!\u0006N]8xC\ndWMC\u0002\u0002n\u0001\u0002")
public class InstrumentedThreadPoolExecutor
extends ThreadPoolExecutor
implements Instrumented,
ScalaObject {
    public final BlockingQueue<Runnable> overlock$threadpool$InstrumentedThreadPoolExecutor$$workQueue;
    private Logger log;
    private final Meter requestRate;
    private final Meter rejectedRate;
    private final Timer executionTimer;
    private final Gauge<Object> queueGauge;
    private final Gauge<Object> threadGauge;
    private final Gauge<Object> activeThreadGauge;
    private final ThreadLocal<Object> startTime;
    private final MetricsGroup com$yammer$metrics$scala$Instrumented$$metricsGroup;
    public volatile int bitmap$0;
    private volatile int bitmap$priv$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger log() {
        if ((this.bitmap$0 & 1) != 0) return this.log;
        InstrumentedThreadPoolExecutor instrumentedThreadPoolExecutor = this;
        synchronized (instrumentedThreadPoolExecutor) {
            if ((this.bitmap$0 & 1) == 0) {
                this.log = LoggerFactory.getLogger(this.getClass());
                this.bitmap$0 |= 1;
            }
            return this.log;
        }
    }

    public Meter requestRate() {
        return this.requestRate;
    }

    public Meter rejectedRate() {
        return this.rejectedRate;
    }

    public Timer executionTimer() {
        return this.executionTimer;
    }

    public Gauge<Object> queueGauge() {
        return this.queueGauge;
    }

    public Gauge<Object> threadGauge() {
        return this.threadGauge;
    }

    public Gauge<Object> activeThreadGauge() {
        return this.activeThreadGauge;
    }

    public ThreadLocal<Object> startTime() {
        return this.startTime;
    }

    @Override
    public void execute(Runnable r) {
        this.requestRate().mark();
        super.execute(r);
    }

    @Override
    public void beforeExecute(Thread t, Runnable r) {
        this.startTime().set(BoxesRunTime.boxToLong((long)System.nanoTime()));
    }

    @Override
    public void afterExecute(Runnable r, Throwable t) {
        long duration = System.nanoTime() - BoxesRunTime.unboxToLong((Object)this.startTime().get());
        this.executionTimer().update(duration, TimeUnit.NANOSECONDS);
    }

    public InstrumentedThreadPoolExecutor(String path, String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory factory) {
        this.overlock$threadpool$InstrumentedThreadPoolExecutor$$workQueue = workQueue;
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, factory);
        Instrumented.class.$init$((Instrumented)this);
        MetricsGroup qual$1 = this.metrics();
        String x$1 = "request";
        String x$2 = "requests";
        String x$3 = new StringBuilder().append((Object)path).append((Object)".").append((Object)name).toString();
        TimeUnit x$4 = TimeUnit.SECONDS;
        MetricsRegistry x$5 = qual$1.meter$default$5();
        this.requestRate = qual$1.meter("request", "requests", x$3, TimeUnit.SECONDS, x$5);
        MetricsGroup qual$2 = this.metrics();
        String x$6 = "rejected";
        String x$7 = "requests";
        String x$8 = new StringBuilder().append((Object)path).append((Object)".").append((Object)name).toString();
        TimeUnit x$9 = TimeUnit.SECONDS;
        MetricsRegistry x$10 = qual$2.meter$default$5();
        this.rejectedRate = qual$2.meter("rejected", "requests", x$8, TimeUnit.SECONDS, x$10);
        MetricsGroup qual$3 = this.metrics();
        String x$11 = "execution";
        String x$12 = new StringBuilder().append((Object)path).append((Object)".").append((Object)name).toString();
        TimeUnit x$13 = qual$3.timer$default$3();
        TimeUnit x$14 = qual$3.timer$default$4();
        MetricsRegistry x$15 = qual$3.timer$default$5();
        this.executionTimer = qual$3.timer("execution", x$12, x$13, x$14, x$15);
        MetricsGroup qual$4 = this.metrics();
        String x$16 = "queue size";
        String x$17 = new StringBuilder().append((Object)path).append((Object)".").append((Object)name).toString();
        MetricsRegistry x$18 = qual$4.gauge$default$3();
        $anonfun$1 x$19$1 = new $anonfun$1(this);
        this.queueGauge = qual$4.gauge("queue size", x$17, x$18, (Function0)new $anonfun$2(this, (Function0)x$19$1));
        MetricsGroup qual$5 = this.metrics();
        String x$20 = "threads";
        String x$21 = new StringBuilder().append((Object)path).append((Object)".").append((Object)name).toString();
        MetricsRegistry x$22 = qual$5.gauge$default$3();
        $anonfun$3 x$23$1 = new $anonfun$3(this);
        this.threadGauge = qual$5.gauge("threads", x$21, x$22, (Function0)new $anonfun$4(this, (Function0)x$23$1));
        MetricsGroup qual$6 = this.metrics();
        String x$24 = "active threads";
        String x$25 = new StringBuilder().append((Object)path).append((Object)".").append((Object)name).toString();
        MetricsRegistry x$26 = qual$6.gauge$default$3();
        $anonfun$5 x$27$1 = new $anonfun$5(this);
        this.activeThreadGauge = qual$6.gauge("active threads", x$25, x$26, (Function0)new $anonfun$6(this, (Function0)x$27$1));
        this.startTime = new ThreadLocal();
        this.setRejectedExecutionHandler(new RejectedExecutionHandler(this){
            private final InstrumentedThreadPoolExecutor $outer;

            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                this.$outer.rejectedRate().mark();
                if (!this.$outer.overlock$threadpool$InstrumentedThreadPoolExecutor$$workQueue.offer(r)) {
                    this.$outer.log().warn("Work queue is not accepting work.");
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

