/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.office;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeUtils;
import org.artofsolving.jodconverter.office.RetryTimeoutException;
import org.artofsolving.jodconverter.office.Retryable;
import org.artofsolving.jodconverter.office.TemporaryException;
import org.artofsolving.jodconverter.office.UnknownOficeProcessAlreadyExistingException;
import org.artofsolving.jodconverter.office.UnoUrl;
import org.artofsolving.jodconverter.process.ProcessManager;
import org.artofsolving.jodconverter.process.ProcessQuery;
import org.artofsolving.jodconverter.util.PlatformUtils;
import org.artofsolving.jodconverter.util.ProcessLoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OfficeProcess {
    private final File officeHome;
    private final UnoUrl unoUrl;
    private final String[] runAsArgs;
    private final File templateProfileDir;
    private final File instanceProfileDir;
    private final ProcessManager processManager;
    private Process process;
    private long pid = -1L;
    private final Logger logger = LoggerFactory.getLogger(OfficeProcess.class);
    private final Logger loggerProcessOutput = LoggerFactory.getLogger((String)(this.logger.getName() + ".ProcessOutput"));

    public OfficeProcess(File officeHome, UnoUrl unoUrl, String[] runAsArgs, File templateProfileDir, File workDir, ProcessManager processManager) {
        this.officeHome = officeHome;
        this.unoUrl = unoUrl;
        this.runAsArgs = runAsArgs;
        this.templateProfileDir = templateProfileDir;
        this.instanceProfileDir = this.getInstanceProfileDir(workDir, unoUrl);
        this.processManager = processManager;
    }

    public void start() throws IOException {
        this.start(false);
    }

    public void start(boolean restart) throws IOException {
        File officeExecutable = OfficeUtils.getOfficeExecutable(this.officeHome);
        ProcessQuery processQuery = new ProcessQuery(officeExecutable.getName(), this.unoUrl.getAcceptString());
        long existingPid = this.processManager.findPid(processQuery);
        if (existingPid != -2L && existingPid != -1L) {
            throw new UnknownOficeProcessAlreadyExistingException(this.unoUrl.getAcceptString(), existingPid);
        }
        if (!restart) {
            this.prepareInstanceProfileDir();
        }
        ArrayList<String> command = new ArrayList<String>();
        File executable = officeExecutable;
        if (this.runAsArgs != null) {
            command.addAll(Arrays.asList(this.runAsArgs));
        }
        command.add(executable.getAbsolutePath());
        command.add("-accept=" + this.unoUrl.getAcceptString() + ";urp;");
        command.add("-env:UserInstallation=" + OfficeUtils.toUrl(this.instanceProfileDir));
        command.add("-headless");
        command.add("-nocrashreport");
        command.add("-nodefault");
        command.add("-nofirststartwizard");
        command.add("-nolockcheck");
        command.add("-nologo");
        command.add("-norestore");
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        if (PlatformUtils.isWindows()) {
            this.addBasisAndUrePaths(processBuilder);
        }
        this.logger.info(String.format("starting process with acceptString '{}' and profileDir '{}'", this.unoUrl, this.instanceProfileDir));
        this.process = processBuilder.start();
        this.pid = this.processManager.findPid(processQuery);
        ProcessLoggingUtils.logProcessOutput(this.process, this.pid, this.loggerProcessOutput);
        if (this.pid == -2L) {
            throw new IllegalStateException("process with acceptString '" + this.unoUrl.getAcceptString() + "' started but its pid could not be found");
        }
        this.logger.info("started process" + (this.pid != -1L ? "; pid = " + this.pid : ""));
    }

    private File getInstanceProfileDir(File workDir, UnoUrl unoUrl) {
        String dirName = ".jodconverter_" + unoUrl.getAcceptString().replace(',', '_').replace('=', '-');
        return new File(workDir, dirName);
    }

    private void prepareInstanceProfileDir() throws OfficeException {
        if (this.instanceProfileDir.exists()) {
            this.logger.warn("profile dir '{}' already exists; deleting", (Object)this.instanceProfileDir);
            this.deleteProfileDir();
        }
        if (this.templateProfileDir != null) {
            try {
                FileUtils.copyDirectory((File)this.templateProfileDir, (File)this.instanceProfileDir);
            }
            catch (IOException ioException) {
                throw new OfficeException("failed to create profileDir", ioException);
            }
        }
    }

    public void deleteProfileDir() {
        if (this.instanceProfileDir != null) {
            try {
                FileUtils.deleteDirectory((File)this.instanceProfileDir);
            }
            catch (IOException ioException) {
                File oldProfileDir = new File(this.instanceProfileDir.getParentFile(), this.instanceProfileDir.getName() + ".old." + System.currentTimeMillis());
                if (this.instanceProfileDir.renameTo(oldProfileDir)) {
                    this.logger.warn("could not delete profileDir: " + ioException.getMessage() + "; renamed it to " + oldProfileDir);
                }
                this.logger.warn("could not delete profileDir: " + ioException.getMessage());
            }
        }
    }

    private void addBasisAndUrePaths(ProcessBuilder processBuilder) throws IOException {
        File basisLink = new File(this.officeHome, "basis-link");
        if (!basisLink.isFile()) {
            this.logger.debug("no %OFFICE_HOME%/basis-link found; assuming it's OOo 2.x and we don't need to append URE and Basic paths");
            return;
        }
        String basisLinkText = FileUtils.readFileToString((File)basisLink).trim();
        File basisHome = new File(this.officeHome, basisLinkText);
        File basisProgram = new File(basisHome, "program");
        File ureLink = new File(basisHome, "ure-link");
        String ureLinkText = FileUtils.readFileToString((File)ureLink).trim();
        File ureHome = new File(basisHome, ureLinkText);
        File ureBin = new File(ureHome, "bin");
        Map<String, String> environment = processBuilder.environment();
        String pathKey = "PATH";
        for (String key : environment.keySet()) {
            if (!"PATH".equalsIgnoreCase(key)) continue;
            pathKey = key;
        }
        String path = environment.get(pathKey) + ";" + ureBin.getAbsolutePath() + ";" + basisProgram.getAbsolutePath();
        this.logger.debug(String.format("setting %s to \"%s\"", pathKey, path));
        environment.put(pathKey, path);
    }

    public boolean isRunning() {
        if (this.process == null) {
            return false;
        }
        try {
            long foundPid = this.processManager.findPid(new ProcessQuery(OfficeUtils.getOfficeExecutable(this.officeHome).getName(), this.unoUrl.getAcceptString()));
            if (foundPid == -2L) {
                return false;
            }
        }
        catch (IOException e) {
            this.logger.warn("Could not even request pid to find");
        }
        return this.getExitCode() == null;
    }

    public Integer getExitCode() {
        try {
            return this.process.exitValue();
        }
        catch (IllegalThreadStateException exception) {
            return null;
        }
    }

    public int getExitCode(long retryInterval, long retryTimeout) throws RetryTimeoutException {
        try {
            ExitCodeRetryable retryable = new ExitCodeRetryable();
            retryable.execute(retryInterval, retryTimeout);
            return retryable.getExitCode();
        }
        catch (RetryTimeoutException retryTimeoutException) {
            throw retryTimeoutException;
        }
        catch (Exception exception) {
            throw new OfficeException("could not get process exit code", exception);
        }
    }

    public int forciblyTerminate(long retryInterval, long retryTimeout) throws IOException, RetryTimeoutException {
        this.logger.info("trying to forcibly terminate process: '" + this.unoUrl + "'" + (this.pid != -1L ? " (pid " + this.pid + ")" : ""));
        if (this.pid == -1L) {
            long foundPid = this.processManager.findPid(new ProcessQuery(OfficeUtils.getOfficeExecutable(this.officeHome).getName(), this.unoUrl.getAcceptString()));
            this.processManager.kill(this.process, foundPid);
        } else {
            this.processManager.kill(this.process, this.pid);
        }
        return this.getExitCode(retryInterval, retryTimeout);
    }

    private class ExitCodeRetryable
    extends Retryable {
        private int exitCode;

        private ExitCodeRetryable() {
        }

        @Override
        protected void attempt() throws TemporaryException, Exception {
            try {
                this.exitCode = OfficeProcess.this.process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                throw new TemporaryException(illegalThreadStateException);
            }
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

