/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.process;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.artofsolving.jodconverter.process.ProcessManager;
import org.artofsolving.jodconverter.process.ProcessQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxProcessManager
implements ProcessManager {
    private static final Pattern PS_OUTPUT_LINE = Pattern.compile("^\\s*(\\d+)\\s+(.*)$");
    private String[] runAsArgs;
    private final Logger logger = LoggerFactory.getLogger(LinuxProcessManager.class);

    public void setRunAsArgs(String ... runAsArgs) {
        this.runAsArgs = runAsArgs;
    }

    protected String[] psCommand() {
        return new String[]{"/bin/ps", "-e", "-o", "pid,args"};
    }

    @Override
    public long findPid(ProcessQuery query) throws IOException {
        this.logger.debug("trying to find process by query [ {} ]", (Object)query);
        String regex = Pattern.quote(query.getCommand()) + ".*" + Pattern.quote(query.getArgument());
        Pattern commandPattern = Pattern.compile(regex);
        for (String line : this.execute(this.psCommand())) {
            String command;
            Matcher commandMatcher;
            Matcher lineMatcher = PS_OUTPUT_LINE.matcher(line);
            if (!lineMatcher.matches() || !(commandMatcher = commandPattern.matcher(command = lineMatcher.group(2))).find()) continue;
            long pid = Long.parseLong(lineMatcher.group(1));
            this.logger.debug("found process for query [ {} ] with pid [ {} ]", (Object)query, (Object)pid);
            return pid;
        }
        this.logger.warn("no process found for query [ {} ]", (Object)query);
        return -2L;
    }

    @Override
    public void kill(Process process, long pid) throws IOException {
        if (process != null) {
            process.destroy();
        }
        if (pid <= 0L) {
            throw new IllegalArgumentException("invalid pid: " + pid);
        }
        this.execute("/bin/kill", "-KILL", Long.toString(pid));
    }

    private List<String> execute(String ... args) throws IOException {
        String[] command;
        if (this.runAsArgs != null) {
            command = new String[this.runAsArgs.length + args.length];
            System.arraycopy(this.runAsArgs, 0, command, 0, this.runAsArgs.length);
            System.arraycopy(args, 0, command, this.runAsArgs.length, args.length);
        } else {
            command = args;
        }
        Process process = new ProcessBuilder(command).start();
        List lines = IOUtils.readLines((InputStream)process.getInputStream());
        return lines;
    }
}

