/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;

public class ProcessLoggingUtils {
    public static void logProcessOutput(Process process, final long pid, final Logger logger) {
        ThreadGroup threadGroup = new ThreadGroup(String.format("loggingthreads for process [ %s ]", pid)){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.warn("exception on loggingthread for process [ " + pid + " ]", e);
                super.uncaughtException(t, e);
            }
        };
        threadGroup.setDaemon(true);
        Thread stdOutLoggerThread = ProcessLoggingUtils.createLoggingThread(threadGroup, pid, process.getInputStream(), "stdout", logger);
        Thread stdErrLoggerThread = ProcessLoggingUtils.createLoggingThread(threadGroup, pid, process.getErrorStream(), "stderr", logger);
        ProcessLoggingUtils.start(stdOutLoggerThread);
        ProcessLoggingUtils.start(stdErrLoggerThread);
    }

    private static void start(Thread t) {
        if (t != null) {
            t.start();
        }
    }

    private static Thread createLoggingThread(ThreadGroup threadGroup, long pid, InputStream stream, String name, Logger logger) {
        if (stream == null) {
            return null;
        }
        Runnable r = ProcessLoggingUtils.createLoggingRunnable(pid, name, stream, logger);
        Thread t = new Thread(threadGroup, r, String.format("loggingthread for %s of process [ %s ]", name, pid));
        t.setDaemon(true);
        return t;
    }

    private static Runnable createLoggingRunnable(long pid, String name, InputStream stream, Logger logger) {
        if (stream == null) {
            return null;
        }
        String prefix = String.format("%s[%s]: ", name, pid);
        return new LoggingRunnable(stream, logger, prefix);
    }

    private static final class LoggingRunnable
    implements Runnable {
        private final BufferedReader reader;
        private final String prefix;
        private final Logger logger;

        private LoggingRunnable(InputStream stream, Logger logger, String prefix) {
            this.reader = new BufferedReader(new InputStreamReader(stream));
            this.logger = logger;
            this.prefix = prefix;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    this.logger.debug(this.prefix + line);
                }
            }
            catch (IOException e) {
                this.logger.error(this.prefix + "error reading line", (Throwable)e);
            }
        }
    }
}

