/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.ErrorCode;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.Language;
import com.cybozu.labs.langdetect.util.NGram;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Random;
import java.util.regex.Pattern;

public class Detector {
    private static final double ALPHA_DEFAULT = 0.5;
    private static final double ALPHA_WIDTH = 0.05;
    private static final int ITERATION_LIMIT = 1000;
    private static final double PROB_THRESHOLD = 0.1;
    private static final double CONV_THRESHOLD = 0.99999;
    private static final int BASE_FREQ = 10000;
    private static final String UNKNOWN_LANG = "unknown";
    private static final Pattern URL_REGEX = Pattern.compile("https?://[-_.?&~;+=/#0-9A-Za-z]{1,2076}");
    private static final Pattern MAIL_REGEX = Pattern.compile("[-_.0-9A-Za-z]{1,64}@[-_0-9A-Za-z]{1,255}[-_.0-9A-Za-z]{1,255}");
    private final HashMap<String, double[]> wordLangProbMap;
    private final ArrayList<String> langlist;
    private StringBuffer text;
    private double[] langprob = null;
    private double alpha = 0.5;
    private int n_trial = 7;
    private int max_text_length = 10000;
    private double[] priorMap = null;
    private boolean verbose = false;
    private Long seed = null;

    public Detector(DetectorFactory detectorFactory) {
        this.wordLangProbMap = detectorFactory.wordLangProbMap;
        this.langlist = detectorFactory.langlist;
        this.text = new StringBuffer();
        this.seed = detectorFactory.seed;
    }

    public void setVerbose() {
        this.verbose = true;
    }

    public void setAlpha(double d) {
        this.alpha = d;
    }

    public void setTrials(int n) {
        this.n_trial = n;
    }

    public void setPriorMap(HashMap<String, Double> hashMap) throws LangDetectException {
        int n;
        this.priorMap = new double[this.langlist.size()];
        double d = 0.0;
        for (n = 0; n < this.priorMap.length; ++n) {
            String string = this.langlist.get(n);
            if (!hashMap.containsKey(string)) continue;
            double d2 = hashMap.get(string);
            if (d2 < 0.0) {
                throw new LangDetectException(ErrorCode.InitParamError, "Prior probability must be non-negative.");
            }
            this.priorMap[n] = d2;
            d += d2;
        }
        if (d <= 0.0) {
            throw new LangDetectException(ErrorCode.InitParamError, "More one of prior probability must be non-zero.");
        }
        n = 0;
        while (n < this.priorMap.length) {
            int n2 = n++;
            this.priorMap[n2] = this.priorMap[n2] / d;
        }
    }

    public void setMaxTextLength(int n) {
        this.max_text_length = n;
    }

    public void append(Reader reader) throws IOException {
        char[] cArray = new char[this.max_text_length / 2];
        while (this.text.length() < this.max_text_length && reader.ready()) {
            int n = reader.read(cArray);
            this.append(new String(cArray, 0, n));
        }
    }

    public void append(String string) {
        string = URL_REGEX.matcher(string).replaceAll(" ");
        string = MAIL_REGEX.matcher(string).replaceAll(" ");
        string = NGram.normalize_vi(string);
        int n = 0;
        for (int i = 0; i < string.length() && i < this.max_text_length; ++i) {
            char c = string.charAt(i);
            if (c != ' ' || n != 32) {
                this.text.append(c);
            }
            n = c;
        }
    }

    private void cleaningText() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.text.length(); ++i) {
            n = this.text.charAt(i);
            if (n <= 122 && n >= 65) {
                ++n2;
                continue;
            }
            if (n < 768 || Character.UnicodeBlock.of((char)n) == Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL) continue;
            ++n3;
        }
        if (n2 * 2 < n3) {
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < this.text.length(); ++n) {
                char c = this.text.charAt(n);
                if (c <= 'z' && c >= 'A') continue;
                stringBuffer.append(c);
            }
            this.text = stringBuffer;
        }
    }

    public String detect() throws LangDetectException {
        ArrayList<Language> arrayList = this.getProbabilities();
        if (arrayList.size() > 0) {
            return arrayList.get((int)0).lang;
        }
        return UNKNOWN_LANG;
    }

    public ArrayList<Language> getProbabilities() throws LangDetectException {
        if (this.langprob == null) {
            this.detectBlock();
        }
        ArrayList<Language> arrayList = this.sortProbability(this.langprob);
        return arrayList;
    }

    private void detectBlock() throws LangDetectException {
        this.cleaningText();
        ArrayList<String> arrayList = this.extractNGrams();
        if (arrayList.size() == 0) {
            throw new LangDetectException(ErrorCode.CantDetectError, "no features in text");
        }
        this.langprob = new double[this.langlist.size()];
        Random random = new Random();
        if (this.seed != null) {
            random.setSeed(this.seed);
        }
        for (int i = 0; i < this.n_trial; ++i) {
            double[] dArray = this.initProbability();
            double d = this.alpha + random.nextGaussian() * 0.05;
            int n = 0;
            while (true) {
                int n2 = random.nextInt(arrayList.size());
                this.updateLangProb(dArray, arrayList.get(n2), d);
                if (n % 5 == 0) {
                    if (Detector.normalizeProb(dArray) > 0.99999 || n >= 1000) break;
                    if (this.verbose) {
                        System.out.println("> " + this.sortProbability(dArray));
                    }
                }
                ++n;
            }
            for (n = 0; n < this.langprob.length; ++n) {
                int n3 = n;
                this.langprob[n3] = this.langprob[n3] + dArray[n] / (double)this.n_trial;
            }
            if (!this.verbose) continue;
            System.out.println("==> " + this.sortProbability(dArray));
        }
    }

    private double[] initProbability() {
        double[] dArray = new double[this.langlist.size()];
        if (this.priorMap != null) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.priorMap[i];
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = 1.0 / (double)this.langlist.size();
            }
        }
        return dArray;
    }

    private ArrayList<String> extractNGrams() {
        ArrayList<String> arrayList = new ArrayList<String>();
        NGram nGram = new NGram();
        for (int i = 0; i < this.text.length(); ++i) {
            nGram.addChar(this.text.charAt(i));
            for (int j = 1; j <= 3; ++j) {
                String string = nGram.get(j);
                if (string == null || !this.wordLangProbMap.containsKey(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private boolean updateLangProb(double[] dArray, String string, double d) {
        if (string == null || !this.wordLangProbMap.containsKey(string)) {
            return false;
        }
        double[] dArray2 = this.wordLangProbMap.get(string);
        if (this.verbose) {
            System.out.println(string + "(" + Detector.unicodeEncode(string) + "):" + this.wordProbToString(dArray2));
        }
        double d2 = d / 10000.0;
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] * (d2 + dArray2[i]);
        }
        return true;
    }

    private String wordProbToString(double[] dArray) {
        Formatter formatter = new Formatter();
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            if (!(d >= 1.0E-5)) continue;
            formatter.format(" %s:%.5f", this.langlist.get(i), d);
        }
        String string = formatter.toString();
        formatter.close();
        return string;
    }

    private static double normalizeProb(double[] dArray) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d2 += dArray[n];
        }
        for (n = 0; n < dArray.length; ++n) {
            double d3 = dArray[n] / d2;
            if (d < d3) {
                d = d3;
            }
            dArray[n] = d3;
        }
        return d;
    }

    private ArrayList<Language> sortProbability(double[] dArray) {
        ArrayList<Language> arrayList = new ArrayList<Language>();
        block0: for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            if (!(d > 0.1)) continue;
            for (int j = 0; j <= arrayList.size(); ++j) {
                if (j != arrayList.size() && !(arrayList.get((int)j).prob < d)) continue;
                arrayList.add(j, new Language(this.langlist.get(i), d));
                continue block0;
            }
        }
        return arrayList;
    }

    private static String unicodeEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\u0080') {
                String string2 = Integer.toHexString(65536 + c);
                while (string2.length() < 4) {
                    string2 = "0" + string2;
                }
                stringBuffer.append("\\u").append(string2.subSequence(1, 5));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

