(ns kixi.user
  (:require [spec-tools.spec :as spec]
            [kixi.spec :refer [api-spec]]
            [kixi.spec.conformers :as sc]))

(s/def ::id (api-spec sc/uuid? "string"))
(s/def ::name spec/string?)
(s/def ::created sc/timestamp?)
(s/def ::groups (s/coll-of sc/uuid))
(s/def ::self-group (api-spec sc/uuid? "string"))

(s/def :kixi/user
  (s/keys :req [::id
                ::groups]
          :opt [::self-group]))
