(ns kixi.stats.t-digest)

(defn t-digest [delta]
  (fn
    ([] {:delta 0.01
         :centroids []
         :n 0})
    ([acc x]
     (-> (update acc :centroids conj {:mean x :count 1})
         (update :n inc)))
    ([acc] acc)))

(defn add-to-centroid
  ([centroid x]
   (add-to-centroid centroid x 1))
  ([{:keys [mean count]} x weight]
   (let [count' (+ count weight)]
     {:mean (+ mean (/ (- x mean) count'))
      :count count'})))

(defn centroid-q [this rest]
  (let [sum (apply + (map :count rest))]
    (/ (+ (/ (:count this) 2)
          sum)
       sum)))

(defn )
