(defproject kixus/reduce                            "0.1.3"
    :description                                    "Generalized multi-dimensional reduce functions in Clojure."
    :url                                            "https://github.com/kixus/reduce-clj"
    :scm                    {   :url                "https://github.com/kixus/reduce-clj"
                                :name               "git" 
                            }
    :license                {   :url                "http://opensource.org/licenses/BSD-3-Clause"
                                :name               "BSD 3-Clause License"
                            }
    :dependencies           [                       [org.clojure/clojure    "1.6.0"]
                            ]
    :profiles               {   :dev                [   ;; :dependencies   [
                                                        ;;                 ]
                                                        ;; :plugins        [
                                                        ;;                 ]
                                                    ]

                            }
    :repositories           {   ;; "sonatype"          "https://oss.sonatype.org/content/repositories/releases/"
                            }
    :deploy-repositories    [   ["clojars"          {:creds :gpg}]
                            ]
    :signing                {   :gpg-key            "56BA7F7E"   ;; check with "gpg --fingerprint 56BA7F7E"
                            }
    :pom-addition           [   :developers         [:developer [:id            "kixus"]
                                                                [:name          "Rajesh Krishnan"]
                                                                [:url           "https://github.com/kixus"]
                                                                [:email         "raj.dev.github@pub.dom.st"]
                                                                [:timezone      "America/Los_Angeles"]
                                                                [:properties    [:clojars "https://clojars.org/groups/kixus"]
                                                                ]
                                                    ]
                            ]
    :target-path            "out/tgt"
    :source-paths           ["app/src"]
    :resource-paths         ["app/res" "tst/res"]
    :test-paths             ["tst/src"]
    :jvm-opts               ["-Xmx4g"]
)
