;
; Copyright (c) 2017. qlaro, Inc.
;
; Proprietary and Confidential
;
; Unauthorized copying of this project or any files within this project, via any
; medium, is strictly prohibited
;

(ns h2e.system
  (:require [clojure.java.io :as io]
            [com.stuartsierra.component :as component]
            [datomic.api :as d]
            [io.rkn.conformity :as c]
            [taoensso.timbre :as timbre
             :refer [log trace debug info warn error fatal report
                     logf tracef debugf infof warnf errorf fatalf reportf
                     spy get-env]]

            [h2e.db.datomic :as datomic]
            [h2e.db.semantic-db :as semantic-db])
  (:import [java.io File PushbackReader]))

(defn get-system
  [system-type]
  (let [datomic-db-name (case system-type
                          :dev "h2e-dev"
                          :test (str "h2e-test-" (rand-int 99999)))]
    (component/system-map
      :datomic (datomic/new-component "192.168.64.3" 9042 datomic-db-name)
      :semantic-db (component/using
                     (semantic-db/new-component)
                     [:datomic]))))

(def dev-system (get-system :dev))
(def test-system (get-system :test))