(ns mold-http.test
  (:require #?(:cljs [mold-http.utils])
            [re-frame.core :as re-frame]))


(defn make-events-redefs [bindings]
  (for [{:keys [event stub stage cb-params]} bindings]
    (if (= stage :request)
      `(re-frame/reg-event-fx
         ~event
         [re-frame/trim-v]
         (fn [cofx# [& args#]]
           (~stub cofx# args#)
           nil))

      `(re-frame/reg-event-fx
         ~event
         (fn []
           {:dispatch [(mold-http.utils/concat-two-keywords ~event ~stage) "" ~cb-params ~stub]})))))


(defmacro with-fake-http [bindings & body]
  (let [events-redefs (make-events-redefs bindings)]
    `(do
       ~@events-redefs
       ~@body)))
