(ns mold-http.utils)


(defn reduce-kvs
  "Like `reduce-kv` but takes a flat sequence of kv pairs."
  [rf init kvs]
  (transduce (partition-all 2)
             (completing (fn [acc [k v]]
                           (rf acc k v)))
             init
             kvs))


(defn assoc-some
  "Assocs each kv if its value is not nil."
  ([m k v]
   (if (nil? v)
     (if (nil? m) {} m)
     (assoc m k v)))

  ([m k v & kvs]
   (reduce-kvs
     (fn [m k v]
       (if (nil? v) m (assoc m k v)))
     (assoc-some m k v)
     kvs))

  ([m kvs]
   (reduce-kv
     (fn [m k v]
       (if (nil? v) m (assoc m k v)))
     (if (nil? m) {} m)
     kvs)))


(defn concat-two-keywords
  "Create keyword from two keywords"
  ([first second]
   (concat-two-keywords first second "-"))

  ([first second delim]
   (let [name1 (name first)
         ns1   (namespace first)
         name2 (name second)]
     (keyword ns1 (str name1 delim name2)))))


(defn in-seq?
  "true if a sequence contains element"
  [seq elem]
  (some #(= elem %) seq))
