(ns omg-deutsch.core
  (:use clj-http.client
        clojure.data.json)
  (:gen-class))

(def ^:dynamic *google-key* nil)

(defn translate
  [source target query]
  (let [translation
        (:translatedText
         (first
          (:translations
           (:data
            (read-json
             (:body (get
                     "https://www.googleapis.com/language/translate/v2"
                     {:query-params {"q" query
                                     "target" target
                                     "source" source
                                     "key" *google-key*}})))))))]
    translation))

(defn -main [& args]
  (let [google-key (clojure.core/get (System/getenv) "GOOGLE_KEY")]
    (binding [*google-key* google-key]
      (println (apply translate args)))))
