(ns api.uauth
  (:require [web.authenticate :as wauth])
  (:gen-class))


(defn api []
  :api)

(defn create [[token shared-mem] data]
  (let [email (:email data)
        password (:password data "")
        confirm-password (:confirm data)
        cgtoken (:cgtoken data "")
        existing? (wauth/exists? email)]
    (if existing?
      {:error "Email is already assigned to another account."}
      (if (or 
            (= password "")
            (not (= password confirm-password)))
        {:error "Password doesnt match your confirmation."}
        (wauth/user! email password cgtoken)))))

(defn login
  [[token shared-mem] data]
  (let [email (:email data)
        password (:password data)]
    (wauth/load-by-pass email password)))

