(ns connector.bitcoin
  (:require [clj-http.client :as http]
            [clojure.data.json :as json]
            [clojure.string :as str])
  (:gen-class))


(defn json-reader [filename]
  (let [conf (json/read-str (slurp filename) 
                            :key-fn keyword)]
    conf))

(defn conf-reader []
  (let [conf (atom {})]
    (fn [file & args]
      (if (and (not (contains? @conf file))
               (not (nil? (first args))))
        (get (swap! conf assoc file (json-reader file))
             file)
        (get @conf file)))))

(def read-config (conf-reader))

(defn connection []
  (let [conf (read-config (str (System/getProperty "user.dir")
                                   "/configuration/bitcoin.json")
                              :reload)]
    conf))

(defn rpc
  ([method]
   (rpc method nil)) 
  ([method params]
   (rpc (connection) method params))
  ([connection method params]
  (let [body (json/write-str {:method method
                              :params params
                              :id "jsonrpc"})
        _ (println "doing POST to " (:host connection) body)
        response (try (http/post (:host connection) 
                     {:basic-auth (:auth connection)
                      :body body
                      :content-type :json
                      :accept :json})
                   (catch Exception e (println e)))]
    (when-not (nil? response)
      (json/read-str (:body response)
                   :key-fn keyword)))))



