(ns web.api
  (:require [clojure.data.json :as json]
            [clojure.edn :as edn]
            [clojure.tools.logging :as log])
  (:gen-class))


(defn- error-return [& args]
  {:error "no"})

(defn- action [ns-name action-name]
  (require (symbol ns-name))
  (binding [*ns* (symbol ns-name)]
    (ns-resolve *ns* (symbol action-name))))

(defn extract-data 
  [request]
  (try
    (edn/read-string (:body-as-string request))
    (catch Exception e (log/info e "error on end-read"))))


(defn resolver [shared-memory token-id ns-name action-name api-path]
  (let [action-fn (action (str api-path ns-name)
                          action-name)]
    (fn [request]
      (let [
            data (extract-data request)
            
            response (action-fn [token-id shared-memory] 
                                data)]
        {:status 200
         :headers {"Content-Type" "application/edn"}
         :body (pr-str response)}))))

