(ns {{ns-name}}.handler
  (:require [compojure.core :refer [GET POST defroutes]]
            [compojure.route :refer [not-found resources]]
            [hiccup.page :refer [include-js include-css html5]]
            [{{ns-name}}.middleware :refer [wrap-middleware]]
            [web.api :refer [resolver]]
            [clojure.data.json :as json]
            [config.core :refer [env]])
  (:gen-class))


(def shared-memory (atom {:session {}}))

(def api-path "api.")

(def mount-target
  [:div#app
      [:h3 "My Web Project"]
      [:p "loading..."]])

(defn head []
  [:head
   [:meta {:charset "utf-8"}]
   [:meta {:name "viewport"
           :content "width=device-width, initial-scale=1"}]
   (include-css (if (env :dev) "/css/materialize.css" "/css/materialize.css"))
   (include-css (if (env :dev) "/css/site.css" "/css/site.min.css"))])

(defn loading-page [& uri]
  (let [body (html5
    (head)
    [:body {:class "body-container"}
     mount-target
     (include-js "/js/library/jquery.min.js")
     (include-js "/js/library/materialize.js")
     (include-js "/js/app.js")])]
    (fn [r]
      body)))

(defroutes routes
  (GET "/" [] (loading-page))
  (GET "/:uri" [uri] (loading-page uri))
  (POST "/:token-id/:namespace/:action" 
        [token-id  namespace action] 
        (resolver shared-memory token-id namespace action api-path))
  (resources "/")
  (not-found "Not Found"))



(def app (wrap-middleware #'routes))

