(ns connector.oanda
    (:require [clj-http.client :as http]
            [clojure.data.json :as json]
            [clojure.string :as str])
  (:gen-class))


(defn json-reader [filename]
  (let [conf (json/read-str (slurp filename) 
                            :key-fn keyword)]
    conf))

(defn conf-reader []
  (let [conf (atom {})]
    (fn [file & args]
      (if (and (not (contains? @conf file))
               (not (nil? (first args))))
        (get (swap! conf assoc file (json-reader file))
             file)
        (get @conf file)))))

(def read-config (conf-reader))

(defn connection []
  (let [conf (read-config (str (System/getProperty "user.dir")
                                   "/configuration/oanda.json")
                              :reload)]
    conf))

(defn api
  [method uri params])