(ns {{ns-name}}.server
  (:require [{{ns-name}}.handler :refer [app]]
            [config.core :refer [env]]
            [ring.adapter.jetty :refer [run-jetty]])
  (:gen-class))

(defonce the-server (atom nil))

(defn stop-server
  []
  (when-not (nil? @the-server)
    (println (format "Stopping server...."))
    (.close @the-server)))

(defn restart-server
  [port]
  (stop-server)
  (println (format "starting server at port %s" port))
  (reset! the-server (run-jetty app {:port port :join? false}))
  (println (format "server started at http://localhost:%s/" port)))

 (defn -main [& args]
   (let [port (Integer/parseInt (or (env :port) "3000"))]
     (restart-server port)))
