(ns framework.api
  (:require 
    [ajax.core :as ajax]
    [ajax.edn :as ajax-edn]
    [framework.storage :as store]))

(def api-start-url "/")
(defn error-handler [& error]
  (.log js/console "Error on AJAX request" error))
;;(let [status (first response)]
      ;;(if status
;;        
        ;;(error-handler response)))
;;

(defn response-wrapper [handler]
  (fn [response]
    (handler (second response))))

(defn call 
  ([n a data response-handler]
   (call (store/get :token "0") n a data response-handler))
  ([token n a data response-handler]
  (let [api-url (str api-start-url token "/" n "/" a)]
    (ajax/ajax-request {:uri api-url
                        :method :post
                        :params data
                        :handler (response-wrapper response-handler)
                        :response-format (ajax-edn/edn-response-format)
                        :format (ajax-edn/edn-request-format)}))))