(ns framework.data.holder
  (:require [reagent.core :as r]))


(def session (r/atom nil))


(defn create-index [index-name]
  (let [values (r/atom nil)]
    (fn [& {:keys [bucket value]
            :or {value nil}}]
      (if-not (nil? bucket)
        (if-not (nil? value)
          (do
            (swap! values update-in [(keyword bucket)]
                   (fn [old & args]
                     value))
            value)
          (get @values (keyword bucket)))
        (if (nil? value)
          values)))))

