(ns framework.data.network
  (:require [framework.api :as api]))


(defn object-creator [& {:keys [index type]}]
  (fn [data after]
    (api/call "object" "create" {:index index
                                 :type type
                                 :data data}
              after)))
(defn object-updator [& {:keys [index type]}]
  (fn [id data after]
    (api/call "object" "update" {:index index
                                 :type type
                                 :id id
                                 :data data}
              after)))

(defn object-loader [& {:keys [index type
                               loader]
                        :or {loader (fn [old-val new-val]
                                      new-val)}}]
  (fn [id holder]
    (api/call "object" "get-id" {:index (name index)
                                 :type (name type)
                                 :data {:id id}}
              #(swap! holder loader %))))


(defn object-searcher 
  ":next-fn takes a fn that goes with swap! [old-value new-value]
:next-fn by default is concat
:act accepted values are [:search :random :next :count]
:count doesn't accept a :next after.
If you need the number of objects in the search, do a count first!"
  [& {:keys [index type next-fn]
      :or {next-fn concat}}]
  (let [search-id (atom nil)]
    (fn [& {:keys [act filter query size holder do-fn sort]
            :or {act :search
                 sort nil
                 filter nil
                 query nil
                 holder nil
                 size 1000
                 do-fn nil}}]
      (case act
        :search (api/call "object" "search" {:index (name index)
                                             :type (name type)
                                             :query query
                                             :sort sort
                                             :filter filter
                                             :size size}
                          (fn [response]
                            (if (nil? do-fn)
                              (do (reset! search-id (:_scroll_id response))
                                (reset! holder (-> response :hits :hits)))
                              (do-fn response))))
        :next (if-not (and (nil? @search-id)
                           (= 0 @search-id))
                (api/call "object" "search" {:id @search-id}
                          (fn [response]
                            (if (nil? do-fn)
                              (do
                                (swap! search-id (fn [old-val new-val]
                                                   new-val) (:_scroll_id response))
                                (swap! holder next-fn (-> response :hits :hits)))
                              (do-fn response))))
                (if (nil? @search-id)
                  (.warn js/console "Initiate a search first!")
                  false))
        :random (api/call "object" "get-random" {:index (name index)
                                                 :type (name type)
                                                 :query query
                                                 :filter filter
                                                 :size size}
                          (fn [response]
                            (if (nil? do-fn)
                              (do (reset! search-id (:_scroll_id response))
                                (reset! holder (-> response :hits :hits)))
                              (do-fn response))))
        :count (api/call "object" "search" {:index (name index)
                                            :type (name type)
                                            :query query
                                            :filter filter
                                            :size 1}
                         (fn [response]
                           (if (nil? do-fn)
                             (do (reset! search-id nil)
                               (reset! holder (-> response :hits :total)))
                             (do-fn response))))
        (.warn js/console ":act accepts [:search :next :random :count]")))))


(defn load-in [index type in-atom]
  )

(defn session [in-atom do-after]
  (api/call "session" "get" {}
            (fn [response]
              (reset! in-atom response)
              (do-after response))))




(comment
  "needed"
  "create-obj, load-obj, load-objs, save-obj, delete-obj")

