(ns  {{ns-name}}.components.login
  (:require [cljsjs.material-ui]
             [reagent.session :as session]
             [cljs-react-material-ui.core :refer [get-mui-theme color]]
             [cljs-react-material-ui.reagent :as ui]
             [cljs-react-material-ui.icons :as ic]
             [reagent.core :as r]
             [framework.api :as api]
             [ {{ns-name}}.components.common :as common]
             [framework.easy :as easy]
             [framework.storage :as store]))


(defn do-login
  []
  (let [data {:email (session/get :credentials-email)
              :password (session/get :credentials-password)}]
    (if (or (= "" (:email data))
            (= "" (:password data)))
      (js/alert "Enter your credentials or create an account")
      (api/call "uauth" "login" data
                (fn [r]
                  (if-not (nil? r)
                    (do 
                      
                      (store/put! :token (:token (:_source r)))
	                  (store/put! :email (:email (:_source r)))
                   (js/alert (store/get :token))
                   	  (session/put! :token (store/get :token))
	                  (session/put! :user-email (store/get :email))
                   )
                    (js/alert "Login failed")))))))
(defn create-login
  []
  (let [data {:email (session/get :credentials-email)
              :password (session/get :credentials-password)
              :confirm (session/get :credentials-confirm-password)
              :cgtoken (session/get :credentials-cgtoken)}]
    (if (or (= "" (:email data))
            (= "" (:password data)))
      (js/alert "Email & Password must not be empty")
      (if-not (= (:password data) (:confirm data))
        (js/alert "Password and Confirmation password do not match.")
        (if (= "" (:cgtoken data))
          (js/alert "You must add a Crypto-Games API token")
          (api/call "uauth" "create" data
                    (fn [r]
                      (if (contains? r :error)
                        (js/alert (:error r))
                        (js/alert "Account created")))))))))

(defn switch-create
  []
  (session/put! :login-box-display (not (session/get :login-box-display true))))

(defn create-form
  []
  [ui/paper
   [ui/text-field {:hint-text "your@user.email"
                      :floating-label-text "Your email address"
                      :underline-show false
                      :full-width true
                      :on-change #(session/put! :credentials-email (easy/get-field-value %))}]
  [ui/text-field {:hint-text "password"
                  :floating-label-text "Your password"
                  :underline-show false
                  :full-width true
                  :type "password"
                  :on-change #(session/put! :credentials-password (easy/get-field-value %))}]
  [ui/text-field {:hint-text "password"
                  :floating-label-text "Confirm password"
                  :underline-show false
                  :full-width true
                  :type "password"
                  :on-change #(session/put! :credentials-confirm-password (easy/get-field-value %))}]
  [ui/text-field {:hint-text "CG Token"
                  :floating-label-text "CG Token"
                  :underline-show false
                  :full-width true
                  :on-change #(session/put! :credentials-cgtoken (easy/get-field-value %))}]
  [ui/flat-button {:primary true
                   :label "Create"
                   :on-touch-tap #(create-login)}]
  [ui/flat-button {:secondary true
                   :label "Already have an account"
                   :on-touch-tap #(switch-create)}]])

(defn login-form
  []
  [ui/paper
   [ui/text-field {:hint-text "your@user.email"
                      :floating-label-text "Your email address"
                      :underline-show false
                      :full-width true
                      :on-change #(session/put! :credentials-email (easy/get-field-value %))}]
  [ui/text-field {:hint-text "password"
                  :floating-label-text "Your password"
                  :underline-show false
                  :full-width true
                  :type "password"
                  :on-change #(session/put! :credentials-password (easy/get-field-value %))}]
  [ui/flat-button {:primary true
                   :label "Login"
                   :on-touch-tap #(do-login)}]
  [ui/flat-button {:secondary true
                   :label "Create Account"
                   :on-touch-tap #(switch-create)}]])

(defn page
  []
  [ui/mui-theme-provider
     {:mui-theme (get-mui-theme
                   {:palette {:text-color (color :black)
                              ;:canvas-color (color :grey50)
                              :primary1-color (color :red900)
                              :accent1-color (color :blue500)
                              :accent2-color (color :blue500)
                              :primary2-color (color :blue500)}})}
     
     [:div
      [ui/paper
       [:p (session/get :token 
                             (store/get :token nil))]]
      (if (session/get :login-box-display true)
        [login-form]
        [create-form])]])