(ns {{ns-name}}.core
  (:require [cljsjs.material-ui]
            [reagent.session :as session]
            [secretary.core :as secretary :include-macros true]
            [accountant.core :as accountant]
            [cljs-react-material-ui.core :refer [get-mui-theme color]]
            [cljs-react-material-ui.reagent :as ui]
            [cljs-react-material-ui.icons :as ic]
            [reagent.core :as r]
            [framework.api :as api]
            [framework.storage :as store]
            [{{ns-name}}.components.common :as common]
            [{{ns-name}}.components.login :as lgnpage]))

;; -------------------------
;; Views

(defn home-page
  []
  (if-not (nil? (session/get :token 
                             (store/get :token nil)))
    [ui/mui-theme-provider
     {:mui-theme (get-mui-theme
                   {:palette {:text-color (color :black)
                              ;:canvas-color (color :grey50)
                              :primary1-color (color :red900)
                              :accent1-color (color :blue500)
                              :accent2-color (color :blue500)
                              :primary2-color (color :blue500)}})}
     
     [:div
      [common/app-header]
      [common/sidebar-drawer]
      (case (session/get :display-current-page :home-page)
        :home-page [ui/paper
                    [:p "Hello "]]
        [:p "Intro Default2"])
      ]]
    [lgnpage/page]))

(defn current-page []
  [:div [(session/get :current-page)]])

;; -------------------------
;; Routes

(secretary/defroute "/" []
                    (session/put! :current-page #'home-page))



;; -------------------------
;; Initialize app

(defn mount-root []
  (r/render [current-page] (.getElementById js/document "app")))

(defn init! []
  (accountant/configure-navigation!
    {:nav-handler
     (fn [path]
       (secretary/dispatch! path))
     :path-exists?
     (fn [path]
       (secretary/locate-route path))})
  (accountant/dispatch-current!)
  (mount-root))
