kosmos-sentry: clojure sentry client library with kosmos configuration
====================================

A Clojure library to send events to a sentry host that is configured with kosmos

### Usage

```clojure
[kosmos/kosmos-sentry "0.0.5"]
```

Configuration:

In most of our apps, kosmos defines the `dsn` and `environment` values:

```clojure
...

:sentry
{
 :dsn "http://secret:key@sentry.healthfinch.com/id"
 :environment "development"

 ;; ----
 ;; used to determine in_app seleection in sentry message for stackframes
 ;; see doc string in code for in_app?
 ;;
 :inclusions ["kosmos.db" "application.server" "http-clj.client"]
 :exclusions ["kosmos" "application" "http-clj"]
 }

```

The main function is a multi-arity fn named `capture!`:

- `(capture! level args)`

- `(capture! level args exception)`

#### Arguments

**level**: alert level for sentry to trigger on  

**args**: a map of things to include in the message sent  
  -- tags are static and defined in the sentry server (see the Tags option under settings for the app being configured)  
  -- extra are dynamic user defined values  
  -- fingerprint is vector of strings used to rollup messages (when stackframes are not present) (not sure this is working in our version??)

**exception**: a java exception or ex-info  
  -- the data map associated with ex-info exceptions are sent via the extra key in the resulting message  

### License

Kosmos is distributed under the [Eclipse Public License](http://opensource.org/licenses/eclipse-1.0.php), the same as Clojure.

