// Compiled by ClojureScript 1.7.122 {}
goog.provide('clojure.network.ip');
goog.require('cljs.core');
goog.require('goog.net.IpAddress');

/**
 * @interface
 */
clojure.network.ip.IPConstructor = function(){};

clojure.network.ip.make_ip_address = (function clojure$network$ip$make_ip_address(this$){
if((!((this$ == null))) && (!((this$.clojure$network$ip$IPConstructor$make_ip_address$arity$1 == null)))){
return this$.clojure$network$ip$IPConstructor$make_ip_address$arity$1(this$);
} else {
var x__5243__auto__ = (((this$ == null))?null:this$);
var m__5244__auto__ = (clojure.network.ip.make_ip_address[goog.typeOf(x__5243__auto__)]);
if(!((m__5244__auto__ == null))){
return m__5244__auto__.call(null,this$);
} else {
var m__5244__auto____$1 = (clojure.network.ip.make_ip_address["_"]);
if(!((m__5244__auto____$1 == null))){
return m__5244__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IPConstructor.make-ip-address",this$);
}
}
}
});


/**
 * @interface
 */
clojure.network.ip.IPInfo = function(){};

clojure.network.ip.ip_address = (function clojure$network$ip$ip_address(this$){
if((!((this$ == null))) && (!((this$.clojure$network$ip$IPInfo$ip_address$arity$1 == null)))){
return this$.clojure$network$ip$IPInfo$ip_address$arity$1(this$);
} else {
var x__5243__auto__ = (((this$ == null))?null:this$);
var m__5244__auto__ = (clojure.network.ip.ip_address[goog.typeOf(x__5243__auto__)]);
if(!((m__5244__auto__ == null))){
return m__5244__auto__.call(null,this$);
} else {
var m__5244__auto____$1 = (clojure.network.ip.ip_address["_"]);
if(!((m__5244__auto____$1 == null))){
return m__5244__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IPInfo.ip-address",this$);
}
}
}
});

clojure.network.ip.version = (function clojure$network$ip$version(this$){
if((!((this$ == null))) && (!((this$.clojure$network$ip$IPInfo$version$arity$1 == null)))){
return this$.clojure$network$ip$IPInfo$version$arity$1(this$);
} else {
var x__5243__auto__ = (((this$ == null))?null:this$);
var m__5244__auto__ = (clojure.network.ip.version[goog.typeOf(x__5243__auto__)]);
if(!((m__5244__auto__ == null))){
return m__5244__auto__.call(null,this$);
} else {
var m__5244__auto____$1 = (clojure.network.ip.version["_"]);
if(!((m__5244__auto____$1 == null))){
return m__5244__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IPInfo.version",this$);
}
}
}
});

clojure.network.ip.numeric_value = (function clojure$network$ip$numeric_value(this$){
if((!((this$ == null))) && (!((this$.clojure$network$ip$IPInfo$numeric_value$arity$1 == null)))){
return this$.clojure$network$ip$IPInfo$numeric_value$arity$1(this$);
} else {
var x__5243__auto__ = (((this$ == null))?null:this$);
var m__5244__auto__ = (clojure.network.ip.numeric_value[goog.typeOf(x__5243__auto__)]);
if(!((m__5244__auto__ == null))){
return m__5244__auto__.call(null,this$);
} else {
var m__5244__auto____$1 = (clojure.network.ip.numeric_value["_"]);
if(!((m__5244__auto____$1 == null))){
return m__5244__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IPInfo.numeric-value",this$);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {clojure.network.ip.IPInfo}
 * @implements {clojure.network.ip.IPConstructor}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {clojure.network.ip.Object}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
clojure.network.ip.IPAddress = (function (value,__meta,__extmap,__hash){
this.value = value;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
clojure.network.ip.IPAddress.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return null;
});

clojure.network.ip.IPAddress.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5202__auto__,k__5203__auto__){
var self__ = this;
var this__5202__auto____$1 = this;
return cljs.core._lookup.call(null,this__5202__auto____$1,k__5203__auto__,null);
});

clojure.network.ip.IPAddress.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5204__auto__,k7978,else__5205__auto__){
var self__ = this;
var this__5204__auto____$1 = this;
var G__7980 = (((k7978 instanceof cljs.core.Keyword))?k7978.fqn:null);
switch (G__7980) {
case "value":
return self__.value;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k7978,else__5205__auto__);

}
});

clojure.network.ip.IPAddress.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5216__auto__,writer__5217__auto__,opts__5218__auto__){
var self__ = this;
var this__5216__auto____$1 = this;
var pr_pair__5219__auto__ = ((function (this__5216__auto____$1){
return (function (keyval__5220__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5217__auto__,cljs.core.pr_writer,""," ","",opts__5218__auto__,keyval__5220__auto__);
});})(this__5216__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__5217__auto__,pr_pair__5219__auto__,"#clojure.network.ip.IPAddress{",", ","}",opts__5218__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"value","value",305978217),self__.value],null))], null),self__.__extmap));
});

clojure.network.ip.IPAddress.prototype.cljs$core$IIterable$ = true;

clojure.network.ip.IPAddress.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__7977){
var self__ = this;
var G__7977__$1 = this;
return (new cljs.core.RecordIter((0),G__7977__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"value","value",305978217)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

clojure.network.ip.IPAddress.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5200__auto__){
var self__ = this;
var this__5200__auto____$1 = this;
return self__.__meta;
});

clojure.network.ip.IPAddress.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5196__auto__){
var self__ = this;
var this__5196__auto____$1 = this;
return (new clojure.network.ip.IPAddress(self__.value,self__.__meta,self__.__extmap,self__.__hash));
});

clojure.network.ip.IPAddress.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5206__auto__){
var self__ = this;
var this__5206__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

clojure.network.ip.IPAddress.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5197__auto__){
var self__ = this;
var this__5197__auto____$1 = this;
var h__5023__auto__ = self__.__hash;
if(!((h__5023__auto__ == null))){
return h__5023__auto__;
} else {
var h__5023__auto____$1 = cljs.core.hash_imap.call(null,this__5197__auto____$1);
self__.__hash = h__5023__auto____$1;

return h__5023__auto____$1;
}
});

clojure.network.ip.IPAddress.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__5198__auto__,other__5199__auto__){
var self__ = this;
var this__5198__auto____$1 = this;
if(cljs.core.truth_((function (){var and__4576__auto__ = other__5199__auto__;
if(cljs.core.truth_(and__4576__auto__)){
var and__4576__auto____$1 = (this__5198__auto____$1.constructor === other__5199__auto__.constructor);
if(and__4576__auto____$1){
return cljs.core.equiv_map.call(null,this__5198__auto____$1,other__5199__auto__);
} else {
return and__4576__auto____$1;
}
} else {
return and__4576__auto__;
}
})())){
return true;
} else {
return false;
}
});

clojure.network.ip.IPAddress.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5211__auto__,k__5212__auto__){
var self__ = this;
var this__5211__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),null], null), null),k__5212__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5211__auto____$1),self__.__meta),k__5212__auto__);
} else {
return (new clojure.network.ip.IPAddress(self__.value,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5212__auto__)),null));
}
});

clojure.network.ip.IPAddress.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5209__auto__,k__5210__auto__,G__7977){
var self__ = this;
var this__5209__auto____$1 = this;
var pred__7981 = cljs.core.keyword_identical_QMARK_;
var expr__7982 = k__5210__auto__;
if(cljs.core.truth_(pred__7981.call(null,new cljs.core.Keyword(null,"value","value",305978217),expr__7982))){
return (new clojure.network.ip.IPAddress(G__7977,self__.__meta,self__.__extmap,null));
} else {
return (new clojure.network.ip.IPAddress(self__.value,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5210__auto__,G__7977),null));
}
});

clojure.network.ip.IPAddress.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5214__auto__){
var self__ = this;
var this__5214__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"value","value",305978217),self__.value],null))], null),self__.__extmap));
});

clojure.network.ip.IPAddress.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5201__auto__,G__7977){
var self__ = this;
var this__5201__auto____$1 = this;
return (new clojure.network.ip.IPAddress(self__.value,G__7977,self__.__extmap,self__.__hash));
});

clojure.network.ip.IPAddress.prototype.clojure$network$ip$IPConstructor$ = true;

clojure.network.ip.IPAddress.prototype.clojure$network$ip$IPConstructor$make_ip_address$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

clojure.network.ip.IPAddress.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5207__auto__,entry__5208__auto__){
var self__ = this;
var this__5207__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5208__auto__)){
return cljs.core._assoc.call(null,this__5207__auto____$1,cljs.core._nth.call(null,entry__5208__auto__,(0)),cljs.core._nth.call(null,entry__5208__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5207__auto____$1,entry__5208__auto__);
}
});

clojure.network.ip.IPAddress.prototype.clojure$network$ip$IPInfo$ = true;

clojure.network.ip.IPAddress.prototype.clojure$network$ip$IPInfo$ip_address$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return [cljs.core.str(this$__$1)].join('');
});

clojure.network.ip.IPAddress.prototype.clojure$network$ip$IPInfo$version$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return null;
});

clojure.network.ip.IPAddress.prototype.clojure$network$ip$IPInfo$numeric_value$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return null;
});

clojure.network.ip.IPAddress.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null)], null);
});

clojure.network.ip.IPAddress.cljs$lang$type = true;

clojure.network.ip.IPAddress.cljs$lang$ctorPrSeq = (function (this__5236__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"clojure.network.ip/IPAddress");
});

clojure.network.ip.IPAddress.cljs$lang$ctorPrWriter = (function (this__5236__auto__,writer__5237__auto__){
return cljs.core._write.call(null,writer__5237__auto__,"clojure.network.ip/IPAddress");
});

clojure.network.ip.__GT_IPAddress = (function clojure$network$ip$__GT_IPAddress(value){
return (new clojure.network.ip.IPAddress(value,null,null,null));
});

clojure.network.ip.map__GT_IPAddress = (function clojure$network$ip$map__GT_IPAddress(G__7979){
return (new clojure.network.ip.IPAddress(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(G__7979),null,cljs.core.dissoc.call(null,G__7979,new cljs.core.Keyword(null,"value","value",305978217)),null));
});

clojure.network.ip.String.prototype.clojure$network$ip$IPConstructor$ = true;

clojure.network.ip.String.prototype.clojure$network$ip$IPConstructor$make_ip_address$arity$1 = (function (this$){
var this$__$1 = this;
return clojure.network.ip.__GT_IPAddress.call(null);
});
clojure.network.ip.get_network_address = (function clojure$network$ip$get_network_address(ip,subnet){
return clojure.network.ip.make_ip_address.call(null,cljs.core.reduce.call(null,clojure.network.ip.numeric_value.call(null,ip),(function (){var G__7986 = clojure.network.ip.version.call(null,ip);
switch (G__7986) {
case "v4":
return cljs.core.range.call(null,((32) - subnet));

break;
case "v6":
return cljs.core.range.call(null,cljs.core.range.call(null,((128) - subnet)));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(clojure.network.ip.version.call(null,ip))].join('')));

}
})()));
});
clojure.network.ip.get_broadcast_address = (function clojure$network$ip$get_broadcast_address(ip,subnet){
return clojure.network.ip.make_ip_address.call(null,cljs.core.reduce.call(null,clojure.network.ip.numeric_value.call(null,ip),(function (){var G__7989 = clojure.network.ip.version.call(null,ip);
switch (G__7989) {
case "v4":
return cljs.core.range.call(null,((32) - subnet));

break;
case "v6":
return cljs.core.range.call(null,((128) - subnet));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(clojure.network.ip.version.call(null,ip))].join('')));

}
})()));
});
clojure.network.ip.get_all_addresses = (function clojure$network$ip$get_all_addresses(ip,subnet){
var min_address = clojure.network.ip.numeric_value.call(null,clojure.network.ip.get_network_address.call(null,ip,subnet));
var max_address = null;
return cljs.core.map.call(null,clojure.network.ip.make_ip_address,cljs.core.range.call(null,min_address,max_address));
});
clojure.network.ip.test_ipv6 = "2a00:c31:1ffe:fff::9:13";
clojure.network.ip.test_ipv4 = "192.168.250.111";
clojure.network.ip.make_network = (function clojure$network$ip$make_network(var_args){
var args7992 = [];
var len__5646__auto___7998 = arguments.length;
var i__5647__auto___7999 = (0);
while(true){
if((i__5647__auto___7999 < len__5646__auto___7998)){
args7992.push((arguments[i__5647__auto___7999]));

var G__8000 = (i__5647__auto___7999 + (1));
i__5647__auto___7999 = G__8000;
continue;
} else {
}
break;
}

var G__7994 = args7992.length;
switch (G__7994) {
case 1:
return clojure.network.ip.make_network.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.network.ip.make_network.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args7992.length)].join('')));

}
});

clojure.network.ip.make_network.cljs$core$IFn$_invoke$arity$1 = (function (network){
return cljs.core.apply.call(null,clojure.network.ip.make_network,clojure.string.split.call(null,network,/\//));
});

clojure.network.ip.make_network.cljs$core$IFn$_invoke$arity$2 = (function (ip_address,subnet){
var temp__4425__auto__ = clojure.network.ip.make_ip_address.call(null,ip_address);
if(cljs.core.truth_(temp__4425__auto__)){
var ip_address__$1 = temp__4425__auto__;
var G__7995 = clojure.network.ip.version.call(null,ip_address__$1);
switch (G__7995) {
case "v4":
if(typeof subnet === 'string'){
var temp__4423__auto__ = (function (){try{return Integer.parseInt.call(null,subnet);
}catch (e7996){if((e7996 instanceof clojure.network.ip.Exception)){
var e = e7996;
return null;
} else {
throw e7996;

}
}})();
if(cljs.core.truth_(temp__4423__auto__)){
var subnet__$1 = temp__4423__auto__;
if(((subnet__$1 <= (32))) && ((subnet__$1 >= (0)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("Subnet "),cljs.core.str(subnet__$1),cljs.core.str(" is out of range.")].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"and","and",668631710,null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"subnet","subnet",640005315,null),(32)),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"subnet","subnet",640005315,null),(0)))))].join('')));
}

return clojure.network.ip.__GT_Network.call(null,ip_address__$1,subnet__$1);
} else {
if(cljs.core.seq.call(null,cljs.core.re_find.call(null,/\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/,subnet))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("Subnet: "),cljs.core.str(subnet),cljs.core.str(" is not valid!")].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"seq","seq",-177272256,null),cljs.core.list(new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),/\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/,new cljs.core.Symbol(null,"subnet","subnet",640005315,null)))))].join('')));
}

var subnet_count = ((function (temp__4423__auto__,G__7995,ip_address__$1,temp__4425__auto__){
return (function clojure$network$ip$subnet_count(x){
var testers = cljs.core.range.call(null,(7),(-1),(-1));
var test_BANG_ = cljs.core.map.call(null,((function (testers,temp__4423__auto__,G__7995,ip_address__$1,temp__4425__auto__){
return (function (p1__7991_SHARP_){
return ((x & (1 << p1__7991_SHARP_)) != 0);
});})(testers,temp__4423__auto__,G__7995,ip_address__$1,temp__4425__auto__))
,testers);
var subnet_bits = cljs.core.count.call(null,cljs.core.take_while.call(null,cljs.core.true_QMARK_,test_BANG_));
var all_bits = cljs.core.count.call(null,cljs.core.filter.call(null,cljs.core.true_QMARK_,test_BANG_));
if(cljs.core.not_EQ_.call(null,subnet_bits,all_bits)){
throw null;
} else {
return subnet_bits;
}
});})(temp__4423__auto__,G__7995,ip_address__$1,temp__4425__auto__))
;
var subnet__$1 = cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map.call(null,subnet_count,cljs.core.map.call(null,clojure.network.ip.read_string,clojure.string.split.call(null,subnet,/\./))));
return clojure.network.ip.__GT_Network.call(null,ip_address__$1,subnet__$1);
}
} else {
if(typeof subnet === 'number'){
if(((subnet <= (32))) && ((subnet >= (0)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("Subnet "),cljs.core.str(subnet),cljs.core.str(" is out of range.")].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"and","and",668631710,null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"subnet","subnet",640005315,null),(32)),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"subnet","subnet",640005315,null),(0)))))].join('')));
}

return clojure.network.ip.__GT_Network.call(null,ip_address__$1,subnet);
} else {
return null;

}
}

break;
case "v6":
if(typeof subnet === 'string'){
var temp__4423__auto__ = (function (){try{return Integer.parseInt.call(null,subnet);
}catch (e7997){if((e7997 instanceof clojure.network.ip.Exception)){
var e = e7997;
return null;
} else {
throw e7997;

}
}})();
if(cljs.core.truth_(temp__4423__auto__)){
var subnet__$1 = temp__4423__auto__;
return clojure.network.ip.__GT_Network.call(null,ip_address__$1,subnet__$1);
} else {
return ((function (temp__4423__auto__,G__7995,ip_address__$1,temp__4425__auto__){
return (function (){
return new cljs.core.Keyword(null,"clj","clj",-660495428).cljs$core$IFn$_invoke$arity$1((function(){throw (new clojure.network.ip.Exception([cljs.core.str("Can't make subnet from: "),cljs.core.str(subnet)].join('')))})());
});
;})(temp__4423__auto__,G__7995,ip_address__$1,temp__4425__auto__))
}
} else {
if(typeof subnet === 'number'){
return clojure.network.ip.__GT_Network.call(null,ip_address__$1,subnet);
} else {
return null;

}
}

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(clojure.network.ip.version.call(null,ip_address__$1))].join('')));

}
} else {
return null;
}
});

clojure.network.ip.make_network.cljs$lang$maxFixedArity = 2;

//# sourceMappingURL=ip.js.map