// Compiled by ClojureScript 1.7.122 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
figwheel.client.file_reloading.queued_file_reload;
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__16658__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__16658__auto__){
return or__16658__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__16658__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__16658__auto__)){
return or__16658__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__24001_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__24001_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__24006 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__24007 = null;
var count__24008 = (0);
var i__24009 = (0);
while(true){
if((i__24009 < count__24008)){
var n = cljs.core._nth.call(null,chunk__24007,i__24009);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__24010 = seq__24006;
var G__24011 = chunk__24007;
var G__24012 = count__24008;
var G__24013 = (i__24009 + (1));
seq__24006 = G__24010;
chunk__24007 = G__24011;
count__24008 = G__24012;
i__24009 = G__24013;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__24006);
if(temp__4425__auto__){
var seq__24006__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24006__$1)){
var c__17461__auto__ = cljs.core.chunk_first.call(null,seq__24006__$1);
var G__24014 = cljs.core.chunk_rest.call(null,seq__24006__$1);
var G__24015 = c__17461__auto__;
var G__24016 = cljs.core.count.call(null,c__17461__auto__);
var G__24017 = (0);
seq__24006 = G__24014;
chunk__24007 = G__24015;
count__24008 = G__24016;
i__24009 = G__24017;
continue;
} else {
var n = cljs.core.first.call(null,seq__24006__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__24018 = cljs.core.next.call(null,seq__24006__$1);
var G__24019 = null;
var G__24020 = (0);
var G__24021 = (0);
seq__24006 = G__24018;
chunk__24007 = G__24019;
count__24008 = G__24020;
i__24009 = G__24021;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__24060_24067 = cljs.core.seq.call(null,deps);
var chunk__24061_24068 = null;
var count__24062_24069 = (0);
var i__24063_24070 = (0);
while(true){
if((i__24063_24070 < count__24062_24069)){
var dep_24071 = cljs.core._nth.call(null,chunk__24061_24068,i__24063_24070);
topo_sort_helper_STAR_.call(null,dep_24071,(depth + (1)),state);

var G__24072 = seq__24060_24067;
var G__24073 = chunk__24061_24068;
var G__24074 = count__24062_24069;
var G__24075 = (i__24063_24070 + (1));
seq__24060_24067 = G__24072;
chunk__24061_24068 = G__24073;
count__24062_24069 = G__24074;
i__24063_24070 = G__24075;
continue;
} else {
var temp__4425__auto___24076 = cljs.core.seq.call(null,seq__24060_24067);
if(temp__4425__auto___24076){
var seq__24060_24077__$1 = temp__4425__auto___24076;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24060_24077__$1)){
var c__17461__auto___24078 = cljs.core.chunk_first.call(null,seq__24060_24077__$1);
var G__24079 = cljs.core.chunk_rest.call(null,seq__24060_24077__$1);
var G__24080 = c__17461__auto___24078;
var G__24081 = cljs.core.count.call(null,c__17461__auto___24078);
var G__24082 = (0);
seq__24060_24067 = G__24079;
chunk__24061_24068 = G__24080;
count__24062_24069 = G__24081;
i__24063_24070 = G__24082;
continue;
} else {
var dep_24083 = cljs.core.first.call(null,seq__24060_24077__$1);
topo_sort_helper_STAR_.call(null,dep_24083,(depth + (1)),state);

var G__24084 = cljs.core.next.call(null,seq__24060_24077__$1);
var G__24085 = null;
var G__24086 = (0);
var G__24087 = (0);
seq__24060_24067 = G__24084;
chunk__24061_24068 = G__24085;
count__24062_24069 = G__24086;
i__24063_24070 = G__24087;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__24064){
var vec__24066 = p__24064;
var x = cljs.core.nth.call(null,vec__24066,(0),null);
var xs = cljs.core.nthnext.call(null,vec__24066,(1));
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__24066,x,xs,get_deps__$1){
return (function (p1__24022_SHARP_){
return clojure.set.difference.call(null,p1__24022_SHARP_,x);
});})(vec__24066,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__24100 = cljs.core.seq.call(null,provides);
var chunk__24101 = null;
var count__24102 = (0);
var i__24103 = (0);
while(true){
if((i__24103 < count__24102)){
var prov = cljs.core._nth.call(null,chunk__24101,i__24103);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__24104_24112 = cljs.core.seq.call(null,requires);
var chunk__24105_24113 = null;
var count__24106_24114 = (0);
var i__24107_24115 = (0);
while(true){
if((i__24107_24115 < count__24106_24114)){
var req_24116 = cljs.core._nth.call(null,chunk__24105_24113,i__24107_24115);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_24116,prov);

var G__24117 = seq__24104_24112;
var G__24118 = chunk__24105_24113;
var G__24119 = count__24106_24114;
var G__24120 = (i__24107_24115 + (1));
seq__24104_24112 = G__24117;
chunk__24105_24113 = G__24118;
count__24106_24114 = G__24119;
i__24107_24115 = G__24120;
continue;
} else {
var temp__4425__auto___24121 = cljs.core.seq.call(null,seq__24104_24112);
if(temp__4425__auto___24121){
var seq__24104_24122__$1 = temp__4425__auto___24121;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24104_24122__$1)){
var c__17461__auto___24123 = cljs.core.chunk_first.call(null,seq__24104_24122__$1);
var G__24124 = cljs.core.chunk_rest.call(null,seq__24104_24122__$1);
var G__24125 = c__17461__auto___24123;
var G__24126 = cljs.core.count.call(null,c__17461__auto___24123);
var G__24127 = (0);
seq__24104_24112 = G__24124;
chunk__24105_24113 = G__24125;
count__24106_24114 = G__24126;
i__24107_24115 = G__24127;
continue;
} else {
var req_24128 = cljs.core.first.call(null,seq__24104_24122__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_24128,prov);

var G__24129 = cljs.core.next.call(null,seq__24104_24122__$1);
var G__24130 = null;
var G__24131 = (0);
var G__24132 = (0);
seq__24104_24112 = G__24129;
chunk__24105_24113 = G__24130;
count__24106_24114 = G__24131;
i__24107_24115 = G__24132;
continue;
}
} else {
}
}
break;
}

var G__24133 = seq__24100;
var G__24134 = chunk__24101;
var G__24135 = count__24102;
var G__24136 = (i__24103 + (1));
seq__24100 = G__24133;
chunk__24101 = G__24134;
count__24102 = G__24135;
i__24103 = G__24136;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__24100);
if(temp__4425__auto__){
var seq__24100__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24100__$1)){
var c__17461__auto__ = cljs.core.chunk_first.call(null,seq__24100__$1);
var G__24137 = cljs.core.chunk_rest.call(null,seq__24100__$1);
var G__24138 = c__17461__auto__;
var G__24139 = cljs.core.count.call(null,c__17461__auto__);
var G__24140 = (0);
seq__24100 = G__24137;
chunk__24101 = G__24138;
count__24102 = G__24139;
i__24103 = G__24140;
continue;
} else {
var prov = cljs.core.first.call(null,seq__24100__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__24108_24141 = cljs.core.seq.call(null,requires);
var chunk__24109_24142 = null;
var count__24110_24143 = (0);
var i__24111_24144 = (0);
while(true){
if((i__24111_24144 < count__24110_24143)){
var req_24145 = cljs.core._nth.call(null,chunk__24109_24142,i__24111_24144);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_24145,prov);

var G__24146 = seq__24108_24141;
var G__24147 = chunk__24109_24142;
var G__24148 = count__24110_24143;
var G__24149 = (i__24111_24144 + (1));
seq__24108_24141 = G__24146;
chunk__24109_24142 = G__24147;
count__24110_24143 = G__24148;
i__24111_24144 = G__24149;
continue;
} else {
var temp__4425__auto___24150__$1 = cljs.core.seq.call(null,seq__24108_24141);
if(temp__4425__auto___24150__$1){
var seq__24108_24151__$1 = temp__4425__auto___24150__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24108_24151__$1)){
var c__17461__auto___24152 = cljs.core.chunk_first.call(null,seq__24108_24151__$1);
var G__24153 = cljs.core.chunk_rest.call(null,seq__24108_24151__$1);
var G__24154 = c__17461__auto___24152;
var G__24155 = cljs.core.count.call(null,c__17461__auto___24152);
var G__24156 = (0);
seq__24108_24141 = G__24153;
chunk__24109_24142 = G__24154;
count__24110_24143 = G__24155;
i__24111_24144 = G__24156;
continue;
} else {
var req_24157 = cljs.core.first.call(null,seq__24108_24151__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_24157,prov);

var G__24158 = cljs.core.next.call(null,seq__24108_24151__$1);
var G__24159 = null;
var G__24160 = (0);
var G__24161 = (0);
seq__24108_24141 = G__24158;
chunk__24109_24142 = G__24159;
count__24110_24143 = G__24160;
i__24111_24144 = G__24161;
continue;
}
} else {
}
}
break;
}

var G__24162 = cljs.core.next.call(null,seq__24100__$1);
var G__24163 = null;
var G__24164 = (0);
var G__24165 = (0);
seq__24100 = G__24162;
chunk__24101 = G__24163;
count__24102 = G__24164;
i__24103 = G__24165;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__24170_24174 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__24171_24175 = null;
var count__24172_24176 = (0);
var i__24173_24177 = (0);
while(true){
if((i__24173_24177 < count__24172_24176)){
var ns_24178 = cljs.core._nth.call(null,chunk__24171_24175,i__24173_24177);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_24178);

var G__24179 = seq__24170_24174;
var G__24180 = chunk__24171_24175;
var G__24181 = count__24172_24176;
var G__24182 = (i__24173_24177 + (1));
seq__24170_24174 = G__24179;
chunk__24171_24175 = G__24180;
count__24172_24176 = G__24181;
i__24173_24177 = G__24182;
continue;
} else {
var temp__4425__auto___24183 = cljs.core.seq.call(null,seq__24170_24174);
if(temp__4425__auto___24183){
var seq__24170_24184__$1 = temp__4425__auto___24183;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24170_24184__$1)){
var c__17461__auto___24185 = cljs.core.chunk_first.call(null,seq__24170_24184__$1);
var G__24186 = cljs.core.chunk_rest.call(null,seq__24170_24184__$1);
var G__24187 = c__17461__auto___24185;
var G__24188 = cljs.core.count.call(null,c__17461__auto___24185);
var G__24189 = (0);
seq__24170_24174 = G__24186;
chunk__24171_24175 = G__24187;
count__24172_24176 = G__24188;
i__24173_24177 = G__24189;
continue;
} else {
var ns_24190 = cljs.core.first.call(null,seq__24170_24184__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_24190);

var G__24191 = cljs.core.next.call(null,seq__24170_24184__$1);
var G__24192 = null;
var G__24193 = (0);
var G__24194 = (0);
seq__24170_24174 = G__24191;
chunk__24171_24175 = G__24192;
count__24172_24176 = G__24193;
i__24173_24177 = G__24194;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__16658__auto__ = goog.require__;
if(cljs.core.truth_(or__16658__auto__)){
return or__16658__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__24195__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__24195 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__24196__i = 0, G__24196__a = new Array(arguments.length -  0);
while (G__24196__i < G__24196__a.length) {G__24196__a[G__24196__i] = arguments[G__24196__i + 0]; ++G__24196__i;}
  args = new cljs.core.IndexedSeq(G__24196__a,0);
} 
return G__24195__delegate.call(this,args);};
G__24195.cljs$lang$maxFixedArity = 0;
G__24195.cljs$lang$applyTo = (function (arglist__24197){
var args = cljs.core.seq(arglist__24197);
return G__24195__delegate(args);
});
G__24195.cljs$core$IFn$_invoke$arity$variadic = G__24195__delegate;
return G__24195;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__24199 = cljs.core._EQ_;
var expr__24200 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__24199.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__24200))){
var path_parts = ((function (pred__24199,expr__24200){
return (function (p1__24198_SHARP_){
return clojure.string.split.call(null,p1__24198_SHARP_,/[\/\\]/);
});})(pred__24199,expr__24200))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__24199,expr__24200){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e24202){if((e24202 instanceof Error)){
var e = e24202;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e24202;

}
}})());
});
;})(path_parts,sep,root,pred__24199,expr__24200))
} else {
if(cljs.core.truth_(pred__24199.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__24200))){
return ((function (pred__24199,expr__24200){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred,pred__24199,expr__24200){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__24199,expr__24200))
);

return deferred.addErrback(((function (deferred,pred__24199,expr__24200){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__24199,expr__24200))
);
});
;})(pred__24199,expr__24200))
} else {
return ((function (pred__24199,expr__24200){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__24199,expr__24200))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__24203,callback){
var map__24206 = p__24203;
var map__24206__$1 = ((((!((map__24206 == null)))?((((map__24206.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24206.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24206):map__24206);
var file_msg = map__24206__$1;
var request_url = cljs.core.get.call(null,map__24206__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__24206,map__24206__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__24206,map__24206__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__18741__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto__){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto__){
return (function (state_24230){
var state_val_24231 = (state_24230[(1)]);
if((state_val_24231 === (7))){
var inst_24226 = (state_24230[(2)]);
var state_24230__$1 = state_24230;
var statearr_24232_24252 = state_24230__$1;
(statearr_24232_24252[(2)] = inst_24226);

(statearr_24232_24252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24231 === (1))){
var state_24230__$1 = state_24230;
var statearr_24233_24253 = state_24230__$1;
(statearr_24233_24253[(2)] = null);

(statearr_24233_24253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24231 === (4))){
var inst_24210 = (state_24230[(7)]);
var inst_24210__$1 = (state_24230[(2)]);
var state_24230__$1 = (function (){var statearr_24234 = state_24230;
(statearr_24234[(7)] = inst_24210__$1);

return statearr_24234;
})();
if(cljs.core.truth_(inst_24210__$1)){
var statearr_24235_24254 = state_24230__$1;
(statearr_24235_24254[(1)] = (5));

} else {
var statearr_24236_24255 = state_24230__$1;
(statearr_24236_24255[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24231 === (6))){
var state_24230__$1 = state_24230;
var statearr_24237_24256 = state_24230__$1;
(statearr_24237_24256[(2)] = null);

(statearr_24237_24256[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24231 === (3))){
var inst_24228 = (state_24230[(2)]);
var state_24230__$1 = state_24230;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24230__$1,inst_24228);
} else {
if((state_val_24231 === (2))){
var state_24230__$1 = state_24230;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24230__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_24231 === (11))){
var inst_24222 = (state_24230[(2)]);
var state_24230__$1 = (function (){var statearr_24238 = state_24230;
(statearr_24238[(8)] = inst_24222);

return statearr_24238;
})();
var statearr_24239_24257 = state_24230__$1;
(statearr_24239_24257[(2)] = null);

(statearr_24239_24257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24231 === (9))){
var inst_24216 = (state_24230[(9)]);
var inst_24214 = (state_24230[(10)]);
var inst_24218 = inst_24216.call(null,inst_24214);
var state_24230__$1 = state_24230;
var statearr_24240_24258 = state_24230__$1;
(statearr_24240_24258[(2)] = inst_24218);

(statearr_24240_24258[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24231 === (5))){
var inst_24210 = (state_24230[(7)]);
var inst_24212 = figwheel.client.file_reloading.blocking_load.call(null,inst_24210);
var state_24230__$1 = state_24230;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24230__$1,(8),inst_24212);
} else {
if((state_val_24231 === (10))){
var inst_24214 = (state_24230[(10)]);
var inst_24220 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_24214);
var state_24230__$1 = state_24230;
var statearr_24241_24259 = state_24230__$1;
(statearr_24241_24259[(2)] = inst_24220);

(statearr_24241_24259[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24231 === (8))){
var inst_24216 = (state_24230[(9)]);
var inst_24210 = (state_24230[(7)]);
var inst_24214 = (state_24230[(2)]);
var inst_24215 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_24216__$1 = cljs.core.get.call(null,inst_24215,inst_24210);
var state_24230__$1 = (function (){var statearr_24242 = state_24230;
(statearr_24242[(9)] = inst_24216__$1);

(statearr_24242[(10)] = inst_24214);

return statearr_24242;
})();
if(cljs.core.truth_(inst_24216__$1)){
var statearr_24243_24260 = state_24230__$1;
(statearr_24243_24260[(1)] = (9));

} else {
var statearr_24244_24261 = state_24230__$1;
(statearr_24244_24261[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto__))
;
return ((function (switch__18676__auto__,c__18741__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__18677__auto__ = null;
var figwheel$client$file_reloading$state_machine__18677__auto____0 = (function (){
var statearr_24248 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24248[(0)] = figwheel$client$file_reloading$state_machine__18677__auto__);

(statearr_24248[(1)] = (1));

return statearr_24248;
});
var figwheel$client$file_reloading$state_machine__18677__auto____1 = (function (state_24230){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_24230);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e24249){if((e24249 instanceof Object)){
var ex__18680__auto__ = e24249;
var statearr_24250_24262 = state_24230;
(statearr_24250_24262[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24230);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24249;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24263 = state_24230;
state_24230 = G__24263;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__18677__auto__ = function(state_24230){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__18677__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__18677__auto____1.call(this,state_24230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__18677__auto____0;
figwheel$client$file_reloading$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__18677__auto____1;
return figwheel$client$file_reloading$state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto__))
})();
var state__18743__auto__ = (function (){var statearr_24251 = f__18742__auto__.call(null);
(statearr_24251[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto__);

return statearr_24251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto__))
);

return c__18741__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__24264,callback){
var map__24267 = p__24264;
var map__24267__$1 = ((((!((map__24267 == null)))?((((map__24267.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24267.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24267):map__24267);
var file_msg = map__24267__$1;
var namespace = cljs.core.get.call(null,map__24267__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__24267,map__24267__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__24267,map__24267__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__24269){
var map__24272 = p__24269;
var map__24272__$1 = ((((!((map__24272 == null)))?((((map__24272.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24272.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24272):map__24272);
var file_msg = map__24272__$1;
var namespace = cljs.core.get.call(null,map__24272__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__16646__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__16646__auto__){
var or__16658__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__16658__auto__)){
return or__16658__auto__;
} else {
var or__16658__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__16658__auto____$1)){
return or__16658__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__16646__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__24274,callback){
var map__24277 = p__24274;
var map__24277__$1 = ((((!((map__24277 == null)))?((((map__24277.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24277.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24277):map__24277);
var file_msg = map__24277__$1;
var request_url = cljs.core.get.call(null,map__24277__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__24277__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__18741__auto___24365 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___24365,out){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___24365,out){
return (function (state_24347){
var state_val_24348 = (state_24347[(1)]);
if((state_val_24348 === (1))){
var inst_24325 = cljs.core.nth.call(null,files,(0),null);
var inst_24326 = cljs.core.nthnext.call(null,files,(1));
var inst_24327 = files;
var state_24347__$1 = (function (){var statearr_24349 = state_24347;
(statearr_24349[(7)] = inst_24327);

(statearr_24349[(8)] = inst_24325);

(statearr_24349[(9)] = inst_24326);

return statearr_24349;
})();
var statearr_24350_24366 = state_24347__$1;
(statearr_24350_24366[(2)] = null);

(statearr_24350_24366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24348 === (2))){
var inst_24327 = (state_24347[(7)]);
var inst_24330 = (state_24347[(10)]);
var inst_24330__$1 = cljs.core.nth.call(null,inst_24327,(0),null);
var inst_24331 = cljs.core.nthnext.call(null,inst_24327,(1));
var inst_24332 = (inst_24330__$1 == null);
var inst_24333 = cljs.core.not.call(null,inst_24332);
var state_24347__$1 = (function (){var statearr_24351 = state_24347;
(statearr_24351[(11)] = inst_24331);

(statearr_24351[(10)] = inst_24330__$1);

return statearr_24351;
})();
if(inst_24333){
var statearr_24352_24367 = state_24347__$1;
(statearr_24352_24367[(1)] = (4));

} else {
var statearr_24353_24368 = state_24347__$1;
(statearr_24353_24368[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24348 === (3))){
var inst_24345 = (state_24347[(2)]);
var state_24347__$1 = state_24347;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24347__$1,inst_24345);
} else {
if((state_val_24348 === (4))){
var inst_24330 = (state_24347[(10)]);
var inst_24335 = figwheel.client.file_reloading.reload_js_file.call(null,inst_24330);
var state_24347__$1 = state_24347;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24347__$1,(7),inst_24335);
} else {
if((state_val_24348 === (5))){
var inst_24341 = cljs.core.async.close_BANG_.call(null,out);
var state_24347__$1 = state_24347;
var statearr_24354_24369 = state_24347__$1;
(statearr_24354_24369[(2)] = inst_24341);

(statearr_24354_24369[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24348 === (6))){
var inst_24343 = (state_24347[(2)]);
var state_24347__$1 = state_24347;
var statearr_24355_24370 = state_24347__$1;
(statearr_24355_24370[(2)] = inst_24343);

(statearr_24355_24370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24348 === (7))){
var inst_24331 = (state_24347[(11)]);
var inst_24337 = (state_24347[(2)]);
var inst_24338 = cljs.core.async.put_BANG_.call(null,out,inst_24337);
var inst_24327 = inst_24331;
var state_24347__$1 = (function (){var statearr_24356 = state_24347;
(statearr_24356[(7)] = inst_24327);

(statearr_24356[(12)] = inst_24338);

return statearr_24356;
})();
var statearr_24357_24371 = state_24347__$1;
(statearr_24357_24371[(2)] = null);

(statearr_24357_24371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__18741__auto___24365,out))
;
return ((function (switch__18676__auto__,c__18741__auto___24365,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__18677__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__18677__auto____0 = (function (){
var statearr_24361 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24361[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__18677__auto__);

(statearr_24361[(1)] = (1));

return statearr_24361;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__18677__auto____1 = (function (state_24347){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_24347);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e24362){if((e24362 instanceof Object)){
var ex__18680__auto__ = e24362;
var statearr_24363_24372 = state_24347;
(statearr_24363_24372[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24347);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24362;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24373 = state_24347;
state_24347 = G__24373;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__18677__auto__ = function(state_24347){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__18677__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__18677__auto____1.call(this,state_24347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__18677__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__18677__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___24365,out))
})();
var state__18743__auto__ = (function (){var statearr_24364 = f__18742__auto__.call(null);
(statearr_24364[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___24365);

return statearr_24364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___24365,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__24374,opts){
var map__24378 = p__24374;
var map__24378__$1 = ((((!((map__24378 == null)))?((((map__24378.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24378.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24378):map__24378);
var eval_body__$1 = cljs.core.get.call(null,map__24378__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__24378__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__16646__auto__ = eval_body__$1;
if(cljs.core.truth_(and__16646__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__16646__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e24380){var e = e24380;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4423__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__24381_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__24381_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4423__auto__)){
var file_msg = temp__4423__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__24386){
var vec__24387 = p__24386;
var k = cljs.core.nth.call(null,vec__24387,(0),null);
var v = cljs.core.nth.call(null,vec__24387,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__24388){
var vec__24389 = p__24388;
var k = cljs.core.nth.call(null,vec__24389,(0),null);
var v = cljs.core.nth.call(null,vec__24389,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__24393,p__24394){
var map__24641 = p__24393;
var map__24641__$1 = ((((!((map__24641 == null)))?((((map__24641.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24641.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24641):map__24641);
var opts = map__24641__$1;
var before_jsload = cljs.core.get.call(null,map__24641__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__24641__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__24641__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__24642 = p__24394;
var map__24642__$1 = ((((!((map__24642 == null)))?((((map__24642.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24642.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24642):map__24642);
var msg = map__24642__$1;
var files = cljs.core.get.call(null,map__24642__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__24642__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__24642__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__18741__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_24795){
var state_val_24796 = (state_24795[(1)]);
if((state_val_24796 === (7))){
var inst_24656 = (state_24795[(7)]);
var inst_24657 = (state_24795[(8)]);
var inst_24659 = (state_24795[(9)]);
var inst_24658 = (state_24795[(10)]);
var inst_24664 = cljs.core._nth.call(null,inst_24657,inst_24659);
var inst_24665 = figwheel.client.file_reloading.eval_body.call(null,inst_24664,opts);
var inst_24666 = (inst_24659 + (1));
var tmp24797 = inst_24656;
var tmp24798 = inst_24657;
var tmp24799 = inst_24658;
var inst_24656__$1 = tmp24797;
var inst_24657__$1 = tmp24798;
var inst_24658__$1 = tmp24799;
var inst_24659__$1 = inst_24666;
var state_24795__$1 = (function (){var statearr_24800 = state_24795;
(statearr_24800[(7)] = inst_24656__$1);

(statearr_24800[(8)] = inst_24657__$1);

(statearr_24800[(9)] = inst_24659__$1);

(statearr_24800[(11)] = inst_24665);

(statearr_24800[(10)] = inst_24658__$1);

return statearr_24800;
})();
var statearr_24801_24887 = state_24795__$1;
(statearr_24801_24887[(2)] = null);

(statearr_24801_24887[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (20))){
var inst_24699 = (state_24795[(12)]);
var inst_24707 = figwheel.client.file_reloading.sort_files.call(null,inst_24699);
var state_24795__$1 = state_24795;
var statearr_24802_24888 = state_24795__$1;
(statearr_24802_24888[(2)] = inst_24707);

(statearr_24802_24888[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (27))){
var state_24795__$1 = state_24795;
var statearr_24803_24889 = state_24795__$1;
(statearr_24803_24889[(2)] = null);

(statearr_24803_24889[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (1))){
var inst_24648 = (state_24795[(13)]);
var inst_24645 = before_jsload.call(null,files);
var inst_24646 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_24647 = (function (){return ((function (inst_24648,inst_24645,inst_24646,state_val_24796,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__24390_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__24390_SHARP_);
});
;})(inst_24648,inst_24645,inst_24646,state_val_24796,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24648__$1 = cljs.core.filter.call(null,inst_24647,files);
var inst_24649 = cljs.core.not_empty.call(null,inst_24648__$1);
var state_24795__$1 = (function (){var statearr_24804 = state_24795;
(statearr_24804[(14)] = inst_24645);

(statearr_24804[(13)] = inst_24648__$1);

(statearr_24804[(15)] = inst_24646);

return statearr_24804;
})();
if(cljs.core.truth_(inst_24649)){
var statearr_24805_24890 = state_24795__$1;
(statearr_24805_24890[(1)] = (2));

} else {
var statearr_24806_24891 = state_24795__$1;
(statearr_24806_24891[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (24))){
var state_24795__$1 = state_24795;
var statearr_24807_24892 = state_24795__$1;
(statearr_24807_24892[(2)] = null);

(statearr_24807_24892[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (39))){
var inst_24749 = (state_24795[(16)]);
var state_24795__$1 = state_24795;
var statearr_24808_24893 = state_24795__$1;
(statearr_24808_24893[(2)] = inst_24749);

(statearr_24808_24893[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (46))){
var inst_24790 = (state_24795[(2)]);
var state_24795__$1 = state_24795;
var statearr_24809_24894 = state_24795__$1;
(statearr_24809_24894[(2)] = inst_24790);

(statearr_24809_24894[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (4))){
var inst_24693 = (state_24795[(2)]);
var inst_24694 = cljs.core.List.EMPTY;
var inst_24695 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_24694);
var inst_24696 = (function (){return ((function (inst_24693,inst_24694,inst_24695,state_val_24796,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__24391_SHARP_){
var and__16646__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__24391_SHARP_);
if(cljs.core.truth_(and__16646__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__24391_SHARP_));
} else {
return and__16646__auto__;
}
});
;})(inst_24693,inst_24694,inst_24695,state_val_24796,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24697 = cljs.core.filter.call(null,inst_24696,files);
var inst_24698 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_24699 = cljs.core.concat.call(null,inst_24697,inst_24698);
var state_24795__$1 = (function (){var statearr_24810 = state_24795;
(statearr_24810[(12)] = inst_24699);

(statearr_24810[(17)] = inst_24693);

(statearr_24810[(18)] = inst_24695);

return statearr_24810;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_24811_24895 = state_24795__$1;
(statearr_24811_24895[(1)] = (16));

} else {
var statearr_24812_24896 = state_24795__$1;
(statearr_24812_24896[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (15))){
var inst_24683 = (state_24795[(2)]);
var state_24795__$1 = state_24795;
var statearr_24813_24897 = state_24795__$1;
(statearr_24813_24897[(2)] = inst_24683);

(statearr_24813_24897[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (21))){
var inst_24709 = (state_24795[(19)]);
var inst_24709__$1 = (state_24795[(2)]);
var inst_24710 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_24709__$1);
var state_24795__$1 = (function (){var statearr_24814 = state_24795;
(statearr_24814[(19)] = inst_24709__$1);

return statearr_24814;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24795__$1,(22),inst_24710);
} else {
if((state_val_24796 === (31))){
var inst_24793 = (state_24795[(2)]);
var state_24795__$1 = state_24795;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24795__$1,inst_24793);
} else {
if((state_val_24796 === (32))){
var inst_24749 = (state_24795[(16)]);
var inst_24754 = inst_24749.cljs$lang$protocol_mask$partition0$;
var inst_24755 = (inst_24754 & (64));
var inst_24756 = inst_24749.cljs$core$ISeq$;
var inst_24757 = (inst_24755) || (inst_24756);
var state_24795__$1 = state_24795;
if(cljs.core.truth_(inst_24757)){
var statearr_24815_24898 = state_24795__$1;
(statearr_24815_24898[(1)] = (35));

} else {
var statearr_24816_24899 = state_24795__$1;
(statearr_24816_24899[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (40))){
var inst_24770 = (state_24795[(20)]);
var inst_24769 = (state_24795[(2)]);
var inst_24770__$1 = cljs.core.get.call(null,inst_24769,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_24771 = cljs.core.get.call(null,inst_24769,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_24772 = cljs.core.not_empty.call(null,inst_24770__$1);
var state_24795__$1 = (function (){var statearr_24817 = state_24795;
(statearr_24817[(21)] = inst_24771);

(statearr_24817[(20)] = inst_24770__$1);

return statearr_24817;
})();
if(cljs.core.truth_(inst_24772)){
var statearr_24818_24900 = state_24795__$1;
(statearr_24818_24900[(1)] = (41));

} else {
var statearr_24819_24901 = state_24795__$1;
(statearr_24819_24901[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (33))){
var state_24795__$1 = state_24795;
var statearr_24820_24902 = state_24795__$1;
(statearr_24820_24902[(2)] = false);

(statearr_24820_24902[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (13))){
var inst_24669 = (state_24795[(22)]);
var inst_24673 = cljs.core.chunk_first.call(null,inst_24669);
var inst_24674 = cljs.core.chunk_rest.call(null,inst_24669);
var inst_24675 = cljs.core.count.call(null,inst_24673);
var inst_24656 = inst_24674;
var inst_24657 = inst_24673;
var inst_24658 = inst_24675;
var inst_24659 = (0);
var state_24795__$1 = (function (){var statearr_24821 = state_24795;
(statearr_24821[(7)] = inst_24656);

(statearr_24821[(8)] = inst_24657);

(statearr_24821[(9)] = inst_24659);

(statearr_24821[(10)] = inst_24658);

return statearr_24821;
})();
var statearr_24822_24903 = state_24795__$1;
(statearr_24822_24903[(2)] = null);

(statearr_24822_24903[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (22))){
var inst_24713 = (state_24795[(23)]);
var inst_24717 = (state_24795[(24)]);
var inst_24712 = (state_24795[(25)]);
var inst_24709 = (state_24795[(19)]);
var inst_24712__$1 = (state_24795[(2)]);
var inst_24713__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_24712__$1);
var inst_24714 = (function (){var all_files = inst_24709;
var res_SINGLEQUOTE_ = inst_24712__$1;
var res = inst_24713__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_24713,inst_24717,inst_24712,inst_24709,inst_24712__$1,inst_24713__$1,state_val_24796,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__24392_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__24392_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_24713,inst_24717,inst_24712,inst_24709,inst_24712__$1,inst_24713__$1,state_val_24796,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24715 = cljs.core.filter.call(null,inst_24714,inst_24712__$1);
var inst_24716 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_24717__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_24716);
var inst_24718 = cljs.core.not_empty.call(null,inst_24717__$1);
var state_24795__$1 = (function (){var statearr_24823 = state_24795;
(statearr_24823[(23)] = inst_24713__$1);

(statearr_24823[(26)] = inst_24715);

(statearr_24823[(24)] = inst_24717__$1);

(statearr_24823[(25)] = inst_24712__$1);

return statearr_24823;
})();
if(cljs.core.truth_(inst_24718)){
var statearr_24824_24904 = state_24795__$1;
(statearr_24824_24904[(1)] = (23));

} else {
var statearr_24825_24905 = state_24795__$1;
(statearr_24825_24905[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (36))){
var state_24795__$1 = state_24795;
var statearr_24826_24906 = state_24795__$1;
(statearr_24826_24906[(2)] = false);

(statearr_24826_24906[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (41))){
var inst_24770 = (state_24795[(20)]);
var inst_24774 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_24775 = cljs.core.map.call(null,inst_24774,inst_24770);
var inst_24776 = cljs.core.pr_str.call(null,inst_24775);
var inst_24777 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_24776)].join('');
var inst_24778 = figwheel.client.utils.log.call(null,inst_24777);
var state_24795__$1 = state_24795;
var statearr_24827_24907 = state_24795__$1;
(statearr_24827_24907[(2)] = inst_24778);

(statearr_24827_24907[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (43))){
var inst_24771 = (state_24795[(21)]);
var inst_24781 = (state_24795[(2)]);
var inst_24782 = cljs.core.not_empty.call(null,inst_24771);
var state_24795__$1 = (function (){var statearr_24828 = state_24795;
(statearr_24828[(27)] = inst_24781);

return statearr_24828;
})();
if(cljs.core.truth_(inst_24782)){
var statearr_24829_24908 = state_24795__$1;
(statearr_24829_24908[(1)] = (44));

} else {
var statearr_24830_24909 = state_24795__$1;
(statearr_24830_24909[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (29))){
var inst_24713 = (state_24795[(23)]);
var inst_24715 = (state_24795[(26)]);
var inst_24717 = (state_24795[(24)]);
var inst_24712 = (state_24795[(25)]);
var inst_24749 = (state_24795[(16)]);
var inst_24709 = (state_24795[(19)]);
var inst_24745 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_24748 = (function (){var all_files = inst_24709;
var res_SINGLEQUOTE_ = inst_24712;
var res = inst_24713;
var files_not_loaded = inst_24715;
var dependencies_that_loaded = inst_24717;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24713,inst_24715,inst_24717,inst_24712,inst_24749,inst_24709,inst_24745,state_val_24796,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__24747){
var map__24831 = p__24747;
var map__24831__$1 = ((((!((map__24831 == null)))?((((map__24831.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24831.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24831):map__24831);
var namespace = cljs.core.get.call(null,map__24831__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24713,inst_24715,inst_24717,inst_24712,inst_24749,inst_24709,inst_24745,state_val_24796,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24749__$1 = cljs.core.group_by.call(null,inst_24748,inst_24715);
var inst_24751 = (inst_24749__$1 == null);
var inst_24752 = cljs.core.not.call(null,inst_24751);
var state_24795__$1 = (function (){var statearr_24833 = state_24795;
(statearr_24833[(28)] = inst_24745);

(statearr_24833[(16)] = inst_24749__$1);

return statearr_24833;
})();
if(inst_24752){
var statearr_24834_24910 = state_24795__$1;
(statearr_24834_24910[(1)] = (32));

} else {
var statearr_24835_24911 = state_24795__$1;
(statearr_24835_24911[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (44))){
var inst_24771 = (state_24795[(21)]);
var inst_24784 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_24771);
var inst_24785 = cljs.core.pr_str.call(null,inst_24784);
var inst_24786 = [cljs.core.str("not required: "),cljs.core.str(inst_24785)].join('');
var inst_24787 = figwheel.client.utils.log.call(null,inst_24786);
var state_24795__$1 = state_24795;
var statearr_24836_24912 = state_24795__$1;
(statearr_24836_24912[(2)] = inst_24787);

(statearr_24836_24912[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (6))){
var inst_24690 = (state_24795[(2)]);
var state_24795__$1 = state_24795;
var statearr_24837_24913 = state_24795__$1;
(statearr_24837_24913[(2)] = inst_24690);

(statearr_24837_24913[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (28))){
var inst_24715 = (state_24795[(26)]);
var inst_24742 = (state_24795[(2)]);
var inst_24743 = cljs.core.not_empty.call(null,inst_24715);
var state_24795__$1 = (function (){var statearr_24838 = state_24795;
(statearr_24838[(29)] = inst_24742);

return statearr_24838;
})();
if(cljs.core.truth_(inst_24743)){
var statearr_24839_24914 = state_24795__$1;
(statearr_24839_24914[(1)] = (29));

} else {
var statearr_24840_24915 = state_24795__$1;
(statearr_24840_24915[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (25))){
var inst_24713 = (state_24795[(23)]);
var inst_24729 = (state_24795[(2)]);
var inst_24730 = cljs.core.not_empty.call(null,inst_24713);
var state_24795__$1 = (function (){var statearr_24841 = state_24795;
(statearr_24841[(30)] = inst_24729);

return statearr_24841;
})();
if(cljs.core.truth_(inst_24730)){
var statearr_24842_24916 = state_24795__$1;
(statearr_24842_24916[(1)] = (26));

} else {
var statearr_24843_24917 = state_24795__$1;
(statearr_24843_24917[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (34))){
var inst_24764 = (state_24795[(2)]);
var state_24795__$1 = state_24795;
if(cljs.core.truth_(inst_24764)){
var statearr_24844_24918 = state_24795__$1;
(statearr_24844_24918[(1)] = (38));

} else {
var statearr_24845_24919 = state_24795__$1;
(statearr_24845_24919[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (17))){
var state_24795__$1 = state_24795;
var statearr_24846_24920 = state_24795__$1;
(statearr_24846_24920[(2)] = recompile_dependents);

(statearr_24846_24920[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (3))){
var state_24795__$1 = state_24795;
var statearr_24847_24921 = state_24795__$1;
(statearr_24847_24921[(2)] = null);

(statearr_24847_24921[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (12))){
var inst_24686 = (state_24795[(2)]);
var state_24795__$1 = state_24795;
var statearr_24848_24922 = state_24795__$1;
(statearr_24848_24922[(2)] = inst_24686);

(statearr_24848_24922[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (2))){
var inst_24648 = (state_24795[(13)]);
var inst_24655 = cljs.core.seq.call(null,inst_24648);
var inst_24656 = inst_24655;
var inst_24657 = null;
var inst_24658 = (0);
var inst_24659 = (0);
var state_24795__$1 = (function (){var statearr_24849 = state_24795;
(statearr_24849[(7)] = inst_24656);

(statearr_24849[(8)] = inst_24657);

(statearr_24849[(9)] = inst_24659);

(statearr_24849[(10)] = inst_24658);

return statearr_24849;
})();
var statearr_24850_24923 = state_24795__$1;
(statearr_24850_24923[(2)] = null);

(statearr_24850_24923[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (23))){
var inst_24713 = (state_24795[(23)]);
var inst_24715 = (state_24795[(26)]);
var inst_24717 = (state_24795[(24)]);
var inst_24712 = (state_24795[(25)]);
var inst_24709 = (state_24795[(19)]);
var inst_24720 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_24722 = (function (){var all_files = inst_24709;
var res_SINGLEQUOTE_ = inst_24712;
var res = inst_24713;
var files_not_loaded = inst_24715;
var dependencies_that_loaded = inst_24717;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24713,inst_24715,inst_24717,inst_24712,inst_24709,inst_24720,state_val_24796,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__24721){
var map__24851 = p__24721;
var map__24851__$1 = ((((!((map__24851 == null)))?((((map__24851.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24851.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24851):map__24851);
var request_url = cljs.core.get.call(null,map__24851__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24713,inst_24715,inst_24717,inst_24712,inst_24709,inst_24720,state_val_24796,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24723 = cljs.core.reverse.call(null,inst_24717);
var inst_24724 = cljs.core.map.call(null,inst_24722,inst_24723);
var inst_24725 = cljs.core.pr_str.call(null,inst_24724);
var inst_24726 = figwheel.client.utils.log.call(null,inst_24725);
var state_24795__$1 = (function (){var statearr_24853 = state_24795;
(statearr_24853[(31)] = inst_24720);

return statearr_24853;
})();
var statearr_24854_24924 = state_24795__$1;
(statearr_24854_24924[(2)] = inst_24726);

(statearr_24854_24924[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (35))){
var state_24795__$1 = state_24795;
var statearr_24855_24925 = state_24795__$1;
(statearr_24855_24925[(2)] = true);

(statearr_24855_24925[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (19))){
var inst_24699 = (state_24795[(12)]);
var inst_24705 = figwheel.client.file_reloading.expand_files.call(null,inst_24699);
var state_24795__$1 = state_24795;
var statearr_24856_24926 = state_24795__$1;
(statearr_24856_24926[(2)] = inst_24705);

(statearr_24856_24926[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (11))){
var state_24795__$1 = state_24795;
var statearr_24857_24927 = state_24795__$1;
(statearr_24857_24927[(2)] = null);

(statearr_24857_24927[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (9))){
var inst_24688 = (state_24795[(2)]);
var state_24795__$1 = state_24795;
var statearr_24858_24928 = state_24795__$1;
(statearr_24858_24928[(2)] = inst_24688);

(statearr_24858_24928[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (5))){
var inst_24659 = (state_24795[(9)]);
var inst_24658 = (state_24795[(10)]);
var inst_24661 = (inst_24659 < inst_24658);
var inst_24662 = inst_24661;
var state_24795__$1 = state_24795;
if(cljs.core.truth_(inst_24662)){
var statearr_24859_24929 = state_24795__$1;
(statearr_24859_24929[(1)] = (7));

} else {
var statearr_24860_24930 = state_24795__$1;
(statearr_24860_24930[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (14))){
var inst_24669 = (state_24795[(22)]);
var inst_24678 = cljs.core.first.call(null,inst_24669);
var inst_24679 = figwheel.client.file_reloading.eval_body.call(null,inst_24678,opts);
var inst_24680 = cljs.core.next.call(null,inst_24669);
var inst_24656 = inst_24680;
var inst_24657 = null;
var inst_24658 = (0);
var inst_24659 = (0);
var state_24795__$1 = (function (){var statearr_24861 = state_24795;
(statearr_24861[(7)] = inst_24656);

(statearr_24861[(8)] = inst_24657);

(statearr_24861[(9)] = inst_24659);

(statearr_24861[(32)] = inst_24679);

(statearr_24861[(10)] = inst_24658);

return statearr_24861;
})();
var statearr_24862_24931 = state_24795__$1;
(statearr_24862_24931[(2)] = null);

(statearr_24862_24931[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (45))){
var state_24795__$1 = state_24795;
var statearr_24863_24932 = state_24795__$1;
(statearr_24863_24932[(2)] = null);

(statearr_24863_24932[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (26))){
var inst_24713 = (state_24795[(23)]);
var inst_24715 = (state_24795[(26)]);
var inst_24717 = (state_24795[(24)]);
var inst_24712 = (state_24795[(25)]);
var inst_24709 = (state_24795[(19)]);
var inst_24732 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_24734 = (function (){var all_files = inst_24709;
var res_SINGLEQUOTE_ = inst_24712;
var res = inst_24713;
var files_not_loaded = inst_24715;
var dependencies_that_loaded = inst_24717;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24713,inst_24715,inst_24717,inst_24712,inst_24709,inst_24732,state_val_24796,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__24733){
var map__24864 = p__24733;
var map__24864__$1 = ((((!((map__24864 == null)))?((((map__24864.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24864.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24864):map__24864);
var namespace = cljs.core.get.call(null,map__24864__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__24864__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24713,inst_24715,inst_24717,inst_24712,inst_24709,inst_24732,state_val_24796,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24735 = cljs.core.map.call(null,inst_24734,inst_24713);
var inst_24736 = cljs.core.pr_str.call(null,inst_24735);
var inst_24737 = figwheel.client.utils.log.call(null,inst_24736);
var inst_24738 = (function (){var all_files = inst_24709;
var res_SINGLEQUOTE_ = inst_24712;
var res = inst_24713;
var files_not_loaded = inst_24715;
var dependencies_that_loaded = inst_24717;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24713,inst_24715,inst_24717,inst_24712,inst_24709,inst_24732,inst_24734,inst_24735,inst_24736,inst_24737,state_val_24796,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_24713,inst_24715,inst_24717,inst_24712,inst_24709,inst_24732,inst_24734,inst_24735,inst_24736,inst_24737,state_val_24796,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_24739 = setTimeout(inst_24738,(10));
var state_24795__$1 = (function (){var statearr_24866 = state_24795;
(statearr_24866[(33)] = inst_24732);

(statearr_24866[(34)] = inst_24737);

return statearr_24866;
})();
var statearr_24867_24933 = state_24795__$1;
(statearr_24867_24933[(2)] = inst_24739);

(statearr_24867_24933[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (16))){
var state_24795__$1 = state_24795;
var statearr_24868_24934 = state_24795__$1;
(statearr_24868_24934[(2)] = reload_dependents);

(statearr_24868_24934[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (38))){
var inst_24749 = (state_24795[(16)]);
var inst_24766 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24749);
var state_24795__$1 = state_24795;
var statearr_24869_24935 = state_24795__$1;
(statearr_24869_24935[(2)] = inst_24766);

(statearr_24869_24935[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (30))){
var state_24795__$1 = state_24795;
var statearr_24870_24936 = state_24795__$1;
(statearr_24870_24936[(2)] = null);

(statearr_24870_24936[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (10))){
var inst_24669 = (state_24795[(22)]);
var inst_24671 = cljs.core.chunked_seq_QMARK_.call(null,inst_24669);
var state_24795__$1 = state_24795;
if(inst_24671){
var statearr_24871_24937 = state_24795__$1;
(statearr_24871_24937[(1)] = (13));

} else {
var statearr_24872_24938 = state_24795__$1;
(statearr_24872_24938[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (18))){
var inst_24703 = (state_24795[(2)]);
var state_24795__$1 = state_24795;
if(cljs.core.truth_(inst_24703)){
var statearr_24873_24939 = state_24795__$1;
(statearr_24873_24939[(1)] = (19));

} else {
var statearr_24874_24940 = state_24795__$1;
(statearr_24874_24940[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (42))){
var state_24795__$1 = state_24795;
var statearr_24875_24941 = state_24795__$1;
(statearr_24875_24941[(2)] = null);

(statearr_24875_24941[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (37))){
var inst_24761 = (state_24795[(2)]);
var state_24795__$1 = state_24795;
var statearr_24876_24942 = state_24795__$1;
(statearr_24876_24942[(2)] = inst_24761);

(statearr_24876_24942[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24796 === (8))){
var inst_24656 = (state_24795[(7)]);
var inst_24669 = (state_24795[(22)]);
var inst_24669__$1 = cljs.core.seq.call(null,inst_24656);
var state_24795__$1 = (function (){var statearr_24877 = state_24795;
(statearr_24877[(22)] = inst_24669__$1);

return statearr_24877;
})();
if(inst_24669__$1){
var statearr_24878_24943 = state_24795__$1;
(statearr_24878_24943[(1)] = (10));

} else {
var statearr_24879_24944 = state_24795__$1;
(statearr_24879_24944[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__18676__auto__,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__18677__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__18677__auto____0 = (function (){
var statearr_24883 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24883[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__18677__auto__);

(statearr_24883[(1)] = (1));

return statearr_24883;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__18677__auto____1 = (function (state_24795){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_24795);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e24884){if((e24884 instanceof Object)){
var ex__18680__auto__ = e24884;
var statearr_24885_24945 = state_24795;
(statearr_24885_24945[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24795);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24884;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24946 = state_24795;
state_24795 = G__24946;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__18677__auto__ = function(state_24795){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__18677__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__18677__auto____1.call(this,state_24795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__18677__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__18677__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__18743__auto__ = (function (){var statearr_24886 = f__18742__auto__.call(null);
(statearr_24886[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto__);

return statearr_24886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto__,map__24641,map__24641__$1,opts,before_jsload,on_jsload,reload_dependents,map__24642,map__24642__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__18741__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__24949,link){
var map__24952 = p__24949;
var map__24952__$1 = ((((!((map__24952 == null)))?((((map__24952.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24952.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24952):map__24952);
var file = cljs.core.get.call(null,map__24952__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = link.href;
if(cljs.core.truth_(temp__4425__auto__)){
var link_href = temp__4425__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4425__auto__,map__24952,map__24952__$1,file){
return (function (p1__24947_SHARP_,p2__24948_SHARP_){
if(cljs.core._EQ_.call(null,p1__24947_SHARP_,p2__24948_SHARP_)){
return p1__24947_SHARP_;
} else {
return false;
}
});})(link_href,temp__4425__auto__,map__24952,map__24952__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4425__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__24958){
var map__24959 = p__24958;
var map__24959__$1 = ((((!((map__24959 == null)))?((((map__24959.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24959.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24959):map__24959);
var match_length = cljs.core.get.call(null,map__24959__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__24959__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__24954_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__24954_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4425__auto__)){
var res = temp__4425__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args24961 = [];
var len__17716__auto___24964 = arguments.length;
var i__17717__auto___24965 = (0);
while(true){
if((i__17717__auto___24965 < len__17716__auto___24964)){
args24961.push((arguments[i__17717__auto___24965]));

var G__24966 = (i__17717__auto___24965 + (1));
i__17717__auto___24965 = G__24966;
continue;
} else {
}
break;
}

var G__24963 = args24961.length;
switch (G__24963) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24961.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__24968_SHARP_,p2__24969_SHARP_){
return cljs.core.assoc.call(null,p1__24968_SHARP_,cljs.core.get.call(null,p2__24969_SHARP_,key),p2__24969_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__24970){
var map__24973 = p__24970;
var map__24973__$1 = ((((!((map__24973 == null)))?((((map__24973.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24973.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24973):map__24973);
var f_data = map__24973__$1;
var file = cljs.core.get.call(null,map__24973__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4425__auto__)){
var link = temp__4425__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__24975,files_msg){
var map__24982 = p__24975;
var map__24982__$1 = ((((!((map__24982 == null)))?((((map__24982.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24982.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24982):map__24982);
var opts = map__24982__$1;
var on_cssload = cljs.core.get.call(null,map__24982__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__24984_24988 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__24985_24989 = null;
var count__24986_24990 = (0);
var i__24987_24991 = (0);
while(true){
if((i__24987_24991 < count__24986_24990)){
var f_24992 = cljs.core._nth.call(null,chunk__24985_24989,i__24987_24991);
figwheel.client.file_reloading.reload_css_file.call(null,f_24992);

var G__24993 = seq__24984_24988;
var G__24994 = chunk__24985_24989;
var G__24995 = count__24986_24990;
var G__24996 = (i__24987_24991 + (1));
seq__24984_24988 = G__24993;
chunk__24985_24989 = G__24994;
count__24986_24990 = G__24995;
i__24987_24991 = G__24996;
continue;
} else {
var temp__4425__auto___24997 = cljs.core.seq.call(null,seq__24984_24988);
if(temp__4425__auto___24997){
var seq__24984_24998__$1 = temp__4425__auto___24997;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24984_24998__$1)){
var c__17461__auto___24999 = cljs.core.chunk_first.call(null,seq__24984_24998__$1);
var G__25000 = cljs.core.chunk_rest.call(null,seq__24984_24998__$1);
var G__25001 = c__17461__auto___24999;
var G__25002 = cljs.core.count.call(null,c__17461__auto___24999);
var G__25003 = (0);
seq__24984_24988 = G__25000;
chunk__24985_24989 = G__25001;
count__24986_24990 = G__25002;
i__24987_24991 = G__25003;
continue;
} else {
var f_25004 = cljs.core.first.call(null,seq__24984_24998__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_25004);

var G__25005 = cljs.core.next.call(null,seq__24984_24998__$1);
var G__25006 = null;
var G__25007 = (0);
var G__25008 = (0);
seq__24984_24988 = G__25005;
chunk__24985_24989 = G__25006;
count__24986_24990 = G__25007;
i__24987_24991 = G__25008;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__24982,map__24982__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__24982,map__24982__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map