// Compiled by ClojureScript 1.7.122 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args25072 = [];
var len__17716__auto___25078 = arguments.length;
var i__17717__auto___25079 = (0);
while(true){
if((i__17717__auto___25079 < len__17716__auto___25078)){
args25072.push((arguments[i__17717__auto___25079]));

var G__25080 = (i__17717__auto___25079 + (1));
i__17717__auto___25079 = G__25080;
continue;
} else {
}
break;
}

var G__25074 = args25072.length;
switch (G__25074) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25072.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async25075 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25075 = (function (f,blockable,meta25076){
this.f = f;
this.blockable = blockable;
this.meta25076 = meta25076;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25075.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25077,meta25076__$1){
var self__ = this;
var _25077__$1 = this;
return (new cljs.core.async.t_cljs$core$async25075(self__.f,self__.blockable,meta25076__$1));
});

cljs.core.async.t_cljs$core$async25075.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25077){
var self__ = this;
var _25077__$1 = this;
return self__.meta25076;
});

cljs.core.async.t_cljs$core$async25075.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async25075.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async25075.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async25075.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async25075.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta25076","meta25076",299347785,null)], null);
});

cljs.core.async.t_cljs$core$async25075.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25075.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25075";

cljs.core.async.t_cljs$core$async25075.cljs$lang$ctorPrWriter = (function (this__17256__auto__,writer__17257__auto__,opt__17258__auto__){
return cljs.core._write.call(null,writer__17257__auto__,"cljs.core.async/t_cljs$core$async25075");
});

cljs.core.async.__GT_t_cljs$core$async25075 = (function cljs$core$async$__GT_t_cljs$core$async25075(f__$1,blockable__$1,meta25076){
return (new cljs.core.async.t_cljs$core$async25075(f__$1,blockable__$1,meta25076));
});

}

return (new cljs.core.async.t_cljs$core$async25075(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args25084 = [];
var len__17716__auto___25087 = arguments.length;
var i__17717__auto___25088 = (0);
while(true){
if((i__17717__auto___25088 < len__17716__auto___25087)){
args25084.push((arguments[i__17717__auto___25088]));

var G__25089 = (i__17717__auto___25088 + (1));
i__17717__auto___25088 = G__25089;
continue;
} else {
}
break;
}

var G__25086 = args25084.length;
switch (G__25086) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25084.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args25091 = [];
var len__17716__auto___25094 = arguments.length;
var i__17717__auto___25095 = (0);
while(true){
if((i__17717__auto___25095 < len__17716__auto___25094)){
args25091.push((arguments[i__17717__auto___25095]));

var G__25096 = (i__17717__auto___25095 + (1));
i__17717__auto___25095 = G__25096;
continue;
} else {
}
break;
}

var G__25093 = args25091.length;
switch (G__25093) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25091.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args25098 = [];
var len__17716__auto___25101 = arguments.length;
var i__17717__auto___25102 = (0);
while(true){
if((i__17717__auto___25102 < len__17716__auto___25101)){
args25098.push((arguments[i__17717__auto___25102]));

var G__25103 = (i__17717__auto___25102 + (1));
i__17717__auto___25102 = G__25103;
continue;
} else {
}
break;
}

var G__25100 = args25098.length;
switch (G__25100) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25098.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_25105 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_25105);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_25105,ret){
return (function (){
return fn1.call(null,val_25105);
});})(val_25105,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args25106 = [];
var len__17716__auto___25109 = arguments.length;
var i__17717__auto___25110 = (0);
while(true){
if((i__17717__auto___25110 < len__17716__auto___25109)){
args25106.push((arguments[i__17717__auto___25110]));

var G__25111 = (i__17717__auto___25110 + (1));
i__17717__auto___25110 = G__25111;
continue;
} else {
}
break;
}

var G__25108 = args25106.length;
switch (G__25108) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25106.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__17561__auto___25113 = n;
var x_25114 = (0);
while(true){
if((x_25114 < n__17561__auto___25113)){
(a[x_25114] = (0));

var G__25115 = (x_25114 + (1));
x_25114 = G__25115;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__25116 = (i + (1));
i = G__25116;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async25120 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25120 = (function (alt_flag,flag,meta25121){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta25121 = meta25121;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25120.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_25122,meta25121__$1){
var self__ = this;
var _25122__$1 = this;
return (new cljs.core.async.t_cljs$core$async25120(self__.alt_flag,self__.flag,meta25121__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async25120.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_25122){
var self__ = this;
var _25122__$1 = this;
return self__.meta25121;
});})(flag))
;

cljs.core.async.t_cljs$core$async25120.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async25120.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async25120.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async25120.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async25120.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta25121","meta25121",995768235,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async25120.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25120.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25120";

cljs.core.async.t_cljs$core$async25120.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__17256__auto__,writer__17257__auto__,opt__17258__auto__){
return cljs.core._write.call(null,writer__17257__auto__,"cljs.core.async/t_cljs$core$async25120");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async25120 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async25120(alt_flag__$1,flag__$1,meta25121){
return (new cljs.core.async.t_cljs$core$async25120(alt_flag__$1,flag__$1,meta25121));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async25120(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async25126 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25126 = (function (alt_handler,flag,cb,meta25127){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta25127 = meta25127;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25126.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25128,meta25127__$1){
var self__ = this;
var _25128__$1 = this;
return (new cljs.core.async.t_cljs$core$async25126(self__.alt_handler,self__.flag,self__.cb,meta25127__$1));
});

cljs.core.async.t_cljs$core$async25126.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25128){
var self__ = this;
var _25128__$1 = this;
return self__.meta25127;
});

cljs.core.async.t_cljs$core$async25126.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async25126.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async25126.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async25126.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async25126.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta25127","meta25127",-369113269,null)], null);
});

cljs.core.async.t_cljs$core$async25126.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25126.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25126";

cljs.core.async.t_cljs$core$async25126.cljs$lang$ctorPrWriter = (function (this__17256__auto__,writer__17257__auto__,opt__17258__auto__){
return cljs.core._write.call(null,writer__17257__auto__,"cljs.core.async/t_cljs$core$async25126");
});

cljs.core.async.__GT_t_cljs$core$async25126 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async25126(alt_handler__$1,flag__$1,cb__$1,meta25127){
return (new cljs.core.async.t_cljs$core$async25126(alt_handler__$1,flag__$1,cb__$1,meta25127));
});

}

return (new cljs.core.async.t_cljs$core$async25126(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__25129_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25129_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__25130_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25130_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__16658__auto__ = wport;
if(cljs.core.truth_(or__16658__auto__)){
return or__16658__auto__;
} else {
return port;
}
})()], null));
} else {
var G__25131 = (i + (1));
i = G__25131;
continue;
}
} else {
return null;
}
break;
}
})();
var or__16658__auto__ = ret;
if(cljs.core.truth_(or__16658__auto__)){
return or__16658__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__16646__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__16646__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__16646__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__17723__auto__ = [];
var len__17716__auto___25137 = arguments.length;
var i__17717__auto___25138 = (0);
while(true){
if((i__17717__auto___25138 < len__17716__auto___25137)){
args__17723__auto__.push((arguments[i__17717__auto___25138]));

var G__25139 = (i__17717__auto___25138 + (1));
i__17717__auto___25138 = G__25139;
continue;
} else {
}
break;
}

var argseq__17724__auto__ = ((((1) < args__17723__auto__.length))?(new cljs.core.IndexedSeq(args__17723__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17724__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__25134){
var map__25135 = p__25134;
var map__25135__$1 = ((((!((map__25135 == null)))?((((map__25135.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25135.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25135):map__25135);
var opts = map__25135__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq25132){
var G__25133 = cljs.core.first.call(null,seq25132);
var seq25132__$1 = cljs.core.next.call(null,seq25132);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__25133,seq25132__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args25140 = [];
var len__17716__auto___25190 = arguments.length;
var i__17717__auto___25191 = (0);
while(true){
if((i__17717__auto___25191 < len__17716__auto___25190)){
args25140.push((arguments[i__17717__auto___25191]));

var G__25192 = (i__17717__auto___25191 + (1));
i__17717__auto___25191 = G__25192;
continue;
} else {
}
break;
}

var G__25142 = args25140.length;
switch (G__25142) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25140.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__18741__auto___25194 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___25194){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___25194){
return (function (state_25166){
var state_val_25167 = (state_25166[(1)]);
if((state_val_25167 === (7))){
var inst_25162 = (state_25166[(2)]);
var state_25166__$1 = state_25166;
var statearr_25168_25195 = state_25166__$1;
(statearr_25168_25195[(2)] = inst_25162);

(statearr_25168_25195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25167 === (1))){
var state_25166__$1 = state_25166;
var statearr_25169_25196 = state_25166__$1;
(statearr_25169_25196[(2)] = null);

(statearr_25169_25196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25167 === (4))){
var inst_25145 = (state_25166[(7)]);
var inst_25145__$1 = (state_25166[(2)]);
var inst_25146 = (inst_25145__$1 == null);
var state_25166__$1 = (function (){var statearr_25170 = state_25166;
(statearr_25170[(7)] = inst_25145__$1);

return statearr_25170;
})();
if(cljs.core.truth_(inst_25146)){
var statearr_25171_25197 = state_25166__$1;
(statearr_25171_25197[(1)] = (5));

} else {
var statearr_25172_25198 = state_25166__$1;
(statearr_25172_25198[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25167 === (13))){
var state_25166__$1 = state_25166;
var statearr_25173_25199 = state_25166__$1;
(statearr_25173_25199[(2)] = null);

(statearr_25173_25199[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25167 === (6))){
var inst_25145 = (state_25166[(7)]);
var state_25166__$1 = state_25166;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25166__$1,(11),to,inst_25145);
} else {
if((state_val_25167 === (3))){
var inst_25164 = (state_25166[(2)]);
var state_25166__$1 = state_25166;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25166__$1,inst_25164);
} else {
if((state_val_25167 === (12))){
var state_25166__$1 = state_25166;
var statearr_25174_25200 = state_25166__$1;
(statearr_25174_25200[(2)] = null);

(statearr_25174_25200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25167 === (2))){
var state_25166__$1 = state_25166;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25166__$1,(4),from);
} else {
if((state_val_25167 === (11))){
var inst_25155 = (state_25166[(2)]);
var state_25166__$1 = state_25166;
if(cljs.core.truth_(inst_25155)){
var statearr_25175_25201 = state_25166__$1;
(statearr_25175_25201[(1)] = (12));

} else {
var statearr_25176_25202 = state_25166__$1;
(statearr_25176_25202[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25167 === (9))){
var state_25166__$1 = state_25166;
var statearr_25177_25203 = state_25166__$1;
(statearr_25177_25203[(2)] = null);

(statearr_25177_25203[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25167 === (5))){
var state_25166__$1 = state_25166;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25178_25204 = state_25166__$1;
(statearr_25178_25204[(1)] = (8));

} else {
var statearr_25179_25205 = state_25166__$1;
(statearr_25179_25205[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25167 === (14))){
var inst_25160 = (state_25166[(2)]);
var state_25166__$1 = state_25166;
var statearr_25180_25206 = state_25166__$1;
(statearr_25180_25206[(2)] = inst_25160);

(statearr_25180_25206[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25167 === (10))){
var inst_25152 = (state_25166[(2)]);
var state_25166__$1 = state_25166;
var statearr_25181_25207 = state_25166__$1;
(statearr_25181_25207[(2)] = inst_25152);

(statearr_25181_25207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25167 === (8))){
var inst_25149 = cljs.core.async.close_BANG_.call(null,to);
var state_25166__$1 = state_25166;
var statearr_25182_25208 = state_25166__$1;
(statearr_25182_25208[(2)] = inst_25149);

(statearr_25182_25208[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto___25194))
;
return ((function (switch__18676__auto__,c__18741__auto___25194){
return (function() {
var cljs$core$async$state_machine__18677__auto__ = null;
var cljs$core$async$state_machine__18677__auto____0 = (function (){
var statearr_25186 = [null,null,null,null,null,null,null,null];
(statearr_25186[(0)] = cljs$core$async$state_machine__18677__auto__);

(statearr_25186[(1)] = (1));

return statearr_25186;
});
var cljs$core$async$state_machine__18677__auto____1 = (function (state_25166){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_25166);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e25187){if((e25187 instanceof Object)){
var ex__18680__auto__ = e25187;
var statearr_25188_25209 = state_25166;
(statearr_25188_25209[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25166);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25187;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25210 = state_25166;
state_25166 = G__25210;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$state_machine__18677__auto__ = function(state_25166){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18677__auto____1.call(this,state_25166);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18677__auto____0;
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18677__auto____1;
return cljs$core$async$state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___25194))
})();
var state__18743__auto__ = (function (){var statearr_25189 = f__18742__auto__.call(null);
(statearr_25189[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___25194);

return statearr_25189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___25194))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__25394){
var vec__25395 = p__25394;
var v = cljs.core.nth.call(null,vec__25395,(0),null);
var p = cljs.core.nth.call(null,vec__25395,(1),null);
var job = vec__25395;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__18741__auto___25577 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___25577,res,vec__25395,v,p,job,jobs,results){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___25577,res,vec__25395,v,p,job,jobs,results){
return (function (state_25400){
var state_val_25401 = (state_25400[(1)]);
if((state_val_25401 === (1))){
var state_25400__$1 = state_25400;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25400__$1,(2),res,v);
} else {
if((state_val_25401 === (2))){
var inst_25397 = (state_25400[(2)]);
var inst_25398 = cljs.core.async.close_BANG_.call(null,res);
var state_25400__$1 = (function (){var statearr_25402 = state_25400;
(statearr_25402[(7)] = inst_25397);

return statearr_25402;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25400__$1,inst_25398);
} else {
return null;
}
}
});})(c__18741__auto___25577,res,vec__25395,v,p,job,jobs,results))
;
return ((function (switch__18676__auto__,c__18741__auto___25577,res,vec__25395,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0 = (function (){
var statearr_25406 = [null,null,null,null,null,null,null,null];
(statearr_25406[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__);

(statearr_25406[(1)] = (1));

return statearr_25406;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1 = (function (state_25400){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_25400);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e25407){if((e25407 instanceof Object)){
var ex__18680__auto__ = e25407;
var statearr_25408_25578 = state_25400;
(statearr_25408_25578[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25400);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25407;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25579 = state_25400;
state_25400 = G__25579;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__ = function(state_25400){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1.call(this,state_25400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___25577,res,vec__25395,v,p,job,jobs,results))
})();
var state__18743__auto__ = (function (){var statearr_25409 = f__18742__auto__.call(null);
(statearr_25409[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___25577);

return statearr_25409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___25577,res,vec__25395,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__25410){
var vec__25411 = p__25410;
var v = cljs.core.nth.call(null,vec__25411,(0),null);
var p = cljs.core.nth.call(null,vec__25411,(1),null);
var job = vec__25411;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__17561__auto___25580 = n;
var __25581 = (0);
while(true){
if((__25581 < n__17561__auto___25580)){
var G__25412_25582 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__25412_25582) {
case "compute":
var c__18741__auto___25584 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__25581,c__18741__auto___25584,G__25412_25582,n__17561__auto___25580,jobs,results,process,async){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (__25581,c__18741__auto___25584,G__25412_25582,n__17561__auto___25580,jobs,results,process,async){
return (function (state_25425){
var state_val_25426 = (state_25425[(1)]);
if((state_val_25426 === (1))){
var state_25425__$1 = state_25425;
var statearr_25427_25585 = state_25425__$1;
(statearr_25427_25585[(2)] = null);

(statearr_25427_25585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25426 === (2))){
var state_25425__$1 = state_25425;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25425__$1,(4),jobs);
} else {
if((state_val_25426 === (3))){
var inst_25423 = (state_25425[(2)]);
var state_25425__$1 = state_25425;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25425__$1,inst_25423);
} else {
if((state_val_25426 === (4))){
var inst_25415 = (state_25425[(2)]);
var inst_25416 = process.call(null,inst_25415);
var state_25425__$1 = state_25425;
if(cljs.core.truth_(inst_25416)){
var statearr_25428_25586 = state_25425__$1;
(statearr_25428_25586[(1)] = (5));

} else {
var statearr_25429_25587 = state_25425__$1;
(statearr_25429_25587[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25426 === (5))){
var state_25425__$1 = state_25425;
var statearr_25430_25588 = state_25425__$1;
(statearr_25430_25588[(2)] = null);

(statearr_25430_25588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25426 === (6))){
var state_25425__$1 = state_25425;
var statearr_25431_25589 = state_25425__$1;
(statearr_25431_25589[(2)] = null);

(statearr_25431_25589[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25426 === (7))){
var inst_25421 = (state_25425[(2)]);
var state_25425__$1 = state_25425;
var statearr_25432_25590 = state_25425__$1;
(statearr_25432_25590[(2)] = inst_25421);

(statearr_25432_25590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__25581,c__18741__auto___25584,G__25412_25582,n__17561__auto___25580,jobs,results,process,async))
;
return ((function (__25581,switch__18676__auto__,c__18741__auto___25584,G__25412_25582,n__17561__auto___25580,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0 = (function (){
var statearr_25436 = [null,null,null,null,null,null,null];
(statearr_25436[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__);

(statearr_25436[(1)] = (1));

return statearr_25436;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1 = (function (state_25425){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_25425);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e25437){if((e25437 instanceof Object)){
var ex__18680__auto__ = e25437;
var statearr_25438_25591 = state_25425;
(statearr_25438_25591[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25425);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25437;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25592 = state_25425;
state_25425 = G__25592;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__ = function(state_25425){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1.call(this,state_25425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__;
})()
;})(__25581,switch__18676__auto__,c__18741__auto___25584,G__25412_25582,n__17561__auto___25580,jobs,results,process,async))
})();
var state__18743__auto__ = (function (){var statearr_25439 = f__18742__auto__.call(null);
(statearr_25439[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___25584);

return statearr_25439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(__25581,c__18741__auto___25584,G__25412_25582,n__17561__auto___25580,jobs,results,process,async))
);


break;
case "async":
var c__18741__auto___25593 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__25581,c__18741__auto___25593,G__25412_25582,n__17561__auto___25580,jobs,results,process,async){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (__25581,c__18741__auto___25593,G__25412_25582,n__17561__auto___25580,jobs,results,process,async){
return (function (state_25452){
var state_val_25453 = (state_25452[(1)]);
if((state_val_25453 === (1))){
var state_25452__$1 = state_25452;
var statearr_25454_25594 = state_25452__$1;
(statearr_25454_25594[(2)] = null);

(statearr_25454_25594[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25453 === (2))){
var state_25452__$1 = state_25452;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25452__$1,(4),jobs);
} else {
if((state_val_25453 === (3))){
var inst_25450 = (state_25452[(2)]);
var state_25452__$1 = state_25452;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25452__$1,inst_25450);
} else {
if((state_val_25453 === (4))){
var inst_25442 = (state_25452[(2)]);
var inst_25443 = async.call(null,inst_25442);
var state_25452__$1 = state_25452;
if(cljs.core.truth_(inst_25443)){
var statearr_25455_25595 = state_25452__$1;
(statearr_25455_25595[(1)] = (5));

} else {
var statearr_25456_25596 = state_25452__$1;
(statearr_25456_25596[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25453 === (5))){
var state_25452__$1 = state_25452;
var statearr_25457_25597 = state_25452__$1;
(statearr_25457_25597[(2)] = null);

(statearr_25457_25597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25453 === (6))){
var state_25452__$1 = state_25452;
var statearr_25458_25598 = state_25452__$1;
(statearr_25458_25598[(2)] = null);

(statearr_25458_25598[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25453 === (7))){
var inst_25448 = (state_25452[(2)]);
var state_25452__$1 = state_25452;
var statearr_25459_25599 = state_25452__$1;
(statearr_25459_25599[(2)] = inst_25448);

(statearr_25459_25599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__25581,c__18741__auto___25593,G__25412_25582,n__17561__auto___25580,jobs,results,process,async))
;
return ((function (__25581,switch__18676__auto__,c__18741__auto___25593,G__25412_25582,n__17561__auto___25580,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0 = (function (){
var statearr_25463 = [null,null,null,null,null,null,null];
(statearr_25463[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__);

(statearr_25463[(1)] = (1));

return statearr_25463;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1 = (function (state_25452){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_25452);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e25464){if((e25464 instanceof Object)){
var ex__18680__auto__ = e25464;
var statearr_25465_25600 = state_25452;
(statearr_25465_25600[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25452);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25464;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25601 = state_25452;
state_25452 = G__25601;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__ = function(state_25452){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1.call(this,state_25452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__;
})()
;})(__25581,switch__18676__auto__,c__18741__auto___25593,G__25412_25582,n__17561__auto___25580,jobs,results,process,async))
})();
var state__18743__auto__ = (function (){var statearr_25466 = f__18742__auto__.call(null);
(statearr_25466[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___25593);

return statearr_25466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(__25581,c__18741__auto___25593,G__25412_25582,n__17561__auto___25580,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__25602 = (__25581 + (1));
__25581 = G__25602;
continue;
} else {
}
break;
}

var c__18741__auto___25603 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___25603,jobs,results,process,async){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___25603,jobs,results,process,async){
return (function (state_25488){
var state_val_25489 = (state_25488[(1)]);
if((state_val_25489 === (1))){
var state_25488__$1 = state_25488;
var statearr_25490_25604 = state_25488__$1;
(statearr_25490_25604[(2)] = null);

(statearr_25490_25604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25489 === (2))){
var state_25488__$1 = state_25488;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25488__$1,(4),from);
} else {
if((state_val_25489 === (3))){
var inst_25486 = (state_25488[(2)]);
var state_25488__$1 = state_25488;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25488__$1,inst_25486);
} else {
if((state_val_25489 === (4))){
var inst_25469 = (state_25488[(7)]);
var inst_25469__$1 = (state_25488[(2)]);
var inst_25470 = (inst_25469__$1 == null);
var state_25488__$1 = (function (){var statearr_25491 = state_25488;
(statearr_25491[(7)] = inst_25469__$1);

return statearr_25491;
})();
if(cljs.core.truth_(inst_25470)){
var statearr_25492_25605 = state_25488__$1;
(statearr_25492_25605[(1)] = (5));

} else {
var statearr_25493_25606 = state_25488__$1;
(statearr_25493_25606[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25489 === (5))){
var inst_25472 = cljs.core.async.close_BANG_.call(null,jobs);
var state_25488__$1 = state_25488;
var statearr_25494_25607 = state_25488__$1;
(statearr_25494_25607[(2)] = inst_25472);

(statearr_25494_25607[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25489 === (6))){
var inst_25469 = (state_25488[(7)]);
var inst_25474 = (state_25488[(8)]);
var inst_25474__$1 = cljs.core.async.chan.call(null,(1));
var inst_25475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25476 = [inst_25469,inst_25474__$1];
var inst_25477 = (new cljs.core.PersistentVector(null,2,(5),inst_25475,inst_25476,null));
var state_25488__$1 = (function (){var statearr_25495 = state_25488;
(statearr_25495[(8)] = inst_25474__$1);

return statearr_25495;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25488__$1,(8),jobs,inst_25477);
} else {
if((state_val_25489 === (7))){
var inst_25484 = (state_25488[(2)]);
var state_25488__$1 = state_25488;
var statearr_25496_25608 = state_25488__$1;
(statearr_25496_25608[(2)] = inst_25484);

(statearr_25496_25608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25489 === (8))){
var inst_25474 = (state_25488[(8)]);
var inst_25479 = (state_25488[(2)]);
var state_25488__$1 = (function (){var statearr_25497 = state_25488;
(statearr_25497[(9)] = inst_25479);

return statearr_25497;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25488__$1,(9),results,inst_25474);
} else {
if((state_val_25489 === (9))){
var inst_25481 = (state_25488[(2)]);
var state_25488__$1 = (function (){var statearr_25498 = state_25488;
(statearr_25498[(10)] = inst_25481);

return statearr_25498;
})();
var statearr_25499_25609 = state_25488__$1;
(statearr_25499_25609[(2)] = null);

(statearr_25499_25609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__18741__auto___25603,jobs,results,process,async))
;
return ((function (switch__18676__auto__,c__18741__auto___25603,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0 = (function (){
var statearr_25503 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25503[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__);

(statearr_25503[(1)] = (1));

return statearr_25503;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1 = (function (state_25488){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_25488);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e25504){if((e25504 instanceof Object)){
var ex__18680__auto__ = e25504;
var statearr_25505_25610 = state_25488;
(statearr_25505_25610[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25488);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25504;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25611 = state_25488;
state_25488 = G__25611;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__ = function(state_25488){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1.call(this,state_25488);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___25603,jobs,results,process,async))
})();
var state__18743__auto__ = (function (){var statearr_25506 = f__18742__auto__.call(null);
(statearr_25506[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___25603);

return statearr_25506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___25603,jobs,results,process,async))
);


var c__18741__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto__,jobs,results,process,async){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto__,jobs,results,process,async){
return (function (state_25544){
var state_val_25545 = (state_25544[(1)]);
if((state_val_25545 === (7))){
var inst_25540 = (state_25544[(2)]);
var state_25544__$1 = state_25544;
var statearr_25546_25612 = state_25544__$1;
(statearr_25546_25612[(2)] = inst_25540);

(statearr_25546_25612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (20))){
var state_25544__$1 = state_25544;
var statearr_25547_25613 = state_25544__$1;
(statearr_25547_25613[(2)] = null);

(statearr_25547_25613[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (1))){
var state_25544__$1 = state_25544;
var statearr_25548_25614 = state_25544__$1;
(statearr_25548_25614[(2)] = null);

(statearr_25548_25614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (4))){
var inst_25509 = (state_25544[(7)]);
var inst_25509__$1 = (state_25544[(2)]);
var inst_25510 = (inst_25509__$1 == null);
var state_25544__$1 = (function (){var statearr_25549 = state_25544;
(statearr_25549[(7)] = inst_25509__$1);

return statearr_25549;
})();
if(cljs.core.truth_(inst_25510)){
var statearr_25550_25615 = state_25544__$1;
(statearr_25550_25615[(1)] = (5));

} else {
var statearr_25551_25616 = state_25544__$1;
(statearr_25551_25616[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (15))){
var inst_25522 = (state_25544[(8)]);
var state_25544__$1 = state_25544;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25544__$1,(18),to,inst_25522);
} else {
if((state_val_25545 === (21))){
var inst_25535 = (state_25544[(2)]);
var state_25544__$1 = state_25544;
var statearr_25552_25617 = state_25544__$1;
(statearr_25552_25617[(2)] = inst_25535);

(statearr_25552_25617[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (13))){
var inst_25537 = (state_25544[(2)]);
var state_25544__$1 = (function (){var statearr_25553 = state_25544;
(statearr_25553[(9)] = inst_25537);

return statearr_25553;
})();
var statearr_25554_25618 = state_25544__$1;
(statearr_25554_25618[(2)] = null);

(statearr_25554_25618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (6))){
var inst_25509 = (state_25544[(7)]);
var state_25544__$1 = state_25544;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25544__$1,(11),inst_25509);
} else {
if((state_val_25545 === (17))){
var inst_25530 = (state_25544[(2)]);
var state_25544__$1 = state_25544;
if(cljs.core.truth_(inst_25530)){
var statearr_25555_25619 = state_25544__$1;
(statearr_25555_25619[(1)] = (19));

} else {
var statearr_25556_25620 = state_25544__$1;
(statearr_25556_25620[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (3))){
var inst_25542 = (state_25544[(2)]);
var state_25544__$1 = state_25544;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25544__$1,inst_25542);
} else {
if((state_val_25545 === (12))){
var inst_25519 = (state_25544[(10)]);
var state_25544__$1 = state_25544;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25544__$1,(14),inst_25519);
} else {
if((state_val_25545 === (2))){
var state_25544__$1 = state_25544;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25544__$1,(4),results);
} else {
if((state_val_25545 === (19))){
var state_25544__$1 = state_25544;
var statearr_25557_25621 = state_25544__$1;
(statearr_25557_25621[(2)] = null);

(statearr_25557_25621[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (11))){
var inst_25519 = (state_25544[(2)]);
var state_25544__$1 = (function (){var statearr_25558 = state_25544;
(statearr_25558[(10)] = inst_25519);

return statearr_25558;
})();
var statearr_25559_25622 = state_25544__$1;
(statearr_25559_25622[(2)] = null);

(statearr_25559_25622[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (9))){
var state_25544__$1 = state_25544;
var statearr_25560_25623 = state_25544__$1;
(statearr_25560_25623[(2)] = null);

(statearr_25560_25623[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (5))){
var state_25544__$1 = state_25544;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25561_25624 = state_25544__$1;
(statearr_25561_25624[(1)] = (8));

} else {
var statearr_25562_25625 = state_25544__$1;
(statearr_25562_25625[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (14))){
var inst_25524 = (state_25544[(11)]);
var inst_25522 = (state_25544[(8)]);
var inst_25522__$1 = (state_25544[(2)]);
var inst_25523 = (inst_25522__$1 == null);
var inst_25524__$1 = cljs.core.not.call(null,inst_25523);
var state_25544__$1 = (function (){var statearr_25563 = state_25544;
(statearr_25563[(11)] = inst_25524__$1);

(statearr_25563[(8)] = inst_25522__$1);

return statearr_25563;
})();
if(inst_25524__$1){
var statearr_25564_25626 = state_25544__$1;
(statearr_25564_25626[(1)] = (15));

} else {
var statearr_25565_25627 = state_25544__$1;
(statearr_25565_25627[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (16))){
var inst_25524 = (state_25544[(11)]);
var state_25544__$1 = state_25544;
var statearr_25566_25628 = state_25544__$1;
(statearr_25566_25628[(2)] = inst_25524);

(statearr_25566_25628[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (10))){
var inst_25516 = (state_25544[(2)]);
var state_25544__$1 = state_25544;
var statearr_25567_25629 = state_25544__$1;
(statearr_25567_25629[(2)] = inst_25516);

(statearr_25567_25629[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (18))){
var inst_25527 = (state_25544[(2)]);
var state_25544__$1 = state_25544;
var statearr_25568_25630 = state_25544__$1;
(statearr_25568_25630[(2)] = inst_25527);

(statearr_25568_25630[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25545 === (8))){
var inst_25513 = cljs.core.async.close_BANG_.call(null,to);
var state_25544__$1 = state_25544;
var statearr_25569_25631 = state_25544__$1;
(statearr_25569_25631[(2)] = inst_25513);

(statearr_25569_25631[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto__,jobs,results,process,async))
;
return ((function (switch__18676__auto__,c__18741__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0 = (function (){
var statearr_25573 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25573[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__);

(statearr_25573[(1)] = (1));

return statearr_25573;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1 = (function (state_25544){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_25544);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e25574){if((e25574 instanceof Object)){
var ex__18680__auto__ = e25574;
var statearr_25575_25632 = state_25544;
(statearr_25575_25632[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25544);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25574;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25633 = state_25544;
state_25544 = G__25633;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__ = function(state_25544){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1.call(this,state_25544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18677__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto__,jobs,results,process,async))
})();
var state__18743__auto__ = (function (){var statearr_25576 = f__18742__auto__.call(null);
(statearr_25576[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto__);

return statearr_25576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto__,jobs,results,process,async))
);

return c__18741__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args25634 = [];
var len__17716__auto___25637 = arguments.length;
var i__17717__auto___25638 = (0);
while(true){
if((i__17717__auto___25638 < len__17716__auto___25637)){
args25634.push((arguments[i__17717__auto___25638]));

var G__25639 = (i__17717__auto___25638 + (1));
i__17717__auto___25638 = G__25639;
continue;
} else {
}
break;
}

var G__25636 = args25634.length;
switch (G__25636) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25634.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args25641 = [];
var len__17716__auto___25644 = arguments.length;
var i__17717__auto___25645 = (0);
while(true){
if((i__17717__auto___25645 < len__17716__auto___25644)){
args25641.push((arguments[i__17717__auto___25645]));

var G__25646 = (i__17717__auto___25645 + (1));
i__17717__auto___25645 = G__25646;
continue;
} else {
}
break;
}

var G__25643 = args25641.length;
switch (G__25643) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25641.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args25648 = [];
var len__17716__auto___25701 = arguments.length;
var i__17717__auto___25702 = (0);
while(true){
if((i__17717__auto___25702 < len__17716__auto___25701)){
args25648.push((arguments[i__17717__auto___25702]));

var G__25703 = (i__17717__auto___25702 + (1));
i__17717__auto___25702 = G__25703;
continue;
} else {
}
break;
}

var G__25650 = args25648.length;
switch (G__25650) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25648.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__18741__auto___25705 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___25705,tc,fc){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___25705,tc,fc){
return (function (state_25676){
var state_val_25677 = (state_25676[(1)]);
if((state_val_25677 === (7))){
var inst_25672 = (state_25676[(2)]);
var state_25676__$1 = state_25676;
var statearr_25678_25706 = state_25676__$1;
(statearr_25678_25706[(2)] = inst_25672);

(statearr_25678_25706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25677 === (1))){
var state_25676__$1 = state_25676;
var statearr_25679_25707 = state_25676__$1;
(statearr_25679_25707[(2)] = null);

(statearr_25679_25707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25677 === (4))){
var inst_25653 = (state_25676[(7)]);
var inst_25653__$1 = (state_25676[(2)]);
var inst_25654 = (inst_25653__$1 == null);
var state_25676__$1 = (function (){var statearr_25680 = state_25676;
(statearr_25680[(7)] = inst_25653__$1);

return statearr_25680;
})();
if(cljs.core.truth_(inst_25654)){
var statearr_25681_25708 = state_25676__$1;
(statearr_25681_25708[(1)] = (5));

} else {
var statearr_25682_25709 = state_25676__$1;
(statearr_25682_25709[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25677 === (13))){
var state_25676__$1 = state_25676;
var statearr_25683_25710 = state_25676__$1;
(statearr_25683_25710[(2)] = null);

(statearr_25683_25710[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25677 === (6))){
var inst_25653 = (state_25676[(7)]);
var inst_25659 = p.call(null,inst_25653);
var state_25676__$1 = state_25676;
if(cljs.core.truth_(inst_25659)){
var statearr_25684_25711 = state_25676__$1;
(statearr_25684_25711[(1)] = (9));

} else {
var statearr_25685_25712 = state_25676__$1;
(statearr_25685_25712[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25677 === (3))){
var inst_25674 = (state_25676[(2)]);
var state_25676__$1 = state_25676;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25676__$1,inst_25674);
} else {
if((state_val_25677 === (12))){
var state_25676__$1 = state_25676;
var statearr_25686_25713 = state_25676__$1;
(statearr_25686_25713[(2)] = null);

(statearr_25686_25713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25677 === (2))){
var state_25676__$1 = state_25676;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25676__$1,(4),ch);
} else {
if((state_val_25677 === (11))){
var inst_25653 = (state_25676[(7)]);
var inst_25663 = (state_25676[(2)]);
var state_25676__$1 = state_25676;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25676__$1,(8),inst_25663,inst_25653);
} else {
if((state_val_25677 === (9))){
var state_25676__$1 = state_25676;
var statearr_25687_25714 = state_25676__$1;
(statearr_25687_25714[(2)] = tc);

(statearr_25687_25714[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25677 === (5))){
var inst_25656 = cljs.core.async.close_BANG_.call(null,tc);
var inst_25657 = cljs.core.async.close_BANG_.call(null,fc);
var state_25676__$1 = (function (){var statearr_25688 = state_25676;
(statearr_25688[(8)] = inst_25656);

return statearr_25688;
})();
var statearr_25689_25715 = state_25676__$1;
(statearr_25689_25715[(2)] = inst_25657);

(statearr_25689_25715[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25677 === (14))){
var inst_25670 = (state_25676[(2)]);
var state_25676__$1 = state_25676;
var statearr_25690_25716 = state_25676__$1;
(statearr_25690_25716[(2)] = inst_25670);

(statearr_25690_25716[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25677 === (10))){
var state_25676__$1 = state_25676;
var statearr_25691_25717 = state_25676__$1;
(statearr_25691_25717[(2)] = fc);

(statearr_25691_25717[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25677 === (8))){
var inst_25665 = (state_25676[(2)]);
var state_25676__$1 = state_25676;
if(cljs.core.truth_(inst_25665)){
var statearr_25692_25718 = state_25676__$1;
(statearr_25692_25718[(1)] = (12));

} else {
var statearr_25693_25719 = state_25676__$1;
(statearr_25693_25719[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto___25705,tc,fc))
;
return ((function (switch__18676__auto__,c__18741__auto___25705,tc,fc){
return (function() {
var cljs$core$async$state_machine__18677__auto__ = null;
var cljs$core$async$state_machine__18677__auto____0 = (function (){
var statearr_25697 = [null,null,null,null,null,null,null,null,null];
(statearr_25697[(0)] = cljs$core$async$state_machine__18677__auto__);

(statearr_25697[(1)] = (1));

return statearr_25697;
});
var cljs$core$async$state_machine__18677__auto____1 = (function (state_25676){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_25676);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e25698){if((e25698 instanceof Object)){
var ex__18680__auto__ = e25698;
var statearr_25699_25720 = state_25676;
(statearr_25699_25720[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25676);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25698;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25721 = state_25676;
state_25676 = G__25721;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$state_machine__18677__auto__ = function(state_25676){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18677__auto____1.call(this,state_25676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18677__auto____0;
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18677__auto____1;
return cljs$core$async$state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___25705,tc,fc))
})();
var state__18743__auto__ = (function (){var statearr_25700 = f__18742__auto__.call(null);
(statearr_25700[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___25705);

return statearr_25700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___25705,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__18741__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto__){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto__){
return (function (state_25785){
var state_val_25786 = (state_25785[(1)]);
if((state_val_25786 === (7))){
var inst_25781 = (state_25785[(2)]);
var state_25785__$1 = state_25785;
var statearr_25787_25808 = state_25785__$1;
(statearr_25787_25808[(2)] = inst_25781);

(statearr_25787_25808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25786 === (1))){
var inst_25765 = init;
var state_25785__$1 = (function (){var statearr_25788 = state_25785;
(statearr_25788[(7)] = inst_25765);

return statearr_25788;
})();
var statearr_25789_25809 = state_25785__$1;
(statearr_25789_25809[(2)] = null);

(statearr_25789_25809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25786 === (4))){
var inst_25768 = (state_25785[(8)]);
var inst_25768__$1 = (state_25785[(2)]);
var inst_25769 = (inst_25768__$1 == null);
var state_25785__$1 = (function (){var statearr_25790 = state_25785;
(statearr_25790[(8)] = inst_25768__$1);

return statearr_25790;
})();
if(cljs.core.truth_(inst_25769)){
var statearr_25791_25810 = state_25785__$1;
(statearr_25791_25810[(1)] = (5));

} else {
var statearr_25792_25811 = state_25785__$1;
(statearr_25792_25811[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25786 === (6))){
var inst_25768 = (state_25785[(8)]);
var inst_25772 = (state_25785[(9)]);
var inst_25765 = (state_25785[(7)]);
var inst_25772__$1 = f.call(null,inst_25765,inst_25768);
var inst_25773 = cljs.core.reduced_QMARK_.call(null,inst_25772__$1);
var state_25785__$1 = (function (){var statearr_25793 = state_25785;
(statearr_25793[(9)] = inst_25772__$1);

return statearr_25793;
})();
if(inst_25773){
var statearr_25794_25812 = state_25785__$1;
(statearr_25794_25812[(1)] = (8));

} else {
var statearr_25795_25813 = state_25785__$1;
(statearr_25795_25813[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25786 === (3))){
var inst_25783 = (state_25785[(2)]);
var state_25785__$1 = state_25785;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25785__$1,inst_25783);
} else {
if((state_val_25786 === (2))){
var state_25785__$1 = state_25785;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25785__$1,(4),ch);
} else {
if((state_val_25786 === (9))){
var inst_25772 = (state_25785[(9)]);
var inst_25765 = inst_25772;
var state_25785__$1 = (function (){var statearr_25796 = state_25785;
(statearr_25796[(7)] = inst_25765);

return statearr_25796;
})();
var statearr_25797_25814 = state_25785__$1;
(statearr_25797_25814[(2)] = null);

(statearr_25797_25814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25786 === (5))){
var inst_25765 = (state_25785[(7)]);
var state_25785__$1 = state_25785;
var statearr_25798_25815 = state_25785__$1;
(statearr_25798_25815[(2)] = inst_25765);

(statearr_25798_25815[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25786 === (10))){
var inst_25779 = (state_25785[(2)]);
var state_25785__$1 = state_25785;
var statearr_25799_25816 = state_25785__$1;
(statearr_25799_25816[(2)] = inst_25779);

(statearr_25799_25816[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25786 === (8))){
var inst_25772 = (state_25785[(9)]);
var inst_25775 = cljs.core.deref.call(null,inst_25772);
var state_25785__$1 = state_25785;
var statearr_25800_25817 = state_25785__$1;
(statearr_25800_25817[(2)] = inst_25775);

(statearr_25800_25817[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto__))
;
return ((function (switch__18676__auto__,c__18741__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__18677__auto__ = null;
var cljs$core$async$reduce_$_state_machine__18677__auto____0 = (function (){
var statearr_25804 = [null,null,null,null,null,null,null,null,null,null];
(statearr_25804[(0)] = cljs$core$async$reduce_$_state_machine__18677__auto__);

(statearr_25804[(1)] = (1));

return statearr_25804;
});
var cljs$core$async$reduce_$_state_machine__18677__auto____1 = (function (state_25785){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_25785);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e25805){if((e25805 instanceof Object)){
var ex__18680__auto__ = e25805;
var statearr_25806_25818 = state_25785;
(statearr_25806_25818[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25785);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25805;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25819 = state_25785;
state_25785 = G__25819;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__18677__auto__ = function(state_25785){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__18677__auto____1.call(this,state_25785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__18677__auto____0;
cljs$core$async$reduce_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__18677__auto____1;
return cljs$core$async$reduce_$_state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto__))
})();
var state__18743__auto__ = (function (){var statearr_25807 = f__18742__auto__.call(null);
(statearr_25807[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto__);

return statearr_25807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto__))
);

return c__18741__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args25820 = [];
var len__17716__auto___25872 = arguments.length;
var i__17717__auto___25873 = (0);
while(true){
if((i__17717__auto___25873 < len__17716__auto___25872)){
args25820.push((arguments[i__17717__auto___25873]));

var G__25874 = (i__17717__auto___25873 + (1));
i__17717__auto___25873 = G__25874;
continue;
} else {
}
break;
}

var G__25822 = args25820.length;
switch (G__25822) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25820.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__18741__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto__){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto__){
return (function (state_25847){
var state_val_25848 = (state_25847[(1)]);
if((state_val_25848 === (7))){
var inst_25829 = (state_25847[(2)]);
var state_25847__$1 = state_25847;
var statearr_25849_25876 = state_25847__$1;
(statearr_25849_25876[(2)] = inst_25829);

(statearr_25849_25876[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25848 === (1))){
var inst_25823 = cljs.core.seq.call(null,coll);
var inst_25824 = inst_25823;
var state_25847__$1 = (function (){var statearr_25850 = state_25847;
(statearr_25850[(7)] = inst_25824);

return statearr_25850;
})();
var statearr_25851_25877 = state_25847__$1;
(statearr_25851_25877[(2)] = null);

(statearr_25851_25877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25848 === (4))){
var inst_25824 = (state_25847[(7)]);
var inst_25827 = cljs.core.first.call(null,inst_25824);
var state_25847__$1 = state_25847;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25847__$1,(7),ch,inst_25827);
} else {
if((state_val_25848 === (13))){
var inst_25841 = (state_25847[(2)]);
var state_25847__$1 = state_25847;
var statearr_25852_25878 = state_25847__$1;
(statearr_25852_25878[(2)] = inst_25841);

(statearr_25852_25878[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25848 === (6))){
var inst_25832 = (state_25847[(2)]);
var state_25847__$1 = state_25847;
if(cljs.core.truth_(inst_25832)){
var statearr_25853_25879 = state_25847__$1;
(statearr_25853_25879[(1)] = (8));

} else {
var statearr_25854_25880 = state_25847__$1;
(statearr_25854_25880[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25848 === (3))){
var inst_25845 = (state_25847[(2)]);
var state_25847__$1 = state_25847;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25847__$1,inst_25845);
} else {
if((state_val_25848 === (12))){
var state_25847__$1 = state_25847;
var statearr_25855_25881 = state_25847__$1;
(statearr_25855_25881[(2)] = null);

(statearr_25855_25881[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25848 === (2))){
var inst_25824 = (state_25847[(7)]);
var state_25847__$1 = state_25847;
if(cljs.core.truth_(inst_25824)){
var statearr_25856_25882 = state_25847__$1;
(statearr_25856_25882[(1)] = (4));

} else {
var statearr_25857_25883 = state_25847__$1;
(statearr_25857_25883[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25848 === (11))){
var inst_25838 = cljs.core.async.close_BANG_.call(null,ch);
var state_25847__$1 = state_25847;
var statearr_25858_25884 = state_25847__$1;
(statearr_25858_25884[(2)] = inst_25838);

(statearr_25858_25884[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25848 === (9))){
var state_25847__$1 = state_25847;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25859_25885 = state_25847__$1;
(statearr_25859_25885[(1)] = (11));

} else {
var statearr_25860_25886 = state_25847__$1;
(statearr_25860_25886[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25848 === (5))){
var inst_25824 = (state_25847[(7)]);
var state_25847__$1 = state_25847;
var statearr_25861_25887 = state_25847__$1;
(statearr_25861_25887[(2)] = inst_25824);

(statearr_25861_25887[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25848 === (10))){
var inst_25843 = (state_25847[(2)]);
var state_25847__$1 = state_25847;
var statearr_25862_25888 = state_25847__$1;
(statearr_25862_25888[(2)] = inst_25843);

(statearr_25862_25888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25848 === (8))){
var inst_25824 = (state_25847[(7)]);
var inst_25834 = cljs.core.next.call(null,inst_25824);
var inst_25824__$1 = inst_25834;
var state_25847__$1 = (function (){var statearr_25863 = state_25847;
(statearr_25863[(7)] = inst_25824__$1);

return statearr_25863;
})();
var statearr_25864_25889 = state_25847__$1;
(statearr_25864_25889[(2)] = null);

(statearr_25864_25889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto__))
;
return ((function (switch__18676__auto__,c__18741__auto__){
return (function() {
var cljs$core$async$state_machine__18677__auto__ = null;
var cljs$core$async$state_machine__18677__auto____0 = (function (){
var statearr_25868 = [null,null,null,null,null,null,null,null];
(statearr_25868[(0)] = cljs$core$async$state_machine__18677__auto__);

(statearr_25868[(1)] = (1));

return statearr_25868;
});
var cljs$core$async$state_machine__18677__auto____1 = (function (state_25847){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_25847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e25869){if((e25869 instanceof Object)){
var ex__18680__auto__ = e25869;
var statearr_25870_25890 = state_25847;
(statearr_25870_25890[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25847);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25869;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25891 = state_25847;
state_25847 = G__25891;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$state_machine__18677__auto__ = function(state_25847){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18677__auto____1.call(this,state_25847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18677__auto____0;
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18677__auto____1;
return cljs$core$async$state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto__))
})();
var state__18743__auto__ = (function (){var statearr_25871 = f__18742__auto__.call(null);
(statearr_25871[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto__);

return statearr_25871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto__))
);

return c__18741__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__17313__auto__ = (((_ == null))?null:_);
var m__17314__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__17313__auto__)]);
if(!((m__17314__auto__ == null))){
return m__17314__auto__.call(null,_);
} else {
var m__17314__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__17314__auto____$1 == null))){
return m__17314__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__17313__auto__ = (((m == null))?null:m);
var m__17314__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__17313__auto__)]);
if(!((m__17314__auto__ == null))){
return m__17314__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__17314__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__17314__auto____$1 == null))){
return m__17314__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__17313__auto__ = (((m == null))?null:m);
var m__17314__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__17313__auto__)]);
if(!((m__17314__auto__ == null))){
return m__17314__auto__.call(null,m,ch);
} else {
var m__17314__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__17314__auto____$1 == null))){
return m__17314__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__17313__auto__ = (((m == null))?null:m);
var m__17314__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__17313__auto__)]);
if(!((m__17314__auto__ == null))){
return m__17314__auto__.call(null,m);
} else {
var m__17314__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__17314__auto____$1 == null))){
return m__17314__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async26113 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26113 = (function (mult,ch,cs,meta26114){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta26114 = meta26114;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26113.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_26115,meta26114__$1){
var self__ = this;
var _26115__$1 = this;
return (new cljs.core.async.t_cljs$core$async26113(self__.mult,self__.ch,self__.cs,meta26114__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async26113.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_26115){
var self__ = this;
var _26115__$1 = this;
return self__.meta26114;
});})(cs))
;

cljs.core.async.t_cljs$core$async26113.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async26113.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async26113.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async26113.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async26113.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async26113.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async26113.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta26114","meta26114",1949493374,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async26113.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26113.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26113";

cljs.core.async.t_cljs$core$async26113.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__17256__auto__,writer__17257__auto__,opt__17258__auto__){
return cljs.core._write.call(null,writer__17257__auto__,"cljs.core.async/t_cljs$core$async26113");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async26113 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async26113(mult__$1,ch__$1,cs__$1,meta26114){
return (new cljs.core.async.t_cljs$core$async26113(mult__$1,ch__$1,cs__$1,meta26114));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async26113(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__18741__auto___26334 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___26334,cs,m,dchan,dctr,done){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___26334,cs,m,dchan,dctr,done){
return (function (state_26246){
var state_val_26247 = (state_26246[(1)]);
if((state_val_26247 === (7))){
var inst_26242 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
var statearr_26248_26335 = state_26246__$1;
(statearr_26248_26335[(2)] = inst_26242);

(statearr_26248_26335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (20))){
var inst_26147 = (state_26246[(7)]);
var inst_26157 = cljs.core.first.call(null,inst_26147);
var inst_26158 = cljs.core.nth.call(null,inst_26157,(0),null);
var inst_26159 = cljs.core.nth.call(null,inst_26157,(1),null);
var state_26246__$1 = (function (){var statearr_26249 = state_26246;
(statearr_26249[(8)] = inst_26158);

return statearr_26249;
})();
if(cljs.core.truth_(inst_26159)){
var statearr_26250_26336 = state_26246__$1;
(statearr_26250_26336[(1)] = (22));

} else {
var statearr_26251_26337 = state_26246__$1;
(statearr_26251_26337[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (27))){
var inst_26118 = (state_26246[(9)]);
var inst_26187 = (state_26246[(10)]);
var inst_26189 = (state_26246[(11)]);
var inst_26194 = (state_26246[(12)]);
var inst_26194__$1 = cljs.core._nth.call(null,inst_26187,inst_26189);
var inst_26195 = cljs.core.async.put_BANG_.call(null,inst_26194__$1,inst_26118,done);
var state_26246__$1 = (function (){var statearr_26252 = state_26246;
(statearr_26252[(12)] = inst_26194__$1);

return statearr_26252;
})();
if(cljs.core.truth_(inst_26195)){
var statearr_26253_26338 = state_26246__$1;
(statearr_26253_26338[(1)] = (30));

} else {
var statearr_26254_26339 = state_26246__$1;
(statearr_26254_26339[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (1))){
var state_26246__$1 = state_26246;
var statearr_26255_26340 = state_26246__$1;
(statearr_26255_26340[(2)] = null);

(statearr_26255_26340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (24))){
var inst_26147 = (state_26246[(7)]);
var inst_26164 = (state_26246[(2)]);
var inst_26165 = cljs.core.next.call(null,inst_26147);
var inst_26127 = inst_26165;
var inst_26128 = null;
var inst_26129 = (0);
var inst_26130 = (0);
var state_26246__$1 = (function (){var statearr_26256 = state_26246;
(statearr_26256[(13)] = inst_26129);

(statearr_26256[(14)] = inst_26164);

(statearr_26256[(15)] = inst_26127);

(statearr_26256[(16)] = inst_26130);

(statearr_26256[(17)] = inst_26128);

return statearr_26256;
})();
var statearr_26257_26341 = state_26246__$1;
(statearr_26257_26341[(2)] = null);

(statearr_26257_26341[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (39))){
var state_26246__$1 = state_26246;
var statearr_26261_26342 = state_26246__$1;
(statearr_26261_26342[(2)] = null);

(statearr_26261_26342[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (4))){
var inst_26118 = (state_26246[(9)]);
var inst_26118__$1 = (state_26246[(2)]);
var inst_26119 = (inst_26118__$1 == null);
var state_26246__$1 = (function (){var statearr_26262 = state_26246;
(statearr_26262[(9)] = inst_26118__$1);

return statearr_26262;
})();
if(cljs.core.truth_(inst_26119)){
var statearr_26263_26343 = state_26246__$1;
(statearr_26263_26343[(1)] = (5));

} else {
var statearr_26264_26344 = state_26246__$1;
(statearr_26264_26344[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (15))){
var inst_26129 = (state_26246[(13)]);
var inst_26127 = (state_26246[(15)]);
var inst_26130 = (state_26246[(16)]);
var inst_26128 = (state_26246[(17)]);
var inst_26143 = (state_26246[(2)]);
var inst_26144 = (inst_26130 + (1));
var tmp26258 = inst_26129;
var tmp26259 = inst_26127;
var tmp26260 = inst_26128;
var inst_26127__$1 = tmp26259;
var inst_26128__$1 = tmp26260;
var inst_26129__$1 = tmp26258;
var inst_26130__$1 = inst_26144;
var state_26246__$1 = (function (){var statearr_26265 = state_26246;
(statearr_26265[(13)] = inst_26129__$1);

(statearr_26265[(18)] = inst_26143);

(statearr_26265[(15)] = inst_26127__$1);

(statearr_26265[(16)] = inst_26130__$1);

(statearr_26265[(17)] = inst_26128__$1);

return statearr_26265;
})();
var statearr_26266_26345 = state_26246__$1;
(statearr_26266_26345[(2)] = null);

(statearr_26266_26345[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (21))){
var inst_26168 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
var statearr_26270_26346 = state_26246__$1;
(statearr_26270_26346[(2)] = inst_26168);

(statearr_26270_26346[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (31))){
var inst_26194 = (state_26246[(12)]);
var inst_26198 = done.call(null,null);
var inst_26199 = cljs.core.async.untap_STAR_.call(null,m,inst_26194);
var state_26246__$1 = (function (){var statearr_26271 = state_26246;
(statearr_26271[(19)] = inst_26198);

return statearr_26271;
})();
var statearr_26272_26347 = state_26246__$1;
(statearr_26272_26347[(2)] = inst_26199);

(statearr_26272_26347[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (32))){
var inst_26187 = (state_26246[(10)]);
var inst_26189 = (state_26246[(11)]);
var inst_26186 = (state_26246[(20)]);
var inst_26188 = (state_26246[(21)]);
var inst_26201 = (state_26246[(2)]);
var inst_26202 = (inst_26189 + (1));
var tmp26267 = inst_26187;
var tmp26268 = inst_26186;
var tmp26269 = inst_26188;
var inst_26186__$1 = tmp26268;
var inst_26187__$1 = tmp26267;
var inst_26188__$1 = tmp26269;
var inst_26189__$1 = inst_26202;
var state_26246__$1 = (function (){var statearr_26273 = state_26246;
(statearr_26273[(10)] = inst_26187__$1);

(statearr_26273[(11)] = inst_26189__$1);

(statearr_26273[(20)] = inst_26186__$1);

(statearr_26273[(21)] = inst_26188__$1);

(statearr_26273[(22)] = inst_26201);

return statearr_26273;
})();
var statearr_26274_26348 = state_26246__$1;
(statearr_26274_26348[(2)] = null);

(statearr_26274_26348[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (40))){
var inst_26214 = (state_26246[(23)]);
var inst_26218 = done.call(null,null);
var inst_26219 = cljs.core.async.untap_STAR_.call(null,m,inst_26214);
var state_26246__$1 = (function (){var statearr_26275 = state_26246;
(statearr_26275[(24)] = inst_26218);

return statearr_26275;
})();
var statearr_26276_26349 = state_26246__$1;
(statearr_26276_26349[(2)] = inst_26219);

(statearr_26276_26349[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (33))){
var inst_26205 = (state_26246[(25)]);
var inst_26207 = cljs.core.chunked_seq_QMARK_.call(null,inst_26205);
var state_26246__$1 = state_26246;
if(inst_26207){
var statearr_26277_26350 = state_26246__$1;
(statearr_26277_26350[(1)] = (36));

} else {
var statearr_26278_26351 = state_26246__$1;
(statearr_26278_26351[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (13))){
var inst_26137 = (state_26246[(26)]);
var inst_26140 = cljs.core.async.close_BANG_.call(null,inst_26137);
var state_26246__$1 = state_26246;
var statearr_26279_26352 = state_26246__$1;
(statearr_26279_26352[(2)] = inst_26140);

(statearr_26279_26352[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (22))){
var inst_26158 = (state_26246[(8)]);
var inst_26161 = cljs.core.async.close_BANG_.call(null,inst_26158);
var state_26246__$1 = state_26246;
var statearr_26280_26353 = state_26246__$1;
(statearr_26280_26353[(2)] = inst_26161);

(statearr_26280_26353[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (36))){
var inst_26205 = (state_26246[(25)]);
var inst_26209 = cljs.core.chunk_first.call(null,inst_26205);
var inst_26210 = cljs.core.chunk_rest.call(null,inst_26205);
var inst_26211 = cljs.core.count.call(null,inst_26209);
var inst_26186 = inst_26210;
var inst_26187 = inst_26209;
var inst_26188 = inst_26211;
var inst_26189 = (0);
var state_26246__$1 = (function (){var statearr_26281 = state_26246;
(statearr_26281[(10)] = inst_26187);

(statearr_26281[(11)] = inst_26189);

(statearr_26281[(20)] = inst_26186);

(statearr_26281[(21)] = inst_26188);

return statearr_26281;
})();
var statearr_26282_26354 = state_26246__$1;
(statearr_26282_26354[(2)] = null);

(statearr_26282_26354[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (41))){
var inst_26205 = (state_26246[(25)]);
var inst_26221 = (state_26246[(2)]);
var inst_26222 = cljs.core.next.call(null,inst_26205);
var inst_26186 = inst_26222;
var inst_26187 = null;
var inst_26188 = (0);
var inst_26189 = (0);
var state_26246__$1 = (function (){var statearr_26283 = state_26246;
(statearr_26283[(10)] = inst_26187);

(statearr_26283[(11)] = inst_26189);

(statearr_26283[(20)] = inst_26186);

(statearr_26283[(21)] = inst_26188);

(statearr_26283[(27)] = inst_26221);

return statearr_26283;
})();
var statearr_26284_26355 = state_26246__$1;
(statearr_26284_26355[(2)] = null);

(statearr_26284_26355[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (43))){
var state_26246__$1 = state_26246;
var statearr_26285_26356 = state_26246__$1;
(statearr_26285_26356[(2)] = null);

(statearr_26285_26356[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (29))){
var inst_26230 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
var statearr_26286_26357 = state_26246__$1;
(statearr_26286_26357[(2)] = inst_26230);

(statearr_26286_26357[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (44))){
var inst_26239 = (state_26246[(2)]);
var state_26246__$1 = (function (){var statearr_26287 = state_26246;
(statearr_26287[(28)] = inst_26239);

return statearr_26287;
})();
var statearr_26288_26358 = state_26246__$1;
(statearr_26288_26358[(2)] = null);

(statearr_26288_26358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (6))){
var inst_26178 = (state_26246[(29)]);
var inst_26177 = cljs.core.deref.call(null,cs);
var inst_26178__$1 = cljs.core.keys.call(null,inst_26177);
var inst_26179 = cljs.core.count.call(null,inst_26178__$1);
var inst_26180 = cljs.core.reset_BANG_.call(null,dctr,inst_26179);
var inst_26185 = cljs.core.seq.call(null,inst_26178__$1);
var inst_26186 = inst_26185;
var inst_26187 = null;
var inst_26188 = (0);
var inst_26189 = (0);
var state_26246__$1 = (function (){var statearr_26289 = state_26246;
(statearr_26289[(30)] = inst_26180);

(statearr_26289[(10)] = inst_26187);

(statearr_26289[(11)] = inst_26189);

(statearr_26289[(29)] = inst_26178__$1);

(statearr_26289[(20)] = inst_26186);

(statearr_26289[(21)] = inst_26188);

return statearr_26289;
})();
var statearr_26290_26359 = state_26246__$1;
(statearr_26290_26359[(2)] = null);

(statearr_26290_26359[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (28))){
var inst_26205 = (state_26246[(25)]);
var inst_26186 = (state_26246[(20)]);
var inst_26205__$1 = cljs.core.seq.call(null,inst_26186);
var state_26246__$1 = (function (){var statearr_26291 = state_26246;
(statearr_26291[(25)] = inst_26205__$1);

return statearr_26291;
})();
if(inst_26205__$1){
var statearr_26292_26360 = state_26246__$1;
(statearr_26292_26360[(1)] = (33));

} else {
var statearr_26293_26361 = state_26246__$1;
(statearr_26293_26361[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (25))){
var inst_26189 = (state_26246[(11)]);
var inst_26188 = (state_26246[(21)]);
var inst_26191 = (inst_26189 < inst_26188);
var inst_26192 = inst_26191;
var state_26246__$1 = state_26246;
if(cljs.core.truth_(inst_26192)){
var statearr_26294_26362 = state_26246__$1;
(statearr_26294_26362[(1)] = (27));

} else {
var statearr_26295_26363 = state_26246__$1;
(statearr_26295_26363[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (34))){
var state_26246__$1 = state_26246;
var statearr_26296_26364 = state_26246__$1;
(statearr_26296_26364[(2)] = null);

(statearr_26296_26364[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (17))){
var state_26246__$1 = state_26246;
var statearr_26297_26365 = state_26246__$1;
(statearr_26297_26365[(2)] = null);

(statearr_26297_26365[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (3))){
var inst_26244 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26246__$1,inst_26244);
} else {
if((state_val_26247 === (12))){
var inst_26173 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
var statearr_26298_26366 = state_26246__$1;
(statearr_26298_26366[(2)] = inst_26173);

(statearr_26298_26366[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (2))){
var state_26246__$1 = state_26246;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26246__$1,(4),ch);
} else {
if((state_val_26247 === (23))){
var state_26246__$1 = state_26246;
var statearr_26299_26367 = state_26246__$1;
(statearr_26299_26367[(2)] = null);

(statearr_26299_26367[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (35))){
var inst_26228 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
var statearr_26300_26368 = state_26246__$1;
(statearr_26300_26368[(2)] = inst_26228);

(statearr_26300_26368[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (19))){
var inst_26147 = (state_26246[(7)]);
var inst_26151 = cljs.core.chunk_first.call(null,inst_26147);
var inst_26152 = cljs.core.chunk_rest.call(null,inst_26147);
var inst_26153 = cljs.core.count.call(null,inst_26151);
var inst_26127 = inst_26152;
var inst_26128 = inst_26151;
var inst_26129 = inst_26153;
var inst_26130 = (0);
var state_26246__$1 = (function (){var statearr_26301 = state_26246;
(statearr_26301[(13)] = inst_26129);

(statearr_26301[(15)] = inst_26127);

(statearr_26301[(16)] = inst_26130);

(statearr_26301[(17)] = inst_26128);

return statearr_26301;
})();
var statearr_26302_26369 = state_26246__$1;
(statearr_26302_26369[(2)] = null);

(statearr_26302_26369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (11))){
var inst_26147 = (state_26246[(7)]);
var inst_26127 = (state_26246[(15)]);
var inst_26147__$1 = cljs.core.seq.call(null,inst_26127);
var state_26246__$1 = (function (){var statearr_26303 = state_26246;
(statearr_26303[(7)] = inst_26147__$1);

return statearr_26303;
})();
if(inst_26147__$1){
var statearr_26304_26370 = state_26246__$1;
(statearr_26304_26370[(1)] = (16));

} else {
var statearr_26305_26371 = state_26246__$1;
(statearr_26305_26371[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (9))){
var inst_26175 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
var statearr_26306_26372 = state_26246__$1;
(statearr_26306_26372[(2)] = inst_26175);

(statearr_26306_26372[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (5))){
var inst_26125 = cljs.core.deref.call(null,cs);
var inst_26126 = cljs.core.seq.call(null,inst_26125);
var inst_26127 = inst_26126;
var inst_26128 = null;
var inst_26129 = (0);
var inst_26130 = (0);
var state_26246__$1 = (function (){var statearr_26307 = state_26246;
(statearr_26307[(13)] = inst_26129);

(statearr_26307[(15)] = inst_26127);

(statearr_26307[(16)] = inst_26130);

(statearr_26307[(17)] = inst_26128);

return statearr_26307;
})();
var statearr_26308_26373 = state_26246__$1;
(statearr_26308_26373[(2)] = null);

(statearr_26308_26373[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (14))){
var state_26246__$1 = state_26246;
var statearr_26309_26374 = state_26246__$1;
(statearr_26309_26374[(2)] = null);

(statearr_26309_26374[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (45))){
var inst_26236 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
var statearr_26310_26375 = state_26246__$1;
(statearr_26310_26375[(2)] = inst_26236);

(statearr_26310_26375[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (26))){
var inst_26178 = (state_26246[(29)]);
var inst_26232 = (state_26246[(2)]);
var inst_26233 = cljs.core.seq.call(null,inst_26178);
var state_26246__$1 = (function (){var statearr_26311 = state_26246;
(statearr_26311[(31)] = inst_26232);

return statearr_26311;
})();
if(inst_26233){
var statearr_26312_26376 = state_26246__$1;
(statearr_26312_26376[(1)] = (42));

} else {
var statearr_26313_26377 = state_26246__$1;
(statearr_26313_26377[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (16))){
var inst_26147 = (state_26246[(7)]);
var inst_26149 = cljs.core.chunked_seq_QMARK_.call(null,inst_26147);
var state_26246__$1 = state_26246;
if(inst_26149){
var statearr_26314_26378 = state_26246__$1;
(statearr_26314_26378[(1)] = (19));

} else {
var statearr_26315_26379 = state_26246__$1;
(statearr_26315_26379[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (38))){
var inst_26225 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
var statearr_26316_26380 = state_26246__$1;
(statearr_26316_26380[(2)] = inst_26225);

(statearr_26316_26380[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (30))){
var state_26246__$1 = state_26246;
var statearr_26317_26381 = state_26246__$1;
(statearr_26317_26381[(2)] = null);

(statearr_26317_26381[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (10))){
var inst_26130 = (state_26246[(16)]);
var inst_26128 = (state_26246[(17)]);
var inst_26136 = cljs.core._nth.call(null,inst_26128,inst_26130);
var inst_26137 = cljs.core.nth.call(null,inst_26136,(0),null);
var inst_26138 = cljs.core.nth.call(null,inst_26136,(1),null);
var state_26246__$1 = (function (){var statearr_26318 = state_26246;
(statearr_26318[(26)] = inst_26137);

return statearr_26318;
})();
if(cljs.core.truth_(inst_26138)){
var statearr_26319_26382 = state_26246__$1;
(statearr_26319_26382[(1)] = (13));

} else {
var statearr_26320_26383 = state_26246__$1;
(statearr_26320_26383[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (18))){
var inst_26171 = (state_26246[(2)]);
var state_26246__$1 = state_26246;
var statearr_26321_26384 = state_26246__$1;
(statearr_26321_26384[(2)] = inst_26171);

(statearr_26321_26384[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (42))){
var state_26246__$1 = state_26246;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26246__$1,(45),dchan);
} else {
if((state_val_26247 === (37))){
var inst_26118 = (state_26246[(9)]);
var inst_26205 = (state_26246[(25)]);
var inst_26214 = (state_26246[(23)]);
var inst_26214__$1 = cljs.core.first.call(null,inst_26205);
var inst_26215 = cljs.core.async.put_BANG_.call(null,inst_26214__$1,inst_26118,done);
var state_26246__$1 = (function (){var statearr_26322 = state_26246;
(statearr_26322[(23)] = inst_26214__$1);

return statearr_26322;
})();
if(cljs.core.truth_(inst_26215)){
var statearr_26323_26385 = state_26246__$1;
(statearr_26323_26385[(1)] = (39));

} else {
var statearr_26324_26386 = state_26246__$1;
(statearr_26324_26386[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26247 === (8))){
var inst_26129 = (state_26246[(13)]);
var inst_26130 = (state_26246[(16)]);
var inst_26132 = (inst_26130 < inst_26129);
var inst_26133 = inst_26132;
var state_26246__$1 = state_26246;
if(cljs.core.truth_(inst_26133)){
var statearr_26325_26387 = state_26246__$1;
(statearr_26325_26387[(1)] = (10));

} else {
var statearr_26326_26388 = state_26246__$1;
(statearr_26326_26388[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto___26334,cs,m,dchan,dctr,done))
;
return ((function (switch__18676__auto__,c__18741__auto___26334,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__18677__auto__ = null;
var cljs$core$async$mult_$_state_machine__18677__auto____0 = (function (){
var statearr_26330 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26330[(0)] = cljs$core$async$mult_$_state_machine__18677__auto__);

(statearr_26330[(1)] = (1));

return statearr_26330;
});
var cljs$core$async$mult_$_state_machine__18677__auto____1 = (function (state_26246){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_26246);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e26331){if((e26331 instanceof Object)){
var ex__18680__auto__ = e26331;
var statearr_26332_26389 = state_26246;
(statearr_26332_26389[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26246);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26331;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26390 = state_26246;
state_26246 = G__26390;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__18677__auto__ = function(state_26246){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__18677__auto____1.call(this,state_26246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__18677__auto____0;
cljs$core$async$mult_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__18677__auto____1;
return cljs$core$async$mult_$_state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___26334,cs,m,dchan,dctr,done))
})();
var state__18743__auto__ = (function (){var statearr_26333 = f__18742__auto__.call(null);
(statearr_26333[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___26334);

return statearr_26333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___26334,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args26391 = [];
var len__17716__auto___26394 = arguments.length;
var i__17717__auto___26395 = (0);
while(true){
if((i__17717__auto___26395 < len__17716__auto___26394)){
args26391.push((arguments[i__17717__auto___26395]));

var G__26396 = (i__17717__auto___26395 + (1));
i__17717__auto___26395 = G__26396;
continue;
} else {
}
break;
}

var G__26393 = args26391.length;
switch (G__26393) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26391.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__17313__auto__ = (((m == null))?null:m);
var m__17314__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__17313__auto__)]);
if(!((m__17314__auto__ == null))){
return m__17314__auto__.call(null,m,ch);
} else {
var m__17314__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__17314__auto____$1 == null))){
return m__17314__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__17313__auto__ = (((m == null))?null:m);
var m__17314__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__17313__auto__)]);
if(!((m__17314__auto__ == null))){
return m__17314__auto__.call(null,m,ch);
} else {
var m__17314__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__17314__auto____$1 == null))){
return m__17314__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__17313__auto__ = (((m == null))?null:m);
var m__17314__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__17313__auto__)]);
if(!((m__17314__auto__ == null))){
return m__17314__auto__.call(null,m);
} else {
var m__17314__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__17314__auto____$1 == null))){
return m__17314__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__17313__auto__ = (((m == null))?null:m);
var m__17314__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__17313__auto__)]);
if(!((m__17314__auto__ == null))){
return m__17314__auto__.call(null,m,state_map);
} else {
var m__17314__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__17314__auto____$1 == null))){
return m__17314__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__17313__auto__ = (((m == null))?null:m);
var m__17314__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__17313__auto__)]);
if(!((m__17314__auto__ == null))){
return m__17314__auto__.call(null,m,mode);
} else {
var m__17314__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__17314__auto____$1 == null))){
return m__17314__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__17723__auto__ = [];
var len__17716__auto___26408 = arguments.length;
var i__17717__auto___26409 = (0);
while(true){
if((i__17717__auto___26409 < len__17716__auto___26408)){
args__17723__auto__.push((arguments[i__17717__auto___26409]));

var G__26410 = (i__17717__auto___26409 + (1));
i__17717__auto___26409 = G__26410;
continue;
} else {
}
break;
}

var argseq__17724__auto__ = ((((3) < args__17723__auto__.length))?(new cljs.core.IndexedSeq(args__17723__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__17724__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__26402){
var map__26403 = p__26402;
var map__26403__$1 = ((((!((map__26403 == null)))?((((map__26403.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26403.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26403):map__26403);
var opts = map__26403__$1;
var statearr_26405_26411 = state;
(statearr_26405_26411[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__26403,map__26403__$1,opts){
return (function (val){
var statearr_26406_26412 = state;
(statearr_26406_26412[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__26403,map__26403__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_26407_26413 = state;
(statearr_26407_26413[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq26398){
var G__26399 = cljs.core.first.call(null,seq26398);
var seq26398__$1 = cljs.core.next.call(null,seq26398);
var G__26400 = cljs.core.first.call(null,seq26398__$1);
var seq26398__$2 = cljs.core.next.call(null,seq26398__$1);
var G__26401 = cljs.core.first.call(null,seq26398__$2);
var seq26398__$3 = cljs.core.next.call(null,seq26398__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26399,G__26400,G__26401,seq26398__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async26577 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26577 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta26578){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta26578 = meta26578;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26577.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_26579,meta26578__$1){
var self__ = this;
var _26579__$1 = this;
return (new cljs.core.async.t_cljs$core$async26577(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta26578__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26577.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_26579){
var self__ = this;
var _26579__$1 = this;
return self__.meta26578;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26577.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async26577.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26577.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async26577.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26577.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26577.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26577.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26577.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26577.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta26578","meta26578",-992630841,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26577.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26577.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26577";

cljs.core.async.t_cljs$core$async26577.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__17256__auto__,writer__17257__auto__,opt__17258__auto__){
return cljs.core._write.call(null,writer__17257__auto__,"cljs.core.async/t_cljs$core$async26577");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async26577 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async26577(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta26578){
return (new cljs.core.async.t_cljs$core$async26577(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta26578));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async26577(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__18741__auto___26740 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___26740,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___26740,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_26677){
var state_val_26678 = (state_26677[(1)]);
if((state_val_26678 === (7))){
var inst_26595 = (state_26677[(2)]);
var state_26677__$1 = state_26677;
var statearr_26679_26741 = state_26677__$1;
(statearr_26679_26741[(2)] = inst_26595);

(statearr_26679_26741[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (20))){
var inst_26607 = (state_26677[(7)]);
var state_26677__$1 = state_26677;
var statearr_26680_26742 = state_26677__$1;
(statearr_26680_26742[(2)] = inst_26607);

(statearr_26680_26742[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (27))){
var state_26677__$1 = state_26677;
var statearr_26681_26743 = state_26677__$1;
(statearr_26681_26743[(2)] = null);

(statearr_26681_26743[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (1))){
var inst_26583 = (state_26677[(8)]);
var inst_26583__$1 = calc_state.call(null);
var inst_26585 = (inst_26583__$1 == null);
var inst_26586 = cljs.core.not.call(null,inst_26585);
var state_26677__$1 = (function (){var statearr_26682 = state_26677;
(statearr_26682[(8)] = inst_26583__$1);

return statearr_26682;
})();
if(inst_26586){
var statearr_26683_26744 = state_26677__$1;
(statearr_26683_26744[(1)] = (2));

} else {
var statearr_26684_26745 = state_26677__$1;
(statearr_26684_26745[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (24))){
var inst_26637 = (state_26677[(9)]);
var inst_26651 = (state_26677[(10)]);
var inst_26630 = (state_26677[(11)]);
var inst_26651__$1 = inst_26630.call(null,inst_26637);
var state_26677__$1 = (function (){var statearr_26685 = state_26677;
(statearr_26685[(10)] = inst_26651__$1);

return statearr_26685;
})();
if(cljs.core.truth_(inst_26651__$1)){
var statearr_26686_26746 = state_26677__$1;
(statearr_26686_26746[(1)] = (29));

} else {
var statearr_26687_26747 = state_26677__$1;
(statearr_26687_26747[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (4))){
var inst_26598 = (state_26677[(2)]);
var state_26677__$1 = state_26677;
if(cljs.core.truth_(inst_26598)){
var statearr_26688_26748 = state_26677__$1;
(statearr_26688_26748[(1)] = (8));

} else {
var statearr_26689_26749 = state_26677__$1;
(statearr_26689_26749[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (15))){
var inst_26624 = (state_26677[(2)]);
var state_26677__$1 = state_26677;
if(cljs.core.truth_(inst_26624)){
var statearr_26690_26750 = state_26677__$1;
(statearr_26690_26750[(1)] = (19));

} else {
var statearr_26691_26751 = state_26677__$1;
(statearr_26691_26751[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (21))){
var inst_26629 = (state_26677[(12)]);
var inst_26629__$1 = (state_26677[(2)]);
var inst_26630 = cljs.core.get.call(null,inst_26629__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_26631 = cljs.core.get.call(null,inst_26629__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_26632 = cljs.core.get.call(null,inst_26629__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_26677__$1 = (function (){var statearr_26692 = state_26677;
(statearr_26692[(11)] = inst_26630);

(statearr_26692[(12)] = inst_26629__$1);

(statearr_26692[(13)] = inst_26631);

return statearr_26692;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_26677__$1,(22),inst_26632);
} else {
if((state_val_26678 === (31))){
var inst_26659 = (state_26677[(2)]);
var state_26677__$1 = state_26677;
if(cljs.core.truth_(inst_26659)){
var statearr_26693_26752 = state_26677__$1;
(statearr_26693_26752[(1)] = (32));

} else {
var statearr_26694_26753 = state_26677__$1;
(statearr_26694_26753[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (32))){
var inst_26636 = (state_26677[(14)]);
var state_26677__$1 = state_26677;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26677__$1,(35),out,inst_26636);
} else {
if((state_val_26678 === (33))){
var inst_26629 = (state_26677[(12)]);
var inst_26607 = inst_26629;
var state_26677__$1 = (function (){var statearr_26695 = state_26677;
(statearr_26695[(7)] = inst_26607);

return statearr_26695;
})();
var statearr_26696_26754 = state_26677__$1;
(statearr_26696_26754[(2)] = null);

(statearr_26696_26754[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (13))){
var inst_26607 = (state_26677[(7)]);
var inst_26614 = inst_26607.cljs$lang$protocol_mask$partition0$;
var inst_26615 = (inst_26614 & (64));
var inst_26616 = inst_26607.cljs$core$ISeq$;
var inst_26617 = (inst_26615) || (inst_26616);
var state_26677__$1 = state_26677;
if(cljs.core.truth_(inst_26617)){
var statearr_26697_26755 = state_26677__$1;
(statearr_26697_26755[(1)] = (16));

} else {
var statearr_26698_26756 = state_26677__$1;
(statearr_26698_26756[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (22))){
var inst_26637 = (state_26677[(9)]);
var inst_26636 = (state_26677[(14)]);
var inst_26635 = (state_26677[(2)]);
var inst_26636__$1 = cljs.core.nth.call(null,inst_26635,(0),null);
var inst_26637__$1 = cljs.core.nth.call(null,inst_26635,(1),null);
var inst_26638 = (inst_26636__$1 == null);
var inst_26639 = cljs.core._EQ_.call(null,inst_26637__$1,change);
var inst_26640 = (inst_26638) || (inst_26639);
var state_26677__$1 = (function (){var statearr_26699 = state_26677;
(statearr_26699[(9)] = inst_26637__$1);

(statearr_26699[(14)] = inst_26636__$1);

return statearr_26699;
})();
if(cljs.core.truth_(inst_26640)){
var statearr_26700_26757 = state_26677__$1;
(statearr_26700_26757[(1)] = (23));

} else {
var statearr_26701_26758 = state_26677__$1;
(statearr_26701_26758[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (36))){
var inst_26629 = (state_26677[(12)]);
var inst_26607 = inst_26629;
var state_26677__$1 = (function (){var statearr_26702 = state_26677;
(statearr_26702[(7)] = inst_26607);

return statearr_26702;
})();
var statearr_26703_26759 = state_26677__$1;
(statearr_26703_26759[(2)] = null);

(statearr_26703_26759[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (29))){
var inst_26651 = (state_26677[(10)]);
var state_26677__$1 = state_26677;
var statearr_26704_26760 = state_26677__$1;
(statearr_26704_26760[(2)] = inst_26651);

(statearr_26704_26760[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (6))){
var state_26677__$1 = state_26677;
var statearr_26705_26761 = state_26677__$1;
(statearr_26705_26761[(2)] = false);

(statearr_26705_26761[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (28))){
var inst_26647 = (state_26677[(2)]);
var inst_26648 = calc_state.call(null);
var inst_26607 = inst_26648;
var state_26677__$1 = (function (){var statearr_26706 = state_26677;
(statearr_26706[(7)] = inst_26607);

(statearr_26706[(15)] = inst_26647);

return statearr_26706;
})();
var statearr_26707_26762 = state_26677__$1;
(statearr_26707_26762[(2)] = null);

(statearr_26707_26762[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (25))){
var inst_26673 = (state_26677[(2)]);
var state_26677__$1 = state_26677;
var statearr_26708_26763 = state_26677__$1;
(statearr_26708_26763[(2)] = inst_26673);

(statearr_26708_26763[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (34))){
var inst_26671 = (state_26677[(2)]);
var state_26677__$1 = state_26677;
var statearr_26709_26764 = state_26677__$1;
(statearr_26709_26764[(2)] = inst_26671);

(statearr_26709_26764[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (17))){
var state_26677__$1 = state_26677;
var statearr_26710_26765 = state_26677__$1;
(statearr_26710_26765[(2)] = false);

(statearr_26710_26765[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (3))){
var state_26677__$1 = state_26677;
var statearr_26711_26766 = state_26677__$1;
(statearr_26711_26766[(2)] = false);

(statearr_26711_26766[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (12))){
var inst_26675 = (state_26677[(2)]);
var state_26677__$1 = state_26677;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26677__$1,inst_26675);
} else {
if((state_val_26678 === (2))){
var inst_26583 = (state_26677[(8)]);
var inst_26588 = inst_26583.cljs$lang$protocol_mask$partition0$;
var inst_26589 = (inst_26588 & (64));
var inst_26590 = inst_26583.cljs$core$ISeq$;
var inst_26591 = (inst_26589) || (inst_26590);
var state_26677__$1 = state_26677;
if(cljs.core.truth_(inst_26591)){
var statearr_26712_26767 = state_26677__$1;
(statearr_26712_26767[(1)] = (5));

} else {
var statearr_26713_26768 = state_26677__$1;
(statearr_26713_26768[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (23))){
var inst_26636 = (state_26677[(14)]);
var inst_26642 = (inst_26636 == null);
var state_26677__$1 = state_26677;
if(cljs.core.truth_(inst_26642)){
var statearr_26714_26769 = state_26677__$1;
(statearr_26714_26769[(1)] = (26));

} else {
var statearr_26715_26770 = state_26677__$1;
(statearr_26715_26770[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (35))){
var inst_26662 = (state_26677[(2)]);
var state_26677__$1 = state_26677;
if(cljs.core.truth_(inst_26662)){
var statearr_26716_26771 = state_26677__$1;
(statearr_26716_26771[(1)] = (36));

} else {
var statearr_26717_26772 = state_26677__$1;
(statearr_26717_26772[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (19))){
var inst_26607 = (state_26677[(7)]);
var inst_26626 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26607);
var state_26677__$1 = state_26677;
var statearr_26718_26773 = state_26677__$1;
(statearr_26718_26773[(2)] = inst_26626);

(statearr_26718_26773[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (11))){
var inst_26607 = (state_26677[(7)]);
var inst_26611 = (inst_26607 == null);
var inst_26612 = cljs.core.not.call(null,inst_26611);
var state_26677__$1 = state_26677;
if(inst_26612){
var statearr_26719_26774 = state_26677__$1;
(statearr_26719_26774[(1)] = (13));

} else {
var statearr_26720_26775 = state_26677__$1;
(statearr_26720_26775[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (9))){
var inst_26583 = (state_26677[(8)]);
var state_26677__$1 = state_26677;
var statearr_26721_26776 = state_26677__$1;
(statearr_26721_26776[(2)] = inst_26583);

(statearr_26721_26776[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (5))){
var state_26677__$1 = state_26677;
var statearr_26722_26777 = state_26677__$1;
(statearr_26722_26777[(2)] = true);

(statearr_26722_26777[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (14))){
var state_26677__$1 = state_26677;
var statearr_26723_26778 = state_26677__$1;
(statearr_26723_26778[(2)] = false);

(statearr_26723_26778[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (26))){
var inst_26637 = (state_26677[(9)]);
var inst_26644 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_26637);
var state_26677__$1 = state_26677;
var statearr_26724_26779 = state_26677__$1;
(statearr_26724_26779[(2)] = inst_26644);

(statearr_26724_26779[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (16))){
var state_26677__$1 = state_26677;
var statearr_26725_26780 = state_26677__$1;
(statearr_26725_26780[(2)] = true);

(statearr_26725_26780[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (38))){
var inst_26667 = (state_26677[(2)]);
var state_26677__$1 = state_26677;
var statearr_26726_26781 = state_26677__$1;
(statearr_26726_26781[(2)] = inst_26667);

(statearr_26726_26781[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (30))){
var inst_26637 = (state_26677[(9)]);
var inst_26630 = (state_26677[(11)]);
var inst_26631 = (state_26677[(13)]);
var inst_26654 = cljs.core.empty_QMARK_.call(null,inst_26630);
var inst_26655 = inst_26631.call(null,inst_26637);
var inst_26656 = cljs.core.not.call(null,inst_26655);
var inst_26657 = (inst_26654) && (inst_26656);
var state_26677__$1 = state_26677;
var statearr_26727_26782 = state_26677__$1;
(statearr_26727_26782[(2)] = inst_26657);

(statearr_26727_26782[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (10))){
var inst_26583 = (state_26677[(8)]);
var inst_26603 = (state_26677[(2)]);
var inst_26604 = cljs.core.get.call(null,inst_26603,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_26605 = cljs.core.get.call(null,inst_26603,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_26606 = cljs.core.get.call(null,inst_26603,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_26607 = inst_26583;
var state_26677__$1 = (function (){var statearr_26728 = state_26677;
(statearr_26728[(16)] = inst_26606);

(statearr_26728[(7)] = inst_26607);

(statearr_26728[(17)] = inst_26605);

(statearr_26728[(18)] = inst_26604);

return statearr_26728;
})();
var statearr_26729_26783 = state_26677__$1;
(statearr_26729_26783[(2)] = null);

(statearr_26729_26783[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (18))){
var inst_26621 = (state_26677[(2)]);
var state_26677__$1 = state_26677;
var statearr_26730_26784 = state_26677__$1;
(statearr_26730_26784[(2)] = inst_26621);

(statearr_26730_26784[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (37))){
var state_26677__$1 = state_26677;
var statearr_26731_26785 = state_26677__$1;
(statearr_26731_26785[(2)] = null);

(statearr_26731_26785[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26678 === (8))){
var inst_26583 = (state_26677[(8)]);
var inst_26600 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26583);
var state_26677__$1 = state_26677;
var statearr_26732_26786 = state_26677__$1;
(statearr_26732_26786[(2)] = inst_26600);

(statearr_26732_26786[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto___26740,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__18676__auto__,c__18741__auto___26740,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__18677__auto__ = null;
var cljs$core$async$mix_$_state_machine__18677__auto____0 = (function (){
var statearr_26736 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26736[(0)] = cljs$core$async$mix_$_state_machine__18677__auto__);

(statearr_26736[(1)] = (1));

return statearr_26736;
});
var cljs$core$async$mix_$_state_machine__18677__auto____1 = (function (state_26677){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_26677);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e26737){if((e26737 instanceof Object)){
var ex__18680__auto__ = e26737;
var statearr_26738_26787 = state_26677;
(statearr_26738_26787[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26677);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26737;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26788 = state_26677;
state_26677 = G__26788;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__18677__auto__ = function(state_26677){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__18677__auto____1.call(this,state_26677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__18677__auto____0;
cljs$core$async$mix_$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__18677__auto____1;
return cljs$core$async$mix_$_state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___26740,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__18743__auto__ = (function (){var statearr_26739 = f__18742__auto__.call(null);
(statearr_26739[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___26740);

return statearr_26739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___26740,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__17313__auto__ = (((p == null))?null:p);
var m__17314__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__17313__auto__)]);
if(!((m__17314__auto__ == null))){
return m__17314__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__17314__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__17314__auto____$1 == null))){
return m__17314__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__17313__auto__ = (((p == null))?null:p);
var m__17314__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__17313__auto__)]);
if(!((m__17314__auto__ == null))){
return m__17314__auto__.call(null,p,v,ch);
} else {
var m__17314__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__17314__auto____$1 == null))){
return m__17314__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args26789 = [];
var len__17716__auto___26792 = arguments.length;
var i__17717__auto___26793 = (0);
while(true){
if((i__17717__auto___26793 < len__17716__auto___26792)){
args26789.push((arguments[i__17717__auto___26793]));

var G__26794 = (i__17717__auto___26793 + (1));
i__17717__auto___26793 = G__26794;
continue;
} else {
}
break;
}

var G__26791 = args26789.length;
switch (G__26791) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26789.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__17313__auto__ = (((p == null))?null:p);
var m__17314__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__17313__auto__)]);
if(!((m__17314__auto__ == null))){
return m__17314__auto__.call(null,p);
} else {
var m__17314__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__17314__auto____$1 == null))){
return m__17314__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__17313__auto__ = (((p == null))?null:p);
var m__17314__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__17313__auto__)]);
if(!((m__17314__auto__ == null))){
return m__17314__auto__.call(null,p,v);
} else {
var m__17314__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__17314__auto____$1 == null))){
return m__17314__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args26797 = [];
var len__17716__auto___26922 = arguments.length;
var i__17717__auto___26923 = (0);
while(true){
if((i__17717__auto___26923 < len__17716__auto___26922)){
args26797.push((arguments[i__17717__auto___26923]));

var G__26924 = (i__17717__auto___26923 + (1));
i__17717__auto___26923 = G__26924;
continue;
} else {
}
break;
}

var G__26799 = args26797.length;
switch (G__26799) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26797.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__16658__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__16658__auto__)){
return or__16658__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__16658__auto__,mults){
return (function (p1__26796_SHARP_){
if(cljs.core.truth_(p1__26796_SHARP_.call(null,topic))){
return p1__26796_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__26796_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__16658__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async26800 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26800 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta26801){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta26801 = meta26801;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async26800.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_26802,meta26801__$1){
var self__ = this;
var _26802__$1 = this;
return (new cljs.core.async.t_cljs$core$async26800(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta26801__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26800.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_26802){
var self__ = this;
var _26802__$1 = this;
return self__.meta26801;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26800.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async26800.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26800.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async26800.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26800.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26800.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26800.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26800.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta26801","meta26801",-1661159794,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26800.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26800.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26800";

cljs.core.async.t_cljs$core$async26800.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__17256__auto__,writer__17257__auto__,opt__17258__auto__){
return cljs.core._write.call(null,writer__17257__auto__,"cljs.core.async/t_cljs$core$async26800");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async26800 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async26800(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta26801){
return (new cljs.core.async.t_cljs$core$async26800(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta26801));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async26800(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__18741__auto___26926 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___26926,mults,ensure_mult,p){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___26926,mults,ensure_mult,p){
return (function (state_26874){
var state_val_26875 = (state_26874[(1)]);
if((state_val_26875 === (7))){
var inst_26870 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26876_26927 = state_26874__$1;
(statearr_26876_26927[(2)] = inst_26870);

(statearr_26876_26927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (20))){
var state_26874__$1 = state_26874;
var statearr_26877_26928 = state_26874__$1;
(statearr_26877_26928[(2)] = null);

(statearr_26877_26928[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (1))){
var state_26874__$1 = state_26874;
var statearr_26878_26929 = state_26874__$1;
(statearr_26878_26929[(2)] = null);

(statearr_26878_26929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (24))){
var inst_26853 = (state_26874[(7)]);
var inst_26862 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_26853);
var state_26874__$1 = state_26874;
var statearr_26879_26930 = state_26874__$1;
(statearr_26879_26930[(2)] = inst_26862);

(statearr_26879_26930[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (4))){
var inst_26805 = (state_26874[(8)]);
var inst_26805__$1 = (state_26874[(2)]);
var inst_26806 = (inst_26805__$1 == null);
var state_26874__$1 = (function (){var statearr_26880 = state_26874;
(statearr_26880[(8)] = inst_26805__$1);

return statearr_26880;
})();
if(cljs.core.truth_(inst_26806)){
var statearr_26881_26931 = state_26874__$1;
(statearr_26881_26931[(1)] = (5));

} else {
var statearr_26882_26932 = state_26874__$1;
(statearr_26882_26932[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (15))){
var inst_26847 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26883_26933 = state_26874__$1;
(statearr_26883_26933[(2)] = inst_26847);

(statearr_26883_26933[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (21))){
var inst_26867 = (state_26874[(2)]);
var state_26874__$1 = (function (){var statearr_26884 = state_26874;
(statearr_26884[(9)] = inst_26867);

return statearr_26884;
})();
var statearr_26885_26934 = state_26874__$1;
(statearr_26885_26934[(2)] = null);

(statearr_26885_26934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (13))){
var inst_26829 = (state_26874[(10)]);
var inst_26831 = cljs.core.chunked_seq_QMARK_.call(null,inst_26829);
var state_26874__$1 = state_26874;
if(inst_26831){
var statearr_26886_26935 = state_26874__$1;
(statearr_26886_26935[(1)] = (16));

} else {
var statearr_26887_26936 = state_26874__$1;
(statearr_26887_26936[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (22))){
var inst_26859 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
if(cljs.core.truth_(inst_26859)){
var statearr_26888_26937 = state_26874__$1;
(statearr_26888_26937[(1)] = (23));

} else {
var statearr_26889_26938 = state_26874__$1;
(statearr_26889_26938[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (6))){
var inst_26853 = (state_26874[(7)]);
var inst_26855 = (state_26874[(11)]);
var inst_26805 = (state_26874[(8)]);
var inst_26853__$1 = topic_fn.call(null,inst_26805);
var inst_26854 = cljs.core.deref.call(null,mults);
var inst_26855__$1 = cljs.core.get.call(null,inst_26854,inst_26853__$1);
var state_26874__$1 = (function (){var statearr_26890 = state_26874;
(statearr_26890[(7)] = inst_26853__$1);

(statearr_26890[(11)] = inst_26855__$1);

return statearr_26890;
})();
if(cljs.core.truth_(inst_26855__$1)){
var statearr_26891_26939 = state_26874__$1;
(statearr_26891_26939[(1)] = (19));

} else {
var statearr_26892_26940 = state_26874__$1;
(statearr_26892_26940[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (25))){
var inst_26864 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26893_26941 = state_26874__$1;
(statearr_26893_26941[(2)] = inst_26864);

(statearr_26893_26941[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (17))){
var inst_26829 = (state_26874[(10)]);
var inst_26838 = cljs.core.first.call(null,inst_26829);
var inst_26839 = cljs.core.async.muxch_STAR_.call(null,inst_26838);
var inst_26840 = cljs.core.async.close_BANG_.call(null,inst_26839);
var inst_26841 = cljs.core.next.call(null,inst_26829);
var inst_26815 = inst_26841;
var inst_26816 = null;
var inst_26817 = (0);
var inst_26818 = (0);
var state_26874__$1 = (function (){var statearr_26894 = state_26874;
(statearr_26894[(12)] = inst_26818);

(statearr_26894[(13)] = inst_26815);

(statearr_26894[(14)] = inst_26816);

(statearr_26894[(15)] = inst_26817);

(statearr_26894[(16)] = inst_26840);

return statearr_26894;
})();
var statearr_26895_26942 = state_26874__$1;
(statearr_26895_26942[(2)] = null);

(statearr_26895_26942[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (3))){
var inst_26872 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26874__$1,inst_26872);
} else {
if((state_val_26875 === (12))){
var inst_26849 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26896_26943 = state_26874__$1;
(statearr_26896_26943[(2)] = inst_26849);

(statearr_26896_26943[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (2))){
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26874__$1,(4),ch);
} else {
if((state_val_26875 === (23))){
var state_26874__$1 = state_26874;
var statearr_26897_26944 = state_26874__$1;
(statearr_26897_26944[(2)] = null);

(statearr_26897_26944[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (19))){
var inst_26855 = (state_26874[(11)]);
var inst_26805 = (state_26874[(8)]);
var inst_26857 = cljs.core.async.muxch_STAR_.call(null,inst_26855);
var state_26874__$1 = state_26874;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26874__$1,(22),inst_26857,inst_26805);
} else {
if((state_val_26875 === (11))){
var inst_26829 = (state_26874[(10)]);
var inst_26815 = (state_26874[(13)]);
var inst_26829__$1 = cljs.core.seq.call(null,inst_26815);
var state_26874__$1 = (function (){var statearr_26898 = state_26874;
(statearr_26898[(10)] = inst_26829__$1);

return statearr_26898;
})();
if(inst_26829__$1){
var statearr_26899_26945 = state_26874__$1;
(statearr_26899_26945[(1)] = (13));

} else {
var statearr_26900_26946 = state_26874__$1;
(statearr_26900_26946[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (9))){
var inst_26851 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26901_26947 = state_26874__$1;
(statearr_26901_26947[(2)] = inst_26851);

(statearr_26901_26947[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (5))){
var inst_26812 = cljs.core.deref.call(null,mults);
var inst_26813 = cljs.core.vals.call(null,inst_26812);
var inst_26814 = cljs.core.seq.call(null,inst_26813);
var inst_26815 = inst_26814;
var inst_26816 = null;
var inst_26817 = (0);
var inst_26818 = (0);
var state_26874__$1 = (function (){var statearr_26902 = state_26874;
(statearr_26902[(12)] = inst_26818);

(statearr_26902[(13)] = inst_26815);

(statearr_26902[(14)] = inst_26816);

(statearr_26902[(15)] = inst_26817);

return statearr_26902;
})();
var statearr_26903_26948 = state_26874__$1;
(statearr_26903_26948[(2)] = null);

(statearr_26903_26948[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (14))){
var state_26874__$1 = state_26874;
var statearr_26907_26949 = state_26874__$1;
(statearr_26907_26949[(2)] = null);

(statearr_26907_26949[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (16))){
var inst_26829 = (state_26874[(10)]);
var inst_26833 = cljs.core.chunk_first.call(null,inst_26829);
var inst_26834 = cljs.core.chunk_rest.call(null,inst_26829);
var inst_26835 = cljs.core.count.call(null,inst_26833);
var inst_26815 = inst_26834;
var inst_26816 = inst_26833;
var inst_26817 = inst_26835;
var inst_26818 = (0);
var state_26874__$1 = (function (){var statearr_26908 = state_26874;
(statearr_26908[(12)] = inst_26818);

(statearr_26908[(13)] = inst_26815);

(statearr_26908[(14)] = inst_26816);

(statearr_26908[(15)] = inst_26817);

return statearr_26908;
})();
var statearr_26909_26950 = state_26874__$1;
(statearr_26909_26950[(2)] = null);

(statearr_26909_26950[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (10))){
var inst_26818 = (state_26874[(12)]);
var inst_26815 = (state_26874[(13)]);
var inst_26816 = (state_26874[(14)]);
var inst_26817 = (state_26874[(15)]);
var inst_26823 = cljs.core._nth.call(null,inst_26816,inst_26818);
var inst_26824 = cljs.core.async.muxch_STAR_.call(null,inst_26823);
var inst_26825 = cljs.core.async.close_BANG_.call(null,inst_26824);
var inst_26826 = (inst_26818 + (1));
var tmp26904 = inst_26815;
var tmp26905 = inst_26816;
var tmp26906 = inst_26817;
var inst_26815__$1 = tmp26904;
var inst_26816__$1 = tmp26905;
var inst_26817__$1 = tmp26906;
var inst_26818__$1 = inst_26826;
var state_26874__$1 = (function (){var statearr_26910 = state_26874;
(statearr_26910[(12)] = inst_26818__$1);

(statearr_26910[(17)] = inst_26825);

(statearr_26910[(13)] = inst_26815__$1);

(statearr_26910[(14)] = inst_26816__$1);

(statearr_26910[(15)] = inst_26817__$1);

return statearr_26910;
})();
var statearr_26911_26951 = state_26874__$1;
(statearr_26911_26951[(2)] = null);

(statearr_26911_26951[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (18))){
var inst_26844 = (state_26874[(2)]);
var state_26874__$1 = state_26874;
var statearr_26912_26952 = state_26874__$1;
(statearr_26912_26952[(2)] = inst_26844);

(statearr_26912_26952[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26875 === (8))){
var inst_26818 = (state_26874[(12)]);
var inst_26817 = (state_26874[(15)]);
var inst_26820 = (inst_26818 < inst_26817);
var inst_26821 = inst_26820;
var state_26874__$1 = state_26874;
if(cljs.core.truth_(inst_26821)){
var statearr_26913_26953 = state_26874__$1;
(statearr_26913_26953[(1)] = (10));

} else {
var statearr_26914_26954 = state_26874__$1;
(statearr_26914_26954[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto___26926,mults,ensure_mult,p))
;
return ((function (switch__18676__auto__,c__18741__auto___26926,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__18677__auto__ = null;
var cljs$core$async$state_machine__18677__auto____0 = (function (){
var statearr_26918 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26918[(0)] = cljs$core$async$state_machine__18677__auto__);

(statearr_26918[(1)] = (1));

return statearr_26918;
});
var cljs$core$async$state_machine__18677__auto____1 = (function (state_26874){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_26874);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e26919){if((e26919 instanceof Object)){
var ex__18680__auto__ = e26919;
var statearr_26920_26955 = state_26874;
(statearr_26920_26955[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26874);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26919;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26956 = state_26874;
state_26874 = G__26956;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$state_machine__18677__auto__ = function(state_26874){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18677__auto____1.call(this,state_26874);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18677__auto____0;
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18677__auto____1;
return cljs$core$async$state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___26926,mults,ensure_mult,p))
})();
var state__18743__auto__ = (function (){var statearr_26921 = f__18742__auto__.call(null);
(statearr_26921[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___26926);

return statearr_26921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___26926,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args26957 = [];
var len__17716__auto___26960 = arguments.length;
var i__17717__auto___26961 = (0);
while(true){
if((i__17717__auto___26961 < len__17716__auto___26960)){
args26957.push((arguments[i__17717__auto___26961]));

var G__26962 = (i__17717__auto___26961 + (1));
i__17717__auto___26961 = G__26962;
continue;
} else {
}
break;
}

var G__26959 = args26957.length;
switch (G__26959) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26957.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args26964 = [];
var len__17716__auto___26967 = arguments.length;
var i__17717__auto___26968 = (0);
while(true){
if((i__17717__auto___26968 < len__17716__auto___26967)){
args26964.push((arguments[i__17717__auto___26968]));

var G__26969 = (i__17717__auto___26968 + (1));
i__17717__auto___26968 = G__26969;
continue;
} else {
}
break;
}

var G__26966 = args26964.length;
switch (G__26966) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26964.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args26971 = [];
var len__17716__auto___27042 = arguments.length;
var i__17717__auto___27043 = (0);
while(true){
if((i__17717__auto___27043 < len__17716__auto___27042)){
args26971.push((arguments[i__17717__auto___27043]));

var G__27044 = (i__17717__auto___27043 + (1));
i__17717__auto___27043 = G__27044;
continue;
} else {
}
break;
}

var G__26973 = args26971.length;
switch (G__26973) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26971.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__18741__auto___27046 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___27046,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___27046,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_27012){
var state_val_27013 = (state_27012[(1)]);
if((state_val_27013 === (7))){
var state_27012__$1 = state_27012;
var statearr_27014_27047 = state_27012__$1;
(statearr_27014_27047[(2)] = null);

(statearr_27014_27047[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27013 === (1))){
var state_27012__$1 = state_27012;
var statearr_27015_27048 = state_27012__$1;
(statearr_27015_27048[(2)] = null);

(statearr_27015_27048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27013 === (4))){
var inst_26976 = (state_27012[(7)]);
var inst_26978 = (inst_26976 < cnt);
var state_27012__$1 = state_27012;
if(cljs.core.truth_(inst_26978)){
var statearr_27016_27049 = state_27012__$1;
(statearr_27016_27049[(1)] = (6));

} else {
var statearr_27017_27050 = state_27012__$1;
(statearr_27017_27050[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27013 === (15))){
var inst_27008 = (state_27012[(2)]);
var state_27012__$1 = state_27012;
var statearr_27018_27051 = state_27012__$1;
(statearr_27018_27051[(2)] = inst_27008);

(statearr_27018_27051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27013 === (13))){
var inst_27001 = cljs.core.async.close_BANG_.call(null,out);
var state_27012__$1 = state_27012;
var statearr_27019_27052 = state_27012__$1;
(statearr_27019_27052[(2)] = inst_27001);

(statearr_27019_27052[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27013 === (6))){
var state_27012__$1 = state_27012;
var statearr_27020_27053 = state_27012__$1;
(statearr_27020_27053[(2)] = null);

(statearr_27020_27053[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27013 === (3))){
var inst_27010 = (state_27012[(2)]);
var state_27012__$1 = state_27012;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27012__$1,inst_27010);
} else {
if((state_val_27013 === (12))){
var inst_26998 = (state_27012[(8)]);
var inst_26998__$1 = (state_27012[(2)]);
var inst_26999 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_26998__$1);
var state_27012__$1 = (function (){var statearr_27021 = state_27012;
(statearr_27021[(8)] = inst_26998__$1);

return statearr_27021;
})();
if(cljs.core.truth_(inst_26999)){
var statearr_27022_27054 = state_27012__$1;
(statearr_27022_27054[(1)] = (13));

} else {
var statearr_27023_27055 = state_27012__$1;
(statearr_27023_27055[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27013 === (2))){
var inst_26975 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_26976 = (0);
var state_27012__$1 = (function (){var statearr_27024 = state_27012;
(statearr_27024[(7)] = inst_26976);

(statearr_27024[(9)] = inst_26975);

return statearr_27024;
})();
var statearr_27025_27056 = state_27012__$1;
(statearr_27025_27056[(2)] = null);

(statearr_27025_27056[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27013 === (11))){
var inst_26976 = (state_27012[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_27012,(10),Object,null,(9));
var inst_26985 = chs__$1.call(null,inst_26976);
var inst_26986 = done.call(null,inst_26976);
var inst_26987 = cljs.core.async.take_BANG_.call(null,inst_26985,inst_26986);
var state_27012__$1 = state_27012;
var statearr_27026_27057 = state_27012__$1;
(statearr_27026_27057[(2)] = inst_26987);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27012__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27013 === (9))){
var inst_26976 = (state_27012[(7)]);
var inst_26989 = (state_27012[(2)]);
var inst_26990 = (inst_26976 + (1));
var inst_26976__$1 = inst_26990;
var state_27012__$1 = (function (){var statearr_27027 = state_27012;
(statearr_27027[(7)] = inst_26976__$1);

(statearr_27027[(10)] = inst_26989);

return statearr_27027;
})();
var statearr_27028_27058 = state_27012__$1;
(statearr_27028_27058[(2)] = null);

(statearr_27028_27058[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27013 === (5))){
var inst_26996 = (state_27012[(2)]);
var state_27012__$1 = (function (){var statearr_27029 = state_27012;
(statearr_27029[(11)] = inst_26996);

return statearr_27029;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27012__$1,(12),dchan);
} else {
if((state_val_27013 === (14))){
var inst_26998 = (state_27012[(8)]);
var inst_27003 = cljs.core.apply.call(null,f,inst_26998);
var state_27012__$1 = state_27012;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27012__$1,(16),out,inst_27003);
} else {
if((state_val_27013 === (16))){
var inst_27005 = (state_27012[(2)]);
var state_27012__$1 = (function (){var statearr_27030 = state_27012;
(statearr_27030[(12)] = inst_27005);

return statearr_27030;
})();
var statearr_27031_27059 = state_27012__$1;
(statearr_27031_27059[(2)] = null);

(statearr_27031_27059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27013 === (10))){
var inst_26980 = (state_27012[(2)]);
var inst_26981 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_27012__$1 = (function (){var statearr_27032 = state_27012;
(statearr_27032[(13)] = inst_26980);

return statearr_27032;
})();
var statearr_27033_27060 = state_27012__$1;
(statearr_27033_27060[(2)] = inst_26981);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27012__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27013 === (8))){
var inst_26994 = (state_27012[(2)]);
var state_27012__$1 = state_27012;
var statearr_27034_27061 = state_27012__$1;
(statearr_27034_27061[(2)] = inst_26994);

(statearr_27034_27061[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto___27046,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__18676__auto__,c__18741__auto___27046,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__18677__auto__ = null;
var cljs$core$async$state_machine__18677__auto____0 = (function (){
var statearr_27038 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27038[(0)] = cljs$core$async$state_machine__18677__auto__);

(statearr_27038[(1)] = (1));

return statearr_27038;
});
var cljs$core$async$state_machine__18677__auto____1 = (function (state_27012){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_27012);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e27039){if((e27039 instanceof Object)){
var ex__18680__auto__ = e27039;
var statearr_27040_27062 = state_27012;
(statearr_27040_27062[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27012);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27039;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27063 = state_27012;
state_27012 = G__27063;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$state_machine__18677__auto__ = function(state_27012){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18677__auto____1.call(this,state_27012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18677__auto____0;
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18677__auto____1;
return cljs$core$async$state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___27046,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__18743__auto__ = (function (){var statearr_27041 = f__18742__auto__.call(null);
(statearr_27041[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___27046);

return statearr_27041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___27046,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args27065 = [];
var len__17716__auto___27121 = arguments.length;
var i__17717__auto___27122 = (0);
while(true){
if((i__17717__auto___27122 < len__17716__auto___27121)){
args27065.push((arguments[i__17717__auto___27122]));

var G__27123 = (i__17717__auto___27122 + (1));
i__17717__auto___27122 = G__27123;
continue;
} else {
}
break;
}

var G__27067 = args27065.length;
switch (G__27067) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27065.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18741__auto___27125 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___27125,out){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___27125,out){
return (function (state_27097){
var state_val_27098 = (state_27097[(1)]);
if((state_val_27098 === (7))){
var inst_27076 = (state_27097[(7)]);
var inst_27077 = (state_27097[(8)]);
var inst_27076__$1 = (state_27097[(2)]);
var inst_27077__$1 = cljs.core.nth.call(null,inst_27076__$1,(0),null);
var inst_27078 = cljs.core.nth.call(null,inst_27076__$1,(1),null);
var inst_27079 = (inst_27077__$1 == null);
var state_27097__$1 = (function (){var statearr_27099 = state_27097;
(statearr_27099[(7)] = inst_27076__$1);

(statearr_27099[(9)] = inst_27078);

(statearr_27099[(8)] = inst_27077__$1);

return statearr_27099;
})();
if(cljs.core.truth_(inst_27079)){
var statearr_27100_27126 = state_27097__$1;
(statearr_27100_27126[(1)] = (8));

} else {
var statearr_27101_27127 = state_27097__$1;
(statearr_27101_27127[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27098 === (1))){
var inst_27068 = cljs.core.vec.call(null,chs);
var inst_27069 = inst_27068;
var state_27097__$1 = (function (){var statearr_27102 = state_27097;
(statearr_27102[(10)] = inst_27069);

return statearr_27102;
})();
var statearr_27103_27128 = state_27097__$1;
(statearr_27103_27128[(2)] = null);

(statearr_27103_27128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27098 === (4))){
var inst_27069 = (state_27097[(10)]);
var state_27097__$1 = state_27097;
return cljs.core.async.ioc_alts_BANG_.call(null,state_27097__$1,(7),inst_27069);
} else {
if((state_val_27098 === (6))){
var inst_27093 = (state_27097[(2)]);
var state_27097__$1 = state_27097;
var statearr_27104_27129 = state_27097__$1;
(statearr_27104_27129[(2)] = inst_27093);

(statearr_27104_27129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27098 === (3))){
var inst_27095 = (state_27097[(2)]);
var state_27097__$1 = state_27097;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27097__$1,inst_27095);
} else {
if((state_val_27098 === (2))){
var inst_27069 = (state_27097[(10)]);
var inst_27071 = cljs.core.count.call(null,inst_27069);
var inst_27072 = (inst_27071 > (0));
var state_27097__$1 = state_27097;
if(cljs.core.truth_(inst_27072)){
var statearr_27106_27130 = state_27097__$1;
(statearr_27106_27130[(1)] = (4));

} else {
var statearr_27107_27131 = state_27097__$1;
(statearr_27107_27131[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27098 === (11))){
var inst_27069 = (state_27097[(10)]);
var inst_27086 = (state_27097[(2)]);
var tmp27105 = inst_27069;
var inst_27069__$1 = tmp27105;
var state_27097__$1 = (function (){var statearr_27108 = state_27097;
(statearr_27108[(11)] = inst_27086);

(statearr_27108[(10)] = inst_27069__$1);

return statearr_27108;
})();
var statearr_27109_27132 = state_27097__$1;
(statearr_27109_27132[(2)] = null);

(statearr_27109_27132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27098 === (9))){
var inst_27077 = (state_27097[(8)]);
var state_27097__$1 = state_27097;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27097__$1,(11),out,inst_27077);
} else {
if((state_val_27098 === (5))){
var inst_27091 = cljs.core.async.close_BANG_.call(null,out);
var state_27097__$1 = state_27097;
var statearr_27110_27133 = state_27097__$1;
(statearr_27110_27133[(2)] = inst_27091);

(statearr_27110_27133[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27098 === (10))){
var inst_27089 = (state_27097[(2)]);
var state_27097__$1 = state_27097;
var statearr_27111_27134 = state_27097__$1;
(statearr_27111_27134[(2)] = inst_27089);

(statearr_27111_27134[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27098 === (8))){
var inst_27076 = (state_27097[(7)]);
var inst_27069 = (state_27097[(10)]);
var inst_27078 = (state_27097[(9)]);
var inst_27077 = (state_27097[(8)]);
var inst_27081 = (function (){var cs = inst_27069;
var vec__27074 = inst_27076;
var v = inst_27077;
var c = inst_27078;
return ((function (cs,vec__27074,v,c,inst_27076,inst_27069,inst_27078,inst_27077,state_val_27098,c__18741__auto___27125,out){
return (function (p1__27064_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__27064_SHARP_);
});
;})(cs,vec__27074,v,c,inst_27076,inst_27069,inst_27078,inst_27077,state_val_27098,c__18741__auto___27125,out))
})();
var inst_27082 = cljs.core.filterv.call(null,inst_27081,inst_27069);
var inst_27069__$1 = inst_27082;
var state_27097__$1 = (function (){var statearr_27112 = state_27097;
(statearr_27112[(10)] = inst_27069__$1);

return statearr_27112;
})();
var statearr_27113_27135 = state_27097__$1;
(statearr_27113_27135[(2)] = null);

(statearr_27113_27135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto___27125,out))
;
return ((function (switch__18676__auto__,c__18741__auto___27125,out){
return (function() {
var cljs$core$async$state_machine__18677__auto__ = null;
var cljs$core$async$state_machine__18677__auto____0 = (function (){
var statearr_27117 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27117[(0)] = cljs$core$async$state_machine__18677__auto__);

(statearr_27117[(1)] = (1));

return statearr_27117;
});
var cljs$core$async$state_machine__18677__auto____1 = (function (state_27097){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_27097);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e27118){if((e27118 instanceof Object)){
var ex__18680__auto__ = e27118;
var statearr_27119_27136 = state_27097;
(statearr_27119_27136[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27097);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27118;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27137 = state_27097;
state_27097 = G__27137;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$state_machine__18677__auto__ = function(state_27097){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18677__auto____1.call(this,state_27097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18677__auto____0;
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18677__auto____1;
return cljs$core$async$state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___27125,out))
})();
var state__18743__auto__ = (function (){var statearr_27120 = f__18742__auto__.call(null);
(statearr_27120[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___27125);

return statearr_27120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___27125,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args27138 = [];
var len__17716__auto___27187 = arguments.length;
var i__17717__auto___27188 = (0);
while(true){
if((i__17717__auto___27188 < len__17716__auto___27187)){
args27138.push((arguments[i__17717__auto___27188]));

var G__27189 = (i__17717__auto___27188 + (1));
i__17717__auto___27188 = G__27189;
continue;
} else {
}
break;
}

var G__27140 = args27138.length;
switch (G__27140) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27138.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18741__auto___27191 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___27191,out){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___27191,out){
return (function (state_27164){
var state_val_27165 = (state_27164[(1)]);
if((state_val_27165 === (7))){
var inst_27146 = (state_27164[(7)]);
var inst_27146__$1 = (state_27164[(2)]);
var inst_27147 = (inst_27146__$1 == null);
var inst_27148 = cljs.core.not.call(null,inst_27147);
var state_27164__$1 = (function (){var statearr_27166 = state_27164;
(statearr_27166[(7)] = inst_27146__$1);

return statearr_27166;
})();
if(inst_27148){
var statearr_27167_27192 = state_27164__$1;
(statearr_27167_27192[(1)] = (8));

} else {
var statearr_27168_27193 = state_27164__$1;
(statearr_27168_27193[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (1))){
var inst_27141 = (0);
var state_27164__$1 = (function (){var statearr_27169 = state_27164;
(statearr_27169[(8)] = inst_27141);

return statearr_27169;
})();
var statearr_27170_27194 = state_27164__$1;
(statearr_27170_27194[(2)] = null);

(statearr_27170_27194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (4))){
var state_27164__$1 = state_27164;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27164__$1,(7),ch);
} else {
if((state_val_27165 === (6))){
var inst_27159 = (state_27164[(2)]);
var state_27164__$1 = state_27164;
var statearr_27171_27195 = state_27164__$1;
(statearr_27171_27195[(2)] = inst_27159);

(statearr_27171_27195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (3))){
var inst_27161 = (state_27164[(2)]);
var inst_27162 = cljs.core.async.close_BANG_.call(null,out);
var state_27164__$1 = (function (){var statearr_27172 = state_27164;
(statearr_27172[(9)] = inst_27161);

return statearr_27172;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27164__$1,inst_27162);
} else {
if((state_val_27165 === (2))){
var inst_27141 = (state_27164[(8)]);
var inst_27143 = (inst_27141 < n);
var state_27164__$1 = state_27164;
if(cljs.core.truth_(inst_27143)){
var statearr_27173_27196 = state_27164__$1;
(statearr_27173_27196[(1)] = (4));

} else {
var statearr_27174_27197 = state_27164__$1;
(statearr_27174_27197[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (11))){
var inst_27141 = (state_27164[(8)]);
var inst_27151 = (state_27164[(2)]);
var inst_27152 = (inst_27141 + (1));
var inst_27141__$1 = inst_27152;
var state_27164__$1 = (function (){var statearr_27175 = state_27164;
(statearr_27175[(10)] = inst_27151);

(statearr_27175[(8)] = inst_27141__$1);

return statearr_27175;
})();
var statearr_27176_27198 = state_27164__$1;
(statearr_27176_27198[(2)] = null);

(statearr_27176_27198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (9))){
var state_27164__$1 = state_27164;
var statearr_27177_27199 = state_27164__$1;
(statearr_27177_27199[(2)] = null);

(statearr_27177_27199[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (5))){
var state_27164__$1 = state_27164;
var statearr_27178_27200 = state_27164__$1;
(statearr_27178_27200[(2)] = null);

(statearr_27178_27200[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (10))){
var inst_27156 = (state_27164[(2)]);
var state_27164__$1 = state_27164;
var statearr_27179_27201 = state_27164__$1;
(statearr_27179_27201[(2)] = inst_27156);

(statearr_27179_27201[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27165 === (8))){
var inst_27146 = (state_27164[(7)]);
var state_27164__$1 = state_27164;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27164__$1,(11),out,inst_27146);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto___27191,out))
;
return ((function (switch__18676__auto__,c__18741__auto___27191,out){
return (function() {
var cljs$core$async$state_machine__18677__auto__ = null;
var cljs$core$async$state_machine__18677__auto____0 = (function (){
var statearr_27183 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27183[(0)] = cljs$core$async$state_machine__18677__auto__);

(statearr_27183[(1)] = (1));

return statearr_27183;
});
var cljs$core$async$state_machine__18677__auto____1 = (function (state_27164){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_27164);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e27184){if((e27184 instanceof Object)){
var ex__18680__auto__ = e27184;
var statearr_27185_27202 = state_27164;
(statearr_27185_27202[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27164);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27184;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27203 = state_27164;
state_27164 = G__27203;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$state_machine__18677__auto__ = function(state_27164){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18677__auto____1.call(this,state_27164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18677__auto____0;
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18677__auto____1;
return cljs$core$async$state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___27191,out))
})();
var state__18743__auto__ = (function (){var statearr_27186 = f__18742__auto__.call(null);
(statearr_27186[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___27191);

return statearr_27186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___27191,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async27211 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27211 = (function (map_LT_,f,ch,meta27212){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta27212 = meta27212;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async27211.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27213,meta27212__$1){
var self__ = this;
var _27213__$1 = this;
return (new cljs.core.async.t_cljs$core$async27211(self__.map_LT_,self__.f,self__.ch,meta27212__$1));
});

cljs.core.async.t_cljs$core$async27211.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27213){
var self__ = this;
var _27213__$1 = this;
return self__.meta27212;
});

cljs.core.async.t_cljs$core$async27211.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async27211.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27211.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27211.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async27211.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async27214 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27214 = (function (map_LT_,f,ch,meta27212,_,fn1,meta27215){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta27212 = meta27212;
this._ = _;
this.fn1 = fn1;
this.meta27215 = meta27215;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async27214.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_27216,meta27215__$1){
var self__ = this;
var _27216__$1 = this;
return (new cljs.core.async.t_cljs$core$async27214(self__.map_LT_,self__.f,self__.ch,self__.meta27212,self__._,self__.fn1,meta27215__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async27214.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_27216){
var self__ = this;
var _27216__$1 = this;
return self__.meta27215;
});})(___$1))
;

cljs.core.async.t_cljs$core$async27214.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async27214.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async27214.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async27214.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__27204_SHARP_){
return f1.call(null,(((p1__27204_SHARP_ == null))?null:self__.f.call(null,p1__27204_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async27214.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta27212","meta27212",-1565598941,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async27211","cljs.core.async/t_cljs$core$async27211",275689949,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta27215","meta27215",608153883,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async27214.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27214.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27214";

cljs.core.async.t_cljs$core$async27214.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__17256__auto__,writer__17257__auto__,opt__17258__auto__){
return cljs.core._write.call(null,writer__17257__auto__,"cljs.core.async/t_cljs$core$async27214");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async27214 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async27214(map_LT___$1,f__$1,ch__$1,meta27212__$1,___$2,fn1__$1,meta27215){
return (new cljs.core.async.t_cljs$core$async27214(map_LT___$1,f__$1,ch__$1,meta27212__$1,___$2,fn1__$1,meta27215));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async27214(self__.map_LT_,self__.f,self__.ch,self__.meta27212,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__16646__auto__ = ret;
if(cljs.core.truth_(and__16646__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__16646__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async27211.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async27211.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async27211.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta27212","meta27212",-1565598941,null)], null);
});

cljs.core.async.t_cljs$core$async27211.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27211.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27211";

cljs.core.async.t_cljs$core$async27211.cljs$lang$ctorPrWriter = (function (this__17256__auto__,writer__17257__auto__,opt__17258__auto__){
return cljs.core._write.call(null,writer__17257__auto__,"cljs.core.async/t_cljs$core$async27211");
});

cljs.core.async.__GT_t_cljs$core$async27211 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async27211(map_LT___$1,f__$1,ch__$1,meta27212){
return (new cljs.core.async.t_cljs$core$async27211(map_LT___$1,f__$1,ch__$1,meta27212));
});

}

return (new cljs.core.async.t_cljs$core$async27211(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async27220 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27220 = (function (map_GT_,f,ch,meta27221){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta27221 = meta27221;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async27220.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27222,meta27221__$1){
var self__ = this;
var _27222__$1 = this;
return (new cljs.core.async.t_cljs$core$async27220(self__.map_GT_,self__.f,self__.ch,meta27221__$1));
});

cljs.core.async.t_cljs$core$async27220.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27222){
var self__ = this;
var _27222__$1 = this;
return self__.meta27221;
});

cljs.core.async.t_cljs$core$async27220.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async27220.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27220.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async27220.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async27220.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async27220.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async27220.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta27221","meta27221",-22798367,null)], null);
});

cljs.core.async.t_cljs$core$async27220.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27220.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27220";

cljs.core.async.t_cljs$core$async27220.cljs$lang$ctorPrWriter = (function (this__17256__auto__,writer__17257__auto__,opt__17258__auto__){
return cljs.core._write.call(null,writer__17257__auto__,"cljs.core.async/t_cljs$core$async27220");
});

cljs.core.async.__GT_t_cljs$core$async27220 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async27220(map_GT___$1,f__$1,ch__$1,meta27221){
return (new cljs.core.async.t_cljs$core$async27220(map_GT___$1,f__$1,ch__$1,meta27221));
});

}

return (new cljs.core.async.t_cljs$core$async27220(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async27226 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27226 = (function (filter_GT_,p,ch,meta27227){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta27227 = meta27227;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27228,meta27227__$1){
var self__ = this;
var _27228__$1 = this;
return (new cljs.core.async.t_cljs$core$async27226(self__.filter_GT_,self__.p,self__.ch,meta27227__$1));
});

cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27228){
var self__ = this;
var _27228__$1 = this;
return self__.meta27227;
});

cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async27226.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta27227","meta27227",-853501250,null)], null);
});

cljs.core.async.t_cljs$core$async27226.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27226.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27226";

cljs.core.async.t_cljs$core$async27226.cljs$lang$ctorPrWriter = (function (this__17256__auto__,writer__17257__auto__,opt__17258__auto__){
return cljs.core._write.call(null,writer__17257__auto__,"cljs.core.async/t_cljs$core$async27226");
});

cljs.core.async.__GT_t_cljs$core$async27226 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async27226(filter_GT___$1,p__$1,ch__$1,meta27227){
return (new cljs.core.async.t_cljs$core$async27226(filter_GT___$1,p__$1,ch__$1,meta27227));
});

}

return (new cljs.core.async.t_cljs$core$async27226(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args27229 = [];
var len__17716__auto___27273 = arguments.length;
var i__17717__auto___27274 = (0);
while(true){
if((i__17717__auto___27274 < len__17716__auto___27273)){
args27229.push((arguments[i__17717__auto___27274]));

var G__27275 = (i__17717__auto___27274 + (1));
i__17717__auto___27274 = G__27275;
continue;
} else {
}
break;
}

var G__27231 = args27229.length;
switch (G__27231) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27229.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18741__auto___27277 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___27277,out){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___27277,out){
return (function (state_27252){
var state_val_27253 = (state_27252[(1)]);
if((state_val_27253 === (7))){
var inst_27248 = (state_27252[(2)]);
var state_27252__$1 = state_27252;
var statearr_27254_27278 = state_27252__$1;
(statearr_27254_27278[(2)] = inst_27248);

(statearr_27254_27278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27253 === (1))){
var state_27252__$1 = state_27252;
var statearr_27255_27279 = state_27252__$1;
(statearr_27255_27279[(2)] = null);

(statearr_27255_27279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27253 === (4))){
var inst_27234 = (state_27252[(7)]);
var inst_27234__$1 = (state_27252[(2)]);
var inst_27235 = (inst_27234__$1 == null);
var state_27252__$1 = (function (){var statearr_27256 = state_27252;
(statearr_27256[(7)] = inst_27234__$1);

return statearr_27256;
})();
if(cljs.core.truth_(inst_27235)){
var statearr_27257_27280 = state_27252__$1;
(statearr_27257_27280[(1)] = (5));

} else {
var statearr_27258_27281 = state_27252__$1;
(statearr_27258_27281[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27253 === (6))){
var inst_27234 = (state_27252[(7)]);
var inst_27239 = p.call(null,inst_27234);
var state_27252__$1 = state_27252;
if(cljs.core.truth_(inst_27239)){
var statearr_27259_27282 = state_27252__$1;
(statearr_27259_27282[(1)] = (8));

} else {
var statearr_27260_27283 = state_27252__$1;
(statearr_27260_27283[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27253 === (3))){
var inst_27250 = (state_27252[(2)]);
var state_27252__$1 = state_27252;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27252__$1,inst_27250);
} else {
if((state_val_27253 === (2))){
var state_27252__$1 = state_27252;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27252__$1,(4),ch);
} else {
if((state_val_27253 === (11))){
var inst_27242 = (state_27252[(2)]);
var state_27252__$1 = state_27252;
var statearr_27261_27284 = state_27252__$1;
(statearr_27261_27284[(2)] = inst_27242);

(statearr_27261_27284[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27253 === (9))){
var state_27252__$1 = state_27252;
var statearr_27262_27285 = state_27252__$1;
(statearr_27262_27285[(2)] = null);

(statearr_27262_27285[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27253 === (5))){
var inst_27237 = cljs.core.async.close_BANG_.call(null,out);
var state_27252__$1 = state_27252;
var statearr_27263_27286 = state_27252__$1;
(statearr_27263_27286[(2)] = inst_27237);

(statearr_27263_27286[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27253 === (10))){
var inst_27245 = (state_27252[(2)]);
var state_27252__$1 = (function (){var statearr_27264 = state_27252;
(statearr_27264[(8)] = inst_27245);

return statearr_27264;
})();
var statearr_27265_27287 = state_27252__$1;
(statearr_27265_27287[(2)] = null);

(statearr_27265_27287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27253 === (8))){
var inst_27234 = (state_27252[(7)]);
var state_27252__$1 = state_27252;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27252__$1,(11),out,inst_27234);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto___27277,out))
;
return ((function (switch__18676__auto__,c__18741__auto___27277,out){
return (function() {
var cljs$core$async$state_machine__18677__auto__ = null;
var cljs$core$async$state_machine__18677__auto____0 = (function (){
var statearr_27269 = [null,null,null,null,null,null,null,null,null];
(statearr_27269[(0)] = cljs$core$async$state_machine__18677__auto__);

(statearr_27269[(1)] = (1));

return statearr_27269;
});
var cljs$core$async$state_machine__18677__auto____1 = (function (state_27252){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_27252);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e27270){if((e27270 instanceof Object)){
var ex__18680__auto__ = e27270;
var statearr_27271_27288 = state_27252;
(statearr_27271_27288[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27252);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27270;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27289 = state_27252;
state_27252 = G__27289;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$state_machine__18677__auto__ = function(state_27252){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18677__auto____1.call(this,state_27252);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18677__auto____0;
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18677__auto____1;
return cljs$core$async$state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___27277,out))
})();
var state__18743__auto__ = (function (){var statearr_27272 = f__18742__auto__.call(null);
(statearr_27272[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___27277);

return statearr_27272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___27277,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args27290 = [];
var len__17716__auto___27293 = arguments.length;
var i__17717__auto___27294 = (0);
while(true){
if((i__17717__auto___27294 < len__17716__auto___27293)){
args27290.push((arguments[i__17717__auto___27294]));

var G__27295 = (i__17717__auto___27294 + (1));
i__17717__auto___27294 = G__27295;
continue;
} else {
}
break;
}

var G__27292 = args27290.length;
switch (G__27292) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27290.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__18741__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto__){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto__){
return (function (state_27462){
var state_val_27463 = (state_27462[(1)]);
if((state_val_27463 === (7))){
var inst_27458 = (state_27462[(2)]);
var state_27462__$1 = state_27462;
var statearr_27464_27505 = state_27462__$1;
(statearr_27464_27505[(2)] = inst_27458);

(statearr_27464_27505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (20))){
var inst_27428 = (state_27462[(7)]);
var inst_27439 = (state_27462[(2)]);
var inst_27440 = cljs.core.next.call(null,inst_27428);
var inst_27414 = inst_27440;
var inst_27415 = null;
var inst_27416 = (0);
var inst_27417 = (0);
var state_27462__$1 = (function (){var statearr_27465 = state_27462;
(statearr_27465[(8)] = inst_27415);

(statearr_27465[(9)] = inst_27414);

(statearr_27465[(10)] = inst_27416);

(statearr_27465[(11)] = inst_27439);

(statearr_27465[(12)] = inst_27417);

return statearr_27465;
})();
var statearr_27466_27506 = state_27462__$1;
(statearr_27466_27506[(2)] = null);

(statearr_27466_27506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (1))){
var state_27462__$1 = state_27462;
var statearr_27467_27507 = state_27462__$1;
(statearr_27467_27507[(2)] = null);

(statearr_27467_27507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (4))){
var inst_27403 = (state_27462[(13)]);
var inst_27403__$1 = (state_27462[(2)]);
var inst_27404 = (inst_27403__$1 == null);
var state_27462__$1 = (function (){var statearr_27468 = state_27462;
(statearr_27468[(13)] = inst_27403__$1);

return statearr_27468;
})();
if(cljs.core.truth_(inst_27404)){
var statearr_27469_27508 = state_27462__$1;
(statearr_27469_27508[(1)] = (5));

} else {
var statearr_27470_27509 = state_27462__$1;
(statearr_27470_27509[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (15))){
var state_27462__$1 = state_27462;
var statearr_27474_27510 = state_27462__$1;
(statearr_27474_27510[(2)] = null);

(statearr_27474_27510[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (21))){
var state_27462__$1 = state_27462;
var statearr_27475_27511 = state_27462__$1;
(statearr_27475_27511[(2)] = null);

(statearr_27475_27511[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (13))){
var inst_27415 = (state_27462[(8)]);
var inst_27414 = (state_27462[(9)]);
var inst_27416 = (state_27462[(10)]);
var inst_27417 = (state_27462[(12)]);
var inst_27424 = (state_27462[(2)]);
var inst_27425 = (inst_27417 + (1));
var tmp27471 = inst_27415;
var tmp27472 = inst_27414;
var tmp27473 = inst_27416;
var inst_27414__$1 = tmp27472;
var inst_27415__$1 = tmp27471;
var inst_27416__$1 = tmp27473;
var inst_27417__$1 = inst_27425;
var state_27462__$1 = (function (){var statearr_27476 = state_27462;
(statearr_27476[(8)] = inst_27415__$1);

(statearr_27476[(9)] = inst_27414__$1);

(statearr_27476[(10)] = inst_27416__$1);

(statearr_27476[(12)] = inst_27417__$1);

(statearr_27476[(14)] = inst_27424);

return statearr_27476;
})();
var statearr_27477_27512 = state_27462__$1;
(statearr_27477_27512[(2)] = null);

(statearr_27477_27512[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (22))){
var state_27462__$1 = state_27462;
var statearr_27478_27513 = state_27462__$1;
(statearr_27478_27513[(2)] = null);

(statearr_27478_27513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (6))){
var inst_27403 = (state_27462[(13)]);
var inst_27412 = f.call(null,inst_27403);
var inst_27413 = cljs.core.seq.call(null,inst_27412);
var inst_27414 = inst_27413;
var inst_27415 = null;
var inst_27416 = (0);
var inst_27417 = (0);
var state_27462__$1 = (function (){var statearr_27479 = state_27462;
(statearr_27479[(8)] = inst_27415);

(statearr_27479[(9)] = inst_27414);

(statearr_27479[(10)] = inst_27416);

(statearr_27479[(12)] = inst_27417);

return statearr_27479;
})();
var statearr_27480_27514 = state_27462__$1;
(statearr_27480_27514[(2)] = null);

(statearr_27480_27514[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (17))){
var inst_27428 = (state_27462[(7)]);
var inst_27432 = cljs.core.chunk_first.call(null,inst_27428);
var inst_27433 = cljs.core.chunk_rest.call(null,inst_27428);
var inst_27434 = cljs.core.count.call(null,inst_27432);
var inst_27414 = inst_27433;
var inst_27415 = inst_27432;
var inst_27416 = inst_27434;
var inst_27417 = (0);
var state_27462__$1 = (function (){var statearr_27481 = state_27462;
(statearr_27481[(8)] = inst_27415);

(statearr_27481[(9)] = inst_27414);

(statearr_27481[(10)] = inst_27416);

(statearr_27481[(12)] = inst_27417);

return statearr_27481;
})();
var statearr_27482_27515 = state_27462__$1;
(statearr_27482_27515[(2)] = null);

(statearr_27482_27515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (3))){
var inst_27460 = (state_27462[(2)]);
var state_27462__$1 = state_27462;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27462__$1,inst_27460);
} else {
if((state_val_27463 === (12))){
var inst_27448 = (state_27462[(2)]);
var state_27462__$1 = state_27462;
var statearr_27483_27516 = state_27462__$1;
(statearr_27483_27516[(2)] = inst_27448);

(statearr_27483_27516[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (2))){
var state_27462__$1 = state_27462;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27462__$1,(4),in$);
} else {
if((state_val_27463 === (23))){
var inst_27456 = (state_27462[(2)]);
var state_27462__$1 = state_27462;
var statearr_27484_27517 = state_27462__$1;
(statearr_27484_27517[(2)] = inst_27456);

(statearr_27484_27517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (19))){
var inst_27443 = (state_27462[(2)]);
var state_27462__$1 = state_27462;
var statearr_27485_27518 = state_27462__$1;
(statearr_27485_27518[(2)] = inst_27443);

(statearr_27485_27518[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (11))){
var inst_27428 = (state_27462[(7)]);
var inst_27414 = (state_27462[(9)]);
var inst_27428__$1 = cljs.core.seq.call(null,inst_27414);
var state_27462__$1 = (function (){var statearr_27486 = state_27462;
(statearr_27486[(7)] = inst_27428__$1);

return statearr_27486;
})();
if(inst_27428__$1){
var statearr_27487_27519 = state_27462__$1;
(statearr_27487_27519[(1)] = (14));

} else {
var statearr_27488_27520 = state_27462__$1;
(statearr_27488_27520[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (9))){
var inst_27450 = (state_27462[(2)]);
var inst_27451 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_27462__$1 = (function (){var statearr_27489 = state_27462;
(statearr_27489[(15)] = inst_27450);

return statearr_27489;
})();
if(cljs.core.truth_(inst_27451)){
var statearr_27490_27521 = state_27462__$1;
(statearr_27490_27521[(1)] = (21));

} else {
var statearr_27491_27522 = state_27462__$1;
(statearr_27491_27522[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (5))){
var inst_27406 = cljs.core.async.close_BANG_.call(null,out);
var state_27462__$1 = state_27462;
var statearr_27492_27523 = state_27462__$1;
(statearr_27492_27523[(2)] = inst_27406);

(statearr_27492_27523[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (14))){
var inst_27428 = (state_27462[(7)]);
var inst_27430 = cljs.core.chunked_seq_QMARK_.call(null,inst_27428);
var state_27462__$1 = state_27462;
if(inst_27430){
var statearr_27493_27524 = state_27462__$1;
(statearr_27493_27524[(1)] = (17));

} else {
var statearr_27494_27525 = state_27462__$1;
(statearr_27494_27525[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (16))){
var inst_27446 = (state_27462[(2)]);
var state_27462__$1 = state_27462;
var statearr_27495_27526 = state_27462__$1;
(statearr_27495_27526[(2)] = inst_27446);

(statearr_27495_27526[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27463 === (10))){
var inst_27415 = (state_27462[(8)]);
var inst_27417 = (state_27462[(12)]);
var inst_27422 = cljs.core._nth.call(null,inst_27415,inst_27417);
var state_27462__$1 = state_27462;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27462__$1,(13),out,inst_27422);
} else {
if((state_val_27463 === (18))){
var inst_27428 = (state_27462[(7)]);
var inst_27437 = cljs.core.first.call(null,inst_27428);
var state_27462__$1 = state_27462;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27462__$1,(20),out,inst_27437);
} else {
if((state_val_27463 === (8))){
var inst_27416 = (state_27462[(10)]);
var inst_27417 = (state_27462[(12)]);
var inst_27419 = (inst_27417 < inst_27416);
var inst_27420 = inst_27419;
var state_27462__$1 = state_27462;
if(cljs.core.truth_(inst_27420)){
var statearr_27496_27527 = state_27462__$1;
(statearr_27496_27527[(1)] = (10));

} else {
var statearr_27497_27528 = state_27462__$1;
(statearr_27497_27528[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto__))
;
return ((function (switch__18676__auto__,c__18741__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__18677__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__18677__auto____0 = (function (){
var statearr_27501 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27501[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__18677__auto__);

(statearr_27501[(1)] = (1));

return statearr_27501;
});
var cljs$core$async$mapcat_STAR__$_state_machine__18677__auto____1 = (function (state_27462){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_27462);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e27502){if((e27502 instanceof Object)){
var ex__18680__auto__ = e27502;
var statearr_27503_27529 = state_27462;
(statearr_27503_27529[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27462);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27502;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27530 = state_27462;
state_27462 = G__27530;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__18677__auto__ = function(state_27462){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__18677__auto____1.call(this,state_27462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__18677__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__18677__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto__))
})();
var state__18743__auto__ = (function (){var statearr_27504 = f__18742__auto__.call(null);
(statearr_27504[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto__);

return statearr_27504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto__))
);

return c__18741__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args27531 = [];
var len__17716__auto___27534 = arguments.length;
var i__17717__auto___27535 = (0);
while(true){
if((i__17717__auto___27535 < len__17716__auto___27534)){
args27531.push((arguments[i__17717__auto___27535]));

var G__27536 = (i__17717__auto___27535 + (1));
i__17717__auto___27535 = G__27536;
continue;
} else {
}
break;
}

var G__27533 = args27531.length;
switch (G__27533) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27531.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args27538 = [];
var len__17716__auto___27541 = arguments.length;
var i__17717__auto___27542 = (0);
while(true){
if((i__17717__auto___27542 < len__17716__auto___27541)){
args27538.push((arguments[i__17717__auto___27542]));

var G__27543 = (i__17717__auto___27542 + (1));
i__17717__auto___27542 = G__27543;
continue;
} else {
}
break;
}

var G__27540 = args27538.length;
switch (G__27540) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27538.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args27545 = [];
var len__17716__auto___27596 = arguments.length;
var i__17717__auto___27597 = (0);
while(true){
if((i__17717__auto___27597 < len__17716__auto___27596)){
args27545.push((arguments[i__17717__auto___27597]));

var G__27598 = (i__17717__auto___27597 + (1));
i__17717__auto___27597 = G__27598;
continue;
} else {
}
break;
}

var G__27547 = args27545.length;
switch (G__27547) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27545.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18741__auto___27600 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___27600,out){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___27600,out){
return (function (state_27571){
var state_val_27572 = (state_27571[(1)]);
if((state_val_27572 === (7))){
var inst_27566 = (state_27571[(2)]);
var state_27571__$1 = state_27571;
var statearr_27573_27601 = state_27571__$1;
(statearr_27573_27601[(2)] = inst_27566);

(statearr_27573_27601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27572 === (1))){
var inst_27548 = null;
var state_27571__$1 = (function (){var statearr_27574 = state_27571;
(statearr_27574[(7)] = inst_27548);

return statearr_27574;
})();
var statearr_27575_27602 = state_27571__$1;
(statearr_27575_27602[(2)] = null);

(statearr_27575_27602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27572 === (4))){
var inst_27551 = (state_27571[(8)]);
var inst_27551__$1 = (state_27571[(2)]);
var inst_27552 = (inst_27551__$1 == null);
var inst_27553 = cljs.core.not.call(null,inst_27552);
var state_27571__$1 = (function (){var statearr_27576 = state_27571;
(statearr_27576[(8)] = inst_27551__$1);

return statearr_27576;
})();
if(inst_27553){
var statearr_27577_27603 = state_27571__$1;
(statearr_27577_27603[(1)] = (5));

} else {
var statearr_27578_27604 = state_27571__$1;
(statearr_27578_27604[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27572 === (6))){
var state_27571__$1 = state_27571;
var statearr_27579_27605 = state_27571__$1;
(statearr_27579_27605[(2)] = null);

(statearr_27579_27605[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27572 === (3))){
var inst_27568 = (state_27571[(2)]);
var inst_27569 = cljs.core.async.close_BANG_.call(null,out);
var state_27571__$1 = (function (){var statearr_27580 = state_27571;
(statearr_27580[(9)] = inst_27568);

return statearr_27580;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27571__$1,inst_27569);
} else {
if((state_val_27572 === (2))){
var state_27571__$1 = state_27571;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27571__$1,(4),ch);
} else {
if((state_val_27572 === (11))){
var inst_27551 = (state_27571[(8)]);
var inst_27560 = (state_27571[(2)]);
var inst_27548 = inst_27551;
var state_27571__$1 = (function (){var statearr_27581 = state_27571;
(statearr_27581[(7)] = inst_27548);

(statearr_27581[(10)] = inst_27560);

return statearr_27581;
})();
var statearr_27582_27606 = state_27571__$1;
(statearr_27582_27606[(2)] = null);

(statearr_27582_27606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27572 === (9))){
var inst_27551 = (state_27571[(8)]);
var state_27571__$1 = state_27571;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27571__$1,(11),out,inst_27551);
} else {
if((state_val_27572 === (5))){
var inst_27551 = (state_27571[(8)]);
var inst_27548 = (state_27571[(7)]);
var inst_27555 = cljs.core._EQ_.call(null,inst_27551,inst_27548);
var state_27571__$1 = state_27571;
if(inst_27555){
var statearr_27584_27607 = state_27571__$1;
(statearr_27584_27607[(1)] = (8));

} else {
var statearr_27585_27608 = state_27571__$1;
(statearr_27585_27608[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27572 === (10))){
var inst_27563 = (state_27571[(2)]);
var state_27571__$1 = state_27571;
var statearr_27586_27609 = state_27571__$1;
(statearr_27586_27609[(2)] = inst_27563);

(statearr_27586_27609[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27572 === (8))){
var inst_27548 = (state_27571[(7)]);
var tmp27583 = inst_27548;
var inst_27548__$1 = tmp27583;
var state_27571__$1 = (function (){var statearr_27587 = state_27571;
(statearr_27587[(7)] = inst_27548__$1);

return statearr_27587;
})();
var statearr_27588_27610 = state_27571__$1;
(statearr_27588_27610[(2)] = null);

(statearr_27588_27610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto___27600,out))
;
return ((function (switch__18676__auto__,c__18741__auto___27600,out){
return (function() {
var cljs$core$async$state_machine__18677__auto__ = null;
var cljs$core$async$state_machine__18677__auto____0 = (function (){
var statearr_27592 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27592[(0)] = cljs$core$async$state_machine__18677__auto__);

(statearr_27592[(1)] = (1));

return statearr_27592;
});
var cljs$core$async$state_machine__18677__auto____1 = (function (state_27571){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_27571);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e27593){if((e27593 instanceof Object)){
var ex__18680__auto__ = e27593;
var statearr_27594_27611 = state_27571;
(statearr_27594_27611[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27571);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27593;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27612 = state_27571;
state_27571 = G__27612;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$state_machine__18677__auto__ = function(state_27571){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18677__auto____1.call(this,state_27571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18677__auto____0;
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18677__auto____1;
return cljs$core$async$state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___27600,out))
})();
var state__18743__auto__ = (function (){var statearr_27595 = f__18742__auto__.call(null);
(statearr_27595[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___27600);

return statearr_27595;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___27600,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args27613 = [];
var len__17716__auto___27683 = arguments.length;
var i__17717__auto___27684 = (0);
while(true){
if((i__17717__auto___27684 < len__17716__auto___27683)){
args27613.push((arguments[i__17717__auto___27684]));

var G__27685 = (i__17717__auto___27684 + (1));
i__17717__auto___27684 = G__27685;
continue;
} else {
}
break;
}

var G__27615 = args27613.length;
switch (G__27615) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27613.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18741__auto___27687 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___27687,out){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___27687,out){
return (function (state_27653){
var state_val_27654 = (state_27653[(1)]);
if((state_val_27654 === (7))){
var inst_27649 = (state_27653[(2)]);
var state_27653__$1 = state_27653;
var statearr_27655_27688 = state_27653__$1;
(statearr_27655_27688[(2)] = inst_27649);

(statearr_27655_27688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (1))){
var inst_27616 = (new Array(n));
var inst_27617 = inst_27616;
var inst_27618 = (0);
var state_27653__$1 = (function (){var statearr_27656 = state_27653;
(statearr_27656[(7)] = inst_27617);

(statearr_27656[(8)] = inst_27618);

return statearr_27656;
})();
var statearr_27657_27689 = state_27653__$1;
(statearr_27657_27689[(2)] = null);

(statearr_27657_27689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (4))){
var inst_27621 = (state_27653[(9)]);
var inst_27621__$1 = (state_27653[(2)]);
var inst_27622 = (inst_27621__$1 == null);
var inst_27623 = cljs.core.not.call(null,inst_27622);
var state_27653__$1 = (function (){var statearr_27658 = state_27653;
(statearr_27658[(9)] = inst_27621__$1);

return statearr_27658;
})();
if(inst_27623){
var statearr_27659_27690 = state_27653__$1;
(statearr_27659_27690[(1)] = (5));

} else {
var statearr_27660_27691 = state_27653__$1;
(statearr_27660_27691[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (15))){
var inst_27643 = (state_27653[(2)]);
var state_27653__$1 = state_27653;
var statearr_27661_27692 = state_27653__$1;
(statearr_27661_27692[(2)] = inst_27643);

(statearr_27661_27692[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (13))){
var state_27653__$1 = state_27653;
var statearr_27662_27693 = state_27653__$1;
(statearr_27662_27693[(2)] = null);

(statearr_27662_27693[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (6))){
var inst_27618 = (state_27653[(8)]);
var inst_27639 = (inst_27618 > (0));
var state_27653__$1 = state_27653;
if(cljs.core.truth_(inst_27639)){
var statearr_27663_27694 = state_27653__$1;
(statearr_27663_27694[(1)] = (12));

} else {
var statearr_27664_27695 = state_27653__$1;
(statearr_27664_27695[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (3))){
var inst_27651 = (state_27653[(2)]);
var state_27653__$1 = state_27653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27653__$1,inst_27651);
} else {
if((state_val_27654 === (12))){
var inst_27617 = (state_27653[(7)]);
var inst_27641 = cljs.core.vec.call(null,inst_27617);
var state_27653__$1 = state_27653;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27653__$1,(15),out,inst_27641);
} else {
if((state_val_27654 === (2))){
var state_27653__$1 = state_27653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27653__$1,(4),ch);
} else {
if((state_val_27654 === (11))){
var inst_27633 = (state_27653[(2)]);
var inst_27634 = (new Array(n));
var inst_27617 = inst_27634;
var inst_27618 = (0);
var state_27653__$1 = (function (){var statearr_27665 = state_27653;
(statearr_27665[(10)] = inst_27633);

(statearr_27665[(7)] = inst_27617);

(statearr_27665[(8)] = inst_27618);

return statearr_27665;
})();
var statearr_27666_27696 = state_27653__$1;
(statearr_27666_27696[(2)] = null);

(statearr_27666_27696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (9))){
var inst_27617 = (state_27653[(7)]);
var inst_27631 = cljs.core.vec.call(null,inst_27617);
var state_27653__$1 = state_27653;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27653__$1,(11),out,inst_27631);
} else {
if((state_val_27654 === (5))){
var inst_27617 = (state_27653[(7)]);
var inst_27621 = (state_27653[(9)]);
var inst_27618 = (state_27653[(8)]);
var inst_27626 = (state_27653[(11)]);
var inst_27625 = (inst_27617[inst_27618] = inst_27621);
var inst_27626__$1 = (inst_27618 + (1));
var inst_27627 = (inst_27626__$1 < n);
var state_27653__$1 = (function (){var statearr_27667 = state_27653;
(statearr_27667[(12)] = inst_27625);

(statearr_27667[(11)] = inst_27626__$1);

return statearr_27667;
})();
if(cljs.core.truth_(inst_27627)){
var statearr_27668_27697 = state_27653__$1;
(statearr_27668_27697[(1)] = (8));

} else {
var statearr_27669_27698 = state_27653__$1;
(statearr_27669_27698[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (14))){
var inst_27646 = (state_27653[(2)]);
var inst_27647 = cljs.core.async.close_BANG_.call(null,out);
var state_27653__$1 = (function (){var statearr_27671 = state_27653;
(statearr_27671[(13)] = inst_27646);

return statearr_27671;
})();
var statearr_27672_27699 = state_27653__$1;
(statearr_27672_27699[(2)] = inst_27647);

(statearr_27672_27699[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (10))){
var inst_27637 = (state_27653[(2)]);
var state_27653__$1 = state_27653;
var statearr_27673_27700 = state_27653__$1;
(statearr_27673_27700[(2)] = inst_27637);

(statearr_27673_27700[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27654 === (8))){
var inst_27617 = (state_27653[(7)]);
var inst_27626 = (state_27653[(11)]);
var tmp27670 = inst_27617;
var inst_27617__$1 = tmp27670;
var inst_27618 = inst_27626;
var state_27653__$1 = (function (){var statearr_27674 = state_27653;
(statearr_27674[(7)] = inst_27617__$1);

(statearr_27674[(8)] = inst_27618);

return statearr_27674;
})();
var statearr_27675_27701 = state_27653__$1;
(statearr_27675_27701[(2)] = null);

(statearr_27675_27701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto___27687,out))
;
return ((function (switch__18676__auto__,c__18741__auto___27687,out){
return (function() {
var cljs$core$async$state_machine__18677__auto__ = null;
var cljs$core$async$state_machine__18677__auto____0 = (function (){
var statearr_27679 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27679[(0)] = cljs$core$async$state_machine__18677__auto__);

(statearr_27679[(1)] = (1));

return statearr_27679;
});
var cljs$core$async$state_machine__18677__auto____1 = (function (state_27653){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_27653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e27680){if((e27680 instanceof Object)){
var ex__18680__auto__ = e27680;
var statearr_27681_27702 = state_27653;
(statearr_27681_27702[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27653);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27680;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27703 = state_27653;
state_27653 = G__27703;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$state_machine__18677__auto__ = function(state_27653){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18677__auto____1.call(this,state_27653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18677__auto____0;
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18677__auto____1;
return cljs$core$async$state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___27687,out))
})();
var state__18743__auto__ = (function (){var statearr_27682 = f__18742__auto__.call(null);
(statearr_27682[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___27687);

return statearr_27682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___27687,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args27704 = [];
var len__17716__auto___27778 = arguments.length;
var i__17717__auto___27779 = (0);
while(true){
if((i__17717__auto___27779 < len__17716__auto___27778)){
args27704.push((arguments[i__17717__auto___27779]));

var G__27780 = (i__17717__auto___27779 + (1));
i__17717__auto___27779 = G__27780;
continue;
} else {
}
break;
}

var G__27706 = args27704.length;
switch (G__27706) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27704.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18741__auto___27782 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18741__auto___27782,out){
return (function (){
var f__18742__auto__ = (function (){var switch__18676__auto__ = ((function (c__18741__auto___27782,out){
return (function (state_27748){
var state_val_27749 = (state_27748[(1)]);
if((state_val_27749 === (7))){
var inst_27744 = (state_27748[(2)]);
var state_27748__$1 = state_27748;
var statearr_27750_27783 = state_27748__$1;
(statearr_27750_27783[(2)] = inst_27744);

(statearr_27750_27783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (1))){
var inst_27707 = [];
var inst_27708 = inst_27707;
var inst_27709 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_27748__$1 = (function (){var statearr_27751 = state_27748;
(statearr_27751[(7)] = inst_27708);

(statearr_27751[(8)] = inst_27709);

return statearr_27751;
})();
var statearr_27752_27784 = state_27748__$1;
(statearr_27752_27784[(2)] = null);

(statearr_27752_27784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (4))){
var inst_27712 = (state_27748[(9)]);
var inst_27712__$1 = (state_27748[(2)]);
var inst_27713 = (inst_27712__$1 == null);
var inst_27714 = cljs.core.not.call(null,inst_27713);
var state_27748__$1 = (function (){var statearr_27753 = state_27748;
(statearr_27753[(9)] = inst_27712__$1);

return statearr_27753;
})();
if(inst_27714){
var statearr_27754_27785 = state_27748__$1;
(statearr_27754_27785[(1)] = (5));

} else {
var statearr_27755_27786 = state_27748__$1;
(statearr_27755_27786[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (15))){
var inst_27738 = (state_27748[(2)]);
var state_27748__$1 = state_27748;
var statearr_27756_27787 = state_27748__$1;
(statearr_27756_27787[(2)] = inst_27738);

(statearr_27756_27787[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (13))){
var state_27748__$1 = state_27748;
var statearr_27757_27788 = state_27748__$1;
(statearr_27757_27788[(2)] = null);

(statearr_27757_27788[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (6))){
var inst_27708 = (state_27748[(7)]);
var inst_27733 = inst_27708.length;
var inst_27734 = (inst_27733 > (0));
var state_27748__$1 = state_27748;
if(cljs.core.truth_(inst_27734)){
var statearr_27758_27789 = state_27748__$1;
(statearr_27758_27789[(1)] = (12));

} else {
var statearr_27759_27790 = state_27748__$1;
(statearr_27759_27790[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (3))){
var inst_27746 = (state_27748[(2)]);
var state_27748__$1 = state_27748;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27748__$1,inst_27746);
} else {
if((state_val_27749 === (12))){
var inst_27708 = (state_27748[(7)]);
var inst_27736 = cljs.core.vec.call(null,inst_27708);
var state_27748__$1 = state_27748;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27748__$1,(15),out,inst_27736);
} else {
if((state_val_27749 === (2))){
var state_27748__$1 = state_27748;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27748__$1,(4),ch);
} else {
if((state_val_27749 === (11))){
var inst_27716 = (state_27748[(10)]);
var inst_27712 = (state_27748[(9)]);
var inst_27726 = (state_27748[(2)]);
var inst_27727 = [];
var inst_27728 = inst_27727.push(inst_27712);
var inst_27708 = inst_27727;
var inst_27709 = inst_27716;
var state_27748__$1 = (function (){var statearr_27760 = state_27748;
(statearr_27760[(7)] = inst_27708);

(statearr_27760[(11)] = inst_27726);

(statearr_27760[(12)] = inst_27728);

(statearr_27760[(8)] = inst_27709);

return statearr_27760;
})();
var statearr_27761_27791 = state_27748__$1;
(statearr_27761_27791[(2)] = null);

(statearr_27761_27791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (9))){
var inst_27708 = (state_27748[(7)]);
var inst_27724 = cljs.core.vec.call(null,inst_27708);
var state_27748__$1 = state_27748;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27748__$1,(11),out,inst_27724);
} else {
if((state_val_27749 === (5))){
var inst_27716 = (state_27748[(10)]);
var inst_27709 = (state_27748[(8)]);
var inst_27712 = (state_27748[(9)]);
var inst_27716__$1 = f.call(null,inst_27712);
var inst_27717 = cljs.core._EQ_.call(null,inst_27716__$1,inst_27709);
var inst_27718 = cljs.core.keyword_identical_QMARK_.call(null,inst_27709,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_27719 = (inst_27717) || (inst_27718);
var state_27748__$1 = (function (){var statearr_27762 = state_27748;
(statearr_27762[(10)] = inst_27716__$1);

return statearr_27762;
})();
if(cljs.core.truth_(inst_27719)){
var statearr_27763_27792 = state_27748__$1;
(statearr_27763_27792[(1)] = (8));

} else {
var statearr_27764_27793 = state_27748__$1;
(statearr_27764_27793[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (14))){
var inst_27741 = (state_27748[(2)]);
var inst_27742 = cljs.core.async.close_BANG_.call(null,out);
var state_27748__$1 = (function (){var statearr_27766 = state_27748;
(statearr_27766[(13)] = inst_27741);

return statearr_27766;
})();
var statearr_27767_27794 = state_27748__$1;
(statearr_27767_27794[(2)] = inst_27742);

(statearr_27767_27794[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (10))){
var inst_27731 = (state_27748[(2)]);
var state_27748__$1 = state_27748;
var statearr_27768_27795 = state_27748__$1;
(statearr_27768_27795[(2)] = inst_27731);

(statearr_27768_27795[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27749 === (8))){
var inst_27708 = (state_27748[(7)]);
var inst_27716 = (state_27748[(10)]);
var inst_27712 = (state_27748[(9)]);
var inst_27721 = inst_27708.push(inst_27712);
var tmp27765 = inst_27708;
var inst_27708__$1 = tmp27765;
var inst_27709 = inst_27716;
var state_27748__$1 = (function (){var statearr_27769 = state_27748;
(statearr_27769[(7)] = inst_27708__$1);

(statearr_27769[(14)] = inst_27721);

(statearr_27769[(8)] = inst_27709);

return statearr_27769;
})();
var statearr_27770_27796 = state_27748__$1;
(statearr_27770_27796[(2)] = null);

(statearr_27770_27796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18741__auto___27782,out))
;
return ((function (switch__18676__auto__,c__18741__auto___27782,out){
return (function() {
var cljs$core$async$state_machine__18677__auto__ = null;
var cljs$core$async$state_machine__18677__auto____0 = (function (){
var statearr_27774 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27774[(0)] = cljs$core$async$state_machine__18677__auto__);

(statearr_27774[(1)] = (1));

return statearr_27774;
});
var cljs$core$async$state_machine__18677__auto____1 = (function (state_27748){
while(true){
var ret_value__18678__auto__ = (function (){try{while(true){
var result__18679__auto__ = switch__18676__auto__.call(null,state_27748);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18679__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18679__auto__;
}
break;
}
}catch (e27775){if((e27775 instanceof Object)){
var ex__18680__auto__ = e27775;
var statearr_27776_27797 = state_27748;
(statearr_27776_27797[(5)] = ex__18680__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27748);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27775;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18678__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27798 = state_27748;
state_27748 = G__27798;
continue;
} else {
return ret_value__18678__auto__;
}
break;
}
});
cljs$core$async$state_machine__18677__auto__ = function(state_27748){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18677__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18677__auto____1.call(this,state_27748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18677__auto____0;
cljs$core$async$state_machine__18677__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18677__auto____1;
return cljs$core$async$state_machine__18677__auto__;
})()
;})(switch__18676__auto__,c__18741__auto___27782,out))
})();
var state__18743__auto__ = (function (){var statearr_27777 = f__18742__auto__.call(null);
(statearr_27777[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18741__auto___27782);

return statearr_27777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18743__auto__);
});})(c__18741__auto___27782,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map