// Compiled by ClojureScript 0.0-3208 {:static-fns true}
goog.provide('cljs.core');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.array');
goog.require('goog.string.StringBuffer');
cljs.core._STAR_clojurescript_version_STAR_ = "0.0-3208";
cljs.core._STAR_unchecked_if_STAR_ = false;
/**
 * Var bound to the name value of the compiler build :target option.
 * For example, if the compiler build :target is :nodejs, *target* will be bound
 * to "nodejs". *target* is a Google Closure define and can be set by compiler
 * :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = "default";
if(typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print output.
 * Whatever function *print-fn* is bound to will be passed any
 * Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = (function cljs$core$_STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 * Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 * This is to work around the implicit newlines emitted by standard JavaScript
 * console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 * non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 * Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 * be printed in a form that can be read back by the reader.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 * their type when read in later.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 * their type when read in later.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 * print nested objects. If it is bound to logical false, there is no
 * limit. Otherwise, it must be bound to an integer indicating the maximum
 * level to print. Each argument to print is at level 0; if an argument is a
 * collection, its items are at level 1; and so on. If an object is a
 * collection and is at a level greater than or equal to the value bound to
 * *print-level*, the printer prints '#' to represent it. The root binding
 * is nil indicating no limit.
 */
cljs.core._STAR_print_level_STAR_ = null;
if(typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined'){
} else {
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__5916__delegate = function (args){
return console.log.apply(console,(function (){var G__5915 = args;
return (cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(G__5915) : cljs.core.into_array.call(null,G__5915));
})());
};
var G__5916 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__5917__i = 0, G__5917__a = new Array(arguments.length -  0);
while (G__5917__i < G__5917__a.length) {G__5917__a[G__5917__i] = arguments[G__5917__i + 0]; ++G__5917__i;}
  args = new cljs.core.IndexedSeq(G__5917__a,0);
} 
return G__5916__delegate.call(this,args);};
G__5916.cljs$lang$maxFixedArity = 0;
G__5916.cljs$lang$applyTo = (function (arglist__5918){
var args = cljs.core.seq(arglist__5918);
return G__5916__delegate(args);
});
G__5916.cljs$core$IFn$_invoke$arity$variadic = G__5916__delegate;
return G__5916;
})()
;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(n){
return typeof n === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if(cljs.core.truth_(x)){
return false;
} else {
return true;
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return !((x == null));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if(!((x == null))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
var G__5920 = x;
return goog.isString(G__5920);
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[(function (){var G__5922 = x__$1;
return goog.typeOf(G__5922);
})()])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever
 * function *main-fn* is set to will be called with the command-line
 * argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__3877__auto__ = ty;
if(cljs.core.truth_(and__3877__auto__)){
return ty.cljs$lang$type;
} else {
return and__3877__auto__;
}
})())?ty.cljs$lang$ctorStr:(function (){var G__5924 = obj;
return goog.typeOf(G__5924);
})());
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__4402__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__4402__auto__)){
var s = temp__4402__auto__;
return s;
} else {
return [cljs.core.str(ty)].join('');
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((typeof Symbol !== 'undefined') && (((function (){var G__5926 = Symbol;
return goog.typeOf(G__5926);
})() === "function"))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * Construct a JavaScript array of specified size. Accepts ignored type
 * argument for compatibility with Clojure.
 */
cljs.core.make_array = (function cljs$core$make_array(){
var G__5928 = arguments.length;
switch (G__5928) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function (size){
return (new Array(size));
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function (type,size){
return (new Array(size));
});

cljs.core.make_array.cljs$lang$maxFixedArity = 2;
/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__4774__auto___5930 = len;
var i_5931 = (0);
while(true){
if((i_5931 < n__4774__auto___5930)){
(new_arr[i_5931] = (arr[i_5931]));

var G__5932 = (i_5931 + (1));
i_5931 = G__5932;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__5933 = (i + (1));
i = G__5933;
continue;
} else {
return a;
}
break;
}
});
/**
 * Returns the value at the index.
 */
cljs.core.aget = (function cljs$core$aget(){
var G__5938 = arguments.length;
switch (G__5938) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return (array[i]);
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,i,idxs){
var G__5939 = cljs.core.aget;
var G__5940 = (array[i]);
var G__5941 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__5939,G__5940,G__5941) : cljs.core.apply.call(null,G__5939,G__5940,G__5941));
});

cljs.core.aget.cljs$lang$applyTo = (function (seq5934){
var G__5935 = cljs.core.first(seq5934);
var seq5934__$1 = cljs.core.next(seq5934);
var G__5936 = cljs.core.first(seq5934__$1);
var seq5934__$2 = cljs.core.next(seq5934__$1);
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__5935,G__5936,seq5934__$2);
});

cljs.core.aget.cljs$lang$maxFixedArity = 2;
/**
 * Sets the value at the index.
 */
cljs.core.aset = (function cljs$core$aset(){
var G__5948 = arguments.length;
switch (G__5948) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4941__auto__);

}
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function (array,i,val){
return (array[i] = val);
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
var G__5949 = cljs.core.aset;
var G__5950 = (array[idx]);
var G__5951 = idx2;
var G__5952 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__5949,G__5950,G__5951,G__5952) : cljs.core.apply.call(null,G__5949,G__5950,G__5951,G__5952));
});

cljs.core.aset.cljs$lang$applyTo = (function (seq5943){
var G__5944 = cljs.core.first(seq5943);
var seq5943__$1 = cljs.core.next(seq5943);
var G__5945 = cljs.core.first(seq5943__$1);
var seq5943__$2 = cljs.core.next(seq5943__$1);
var G__5946 = cljs.core.first(seq5943__$2);
var seq5943__$3 = cljs.core.next(seq5943__$2);
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__5944,G__5945,G__5946,seq5943__$3);
});

cljs.core.aset.cljs$lang$maxFixedArity = 3;
/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 * argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(){
var G__5955 = arguments.length;
switch (G__5955) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function (aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function (type,aseq){
var G__5956 = (function (a,x){
a.push(x);

return a;
});
var G__5957 = [];
var G__5958 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__5956,G__5957,G__5958) : cljs.core.reduce.call(null,G__5956,G__5957,G__5958));
});

cljs.core.into_array.cljs$lang$maxFixedArity = 2;
/**
 * Invoke JavaScript object method via string. Needed when the
 * string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(){
var argseq__4929__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4929__auto__);
});

cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
});

cljs.core.js_invoke.cljs$lang$maxFixedArity = (2);

cljs.core.js_invoke.cljs$lang$applyTo = (function (seq5960){
var G__5961 = cljs.core.first(seq5960);
var seq5960__$1 = cljs.core.next(seq5960);
var G__5962 = cljs.core.first(seq5960__$1);
var seq5960__$2 = cljs.core.next(seq5960__$1);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__5961,G__5962,seq5960__$2);
});

/**
 * Marker protocol
 */
cljs.core.Fn = (function (){var obj5964 = {};
return obj5964;
})();


/**
 * Protocol for adding the ability to invoke an object as a function.
 * For example, a vector can also be used to look up a value:
 * ([1 2 3 4] 1) => 2
 */
cljs.core.IFn = (function (){var obj5966 = {};
return obj5966;
})();

cljs.core._invoke = (function cljs$core$_invoke(){
var G__5968 = arguments.length;
switch (G__5968) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$1;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5970 = x__4525__auto__;
return goog.typeOf(G__5970);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function (this$,a){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$2;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5972 = x__4525__auto__;
return goog.typeOf(G__5972);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function (this$,a,b){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$3;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5974 = x__4525__auto__;
return goog.typeOf(G__5974);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function (this$,a,b,c){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$4;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5976 = x__4525__auto__;
return goog.typeOf(G__5976);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function (this$,a,b,c,d){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$5;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5978 = x__4525__auto__;
return goog.typeOf(G__5978);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function (this$,a,b,c,d,e){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$6;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5980 = x__4525__auto__;
return goog.typeOf(G__5980);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function (this$,a,b,c,d,e,f){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$7;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5982 = x__4525__auto__;
return goog.typeOf(G__5982);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function (this$,a,b,c,d,e,f,g){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$8;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5984 = x__4525__auto__;
return goog.typeOf(G__5984);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function (this$,a,b,c,d,e,f,g,h){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$9;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5986 = x__4525__auto__;
return goog.typeOf(G__5986);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$10;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5988 = x__4525__auto__;
return goog.typeOf(G__5988);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$11;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5990 = x__4525__auto__;
return goog.typeOf(G__5990);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$12;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5992 = x__4525__auto__;
return goog.typeOf(G__5992);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$13;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5994 = x__4525__auto__;
return goog.typeOf(G__5994);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$14;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5996 = x__4525__auto__;
return goog.typeOf(G__5996);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$15;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__5998 = x__4525__auto__;
return goog.typeOf(G__5998);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$16;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__6000 = x__4525__auto__;
return goog.typeOf(G__6000);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$17;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__6002 = x__4525__auto__;
return goog.typeOf(G__6002);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$18;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__6004 = x__4525__auto__;
return goog.typeOf(G__6004);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$19;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__6006 = x__4525__auto__;
return goog.typeOf(G__6006);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$20;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__6008 = x__4525__auto__;
return goog.typeOf(G__6008);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$21;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__6010 = x__4525__auto__;
return goog.typeOf(G__6010);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IFn$_invoke$arity$22;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._invoke[(function (){var G__6012 = x__4525__auto__;
return goog.typeOf(G__6012);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._invoke["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
});

cljs.core._invoke.cljs$lang$maxFixedArity = 22;


/**
 * Protocol for cloning a value.
 */
cljs.core.ICloneable = (function (){var obj6015 = {};
return obj6015;
})();

/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((function (){var and__3877__auto__ = value;
if(and__3877__auto__){
return value.cljs$core$ICloneable$_clone$arity$1;
} else {
return and__3877__auto__;
}
})()){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__4525__auto__ = (((value == null))?null:value);
return (function (){var or__3889__auto__ = (cljs.core._clone[(function (){var G__6019 = x__4525__auto__;
return goog.typeOf(G__6019);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._clone["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
})().call(null,value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 */
cljs.core.ICounted = (function (){var obj6021 = {};
return obj6021;
})();

/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$ICounted$_count$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._count[(function (){var G__6025 = x__4525__auto__;
return goog.typeOf(G__6025);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._count["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for creating an empty collection.
 */
cljs.core.IEmptyableCollection = (function (){var obj6027 = {};
return obj6027;
})();

/**
 * Returns an empty collection of the same category as coll. Used
 * by cljs.core/count.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._empty[(function (){var G__6031 = x__4525__auto__;
return goog.typeOf(G__6031);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._empty["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding to a collection.
 */
cljs.core.ICollection = (function (){var obj6033 = {};
return obj6033;
})();

/**
 * Returns a new collection of coll with o added to it. The new item
 * should be added to the most efficient place, e.g.
 * (conj [1 2 3 4] 5) => [1 2 3 4 5]
 * (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$ICollection$_conj$arity$2;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._conj[(function (){var G__6037 = x__4525__auto__;
return goog.typeOf(G__6037);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._conj["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
})().call(null,coll,o);
}
});


/**
 * Protocol for collections to provide idexed-based access to their items.
 */
cljs.core.IIndexed = (function (){var obj6039 = {};
return obj6039;
})();

/**
 * Returns the value at the index n in the collection coll.
 * Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(){
var G__6041 = arguments.length;
switch (G__6041) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IIndexed$_nth$arity$2;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._nth[(function (){var G__6043 = x__4525__auto__;
return goog.typeOf(G__6043);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._nth["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n);
}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IIndexed$_nth$arity$3;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._nth[(function (){var G__6045 = x__4525__auto__;
return goog.typeOf(G__6045);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._nth["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n,not_found);
}
});

cljs.core._nth.cljs$lang$maxFixedArity = 3;


/**
 * Marker protocol indicating an array sequence.
 */
cljs.core.ASeq = (function (){var obj6048 = {};
return obj6048;
})();


/**
 * Protocol for collections to provide access to their items as sequences.
 */
cljs.core.ISeq = (function (){var obj6050 = {};
return obj6050;
})();

/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$ISeq$_first$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._first[(function (){var G__6054 = x__4525__auto__;
return goog.typeOf(G__6054);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._first["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns a new collection of coll without the first item. It should
 * always return a seq, e.g.
 * (rest []) => ()
 * (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$ISeq$_rest$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._rest[(function (){var G__6058 = x__4525__auto__;
return goog.typeOf(G__6058);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._rest["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 */
cljs.core.INext = (function (){var obj6060 = {};
return obj6060;
})();

/**
 * Returns a new collection of coll without the first item. In contrast to
 * rest, it should return nil if there are no more items, e.g.
 * (next []) => nil
 * (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$INext$_next$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._next[(function (){var G__6064 = x__4525__auto__;
return goog.typeOf(G__6064);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._next["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 */
cljs.core.ILookup = (function (){var obj6066 = {};
return obj6066;
})();

/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 * a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(){
var G__6068 = arguments.length;
switch (G__6068) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$ILookup$_lookup$arity$2;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._lookup[(function (){var G__6070 = x__4525__auto__;
return goog.typeOf(G__6070);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._lookup["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k);
}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$ILookup$_lookup$arity$3;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._lookup[(function (){var G__6072 = x__4525__auto__;
return goog.typeOf(G__6072);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._lookup["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k,not_found);
}
});

cljs.core._lookup.cljs$lang$maxFixedArity = 3;


/**
 * Protocol for adding associativity to collections.
 */
cljs.core.IAssociative = (function (){var obj6075 = {};
return obj6075;
})();

/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._contains_key_QMARK_[(function (){var G__6079 = x__4525__auto__;
return goog.typeOf(G__6079);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._contains_key_QMARK_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
})().call(null,coll,k);
}
});

/**
 * Returns a new collection of coll with a mapping from key k to
 * value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IAssociative$_assoc$arity$3;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._assoc[(function (){var G__6083 = x__4525__auto__;
return goog.typeOf(G__6083);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._assoc["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
})().call(null,coll,k,v);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 */
cljs.core.IMap = (function (){var obj6085 = {};
return obj6085;
})();

/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IMap$_dissoc$arity$2;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._dissoc[(function (){var G__6089 = x__4525__auto__;
return goog.typeOf(G__6089);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._dissoc["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
})().call(null,coll,k);
}
});


/**
 * Protocol for examining a map entry.
 */
cljs.core.IMapEntry = (function (){var obj6091 = {};
return obj6091;
})();

/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IMapEntry$_key$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._key[(function (){var G__6095 = x__4525__auto__;
return goog.typeOf(G__6095);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._key["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IMapEntry$_val$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._val[(function (){var G__6099 = x__4525__auto__;
return goog.typeOf(G__6099);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._val["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 */
cljs.core.ISet = (function (){var obj6101 = {};
return obj6101;
})();

/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$ISet$_disjoin$arity$2;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._disjoin[(function (){var G__6105 = x__4525__auto__;
return goog.typeOf(G__6105);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._disjoin["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
})().call(null,coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 * of the stack should be accessed in the most efficient way for the different
 * data structures.
 */
cljs.core.IStack = (function (){var obj6107 = {};
return obj6107;
})();

/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IStack$_peek$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._peek[(function (){var G__6111 = x__4525__auto__;
return goog.typeOf(G__6111);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._peek["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns a new stack without the item on top of the stack. Is used
 * by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IStack$_pop$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._pop[(function (){var G__6115 = x__4525__auto__;
return goog.typeOf(G__6115);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._pop["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 */
cljs.core.IVector = (function (){var obj6117 = {};
return obj6117;
})();

/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IVector$_assoc_n$arity$3;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._assoc_n[(function (){var G__6121 = x__4525__auto__;
return goog.typeOf(G__6121);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._assoc_n["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
})().call(null,coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 */
cljs.core.IDeref = (function (){var obj6123 = {};
return obj6123;
})();

/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$IDeref$_deref$arity$1;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._deref[(function (){var G__6127 = x__4525__auto__;
return goog.typeOf(G__6127);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._deref["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
})().call(null,o);
}
});


cljs.core.IDerefWithTimeout = (function (){var obj6129 = {};
return obj6129;
})();

cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._deref_with_timeout[(function (){var G__6133 = x__4525__auto__;
return goog.typeOf(G__6133);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._deref_with_timeout["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
})().call(null,o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 */
cljs.core.IMeta = (function (){var obj6135 = {};
return obj6135;
})();

/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$IMeta$_meta$arity$1;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._meta[(function (){var G__6139 = x__4525__auto__;
return goog.typeOf(G__6139);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._meta["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
})().call(null,o);
}
});


/**
 * Protocol for adding metadata to an object.
 */
cljs.core.IWithMeta = (function (){var obj6141 = {};
return obj6141;
})();

/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$IWithMeta$_with_meta$arity$2;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._with_meta[(function (){var G__6145 = x__4525__auto__;
return goog.typeOf(G__6145);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._with_meta["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
})().call(null,o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 * Called by cljs.core/reduce.
 */
cljs.core.IReduce = (function (){var obj6147 = {};
return obj6147;
})();

/**
 * f should be a function of 2 arguments. If start is not supplied,
 * returns the result of applying f to the first 2 items in coll, then
 * applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(){
var G__6149 = arguments.length;
switch (G__6149) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IReduce$_reduce$arity$2;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._reduce[(function (){var G__6151 = x__4525__auto__;
return goog.typeOf(G__6151);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._reduce["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f);
}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,start){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IReduce$_reduce$arity$3;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._reduce[(function (){var G__6153 = x__4525__auto__;
return goog.typeOf(G__6153);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._reduce["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f,start);
}
});

cljs.core._reduce.cljs$lang$maxFixedArity = 3;


/**
 * Protocol for associative types that can reduce themselves
 * via a function of key and val. Called by cljs.core/reduce-kv.
 */
cljs.core.IKVReduce = (function (){var obj6156 = {};
return obj6156;
})();

/**
 * Reduces an associative collection and returns the result. f should be
 * a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._kv_reduce[(function (){var G__6160 = x__4525__auto__;
return goog.typeOf(G__6160);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._kv_reduce["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
})().call(null,coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 */
cljs.core.IEquiv = (function (){var obj6162 = {};
return obj6162;
})();

/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$IEquiv$_equiv$arity$2;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._equiv[(function (){var G__6166 = x__4525__auto__;
return goog.typeOf(G__6166);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._equiv["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
})().call(null,o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 */
cljs.core.IHash = (function (){var obj6168 = {};
return obj6168;
})();

/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$IHash$_hash$arity$1;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._hash[(function (){var G__6172 = x__4525__auto__;
return goog.typeOf(G__6172);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._hash["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
})().call(null,o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 */
cljs.core.ISeqable = (function (){var obj6174 = {};
return obj6174;
})();

/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$ISeqable$_seq$arity$1;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._seq[(function (){var G__6178 = x__4525__auto__;
return goog.typeOf(G__6178);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._seq["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
})().call(null,o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 */
cljs.core.ISequential = (function (){var obj6180 = {};
return obj6180;
})();


/**
 * Marker interface indicating a persistent list
 */
cljs.core.IList = (function (){var obj6182 = {};
return obj6182;
})();


/**
 * Marker interface indicating a record object
 */
cljs.core.IRecord = (function (){var obj6184 = {};
return obj6184;
})();


/**
 * Protocol for reversing a seq.
 */
cljs.core.IReversible = (function (){var obj6186 = {};
return obj6186;
})();

/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IReversible$_rseq$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._rseq[(function (){var G__6190 = x__4525__auto__;
return goog.typeOf(G__6190);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._rseq["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for a collection which can represent their items
 * in a sorted manner.
 */
cljs.core.ISorted = (function (){var obj6192 = {};
return obj6192;
})();

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$ISorted$_sorted_seq$arity$2;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._sorted_seq[(function (){var G__6196 = x__4525__auto__;
return goog.typeOf(G__6196);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._sorted_seq["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
})().call(null,coll,ascending_QMARK_);
}
});

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 * If ascending is true, the result should contain all items which are > or >=
 * than k. If ascending is false, the result should contain all items which
 * are < or <= than k, e.g.
 * (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 * (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._sorted_seq_from[(function (){var G__6200 = x__4525__auto__;
return goog.typeOf(G__6200);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._sorted_seq_from["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
})().call(null,coll,k,ascending_QMARK_);
}
});

/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$ISorted$_entry_key$arity$2;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._entry_key[(function (){var G__6204 = x__4525__auto__;
return goog.typeOf(G__6204);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._entry_key["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
})().call(null,coll,entry);
}
});

/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$ISorted$_comparator$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._comparator[(function (){var G__6208 = x__4525__auto__;
return goog.typeOf(G__6208);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._comparator["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 */
cljs.core.IWriter = (function (){var obj6210 = {};
return obj6210;
})();

/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((function (){var and__3877__auto__ = writer;
if(and__3877__auto__){
return writer.cljs$core$IWriter$_write$arity$2;
} else {
return and__3877__auto__;
}
})()){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__4525__auto__ = (((writer == null))?null:writer);
return (function (){var or__3889__auto__ = (cljs.core._write[(function (){var G__6214 = x__4525__auto__;
return goog.typeOf(G__6214);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._write["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
})().call(null,writer,s);
}
});

/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((function (){var and__3877__auto__ = writer;
if(and__3877__auto__){
return writer.cljs$core$IWriter$_flush$arity$1;
} else {
return and__3877__auto__;
}
})()){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__4525__auto__ = (((writer == null))?null:writer);
return (function (){var or__3889__auto__ = (cljs.core._flush[(function (){var G__6218 = x__4525__auto__;
return goog.typeOf(G__6218);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._flush["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
})().call(null,writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 */
cljs.core.IPrintWithWriter = (function (){var obj6220 = {};
return obj6220;
})();

cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._pr_writer[(function (){var G__6224 = x__4525__auto__;
return goog.typeOf(G__6224);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._pr_writer["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
})().call(null,o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 * implemented by Delay.
 */
cljs.core.IPending = (function (){var obj6226 = {};
return obj6226;
})();

/**
 * Returns true if a value for d has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(d){
if((function (){var and__3877__auto__ = d;
if(and__3877__auto__){
return d.cljs$core$IPending$_realized_QMARK_$arity$1;
} else {
return and__3877__auto__;
}
})()){
return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
} else {
var x__4525__auto__ = (((d == null))?null:d);
return (function (){var or__3889__auto__ = (cljs.core._realized_QMARK_[(function (){var G__6230 = x__4525__auto__;
return goog.typeOf(G__6230);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._realized_QMARK_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IPending.-realized?",d);
}
}
})().call(null,d);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 */
cljs.core.IWatchable = (function (){var obj6232 = {};
return obj6232;
})();

/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IWatchable$_notify_watches$arity$3;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._notify_watches[(function (){var G__6236 = x__4525__auto__;
return goog.typeOf(G__6236);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._notify_watches["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
})().call(null,this$,oldval,newval);
}
});

/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 * and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IWatchable$_add_watch$arity$3;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._add_watch[(function (){var G__6240 = x__4525__auto__;
return goog.typeOf(G__6240);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._add_watch["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
})().call(null,this$,key,f);
}
});

/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((function (){var and__3877__auto__ = this$;
if(and__3877__auto__){
return this$.cljs$core$IWatchable$_remove_watch$arity$2;
} else {
return and__3877__auto__;
}
})()){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__4525__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3889__auto__ = (cljs.core._remove_watch[(function (){var G__6244 = x__4525__auto__;
return goog.typeOf(G__6244);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._remove_watch["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
})().call(null,this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 */
cljs.core.IEditableCollection = (function (){var obj6246 = {};
return obj6246;
})();

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._as_transient[(function (){var G__6250 = x__4525__auto__;
return goog.typeOf(G__6250);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._as_transient["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 */
cljs.core.ITransientCollection = (function (){var obj6252 = {};
return obj6252;
})();

/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((function (){var and__3877__auto__ = tcoll;
if(and__3877__auto__){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;
} else {
return and__3877__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__4525__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3889__auto__ = (cljs.core._conj_BANG_[(function (){var G__6256 = x__4525__auto__;
return goog.typeOf(G__6256);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._conj_BANG_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
})().call(null,tcoll,val);
}
});

/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((function (){var and__3877__auto__ = tcoll;
if(and__3877__auto__){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;
} else {
return and__3877__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__4525__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3889__auto__ = (cljs.core._persistent_BANG_[(function (){var G__6260 = x__4525__auto__;
return goog.typeOf(G__6260);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._persistent_BANG_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
})().call(null,tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 */
cljs.core.ITransientAssociative = (function (){var obj6262 = {};
return obj6262;
})();

/**
 * Returns a new transient collection of tcoll with a mapping from key to
 * val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((function (){var and__3877__auto__ = tcoll;
if(and__3877__auto__){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;
} else {
return and__3877__auto__;
}
})()){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__4525__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3889__auto__ = (cljs.core._assoc_BANG_[(function (){var G__6266 = x__4525__auto__;
return goog.typeOf(G__6266);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._assoc_BANG_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
})().call(null,tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 */
cljs.core.ITransientMap = (function (){var obj6268 = {};
return obj6268;
})();

/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((function (){var and__3877__auto__ = tcoll;
if(and__3877__auto__){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;
} else {
return and__3877__auto__;
}
})()){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__4525__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3889__auto__ = (cljs.core._dissoc_BANG_[(function (){var G__6272 = x__4525__auto__;
return goog.typeOf(G__6272);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._dissoc_BANG_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
})().call(null,tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 */
cljs.core.ITransientVector = (function (){var obj6274 = {};
return obj6274;
})();

/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((function (){var and__3877__auto__ = tcoll;
if(and__3877__auto__){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;
} else {
return and__3877__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__4525__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3889__auto__ = (cljs.core._assoc_n_BANG_[(function (){var G__6278 = x__4525__auto__;
return goog.typeOf(G__6278);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._assoc_n_BANG_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
})().call(null,tcoll,n,val);
}
});

/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((function (){var and__3877__auto__ = tcoll;
if(and__3877__auto__){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;
} else {
return and__3877__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__4525__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3889__auto__ = (cljs.core._pop_BANG_[(function (){var G__6282 = x__4525__auto__;
return goog.typeOf(G__6282);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._pop_BANG_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
})().call(null,tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 */
cljs.core.ITransientSet = (function (){var obj6284 = {};
return obj6284;
})();

/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((function (){var and__3877__auto__ = tcoll;
if(and__3877__auto__){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;
} else {
return and__3877__auto__;
}
})()){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__4525__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3889__auto__ = (cljs.core._disjoin_BANG_[(function (){var G__6288 = x__4525__auto__;
return goog.typeOf(G__6288);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._disjoin_BANG_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
})().call(null,tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 */
cljs.core.IComparable = (function (){var obj6290 = {};
return obj6290;
})();

/**
 * Returns a negative number, zero, or a positive number when x is logically
 * 'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((function (){var and__3877__auto__ = x;
if(and__3877__auto__){
return x.cljs$core$IComparable$_compare$arity$2;
} else {
return and__3877__auto__;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__4525__auto__ = (((x == null))?null:x);
return (function (){var or__3889__auto__ = (cljs.core._compare[(function (){var G__6294 = x__4525__auto__;
return goog.typeOf(G__6294);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._compare["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
})().call(null,x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 */
cljs.core.IChunk = (function (){var obj6296 = {};
return obj6296;
})();

/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IChunk$_drop_first$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._drop_first[(function (){var G__6300 = x__4525__auto__;
return goog.typeOf(G__6300);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._drop_first["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 */
cljs.core.IChunkedSeq = (function (){var obj6302 = {};
return obj6302;
})();

/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._chunked_first[(function (){var G__6306 = x__4525__auto__;
return goog.typeOf(G__6306);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._chunked_first["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
})().call(null,coll);
}
});

/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._chunked_rest[(function (){var G__6310 = x__4525__auto__;
return goog.typeOf(G__6310);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._chunked_rest["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 */
cljs.core.IChunkedNext = (function (){var obj6312 = {};
return obj6312;
})();

/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._chunked_next[(function (){var G__6316 = x__4525__auto__;
return goog.typeOf(G__6316);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._chunked_next["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding a name.
 */
cljs.core.INamed = (function (){var obj6318 = {};
return obj6318;
})();

/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((function (){var and__3877__auto__ = x;
if(and__3877__auto__){
return x.cljs$core$INamed$_name$arity$1;
} else {
return and__3877__auto__;
}
})()){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__4525__auto__ = (((x == null))?null:x);
return (function (){var or__3889__auto__ = (cljs.core._name[(function (){var G__6322 = x__4525__auto__;
return goog.typeOf(G__6322);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._name["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
})().call(null,x);
}
});

/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((function (){var and__3877__auto__ = x;
if(and__3877__auto__){
return x.cljs$core$INamed$_namespace$arity$1;
} else {
return and__3877__auto__;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__4525__auto__ = (((x == null))?null:x);
return (function (){var or__3889__auto__ = (cljs.core._namespace[(function (){var G__6326 = x__4525__auto__;
return goog.typeOf(G__6326);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._namespace["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
})().call(null,x);
}
});


/**
 * Marker protocol indicating an atom.
 */
cljs.core.IAtom = (function (){var obj6328 = {};
return obj6328;
})();


/**
 * Protocol for adding resetting functionality.
 */
cljs.core.IReset = (function (){var obj6330 = {};
return obj6330;
})();

/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$IReset$_reset_BANG_$arity$2;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._reset_BANG_[(function (){var G__6334 = x__4525__auto__;
return goog.typeOf(G__6334);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._reset_BANG_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
})().call(null,o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 */
cljs.core.ISwap = (function (){var obj6336 = {};
return obj6336;
})();

/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(){
var G__6338 = arguments.length;
switch (G__6338) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (o,f){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$2;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._swap_BANG_[(function (){var G__6340 = x__4525__auto__;
return goog.typeOf(G__6340);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f);
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (o,f,a){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$3;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._swap_BANG_[(function (){var G__6342 = x__4525__auto__;
return goog.typeOf(G__6342);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a);
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (o,f,a,b){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$4;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._swap_BANG_[(function (){var G__6344 = x__4525__auto__;
return goog.typeOf(G__6344);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b);
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (o,f,a,b,xs){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$5;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._swap_BANG_[(function (){var G__6346 = x__4525__auto__;
return goog.typeOf(G__6346);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b,xs);
}
});

cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;


/**
 * Protocol for adding volatile functionality.
 */
cljs.core.IVolatile = (function (){var obj6349 = {};
return obj6349;
})();

/**
 * Sets the value of volatile o to new-value without regard for the
 * current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((function (){var and__3877__auto__ = o;
if(and__3877__auto__){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2;
} else {
return and__3877__auto__;
}
})()){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__4525__auto__ = (((o == null))?null:o);
return (function (){var or__3889__auto__ = (cljs.core._vreset_BANG_[(function (){var G__6353 = x__4525__auto__;
return goog.typeOf(G__6353);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._vreset_BANG_["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
})().call(null,o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 */
cljs.core.IIterable = (function (){var obj6355 = {};
return obj6355;
})();

/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((function (){var and__3877__auto__ = coll;
if(and__3877__auto__){
return coll.cljs$core$IIterable$_iterator$arity$1;
} else {
return and__3877__auto__;
}
})()){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__4525__auto__ = (((coll == null))?null:coll);
return (function (){var or__3889__auto__ = (cljs.core._iterator[(function (){var G__6359 = x__4525__auto__;
return goog.typeOf(G__6359);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._iterator["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
})().call(null,coll);
}
});


/**
* @constructor
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/StringBufferWriter");
});

cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return [cljs.core.str(sb)].join('');
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((typeof Math.imul !== 'undefined') && (!(((function (){var G__6362 = (4294967295);
var G__6363 = (5);
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__6362,G__6363) : Math.imul.call(null,G__6362,G__6363));
})() === (0))))){
cljs.core.imul = (function cljs$core$imul(a,b){
var G__6366 = a;
var G__6367 = b;
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__6366,G__6367) : Math.imul.call(null,G__6366,G__6367));
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
var h1__$7 = (h1__$6 ^ (h1__$6 >>> (16)));
return h1__$7;
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__6368 = (i + (2));
var G__6369 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__6368;
h1 = G__6369;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = (function (){var obj6371 = {};
return obj6371;
})();
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if(!((s == null))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__6372 = (i + (1));
var G__6373 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__6372;
hash = G__6373;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
(cljs.core.string_hash_cache[k] = h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = (function (){var obj6377 = {};
return obj6377;
})();

cljs.core.string_hash_cache_count = (0);
} else {
}

var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((function (){var G__6380 = o;
if(G__6380){
var bit__4556__auto__ = (G__6380.cljs$lang$protocol_mask$partition0$ & (4194304));
if((bit__4556__auto__) || (G__6380.cljs$core$IHash$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(null);
} else {
if(typeof o === 'number'){
return ((function (){var G__6381 = o;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__6381) : Math.floor.call(null,G__6381));
})() % (2147483647));
} else {
if(o === true){
return (1);
} else {
if(o === false){
return (0);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return o.valueOf();
} else {
if((o == null)){
return (0);
} else {
return cljs.core._hash(o);

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 * c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(t,o){
return (o instanceof t);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__3877__auto__ = cljs.core.not(a.ns);
if(and__3877__auto__){
return b.ns;
} else {
return and__3877__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__6388 = a.ns;
var G__6389 = b.ns;
return goog.array.defaultCompare(G__6388,G__6389);
})();
if(((0) === nsc)){
var G__6390 = a.name;
var G__6391 = b.name;
return goog.array.defaultCompare(G__6390,G__6391);
} else {
return nsc;
}
}
} else {
var G__6392 = a.name;
var G__6393 = b.name;
return goog.array.defaultCompare(G__6392,G__6393);

}
}
}
});

/**
* @constructor
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.call = (function() {
var G__6395 = null;
var G__6395__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});
var G__6395__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
G__6395 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__6395__2.call(this,self__,coll);
case 3:
return G__6395__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__6395.cljs$core$IFn$_invoke$arity$2 = G__6395__2;
G__6395.cljs$core$IFn$_invoke$arity$3 = G__6395__3;
return G__6395;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args6394){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6394)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__4305__auto__ = self__._hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/Symbol");
});

cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

cljs.core.symbol = (function cljs$core$symbol(){
var G__6397 = arguments.length;
switch (G__6397) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var sym_str = ((!((ns == null)))?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});

cljs.core.symbol.cljs$lang$maxFixedArity = 2;

/**
* @constructor
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 163841;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$Fn$ = true;

cljs.core.Var.prototype.call = (function() {
var G__6444 = null;
var G__6444__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});
var G__6444__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});
var G__6444__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});
var G__6444__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});
var G__6444__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});
var G__6444__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});
var G__6444__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});
var G__6444__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});
var G__6444__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});
var G__6444__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});
var G__6444__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__6444__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__6444__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__6444__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__6444__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__6444__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__6444__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__6444__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__6444__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__6444__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__6444__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__6444__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6400 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__6401 = a;
var G__6402 = b;
var G__6403 = c;
var G__6404 = d;
var G__6405 = e;
var G__6406 = f;
var G__6407 = g;
var G__6408 = h;
var G__6409 = i;
var G__6410 = j;
var G__6411 = k;
var G__6412 = l;
var G__6413 = m;
var G__6414 = n;
var G__6415 = o;
var G__6416 = p;
var G__6417 = q;
var G__6418 = r;
var G__6419 = s;
var G__6420 = t;
var G__6421 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__6400,G__6401,G__6402,G__6403,G__6404,G__6405,G__6406,G__6407,G__6408,G__6409,G__6410,G__6411,G__6412,G__6413,G__6414,G__6415,G__6416,G__6417,G__6418,G__6419,G__6420,G__6421) : cljs.core.apply.call(null,G__6400,G__6401,G__6402,G__6403,G__6404,G__6405,G__6406,G__6407,G__6408,G__6409,G__6410,G__6411,G__6412,G__6413,G__6414,G__6415,G__6416,G__6417,G__6418,G__6419,G__6420,G__6421));
});
G__6444 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__6444__1.call(this,self__);
case 2:
return G__6444__2.call(this,self__,a);
case 3:
return G__6444__3.call(this,self__,a,b);
case 4:
return G__6444__4.call(this,self__,a,b,c);
case 5:
return G__6444__5.call(this,self__,a,b,c,d);
case 6:
return G__6444__6.call(this,self__,a,b,c,d,e);
case 7:
return G__6444__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__6444__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__6444__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__6444__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__6444__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__6444__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__6444__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__6444__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__6444__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__6444__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__6444__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__6444__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__6444__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__6444__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__6444__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__6444__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__6444.cljs$core$IFn$_invoke$arity$1 = G__6444__1;
G__6444.cljs$core$IFn$_invoke$arity$2 = G__6444__2;
G__6444.cljs$core$IFn$_invoke$arity$3 = G__6444__3;
G__6444.cljs$core$IFn$_invoke$arity$4 = G__6444__4;
G__6444.cljs$core$IFn$_invoke$arity$5 = G__6444__5;
G__6444.cljs$core$IFn$_invoke$arity$6 = G__6444__6;
G__6444.cljs$core$IFn$_invoke$arity$7 = G__6444__7;
G__6444.cljs$core$IFn$_invoke$arity$8 = G__6444__8;
G__6444.cljs$core$IFn$_invoke$arity$9 = G__6444__9;
G__6444.cljs$core$IFn$_invoke$arity$10 = G__6444__10;
G__6444.cljs$core$IFn$_invoke$arity$11 = G__6444__11;
G__6444.cljs$core$IFn$_invoke$arity$12 = G__6444__12;
G__6444.cljs$core$IFn$_invoke$arity$13 = G__6444__13;
G__6444.cljs$core$IFn$_invoke$arity$14 = G__6444__14;
G__6444.cljs$core$IFn$_invoke$arity$15 = G__6444__15;
G__6444.cljs$core$IFn$_invoke$arity$16 = G__6444__16;
G__6444.cljs$core$IFn$_invoke$arity$17 = G__6444__17;
G__6444.cljs$core$IFn$_invoke$arity$18 = G__6444__18;
G__6444.cljs$core$IFn$_invoke$arity$19 = G__6444__19;
G__6444.cljs$core$IFn$_invoke$arity$20 = G__6444__20;
G__6444.cljs$core$IFn$_invoke$arity$21 = G__6444__21;
G__6444.cljs$core$IFn$_invoke$arity$22 = G__6444__22;
return G__6444;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args6399){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6399)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__6422 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__6423 = a;
var G__6424 = b;
var G__6425 = c;
var G__6426 = d;
var G__6427 = e;
var G__6428 = f;
var G__6429 = g;
var G__6430 = h;
var G__6431 = i;
var G__6432 = j;
var G__6433 = k;
var G__6434 = l;
var G__6435 = m;
var G__6436 = n;
var G__6437 = o;
var G__6438 = p;
var G__6439 = q;
var G__6440 = r;
var G__6441 = s;
var G__6442 = t;
var G__6443 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__6422,G__6423,G__6424,G__6425,G__6426,G__6427,G__6428,G__6429,G__6430,G__6431,G__6432,G__6433,G__6434,G__6435,G__6436,G__6437,G__6438,G__6439,G__6440,G__6441,G__6442,G__6443) : cljs.core.apply.call(null,G__6422,G__6423,G__6424,G__6425,G__6426,G__6427,G__6428,G__6429,G__6430,G__6431,G__6432,G__6433,G__6434,G__6435,G__6436,G__6437,G__6438,G__6439,G__6440,G__6441,G__6442,G__6443));
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/Var");
});

cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
var G__6446 = x;
if(G__6446){
var bit__4563__auto__ = null;
if(cljs.core.truth_((function (){var or__3889__auto__ = bit__4563__auto__;
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return G__6446.cljs$core$IIterable$;
}
})())){
return true;
} else {
if((!G__6446.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__6446);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__6446);
}
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
var G__6448 = value;
if(G__6448){
var bit__4563__auto__ = (G__6448.cljs$lang$protocol_mask$partition1$ & (8192));
if((bit__4563__auto__) || (G__6448.cljs$core$ICloneable$)){
return true;
} else {
if((!G__6448.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__6448);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__6448);
}
});
/**
 * Returns a seq on the collection. If the collection is
 * empty, returns nil.  (seq nil) returns nil. seq also works on
 * Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__6450 = coll;
if(G__6450){
var bit__4556__auto__ = (G__6450.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4556__auto__) || (G__6450.cljs$core$ISeqable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str(coll),cljs.core.str(" is not ISeqable")].join('')));

}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 * argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__6452 = coll;
if(G__6452){
var bit__4556__auto__ = (G__6452.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4556__auto__) || (G__6452.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 * argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if(!((coll == null))){
if((function (){var G__6454 = coll;
if(G__6454){
var bit__4556__auto__ = (G__6454.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4556__auto__) || (G__6454.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return cljs.core._rest(s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 * argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__6456 = coll;
if(G__6456){
var bit__4556__auto__ = (G__6456.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4556__auto__) || (G__6456.cljs$core$INext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 * numbers and collections in a type-independent manner.  Clojure's immutable data
 * structures define -equiv (and thus =) as a value, not an identity,
 * comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(){
var G__6461 = arguments.length;
switch (G__6461) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return ((x === y)) || (cljs.core._equiv(x,y));
}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__6463 = y;
var G__6464 = cljs.core.first(more);
var G__6465 = cljs.core.next(more);
x = G__6463;
y = G__6464;
more = G__6465;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ_.cljs$lang$applyTo = (function (seq6457){
var G__6458 = cljs.core.first(seq6457);
var seq6457__$1 = cljs.core.next(seq6457);
var G__6459 = cljs.core.first(seq6457__$1);
var seq6457__$2 = cljs.core.next(seq6457__$1);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__6458,G__6459,seq6457__$2);
});

cljs.core._EQ_.cljs$lang$maxFixedArity = 2;

/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
})
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"value": x, "done": false};
} else {
return {"value": null, "done": true};
}
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/ES6Iterator");
});

cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = (function (){var G__6466 = self__.iter;
return (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__6466) : cljs.core.es6_iterator_seq.call(null,G__6466));
})();
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/ES6IteratorSeq");
});

cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__6467 = (n + (1));
var G__6468 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__6469 = cljs.core.next(coll__$1);
n = G__6467;
hash_code = G__6468;
coll__$1 = G__6469;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 * (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__6470 = (n + (1));
var G__6471 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__6472 = cljs.core.next(coll__$1);
n = G__6470;
hash_code = G__6471;
coll__$1 = G__6472;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
Date.prototype.cljs$core$IEquiv$ = true;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return ((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf()));
});

Date.prototype.cljs$core$IComparable$ = true;

Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
var G__6473 = this$__$1.valueOf();
var G__6474 = other.valueOf();
return goog.array.defaultCompare(G__6473,G__6474);
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.Fn["function"] = true);

(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
var G__6475 = o;
return goog.getUid(G__6475);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/Reduced");
});

cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
var G__6477 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__6477) : cljs.core.deref.call(null,G__6477));
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(){
var G__6479 = arguments.length;
switch (G__6479) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__6480 = val;
var G__6481 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6480,G__6481) : f.call(null,G__6480,G__6481));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6487 = nval;
var G__6488 = (n + (1));
val = G__6487;
n = G__6488;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__6482 = val__$1;
var G__6483 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6482,G__6483) : f.call(null,G__6482,G__6483));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6489 = nval;
var G__6490 = (n + (1));
val__$1 = G__6489;
n = G__6490;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__6484 = val__$1;
var G__6485 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6484,G__6485) : f.call(null,G__6484,G__6485));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6491 = nval;
var G__6492 = (n + (1));
val__$1 = G__6491;
n = G__6492;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.array_reduce = (function cljs$core$array_reduce(){
var G__6494 = arguments.length;
switch (G__6494) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__6495 = val;
var G__6496 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6495,G__6496) : f.call(null,G__6495,G__6496));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6502 = nval;
var G__6503 = (n + (1));
val = G__6502;
n = G__6503;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__6497 = val__$1;
var G__6498 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6497,G__6498) : f.call(null,G__6497,G__6498));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6504 = nval;
var G__6505 = (n + (1));
val__$1 = G__6504;
n = G__6505;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__6499 = val__$1;
var G__6500 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6499,G__6500) : f.call(null,G__6499,G__6500));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6506 = nval;
var G__6507 = (n + (1));
val__$1 = G__6506;
n = G__6507;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;



/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
var G__6509 = x;
if(G__6509){
var bit__4563__auto__ = (G__6509.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4563__auto__) || (G__6509.cljs$core$ICounted$)){
return true;
} else {
if((!G__6509.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__6509);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__6509);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
var G__6511 = x;
if(G__6511){
var bit__4563__auto__ = (G__6511.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4563__auto__) || (G__6511.cljs$core$IIndexed$)){
return true;
} else {
if((!G__6511.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__6511);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__6511);
}
});

/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/IndexedSeqIterator");
});

cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
*/
cljs.core.IndexedSeq = (function (arr,i){
this.arr = arr;
this.i = i;
this.cljs$lang$protocol_mask$partition0$ = 166199550;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr.length - self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = cljs.core._count(coll__$1);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__6512 = coll__$1;
var G__6513 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__6512,G__6513) : cljs.core.equiv_sequential.call(null,G__6512,G__6513));
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__6514 = o;
var G__6515 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__6514,G__6515) : cljs.core.cons.call(null,G__6514,G__6515));
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/IndexedSeq");
});

cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i){
return (new cljs.core.IndexedSeq(arr,i));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(){
var G__6517 = arguments.length;
switch (G__6517) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function (prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i));
} else {
return null;
}
});

cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;
/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(){
var G__6520 = arguments.length;
switch (G__6520) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});

cljs.core.array_seq.cljs$lang$maxFixedArity = 2;


/**
* @constructor
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__6522 = coll__$1;
var G__6523 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__6522,G__6523) : cljs.core.equiv_sequential.call(null,G__6522,G__6523));
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__6524 = cljs.core.List.EMPTY;
var G__6525 = self__.meta;
return (cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__6524,G__6525) : cljs.core.with_meta.call(null,G__6524,G__6525));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
var G__6526 = f;
var G__6527 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(G__6526,G__6527) : cljs.core.seq_reduce.call(null,G__6526,G__6527));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
var G__6528 = f;
var G__6529 = start;
var G__6530 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(G__6528,G__6529,G__6530) : cljs.core.seq_reduce.call(null,G__6528,G__6529,G__6530));
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__6531 = o;
var G__6532 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__6531,G__6532) : cljs.core.cons.call(null,G__6531,G__6532));
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/RSeq");
});

cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if(!((sn == null))){
var G__6533 = sn;
s = G__6533;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 * 'added'. (conj nil item) returns (item).  The 'addition' may
 * happen at different 'places' depending on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(){
var G__6538 = arguments.length;
switch (G__6538) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if(!((coll == null))){
return cljs.core._conj(coll,x);
} else {
return cljs.core._conj(cljs.core.List.EMPTY,x);
}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__6540 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__6541 = cljs.core.first(xs);
var G__6542 = cljs.core.next(xs);
coll = G__6540;
x = G__6541;
xs = G__6542;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
});

cljs.core.conj.cljs$lang$applyTo = (function (seq6534){
var G__6535 = cljs.core.first(seq6534);
var seq6534__$1 = cljs.core.next(seq6534);
var G__6536 = cljs.core.first(seq6534__$1);
var seq6534__$2 = cljs.core.next(seq6534__$1);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__6535,G__6536,seq6534__$2);
});

cljs.core.conj.cljs$lang$maxFixedArity = 2;
/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
return cljs.core._empty(coll);
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__6543 = cljs.core.next(s);
var G__6544 = (acc + (1));
s = G__6543;
acc = G__6544;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 * 0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if(!((coll == null))){
if((function (){var G__6546 = coll;
if(G__6546){
var bit__4556__auto__ = (G__6546.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4556__auto__) || (G__6546.cljs$core$ICounted$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll)){
return cljs.core._count(coll);
} else {
return cljs.core.accumulating_seq_count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(){
var G__6548 = arguments.length;
switch (G__6548) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__6550 = cljs.core.next(coll);
var G__6551 = (n - (1));
coll = G__6550;
n = G__6551;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__6552 = cljs.core.next(coll);
var G__6553 = (n - (1));
var G__6554 = not_found;
coll = G__6552;
n = G__6553;
not_found = G__6554;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;
/**
 * Returns the value at the index. get returns nil if index out of
 * bounds, nth throws an exception unless not-found is supplied.  nth
 * also works for strings, arrays, regex Matchers and Lists, and,
 * in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(){
var G__6556 = arguments.length;
switch (G__6556) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((function (){var G__6557 = coll;
if(G__6557){
var bit__4556__auto__ = (G__6557.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4556__auto__) || (G__6557.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__6558 = coll;
if(G__6558){
var bit__4563__auto__ = (G__6558.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4563__auto__) || (G__6558.cljs$core$ISeq$)){
return true;
} else {
if((!G__6558.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__6558);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__6558);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((function (){var G__6559 = coll;
if(G__6559){
var bit__4556__auto__ = (G__6559.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4556__auto__) || (G__6559.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__6560 = coll;
if(G__6560){
var bit__4563__auto__ = (G__6560.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4563__auto__) || (G__6560.cljs$core$ISeq$)){
return true;
} else {
if((!G__6560.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__6560);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__6560);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$lang$maxFixedArity = 3;
/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
if(((n__$1 > (0))) && (cljs.core.seq(xs))){
var G__6562 = (n__$1 - (1));
var G__6563 = cljs.core.rest(xs);
n__$1 = G__6562;
xs = G__6563;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present.
 */
cljs.core.get = (function cljs$core$get(){
var G__6565 = arguments.length;
switch (G__6565) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((o == null)){
return null;
} else {
if((function (){var G__6566 = o;
if(G__6566){
var bit__4556__auto__ = (G__6566.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4556__auto__) || (G__6566.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if(!((o == null))){
if((function (){var G__6567 = o;
if(G__6567){
var bit__4556__auto__ = (G__6567.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4556__auto__) || (G__6567.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});

cljs.core.get.cljs$lang$maxFixedArity = 3;
/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index.
 */
cljs.core.assoc = (function cljs$core$assoc(){
var G__6574 = arguments.length;
switch (G__6574) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4941__auto__);

}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if(!((coll == null))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentHashMap.fromArrays([k],[v]);
}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__6576 = ret;
var G__6577 = cljs.core.first(kvs);
var G__6578 = cljs.core.second(kvs);
var G__6579 = cljs.core.nnext(kvs);
coll = G__6576;
k = G__6577;
v = G__6578;
kvs = G__6579;
continue;
} else {
return ret;
}
break;
}
});

cljs.core.assoc.cljs$lang$applyTo = (function (seq6569){
var G__6570 = cljs.core.first(seq6569);
var seq6569__$1 = cljs.core.next(seq6569);
var G__6571 = cljs.core.first(seq6569__$1);
var seq6569__$2 = cljs.core.next(seq6569__$1);
var G__6572 = cljs.core.first(seq6569__$2);
var seq6569__$3 = cljs.core.next(seq6569__$2);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__6570,G__6571,G__6572,seq6569__$3);
});

cljs.core.assoc.cljs$lang$maxFixedArity = 3;
/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 * that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(){
var G__6584 = arguments.length;
switch (G__6584) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__6586 = ret;
var G__6587 = cljs.core.first(ks);
var G__6588 = cljs.core.next(ks);
coll = G__6586;
k = G__6587;
ks = G__6588;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.dissoc.cljs$lang$applyTo = (function (seq6580){
var G__6581 = cljs.core.first(seq6580);
var seq6580__$1 = cljs.core.next(seq6580);
var G__6582 = cljs.core.first(seq6580__$1);
var seq6580__$2 = cljs.core.next(seq6580__$1);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__6581,G__6582,seq6580__$2);
});

cljs.core.dissoc.cljs$lang$maxFixedArity = 2;
/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__3889__auto__ = (function (){var G__6593 = f;
return goog.isFunction(G__6593);
})();
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
var G__6594 = f;
if(G__6594){
var bit__4563__auto__ = null;
if(cljs.core.truth_((function (){var or__3889__auto____$1 = bit__4563__auto__;
if(cljs.core.truth_(or__3889__auto____$1)){
return or__3889__auto____$1;
} else {
return G__6594.cljs$core$Fn$;
}
})())){
return true;
} else {
if((!G__6594.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__6594);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__6594);
}
}
});

/**
* @constructor
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;

cljs.core.MetaFn.prototype.call = (function() {
var G__7060 = null;
var G__7060__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__7060__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6596 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__6596) : self__.afn.call(null,G__6596));
});
var G__7060__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6597 = a;
var G__6598 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__6597,G__6598) : self__.afn.call(null,G__6597,G__6598));
});
var G__7060__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6599 = a;
var G__6600 = b;
var G__6601 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__6599,G__6600,G__6601) : self__.afn.call(null,G__6599,G__6600,G__6601));
});
var G__7060__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6602 = a;
var G__6603 = b;
var G__6604 = c;
var G__6605 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__6602,G__6603,G__6604,G__6605) : self__.afn.call(null,G__6602,G__6603,G__6604,G__6605));
});
var G__7060__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6606 = a;
var G__6607 = b;
var G__6608 = c;
var G__6609 = d;
var G__6610 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__6606,G__6607,G__6608,G__6609,G__6610) : self__.afn.call(null,G__6606,G__6607,G__6608,G__6609,G__6610));
});
var G__7060__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6611 = a;
var G__6612 = b;
var G__6613 = c;
var G__6614 = d;
var G__6615 = e;
var G__6616 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__6611,G__6612,G__6613,G__6614,G__6615,G__6616) : self__.afn.call(null,G__6611,G__6612,G__6613,G__6614,G__6615,G__6616));
});
var G__7060__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6617 = a;
var G__6618 = b;
var G__6619 = c;
var G__6620 = d;
var G__6621 = e;
var G__6622 = f;
var G__6623 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__6617,G__6618,G__6619,G__6620,G__6621,G__6622,G__6623) : self__.afn.call(null,G__6617,G__6618,G__6619,G__6620,G__6621,G__6622,G__6623));
});
var G__7060__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6624 = a;
var G__6625 = b;
var G__6626 = c;
var G__6627 = d;
var G__6628 = e;
var G__6629 = f;
var G__6630 = g;
var G__6631 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__6624,G__6625,G__6626,G__6627,G__6628,G__6629,G__6630,G__6631) : self__.afn.call(null,G__6624,G__6625,G__6626,G__6627,G__6628,G__6629,G__6630,G__6631));
});
var G__7060__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6632 = a;
var G__6633 = b;
var G__6634 = c;
var G__6635 = d;
var G__6636 = e;
var G__6637 = f;
var G__6638 = g;
var G__6639 = h;
var G__6640 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__6632,G__6633,G__6634,G__6635,G__6636,G__6637,G__6638,G__6639,G__6640) : self__.afn.call(null,G__6632,G__6633,G__6634,G__6635,G__6636,G__6637,G__6638,G__6639,G__6640));
});
var G__7060__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6641 = a;
var G__6642 = b;
var G__6643 = c;
var G__6644 = d;
var G__6645 = e;
var G__6646 = f;
var G__6647 = g;
var G__6648 = h;
var G__6649 = i;
var G__6650 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__6641,G__6642,G__6643,G__6644,G__6645,G__6646,G__6647,G__6648,G__6649,G__6650) : self__.afn.call(null,G__6641,G__6642,G__6643,G__6644,G__6645,G__6646,G__6647,G__6648,G__6649,G__6650));
});
var G__7060__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6651 = a;
var G__6652 = b;
var G__6653 = c;
var G__6654 = d;
var G__6655 = e;
var G__6656 = f;
var G__6657 = g;
var G__6658 = h;
var G__6659 = i;
var G__6660 = j;
var G__6661 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__6651,G__6652,G__6653,G__6654,G__6655,G__6656,G__6657,G__6658,G__6659,G__6660,G__6661) : self__.afn.call(null,G__6651,G__6652,G__6653,G__6654,G__6655,G__6656,G__6657,G__6658,G__6659,G__6660,G__6661));
});
var G__7060__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6662 = a;
var G__6663 = b;
var G__6664 = c;
var G__6665 = d;
var G__6666 = e;
var G__6667 = f;
var G__6668 = g;
var G__6669 = h;
var G__6670 = i;
var G__6671 = j;
var G__6672 = k;
var G__6673 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__6662,G__6663,G__6664,G__6665,G__6666,G__6667,G__6668,G__6669,G__6670,G__6671,G__6672,G__6673) : self__.afn.call(null,G__6662,G__6663,G__6664,G__6665,G__6666,G__6667,G__6668,G__6669,G__6670,G__6671,G__6672,G__6673));
});
var G__7060__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6674 = a;
var G__6675 = b;
var G__6676 = c;
var G__6677 = d;
var G__6678 = e;
var G__6679 = f;
var G__6680 = g;
var G__6681 = h;
var G__6682 = i;
var G__6683 = j;
var G__6684 = k;
var G__6685 = l;
var G__6686 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__6674,G__6675,G__6676,G__6677,G__6678,G__6679,G__6680,G__6681,G__6682,G__6683,G__6684,G__6685,G__6686) : self__.afn.call(null,G__6674,G__6675,G__6676,G__6677,G__6678,G__6679,G__6680,G__6681,G__6682,G__6683,G__6684,G__6685,G__6686));
});
var G__7060__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6687 = a;
var G__6688 = b;
var G__6689 = c;
var G__6690 = d;
var G__6691 = e;
var G__6692 = f;
var G__6693 = g;
var G__6694 = h;
var G__6695 = i;
var G__6696 = j;
var G__6697 = k;
var G__6698 = l;
var G__6699 = m;
var G__6700 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__6687,G__6688,G__6689,G__6690,G__6691,G__6692,G__6693,G__6694,G__6695,G__6696,G__6697,G__6698,G__6699,G__6700) : self__.afn.call(null,G__6687,G__6688,G__6689,G__6690,G__6691,G__6692,G__6693,G__6694,G__6695,G__6696,G__6697,G__6698,G__6699,G__6700));
});
var G__7060__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6701 = a;
var G__6702 = b;
var G__6703 = c;
var G__6704 = d;
var G__6705 = e;
var G__6706 = f;
var G__6707 = g;
var G__6708 = h;
var G__6709 = i;
var G__6710 = j;
var G__6711 = k;
var G__6712 = l;
var G__6713 = m;
var G__6714 = n;
var G__6715 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__6701,G__6702,G__6703,G__6704,G__6705,G__6706,G__6707,G__6708,G__6709,G__6710,G__6711,G__6712,G__6713,G__6714,G__6715) : self__.afn.call(null,G__6701,G__6702,G__6703,G__6704,G__6705,G__6706,G__6707,G__6708,G__6709,G__6710,G__6711,G__6712,G__6713,G__6714,G__6715));
});
var G__7060__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6716 = a;
var G__6717 = b;
var G__6718 = c;
var G__6719 = d;
var G__6720 = e;
var G__6721 = f;
var G__6722 = g;
var G__6723 = h;
var G__6724 = i;
var G__6725 = j;
var G__6726 = k;
var G__6727 = l;
var G__6728 = m;
var G__6729 = n;
var G__6730 = o;
var G__6731 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__6716,G__6717,G__6718,G__6719,G__6720,G__6721,G__6722,G__6723,G__6724,G__6725,G__6726,G__6727,G__6728,G__6729,G__6730,G__6731) : self__.afn.call(null,G__6716,G__6717,G__6718,G__6719,G__6720,G__6721,G__6722,G__6723,G__6724,G__6725,G__6726,G__6727,G__6728,G__6729,G__6730,G__6731));
});
var G__7060__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6732 = a;
var G__6733 = b;
var G__6734 = c;
var G__6735 = d;
var G__6736 = e;
var G__6737 = f;
var G__6738 = g;
var G__6739 = h;
var G__6740 = i;
var G__6741 = j;
var G__6742 = k;
var G__6743 = l;
var G__6744 = m;
var G__6745 = n;
var G__6746 = o;
var G__6747 = p;
var G__6748 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__6732,G__6733,G__6734,G__6735,G__6736,G__6737,G__6738,G__6739,G__6740,G__6741,G__6742,G__6743,G__6744,G__6745,G__6746,G__6747,G__6748) : self__.afn.call(null,G__6732,G__6733,G__6734,G__6735,G__6736,G__6737,G__6738,G__6739,G__6740,G__6741,G__6742,G__6743,G__6744,G__6745,G__6746,G__6747,G__6748));
});
var G__7060__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6749 = a;
var G__6750 = b;
var G__6751 = c;
var G__6752 = d;
var G__6753 = e;
var G__6754 = f;
var G__6755 = g;
var G__6756 = h;
var G__6757 = i;
var G__6758 = j;
var G__6759 = k;
var G__6760 = l;
var G__6761 = m;
var G__6762 = n;
var G__6763 = o;
var G__6764 = p;
var G__6765 = q;
var G__6766 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__6749,G__6750,G__6751,G__6752,G__6753,G__6754,G__6755,G__6756,G__6757,G__6758,G__6759,G__6760,G__6761,G__6762,G__6763,G__6764,G__6765,G__6766) : self__.afn.call(null,G__6749,G__6750,G__6751,G__6752,G__6753,G__6754,G__6755,G__6756,G__6757,G__6758,G__6759,G__6760,G__6761,G__6762,G__6763,G__6764,G__6765,G__6766));
});
var G__7060__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6767 = a;
var G__6768 = b;
var G__6769 = c;
var G__6770 = d;
var G__6771 = e;
var G__6772 = f;
var G__6773 = g;
var G__6774 = h;
var G__6775 = i;
var G__6776 = j;
var G__6777 = k;
var G__6778 = l;
var G__6779 = m;
var G__6780 = n;
var G__6781 = o;
var G__6782 = p;
var G__6783 = q;
var G__6784 = r;
var G__6785 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__6767,G__6768,G__6769,G__6770,G__6771,G__6772,G__6773,G__6774,G__6775,G__6776,G__6777,G__6778,G__6779,G__6780,G__6781,G__6782,G__6783,G__6784,G__6785) : self__.afn.call(null,G__6767,G__6768,G__6769,G__6770,G__6771,G__6772,G__6773,G__6774,G__6775,G__6776,G__6777,G__6778,G__6779,G__6780,G__6781,G__6782,G__6783,G__6784,G__6785));
});
var G__7060__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6786 = a;
var G__6787 = b;
var G__6788 = c;
var G__6789 = d;
var G__6790 = e;
var G__6791 = f;
var G__6792 = g;
var G__6793 = h;
var G__6794 = i;
var G__6795 = j;
var G__6796 = k;
var G__6797 = l;
var G__6798 = m;
var G__6799 = n;
var G__6800 = o;
var G__6801 = p;
var G__6802 = q;
var G__6803 = r;
var G__6804 = s;
var G__6805 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__6786,G__6787,G__6788,G__6789,G__6790,G__6791,G__6792,G__6793,G__6794,G__6795,G__6796,G__6797,G__6798,G__6799,G__6800,G__6801,G__6802,G__6803,G__6804,G__6805) : self__.afn.call(null,G__6786,G__6787,G__6788,G__6789,G__6790,G__6791,G__6792,G__6793,G__6794,G__6795,G__6796,G__6797,G__6798,G__6799,G__6800,G__6801,G__6802,G__6803,G__6804,G__6805));
});
var G__7060__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6806 = self__.afn;
var G__6807 = a;
var G__6808 = b;
var G__6809 = c;
var G__6810 = d;
var G__6811 = e;
var G__6812 = f;
var G__6813 = g;
var G__6814 = h;
var G__6815 = i;
var G__6816 = j;
var G__6817 = k;
var G__6818 = l;
var G__6819 = m;
var G__6820 = n;
var G__6821 = o;
var G__6822 = p;
var G__6823 = q;
var G__6824 = r;
var G__6825 = s;
var G__6826 = t;
var G__6827 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__6806,G__6807,G__6808,G__6809,G__6810,G__6811,G__6812,G__6813,G__6814,G__6815,G__6816,G__6817,G__6818,G__6819,G__6820,G__6821,G__6822,G__6823,G__6824,G__6825,G__6826,G__6827) : cljs.core.apply.call(null,G__6806,G__6807,G__6808,G__6809,G__6810,G__6811,G__6812,G__6813,G__6814,G__6815,G__6816,G__6817,G__6818,G__6819,G__6820,G__6821,G__6822,G__6823,G__6824,G__6825,G__6826,G__6827));
});
G__7060 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__7060__1.call(this,self__);
case 2:
return G__7060__2.call(this,self__,a);
case 3:
return G__7060__3.call(this,self__,a,b);
case 4:
return G__7060__4.call(this,self__,a,b,c);
case 5:
return G__7060__5.call(this,self__,a,b,c,d);
case 6:
return G__7060__6.call(this,self__,a,b,c,d,e);
case 7:
return G__7060__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__7060__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__7060__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__7060__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__7060__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__7060__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__7060__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__7060__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__7060__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__7060__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__7060__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__7060__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__7060__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__7060__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__7060__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__7060__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7060.cljs$core$IFn$_invoke$arity$1 = G__7060__1;
G__7060.cljs$core$IFn$_invoke$arity$2 = G__7060__2;
G__7060.cljs$core$IFn$_invoke$arity$3 = G__7060__3;
G__7060.cljs$core$IFn$_invoke$arity$4 = G__7060__4;
G__7060.cljs$core$IFn$_invoke$arity$5 = G__7060__5;
G__7060.cljs$core$IFn$_invoke$arity$6 = G__7060__6;
G__7060.cljs$core$IFn$_invoke$arity$7 = G__7060__7;
G__7060.cljs$core$IFn$_invoke$arity$8 = G__7060__8;
G__7060.cljs$core$IFn$_invoke$arity$9 = G__7060__9;
G__7060.cljs$core$IFn$_invoke$arity$10 = G__7060__10;
G__7060.cljs$core$IFn$_invoke$arity$11 = G__7060__11;
G__7060.cljs$core$IFn$_invoke$arity$12 = G__7060__12;
G__7060.cljs$core$IFn$_invoke$arity$13 = G__7060__13;
G__7060.cljs$core$IFn$_invoke$arity$14 = G__7060__14;
G__7060.cljs$core$IFn$_invoke$arity$15 = G__7060__15;
G__7060.cljs$core$IFn$_invoke$arity$16 = G__7060__16;
G__7060.cljs$core$IFn$_invoke$arity$17 = G__7060__17;
G__7060.cljs$core$IFn$_invoke$arity$18 = G__7060__18;
G__7060.cljs$core$IFn$_invoke$arity$19 = G__7060__19;
G__7060.cljs$core$IFn$_invoke$arity$20 = G__7060__20;
G__7060.cljs$core$IFn$_invoke$arity$21 = G__7060__21;
G__7060.cljs$core$IFn$_invoke$arity$22 = G__7060__22;
return G__7060;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args6595){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6595)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
var G__6828 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__6828) : self__.afn.call(null,G__6828));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
var G__6829 = a;
var G__6830 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__6829,G__6830) : self__.afn.call(null,G__6829,G__6830));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
var G__6831 = a;
var G__6832 = b;
var G__6833 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__6831,G__6832,G__6833) : self__.afn.call(null,G__6831,G__6832,G__6833));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
var G__6834 = a;
var G__6835 = b;
var G__6836 = c;
var G__6837 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__6834,G__6835,G__6836,G__6837) : self__.afn.call(null,G__6834,G__6835,G__6836,G__6837));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
var G__6838 = a;
var G__6839 = b;
var G__6840 = c;
var G__6841 = d;
var G__6842 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__6838,G__6839,G__6840,G__6841,G__6842) : self__.afn.call(null,G__6838,G__6839,G__6840,G__6841,G__6842));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
var G__6843 = a;
var G__6844 = b;
var G__6845 = c;
var G__6846 = d;
var G__6847 = e;
var G__6848 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__6843,G__6844,G__6845,G__6846,G__6847,G__6848) : self__.afn.call(null,G__6843,G__6844,G__6845,G__6846,G__6847,G__6848));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var G__6849 = a;
var G__6850 = b;
var G__6851 = c;
var G__6852 = d;
var G__6853 = e;
var G__6854 = f;
var G__6855 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__6849,G__6850,G__6851,G__6852,G__6853,G__6854,G__6855) : self__.afn.call(null,G__6849,G__6850,G__6851,G__6852,G__6853,G__6854,G__6855));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var G__6856 = a;
var G__6857 = b;
var G__6858 = c;
var G__6859 = d;
var G__6860 = e;
var G__6861 = f;
var G__6862 = g;
var G__6863 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__6856,G__6857,G__6858,G__6859,G__6860,G__6861,G__6862,G__6863) : self__.afn.call(null,G__6856,G__6857,G__6858,G__6859,G__6860,G__6861,G__6862,G__6863));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var G__6864 = a;
var G__6865 = b;
var G__6866 = c;
var G__6867 = d;
var G__6868 = e;
var G__6869 = f;
var G__6870 = g;
var G__6871 = h;
var G__6872 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__6864,G__6865,G__6866,G__6867,G__6868,G__6869,G__6870,G__6871,G__6872) : self__.afn.call(null,G__6864,G__6865,G__6866,G__6867,G__6868,G__6869,G__6870,G__6871,G__6872));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var G__6873 = a;
var G__6874 = b;
var G__6875 = c;
var G__6876 = d;
var G__6877 = e;
var G__6878 = f;
var G__6879 = g;
var G__6880 = h;
var G__6881 = i;
var G__6882 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__6873,G__6874,G__6875,G__6876,G__6877,G__6878,G__6879,G__6880,G__6881,G__6882) : self__.afn.call(null,G__6873,G__6874,G__6875,G__6876,G__6877,G__6878,G__6879,G__6880,G__6881,G__6882));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var G__6883 = a;
var G__6884 = b;
var G__6885 = c;
var G__6886 = d;
var G__6887 = e;
var G__6888 = f;
var G__6889 = g;
var G__6890 = h;
var G__6891 = i;
var G__6892 = j;
var G__6893 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__6883,G__6884,G__6885,G__6886,G__6887,G__6888,G__6889,G__6890,G__6891,G__6892,G__6893) : self__.afn.call(null,G__6883,G__6884,G__6885,G__6886,G__6887,G__6888,G__6889,G__6890,G__6891,G__6892,G__6893));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var G__6894 = a;
var G__6895 = b;
var G__6896 = c;
var G__6897 = d;
var G__6898 = e;
var G__6899 = f;
var G__6900 = g;
var G__6901 = h;
var G__6902 = i;
var G__6903 = j;
var G__6904 = k;
var G__6905 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__6894,G__6895,G__6896,G__6897,G__6898,G__6899,G__6900,G__6901,G__6902,G__6903,G__6904,G__6905) : self__.afn.call(null,G__6894,G__6895,G__6896,G__6897,G__6898,G__6899,G__6900,G__6901,G__6902,G__6903,G__6904,G__6905));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var G__6906 = a;
var G__6907 = b;
var G__6908 = c;
var G__6909 = d;
var G__6910 = e;
var G__6911 = f;
var G__6912 = g;
var G__6913 = h;
var G__6914 = i;
var G__6915 = j;
var G__6916 = k;
var G__6917 = l;
var G__6918 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__6906,G__6907,G__6908,G__6909,G__6910,G__6911,G__6912,G__6913,G__6914,G__6915,G__6916,G__6917,G__6918) : self__.afn.call(null,G__6906,G__6907,G__6908,G__6909,G__6910,G__6911,G__6912,G__6913,G__6914,G__6915,G__6916,G__6917,G__6918));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var G__6919 = a;
var G__6920 = b;
var G__6921 = c;
var G__6922 = d;
var G__6923 = e;
var G__6924 = f;
var G__6925 = g;
var G__6926 = h;
var G__6927 = i;
var G__6928 = j;
var G__6929 = k;
var G__6930 = l;
var G__6931 = m;
var G__6932 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__6919,G__6920,G__6921,G__6922,G__6923,G__6924,G__6925,G__6926,G__6927,G__6928,G__6929,G__6930,G__6931,G__6932) : self__.afn.call(null,G__6919,G__6920,G__6921,G__6922,G__6923,G__6924,G__6925,G__6926,G__6927,G__6928,G__6929,G__6930,G__6931,G__6932));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var G__6933 = a;
var G__6934 = b;
var G__6935 = c;
var G__6936 = d;
var G__6937 = e;
var G__6938 = f;
var G__6939 = g;
var G__6940 = h;
var G__6941 = i;
var G__6942 = j;
var G__6943 = k;
var G__6944 = l;
var G__6945 = m;
var G__6946 = n;
var G__6947 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__6933,G__6934,G__6935,G__6936,G__6937,G__6938,G__6939,G__6940,G__6941,G__6942,G__6943,G__6944,G__6945,G__6946,G__6947) : self__.afn.call(null,G__6933,G__6934,G__6935,G__6936,G__6937,G__6938,G__6939,G__6940,G__6941,G__6942,G__6943,G__6944,G__6945,G__6946,G__6947));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var G__6948 = a;
var G__6949 = b;
var G__6950 = c;
var G__6951 = d;
var G__6952 = e;
var G__6953 = f;
var G__6954 = g;
var G__6955 = h;
var G__6956 = i;
var G__6957 = j;
var G__6958 = k;
var G__6959 = l;
var G__6960 = m;
var G__6961 = n;
var G__6962 = o;
var G__6963 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__6948,G__6949,G__6950,G__6951,G__6952,G__6953,G__6954,G__6955,G__6956,G__6957,G__6958,G__6959,G__6960,G__6961,G__6962,G__6963) : self__.afn.call(null,G__6948,G__6949,G__6950,G__6951,G__6952,G__6953,G__6954,G__6955,G__6956,G__6957,G__6958,G__6959,G__6960,G__6961,G__6962,G__6963));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var G__6964 = a;
var G__6965 = b;
var G__6966 = c;
var G__6967 = d;
var G__6968 = e;
var G__6969 = f;
var G__6970 = g;
var G__6971 = h;
var G__6972 = i;
var G__6973 = j;
var G__6974 = k;
var G__6975 = l;
var G__6976 = m;
var G__6977 = n;
var G__6978 = o;
var G__6979 = p;
var G__6980 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__6964,G__6965,G__6966,G__6967,G__6968,G__6969,G__6970,G__6971,G__6972,G__6973,G__6974,G__6975,G__6976,G__6977,G__6978,G__6979,G__6980) : self__.afn.call(null,G__6964,G__6965,G__6966,G__6967,G__6968,G__6969,G__6970,G__6971,G__6972,G__6973,G__6974,G__6975,G__6976,G__6977,G__6978,G__6979,G__6980));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var G__6981 = a;
var G__6982 = b;
var G__6983 = c;
var G__6984 = d;
var G__6985 = e;
var G__6986 = f;
var G__6987 = g;
var G__6988 = h;
var G__6989 = i;
var G__6990 = j;
var G__6991 = k;
var G__6992 = l;
var G__6993 = m;
var G__6994 = n;
var G__6995 = o;
var G__6996 = p;
var G__6997 = q;
var G__6998 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__6981,G__6982,G__6983,G__6984,G__6985,G__6986,G__6987,G__6988,G__6989,G__6990,G__6991,G__6992,G__6993,G__6994,G__6995,G__6996,G__6997,G__6998) : self__.afn.call(null,G__6981,G__6982,G__6983,G__6984,G__6985,G__6986,G__6987,G__6988,G__6989,G__6990,G__6991,G__6992,G__6993,G__6994,G__6995,G__6996,G__6997,G__6998));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var G__6999 = a;
var G__7000 = b;
var G__7001 = c;
var G__7002 = d;
var G__7003 = e;
var G__7004 = f;
var G__7005 = g;
var G__7006 = h;
var G__7007 = i;
var G__7008 = j;
var G__7009 = k;
var G__7010 = l;
var G__7011 = m;
var G__7012 = n;
var G__7013 = o;
var G__7014 = p;
var G__7015 = q;
var G__7016 = r;
var G__7017 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__6999,G__7000,G__7001,G__7002,G__7003,G__7004,G__7005,G__7006,G__7007,G__7008,G__7009,G__7010,G__7011,G__7012,G__7013,G__7014,G__7015,G__7016,G__7017) : self__.afn.call(null,G__6999,G__7000,G__7001,G__7002,G__7003,G__7004,G__7005,G__7006,G__7007,G__7008,G__7009,G__7010,G__7011,G__7012,G__7013,G__7014,G__7015,G__7016,G__7017));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var G__7018 = a;
var G__7019 = b;
var G__7020 = c;
var G__7021 = d;
var G__7022 = e;
var G__7023 = f;
var G__7024 = g;
var G__7025 = h;
var G__7026 = i;
var G__7027 = j;
var G__7028 = k;
var G__7029 = l;
var G__7030 = m;
var G__7031 = n;
var G__7032 = o;
var G__7033 = p;
var G__7034 = q;
var G__7035 = r;
var G__7036 = s;
var G__7037 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__7018,G__7019,G__7020,G__7021,G__7022,G__7023,G__7024,G__7025,G__7026,G__7027,G__7028,G__7029,G__7030,G__7031,G__7032,G__7033,G__7034,G__7035,G__7036,G__7037) : self__.afn.call(null,G__7018,G__7019,G__7020,G__7021,G__7022,G__7023,G__7024,G__7025,G__7026,G__7027,G__7028,G__7029,G__7030,G__7031,G__7032,G__7033,G__7034,G__7035,G__7036,G__7037));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__7038 = self__.afn;
var G__7039 = a;
var G__7040 = b;
var G__7041 = c;
var G__7042 = d;
var G__7043 = e;
var G__7044 = f;
var G__7045 = g;
var G__7046 = h;
var G__7047 = i;
var G__7048 = j;
var G__7049 = k;
var G__7050 = l;
var G__7051 = m;
var G__7052 = n;
var G__7053 = o;
var G__7054 = p;
var G__7055 = q;
var G__7056 = r;
var G__7057 = s;
var G__7058 = t;
var G__7059 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__7038,G__7039,G__7040,G__7041,G__7042,G__7043,G__7044,G__7045,G__7046,G__7047,G__7048,G__7049,G__7050,G__7051,G__7052,G__7053,G__7054,G__7055,G__7056,G__7057,G__7058,G__7059) : cljs.core.apply.call(null,G__7038,G__7039,G__7040,G__7041,G__7042,G__7043,G__7044,G__7045,G__7046,G__7047,G__7048,G__7049,G__7050,G__7051,G__7052,G__7053,G__7054,G__7055,G__7056,G__7057,G__7058,G__7059));
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/MetaFn");
});

cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 * map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if((cljs.core.fn_QMARK_(o)) && (!((function (){var G__7064 = o;
if(G__7064){
var bit__4563__auto__ = (G__7064.cljs$lang$protocol_mask$partition0$ & (262144));
if((bit__4563__auto__) || (G__7064.cljs$core$IWithMeta$)){
return true;
} else {
if((!G__7064.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__7064);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__7064);
}
})()))){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__3877__auto__ = !((o == null));
if(and__3877__auto__){
var G__7068 = o;
if(G__7068){
var bit__4563__auto__ = (G__7068.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4563__auto__) || (G__7068.cljs$core$IMeta$)){
return true;
} else {
if((!G__7068.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__7068);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__7068);
}
} else {
return and__3877__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 * more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 * item, for a vector, returns a new vector without the last item.
 * Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 * does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(){
var G__7073 = arguments.length;
switch (G__7073) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__7075 = ret;
var G__7076 = cljs.core.first(ks);
var G__7077 = cljs.core.next(ks);
coll = G__7075;
k = G__7076;
ks = G__7077;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.disj.cljs$lang$applyTo = (function (seq7069){
var G__7070 = cljs.core.first(seq7069);
var seq7069__$1 = cljs.core.next(seq7069);
var G__7071 = cljs.core.first(seq7069__$1);
var seq7069__$2 = cljs.core.next(seq7069__$1);
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__7070,G__7071,seq7069__$2);
});

cljs.core.disj.cljs$lang$maxFixedArity = 2;
/**
 * Returns true if coll has no items - same as (not (seq coll)).
 * Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return ((coll == null)) || (cljs.core.not(cljs.core.seq(coll)));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
var G__7079 = x;
if(G__7079){
var bit__4563__auto__ = (G__7079.cljs$lang$protocol_mask$partition0$ & (8));
if((bit__4563__auto__) || (G__7079.cljs$core$ICollection$)){
return true;
} else {
if((!G__7079.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__7079);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__7079);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
var G__7081 = x;
if(G__7081){
var bit__4563__auto__ = (G__7081.cljs$lang$protocol_mask$partition0$ & (4096));
if((bit__4563__auto__) || (G__7081.cljs$core$ISet$)){
return true;
} else {
if((!G__7081.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__7081);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__7081);
}
}
});
/**
 * Returns true if coll implements Associative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
var G__7083 = x;
if(G__7083){
var bit__4563__auto__ = (G__7083.cljs$lang$protocol_mask$partition0$ & (512));
if((bit__4563__auto__) || (G__7083.cljs$core$IAssociative$)){
return true;
} else {
if((!G__7083.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__7083);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__7083);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
var G__7085 = x;
if(G__7085){
var bit__4563__auto__ = (G__7085.cljs$lang$protocol_mask$partition0$ & (16777216));
if((bit__4563__auto__) || (G__7085.cljs$core$ISequential$)){
return true;
} else {
if((!G__7085.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__7085);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__7085);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
var G__7087 = x;
if(G__7087){
var bit__4563__auto__ = (G__7087.cljs$lang$protocol_mask$partition0$ & (268435456));
if((bit__4563__auto__) || (G__7087.cljs$core$ISorted$)){
return true;
} else {
if((!G__7087.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__7087);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__7087);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
var G__7089 = x;
if(G__7089){
var bit__4563__auto__ = (G__7089.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4563__auto__) || (G__7089.cljs$core$IReduce$)){
return true;
} else {
if((!G__7089.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__7089);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__7089);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
var G__7091 = x;
if(G__7091){
var bit__4563__auto__ = (G__7091.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4563__auto__) || (G__7091.cljs$core$IMap$)){
return true;
} else {
if((!G__7091.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__7091);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__7091);
}
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
var G__7093 = x;
if(G__7093){
var bit__4563__auto__ = (G__7093.cljs$lang$protocol_mask$partition0$ & (16384));
if((bit__4563__auto__) || (G__7093.cljs$core$IVector$)){
return true;
} else {
if((!G__7093.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__7093);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__7093);
}
});

/**
 * Return true if x is satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
var G__7095 = x;
if(G__7095){
var bit__4556__auto__ = (G__7095.cljs$lang$protocol_mask$partition1$ & (512));
if((bit__4556__auto__) || (G__7095.cljs$core$IChunkedSeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 * interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(){
var G__7098 = arguments.length;
switch (G__7098) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,0),(0)));
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__4941__auto__);

}
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
var obj7100 = {};
return obj7100;
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var G__7101 = goog.object.create;
var G__7102 = keyvals;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(G__7101,G__7102) : cljs.core.apply.call(null,G__7101,G__7102));
});

cljs.core.js_obj.cljs$lang$applyTo = (function (seq7096){
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq7096));
});

cljs.core.js_obj.cljs$lang$maxFixedArity = 0;
/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
var keys = [];
var G__7106_7108 = obj;
var G__7107_7109 = ((function (G__7106_7108,keys){
return (function (val,key,obj__$1){
return keys.push(key);
});})(G__7106_7108,keys))
;
goog.object.forEach(G__7106_7108,G__7107_7109);

return keys;
});
/**
 * Delete a property from a JavaScript object.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__7110 = (i__$1 + (1));
var G__7111 = (j__$1 + (1));
var G__7112 = (len__$1 - (1));
i__$1 = G__7110;
j__$1 = G__7111;
len__$1 = G__7112;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__7113 = (i__$1 - (1));
var G__7114 = (j__$1 - (1));
var G__7115 = (len__$1 - (1));
i__$1 = G__7113;
j__$1 = G__7114;
len__$1 = G__7115;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = (function (){var obj7117 = {};
return obj7117;
})();
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
var G__7119 = s;
if(G__7119){
var bit__4563__auto__ = (G__7119.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4563__auto__) || (G__7119.cljs$core$ISeq$)){
return true;
} else {
if((!G__7119.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__7119);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__7119);
}
}
});
/**
 * Return true if s satisfies ISeqable
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var G__7121 = s;
if(G__7121){
var bit__4563__auto__ = (G__7121.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4563__auto__) || (G__7121.cljs$core$ISeqable$)){
return true;
} else {
if((!G__7121.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__7121);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__7121);
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if(cljs.core.truth_(x)){
return true;
} else {
return false;
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__3889__auto__ = cljs.core.fn_QMARK_(f);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var G__7125 = f;
if(G__7125){
var bit__4563__auto__ = (G__7125.cljs$lang$protocol_mask$partition0$ & (1));
if((bit__4563__auto__) || (G__7125.cljs$core$IFn$)){
return true;
} else {
if((!G__7125.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__7125);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__7125);
}
}
});
/**
 * Returns true if n is an integer.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return (typeof n === 'number') && (cljs.core.not((function (){var G__7138 = n;
return isNaN(G__7138);
})())) && (!((n === Infinity))) && (((function (){var G__7139 = n;
return parseFloat(G__7139);
})() === (function (){var G__7140 = n;
var G__7141 = (10);
return parseInt(G__7140,G__7141);
})()));
});
/**
 * Returns true if key is present in the given collection, otherwise
 * returns false.  Note that for numerically indexed collections like
 * vectors and arrays, this tests if the numeric key is within the
 * range of indexes. 'contains?' operates constant or logarithmic time;
 * it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if((!((coll == null))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)], null);
} else {
return null;
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(){
var G__7146 = arguments.length;
switch (G__7146) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
if(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){
var s = cljs.core.PersistentHashSet.fromArray([x,y], true);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__7148 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__7149 = etc;
s = G__7148;
xs = G__7149;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
});

cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function (seq7142){
var G__7143 = cljs.core.first(seq7142);
var seq7142__$1 = cljs.core.next(seq7142);
var G__7144 = cljs.core.first(seq7142__$1);
var seq7142__$2 = cljs.core.next(seq7142__$1);
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__7143,G__7144,seq7142__$2);
});

cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = 2;
/**
 * Comparator. Returns a negative number, zero, or a positive number
 * when x is logically 'less than', 'equal to', or 'greater than'
 * y. Uses IComparable if available and google.array.defaultCompare for objects
 * of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if((cljs.core.type(x) === cljs.core.type(y))){
if((function (){var G__7153 = x;
if(G__7153){
var bit__4556__auto__ = (G__7153.cljs$lang$protocol_mask$partition1$ & (2048));
if((bit__4556__auto__) || (G__7153.cljs$core$IComparable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(null,y);
} else {
var G__7154 = x;
var G__7155 = y;
return goog.array.defaultCompare(G__7154,G__7155);
}
} else {
throw (new Error("compare on non-nil objects of different types"));

}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(){
var G__7157 = arguments.length;
switch (G__7157) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if(((d === (0))) && (((n + (1)) < len))){
var G__7159 = xs;
var G__7160 = ys;
var G__7161 = len;
var G__7162 = (n + (1));
xs = G__7159;
ys = G__7160;
len = G__7161;
n = G__7162;
continue;
} else {
return d;
}
break;
}
});

cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;
/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (function (){var G__7167 = x;
var G__7168 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7167,G__7168) : f.call(null,G__7167,G__7168));
})();
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((function (){var G__7169 = y;
var G__7170 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7169,G__7170) : f.call(null,G__7169,G__7170));
})())){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(){
var G__7172 = arguments.length;
switch (G__7172) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (function (){var G__7173 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__7173) : cljs.core.to_array.call(null,G__7173));
})();
var G__7174_7177 = a;
var G__7175_7178 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__7174_7177,G__7175_7178);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.sort.cljs$lang$maxFixedArity = 2;
/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison funcion, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(){
var G__7180 = arguments.length;
switch (G__7180) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
return cljs.core.fn__GT_comparator(comp).call(null,(function (){var G__7181 = x;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__7181) : keyfn.call(null,G__7181));
})(),(function (){var G__7182 = y;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__7182) : keyfn.call(null,G__7182));
})());
}),coll);
});

cljs.core.sort_by.cljs$lang$maxFixedArity = 3;
cljs.core.seq_reduce = (function cljs$core$seq_reduce(){
var G__7185 = arguments.length;
switch (G__7185) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var temp__4402__auto__ = cljs.core.seq(coll);
if(temp__4402__auto__){
var s = temp__4402__auto__;
var G__7186 = f;
var G__7187 = cljs.core.first(s);
var G__7188 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__7186,G__7187,G__7188) : cljs.core.reduce.call(null,G__7186,G__7187,G__7188));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__7189 = val__$1;
var G__7190 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7189,G__7190) : f.call(null,G__7189,G__7190));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__7192 = nval;
var G__7193 = cljs.core.next(coll__$1);
val__$1 = G__7192;
coll__$1 = G__7193;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;
/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = (function (){var G__7197 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__7197) : cljs.core.to_array.call(null,G__7197));
})();
var G__7198_7200 = a;
goog.array.shuffle(G__7198_7200);

var G__7199 = a;
return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(G__7199) : cljs.core.vec.call(null,G__7199));
});
/**
 * f should be a function of 2 arguments. If val is not supplied,
 * returns the result of applying f to the first 2 items in coll, then
 * applying f to that result and the 3rd item, etc. If coll contains no
 * items, f must accept no arguments as well, and reduce returns the
 * result of calling f with no arguments.  If coll has only 1 item, it
 * is returned and f is not called.  If val is supplied, returns the
 * result of applying f to val and the first item in coll, then
 * applying f to that result and the 2nd item, etc. If coll contains no
 * items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(){
var G__7202 = arguments.length;
switch (G__7202) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
if((function (){var G__7203 = coll;
if(G__7203){
var bit__4556__auto__ = (G__7203.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4556__auto__) || (G__7203.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
if((function (){var G__7204 = coll;
if(G__7204){
var bit__4556__auto__ = (G__7204.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4556__auto__) || (G__7204.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
});

cljs.core.reduce.cljs$lang$maxFixedArity = 3;
/**
 * Reduces an associative collection. f should be a function of 3
 * arguments. Returns the result of applying f to init, the first key
 * and the first value in coll, then applying f to that result and the
 * 2nd key and value, etc. If coll contains no entries, returns init
 * and f is not called. Note that reduce-kv is supported on vectors,
 * where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if(!((coll == null))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 * transduce by adding an arity-1 signature that calls cf (default -
 * identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(){
var G__7207 = arguments.length;
switch (G__7207) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function (f,cf){
return (function() {
var G__7212 = null;
var G__7212__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__7212__1 = (function (x){
var G__7208 = x;
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(G__7208) : cf.call(null,G__7208));
});
var G__7212__2 = (function (x,y){
var G__7209 = x;
var G__7210 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7209,G__7210) : f.call(null,G__7209,G__7210));
});
G__7212 = function(x,y){
switch(arguments.length){
case 0:
return G__7212__0.call(this);
case 1:
return G__7212__1.call(this,x);
case 2:
return G__7212__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7212.cljs$core$IFn$_invoke$arity$0 = G__7212__0;
G__7212.cljs$core$IFn$_invoke$arity$1 = G__7212__1;
G__7212.cljs$core$IFn$_invoke$arity$2 = G__7212__2;
return G__7212;
})()
});

cljs.core.completing.cljs$lang$maxFixedArity = 2;
/**
 * reduce with a transformation of f (xf). If init is not
 * supplied, (f) will be called to produce it. f should be a reducing
 * step function that accepts both 1 and 2 arguments, if it accepts
 * only 2 you can add the arity-1 with 'completing'. Returns the result
 * of applying (the transformed) xf to init and the first item in coll,
 * then applying xf to that result and the 2nd item, etc. If coll
 * contains no items, returns init and f is not called. Note that
 * certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(){
var G__7214 = arguments.length;
switch (G__7214) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function (xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),coll);
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function (xform,f,init,coll){
var f__$1 = (function (){var G__7215 = f;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__7215) : xform.call(null,G__7215));
})();
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
var G__7216 = ret;
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(G__7216) : f__$1.call(null,G__7216));
});

cljs.core.transduce.cljs$lang$maxFixedArity = 4;
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(){
var G__7222 = arguments.length;
switch (G__7222) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
});

cljs.core._PLUS_.cljs$lang$applyTo = (function (seq7218){
var G__7219 = cljs.core.first(seq7218);
var seq7218__$1 = cljs.core.next(seq7218);
var G__7220 = cljs.core.first(seq7218__$1);
var seq7218__$2 = cljs.core.next(seq7218__$1);
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__7219,G__7220,seq7218__$2);
});

cljs.core._PLUS_.cljs$lang$maxFixedArity = 2;
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(){
var G__7228 = arguments.length;
switch (G__7228) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
});

cljs.core._.cljs$lang$applyTo = (function (seq7224){
var G__7225 = cljs.core.first(seq7224);
var seq7224__$1 = cljs.core.next(seq7224);
var G__7226 = cljs.core.first(seq7224__$1);
var seq7224__$2 = cljs.core.next(seq7224__$1);
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__7225,G__7226,seq7224__$2);
});

cljs.core._.cljs$lang$maxFixedArity = 2;
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(){
var G__7234 = arguments.length;
switch (G__7234) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
});

cljs.core._STAR_.cljs$lang$applyTo = (function (seq7230){
var G__7231 = cljs.core.first(seq7230);
var seq7230__$1 = cljs.core.next(seq7230);
var G__7232 = cljs.core.first(seq7230__$1);
var seq7230__$2 = cljs.core.next(seq7230__$1);
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__7231,G__7232,seq7230__$2);
});

cljs.core._STAR_.cljs$lang$maxFixedArity = 2;
/**
 * If no denominators are supplied, returns 1/numerator,
 * else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(){
var G__7240 = arguments.length;
switch (G__7240) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
});

cljs.core._SLASH_.cljs$lang$applyTo = (function (seq7236){
var G__7237 = cljs.core.first(seq7236);
var seq7236__$1 = cljs.core.next(seq7236);
var G__7238 = cljs.core.first(seq7236__$1);
var seq7236__$2 = cljs.core.next(seq7236__$1);
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__7237,G__7238,seq7236__$2);
});

cljs.core._SLASH_.cljs$lang$maxFixedArity = 2;
/**
 * Returns non-nil if nums are in monotonically increasing order,
 * otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(){
var G__7246 = arguments.length;
switch (G__7246) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x < y);
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__7248 = y;
var G__7249 = cljs.core.first(more);
var G__7250 = cljs.core.next(more);
x = G__7248;
y = G__7249;
more = G__7250;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT_.cljs$lang$applyTo = (function (seq7242){
var G__7243 = cljs.core.first(seq7242);
var seq7242__$1 = cljs.core.next(seq7242);
var G__7244 = cljs.core.first(seq7242__$1);
var seq7242__$2 = cljs.core.next(seq7242__$1);
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__7243,G__7244,seq7242__$2);
});

cljs.core._LT_.cljs$lang$maxFixedArity = 2;
/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(){
var G__7255 = arguments.length;
switch (G__7255) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x <= y);
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__7257 = y;
var G__7258 = cljs.core.first(more);
var G__7259 = cljs.core.next(more);
x = G__7257;
y = G__7258;
more = G__7259;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT__EQ_.cljs$lang$applyTo = (function (seq7251){
var G__7252 = cljs.core.first(seq7251);
var seq7251__$1 = cljs.core.next(seq7251);
var G__7253 = cljs.core.first(seq7251__$1);
var seq7251__$2 = cljs.core.next(seq7251__$1);
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__7252,G__7253,seq7251__$2);
});

cljs.core._LT__EQ_.cljs$lang$maxFixedArity = 2;
/**
 * Returns non-nil if nums are in monotonically decreasing order,
 * otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(){
var G__7264 = arguments.length;
switch (G__7264) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x > y);
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__7266 = y;
var G__7267 = cljs.core.first(more);
var G__7268 = cljs.core.next(more);
x = G__7266;
y = G__7267;
more = G__7268;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT_.cljs$lang$applyTo = (function (seq7260){
var G__7261 = cljs.core.first(seq7260);
var seq7260__$1 = cljs.core.next(seq7260);
var G__7262 = cljs.core.first(seq7260__$1);
var seq7260__$2 = cljs.core.next(seq7260__$1);
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__7261,G__7262,seq7260__$2);
});

cljs.core._GT_.cljs$lang$maxFixedArity = 2;
/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(){
var G__7273 = arguments.length;
switch (G__7273) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x >= y);
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__7275 = y;
var G__7276 = cljs.core.first(more);
var G__7277 = cljs.core.next(more);
x = G__7275;
y = G__7276;
more = G__7277;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT__EQ_.cljs$lang$applyTo = (function (seq7269){
var G__7270 = cljs.core.first(seq7269);
var seq7269__$1 = cljs.core.next(seq7269);
var G__7271 = cljs.core.first(seq7269__$1);
var seq7269__$2 = cljs.core.next(seq7269__$1);
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__7270,G__7271,seq7269__$2);
});

cljs.core._GT__EQ_.cljs$lang$maxFixedArity = 2;
/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(){
var G__7282 = arguments.length;
switch (G__7282) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__4201__auto__ = x;
var y__4202__auto__ = y;
return ((x__4201__auto__ > y__4202__auto__) ? x__4201__auto__ : y__4202__auto__);
});

cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__4201__auto__ = x;
var y__4202__auto__ = y;
return ((x__4201__auto__ > y__4202__auto__) ? x__4201__auto__ : y__4202__auto__);
})(),more);
});

cljs.core.max.cljs$lang$applyTo = (function (seq7278){
var G__7279 = cljs.core.first(seq7278);
var seq7278__$1 = cljs.core.next(seq7278);
var G__7280 = cljs.core.first(seq7278__$1);
var seq7278__$2 = cljs.core.next(seq7278__$1);
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__7279,G__7280,seq7278__$2);
});

cljs.core.max.cljs$lang$maxFixedArity = 2;
/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(){
var G__7288 = arguments.length;
switch (G__7288) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__4208__auto__ = x;
var y__4209__auto__ = y;
return ((x__4208__auto__ < y__4209__auto__) ? x__4208__auto__ : y__4209__auto__);
});

cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__4208__auto__ = x;
var y__4209__auto__ = y;
return ((x__4208__auto__ < y__4209__auto__) ? x__4208__auto__ : y__4209__auto__);
})(),more);
});

cljs.core.min.cljs$lang$applyTo = (function (seq7284){
var G__7285 = cljs.core.first(seq7284);
var seq7284__$1 = cljs.core.next(seq7284);
var G__7286 = cljs.core.first(seq7284__$1);
var seq7284__$2 = cljs.core.next(seq7284__$1);
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__7285,G__7286,seq7284__$2);
});

cljs.core.min.cljs$lang$maxFixedArity = 2;
cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if((typeof x === 'string') && ((x.length === (1)))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(){
var G__7294 = arguments.length;
switch (G__7294) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
});

cljs.core.unchecked_add.cljs$lang$applyTo = (function (seq7290){
var G__7291 = cljs.core.first(seq7290);
var seq7290__$1 = cljs.core.next(seq7290);
var G__7292 = cljs.core.first(seq7290__$1);
var seq7290__$2 = cljs.core.next(seq7290__$1);
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__7291,G__7292,seq7290__$2);
});

cljs.core.unchecked_add.cljs$lang$maxFixedArity = 2;
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(){
var G__7300 = arguments.length;
switch (G__7300) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
});

cljs.core.unchecked_add_int.cljs$lang$applyTo = (function (seq7296){
var G__7297 = cljs.core.first(seq7296);
var seq7296__$1 = cljs.core.next(seq7296);
var G__7298 = cljs.core.first(seq7296__$1);
var seq7296__$2 = cljs.core.next(seq7296__$1);
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__7297,G__7298,seq7296__$2);
});

cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = 2;
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 * else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(){
var G__7306 = arguments.length;
switch (G__7306) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
});

cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function (seq7302){
var G__7303 = cljs.core.first(seq7302);
var seq7302__$1 = cljs.core.next(seq7302);
var G__7304 = cljs.core.first(seq7302__$1);
var seq7302__$2 = cljs.core.next(seq7302__$1);
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__7303,G__7304,seq7302__$2);
});

cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(){
var G__7312 = arguments.length;
switch (G__7312) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
});

cljs.core.unchecked_multiply.cljs$lang$applyTo = (function (seq7308){
var G__7309 = cljs.core.first(seq7308);
var seq7308__$1 = cljs.core.next(seq7308);
var G__7310 = cljs.core.first(seq7308__$1);
var seq7308__$2 = cljs.core.next(seq7308__$1);
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__7309,G__7310,seq7308__$2);
});

cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = 2;
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(){
var G__7318 = arguments.length;
switch (G__7318) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
});

cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function (seq7314){
var G__7315 = cljs.core.first(seq7314);
var seq7314__$1 = cljs.core.next(seq7314);
var G__7316 = cljs.core.first(seq7314__$1);
var seq7314__$2 = cljs.core.next(seq7314__$1);
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__7315,G__7316,seq7314__$2);
});

cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
var G__7322 = x;
var G__7323 = n;
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(G__7322,G__7323) : cljs.core.mod.call(null,G__7322,G__7323));
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(){
var G__7328 = arguments.length;
switch (G__7328) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
});

cljs.core.unchecked_subtract.cljs$lang$applyTo = (function (seq7324){
var G__7325 = cljs.core.first(seq7324);
var seq7324__$1 = cljs.core.next(seq7324);
var G__7326 = cljs.core.first(seq7324__$1);
var seq7324__$2 = cljs.core.next(seq7324__$1);
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__7325,G__7326,seq7324__$2);
});

cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = 2;
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(){
var G__7334 = arguments.length;
switch (G__7334) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
});

cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function (seq7330){
var G__7331 = cljs.core.first(seq7330);
var seq7330__$1 = cljs.core.next(seq7330);
var G__7332 = cljs.core.first(seq7330__$1);
var seq7330__$2 = cljs.core.next(seq7330__$1);
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__7331,G__7332,seq7330__$2);
});

cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
var G__7338 = q;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__7338) : Math.floor.call(null,G__7338));
} else {
var G__7339 = q;
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__7339) : Math.ceil.call(null,G__7339));
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(){
var G__7344 = arguments.length;
switch (G__7344) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x ^ y);
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
});

cljs.core.bit_xor.cljs$lang$applyTo = (function (seq7340){
var G__7341 = cljs.core.first(seq7340);
var seq7340__$1 = cljs.core.next(seq7340);
var G__7342 = cljs.core.first(seq7340__$1);
var seq7340__$2 = cljs.core.next(seq7340__$1);
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__7341,G__7342,seq7340__$2);
});

cljs.core.bit_xor.cljs$lang$maxFixedArity = 2;
/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(){
var G__7350 = arguments.length;
switch (G__7350) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & y);
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
});

cljs.core.bit_and.cljs$lang$applyTo = (function (seq7346){
var G__7347 = cljs.core.first(seq7346);
var seq7346__$1 = cljs.core.next(seq7346);
var G__7348 = cljs.core.first(seq7346__$1);
var seq7346__$2 = cljs.core.next(seq7346__$1);
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__7347,G__7348,seq7346__$2);
});

cljs.core.bit_and.cljs$lang$maxFixedArity = 2;
/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(){
var G__7356 = arguments.length;
switch (G__7356) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x | y);
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
});

cljs.core.bit_or.cljs$lang$applyTo = (function (seq7352){
var G__7353 = cljs.core.first(seq7352);
var seq7352__$1 = cljs.core.next(seq7352);
var G__7354 = cljs.core.first(seq7352__$1);
var seq7352__$2 = cljs.core.next(seq7352__$1);
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__7353,G__7354,seq7352__$2);
});

cljs.core.bit_or.cljs$lang$maxFixedArity = 2;
/**
 * Bitwise and
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(){
var G__7362 = arguments.length;
switch (G__7362) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & ~y);
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
});

cljs.core.bit_and_not.cljs$lang$applyTo = (function (seq7358){
var G__7359 = cljs.core.first(seq7358);
var seq7358__$1 = cljs.core.next(seq7358);
var G__7360 = cljs.core.first(seq7358__$1);
var seq7358__$2 = cljs.core.next(seq7358__$1);
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__7359,G__7360,seq7358__$2);
});

cljs.core.bit_and_not.cljs$lang$maxFixedArity = 2;
/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 * value, otherwise false. Behavior on non nums is
 * undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(){
var G__7368 = arguments.length;
switch (G__7368) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return cljs.core._equiv(x,y);
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__7370 = y;
var G__7371 = cljs.core.first(more);
var G__7372 = cljs.core.next(more);
x = G__7370;
y = G__7371;
more = G__7372;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ__EQ_.cljs$lang$applyTo = (function (seq7364){
var G__7365 = cljs.core.first(seq7364);
var seq7364__$1 = cljs.core.next(seq7364);
var G__7366 = cljs.core.first(seq7364__$1);
var seq7364__$2 = cljs.core.next(seq7364__$1);
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__7365,G__7366,seq7364__$2);
});

cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = 2;
/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(n){
return (n > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(n){
return (n === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if((xs) && ((n__$1 > (0)))){
var G__7373 = (n__$1 - (1));
var G__7374 = cljs.core.next(xs);
n__$1 = G__7373;
xs = G__7374;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 * x.toString().  (str nil) returns the empty string. With more than
 * one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(){
var G__7378 = arguments.length;
switch (G__7378) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,1),(0)));
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4941__auto__);

}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function (){
return "";
});

cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function (x){
if((x == null)){
return "";
} else {
var G__7379 = x;
return goog.string.buildString(G__7379);
}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function (x,ys){
var sb = (new goog.string.StringBuffer([cljs.core.str(x)].join('')));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__7381 = sb.append([cljs.core.str(cljs.core.first(more))].join(''));
var G__7382 = cljs.core.next(more);
sb = G__7381;
more = G__7382;
continue;
} else {
return sb.toString();
}
break;
}
});

cljs.core.str.cljs$lang$applyTo = (function (seq7375){
var G__7376 = cljs.core.first(seq7375);
var seq7375__$1 = cljs.core.next(seq7375);
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__7376,seq7375__$1);
});

cljs.core.str.cljs$lang$maxFixedArity = 1;
/**
 * Returns the substring of s beginning at start inclusive, and ending
 * at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(){
var G__7384 = arguments.length;
switch (G__7384) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
return s.substring(start);
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function (s,start,end){
return s.substring(start,end);
});

cljs.core.subs.cljs$lang$maxFixedArity = 3;

/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 * returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?(((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && (!((cljs.core.count(x) === cljs.core.count(y)))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__7386 = cljs.core.next(xs);
var G__7387 = cljs.core.next(ys);
xs = G__7386;
ys = G__7387;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__7388 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__7389 = cljs.core.next(s);
res = G__7388;
s = G__7389;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__7394 = ((h + (cljs.core.hash((function (){var G__7392 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__7392) : cljs.core.key.call(null,G__7392));
})()) ^ cljs.core.hash((function (){var G__7393 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__7393) : cljs.core.val.call(null,G__7393));
})()))) % (4503599627370496));
var G__7395 = cljs.core.next(s);
h = G__7394;
s = G__7395;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__7396 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__7397 = cljs.core.next(s__$1);
h = G__7396;
s__$1 = G__7397;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 * attaches said functions as methods on the object.  Any references to
 * JavaScript's implicit this (via the this-as macro) will resolve to the
 * object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__7408_7418 = cljs.core.seq(fn_map);
var chunk__7409_7419 = null;
var count__7410_7420 = (0);
var i__7411_7421 = (0);
while(true){
if((i__7411_7421 < count__7410_7420)){
var vec__7412_7422 = chunk__7409_7419.cljs$core$IIndexed$_nth$arity$2(null,i__7411_7421);
var key_name_7423 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7412_7422,(0),null);
var f_7424 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7412_7422,(1),null);
var str_name_7425 = (function (){var G__7413 = key_name_7423;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__7413) : cljs.core.name.call(null,G__7413));
})();
(obj[str_name_7425] = f_7424);

var G__7426 = seq__7408_7418;
var G__7427 = chunk__7409_7419;
var G__7428 = count__7410_7420;
var G__7429 = (i__7411_7421 + (1));
seq__7408_7418 = G__7426;
chunk__7409_7419 = G__7427;
count__7410_7420 = G__7428;
i__7411_7421 = G__7429;
continue;
} else {
var temp__4404__auto___7430 = cljs.core.seq(seq__7408_7418);
if(temp__4404__auto___7430){
var seq__7408_7431__$1 = temp__4404__auto___7430;
if(cljs.core.chunked_seq_QMARK_(seq__7408_7431__$1)){
var c__4674__auto___7432 = (function (){var G__7414 = seq__7408_7431__$1;
return (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(G__7414) : cljs.core.chunk_first.call(null,G__7414));
})();
var G__7433 = (function (){var G__7415 = seq__7408_7431__$1;
return (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(G__7415) : cljs.core.chunk_rest.call(null,G__7415));
})();
var G__7434 = c__4674__auto___7432;
var G__7435 = cljs.core.count(c__4674__auto___7432);
var G__7436 = (0);
seq__7408_7418 = G__7433;
chunk__7409_7419 = G__7434;
count__7410_7420 = G__7435;
i__7411_7421 = G__7436;
continue;
} else {
var vec__7416_7437 = cljs.core.first(seq__7408_7431__$1);
var key_name_7438 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7416_7437,(0),null);
var f_7439 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7416_7437,(1),null);
var str_name_7440 = (function (){var G__7417 = key_name_7438;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__7417) : cljs.core.name.call(null,G__7417));
})();
(obj[str_name_7440] = f_7439);

var G__7441 = cljs.core.next(seq__7408_7431__$1);
var G__7442 = null;
var G__7443 = (0);
var G__7444 = (0);
seq__7408_7418 = G__7441;
chunk__7409_7419 = G__7442;
count__7410_7420 = G__7443;
i__7411_7421 = G__7444;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest(coll__$1);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/List");
});

cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));

/**
* @constructor
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.EmptyList(meta__$1));
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/EmptyList");
});

cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
var G__7446 = coll;
if(G__7446){
var bit__4563__auto__ = (G__7446.cljs$lang$protocol_mask$partition0$ & (134217728));
if((bit__4563__auto__) || (G__7446.cljs$core$IReversible$)){
return true;
} else {
if((!G__7446.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__7446);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__7446);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 * can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(coll){
return cljs.core._rseq(coll);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
return cljs.core.rseq(coll);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var arr = ((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if(!((xs__$1 == null))){
arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));

var G__7448 = xs__$1.cljs$core$INext$_next$arity$1(null);
xs__$1 = G__7448;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__7449 = (i - (1));
var G__7450 = r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));
i = G__7449;
r = G__7450;
continue;
} else {
return r;
}
break;
}
});

cljs.core.list.cljs$lang$maxFixedArity = (0);

cljs.core.list.cljs$lang$applyTo = (function (seq7447){
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq7447));
});

/**
* @constructor
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,self__.__hash));
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/Cons");
});

cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
/**
 * Returns a new seq where x is the first element and seq is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((function (){var or__3889__auto__ = (coll == null);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var G__7454 = coll;
if(G__7454){
var bit__4556__auto__ = (G__7454.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4556__auto__) || (G__7454.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));
}
});
/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
var G__7456 = x;
if(G__7456){
var bit__4563__auto__ = (G__7456.cljs$lang$protocol_mask$partition0$ & (33554432));
if((bit__4563__auto__) || (G__7456.cljs$core$IList$)){
return true;
} else {
if((!G__7456.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__7456);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__7456);
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__3877__auto__ = cljs.core.not(a.ns);
if(and__3877__auto__){
return b.ns;
} else {
return and__3877__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__7463 = a.ns;
var G__7464 = b.ns;
return goog.array.defaultCompare(G__7463,G__7464);
})();
if(((0) === nsc)){
var G__7465 = a.name;
var G__7466 = b.name;
return goog.array.defaultCompare(G__7465,G__7466);
} else {
return nsc;
}
}
} else {
var G__7467 = a.name;
var G__7468 = b.name;
return goog.array.defaultCompare(G__7467,G__7468);

}
}
}
});

/**
* @constructor
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str(":"),cljs.core.str(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__7470 = null;
var G__7470__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__7470__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__7470 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__7470__2.call(this,self__,coll);
case 3:
return G__7470__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7470.cljs$core$IFn$_invoke$arity$2 = G__7470__2;
G__7470.cljs$core$IFn$_invoke$arity$3 = G__7470__3;
return G__7470;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args7469){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args7469)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4305__auto__ = self__._hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[cljs.core.str(":"),cljs.core.str(self__.fqn)].join(''));
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/Keyword");
});

cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((function (){var G__7472 = x;
if(G__7472){
var bit__4556__auto__ = (G__7472.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4556__auto__) || (G__7472.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error([cljs.core.str("Doesn't support namespace: "),cljs.core.str(x)].join('')));
}
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 * in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(){
var G__7474 = arguments.length;
switch (G__7474) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(function (){var G__7475 = name;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__7475) : cljs.core.name.call(null,G__7475));
})(),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
return (new cljs.core.Keyword(ns,name,[cljs.core.str((cljs.core.truth_(ns)?[cljs.core.str(ns),cljs.core.str("/")].join(''):null)),cljs.core.str(name)].join(''),null));
});

cljs.core.keyword.cljs$lang$maxFixedArity = 2;

/**
* @constructor
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (function (){return (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));
})();

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if(!((self__.s == null))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__7477 = ls.sval();
ls = G__7477;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash));
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/LazySeq");
});

cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));

/**
* @constructor
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/ChunkBuffer");
});

cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if(((i >= (0))) && ((i < (self__.end - self__.off)))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/ArrayChunk");
});

cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(){
var G__7479 = arguments.length;
switch (G__7479) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;

/**
* @constructor
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
var more__$1 = cljs.core._seq(self__.more);
if((more__$1 == null)){
return null;
} else {
return more__$1;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/ChunkedCons");
});

cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((function (){var G__7482 = s;
if(G__7482){
var bit__4556__auto__ = (G__7482.cljs$lang$protocol_mask$partition1$ & (1024));
if((bit__4556__auto__) || (G__7482.cljs$core$IChunkedNext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Naive impl of to-array as a start.
 */
cljs.core.to_array = (function cljs$core$to_array(s){
var ary = [];
var s__$1 = s;
while(true){
if(cljs.core.seq(s__$1)){
ary.push(cljs.core.first(s__$1));

var G__7483 = cljs.core.next(s__$1);
s__$1 = G__7483;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 * containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_7484 = (0);
var xs_7485 = cljs.core.seq(coll);
while(true){
if(xs_7485){
(ret[i_7484] = cljs.core.to_array(cljs.core.first(xs_7485)));

var G__7486 = (i_7484 + (1));
var G__7487 = cljs.core.next(xs_7485);
i_7484 = G__7486;
xs_7485 = G__7487;
continue;
} else {
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(){
var G__7489 = arguments.length;
switch (G__7489) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__7491 = (i + (1));
var G__7492 = cljs.core.next(s__$1);
i = G__7491;
s__$1 = G__7492;
continue;
} else {
return a;
}
break;
}
} else {
var n__4774__auto___7493 = size;
var i_7494 = (0);
while(true){
if((i_7494 < n__4774__auto___7493)){
(a[i_7494] = init_val_or_seq);

var G__7495 = (i_7494 + (1));
i_7494 = G__7495;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.int_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(){
var G__7497 = arguments.length;
switch (G__7497) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__7499 = (i + (1));
var G__7500 = cljs.core.next(s__$1);
i = G__7499;
s__$1 = G__7500;
continue;
} else {
return a;
}
break;
}
} else {
var n__4774__auto___7501 = size;
var i_7502 = (0);
while(true){
if((i_7502 < n__4774__auto___7501)){
(a[i_7502] = init_val_or_seq);

var G__7503 = (i_7502 + (1));
i_7502 = G__7503;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.long_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(){
var G__7505 = arguments.length;
switch (G__7505) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__7507 = (i + (1));
var G__7508 = cljs.core.next(s__$1);
i = G__7507;
s__$1 = G__7508;
continue;
} else {
return a;
}
break;
}
} else {
var n__4774__auto___7509 = size;
var i_7510 = (0);
while(true){
if((i_7510 < n__4774__auto___7509)){
(a[i_7510] = init_val_or_seq);

var G__7511 = (i_7510 + (1));
i_7510 = G__7511;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.double_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(){
var G__7513 = arguments.length;
switch (G__7513) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__7515 = (i + (1));
var G__7516 = cljs.core.next(s__$1);
i = G__7515;
s__$1 = G__7516;
continue;
} else {
return a;
}
break;
}
} else {
var n__4774__auto___7517 = size;
var i_7518 = (0);
while(true){
if((i_7518 < n__4774__auto___7517)){
(a[i_7518] = init_val_or_seq);

var G__7519 = (i_7518 + (1));
i_7518 = G__7519;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.object_array.cljs$lang$maxFixedArity = 2;
cljs.core.bounded_count = (function cljs$core$bounded_count(s,n){
if(cljs.core.counted_QMARK_(s)){
return cljs.core.count(s);
} else {
var s__$1 = s;
var i = n;
var sum = (0);
while(true){
if(((i > (0))) && (cljs.core.seq(s__$1))){
var G__7520 = cljs.core.next(s__$1);
var G__7521 = (i - (1));
var G__7522 = (sum + (1));
s__$1 = G__7520;
i = G__7521;
sum = G__7522;
continue;
} else {
return sum;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
if((cljs.core.next(arglist) == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),cljs$core$spread(cljs.core.next(arglist)));

}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(){
var G__7528 = arguments.length;
switch (G__7528) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,zs){
var cat = (function cljs$core$cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
});

cljs.core.concat.cljs$lang$applyTo = (function (seq7524){
var G__7525 = cljs.core.first(seq7524);
var seq7524__$1 = cljs.core.next(seq7524);
var G__7526 = cljs.core.first(seq7524__$1);
var seq7524__$2 = cljs.core.next(seq7524__$1);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__7525,G__7526,seq7524__$2);
});

cljs.core.concat.cljs$lang$maxFixedArity = 2;
/**
 * Creates a new list containing the items prepended to the rest, the
 * last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(){
var G__7542 = arguments.length;
switch (G__7542) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4941__auto__);

}
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (args){
return cljs.core.seq(args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (a,args){
return cljs.core.cons(a,args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
});

cljs.core.list_STAR_.cljs$lang$applyTo = (function (seq7536){
var G__7537 = cljs.core.first(seq7536);
var seq7536__$1 = cljs.core.next(seq7536);
var G__7538 = cljs.core.first(seq7536__$1);
var seq7536__$2 = cljs.core.next(seq7536__$1);
var G__7539 = cljs.core.first(seq7536__$2);
var seq7536__$3 = cljs.core.next(seq7536__$2);
var G__7540 = cljs.core.first(seq7536__$3);
var seq7536__$4 = cljs.core.next(seq7536__$3);
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__7537,G__7538,G__7539,G__7540,seq7536__$4);
});

cljs.core.list_STAR_.cljs$lang$maxFixedArity = 4;
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 * constant time. The transient collection cannot be used after this
 * call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds x to the transient collection, and return coll. The 'addition'
 * may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(){
var G__7548 = arguments.length;
switch (G__7548) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__7550 = ntcoll;
var G__7551 = cljs.core.first(vals);
var G__7552 = cljs.core.next(vals);
tcoll = G__7550;
val = G__7551;
vals = G__7552;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.conj_BANG_.cljs$lang$applyTo = (function (seq7544){
var G__7545 = cljs.core.first(seq7544);
var seq7544__$1 = cljs.core.next(seq7544);
var G__7546 = cljs.core.first(seq7544__$1);
var seq7544__$2 = cljs.core.next(seq7544__$1);
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__7545,G__7546,seq7544__$2);
});

cljs.core.conj_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * When applied to a transient map, adds mapping of key(s) to
 * val(s). When applied to a transient vector, sets the val at index.
 * Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(){
var G__7558 = arguments.length;
switch (G__7558) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4941__auto__);

}
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__7560 = ntcoll;
var G__7561 = cljs.core.first(kvs);
var G__7562 = cljs.core.second(kvs);
var G__7563 = cljs.core.nnext(kvs);
tcoll = G__7560;
key = G__7561;
val = G__7562;
kvs = G__7563;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.assoc_BANG_.cljs$lang$applyTo = (function (seq7553){
var G__7554 = cljs.core.first(seq7553);
var seq7553__$1 = cljs.core.next(seq7553);
var G__7555 = cljs.core.first(seq7553__$1);
var seq7553__$2 = cljs.core.next(seq7553__$1);
var G__7556 = cljs.core.first(seq7553__$2);
var seq7553__$3 = cljs.core.next(seq7553__$2);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__7554,G__7555,G__7556,seq7553__$3);
});

cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = 3;
/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(){
var G__7568 = arguments.length;
switch (G__7568) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__7570 = ntcoll;
var G__7571 = cljs.core.first(ks);
var G__7572 = cljs.core.next(ks);
tcoll = G__7570;
key = G__7571;
ks = G__7572;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function (seq7564){
var G__7565 = cljs.core.first(seq7564);
var seq7564__$1 = cljs.core.next(seq7564);
var G__7566 = cljs.core.first(seq7564__$1);
var seq7564__$2 = cljs.core.next(seq7564__$1);
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__7565,G__7566,seq7564__$2);
});

cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * Removes the last item from a transient vector. If
 * the collection is empty, throws an exception. Returns coll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 * does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(){
var G__7577 = arguments.length;
switch (G__7577) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__7579 = ntcoll;
var G__7580 = cljs.core.first(vals);
var G__7581 = cljs.core.next(vals);
tcoll = G__7579;
val = G__7580;
vals = G__7581;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.disj_BANG_.cljs$lang$applyTo = (function (seq7573){
var G__7574 = cljs.core.first(seq7573);
var seq7573__$1 = cljs.core.next(seq7573);
var G__7575 = cljs.core.first(seq7573__$1);
var seq7573__$2 = cljs.core.next(seq7573__$1);
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__7574,G__7575,seq7573__$2);
});

cljs.core.disj_BANG_.cljs$lang$maxFixedArity = 2;

cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a4818 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a4818);
} else {
var G__7792 = a4818;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7792) : f.call(null,G__7792));
}
} else {
var b4819 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a4818,b4819);
} else {
var G__7793 = a4818;
var G__7794 = b4819;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7793,G__7794) : f.call(null,G__7793,G__7794));
}
} else {
var c4820 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a4818,b4819,c4820);
} else {
var G__7795 = a4818;
var G__7796 = b4819;
var G__7797 = c4820;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7795,G__7796,G__7797) : f.call(null,G__7795,G__7796,G__7797));
}
} else {
var d4821 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a4818,b4819,c4820,d4821);
} else {
var G__7798 = a4818;
var G__7799 = b4819;
var G__7800 = c4820;
var G__7801 = d4821;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7798,G__7799,G__7800,G__7801) : f.call(null,G__7798,G__7799,G__7800,G__7801));
}
} else {
var e4822 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a4818,b4819,c4820,d4821,e4822);
} else {
var G__7802 = a4818;
var G__7803 = b4819;
var G__7804 = c4820;
var G__7805 = d4821;
var G__7806 = e4822;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__7802,G__7803,G__7804,G__7805,G__7806) : f.call(null,G__7802,G__7803,G__7804,G__7805,G__7806));
}
} else {
var f4823 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a4818,b4819,c4820,d4821,e4822,f4823);
} else {
var G__7807 = a4818;
var G__7808 = b4819;
var G__7809 = c4820;
var G__7810 = d4821;
var G__7811 = e4822;
var G__7812 = f4823;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__7807,G__7808,G__7809,G__7810,G__7811,G__7812) : f.call(null,G__7807,G__7808,G__7809,G__7810,G__7811,G__7812));
}
} else {
var g4824 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a4818,b4819,c4820,d4821,e4822,f4823,g4824);
} else {
var G__7813 = a4818;
var G__7814 = b4819;
var G__7815 = c4820;
var G__7816 = d4821;
var G__7817 = e4822;
var G__7818 = f4823;
var G__7819 = g4824;
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(G__7813,G__7814,G__7815,G__7816,G__7817,G__7818,G__7819) : f.call(null,G__7813,G__7814,G__7815,G__7816,G__7817,G__7818,G__7819));
}
} else {
var h4825 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a4818,b4819,c4820,d4821,e4822,f4823,g4824,h4825);
} else {
var G__7820 = a4818;
var G__7821 = b4819;
var G__7822 = c4820;
var G__7823 = d4821;
var G__7824 = e4822;
var G__7825 = f4823;
var G__7826 = g4824;
var G__7827 = h4825;
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(G__7820,G__7821,G__7822,G__7823,G__7824,G__7825,G__7826,G__7827) : f.call(null,G__7820,G__7821,G__7822,G__7823,G__7824,G__7825,G__7826,G__7827));
}
} else {
var i4826 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a4818,b4819,c4820,d4821,e4822,f4823,g4824,h4825,i4826);
} else {
var G__7828 = a4818;
var G__7829 = b4819;
var G__7830 = c4820;
var G__7831 = d4821;
var G__7832 = e4822;
var G__7833 = f4823;
var G__7834 = g4824;
var G__7835 = h4825;
var G__7836 = i4826;
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(G__7828,G__7829,G__7830,G__7831,G__7832,G__7833,G__7834,G__7835,G__7836) : f.call(null,G__7828,G__7829,G__7830,G__7831,G__7832,G__7833,G__7834,G__7835,G__7836));
}
} else {
var j4827 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a4818,b4819,c4820,d4821,e4822,f4823,g4824,h4825,i4826,j4827);
} else {
var G__7837 = a4818;
var G__7838 = b4819;
var G__7839 = c4820;
var G__7840 = d4821;
var G__7841 = e4822;
var G__7842 = f4823;
var G__7843 = g4824;
var G__7844 = h4825;
var G__7845 = i4826;
var G__7846 = j4827;
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(G__7837,G__7838,G__7839,G__7840,G__7841,G__7842,G__7843,G__7844,G__7845,G__7846) : f.call(null,G__7837,G__7838,G__7839,G__7840,G__7841,G__7842,G__7843,G__7844,G__7845,G__7846));
}
} else {
var k4828 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a4818,b4819,c4820,d4821,e4822,f4823,g4824,h4825,i4826,j4827,k4828);
} else {
var G__7847 = a4818;
var G__7848 = b4819;
var G__7849 = c4820;
var G__7850 = d4821;
var G__7851 = e4822;
var G__7852 = f4823;
var G__7853 = g4824;
var G__7854 = h4825;
var G__7855 = i4826;
var G__7856 = j4827;
var G__7857 = k4828;
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(G__7847,G__7848,G__7849,G__7850,G__7851,G__7852,G__7853,G__7854,G__7855,G__7856,G__7857) : f.call(null,G__7847,G__7848,G__7849,G__7850,G__7851,G__7852,G__7853,G__7854,G__7855,G__7856,G__7857));
}
} else {
var l4829 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a4818,b4819,c4820,d4821,e4822,f4823,g4824,h4825,i4826,j4827,k4828,l4829);
} else {
var G__7858 = a4818;
var G__7859 = b4819;
var G__7860 = c4820;
var G__7861 = d4821;
var G__7862 = e4822;
var G__7863 = f4823;
var G__7864 = g4824;
var G__7865 = h4825;
var G__7866 = i4826;
var G__7867 = j4827;
var G__7868 = k4828;
var G__7869 = l4829;
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(G__7858,G__7859,G__7860,G__7861,G__7862,G__7863,G__7864,G__7865,G__7866,G__7867,G__7868,G__7869) : f.call(null,G__7858,G__7859,G__7860,G__7861,G__7862,G__7863,G__7864,G__7865,G__7866,G__7867,G__7868,G__7869));
}
} else {
var m4830 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a4818,b4819,c4820,d4821,e4822,f4823,g4824,h4825,i4826,j4827,k4828,l4829,m4830);
} else {
var G__7870 = a4818;
var G__7871 = b4819;
var G__7872 = c4820;
var G__7873 = d4821;
var G__7874 = e4822;
var G__7875 = f4823;
var G__7876 = g4824;
var G__7877 = h4825;
var G__7878 = i4826;
var G__7879 = j4827;
var G__7880 = k4828;
var G__7881 = l4829;
var G__7882 = m4830;
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(G__7870,G__7871,G__7872,G__7873,G__7874,G__7875,G__7876,G__7877,G__7878,G__7879,G__7880,G__7881,G__7882) : f.call(null,G__7870,G__7871,G__7872,G__7873,G__7874,G__7875,G__7876,G__7877,G__7878,G__7879,G__7880,G__7881,G__7882));
}
} else {
var n4831 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a4818,b4819,c4820,d4821,e4822,f4823,g4824,h4825,i4826,j4827,k4828,l4829,m4830,n4831);
} else {
var G__7883 = a4818;
var G__7884 = b4819;
var G__7885 = c4820;
var G__7886 = d4821;
var G__7887 = e4822;
var G__7888 = f4823;
var G__7889 = g4824;
var G__7890 = h4825;
var G__7891 = i4826;
var G__7892 = j4827;
var G__7893 = k4828;
var G__7894 = l4829;
var G__7895 = m4830;
var G__7896 = n4831;
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(G__7883,G__7884,G__7885,G__7886,G__7887,G__7888,G__7889,G__7890,G__7891,G__7892,G__7893,G__7894,G__7895,G__7896) : f.call(null,G__7883,G__7884,G__7885,G__7886,G__7887,G__7888,G__7889,G__7890,G__7891,G__7892,G__7893,G__7894,G__7895,G__7896));
}
} else {
var o4832 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a4818,b4819,c4820,d4821,e4822,f4823,g4824,h4825,i4826,j4827,k4828,l4829,m4830,n4831,o4832);
} else {
var G__7897 = a4818;
var G__7898 = b4819;
var G__7899 = c4820;
var G__7900 = d4821;
var G__7901 = e4822;
var G__7902 = f4823;
var G__7903 = g4824;
var G__7904 = h4825;
var G__7905 = i4826;
var G__7906 = j4827;
var G__7907 = k4828;
var G__7908 = l4829;
var G__7909 = m4830;
var G__7910 = n4831;
var G__7911 = o4832;
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(G__7897,G__7898,G__7899,G__7900,G__7901,G__7902,G__7903,G__7904,G__7905,G__7906,G__7907,G__7908,G__7909,G__7910,G__7911) : f.call(null,G__7897,G__7898,G__7899,G__7900,G__7901,G__7902,G__7903,G__7904,G__7905,G__7906,G__7907,G__7908,G__7909,G__7910,G__7911));
}
} else {
var p4833 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a4818,b4819,c4820,d4821,e4822,f4823,g4824,h4825,i4826,j4827,k4828,l4829,m4830,n4831,o4832,p4833);
} else {
var G__7912 = a4818;
var G__7913 = b4819;
var G__7914 = c4820;
var G__7915 = d4821;
var G__7916 = e4822;
var G__7917 = f4823;
var G__7918 = g4824;
var G__7919 = h4825;
var G__7920 = i4826;
var G__7921 = j4827;
var G__7922 = k4828;
var G__7923 = l4829;
var G__7924 = m4830;
var G__7925 = n4831;
var G__7926 = o4832;
var G__7927 = p4833;
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(G__7912,G__7913,G__7914,G__7915,G__7916,G__7917,G__7918,G__7919,G__7920,G__7921,G__7922,G__7923,G__7924,G__7925,G__7926,G__7927) : f.call(null,G__7912,G__7913,G__7914,G__7915,G__7916,G__7917,G__7918,G__7919,G__7920,G__7921,G__7922,G__7923,G__7924,G__7925,G__7926,G__7927));
}
} else {
var q4834 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a4818,b4819,c4820,d4821,e4822,f4823,g4824,h4825,i4826,j4827,k4828,l4829,m4830,n4831,o4832,p4833,q4834);
} else {
var G__7928 = a4818;
var G__7929 = b4819;
var G__7930 = c4820;
var G__7931 = d4821;
var G__7932 = e4822;
var G__7933 = f4823;
var G__7934 = g4824;
var G__7935 = h4825;
var G__7936 = i4826;
var G__7937 = j4827;
var G__7938 = k4828;
var G__7939 = l4829;
var G__7940 = m4830;
var G__7941 = n4831;
var G__7942 = o4832;
var G__7943 = p4833;
var G__7944 = q4834;
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(G__7928,G__7929,G__7930,G__7931,G__7932,G__7933,G__7934,G__7935,G__7936,G__7937,G__7938,G__7939,G__7940,G__7941,G__7942,G__7943,G__7944) : f.call(null,G__7928,G__7929,G__7930,G__7931,G__7932,G__7933,G__7934,G__7935,G__7936,G__7937,G__7938,G__7939,G__7940,G__7941,G__7942,G__7943,G__7944));
}
} else {
var r4835 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a4818,b4819,c4820,d4821,e4822,f4823,g4824,h4825,i4826,j4827,k4828,l4829,m4830,n4831,o4832,p4833,q4834,r4835);
} else {
var G__7945 = a4818;
var G__7946 = b4819;
var G__7947 = c4820;
var G__7948 = d4821;
var G__7949 = e4822;
var G__7950 = f4823;
var G__7951 = g4824;
var G__7952 = h4825;
var G__7953 = i4826;
var G__7954 = j4827;
var G__7955 = k4828;
var G__7956 = l4829;
var G__7957 = m4830;
var G__7958 = n4831;
var G__7959 = o4832;
var G__7960 = p4833;
var G__7961 = q4834;
var G__7962 = r4835;
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(G__7945,G__7946,G__7947,G__7948,G__7949,G__7950,G__7951,G__7952,G__7953,G__7954,G__7955,G__7956,G__7957,G__7958,G__7959,G__7960,G__7961,G__7962) : f.call(null,G__7945,G__7946,G__7947,G__7948,G__7949,G__7950,G__7951,G__7952,G__7953,G__7954,G__7955,G__7956,G__7957,G__7958,G__7959,G__7960,G__7961,G__7962));
}
} else {
var s4836 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a4818,b4819,c4820,d4821,e4822,f4823,g4824,h4825,i4826,j4827,k4828,l4829,m4830,n4831,o4832,p4833,q4834,r4835,s4836);
} else {
var G__7963 = a4818;
var G__7964 = b4819;
var G__7965 = c4820;
var G__7966 = d4821;
var G__7967 = e4822;
var G__7968 = f4823;
var G__7969 = g4824;
var G__7970 = h4825;
var G__7971 = i4826;
var G__7972 = j4827;
var G__7973 = k4828;
var G__7974 = l4829;
var G__7975 = m4830;
var G__7976 = n4831;
var G__7977 = o4832;
var G__7978 = p4833;
var G__7979 = q4834;
var G__7980 = r4835;
var G__7981 = s4836;
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(G__7963,G__7964,G__7965,G__7966,G__7967,G__7968,G__7969,G__7970,G__7971,G__7972,G__7973,G__7974,G__7975,G__7976,G__7977,G__7978,G__7979,G__7980,G__7981) : f.call(null,G__7963,G__7964,G__7965,G__7966,G__7967,G__7968,G__7969,G__7970,G__7971,G__7972,G__7973,G__7974,G__7975,G__7976,G__7977,G__7978,G__7979,G__7980,G__7981));
}
} else {
var t4837 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a4818,b4819,c4820,d4821,e4822,f4823,g4824,h4825,i4826,j4827,k4828,l4829,m4830,n4831,o4832,p4833,q4834,r4835,s4836,t4837);
} else {
var G__7982 = a4818;
var G__7983 = b4819;
var G__7984 = c4820;
var G__7985 = d4821;
var G__7986 = e4822;
var G__7987 = f4823;
var G__7988 = g4824;
var G__7989 = h4825;
var G__7990 = i4826;
var G__7991 = j4827;
var G__7992 = k4828;
var G__7993 = l4829;
var G__7994 = m4830;
var G__7995 = n4831;
var G__7996 = o4832;
var G__7997 = p4833;
var G__7998 = q4834;
var G__7999 = r4835;
var G__8000 = s4836;
var G__8001 = t4837;
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(G__7982,G__7983,G__7984,G__7985,G__7986,G__7987,G__7988,G__7989,G__7990,G__7991,G__7992,G__7993,G__7994,G__7995,G__7996,G__7997,G__7998,G__7999,G__8000,G__8001) : f.call(null,G__7982,G__7983,G__7984,G__7985,G__7986,G__7987,G__7988,G__7989,G__7990,G__7991,G__7992,G__7993,G__7994,G__7995,G__7996,G__7997,G__7998,G__7999,G__8000,G__8001));
}
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(){
var G__8009 = arguments.length;
switch (G__8009) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,5),(0)));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4941__auto__);

}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(args,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return f.apply(f,cljs.core.to_array(args));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function (f,x,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function (f,x,y,z,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function (f,a,b,c,d,args){
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(args)))));
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$lang$applyTo = (function (seq8002){
var G__8003 = cljs.core.first(seq8002);
var seq8002__$1 = cljs.core.next(seq8002);
var G__8004 = cljs.core.first(seq8002__$1);
var seq8002__$2 = cljs.core.next(seq8002__$1);
var G__8005 = cljs.core.first(seq8002__$2);
var seq8002__$3 = cljs.core.next(seq8002__$2);
var G__8006 = cljs.core.first(seq8002__$3);
var seq8002__$4 = cljs.core.next(seq8002__$3);
var G__8007 = cljs.core.first(seq8002__$4);
var seq8002__$5 = cljs.core.next(seq8002__$4);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__8003,G__8004,G__8005,G__8006,G__8007,seq8002__$5);
});

cljs.core.apply.cljs$lang$maxFixedArity = 5;
/**
 * Returns an object of the same type and value as obj, with
 * (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(){
var G__8019 = arguments.length;
switch (G__8019) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,6),(0)));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4941__auto__);

}
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__8020 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8020) : f.call(null,G__8020));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__8021 = cljs.core.meta(obj);
var G__8022 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8021,G__8022) : f.call(null,G__8021,G__8022));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__8023 = cljs.core.meta(obj);
var G__8024 = a;
var G__8025 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8023,G__8024,G__8025) : f.call(null,G__8023,G__8024,G__8025));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__8026 = cljs.core.meta(obj);
var G__8027 = a;
var G__8028 = b;
var G__8029 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8026,G__8027,G__8028,G__8029) : f.call(null,G__8026,G__8027,G__8028,G__8029));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__8030 = cljs.core.meta(obj);
var G__8031 = a;
var G__8032 = b;
var G__8033 = c;
var G__8034 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__8030,G__8031,G__8032,G__8033,G__8034) : f.call(null,G__8030,G__8031,G__8032,G__8033,G__8034));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.array_seq([d,args], 0)));
});

cljs.core.vary_meta.cljs$lang$applyTo = (function (seq8011){
var G__8012 = cljs.core.first(seq8011);
var seq8011__$1 = cljs.core.next(seq8011);
var G__8013 = cljs.core.first(seq8011__$1);
var seq8011__$2 = cljs.core.next(seq8011__$1);
var G__8014 = cljs.core.first(seq8011__$2);
var seq8011__$3 = cljs.core.next(seq8011__$2);
var G__8015 = cljs.core.first(seq8011__$3);
var seq8011__$4 = cljs.core.next(seq8011__$3);
var G__8016 = cljs.core.first(seq8011__$4);
var seq8011__$5 = cljs.core.next(seq8011__$4);
var G__8017 = cljs.core.first(seq8011__$5);
var seq8011__$6 = cljs.core.next(seq8011__$5);
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__8012,G__8013,G__8014,G__8015,G__8016,G__8017,seq8011__$6);
});

cljs.core.vary_meta.cljs$lang$maxFixedArity = 6;
/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(){
var G__8040 = arguments.length;
switch (G__8040) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return false;
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
});

cljs.core.not_EQ_.cljs$lang$applyTo = (function (seq8036){
var G__8037 = cljs.core.first(seq8036);
var seq8036__$1 = cljs.core.next(seq8036);
var G__8038 = cljs.core.first(seq8036__$1);
var seq8036__$2 = cljs.core.next(seq8036__$1);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__8037,G__8038,seq8036__$2);
});

cljs.core.not_EQ_.cljs$lang$maxFixedArity = 2;
/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if(typeof cljs.core.t8045 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.t8045 = (function (nil_iter,meta8046){
this.nil_iter = nil_iter;
this.meta8046 = meta8046;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.t8045.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8047,meta8046__$1){
var self__ = this;
var _8047__$1 = this;
return (new cljs.core.t8045(self__.nil_iter,meta8046__$1));
});

cljs.core.t8045.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8047){
var self__ = this;
var _8047__$1 = this;
return self__.meta8046;
});

cljs.core.t8045.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t8045.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t8045.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t8045.cljs$lang$type = true;

cljs.core.t8045.cljs$lang$ctorStr = "cljs.core/t8045";

cljs.core.t8045.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/t8045");
});

cljs.core.__GT_t8045 = (function cljs$core$nil_iter_$___GT_t8045(nil_iter__$1,meta8046){
return (new cljs.core.t8045(nil_iter__$1,meta8046));
});

}

return (new cljs.core.t8045(cljs$core$nil_iter,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
})
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/StringIter");
});

cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/ArrayIter");
});

cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = {};
cljs.core.START = {};

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
})
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return !((self__._next == null));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.not(this$.hasNext())){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/SeqIter");
});

cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.truth_(cljs.core.iterable_QMARK_(coll))){
return cljs.core._iterator(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error([cljs.core.str("Cannot create iterator from "),cljs.core.str(coll)].join('')));

}
}
}
}
}
});
cljs.core.lazy_transformer = (function cljs$core$lazy_transformer(stepper){
return (new cljs.core.LazyTransformer(stepper,null,null,null));
});

/**
* @constructor
*/
cljs.core.Stepper = (function (xform,iter){
this.xform = xform;
this.iter = iter;
})
cljs.core.Stepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__3877__auto__ = !((lt.stepper == null));
if(and__3877__auto__){
return self__.iter.hasNext();
} else {
return and__3877__auto__;
}
})())){
if(cljs.core.reduced_QMARK_((function (){var G__8048 = lt;
var G__8049 = self__.iter.next();
return (self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__8048,G__8049) : self__.xform.call(null,G__8048,G__8049));
})())){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__8050 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__8050) : self__.xform.call(null,G__8050));
}
});

cljs.core.Stepper.cljs$lang$type = true;

cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";

cljs.core.Stepper.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/Stepper");
});

cljs.core.__GT_Stepper = (function cljs$core$__GT_Stepper(xform,iter){
return (new cljs.core.Stepper(xform,iter));
});

cljs.core.stepper = (function cljs$core$stepper(xform,iter){
var stepfn = (function() {
var cljs$core$stepper_$_stepfn = null;
var cljs$core$stepper_$_stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return result;
});
var cljs$core$stepper_$_stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepper_$_stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepper_$_stepfn__1.call(this,result);
case 2:
return cljs$core$stepper_$_stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
return cljs$core$stepper_$_stepfn;
})()
;
return (new cljs.core.Stepper((function (){var G__8052 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__8052) : xform.call(null,G__8052));
})(),iter));
});

/**
* @constructor
*/
cljs.core.MultiStepper = (function (xform,iters,nexts){
this.xform = xform;
this.iters = iters;
this.nexts = nexts;
})
cljs.core.MultiStepper.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if(!((iters__$1 == null))){
var iter = cljs.core.first(iters__$1);
if(cljs.core.not(iter.hasNext())){
return false;
} else {
var G__8054 = cljs.core.next(iters__$1);
iters__$1 = G__8054;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiStepper.prototype.next = (function (){
var self__ = this;
var _ = this;
var n__4774__auto___8055 = self__.iters.length;
var i_8056 = (0);
while(true){
if((i_8056 < n__4774__auto___8055)){
(self__.nexts[i_8056] = (self__.iters[i_8056]).next());

var G__8057 = (i_8056 + (1));
i_8056 = G__8057;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts,(0));
});

cljs.core.MultiStepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__3877__auto__ = !((lt.stepper == null));
if(and__3877__auto__){
return this$.hasNext();
} else {
return and__3877__auto__;
}
})())){
if(cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform,cljs.core.cons(lt,this$.next())))){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__8053 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__8053) : self__.xform.call(null,G__8053));
}
});

cljs.core.MultiStepper.cljs$lang$type = true;

cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";

cljs.core.MultiStepper.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/MultiStepper");
});

cljs.core.__GT_MultiStepper = (function cljs$core$__GT_MultiStepper(xform,iters,nexts){
return (new cljs.core.MultiStepper(xform,iters,nexts));
});

cljs.core.multi_stepper = (function cljs$core$multi_stepper(){
var G__8059 = arguments.length;
switch (G__8059) {
case 2:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = (function (xform,iters){
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length)));
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = (function (xform,iters,nexts){
var stepfn = (function() {
var cljs$core$stepfn = null;
var cljs$core$stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return lt;
});
var cljs$core$stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepfn__1.call(this,result);
case 2:
return cljs$core$stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
return cljs$core$stepfn;
})()
;
return (new cljs.core.MultiStepper((function (){var G__8060 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__8060) : xform.call(null,G__8060));
})(),iters,nexts));
});

cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;

/**
* @constructor
*/
cljs.core.LazyTransformer = (function (stepper,first,rest,meta){
this.stepper = stepper;
this.first = first;
this.rest = rest;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 31719628;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,new_meta){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.LazyTransformer(self__.stepper,self__.first,self__.rest,new_meta));
});

cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,cljs.core._seq(this$__$1));
});

cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
var s = cljs.core._seq(this$__$1);
if(!((s == null))){
return cljs.core.equiv_sequential(this$__$1,other);
} else {
return (cljs.core.sequential_QMARK_(other)) && ((cljs.core.seq(other) == null));
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash_ordered_coll(this$__$1);
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
self__.stepper.step(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return this$__$1;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return self__.first;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return cljs.core._seq(self__.rest);
}
});

cljs.core.LazyTransformer.cljs$lang$type = true;

cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";

cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/LazyTransformer");
});

cljs.core.__GT_LazyTransformer = (function cljs$core$__GT_LazyTransformer(stepper,first,rest,meta){
return (new cljs.core.LazyTransformer(stepper,first,rest,meta));
});

(cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
cljs.core.LazyTransformer.create = (function (xform,coll){
return (new cljs.core.LazyTransformer(cljs.core.stepper(xform,cljs.core.iter(coll)),null,null,null));
});
cljs.core.LazyTransformer.createMulti = (function (xform,colls){
var iters = [];
var seq__8062_8066 = cljs.core.seq(colls);
var chunk__8063_8067 = null;
var count__8064_8068 = (0);
var i__8065_8069 = (0);
while(true){
if((i__8065_8069 < count__8064_8068)){
var coll_8070 = chunk__8063_8067.cljs$core$IIndexed$_nth$arity$2(null,i__8065_8069);
iters.push(cljs.core.iter(coll_8070));

var G__8071 = seq__8062_8066;
var G__8072 = chunk__8063_8067;
var G__8073 = count__8064_8068;
var G__8074 = (i__8065_8069 + (1));
seq__8062_8066 = G__8071;
chunk__8063_8067 = G__8072;
count__8064_8068 = G__8073;
i__8065_8069 = G__8074;
continue;
} else {
var temp__4404__auto___8075 = cljs.core.seq(seq__8062_8066);
if(temp__4404__auto___8075){
var seq__8062_8076__$1 = temp__4404__auto___8075;
if(cljs.core.chunked_seq_QMARK_(seq__8062_8076__$1)){
var c__4674__auto___8077 = cljs.core.chunk_first(seq__8062_8076__$1);
var G__8078 = cljs.core.chunk_rest(seq__8062_8076__$1);
var G__8079 = c__4674__auto___8077;
var G__8080 = cljs.core.count(c__4674__auto___8077);
var G__8081 = (0);
seq__8062_8066 = G__8078;
chunk__8063_8067 = G__8079;
count__8064_8068 = G__8080;
i__8065_8069 = G__8081;
continue;
} else {
var coll_8082 = cljs.core.first(seq__8062_8076__$1);
iters.push(cljs.core.iter(coll_8082));

var G__8083 = cljs.core.next(seq__8062_8076__$1);
var G__8084 = null;
var G__8085 = (0);
var G__8086 = (0);
seq__8062_8066 = G__8083;
chunk__8063_8067 = G__8084;
count__8064_8068 = G__8085;
i__8065_8069 = G__8086;
continue;
}
} else {
}
}
break;
}

return (new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length))),null,null,null));
});
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 * one. Will not force a lazy seq. (sequence nil) yields (), When a
 * transducer is supplied, returns a lazy sequence of applications of
 * the transform to the items in coll(s), i.e. to the set of first
 * items of each coll, followed by the set of second
 * items in each coll, until any one of the colls is exhausted.  Any
 * remaining items in other colls are ignored. The transform should accept
 * number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(){
var G__8091 = arguments.length;
switch (G__8091) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__3889__auto__ = cljs.core.seq(coll);
if(or__3889__auto__){
return or__3889__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function (xform,coll){
return cljs.core.LazyTransformer.create(xform,coll);
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function (xform,coll,colls){
return cljs.core.LazyTransformer.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls)));
});

cljs.core.sequence.cljs$lang$applyTo = (function (seq8087){
var G__8088 = cljs.core.first(seq8087);
var seq8087__$1 = cljs.core.next(seq8087);
var G__8089 = cljs.core.first(seq8087__$1);
var seq8087__$2 = cljs.core.next(seq8087__$1);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__8088,G__8089,seq8087__$2);
});

cljs.core.sequence.cljs$lang$maxFixedArity = 2;
/**
 * Returns true if (pred x) is logical true for every x in coll, else
 * false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__8094 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8094) : pred.call(null,G__8094));
})())){
var G__8095 = pred;
var G__8096 = cljs.core.next(coll);
pred = G__8095;
coll = G__8096;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 * coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_(pred,coll));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 * else nil.  One common idiom is to use a set as pred, for example
 * this will return :fred if :fred is in the sequence, otherwise nil:
 * (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
if(cljs.core.seq(coll)){
var or__3889__auto__ = (function (){var G__8100 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8100) : pred.call(null,G__8100));
})();
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
var G__8101 = pred;
var G__8102 = cljs.core.next(coll);
pred = G__8101;
coll = G__8102;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 * else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error([cljs.core.str("Argument must be an integer: "),cljs.core.str(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return !(cljs.core.even_QMARK_(n));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 * has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__8109 = null;
var G__8109__0 = (function (){
return cljs.core.not((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
});
var G__8109__1 = (function (x){
return cljs.core.not((function (){var G__8106 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8106) : f.call(null,G__8106));
})());
});
var G__8109__2 = (function (x,y){
return cljs.core.not((function (){var G__8107 = x;
var G__8108 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8107,G__8108) : f.call(null,G__8107,G__8108));
})());
});
var G__8109__3 = (function() { 
var G__8110__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__8110 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__8111__i = 0, G__8111__a = new Array(arguments.length -  2);
while (G__8111__i < G__8111__a.length) {G__8111__a[G__8111__i] = arguments[G__8111__i + 2]; ++G__8111__i;}
  zs = new cljs.core.IndexedSeq(G__8111__a,0);
} 
return G__8110__delegate.call(this,x,y,zs);};
G__8110.cljs$lang$maxFixedArity = 2;
G__8110.cljs$lang$applyTo = (function (arglist__8112){
var x = cljs.core.first(arglist__8112);
arglist__8112 = cljs.core.next(arglist__8112);
var y = cljs.core.first(arglist__8112);
var zs = cljs.core.rest(arglist__8112);
return G__8110__delegate(x,y,zs);
});
G__8110.cljs$core$IFn$_invoke$arity$variadic = G__8110__delegate;
return G__8110;
})()
;
G__8109 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__8109__0.call(this);
case 1:
return G__8109__1.call(this,x);
case 2:
return G__8109__2.call(this,x,y);
default:
var G__8113 = null;
if (arguments.length > 2) {
var G__8114__i = 0, G__8114__a = new Array(arguments.length -  2);
while (G__8114__i < G__8114__a.length) {G__8114__a[G__8114__i] = arguments[G__8114__i + 2]; ++G__8114__i;}
G__8113 = new cljs.core.IndexedSeq(G__8114__a,0);
}
return G__8109__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__8113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8109.cljs$lang$maxFixedArity = 2;
G__8109.cljs$lang$applyTo = G__8109__3.cljs$lang$applyTo;
G__8109.cljs$core$IFn$_invoke$arity$0 = G__8109__0;
G__8109.cljs$core$IFn$_invoke$arity$1 = G__8109__1;
G__8109.cljs$core$IFn$_invoke$arity$2 = G__8109__2;
G__8109.cljs$core$IFn$_invoke$arity$variadic = G__8109__3.cljs$core$IFn$_invoke$arity$variadic;
return G__8109;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__8115__delegate = function (args){
return x;
};
var G__8115 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__8116__i = 0, G__8116__a = new Array(arguments.length -  0);
while (G__8116__i < G__8116__a.length) {G__8116__a[G__8116__i] = arguments[G__8116__i + 0]; ++G__8116__i;}
  args = new cljs.core.IndexedSeq(G__8116__a,0);
} 
return G__8115__delegate.call(this,args);};
G__8115.cljs$lang$maxFixedArity = 0;
G__8115.cljs$lang$applyTo = (function (arglist__8117){
var args = cljs.core.seq(arglist__8117);
return G__8115__delegate(args);
});
G__8115.cljs$core$IFn$_invoke$arity$variadic = G__8115__delegate;
return G__8115;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 * of those fns.  The returned fn takes a variable number of args,
 * applies the rightmost of fns to the args, the next
 * fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(){
var G__8123 = arguments.length;
switch (G__8123) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4941__auto__);

}
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.identity;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__8152 = null;
var G__8152__0 = (function (){
var G__8124 = (function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8124) : f.call(null,G__8124));
});
var G__8152__1 = (function (x){
var G__8125 = (function (){var G__8126 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8126) : g.call(null,G__8126));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8125) : f.call(null,G__8125));
});
var G__8152__2 = (function (x,y){
var G__8127 = (function (){var G__8128 = x;
var G__8129 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__8128,G__8129) : g.call(null,G__8128,G__8129));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8127) : f.call(null,G__8127));
});
var G__8152__3 = (function (x,y,z){
var G__8130 = (function (){var G__8131 = x;
var G__8132 = y;
var G__8133 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__8131,G__8132,G__8133) : g.call(null,G__8131,G__8132,G__8133));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8130) : f.call(null,G__8130));
});
var G__8152__4 = (function() { 
var G__8153__delegate = function (x,y,z,args){
var G__8134 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8134) : f.call(null,G__8134));
};
var G__8153 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8154__i = 0, G__8154__a = new Array(arguments.length -  3);
while (G__8154__i < G__8154__a.length) {G__8154__a[G__8154__i] = arguments[G__8154__i + 3]; ++G__8154__i;}
  args = new cljs.core.IndexedSeq(G__8154__a,0);
} 
return G__8153__delegate.call(this,x,y,z,args);};
G__8153.cljs$lang$maxFixedArity = 3;
G__8153.cljs$lang$applyTo = (function (arglist__8155){
var x = cljs.core.first(arglist__8155);
arglist__8155 = cljs.core.next(arglist__8155);
var y = cljs.core.first(arglist__8155);
arglist__8155 = cljs.core.next(arglist__8155);
var z = cljs.core.first(arglist__8155);
var args = cljs.core.rest(arglist__8155);
return G__8153__delegate(x,y,z,args);
});
G__8153.cljs$core$IFn$_invoke$arity$variadic = G__8153__delegate;
return G__8153;
})()
;
G__8152 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8152__0.call(this);
case 1:
return G__8152__1.call(this,x);
case 2:
return G__8152__2.call(this,x,y);
case 3:
return G__8152__3.call(this,x,y,z);
default:
var G__8156 = null;
if (arguments.length > 3) {
var G__8157__i = 0, G__8157__a = new Array(arguments.length -  3);
while (G__8157__i < G__8157__a.length) {G__8157__a[G__8157__i] = arguments[G__8157__i + 3]; ++G__8157__i;}
G__8156 = new cljs.core.IndexedSeq(G__8157__a,0);
}
return G__8152__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8152.cljs$lang$maxFixedArity = 3;
G__8152.cljs$lang$applyTo = G__8152__4.cljs$lang$applyTo;
G__8152.cljs$core$IFn$_invoke$arity$0 = G__8152__0;
G__8152.cljs$core$IFn$_invoke$arity$1 = G__8152__1;
G__8152.cljs$core$IFn$_invoke$arity$2 = G__8152__2;
G__8152.cljs$core$IFn$_invoke$arity$3 = G__8152__3;
G__8152.cljs$core$IFn$_invoke$arity$variadic = G__8152__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8152;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__8158 = null;
var G__8158__0 = (function (){
var G__8135 = (function (){var G__8136 = (function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8136) : g.call(null,G__8136));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8135) : f.call(null,G__8135));
});
var G__8158__1 = (function (x){
var G__8137 = (function (){var G__8138 = (function (){var G__8139 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__8139) : h.call(null,G__8139));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8138) : g.call(null,G__8138));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8137) : f.call(null,G__8137));
});
var G__8158__2 = (function (x,y){
var G__8140 = (function (){var G__8141 = (function (){var G__8142 = x;
var G__8143 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__8142,G__8143) : h.call(null,G__8142,G__8143));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8141) : g.call(null,G__8141));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8140) : f.call(null,G__8140));
});
var G__8158__3 = (function (x,y,z){
var G__8144 = (function (){var G__8145 = (function (){var G__8146 = x;
var G__8147 = y;
var G__8148 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__8146,G__8147,G__8148) : h.call(null,G__8146,G__8147,G__8148));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8145) : g.call(null,G__8145));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8144) : f.call(null,G__8144));
});
var G__8158__4 = (function() { 
var G__8159__delegate = function (x,y,z,args){
var G__8149 = (function (){var G__8150 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__8150) : g.call(null,G__8150));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8149) : f.call(null,G__8149));
};
var G__8159 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8160__i = 0, G__8160__a = new Array(arguments.length -  3);
while (G__8160__i < G__8160__a.length) {G__8160__a[G__8160__i] = arguments[G__8160__i + 3]; ++G__8160__i;}
  args = new cljs.core.IndexedSeq(G__8160__a,0);
} 
return G__8159__delegate.call(this,x,y,z,args);};
G__8159.cljs$lang$maxFixedArity = 3;
G__8159.cljs$lang$applyTo = (function (arglist__8161){
var x = cljs.core.first(arglist__8161);
arglist__8161 = cljs.core.next(arglist__8161);
var y = cljs.core.first(arglist__8161);
arglist__8161 = cljs.core.next(arglist__8161);
var z = cljs.core.first(arglist__8161);
var args = cljs.core.rest(arglist__8161);
return G__8159__delegate(x,y,z,args);
});
G__8159.cljs$core$IFn$_invoke$arity$variadic = G__8159__delegate;
return G__8159;
})()
;
G__8158 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8158__0.call(this);
case 1:
return G__8158__1.call(this,x);
case 2:
return G__8158__2.call(this,x,y);
case 3:
return G__8158__3.call(this,x,y,z);
default:
var G__8162 = null;
if (arguments.length > 3) {
var G__8163__i = 0, G__8163__a = new Array(arguments.length -  3);
while (G__8163__i < G__8163__a.length) {G__8163__a[G__8163__i] = arguments[G__8163__i + 3]; ++G__8163__i;}
G__8162 = new cljs.core.IndexedSeq(G__8163__a,0);
}
return G__8158__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8158.cljs$lang$maxFixedArity = 3;
G__8158.cljs$lang$applyTo = G__8158__4.cljs$lang$applyTo;
G__8158.cljs$core$IFn$_invoke$arity$0 = G__8158__0;
G__8158.cljs$core$IFn$_invoke$arity$1 = G__8158__1;
G__8158.cljs$core$IFn$_invoke$arity$2 = G__8158__2;
G__8158.cljs$core$IFn$_invoke$arity$3 = G__8158__3;
G__8158.cljs$core$IFn$_invoke$arity$variadic = G__8158__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8158;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__8164__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__8165 = cljs.core.first(fs__$2).call(null,ret);
var G__8166 = cljs.core.next(fs__$2);
ret = G__8165;
fs__$2 = G__8166;
continue;
} else {
return ret;
}
break;
}
};
var G__8164 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__8167__i = 0, G__8167__a = new Array(arguments.length -  0);
while (G__8167__i < G__8167__a.length) {G__8167__a[G__8167__i] = arguments[G__8167__i + 0]; ++G__8167__i;}
  args = new cljs.core.IndexedSeq(G__8167__a,0);
} 
return G__8164__delegate.call(this,args);};
G__8164.cljs$lang$maxFixedArity = 0;
G__8164.cljs$lang$applyTo = (function (arglist__8168){
var args = cljs.core.seq(arglist__8168);
return G__8164__delegate(args);
});
G__8164.cljs$core$IFn$_invoke$arity$variadic = G__8164__delegate;
return G__8164;
})()
;
;})(fs__$1))
});

cljs.core.comp.cljs$lang$applyTo = (function (seq8118){
var G__8119 = cljs.core.first(seq8118);
var seq8118__$1 = cljs.core.next(seq8118);
var G__8120 = cljs.core.first(seq8118__$1);
var seq8118__$2 = cljs.core.next(seq8118__$1);
var G__8121 = cljs.core.first(seq8118__$2);
var seq8118__$3 = cljs.core.next(seq8118__$2);
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__8119,G__8120,G__8121,seq8118__$3);
});

cljs.core.comp.cljs$lang$maxFixedArity = 3;
/**
 * Takes a function f and fewer than the normal arguments to f, and
 * returns a fn that takes a variable number of additional args. When
 * called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(){
var G__8175 = arguments.length;
switch (G__8175) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4941__auto__);

}
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function (f,arg1){
return (function() {
var G__8219 = null;
var G__8219__0 = (function (){
var G__8176 = arg1;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8176) : f.call(null,G__8176));
});
var G__8219__1 = (function (x){
var G__8177 = arg1;
var G__8178 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8177,G__8178) : f.call(null,G__8177,G__8178));
});
var G__8219__2 = (function (x,y){
var G__8179 = arg1;
var G__8180 = x;
var G__8181 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8179,G__8180,G__8181) : f.call(null,G__8179,G__8180,G__8181));
});
var G__8219__3 = (function (x,y,z){
var G__8182 = arg1;
var G__8183 = x;
var G__8184 = y;
var G__8185 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8182,G__8183,G__8184,G__8185) : f.call(null,G__8182,G__8183,G__8184,G__8185));
});
var G__8219__4 = (function() { 
var G__8220__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.array_seq([args], 0));
};
var G__8220 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8221__i = 0, G__8221__a = new Array(arguments.length -  3);
while (G__8221__i < G__8221__a.length) {G__8221__a[G__8221__i] = arguments[G__8221__i + 3]; ++G__8221__i;}
  args = new cljs.core.IndexedSeq(G__8221__a,0);
} 
return G__8220__delegate.call(this,x,y,z,args);};
G__8220.cljs$lang$maxFixedArity = 3;
G__8220.cljs$lang$applyTo = (function (arglist__8222){
var x = cljs.core.first(arglist__8222);
arglist__8222 = cljs.core.next(arglist__8222);
var y = cljs.core.first(arglist__8222);
arglist__8222 = cljs.core.next(arglist__8222);
var z = cljs.core.first(arglist__8222);
var args = cljs.core.rest(arglist__8222);
return G__8220__delegate(x,y,z,args);
});
G__8220.cljs$core$IFn$_invoke$arity$variadic = G__8220__delegate;
return G__8220;
})()
;
G__8219 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8219__0.call(this);
case 1:
return G__8219__1.call(this,x);
case 2:
return G__8219__2.call(this,x,y);
case 3:
return G__8219__3.call(this,x,y,z);
default:
var G__8223 = null;
if (arguments.length > 3) {
var G__8224__i = 0, G__8224__a = new Array(arguments.length -  3);
while (G__8224__i < G__8224__a.length) {G__8224__a[G__8224__i] = arguments[G__8224__i + 3]; ++G__8224__i;}
G__8223 = new cljs.core.IndexedSeq(G__8224__a,0);
}
return G__8219__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8219.cljs$lang$maxFixedArity = 3;
G__8219.cljs$lang$applyTo = G__8219__4.cljs$lang$applyTo;
G__8219.cljs$core$IFn$_invoke$arity$0 = G__8219__0;
G__8219.cljs$core$IFn$_invoke$arity$1 = G__8219__1;
G__8219.cljs$core$IFn$_invoke$arity$2 = G__8219__2;
G__8219.cljs$core$IFn$_invoke$arity$3 = G__8219__3;
G__8219.cljs$core$IFn$_invoke$arity$variadic = G__8219__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8219;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function (f,arg1,arg2){
return (function() {
var G__8225 = null;
var G__8225__0 = (function (){
var G__8186 = arg1;
var G__8187 = arg2;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8186,G__8187) : f.call(null,G__8186,G__8187));
});
var G__8225__1 = (function (x){
var G__8188 = arg1;
var G__8189 = arg2;
var G__8190 = x;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8188,G__8189,G__8190) : f.call(null,G__8188,G__8189,G__8190));
});
var G__8225__2 = (function (x,y){
var G__8191 = arg1;
var G__8192 = arg2;
var G__8193 = x;
var G__8194 = y;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8191,G__8192,G__8193,G__8194) : f.call(null,G__8191,G__8192,G__8193,G__8194));
});
var G__8225__3 = (function (x,y,z){
var G__8195 = arg1;
var G__8196 = arg2;
var G__8197 = x;
var G__8198 = y;
var G__8199 = z;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__8195,G__8196,G__8197,G__8198,G__8199) : f.call(null,G__8195,G__8196,G__8197,G__8198,G__8199));
});
var G__8225__4 = (function() { 
var G__8226__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.array_seq([z,args], 0));
};
var G__8226 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8227__i = 0, G__8227__a = new Array(arguments.length -  3);
while (G__8227__i < G__8227__a.length) {G__8227__a[G__8227__i] = arguments[G__8227__i + 3]; ++G__8227__i;}
  args = new cljs.core.IndexedSeq(G__8227__a,0);
} 
return G__8226__delegate.call(this,x,y,z,args);};
G__8226.cljs$lang$maxFixedArity = 3;
G__8226.cljs$lang$applyTo = (function (arglist__8228){
var x = cljs.core.first(arglist__8228);
arglist__8228 = cljs.core.next(arglist__8228);
var y = cljs.core.first(arglist__8228);
arglist__8228 = cljs.core.next(arglist__8228);
var z = cljs.core.first(arglist__8228);
var args = cljs.core.rest(arglist__8228);
return G__8226__delegate(x,y,z,args);
});
G__8226.cljs$core$IFn$_invoke$arity$variadic = G__8226__delegate;
return G__8226;
})()
;
G__8225 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8225__0.call(this);
case 1:
return G__8225__1.call(this,x);
case 2:
return G__8225__2.call(this,x,y);
case 3:
return G__8225__3.call(this,x,y,z);
default:
var G__8229 = null;
if (arguments.length > 3) {
var G__8230__i = 0, G__8230__a = new Array(arguments.length -  3);
while (G__8230__i < G__8230__a.length) {G__8230__a[G__8230__i] = arguments[G__8230__i + 3]; ++G__8230__i;}
G__8229 = new cljs.core.IndexedSeq(G__8230__a,0);
}
return G__8225__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8225.cljs$lang$maxFixedArity = 3;
G__8225.cljs$lang$applyTo = G__8225__4.cljs$lang$applyTo;
G__8225.cljs$core$IFn$_invoke$arity$0 = G__8225__0;
G__8225.cljs$core$IFn$_invoke$arity$1 = G__8225__1;
G__8225.cljs$core$IFn$_invoke$arity$2 = G__8225__2;
G__8225.cljs$core$IFn$_invoke$arity$3 = G__8225__3;
G__8225.cljs$core$IFn$_invoke$arity$variadic = G__8225__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8225;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__8231 = null;
var G__8231__0 = (function (){
var G__8200 = arg1;
var G__8201 = arg2;
var G__8202 = arg3;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8200,G__8201,G__8202) : f.call(null,G__8200,G__8201,G__8202));
});
var G__8231__1 = (function (x){
var G__8203 = arg1;
var G__8204 = arg2;
var G__8205 = arg3;
var G__8206 = x;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8203,G__8204,G__8205,G__8206) : f.call(null,G__8203,G__8204,G__8205,G__8206));
});
var G__8231__2 = (function (x,y){
var G__8207 = arg1;
var G__8208 = arg2;
var G__8209 = arg3;
var G__8210 = x;
var G__8211 = y;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__8207,G__8208,G__8209,G__8210,G__8211) : f.call(null,G__8207,G__8208,G__8209,G__8210,G__8211));
});
var G__8231__3 = (function (x,y,z){
var G__8212 = arg1;
var G__8213 = arg2;
var G__8214 = arg3;
var G__8215 = x;
var G__8216 = y;
var G__8217 = z;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__8212,G__8213,G__8214,G__8215,G__8216,G__8217) : f.call(null,G__8212,G__8213,G__8214,G__8215,G__8216,G__8217));
});
var G__8231__4 = (function() { 
var G__8232__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.array_seq([y,z,args], 0));
};
var G__8232 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8233__i = 0, G__8233__a = new Array(arguments.length -  3);
while (G__8233__i < G__8233__a.length) {G__8233__a[G__8233__i] = arguments[G__8233__i + 3]; ++G__8233__i;}
  args = new cljs.core.IndexedSeq(G__8233__a,0);
} 
return G__8232__delegate.call(this,x,y,z,args);};
G__8232.cljs$lang$maxFixedArity = 3;
G__8232.cljs$lang$applyTo = (function (arglist__8234){
var x = cljs.core.first(arglist__8234);
arglist__8234 = cljs.core.next(arglist__8234);
var y = cljs.core.first(arglist__8234);
arglist__8234 = cljs.core.next(arglist__8234);
var z = cljs.core.first(arglist__8234);
var args = cljs.core.rest(arglist__8234);
return G__8232__delegate(x,y,z,args);
});
G__8232.cljs$core$IFn$_invoke$arity$variadic = G__8232__delegate;
return G__8232;
})()
;
G__8231 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__8231__0.call(this);
case 1:
return G__8231__1.call(this,x);
case 2:
return G__8231__2.call(this,x,y);
case 3:
return G__8231__3.call(this,x,y,z);
default:
var G__8235 = null;
if (arguments.length > 3) {
var G__8236__i = 0, G__8236__a = new Array(arguments.length -  3);
while (G__8236__i < G__8236__a.length) {G__8236__a[G__8236__i] = arguments[G__8236__i + 3]; ++G__8236__i;}
G__8235 = new cljs.core.IndexedSeq(G__8236__a,0);
}
return G__8231__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8231.cljs$lang$maxFixedArity = 3;
G__8231.cljs$lang$applyTo = G__8231__4.cljs$lang$applyTo;
G__8231.cljs$core$IFn$_invoke$arity$0 = G__8231__0;
G__8231.cljs$core$IFn$_invoke$arity$1 = G__8231__1;
G__8231.cljs$core$IFn$_invoke$arity$2 = G__8231__2;
G__8231.cljs$core$IFn$_invoke$arity$3 = G__8231__3;
G__8231.cljs$core$IFn$_invoke$arity$variadic = G__8231__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8231;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg1,arg2,arg3,more){
return (function() { 
var G__8237__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__8237 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__8238__i = 0, G__8238__a = new Array(arguments.length -  0);
while (G__8238__i < G__8238__a.length) {G__8238__a[G__8238__i] = arguments[G__8238__i + 0]; ++G__8238__i;}
  args = new cljs.core.IndexedSeq(G__8238__a,0);
} 
return G__8237__delegate.call(this,args);};
G__8237.cljs$lang$maxFixedArity = 0;
G__8237.cljs$lang$applyTo = (function (arglist__8239){
var args = cljs.core.seq(arglist__8239);
return G__8237__delegate(args);
});
G__8237.cljs$core$IFn$_invoke$arity$variadic = G__8237__delegate;
return G__8237;
})()
;
});

cljs.core.partial.cljs$lang$applyTo = (function (seq8169){
var G__8170 = cljs.core.first(seq8169);
var seq8169__$1 = cljs.core.next(seq8169);
var G__8171 = cljs.core.first(seq8169__$1);
var seq8169__$2 = cljs.core.next(seq8169__$1);
var G__8172 = cljs.core.first(seq8169__$2);
var seq8169__$3 = cljs.core.next(seq8169__$2);
var G__8173 = cljs.core.first(seq8169__$3);
var seq8169__$4 = cljs.core.next(seq8169__$3);
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__8170,G__8171,G__8172,G__8173,seq8169__$4);
});

cljs.core.partial.cljs$lang$maxFixedArity = 4;
/**
 * Takes a function f, and returns a function that calls f, replacing
 * a nil first argument to f with the supplied value x. Higher arity
 * versions can replace arguments in the second and third
 * positions (y, z). Note that the function f can take any number of
 * arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(){
var G__8241 = arguments.length;
switch (G__8241) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function (f,x){
return (function() {
var G__8259 = null;
var G__8259__1 = (function (a){
var G__8242 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8242) : f.call(null,G__8242));
});
var G__8259__2 = (function (a,b){
var G__8243 = (((a == null))?x:a);
var G__8244 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8243,G__8244) : f.call(null,G__8243,G__8244));
});
var G__8259__3 = (function (a,b,c){
var G__8245 = (((a == null))?x:a);
var G__8246 = b;
var G__8247 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8245,G__8246,G__8247) : f.call(null,G__8245,G__8246,G__8247));
});
var G__8259__4 = (function() { 
var G__8260__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__8260 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__8261__i = 0, G__8261__a = new Array(arguments.length -  3);
while (G__8261__i < G__8261__a.length) {G__8261__a[G__8261__i] = arguments[G__8261__i + 3]; ++G__8261__i;}
  ds = new cljs.core.IndexedSeq(G__8261__a,0);
} 
return G__8260__delegate.call(this,a,b,c,ds);};
G__8260.cljs$lang$maxFixedArity = 3;
G__8260.cljs$lang$applyTo = (function (arglist__8262){
var a = cljs.core.first(arglist__8262);
arglist__8262 = cljs.core.next(arglist__8262);
var b = cljs.core.first(arglist__8262);
arglist__8262 = cljs.core.next(arglist__8262);
var c = cljs.core.first(arglist__8262);
var ds = cljs.core.rest(arglist__8262);
return G__8260__delegate(a,b,c,ds);
});
G__8260.cljs$core$IFn$_invoke$arity$variadic = G__8260__delegate;
return G__8260;
})()
;
G__8259 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__8259__1.call(this,a);
case 2:
return G__8259__2.call(this,a,b);
case 3:
return G__8259__3.call(this,a,b,c);
default:
var G__8263 = null;
if (arguments.length > 3) {
var G__8264__i = 0, G__8264__a = new Array(arguments.length -  3);
while (G__8264__i < G__8264__a.length) {G__8264__a[G__8264__i] = arguments[G__8264__i + 3]; ++G__8264__i;}
G__8263 = new cljs.core.IndexedSeq(G__8264__a,0);
}
return G__8259__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__8263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8259.cljs$lang$maxFixedArity = 3;
G__8259.cljs$lang$applyTo = G__8259__4.cljs$lang$applyTo;
G__8259.cljs$core$IFn$_invoke$arity$1 = G__8259__1;
G__8259.cljs$core$IFn$_invoke$arity$2 = G__8259__2;
G__8259.cljs$core$IFn$_invoke$arity$3 = G__8259__3;
G__8259.cljs$core$IFn$_invoke$arity$variadic = G__8259__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8259;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function (f,x,y){
return (function() {
var G__8265 = null;
var G__8265__2 = (function (a,b){
var G__8248 = (((a == null))?x:a);
var G__8249 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8248,G__8249) : f.call(null,G__8248,G__8249));
});
var G__8265__3 = (function (a,b,c){
var G__8250 = (((a == null))?x:a);
var G__8251 = (((b == null))?y:b);
var G__8252 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8250,G__8251,G__8252) : f.call(null,G__8250,G__8251,G__8252));
});
var G__8265__4 = (function() { 
var G__8266__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__8266 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__8267__i = 0, G__8267__a = new Array(arguments.length -  3);
while (G__8267__i < G__8267__a.length) {G__8267__a[G__8267__i] = arguments[G__8267__i + 3]; ++G__8267__i;}
  ds = new cljs.core.IndexedSeq(G__8267__a,0);
} 
return G__8266__delegate.call(this,a,b,c,ds);};
G__8266.cljs$lang$maxFixedArity = 3;
G__8266.cljs$lang$applyTo = (function (arglist__8268){
var a = cljs.core.first(arglist__8268);
arglist__8268 = cljs.core.next(arglist__8268);
var b = cljs.core.first(arglist__8268);
arglist__8268 = cljs.core.next(arglist__8268);
var c = cljs.core.first(arglist__8268);
var ds = cljs.core.rest(arglist__8268);
return G__8266__delegate(a,b,c,ds);
});
G__8266.cljs$core$IFn$_invoke$arity$variadic = G__8266__delegate;
return G__8266;
})()
;
G__8265 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__8265__2.call(this,a,b);
case 3:
return G__8265__3.call(this,a,b,c);
default:
var G__8269 = null;
if (arguments.length > 3) {
var G__8270__i = 0, G__8270__a = new Array(arguments.length -  3);
while (G__8270__i < G__8270__a.length) {G__8270__a[G__8270__i] = arguments[G__8270__i + 3]; ++G__8270__i;}
G__8269 = new cljs.core.IndexedSeq(G__8270__a,0);
}
return G__8265__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__8269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8265.cljs$lang$maxFixedArity = 3;
G__8265.cljs$lang$applyTo = G__8265__4.cljs$lang$applyTo;
G__8265.cljs$core$IFn$_invoke$arity$2 = G__8265__2;
G__8265.cljs$core$IFn$_invoke$arity$3 = G__8265__3;
G__8265.cljs$core$IFn$_invoke$arity$variadic = G__8265__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8265;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,z){
return (function() {
var G__8271 = null;
var G__8271__2 = (function (a,b){
var G__8253 = (((a == null))?x:a);
var G__8254 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8253,G__8254) : f.call(null,G__8253,G__8254));
});
var G__8271__3 = (function (a,b,c){
var G__8255 = (((a == null))?x:a);
var G__8256 = (((b == null))?y:b);
var G__8257 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8255,G__8256,G__8257) : f.call(null,G__8255,G__8256,G__8257));
});
var G__8271__4 = (function() { 
var G__8272__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__8272 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__8273__i = 0, G__8273__a = new Array(arguments.length -  3);
while (G__8273__i < G__8273__a.length) {G__8273__a[G__8273__i] = arguments[G__8273__i + 3]; ++G__8273__i;}
  ds = new cljs.core.IndexedSeq(G__8273__a,0);
} 
return G__8272__delegate.call(this,a,b,c,ds);};
G__8272.cljs$lang$maxFixedArity = 3;
G__8272.cljs$lang$applyTo = (function (arglist__8274){
var a = cljs.core.first(arglist__8274);
arglist__8274 = cljs.core.next(arglist__8274);
var b = cljs.core.first(arglist__8274);
arglist__8274 = cljs.core.next(arglist__8274);
var c = cljs.core.first(arglist__8274);
var ds = cljs.core.rest(arglist__8274);
return G__8272__delegate(a,b,c,ds);
});
G__8272.cljs$core$IFn$_invoke$arity$variadic = G__8272__delegate;
return G__8272;
})()
;
G__8271 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__8271__2.call(this,a,b);
case 3:
return G__8271__3.call(this,a,b,c);
default:
var G__8275 = null;
if (arguments.length > 3) {
var G__8276__i = 0, G__8276__a = new Array(arguments.length -  3);
while (G__8276__i < G__8276__a.length) {G__8276__a[G__8276__i] = arguments[G__8276__i + 3]; ++G__8276__i;}
G__8275 = new cljs.core.IndexedSeq(G__8276__a,0);
}
return G__8271__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__8275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8271.cljs$lang$maxFixedArity = 3;
G__8271.cljs$lang$applyTo = G__8271__4.cljs$lang$applyTo;
G__8271.cljs$core$IFn$_invoke$arity$2 = G__8271__2;
G__8271.cljs$core$IFn$_invoke$arity$3 = G__8271__3;
G__8271.cljs$core$IFn$_invoke$arity$variadic = G__8271__4.cljs$core$IFn$_invoke$arity$variadic;
return G__8271;
})()
});

cljs.core.fnil.cljs$lang$maxFixedArity = 4;
/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 * and the first item of coll, followed by applying f to 1 and the second
 * item in coll, etc, until coll is exhausted. Thus function f should
 * accept 2 arguments, index and item.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(){
var G__8278 = arguments.length;
switch (G__8278) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var i = (function (){var G__8279 = (-1);
return (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(G__8279) : cljs.core.volatile_BANG_.call(null,G__8279));
})();
return ((function (i){
return (function() {
var G__8310 = null;
var G__8310__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8310__1 = (function (result){
var G__8280 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8280) : rf.call(null,G__8280));
});
var G__8310__2 = (function (result,input){
var G__8281 = result;
var G__8282 = (function (){var G__8283 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__8284 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8283,G__8284) : f.call(null,G__8283,G__8284));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8281,G__8282) : rf.call(null,G__8281,G__8282));
});
G__8310 = function(result,input){
switch(arguments.length){
case 0:
return G__8310__0.call(this);
case 1:
return G__8310__1.call(this,result);
case 2:
return G__8310__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8310.cljs$core$IFn$_invoke$arity$0 = G__8310__0;
G__8310.cljs$core$IFn$_invoke$arity$1 = G__8310__1;
G__8310.cljs$core$IFn$_invoke$arity$2 = G__8310__2;
return G__8310;
})()
;})(i))
});
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var mapi = (function cljs$core$mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4404__auto__ = cljs.core.seq(coll__$1);
if(temp__4404__auto__){
var s = temp__4404__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4774__auto___8311 = size;
var i_8312 = (0);
while(true){
if((i_8312 < n__4774__auto___8311)){
cljs.core.chunk_append(b,(function (){var G__8305 = (idx + i_8312);
var G__8306 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8312);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8305,G__8306) : f.call(null,G__8305,G__8306));
})());

var G__8313 = (i_8312 + (1));
i_8312 = G__8313;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__8307 = idx;
var G__8308 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8307,G__8308) : f.call(null,G__8307,G__8308));
})(),cljs$core$mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});

cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 * this means false return values will be included.  f must be free of
 * side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(){
var G__8315 = arguments.length;
switch (G__8315) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__8323 = null;
var G__8323__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8323__1 = (function (result){
var G__8316 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8316) : rf.call(null,G__8316));
});
var G__8323__2 = (function (result,input){
var v = (function (){var G__8317 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8317) : f.call(null,G__8317));
})();
if((v == null)){
return result;
} else {
var G__8318 = result;
var G__8319 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8318,G__8319) : rf.call(null,G__8318,G__8319));
}
});
G__8323 = function(result,input){
switch(arguments.length){
case 0:
return G__8323__0.call(this);
case 1:
return G__8323__1.call(this,result);
case 2:
return G__8323__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8323.cljs$core$IFn$_invoke$arity$0 = G__8323__0;
G__8323.cljs$core$IFn$_invoke$arity$1 = G__8323__1;
G__8323.cljs$core$IFn$_invoke$arity$2 = G__8323__2;
return G__8323;
})()
});
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4404__auto__ = cljs.core.seq(coll);
if(temp__4404__auto__){
var s = temp__4404__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4774__auto___8324 = size;
var i_8325 = (0);
while(true){
if((i_8325 < n__4774__auto___8324)){
var x_8326 = (function (){var G__8320 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8325);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8320) : f.call(null,G__8320));
})();
if((x_8326 == null)){
} else {
cljs.core.chunk_append(b,x_8326);
}

var G__8327 = (i_8325 + (1));
i_8325 = G__8327;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__8321 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8321) : f.call(null,G__8321));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.keep.cljs$lang$maxFixedArity = 2;

/**
* @constructor
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
})
cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__8328 = cljs.core.seq(self__.watches);
var chunk__8329 = null;
var count__8330 = (0);
var i__8331 = (0);
while(true){
if((i__8331 < count__8330)){
var vec__8332 = chunk__8329.cljs$core$IIndexed$_nth$arity$2(null,i__8331);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8332,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8332,(1),null);
var G__8333_8343 = key;
var G__8334_8344 = this$__$1;
var G__8335_8345 = oldval;
var G__8336_8346 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8333_8343,G__8334_8344,G__8335_8345,G__8336_8346) : f.call(null,G__8333_8343,G__8334_8344,G__8335_8345,G__8336_8346));

var G__8347 = seq__8328;
var G__8348 = chunk__8329;
var G__8349 = count__8330;
var G__8350 = (i__8331 + (1));
seq__8328 = G__8347;
chunk__8329 = G__8348;
count__8330 = G__8349;
i__8331 = G__8350;
continue;
} else {
var temp__4404__auto__ = cljs.core.seq(seq__8328);
if(temp__4404__auto__){
var seq__8328__$1 = temp__4404__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__8328__$1)){
var c__4674__auto__ = cljs.core.chunk_first(seq__8328__$1);
var G__8351 = cljs.core.chunk_rest(seq__8328__$1);
var G__8352 = c__4674__auto__;
var G__8353 = cljs.core.count(c__4674__auto__);
var G__8354 = (0);
seq__8328 = G__8351;
chunk__8329 = G__8352;
count__8330 = G__8353;
i__8331 = G__8354;
continue;
} else {
var vec__8337 = cljs.core.first(seq__8328__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8337,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8337,(1),null);
var G__8338_8355 = key;
var G__8339_8356 = this$__$1;
var G__8340_8357 = oldval;
var G__8341_8358 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__8338_8355,G__8339_8356,G__8340_8357,G__8341_8358) : f.call(null,G__8338_8355,G__8339_8356,G__8340_8357,G__8341_8358));

var G__8359 = cljs.core.next(seq__8328__$1);
var G__8360 = null;
var G__8361 = (0);
var G__8362 = (0);
seq__8328 = G__8359;
chunk__8329 = G__8360;
count__8330 = G__8361;
i__8331 = G__8362;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__8342 = this$__$1;
return goog.getUid(G__8342);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/Atom");
});

cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 * more options (in any order):
 * 
 * :meta metadata-map
 * 
 * :validator validate-fn
 * 
 * If metadata-map is supplied, it will be come the metadata on the
 * atom. validate-fn must be nil or a side-effect-free fn of one
 * argument, which will be passed the intended new state on any state
 * change. If the new state is unacceptable, the validate-fn should
 * return false or throw an Error.  If either of these error conditions
 * occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(){
var G__8366 = arguments.length;
switch (G__8366) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,1),(0)));
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4941__auto__);

}
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__8367){
var map__8368 = p__8367;
var map__8368__$1 = ((cljs.core.seq_QMARK_(map__8368))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__8368):map__8368);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8368__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8368__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
return (new cljs.core.Atom(x,meta,validator,null));
});

cljs.core.atom.cljs$lang$applyTo = (function (seq8363){
var G__8364 = cljs.core.first(seq8363);
var seq8363__$1 = cljs.core.next(seq8363);
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__8364,seq8363__$1);
});

cljs.core.atom.cljs$lang$maxFixedArity = 1;
/**
 * Sets the value of atom to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((function (){var G__8372 = new_value;
return (validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(G__8372) : validate.call(null,G__8372));
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Validator rejected reference state"),cljs.core.str("\n"),cljs.core.str((function (){var G__8373 = cljs.core.list(new cljs.core.Symbol(null,"validate","validate",1439230700,null),new cljs.core.Symbol(null,"new-value","new-value",-1567397401,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__8373) : cljs.core.pr_str.call(null,G__8373));
})())].join('')));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Atomically swaps the value of atom to be:
 * (apply f current-value-of-atom args). Note that f may be called
 * multiple times, and thus should be free of side effects.  Returns
 * the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(){
var G__8380 = arguments.length;
switch (G__8380) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4941__auto__);

}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__8381 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8381) : f.call(null,G__8381));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__8382 = a.state;
var G__8383 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8382,G__8383) : f.call(null,G__8382,G__8383));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__8384 = a.state;
var G__8385 = x;
var G__8386 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8384,G__8385,G__8386) : f.call(null,G__8384,G__8385,G__8386));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
});

cljs.core.swap_BANG_.cljs$lang$applyTo = (function (seq8374){
var G__8375 = cljs.core.first(seq8374);
var seq8374__$1 = cljs.core.next(seq8374);
var G__8376 = cljs.core.first(seq8374__$1);
var seq8374__$2 = cljs.core.next(seq8374__$1);
var G__8377 = cljs.core.first(seq8374__$2);
var seq8374__$3 = cljs.core.next(seq8374__$2);
var G__8378 = cljs.core.first(seq8374__$3);
var seq8374__$4 = cljs.core.next(seq8374__$3);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__8375,G__8376,G__8377,G__8378,seq8374__$4);
});

cljs.core.swap_BANG_.cljs$lang$maxFixedArity = 4;
/**
 * Atomically sets the value of atom to newval if and only if the
 * current value of the atom is equal to oldval. Returns true if
 * set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 * side-effect-free fn of one argument, which will be passed the intended
 * new state on any state change. If the new state is unacceptable, the
 * validator-fn should return false or throw an Error. If the current state
 * is not acceptable to the new validator, an Error will be thrown and the
 * validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/Volatile");
});

cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 * this means false return values will be included.  f must be free of
 * side-effects.  Returns a stateful transducer when no collection is
 * provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(){
var G__8389 = arguments.length;
switch (G__8389) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__8424 = null;
var G__8424__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8424__1 = (function (result){
var G__8390 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8390) : rf.call(null,G__8390));
});
var G__8424__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
var v = (function (){var G__8391 = i;
var G__8392 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8391,G__8392) : f.call(null,G__8391,G__8392));
})();
if((v == null)){
return result;
} else {
var G__8393 = result;
var G__8394 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8393,G__8394) : rf.call(null,G__8393,G__8394));
}
});
G__8424 = function(result,input){
switch(arguments.length){
case 0:
return G__8424__0.call(this);
case 1:
return G__8424__1.call(this,result);
case 2:
return G__8424__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8424.cljs$core$IFn$_invoke$arity$0 = G__8424__0;
G__8424.cljs$core$IFn$_invoke$arity$1 = G__8424__1;
G__8424.cljs$core$IFn$_invoke$arity$2 = G__8424__2;
return G__8424;
})()
;})(ia))
});
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var keepi = (function cljs$core$keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4404__auto__ = cljs.core.seq(coll__$1);
if(temp__4404__auto__){
var s = temp__4404__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4774__auto___8425 = size;
var i_8426 = (0);
while(true){
if((i_8426 < n__4774__auto___8425)){
var x_8427 = (function (){var G__8419 = (idx + i_8426);
var G__8420 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8426);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8419,G__8420) : f.call(null,G__8419,G__8420));
})();
if((x_8427 == null)){
} else {
cljs.core.chunk_append(b,x_8427);
}

var G__8428 = (i_8426 + (1));
i_8426 = G__8428;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__8421 = idx;
var G__8422 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8421,G__8422) : f.call(null,G__8421,G__8422));
})();
if((x == null)){
return cljs$core$keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});

cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;
/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 * composing predicates return a logical true value against all of its arguments, else it returns
 * false. Note that f is short-circuiting in that it will stop execution on the first
 * argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(){
var G__8440 = arguments.length;
switch (G__8440) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4941__auto__);

}
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$ep1 = null;
var cljs$core$ep1__0 = (function (){
return true;
});
var cljs$core$ep1__1 = (function (x){
return cljs.core.boolean$((function (){var G__8456 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8456) : p.call(null,G__8456));
})());
});
var cljs$core$ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3877__auto__ = (function (){var G__8458 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8458) : p.call(null,G__8458));
})();
if(cljs.core.truth_(and__3877__auto__)){
var G__8459 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8459) : p.call(null,G__8459));
} else {
return and__3877__auto__;
}
})());
});
var cljs$core$ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3877__auto__ = (function (){var G__8461 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8461) : p.call(null,G__8461));
})();
if(cljs.core.truth_(and__3877__auto__)){
var and__3877__auto____$1 = (function (){var G__8463 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8463) : p.call(null,G__8463));
})();
if(cljs.core.truth_(and__3877__auto____$1)){
var G__8464 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8464) : p.call(null,G__8464));
} else {
return and__3877__auto____$1;
}
} else {
return and__3877__auto__;
}
})());
});
var cljs$core$ep1__4 = (function() { 
var G__8626__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__3877__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__3877__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__3877__auto__;
}
})());
};
var G__8626 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8627__i = 0, G__8627__a = new Array(arguments.length -  3);
while (G__8627__i < G__8627__a.length) {G__8627__a[G__8627__i] = arguments[G__8627__i + 3]; ++G__8627__i;}
  args = new cljs.core.IndexedSeq(G__8627__a,0);
} 
return G__8626__delegate.call(this,x,y,z,args);};
G__8626.cljs$lang$maxFixedArity = 3;
G__8626.cljs$lang$applyTo = (function (arglist__8628){
var x = cljs.core.first(arglist__8628);
arglist__8628 = cljs.core.next(arglist__8628);
var y = cljs.core.first(arglist__8628);
arglist__8628 = cljs.core.next(arglist__8628);
var z = cljs.core.first(arglist__8628);
var args = cljs.core.rest(arglist__8628);
return G__8626__delegate(x,y,z,args);
});
G__8626.cljs$core$IFn$_invoke$arity$variadic = G__8626__delegate;
return G__8626;
})()
;
cljs$core$ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep1__0.call(this);
case 1:
return cljs$core$ep1__1.call(this,x);
case 2:
return cljs$core$ep1__2.call(this,x,y);
case 3:
return cljs$core$ep1__3.call(this,x,y,z);
default:
var G__8629 = null;
if (arguments.length > 3) {
var G__8630__i = 0, G__8630__a = new Array(arguments.length -  3);
while (G__8630__i < G__8630__a.length) {G__8630__a[G__8630__i] = arguments[G__8630__i + 3]; ++G__8630__i;}
G__8629 = new cljs.core.IndexedSeq(G__8630__a,0);
}
return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep1.cljs$lang$maxFixedArity = 3;
cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep1;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$ep2 = null;
var cljs$core$ep2__0 = (function (){
return true;
});
var cljs$core$ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__3877__auto__ = (function (){var G__8496 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8496) : p1.call(null,G__8496));
})();
if(cljs.core.truth_(and__3877__auto__)){
var G__8497 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8497) : p2.call(null,G__8497));
} else {
return and__3877__auto__;
}
})());
});
var cljs$core$ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3877__auto__ = (function (){var G__8499 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8499) : p1.call(null,G__8499));
})();
if(cljs.core.truth_(and__3877__auto__)){
var and__3877__auto____$1 = (function (){var G__8501 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8501) : p1.call(null,G__8501));
})();
if(cljs.core.truth_(and__3877__auto____$1)){
var and__3877__auto____$2 = (function (){var G__8503 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8503) : p2.call(null,G__8503));
})();
if(cljs.core.truth_(and__3877__auto____$2)){
var G__8504 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8504) : p2.call(null,G__8504));
} else {
return and__3877__auto____$2;
}
} else {
return and__3877__auto____$1;
}
} else {
return and__3877__auto__;
}
})());
});
var cljs$core$ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3877__auto__ = (function (){var G__8506 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8506) : p1.call(null,G__8506));
})();
if(cljs.core.truth_(and__3877__auto__)){
var and__3877__auto____$1 = (function (){var G__8508 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8508) : p1.call(null,G__8508));
})();
if(cljs.core.truth_(and__3877__auto____$1)){
var and__3877__auto____$2 = (function (){var G__8510 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8510) : p1.call(null,G__8510));
})();
if(cljs.core.truth_(and__3877__auto____$2)){
var and__3877__auto____$3 = (function (){var G__8512 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8512) : p2.call(null,G__8512));
})();
if(cljs.core.truth_(and__3877__auto____$3)){
var and__3877__auto____$4 = (function (){var G__8514 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8514) : p2.call(null,G__8514));
})();
if(cljs.core.truth_(and__3877__auto____$4)){
var G__8515 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8515) : p2.call(null,G__8515));
} else {
return and__3877__auto____$4;
}
} else {
return and__3877__auto____$3;
}
} else {
return and__3877__auto____$2;
}
} else {
return and__3877__auto____$1;
}
} else {
return and__3877__auto__;
}
})());
});
var cljs$core$ep2__4 = (function() { 
var G__8631__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__3877__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__3877__auto__)){
return cljs.core.every_QMARK_(((function (and__3877__auto__){
return (function (p1__8429_SHARP_){
var and__3877__auto____$1 = (function (){var G__8517 = p1__8429_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8517) : p1.call(null,G__8517));
})();
if(cljs.core.truth_(and__3877__auto____$1)){
var G__8518 = p1__8429_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8518) : p2.call(null,G__8518));
} else {
return and__3877__auto____$1;
}
});})(and__3877__auto__))
,args);
} else {
return and__3877__auto__;
}
})());
};
var G__8631 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8632__i = 0, G__8632__a = new Array(arguments.length -  3);
while (G__8632__i < G__8632__a.length) {G__8632__a[G__8632__i] = arguments[G__8632__i + 3]; ++G__8632__i;}
  args = new cljs.core.IndexedSeq(G__8632__a,0);
} 
return G__8631__delegate.call(this,x,y,z,args);};
G__8631.cljs$lang$maxFixedArity = 3;
G__8631.cljs$lang$applyTo = (function (arglist__8633){
var x = cljs.core.first(arglist__8633);
arglist__8633 = cljs.core.next(arglist__8633);
var y = cljs.core.first(arglist__8633);
arglist__8633 = cljs.core.next(arglist__8633);
var z = cljs.core.first(arglist__8633);
var args = cljs.core.rest(arglist__8633);
return G__8631__delegate(x,y,z,args);
});
G__8631.cljs$core$IFn$_invoke$arity$variadic = G__8631__delegate;
return G__8631;
})()
;
cljs$core$ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep2__0.call(this);
case 1:
return cljs$core$ep2__1.call(this,x);
case 2:
return cljs$core$ep2__2.call(this,x,y);
case 3:
return cljs$core$ep2__3.call(this,x,y,z);
default:
var G__8634 = null;
if (arguments.length > 3) {
var G__8635__i = 0, G__8635__a = new Array(arguments.length -  3);
while (G__8635__i < G__8635__a.length) {G__8635__a[G__8635__i] = arguments[G__8635__i + 3]; ++G__8635__i;}
G__8634 = new cljs.core.IndexedSeq(G__8635__a,0);
}
return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep2.cljs$lang$maxFixedArity = 3;
cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep2;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$ep3 = null;
var cljs$core$ep3__0 = (function (){
return true;
});
var cljs$core$ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__3877__auto__ = (function (){var G__8564 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8564) : p1.call(null,G__8564));
})();
if(cljs.core.truth_(and__3877__auto__)){
var and__3877__auto____$1 = (function (){var G__8566 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8566) : p2.call(null,G__8566));
})();
if(cljs.core.truth_(and__3877__auto____$1)){
var G__8567 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8567) : p3.call(null,G__8567));
} else {
return and__3877__auto____$1;
}
} else {
return and__3877__auto__;
}
})());
});
var cljs$core$ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3877__auto__ = (function (){var G__8569 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8569) : p1.call(null,G__8569));
})();
if(cljs.core.truth_(and__3877__auto__)){
var and__3877__auto____$1 = (function (){var G__8571 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8571) : p2.call(null,G__8571));
})();
if(cljs.core.truth_(and__3877__auto____$1)){
var and__3877__auto____$2 = (function (){var G__8573 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8573) : p3.call(null,G__8573));
})();
if(cljs.core.truth_(and__3877__auto____$2)){
var and__3877__auto____$3 = (function (){var G__8575 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8575) : p1.call(null,G__8575));
})();
if(cljs.core.truth_(and__3877__auto____$3)){
var and__3877__auto____$4 = (function (){var G__8577 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8577) : p2.call(null,G__8577));
})();
if(cljs.core.truth_(and__3877__auto____$4)){
var G__8578 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8578) : p3.call(null,G__8578));
} else {
return and__3877__auto____$4;
}
} else {
return and__3877__auto____$3;
}
} else {
return and__3877__auto____$2;
}
} else {
return and__3877__auto____$1;
}
} else {
return and__3877__auto__;
}
})());
});
var cljs$core$ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3877__auto__ = (function (){var G__8580 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8580) : p1.call(null,G__8580));
})();
if(cljs.core.truth_(and__3877__auto__)){
var and__3877__auto____$1 = (function (){var G__8582 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8582) : p2.call(null,G__8582));
})();
if(cljs.core.truth_(and__3877__auto____$1)){
var and__3877__auto____$2 = (function (){var G__8584 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8584) : p3.call(null,G__8584));
})();
if(cljs.core.truth_(and__3877__auto____$2)){
var and__3877__auto____$3 = (function (){var G__8586 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8586) : p1.call(null,G__8586));
})();
if(cljs.core.truth_(and__3877__auto____$3)){
var and__3877__auto____$4 = (function (){var G__8588 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8588) : p2.call(null,G__8588));
})();
if(cljs.core.truth_(and__3877__auto____$4)){
var and__3877__auto____$5 = (function (){var G__8590 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8590) : p3.call(null,G__8590));
})();
if(cljs.core.truth_(and__3877__auto____$5)){
var and__3877__auto____$6 = (function (){var G__8592 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8592) : p1.call(null,G__8592));
})();
if(cljs.core.truth_(and__3877__auto____$6)){
var and__3877__auto____$7 = (function (){var G__8594 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8594) : p2.call(null,G__8594));
})();
if(cljs.core.truth_(and__3877__auto____$7)){
var G__8595 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8595) : p3.call(null,G__8595));
} else {
return and__3877__auto____$7;
}
} else {
return and__3877__auto____$6;
}
} else {
return and__3877__auto____$5;
}
} else {
return and__3877__auto____$4;
}
} else {
return and__3877__auto____$3;
}
} else {
return and__3877__auto____$2;
}
} else {
return and__3877__auto____$1;
}
} else {
return and__3877__auto__;
}
})());
});
var cljs$core$ep3__4 = (function() { 
var G__8636__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__3877__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__3877__auto__)){
return cljs.core.every_QMARK_(((function (and__3877__auto__){
return (function (p1__8430_SHARP_){
var and__3877__auto____$1 = (function (){var G__8597 = p1__8430_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8597) : p1.call(null,G__8597));
})();
if(cljs.core.truth_(and__3877__auto____$1)){
var and__3877__auto____$2 = (function (){var G__8599 = p1__8430_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8599) : p2.call(null,G__8599));
})();
if(cljs.core.truth_(and__3877__auto____$2)){
var G__8600 = p1__8430_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8600) : p3.call(null,G__8600));
} else {
return and__3877__auto____$2;
}
} else {
return and__3877__auto____$1;
}
});})(and__3877__auto__))
,args);
} else {
return and__3877__auto__;
}
})());
};
var G__8636 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8637__i = 0, G__8637__a = new Array(arguments.length -  3);
while (G__8637__i < G__8637__a.length) {G__8637__a[G__8637__i] = arguments[G__8637__i + 3]; ++G__8637__i;}
  args = new cljs.core.IndexedSeq(G__8637__a,0);
} 
return G__8636__delegate.call(this,x,y,z,args);};
G__8636.cljs$lang$maxFixedArity = 3;
G__8636.cljs$lang$applyTo = (function (arglist__8638){
var x = cljs.core.first(arglist__8638);
arglist__8638 = cljs.core.next(arglist__8638);
var y = cljs.core.first(arglist__8638);
arglist__8638 = cljs.core.next(arglist__8638);
var z = cljs.core.first(arglist__8638);
var args = cljs.core.rest(arglist__8638);
return G__8636__delegate(x,y,z,args);
});
G__8636.cljs$core$IFn$_invoke$arity$variadic = G__8636__delegate;
return G__8636;
})()
;
cljs$core$ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep3__0.call(this);
case 1:
return cljs$core$ep3__1.call(this,x);
case 2:
return cljs$core$ep3__2.call(this,x,y);
case 3:
return cljs$core$ep3__3.call(this,x,y,z);
default:
var G__8639 = null;
if (arguments.length > 3) {
var G__8640__i = 0, G__8640__a = new Array(arguments.length -  3);
while (G__8640__i < G__8640__a.length) {G__8640__a[G__8640__i] = arguments[G__8640__i + 3]; ++G__8640__i;}
G__8639 = new cljs.core.IndexedSeq(G__8640__a,0);
}
return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep3.cljs$lang$maxFixedArity = 3;
cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep3;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$epn = null;
var cljs$core$epn__0 = (function (){
return true;
});
var cljs$core$epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__8431_SHARP_){
var G__8616 = x;
return (p1__8431_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8431_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8616) : p1__8431_SHARP_.call(null,G__8616));
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__8432_SHARP_){
var and__3877__auto__ = (function (){var G__8618 = x;
return (p1__8432_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8432_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8618) : p1__8432_SHARP_.call(null,G__8618));
})();
if(cljs.core.truth_(and__3877__auto__)){
var G__8619 = y;
return (p1__8432_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8432_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8619) : p1__8432_SHARP_.call(null,G__8619));
} else {
return and__3877__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__8433_SHARP_){
var and__3877__auto__ = (function (){var G__8621 = x;
return (p1__8433_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8433_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8621) : p1__8433_SHARP_.call(null,G__8621));
})();
if(cljs.core.truth_(and__3877__auto__)){
var and__3877__auto____$1 = (function (){var G__8623 = y;
return (p1__8433_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8433_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8623) : p1__8433_SHARP_.call(null,G__8623));
})();
if(cljs.core.truth_(and__3877__auto____$1)){
var G__8624 = z;
return (p1__8433_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8433_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8624) : p1__8433_SHARP_.call(null,G__8624));
} else {
return and__3877__auto____$1;
}
} else {
return and__3877__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__4 = (function() { 
var G__8641__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__3877__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__3877__auto__)){
return cljs.core.every_QMARK_(((function (and__3877__auto__,ps__$1){
return (function (p1__8434_SHARP_){
return cljs.core.every_QMARK_(p1__8434_SHARP_,args);
});})(and__3877__auto__,ps__$1))
,ps__$1);
} else {
return and__3877__auto__;
}
})());
};
var G__8641 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8642__i = 0, G__8642__a = new Array(arguments.length -  3);
while (G__8642__i < G__8642__a.length) {G__8642__a[G__8642__i] = arguments[G__8642__i + 3]; ++G__8642__i;}
  args = new cljs.core.IndexedSeq(G__8642__a,0);
} 
return G__8641__delegate.call(this,x,y,z,args);};
G__8641.cljs$lang$maxFixedArity = 3;
G__8641.cljs$lang$applyTo = (function (arglist__8643){
var x = cljs.core.first(arglist__8643);
arglist__8643 = cljs.core.next(arglist__8643);
var y = cljs.core.first(arglist__8643);
arglist__8643 = cljs.core.next(arglist__8643);
var z = cljs.core.first(arglist__8643);
var args = cljs.core.rest(arglist__8643);
return G__8641__delegate(x,y,z,args);
});
G__8641.cljs$core$IFn$_invoke$arity$variadic = G__8641__delegate;
return G__8641;
})()
;
cljs$core$epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$epn__0.call(this);
case 1:
return cljs$core$epn__1.call(this,x);
case 2:
return cljs$core$epn__2.call(this,x,y);
case 3:
return cljs$core$epn__3.call(this,x,y,z);
default:
var G__8644 = null;
if (arguments.length > 3) {
var G__8645__i = 0, G__8645__a = new Array(arguments.length -  3);
while (G__8645__i < G__8645__a.length) {G__8645__a[G__8645__i] = arguments[G__8645__i + 3]; ++G__8645__i;}
G__8644 = new cljs.core.IndexedSeq(G__8645__a,0);
}
return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$epn.cljs$lang$maxFixedArity = 3;
cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$epn;
})()
;})(ps__$1))
});

cljs.core.every_pred.cljs$lang$applyTo = (function (seq8435){
var G__8436 = cljs.core.first(seq8435);
var seq8435__$1 = cljs.core.next(seq8435);
var G__8437 = cljs.core.first(seq8435__$1);
var seq8435__$2 = cljs.core.next(seq8435__$1);
var G__8438 = cljs.core.first(seq8435__$2);
var seq8435__$3 = cljs.core.next(seq8435__$2);
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__8436,G__8437,G__8438,seq8435__$3);
});

cljs.core.every_pred.cljs$lang$maxFixedArity = 3;
/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 * returned by one of its composing predicates against any of its arguments, else it returns
 * logical false. Note that f is short-circuiting in that it will stop execution on the first
 * argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(){
var G__8657 = arguments.length;
switch (G__8657) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4941__auto__);

}
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$sp1 = null;
var cljs$core$sp1__0 = (function (){
return null;
});
var cljs$core$sp1__1 = (function (x){
var G__8673 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8673) : p.call(null,G__8673));
});
var cljs$core$sp1__2 = (function (x,y){
var or__3889__auto__ = (function (){var G__8675 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8675) : p.call(null,G__8675));
})();
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
var G__8676 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8676) : p.call(null,G__8676));
}
});
var cljs$core$sp1__3 = (function (x,y,z){
var or__3889__auto__ = (function (){var G__8678 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8678) : p.call(null,G__8678));
})();
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (function (){var G__8680 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8680) : p.call(null,G__8680));
})();
if(cljs.core.truth_(or__3889__auto____$1)){
return or__3889__auto____$1;
} else {
var G__8681 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8681) : p.call(null,G__8681));
}
}
});
var cljs$core$sp1__4 = (function() { 
var G__8843__delegate = function (x,y,z,args){
var or__3889__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__8843 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8844__i = 0, G__8844__a = new Array(arguments.length -  3);
while (G__8844__i < G__8844__a.length) {G__8844__a[G__8844__i] = arguments[G__8844__i + 3]; ++G__8844__i;}
  args = new cljs.core.IndexedSeq(G__8844__a,0);
} 
return G__8843__delegate.call(this,x,y,z,args);};
G__8843.cljs$lang$maxFixedArity = 3;
G__8843.cljs$lang$applyTo = (function (arglist__8845){
var x = cljs.core.first(arglist__8845);
arglist__8845 = cljs.core.next(arglist__8845);
var y = cljs.core.first(arglist__8845);
arglist__8845 = cljs.core.next(arglist__8845);
var z = cljs.core.first(arglist__8845);
var args = cljs.core.rest(arglist__8845);
return G__8843__delegate(x,y,z,args);
});
G__8843.cljs$core$IFn$_invoke$arity$variadic = G__8843__delegate;
return G__8843;
})()
;
cljs$core$sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp1__0.call(this);
case 1:
return cljs$core$sp1__1.call(this,x);
case 2:
return cljs$core$sp1__2.call(this,x,y);
case 3:
return cljs$core$sp1__3.call(this,x,y,z);
default:
var G__8846 = null;
if (arguments.length > 3) {
var G__8847__i = 0, G__8847__a = new Array(arguments.length -  3);
while (G__8847__i < G__8847__a.length) {G__8847__a[G__8847__i] = arguments[G__8847__i + 3]; ++G__8847__i;}
G__8846 = new cljs.core.IndexedSeq(G__8847__a,0);
}
return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp1.cljs$lang$maxFixedArity = 3;
cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp1;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$sp2 = null;
var cljs$core$sp2__0 = (function (){
return null;
});
var cljs$core$sp2__1 = (function (x){
var or__3889__auto__ = (function (){var G__8713 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8713) : p1.call(null,G__8713));
})();
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
var G__8714 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8714) : p2.call(null,G__8714));
}
});
var cljs$core$sp2__2 = (function (x,y){
var or__3889__auto__ = (function (){var G__8716 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8716) : p1.call(null,G__8716));
})();
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (function (){var G__8718 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8718) : p1.call(null,G__8718));
})();
if(cljs.core.truth_(or__3889__auto____$1)){
return or__3889__auto____$1;
} else {
var or__3889__auto____$2 = (function (){var G__8720 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8720) : p2.call(null,G__8720));
})();
if(cljs.core.truth_(or__3889__auto____$2)){
return or__3889__auto____$2;
} else {
var G__8721 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8721) : p2.call(null,G__8721));
}
}
}
});
var cljs$core$sp2__3 = (function (x,y,z){
var or__3889__auto__ = (function (){var G__8723 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8723) : p1.call(null,G__8723));
})();
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (function (){var G__8725 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8725) : p1.call(null,G__8725));
})();
if(cljs.core.truth_(or__3889__auto____$1)){
return or__3889__auto____$1;
} else {
var or__3889__auto____$2 = (function (){var G__8727 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8727) : p1.call(null,G__8727));
})();
if(cljs.core.truth_(or__3889__auto____$2)){
return or__3889__auto____$2;
} else {
var or__3889__auto____$3 = (function (){var G__8729 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8729) : p2.call(null,G__8729));
})();
if(cljs.core.truth_(or__3889__auto____$3)){
return or__3889__auto____$3;
} else {
var or__3889__auto____$4 = (function (){var G__8731 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8731) : p2.call(null,G__8731));
})();
if(cljs.core.truth_(or__3889__auto____$4)){
return or__3889__auto____$4;
} else {
var G__8732 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8732) : p2.call(null,G__8732));
}
}
}
}
}
});
var cljs$core$sp2__4 = (function() { 
var G__8848__delegate = function (x,y,z,args){
var or__3889__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return cljs.core.some(((function (or__3889__auto__){
return (function (p1__8646_SHARP_){
var or__3889__auto____$1 = (function (){var G__8734 = p1__8646_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8734) : p1.call(null,G__8734));
})();
if(cljs.core.truth_(or__3889__auto____$1)){
return or__3889__auto____$1;
} else {
var G__8735 = p1__8646_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8735) : p2.call(null,G__8735));
}
});})(or__3889__auto__))
,args);
}
};
var G__8848 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8849__i = 0, G__8849__a = new Array(arguments.length -  3);
while (G__8849__i < G__8849__a.length) {G__8849__a[G__8849__i] = arguments[G__8849__i + 3]; ++G__8849__i;}
  args = new cljs.core.IndexedSeq(G__8849__a,0);
} 
return G__8848__delegate.call(this,x,y,z,args);};
G__8848.cljs$lang$maxFixedArity = 3;
G__8848.cljs$lang$applyTo = (function (arglist__8850){
var x = cljs.core.first(arglist__8850);
arglist__8850 = cljs.core.next(arglist__8850);
var y = cljs.core.first(arglist__8850);
arglist__8850 = cljs.core.next(arglist__8850);
var z = cljs.core.first(arglist__8850);
var args = cljs.core.rest(arglist__8850);
return G__8848__delegate(x,y,z,args);
});
G__8848.cljs$core$IFn$_invoke$arity$variadic = G__8848__delegate;
return G__8848;
})()
;
cljs$core$sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp2__0.call(this);
case 1:
return cljs$core$sp2__1.call(this,x);
case 2:
return cljs$core$sp2__2.call(this,x,y);
case 3:
return cljs$core$sp2__3.call(this,x,y,z);
default:
var G__8851 = null;
if (arguments.length > 3) {
var G__8852__i = 0, G__8852__a = new Array(arguments.length -  3);
while (G__8852__i < G__8852__a.length) {G__8852__a[G__8852__i] = arguments[G__8852__i + 3]; ++G__8852__i;}
G__8851 = new cljs.core.IndexedSeq(G__8852__a,0);
}
return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp2.cljs$lang$maxFixedArity = 3;
cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp2;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$sp3 = null;
var cljs$core$sp3__0 = (function (){
return null;
});
var cljs$core$sp3__1 = (function (x){
var or__3889__auto__ = (function (){var G__8781 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8781) : p1.call(null,G__8781));
})();
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (function (){var G__8783 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8783) : p2.call(null,G__8783));
})();
if(cljs.core.truth_(or__3889__auto____$1)){
return or__3889__auto____$1;
} else {
var G__8784 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8784) : p3.call(null,G__8784));
}
}
});
var cljs$core$sp3__2 = (function (x,y){
var or__3889__auto__ = (function (){var G__8786 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8786) : p1.call(null,G__8786));
})();
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (function (){var G__8788 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8788) : p2.call(null,G__8788));
})();
if(cljs.core.truth_(or__3889__auto____$1)){
return or__3889__auto____$1;
} else {
var or__3889__auto____$2 = (function (){var G__8790 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8790) : p3.call(null,G__8790));
})();
if(cljs.core.truth_(or__3889__auto____$2)){
return or__3889__auto____$2;
} else {
var or__3889__auto____$3 = (function (){var G__8792 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8792) : p1.call(null,G__8792));
})();
if(cljs.core.truth_(or__3889__auto____$3)){
return or__3889__auto____$3;
} else {
var or__3889__auto____$4 = (function (){var G__8794 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8794) : p2.call(null,G__8794));
})();
if(cljs.core.truth_(or__3889__auto____$4)){
return or__3889__auto____$4;
} else {
var G__8795 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8795) : p3.call(null,G__8795));
}
}
}
}
}
});
var cljs$core$sp3__3 = (function (x,y,z){
var or__3889__auto__ = (function (){var G__8797 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8797) : p1.call(null,G__8797));
})();
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (function (){var G__8799 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8799) : p2.call(null,G__8799));
})();
if(cljs.core.truth_(or__3889__auto____$1)){
return or__3889__auto____$1;
} else {
var or__3889__auto____$2 = (function (){var G__8801 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8801) : p3.call(null,G__8801));
})();
if(cljs.core.truth_(or__3889__auto____$2)){
return or__3889__auto____$2;
} else {
var or__3889__auto____$3 = (function (){var G__8803 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8803) : p1.call(null,G__8803));
})();
if(cljs.core.truth_(or__3889__auto____$3)){
return or__3889__auto____$3;
} else {
var or__3889__auto____$4 = (function (){var G__8805 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8805) : p2.call(null,G__8805));
})();
if(cljs.core.truth_(or__3889__auto____$4)){
return or__3889__auto____$4;
} else {
var or__3889__auto____$5 = (function (){var G__8807 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8807) : p3.call(null,G__8807));
})();
if(cljs.core.truth_(or__3889__auto____$5)){
return or__3889__auto____$5;
} else {
var or__3889__auto____$6 = (function (){var G__8809 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8809) : p1.call(null,G__8809));
})();
if(cljs.core.truth_(or__3889__auto____$6)){
return or__3889__auto____$6;
} else {
var or__3889__auto____$7 = (function (){var G__8811 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8811) : p2.call(null,G__8811));
})();
if(cljs.core.truth_(or__3889__auto____$7)){
return or__3889__auto____$7;
} else {
var G__8812 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8812) : p3.call(null,G__8812));
}
}
}
}
}
}
}
}
});
var cljs$core$sp3__4 = (function() { 
var G__8853__delegate = function (x,y,z,args){
var or__3889__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return cljs.core.some(((function (or__3889__auto__){
return (function (p1__8647_SHARP_){
var or__3889__auto____$1 = (function (){var G__8814 = p1__8647_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8814) : p1.call(null,G__8814));
})();
if(cljs.core.truth_(or__3889__auto____$1)){
return or__3889__auto____$1;
} else {
var or__3889__auto____$2 = (function (){var G__8816 = p1__8647_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8816) : p2.call(null,G__8816));
})();
if(cljs.core.truth_(or__3889__auto____$2)){
return or__3889__auto____$2;
} else {
var G__8817 = p1__8647_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8817) : p3.call(null,G__8817));
}
}
});})(or__3889__auto__))
,args);
}
};
var G__8853 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8854__i = 0, G__8854__a = new Array(arguments.length -  3);
while (G__8854__i < G__8854__a.length) {G__8854__a[G__8854__i] = arguments[G__8854__i + 3]; ++G__8854__i;}
  args = new cljs.core.IndexedSeq(G__8854__a,0);
} 
return G__8853__delegate.call(this,x,y,z,args);};
G__8853.cljs$lang$maxFixedArity = 3;
G__8853.cljs$lang$applyTo = (function (arglist__8855){
var x = cljs.core.first(arglist__8855);
arglist__8855 = cljs.core.next(arglist__8855);
var y = cljs.core.first(arglist__8855);
arglist__8855 = cljs.core.next(arglist__8855);
var z = cljs.core.first(arglist__8855);
var args = cljs.core.rest(arglist__8855);
return G__8853__delegate(x,y,z,args);
});
G__8853.cljs$core$IFn$_invoke$arity$variadic = G__8853__delegate;
return G__8853;
})()
;
cljs$core$sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp3__0.call(this);
case 1:
return cljs$core$sp3__1.call(this,x);
case 2:
return cljs$core$sp3__2.call(this,x,y);
case 3:
return cljs$core$sp3__3.call(this,x,y,z);
default:
var G__8856 = null;
if (arguments.length > 3) {
var G__8857__i = 0, G__8857__a = new Array(arguments.length -  3);
while (G__8857__i < G__8857__a.length) {G__8857__a[G__8857__i] = arguments[G__8857__i + 3]; ++G__8857__i;}
G__8856 = new cljs.core.IndexedSeq(G__8857__a,0);
}
return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp3.cljs$lang$maxFixedArity = 3;
cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp3;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$spn = null;
var cljs$core$spn__0 = (function (){
return null;
});
var cljs$core$spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__8648_SHARP_){
var G__8833 = x;
return (p1__8648_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8648_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8833) : p1__8648_SHARP_.call(null,G__8833));
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__8649_SHARP_){
var or__3889__auto__ = (function (){var G__8835 = x;
return (p1__8649_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8649_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8835) : p1__8649_SHARP_.call(null,G__8835));
})();
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
var G__8836 = y;
return (p1__8649_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8649_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8836) : p1__8649_SHARP_.call(null,G__8836));
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__8650_SHARP_){
var or__3889__auto__ = (function (){var G__8838 = x;
return (p1__8650_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8650_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8838) : p1__8650_SHARP_.call(null,G__8838));
})();
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (function (){var G__8840 = y;
return (p1__8650_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8650_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8840) : p1__8650_SHARP_.call(null,G__8840));
})();
if(cljs.core.truth_(or__3889__auto____$1)){
return or__3889__auto____$1;
} else {
var G__8841 = z;
return (p1__8650_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8650_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8841) : p1__8650_SHARP_.call(null,G__8841));
}
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__4 = (function() { 
var G__8858__delegate = function (x,y,z,args){
var or__3889__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return cljs.core.some(((function (or__3889__auto__,ps__$1){
return (function (p1__8651_SHARP_){
return cljs.core.some(p1__8651_SHARP_,args);
});})(or__3889__auto__,ps__$1))
,ps__$1);
}
};
var G__8858 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8859__i = 0, G__8859__a = new Array(arguments.length -  3);
while (G__8859__i < G__8859__a.length) {G__8859__a[G__8859__i] = arguments[G__8859__i + 3]; ++G__8859__i;}
  args = new cljs.core.IndexedSeq(G__8859__a,0);
} 
return G__8858__delegate.call(this,x,y,z,args);};
G__8858.cljs$lang$maxFixedArity = 3;
G__8858.cljs$lang$applyTo = (function (arglist__8860){
var x = cljs.core.first(arglist__8860);
arglist__8860 = cljs.core.next(arglist__8860);
var y = cljs.core.first(arglist__8860);
arglist__8860 = cljs.core.next(arglist__8860);
var z = cljs.core.first(arglist__8860);
var args = cljs.core.rest(arglist__8860);
return G__8858__delegate(x,y,z,args);
});
G__8858.cljs$core$IFn$_invoke$arity$variadic = G__8858__delegate;
return G__8858;
})()
;
cljs$core$spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$spn__0.call(this);
case 1:
return cljs$core$spn__1.call(this,x);
case 2:
return cljs$core$spn__2.call(this,x,y);
case 3:
return cljs$core$spn__3.call(this,x,y,z);
default:
var G__8861 = null;
if (arguments.length > 3) {
var G__8862__i = 0, G__8862__a = new Array(arguments.length -  3);
while (G__8862__i < G__8862__a.length) {G__8862__a[G__8862__i] = arguments[G__8862__i + 3]; ++G__8862__i;}
G__8861 = new cljs.core.IndexedSeq(G__8862__a,0);
}
return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$spn.cljs$lang$maxFixedArity = 3;
cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$spn;
})()
;})(ps__$1))
});

cljs.core.some_fn.cljs$lang$applyTo = (function (seq8652){
var G__8653 = cljs.core.first(seq8652);
var seq8652__$1 = cljs.core.next(seq8652);
var G__8654 = cljs.core.first(seq8652__$1);
var seq8652__$2 = cljs.core.next(seq8652__$1);
var G__8655 = cljs.core.first(seq8652__$2);
var seq8652__$3 = cljs.core.next(seq8652__$2);
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__8653,G__8654,G__8655,seq8652__$3);
});

cljs.core.some_fn.cljs$lang$maxFixedArity = 3;
/**
 * Returns a lazy sequence consisting of the result of applying f to
 * the set of first items of each coll, followed by applying f to the
 * set of second items in each coll, until any one of the colls is
 * exhausted.  Any remaining items in other colls are ignored. Function
 * f should accept number-of-colls arguments. Returns a transducer when
 * no collection is provided.
 */
cljs.core.map = (function cljs$core$map(){
var G__8870 = arguments.length;
switch (G__8870) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4941__auto__);

}
});

cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__8886 = null;
var G__8886__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8886__1 = (function (result){
var G__8871 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8871) : rf.call(null,G__8871));
});
var G__8886__2 = (function (result,input){
var G__8872 = result;
var G__8873 = (function (){var G__8874 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8874) : f.call(null,G__8874));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8872,G__8873) : rf.call(null,G__8872,G__8873));
});
var G__8886__3 = (function() { 
var G__8887__delegate = function (result,input,inputs){
var G__8875 = result;
var G__8876 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8875,G__8876) : rf.call(null,G__8875,G__8876));
};
var G__8887 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__8888__i = 0, G__8888__a = new Array(arguments.length -  2);
while (G__8888__i < G__8888__a.length) {G__8888__a[G__8888__i] = arguments[G__8888__i + 2]; ++G__8888__i;}
  inputs = new cljs.core.IndexedSeq(G__8888__a,0);
} 
return G__8887__delegate.call(this,result,input,inputs);};
G__8887.cljs$lang$maxFixedArity = 2;
G__8887.cljs$lang$applyTo = (function (arglist__8889){
var result = cljs.core.first(arglist__8889);
arglist__8889 = cljs.core.next(arglist__8889);
var input = cljs.core.first(arglist__8889);
var inputs = cljs.core.rest(arglist__8889);
return G__8887__delegate(result,input,inputs);
});
G__8887.cljs$core$IFn$_invoke$arity$variadic = G__8887__delegate;
return G__8887;
})()
;
G__8886 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__8886__0.call(this);
case 1:
return G__8886__1.call(this,result);
case 2:
return G__8886__2.call(this,result,input);
default:
var G__8890 = null;
if (arguments.length > 2) {
var G__8891__i = 0, G__8891__a = new Array(arguments.length -  2);
while (G__8891__i < G__8891__a.length) {G__8891__a[G__8891__i] = arguments[G__8891__i + 2]; ++G__8891__i;}
G__8890 = new cljs.core.IndexedSeq(G__8891__a,0);
}
return G__8886__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__8890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8886.cljs$lang$maxFixedArity = 2;
G__8886.cljs$lang$applyTo = G__8886__3.cljs$lang$applyTo;
G__8886.cljs$core$IFn$_invoke$arity$0 = G__8886__0;
G__8886.cljs$core$IFn$_invoke$arity$1 = G__8886__1;
G__8886.cljs$core$IFn$_invoke$arity$2 = G__8886__2;
G__8886.cljs$core$IFn$_invoke$arity$variadic = G__8886__3.cljs$core$IFn$_invoke$arity$variadic;
return G__8886;
})()
});
});

cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4404__auto__ = cljs.core.seq(coll);
if(temp__4404__auto__){
var s = temp__4404__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4774__auto___8892 = size;
var i_8893 = (0);
while(true){
if((i_8893 < n__4774__auto___8892)){
cljs.core.chunk_append(b,(function (){var G__8877 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8893);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8877) : f.call(null,G__8877));
})());

var G__8894 = (i_8893 + (1));
i_8893 = G__8894;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__8878 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8878) : f.call(null,G__8878));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons((function (){var G__8879 = cljs.core.first(s1);
var G__8880 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8879,G__8880) : f.call(null,G__8879,G__8880));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if((s1) && (s2) && (s3)){
return cljs.core.cons((function (){var G__8881 = cljs.core.first(s1);
var G__8882 = cljs.core.first(s2);
var G__8883 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8881,G__8882,G__8883) : f.call(null,G__8881,G__8882,G__8883));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
var step = (function cljs$core$step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__8863_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__8863_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.array_seq([c2,c1], 0))));
});

cljs.core.map.cljs$lang$applyTo = (function (seq8864){
var G__8865 = cljs.core.first(seq8864);
var seq8864__$1 = cljs.core.next(seq8864);
var G__8866 = cljs.core.first(seq8864__$1);
var seq8864__$2 = cljs.core.next(seq8864__$1);
var G__8867 = cljs.core.first(seq8864__$2);
var seq8864__$3 = cljs.core.next(seq8864__$2);
var G__8868 = cljs.core.first(seq8864__$3);
var seq8864__$4 = cljs.core.next(seq8864__$3);
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__8865,G__8866,G__8867,G__8868,seq8864__$4);
});

cljs.core.map.cljs$lang$maxFixedArity = 4;
/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 * there are fewer than n.  Returns a stateful transducer when
 * no collection is provided.
 */
cljs.core.take = (function cljs$core$take(){
var G__8896 = arguments.length;
switch (G__8896) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__8901 = null;
var G__8901__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8901__1 = (function (result){
var G__8897 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8897) : rf.call(null,G__8897));
});
var G__8901__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));
var result__$1 = (((n__$1 > (0)))?(function (){var G__8898 = result;
var G__8899 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8898,G__8899) : rf.call(null,G__8898,G__8899));
})():result);
if(!((nn > (0)))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__8901 = function(result,input){
switch(arguments.length){
case 0:
return G__8901__0.call(this);
case 1:
return G__8901__1.call(this,result);
case 2:
return G__8901__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8901.cljs$core$IFn$_invoke$arity$0 = G__8901__0;
G__8901.cljs$core$IFn$_invoke$arity$1 = G__8901__1;
G__8901.cljs$core$IFn$_invoke$arity$2 = G__8901__2;
return G__8901;
})()
;})(na))
});
});

cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__4404__auto__ = cljs.core.seq(coll);
if(temp__4404__auto__){
var s = temp__4404__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of all but the first n items in coll.
 * Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(){
var G__8903 = arguments.length;
switch (G__8903) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__8908 = null;
var G__8908__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8908__1 = (function (result){
var G__8904 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8904) : rf.call(null,G__8904));
});
var G__8908__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));

if((n__$1 > (0))){
return result;
} else {
var G__8905 = result;
var G__8906 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8905,G__8906) : rf.call(null,G__8905,G__8906));
}
});
G__8908 = function(result,input){
switch(arguments.length){
case 0:
return G__8908__0.call(this);
case 1:
return G__8908__1.call(this,result);
case 2:
return G__8908__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8908.cljs$core$IFn$_invoke$arity$0 = G__8908__0;
G__8908.cljs$core$IFn$_invoke$arity$1 = G__8908__1;
G__8908.cljs$core$IFn$_invoke$arity$2 = G__8908__2;
return G__8908;
})()
;})(na))
});
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(((n__$1 > (0))) && (s)){
var G__8909 = (n__$1 - (1));
var G__8910 = cljs.core.rest(s);
n__$1 = G__8909;
coll__$1 = G__8910;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});

cljs.core.drop.cljs$lang$maxFixedArity = 2;
/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(){
var G__8912 = arguments.length;
switch (G__8912) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});

cljs.core.drop_last.cljs$lang$maxFixedArity = 2;
/**
 * Returns a seq of the last n items in coll.  Depending on the type
 * of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__8914 = cljs.core.next(s);
var G__8915 = cljs.core.next(lead);
s = G__8914;
lead = G__8915;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 * first item for which (pred item) returns logical false.  Returns a
 * stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(){
var G__8917 = arguments.length;
switch (G__8917) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__8925 = null;
var G__8925__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8925__1 = (function (result){
var G__8918 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8918) : rf.call(null,G__8918));
});
var G__8925__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__3877__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__3877__auto__)){
var G__8919 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8919) : pred.call(null,G__8919));
} else {
return and__3877__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

var G__8920 = result;
var G__8921 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8920,G__8921) : rf.call(null,G__8920,G__8921));
}
});
G__8925 = function(result,input){
switch(arguments.length){
case 0:
return G__8925__0.call(this);
case 1:
return G__8925__1.call(this,result);
case 2:
return G__8925__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8925.cljs$core$IFn$_invoke$arity$0 = G__8925__0;
G__8925.cljs$core$IFn$_invoke$arity$1 = G__8925__1;
G__8925.cljs$core$IFn$_invoke$arity$2 = G__8925__2;
return G__8925;
})()
;})(da))
});
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__3877__auto__ = s;
if(and__3877__auto__){
var G__8923 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__8923) : pred__$1.call(null,G__8923));
} else {
return and__3877__auto__;
}
})())){
var G__8926 = pred__$1;
var G__8927 = cljs.core.rest(s);
pred__$1 = G__8926;
coll__$1 = G__8927;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});

cljs.core.drop_while.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4404__auto__ = cljs.core.seq(coll);
if(temp__4404__auto__){
var s = temp__4404__auto__;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,cljs$core$cycle(s));
} else {
return null;
}
}),null,null));
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});
/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(){
var G__8930 = arguments.length;
switch (G__8930) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(x,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
}),null,null));
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function (n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});

cljs.core.repeat.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 * returns an infinite (or length n if supplied) lazy sequence of calls
 * to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(){
var G__8933 = arguments.length;
switch (G__8933) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});

cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return cljs.core.cons(x,(new cljs.core.LazySeq(null,(function (){
return cljs$core$iterate(f,(function (){var G__8938 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8938) : f.call(null,G__8938));
})());
}),null,null)));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(){
var G__8943 = arguments.length;
switch (G__8943) {
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4941__auto__);

}
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$lang$applyTo = (function (seq8939){
var G__8940 = cljs.core.first(seq8939);
var seq8939__$1 = cljs.core.next(seq8939);
var G__8941 = cljs.core.first(seq8939__$1);
var seq8939__$2 = cljs.core.next(seq8939__$1);
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__8940,G__8941,seq8939__$2);
});

cljs.core.interleave.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy seq of the elements of coll separated by sep
 */
cljs.core.interpose = (function cljs$core$interpose(){
var G__8946 = arguments.length;
switch (G__8946) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__8955 = null;
var G__8955__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8955__1 = (function (result){
var G__8947 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8947) : rf.call(null,G__8947));
});
var G__8955__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (function (){var G__8948 = result;
var G__8949 = sep;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8948,G__8949) : rf.call(null,G__8948,G__8949));
})();
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
var G__8950 = sepr;
var G__8951 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8950,G__8951) : rf.call(null,G__8950,G__8951));
}
} else {
cljs.core.vreset_BANG_(started,true);

var G__8952 = result;
var G__8953 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8952,G__8953) : rf.call(null,G__8952,G__8953));
}
});
G__8955 = function(result,input){
switch(arguments.length){
case 0:
return G__8955__0.call(this);
case 1:
return G__8955__1.call(this,result);
case 2:
return G__8955__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8955.cljs$core$IFn$_invoke$arity$0 = G__8955__0;
G__8955.cljs$core$IFn$_invoke$arity$1 = G__8955__1;
G__8955.cljs$core$IFn$_invoke$arity$2 = G__8955__2;
return G__8955;
})()
;})(started))
});
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});

cljs.core.interpose.cljs$lang$maxFixedArity = 2;
/**
 * Take a collection of collections, and return a lazy seq
 * of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4402__auto__ = cljs.core.seq(coll);
if(temp__4402__auto__){
var coll__$1 = temp__4402__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 * to f and colls.  Thus function f should return a collection. Returns
 * a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(){
var G__8967 = arguments.length;
switch (G__8967) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,1),(0)));
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4941__auto__);

}
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
});

cljs.core.mapcat.cljs$lang$applyTo = (function (seq8964){
var G__8965 = cljs.core.first(seq8964);
var seq8964__$1 = cljs.core.next(seq8964);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__8965,seq8964__$1);
});

cljs.core.mapcat.cljs$lang$maxFixedArity = 1;
/**
 * Returns a lazy sequence of the items in coll for which
 * (pred item) returns true. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(){
var G__8970 = arguments.length;
switch (G__8970) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__8978 = null;
var G__8978__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8978__1 = (function (result){
var G__8971 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8971) : rf.call(null,G__8971));
});
var G__8978__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__8972 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8972) : pred.call(null,G__8972));
})())){
var G__8973 = result;
var G__8974 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8973,G__8974) : rf.call(null,G__8973,G__8974));
} else {
return result;
}
});
G__8978 = function(result,input){
switch(arguments.length){
case 0:
return G__8978__0.call(this);
case 1:
return G__8978__1.call(this,result);
case 2:
return G__8978__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8978.cljs$core$IFn$_invoke$arity$0 = G__8978__0;
G__8978.cljs$core$IFn$_invoke$arity$1 = G__8978__1;
G__8978.cljs$core$IFn$_invoke$arity$2 = G__8978__2;
return G__8978;
})()
});
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4404__auto__ = cljs.core.seq(coll);
if(temp__4404__auto__){
var s = temp__4404__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4774__auto___8979 = size;
var i_8980 = (0);
while(true){
if((i_8980 < n__4774__auto___8979)){
if(cljs.core.truth_((function (){var G__8975 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8980);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8975) : pred.call(null,G__8975));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8980));
} else {
}

var G__8981 = (i_8980 + (1));
i_8980 = G__8981;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((function (){var G__8976 = f;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8976) : pred.call(null,G__8976));
})())){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.filter.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the items in coll for which
 * (pred item) returns false. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(){
var G__8983 = arguments.length;
switch (G__8983) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});

cljs.core.remove.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 * branch? must be a fn of one arg that returns true if passed a node
 * that can have children (but may not).  children must be a fn of one
 * arg that returns a sequence of the children. Will only be called on
 * nodes for which branch? returns true. Root is the root node of the
 * tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((function (){var G__8991 = node;
return (branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(G__8991) : branch_QMARK_.call(null,G__8991));
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.array_seq([(function (){var G__8992 = node;
return (children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(G__8992) : children.call(null,G__8992));
})()], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 * etc.) and returns their contents as a single, flat sequence.
 * (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__8993_SHARP_){
return !(cljs.core.sequential_QMARK_(p1__8993_SHARP_));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 * from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(){
var G__8995 = arguments.length;
switch (G__8995) {
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
if(!((to == null))){
if((function (){var G__8996 = to;
if(G__8996){
var bit__4556__auto__ = (G__8996.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4556__auto__) || (G__8996.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function (to,xform,from){
if((function (){var G__8997 = to;
if(G__8997){
var bit__4556__auto__ = (G__8997.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4556__auto__) || (G__8997.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});

cljs.core.into.cljs$lang$maxFixedArity = 3;
/**
 * Returns a vector consisting of the result of applying f to the
 * set of first items of each coll, followed by applying f to the set
 * of second items in each coll, until any one of the colls is
 * exhausted.  Any remaining items in other colls are ignored. Function
 * f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(){
var G__9005 = arguments.length;
switch (G__9005) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4941__auto__);

}
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(function (){var G__9006 = o;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9006) : f.call(null,G__9006));
})());
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.array_seq([colls], 0)));
});

cljs.core.mapv.cljs$lang$applyTo = (function (seq8999){
var G__9000 = cljs.core.first(seq8999);
var seq8999__$1 = cljs.core.next(seq8999);
var G__9001 = cljs.core.first(seq8999__$1);
var seq8999__$2 = cljs.core.next(seq8999__$1);
var G__9002 = cljs.core.first(seq8999__$2);
var seq8999__$3 = cljs.core.next(seq8999__$2);
var G__9003 = cljs.core.first(seq8999__$3);
var seq8999__$4 = cljs.core.next(seq8999__$3);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__9000,G__9001,G__9002,G__9003,seq8999__$4);
});

cljs.core.mapv.cljs$lang$maxFixedArity = 4;
/**
 * Returns a vector of the items in coll for which
 * (pred item) returns true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((function (){var G__9009 = o;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9009) : pred.call(null,G__9009));
})())){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 * apart. If step is not supplied, defaults to n, i.e. the partitions
 * do not overlap. If a pad collection is supplied, use its elements as
 * necessary to complete last partition up to n items. In case there are
 * not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(){
var G__9011 = arguments.length;
switch (G__9011) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4404__auto__ = cljs.core.seq(coll);
if(temp__4404__auto__){
var s = temp__4404__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4404__auto__ = cljs.core.seq(coll);
if(temp__4404__auto__){
var s = temp__4404__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)));
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$lang$maxFixedArity = 4;
/**
 * Returns the value in a nested associative structure,
 * where ks is a sequence of keys. Returns nil if the key is not present,
 * or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(){
var G__9014 = arguments.length;
switch (G__9014) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function (m,ks){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(m,ks,null);
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if(ks__$1){
if(!((function (){var G__9015 = m__$1;
if(G__9015){
var bit__4563__auto__ = (G__9015.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4563__auto__) || (G__9015.cljs$core$ILookup$)){
return true;
} else {
if((!G__9015.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__9015);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__9015);
}
})())){
return not_found;
} else {
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__9017 = sentinel;
var G__9018 = m__$2;
var G__9019 = cljs.core.next(ks__$1);
sentinel = G__9017;
m__$1 = G__9018;
ks__$1 = G__9019;
continue;
}
}
} else {
return m__$1;
}
break;
}
});

cljs.core.get_in.cljs$lang$maxFixedArity = 3;
/**
 * Associates a value in a nested associative structure, where ks is a
 * sequence of keys and v is the new value and returns a new nested structure.
 * If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__9020,v){
var vec__9025 = p__9020;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9025,(0),null);
var ks = cljs.core.nthnext(vec__9025,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,v));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 * sequence of keys and f is a function that will take the old value
 * and any supplied args and return the new value, and returns a new
 * nested structure.  If any levels do not exist, hash-maps will be
 * created.
 */
cljs.core.update_in = (function cljs$core$update_in(){
var G__9034 = arguments.length;
switch (G__9034) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,6),(0)));
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4941__auto__);

}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function (m,p__9035,f){
var vec__9036 = p__9035;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9036,(0),null);
var ks = cljs.core.nthnext(vec__9036,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9037 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9037) : f.call(null,G__9037));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function (m,p__9038,f,a){
var vec__9039 = p__9038;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9039,(0),null);
var ks = cljs.core.nthnext(vec__9039,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9040 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9041 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9040,G__9041) : f.call(null,G__9040,G__9041));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function (m,p__9042,f,a,b){
var vec__9043 = p__9042;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9043,(0),null);
var ks = cljs.core.nthnext(vec__9043,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9044 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9045 = a;
var G__9046 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9044,G__9045,G__9046) : f.call(null,G__9044,G__9045,G__9046));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function (m,p__9047,f,a,b,c){
var vec__9048 = p__9047;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9048,(0),null);
var ks = cljs.core.nthnext(vec__9048,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9049 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9050 = a;
var G__9051 = b;
var G__9052 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9049,G__9050,G__9051,G__9052) : f.call(null,G__9049,G__9050,G__9051,G__9052));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__9053,f,a,b,c,args){
var vec__9054 = p__9053;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9054,(0),null);
var ks = cljs.core.nthnext(vec__9054,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.array_seq([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.array_seq([args], 0)));
}
});

cljs.core.update_in.cljs$lang$applyTo = (function (seq9026){
var G__9027 = cljs.core.first(seq9026);
var seq9026__$1 = cljs.core.next(seq9026);
var G__9028 = cljs.core.first(seq9026__$1);
var seq9026__$2 = cljs.core.next(seq9026__$1);
var G__9029 = cljs.core.first(seq9026__$2);
var seq9026__$3 = cljs.core.next(seq9026__$2);
var G__9030 = cljs.core.first(seq9026__$3);
var seq9026__$4 = cljs.core.next(seq9026__$3);
var G__9031 = cljs.core.first(seq9026__$4);
var seq9026__$5 = cljs.core.next(seq9026__$4);
var G__9032 = cljs.core.first(seq9026__$5);
var seq9026__$6 = cljs.core.next(seq9026__$5);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__9027,G__9028,G__9029,G__9030,G__9031,G__9032,seq9026__$6);
});

cljs.core.update_in.cljs$lang$maxFixedArity = 6;
/**
 * 'Updates' a value in an associative structure, where k is a
 * key and f is a function that will take the old value
 * and any supplied args and return the new value, and returns a new
 * structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(){
var G__9064 = arguments.length;
switch (G__9064) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,6),(0)));
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4941__auto__);

}
});

cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9065 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9065) : f.call(null,G__9065));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9066 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9067 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9066,G__9067) : f.call(null,G__9066,G__9067));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9068 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9069 = x;
var G__9070 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9068,G__9069,G__9070) : f.call(null,G__9068,G__9069,G__9070));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9071 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9072 = x;
var G__9073 = y;
var G__9074 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9071,G__9072,G__9073,G__9074) : f.call(null,G__9071,G__9072,G__9073,G__9074));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.array_seq([more], 0)));
});

cljs.core.update.cljs$lang$applyTo = (function (seq9056){
var G__9057 = cljs.core.first(seq9056);
var seq9056__$1 = cljs.core.next(seq9056);
var G__9058 = cljs.core.first(seq9056__$1);
var seq9056__$2 = cljs.core.next(seq9056__$1);
var G__9059 = cljs.core.first(seq9056__$2);
var seq9056__$3 = cljs.core.next(seq9056__$2);
var G__9060 = cljs.core.first(seq9056__$3);
var seq9056__$4 = cljs.core.next(seq9056__$3);
var G__9061 = cljs.core.first(seq9056__$4);
var seq9056__$5 = cljs.core.next(seq9056__$4);
var G__9062 = cljs.core.first(seq9056__$5);
var seq9056__$6 = cljs.core.next(seq9056__$5);
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__9057,G__9058,G__9059,G__9060,G__9061,G__9062,seq9056__$6);
});

cljs.core.update.cljs$lang$maxFixedArity = 6;

/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/VectorNode");
});

cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__9076 = (ll - (5));
var G__9077 = r;
ll = G__9076;
ret = G__9077;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if(!((child == null))){
var node_to_insert = cljs$core$push_tail(pv,(level - (5)),child,tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in vector of length "),cljs.core.str(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__9082 = cljs.core.pv_aget(node,(0));
var G__9083 = (level - (5));
node = G__9082;
level = G__9083;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__9084 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__9085 = (level - (5));
node = G__9084;
level = G__9085;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if((((0) <= i)) && ((i < pv.cnt))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,cljs$core$do_assoc(pv,(level - (5)),cljs.core.pv_aget(node,subidx),i,val));

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$pop_tail(pv,(level - (5)),cljs.core.pv_aget(node,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
})
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/RangedIterator");
});

cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});







/**
* @constructor
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__9095 = init__$2;
var G__9096 = (j + i);
var G__9097 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9095,G__9096,G__9097) : f.call(null,G__9095,G__9096,G__9097));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__9108 = (j + (1));
var G__9109 = init__$3;
j = G__9108;
init__$2 = G__9109;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9098 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9098) : cljs.core.deref.call(null,G__9098));
} else {
var G__9110 = (i + len);
var G__9111 = init__$2;
i = G__9110;
init__$1 = G__9111;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return cljs.core._conj(coll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds  [0,"),cljs.core.str(self__.cnt),cljs.core.str("]")].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(0));
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(1));
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = cljs.core._iterator(coll__$1);
var you_iter = cljs.core._iterator(other);
while(true){
if(cljs.core.truth_(me_iter.hasNext())){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(function (){var G__9099 = self__.root;
return (cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(G__9099) : cljs.core.tv_editable_root.call(null,G__9099));
})(),(function (){var G__9100 = self__.tail;
return (cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(G__9100) : cljs.core.tv_editable_tail.call(null,G__9100));
})()));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1,f);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__9101 = init__$2;
var G__9102 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9101,G__9102) : f.call(null,G__9101,G__9102));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__9112 = (j + (1));
var G__9113 = init__$3;
j = G__9112;
init__$2 = G__9113;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9103 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9103) : cljs.core.deref.call(null,G__9103));
} else {
var G__9114 = (i + len);
var G__9115 = init__$2;
i = G__9114;
init__$1 = G__9115;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._assoc_n(coll__$1,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0)));
} else {
var G__9104 = coll__$1;
var G__9105 = cljs.core.first_array_for_longvec(coll__$1);
var G__9106 = (0);
var G__9107 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9104,G__9105,G__9106,G__9107) : cljs.core.chunked_seq.call(null,G__9104,G__9105,G__9106,G__9107));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__4774__auto___9116 = len;
var i_9117 = (0);
while(true){
if((i_9117 < n__4774__auto___9116)){
(new_tail[i_9117] = (self__.tail[i_9117]));

var G__9118 = (i_9117 + (1));
i_9117 = G__9118;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__9119 = null;
var G__9119__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__9119__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__9119 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9119__2.call(this,self__,k);
case 3:
return G__9119__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9119.cljs$core$IFn$_invoke$arity$2 = G__9119__2;
G__9119.cljs$core$IFn$_invoke$arity$3 = G__9119__3;
return G__9119;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args9094){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9094)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/PersistentVector");
});

cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__9120 = (i + (1));
var G__9121 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__9120;
out = G__9121;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 * will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0)))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
});

cljs.core.vector.cljs$lang$maxFixedArity = (0);

cljs.core.vector.cljs$lang$applyTo = (function (seq9122){
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9122));
});

/**
* @constructor
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__9123 = self__.vec;
var G__9124 = self__.node;
var G__9125 = self__.i;
var G__9126 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9123,G__9124,G__9125,G__9126) : cljs.core.chunked_seq.call(null,G__9123,G__9124,G__9125,G__9126));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return cljs.core._chunked_next(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((function (){var G__9127 = self__.vec;
var G__9128 = (self__.i + self__.off);
var G__9129 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__9127,G__9128,G__9129) : cljs.core.subvec.call(null,G__9127,G__9128,G__9129));
})(),f);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((function (){var G__9130 = self__.vec;
var G__9131 = (self__.i + self__.off);
var G__9132 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__9130,G__9131,G__9132) : cljs.core.subvec.call(null,G__9130,G__9131,G__9132));
})(),f,start);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__9133 = self__.vec;
var G__9134 = self__.node;
var G__9135 = self__.i;
var G__9136 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9133,G__9134,G__9135,G__9136) : cljs.core.chunked_seq.call(null,G__9133,G__9134,G__9135,G__9136));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return cljs.core._chunked_rest(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__9137 = self__.vec;
var G__9138 = cljs.core.unchecked_array_for(self__.vec,end);
var G__9139 = end;
var G__9140 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9137,G__9138,G__9139,G__9140) : cljs.core.chunked_seq.call(null,G__9137,G__9138,G__9139,G__9140));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
var G__9141 = self__.vec;
var G__9142 = self__.node;
var G__9143 = self__.i;
var G__9144 = self__.off;
var G__9145 = m;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(G__9141,G__9142,G__9143,G__9144,G__9145) : cljs.core.chunked_seq.call(null,G__9141,G__9142,G__9143,G__9144,G__9145));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__9146 = self__.vec;
var G__9147 = cljs.core.unchecked_array_for(self__.vec,end);
var G__9148 = end;
var G__9149 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9146,G__9147,G__9148,G__9149) : cljs.core.chunked_seq.call(null,G__9146,G__9147,G__9148,G__9149));
} else {
return null;
}
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/ChunkedSeq");
});

cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(){
var G__9151 = arguments.length;
switch (G__9151) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});

cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;

/**
* @constructor
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__9154 = init__$1;
var G__9155 = j;
var G__9156 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9154,G__9155,G__9156) : f.call(null,G__9154,G__9155,G__9156));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9157 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9157) : cljs.core.deref.call(null,G__9157));
} else {
var G__9179 = (i + (1));
var G__9180 = (j + (1));
var G__9181 = init__$2;
i = G__9179;
j = G__9180;
init__$1 = G__9181;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
var G__9158 = self__.meta;
var G__9159 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__9160 = self__.start;
var G__9161 = (function (){var x__4201__auto__ = self__.end;
var y__4202__auto__ = (v_pos + (1));
return ((x__4201__auto__ > y__4202__auto__) ? x__4201__auto__ : y__4202__auto__);
})();
var G__9162 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9158,G__9159,G__9160,G__9161,G__9162) : cljs.core.build_subvec.call(null,G__9158,G__9159,G__9160,G__9161,G__9162));
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__9163 = self__.meta;
var G__9164 = self__.v;
var G__9165 = self__.start;
var G__9166 = (self__.end - (1));
var G__9167 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9163,G__9164,G__9165,G__9166,G__9167) : cljs.core.build_subvec.call(null,G__9163,G__9164,G__9165,G__9166,G__9167));
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(!((self__.start === self__.end))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start__$1){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start__$1);
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n(coll__$1,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return cljs$core$subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
var G__9169 = meta__$1;
var G__9170 = self__.v;
var G__9171 = self__.start;
var G__9172 = self__.end;
var G__9173 = self__.__hash;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9169,G__9170,G__9171,G__9172,G__9173) : cljs.core.build_subvec.call(null,G__9169,G__9170,G__9171,G__9172,G__9173));
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__9174 = self__.meta;
var G__9175 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__9176 = self__.start;
var G__9177 = (self__.end + (1));
var G__9178 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9174,G__9175,G__9176,G__9177,G__9178) : cljs.core.build_subvec.call(null,G__9174,G__9175,G__9176,G__9177,G__9178));
});

cljs.core.Subvec.prototype.call = (function() {
var G__9182 = null;
var G__9182__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__9182__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__9182 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9182__2.call(this,self__,k);
case 3:
return G__9182__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9182.cljs$core$IFn$_invoke$arity$2 = G__9182__2;
G__9182.cljs$core$IFn$_invoke$arity$3 = G__9182__3;
return G__9182;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args9153){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9153)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/Subvec");
});

cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__9183 = meta;
var G__9184 = v.v;
var G__9185 = (v.start + start);
var G__9186 = (v.start + end);
var G__9187 = __hash;
meta = G__9183;
v = G__9184;
start = G__9185;
end = G__9186;
__hash = G__9187;
continue;
} else {
var c = cljs.core.count(v);
if(((start < (0))) || ((end < (0))) || ((start > c)) || ((end > c))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 * start (inclusive) to end (exclusive).  If end is not supplied,
 * defaults to (count vector). This operation is O(1) and very fast, as
 * the resulting vector shares structure with the original and no
 * trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(){
var G__9189 = arguments.length;
switch (G__9189) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function (v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function (v,start,end){
return cljs.core.build_subvec(null,v,start,end,null);
});

cljs.core.subvec.cljs$lang$maxFixedArity = 3;
cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode((function (){var obj9194 = {};
return obj9194;
})(),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if(!((child == null))){
return cljs$core$tv_push_tail(tv,(level - (5)),child,tail_node);
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$tv_pop_tail(tv,(level - (5)),cljs.core.pv_aget(node__$1,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__9202 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__9203 = (level - (5));
node = G__9202;
level = G__9203;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
})
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n_BANG_(tcoll__$1,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = ((function (tcoll__$1){
return (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
.call(null,self__.shift,self__.root);
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return cljs.core._conj_BANG_(tcoll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds for TransientVector of length"),cljs.core.str(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if(!((nr == null))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.call = (function() {
var G__9207 = null;
var G__9207__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9207__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9207 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9207__2.call(this,self__,k);
case 3:
return G__9207__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9207.cljs$core$IFn$_invoke$arity$2 = G__9207__2;
G__9207.cljs$core$IFn$_invoke$arity$3 = G__9207__3;
return G__9207;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args9204){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9204)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/TransientVector");
});

cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__4402__auto__ = cljs.core.next(self__.front);
if(temp__4402__auto__){
var f1 = temp__4402__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return cljs.core._empty(coll__$1);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueSeq(meta__$1,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/PersistentQueueSeq");
});

cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));

/**
* @constructor
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__4402__auto__ = cljs.core.next(self__.front);
if(temp__4402__auto__){
var f1 = temp__4402__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__3889__auto__ = self__.front;
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(meta__$1,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__3889__auto__ = self__.rear;
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/PersistentQueue");
});

cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));

/**
* @constructor
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/NeverEquiv");
});

cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Assumes y is a map. Returns true if x equals y, otherwise returns
 * false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((cljs.core.map_QMARK_(y))?(((cljs.core.count(x) === cljs.core.count(y)))?cljs.core.every_QMARK_(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__9208 = (i + incr);
i = G__9208;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__9209 = (i + (1));
var G__9210 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,(so[k__$1]));
i = G__9209;
out = G__9210;
continue;
} else {
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = (function (){var obj9214 = {};
return obj9214;
})();
var l = ks.length;
var i_9215 = (0);
while(true){
if((i_9215 < l)){
var k_9216 = (ks[i_9215]);
(new_obj[k_9216] = (obj[k_9216]));

var G__9217 = (i_9215 + (1));
i_9215 = G__9217;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
})
cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3877__auto__ = (function (){var G__9221 = k;
return goog.isString(G__9221);
})();
if(cljs.core.truth_(and__3877__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3877__auto__;
}
})())){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__9222 = init__$1;
var G__9223 = k;
var G__9224 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9222,G__9223,G__9224) : f.call(null,G__9222,G__9223,G__9224));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9225 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9225) : cljs.core.deref.call(null,G__9225));
} else {
var G__9231 = cljs.core.rest(keys__$1);
var G__9232 = init__$2;
keys__$1 = G__9231;
init__$1 = G__9232;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3877__auto__ = (function (){var G__9227 = k;
return goog.isString(G__9227);
})();
if(cljs.core.truth_(and__3877__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3877__auto__;
}
})())){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var G__9228 = k;
return goog.isString(G__9228);
})())){
if(((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if(!((cljs.core.scan_array((1),k,self__.keys) == null))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
(new_strobj[k] = v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
(new_strobj[k] = v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3877__auto__ = (function (){var G__9230 = k;
return goog.isString(G__9230);
})();
if(cljs.core.truth_(and__3877__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3877__auto__;
}
})())){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__9218_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__9218_SHARP_,(self__.strobj[p1__9218_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ObjMap(meta__$1,self__.keys,self__.strobj,self__.update_count,self__.__hash));
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__9233 = null;
var G__9233__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9233__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9233 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9233__2.call(this,self__,k);
case 3:
return G__9233__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9233.cljs$core$IFn$_invoke$arity$2 = G__9233__2;
G__9233.cljs$core$IFn$_invoke$arity$3 = G__9233__3;
return G__9233;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args9219){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9219)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/ObjMap");
});

cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],(function (){var obj9235 = {};
return obj9235;
})(),(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var vec__9236 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9236,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9236,(1),null);
self__.s = cljs.core.next(self__.s);

return {"value": [k,v], "done": false};
} else {
return {"value": null, "done": true};
}
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/ES6EntriesIterator");
});

cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"value": [x,x], "done": false};
} else {
return {"value": null, "done": true};
}
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/ES6SetEntriesIterator");
});

cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__9237 = (i + (2));
i = G__9237;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Keyword)) && ((kstr === k_SINGLEQUOTE_.fqn));
})()){
return i;
} else {
var G__9238 = (i + (2));
i = G__9238;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Symbol)) && ((kstr === k_SINGLEQUOTE_.str));
})()){
return i;
} else {
var G__9239 = (i + (2));
i = G__9239;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__9240 = (i + (2));
i = G__9240;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__9241 = (i + (2));
i = G__9241;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if(cljs.core.truth_((function (){var or__3889__auto__ = (function (){var G__9245 = k;
return goog.isString(G__9245);
})();
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return typeof k === 'number';
}
})())){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_9246 = (0);
while(true){
if((i_9246 < l)){
(narr[i_9246] = (arr[i_9246]));

var G__9247 = (i_9246 + (1));
i_9246 = G__9247;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/PersistentArrayMapSeq");
});

cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
})
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/PersistentArrayMapIterator");
});

cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9249 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9249) : cljs.core.keys.call(null,G__9249));
})());
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9250 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9250) : cljs.core.vals.call(null,G__9250));
})());
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9251 = cljs.core.seq(coll);
var chunk__9252 = null;
var count__9253 = (0);
var i__9254 = (0);
while(true){
if((i__9254 < count__9253)){
var vec__9255 = chunk__9252.cljs$core$IIndexed$_nth$arity$2(null,i__9254);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9255,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9255,(1),null);
var G__9256_9269 = v;
var G__9257_9270 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9256_9269,G__9257_9270) : f.call(null,G__9256_9269,G__9257_9270));

var G__9271 = seq__9251;
var G__9272 = chunk__9252;
var G__9273 = count__9253;
var G__9274 = (i__9254 + (1));
seq__9251 = G__9271;
chunk__9252 = G__9272;
count__9253 = G__9273;
i__9254 = G__9274;
continue;
} else {
var temp__4404__auto__ = cljs.core.seq(seq__9251);
if(temp__4404__auto__){
var seq__9251__$1 = temp__4404__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9251__$1)){
var c__4674__auto__ = cljs.core.chunk_first(seq__9251__$1);
var G__9275 = cljs.core.chunk_rest(seq__9251__$1);
var G__9276 = c__4674__auto__;
var G__9277 = cljs.core.count(c__4674__auto__);
var G__9278 = (0);
seq__9251 = G__9275;
chunk__9252 = G__9276;
count__9253 = G__9277;
i__9254 = G__9278;
continue;
} else {
var vec__9258 = cljs.core.first(seq__9251__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9258,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9258,(1),null);
var G__9259_9279 = v;
var G__9260_9280 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9259_9279,G__9260_9280) : f.call(null,G__9259_9279,G__9260_9280));

var G__9281 = cljs.core.next(seq__9251__$1);
var G__9282 = null;
var G__9283 = (0);
var G__9284 = (0);
seq__9251 = G__9281;
chunk__9252 = G__9282;
count__9253 = G__9283;
i__9254 = G__9284;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__9261 = init__$1;
var G__9262 = (self__.arr[i]);
var G__9263 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9261,G__9262,G__9263) : f.call(null,G__9261,G__9262,G__9263));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9264 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9264) : cljs.core.deref.call(null,G__9264));
} else {
var G__9285 = (i + (2));
var G__9286 = init__$2;
i = G__9285;
init__$1 = G__9286;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((function (){var G__9265 = other;
if(G__9265){
var bit__4556__auto__ = (G__9265.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4556__auto__) || (G__9265.cljs$core$IMap$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if(!((v === cljs.core.lookup_sentinel))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__9287 = (i + (2));
i = G__9287;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_map(coll__$1,other);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap((function (){var obj9267 = {};
return obj9267;
})(),self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return cljs.core._empty(coll__$1);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__9288 = (s + (2));
var G__9289 = d;
s = G__9288;
d = G__9289;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__9290 = (s + (2));
var G__9291 = (d + (2));
s = G__9290;
d = G__9291;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__9268 = cljs.core.aclone(self__.arr);
(G__9268[(idx + (1))] = v);

return G__9268;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((cljs.core.array_map_index_of(coll__$1,k) === (-1)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMap(meta__$1,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9292 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9293 = cljs.core.next(es);
ret = G__9292;
es = G__9293;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__9294 = null;
var G__9294__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9294__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9294 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9294__2.call(this,self__,k);
case 3:
return G__9294__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9294.cljs$core$IFn$_invoke$arity$2 = G__9294__2;
G__9294.cljs$core$IFn$_invoke$arity$3 = G__9294__3;
return G__9294;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args9248){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9248)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/PersistentArrayMap");
});

cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_9295 = (0);
while(true){
if((i_9295 < arr__$1.length)){
var k_9296 = (arr__$1[i_9295]);
var v_9297 = (arr__$1[(i_9295 + (1))]);
var idx_9298 = cljs.core.array_index_of(ret,k_9296);
if((idx_9298 === (-1))){
ret.push(k_9296);

ret.push(v_9297);
} else {
}

var G__9299 = (i_9295 + (2));
i_9295 = G__9299;
continue;
} else {
}
break;
}

return ret;
})());
var arr__$3 = (function (){var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
})();
return arr__$3;
});
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 258;
this.cljs$lang$protocol_mask$partition1$ = 56;
})
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if((function (){var G__9300 = o;
if(G__9300){
var bit__4563__auto__ = (G__9300.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4563__auto__) || (G__9300.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__9300.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9300);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9300);
}
})()){
return cljs.core._assoc_BANG_(tcoll__$1,(function (){var G__9301 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9301) : cljs.core.key.call(null,G__9301));
})(),(function (){var G__9302 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9302) : cljs.core.val.call(null,G__9302));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__4402__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4402__auto__)){
var e = temp__4402__auto__;
var G__9308 = cljs.core.next(es);
var G__9309 = cljs.core._assoc_BANG_(tcoll__$2,(function (){var G__9303 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9303) : cljs.core.key.call(null,G__9303));
})(),(function (){var G__9304 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9304) : cljs.core.val.call(null,G__9304));
})());
es = G__9308;
tcoll__$2 = G__9309;
continue;
} else {
return tcoll__$2;
}
break;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((function (){var G__9305 = self__.len;
var G__9306 = self__.arr;
return (cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(G__9305,G__9306) : cljs.core.array__GT_transient_hash_map.call(null,G__9305,G__9306));
})(),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__9307_9310 = self__.arr;
G__9307_9310.pop();

G__9307_9310.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/TransientArrayMap");
});

cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});


cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__9311 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__9312 = (i + (2));
out = G__9311;
i = G__9312;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/Box");
});

cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(){
var G__9314 = arguments.length;
switch (G__9314) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function (arr,i,a){
var G__9315 = cljs.core.aclone(arr);
(G__9315[i] = a);

return G__9315;
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function (arr,i,a,j,b){
var G__9316 = cljs.core.aclone(arr);
(G__9316[i] = a);

(G__9316[j] = b);

return G__9316;
});

cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;
cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(){
var G__9319 = arguments.length;
switch (G__9319) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});

cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;
cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if(!((k == null))){
var G__9325 = init__$1;
var G__9326 = k;
var G__9327 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9325,G__9326,G__9327) : f.call(null,G__9325,G__9326,G__9327));
} else {
var node = (arr[(i + (1))]);
if(!((node == null))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9328 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9328) : cljs.core.deref.call(null,G__9328));
} else {
var G__9329 = (i + (2));
var G__9330 = init__$2;
i = G__9329;
init__$1 = G__9330;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_[(0)] = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9331 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__9331) : cljs.core.create_inode_seq.call(null,G__9331));
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_9345 = (0);
var j_9346 = (0);
while(true){
if((i_9345 < (32))){
if((((self__.bitmap >>> i_9345) & (1)) === (0))){
var G__9347 = (i_9345 + (1));
var G__9348 = j_9346;
i_9345 = G__9347;
j_9346 = G__9348;
continue;
} else {
(nodes[i_9345] = ((!(((self__.arr[j_9346]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_9346])),(self__.arr[j_9346]),(self__.arr[(j_9346 + (1))]),added_leaf_QMARK_):(self__.arr[(j_9346 + (1))])));

var G__9349 = (i_9345 + (1));
var G__9350 = (j_9346 + (2));
i_9345 = G__9349;
j_9346 = G__9350;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__9332 = edit__$1;
var G__9333 = (shift + (5));
var G__9334 = key_or_nil;
var G__9335 = val_or_node;
var G__9336 = hash;
var G__9337 = key;
var G__9338 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__9332,G__9333,G__9334,G__9335,G__9336,G__9337,G__9338) : cljs.core.create_node.call(null,G__9332,G__9333,G__9334,G__9335,G__9336,G__9337,G__9338));
})());

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_9351 = (0);
var j_9352 = (0);
while(true){
if((i_9351 < (32))){
if((((self__.bitmap >>> i_9351) & (1)) === (0))){
var G__9353 = (i_9351 + (1));
var G__9354 = j_9352;
i_9351 = G__9353;
j_9352 = G__9354;
continue;
} else {
(nodes[i_9351] = ((!(((self__.arr[j_9352]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_9352])),(self__.arr[j_9352]),(self__.arr[(j_9352 + (1))]),added_leaf_QMARK_):(self__.arr[(j_9352 + (1))])));

var G__9355 = (i_9351 + (1));
var G__9356 = (j_9352 + (2));
i_9351 = G__9355;
j_9352 = G__9356;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__9339 = (shift + (5));
var G__9340 = key_or_nil;
var G__9341 = val_or_node;
var G__9342 = hash;
var G__9343 = key;
var G__9344 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__9339,G__9340,G__9341,G__9342,G__9343,G__9344) : cljs.core.create_node.call(null,G__9339,G__9340,G__9341,G__9342,G__9343,G__9344));
})())));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil,val_or_node], null);
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/BitmapIndexedNode");
});

cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((!((i === idx))) && (!(((arr[i]) == null)))){
(new_arr[j] = (arr[i]));

var G__9357 = (i + (1));
var G__9358 = (j + (2));
var G__9359 = (bitmap | ((1) << i));
i = G__9357;
j = G__9358;
bitmap = G__9359;
continue;
} else {
var G__9360 = (i + (1));
var G__9361 = j;
var G__9362 = bitmap;
i = G__9360;
j = G__9361;
bitmap = G__9362;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9363 = self__.arr;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(G__9363) : cljs.core.create_array_node_seq.call(null,G__9363));
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if(!((node == null))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9364 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9364) : cljs.core.deref.call(null,G__9364));
} else {
var G__9365 = (i + (1));
var G__9366 = init__$2;
i = G__9365;
init__$1 = G__9366;
continue;
}
} else {
var G__9367 = (i + (1));
var G__9368 = init__$1;
i = G__9367;
init__$1 = G__9368;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/ArrayNode");
});

cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__9369 = (i + (2));
i = G__9369;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_[(0)] = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9370 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__9370) : cljs.core.create_inode_seq.call(null,G__9370));
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[idx]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),(self__.arr[(idx + (1))])], null);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/HashCollisionNode");
});

cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(){
var G__9372 = arguments.length;
switch (G__9372) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$lang$maxFixedArity = 7;

/**
* @constructor
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))])], null);
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
var G__9374 = self__.nodes;
var G__9375 = (self__.i + (2));
var G__9376 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__9374,G__9375,G__9376) : cljs.core.create_inode_seq.call(null,G__9374,G__9375,G__9376));
} else {
var G__9377 = self__.nodes;
var G__9378 = self__.i;
var G__9379 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__9377,G__9378,G__9379) : cljs.core.create_inode_seq.call(null,G__9377,G__9378,G__9379));
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/NodeSeq");
});

cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(){
var G__9381 = arguments.length;
switch (G__9381) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if(!(((nodes[j]) == null))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__4402__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__4402__auto__)){
var node = temp__4402__auto__;
var temp__4402__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__4402__auto____$1)){
var node_seq = temp__4402__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__9383 = (j + (2));
j = G__9383;
continue;
}
} else {
var G__9384 = (j + (2));
j = G__9384;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});

cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;

/**
* @constructor
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__9385 = null;
var G__9386 = self__.nodes;
var G__9387 = self__.i;
var G__9388 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__9385,G__9386,G__9387,G__9388) : cljs.core.create_array_node_seq.call(null,G__9385,G__9386,G__9387,G__9388));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/ArrayNodeSeq");
});

cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(){
var G__9390 = arguments.length;
switch (G__9390) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null,nodes,(0),null);
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = (function (meta,nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__4402__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__4402__auto__)){
var nj = temp__4402__auto__;
var temp__4402__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__4402__auto____$1)){
var ns = temp__4402__auto____$1;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j + (1)),ns,null));
} else {
var G__9392 = (j + (1));
j = G__9392;
continue;
}
} else {
var G__9393 = (j + (1));
j = G__9393;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});

cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;

/**
* @constructor
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9395 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9395) : cljs.core.keys.call(null,G__9395));
})());
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9396 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9396) : cljs.core.vals.call(null,G__9396));
})());
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9397 = cljs.core.seq(coll);
var chunk__9398 = null;
var count__9399 = (0);
var i__9400 = (0);
while(true){
if((i__9400 < count__9399)){
var vec__9401 = chunk__9398.cljs$core$IIndexed$_nth$arity$2(null,i__9400);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9401,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9401,(1),null);
var G__9402_9413 = v;
var G__9403_9414 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9402_9413,G__9403_9414) : f.call(null,G__9402_9413,G__9403_9414));

var G__9415 = seq__9397;
var G__9416 = chunk__9398;
var G__9417 = count__9399;
var G__9418 = (i__9400 + (1));
seq__9397 = G__9415;
chunk__9398 = G__9416;
count__9399 = G__9417;
i__9400 = G__9418;
continue;
} else {
var temp__4404__auto__ = cljs.core.seq(seq__9397);
if(temp__4404__auto__){
var seq__9397__$1 = temp__4404__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9397__$1)){
var c__4674__auto__ = cljs.core.chunk_first(seq__9397__$1);
var G__9419 = cljs.core.chunk_rest(seq__9397__$1);
var G__9420 = c__4674__auto__;
var G__9421 = cljs.core.count(c__4674__auto__);
var G__9422 = (0);
seq__9397 = G__9419;
chunk__9398 = G__9420;
count__9399 = G__9421;
i__9400 = G__9422;
continue;
} else {
var vec__9404 = cljs.core.first(seq__9397__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9404,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9404,(1),null);
var G__9405_9423 = v;
var G__9406_9424 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9405_9423,G__9406_9424) : f.call(null,G__9405_9423,G__9406_9424));

var G__9425 = cljs.core.next(seq__9397__$1);
var G__9426 = null;
var G__9427 = (0);
var G__9428 = (0);
seq__9397 = G__9425;
chunk__9398 = G__9426;
count__9399 = G__9427;
i__9400 = G__9428;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(function (){var G__9407 = init;
var G__9408 = null;
var G__9409 = self__.nil_val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9407,G__9408,G__9409) : f.call(null,G__9407,G__9408,G__9409));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__9410 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9410) : cljs.core.deref.call(null,G__9410));
} else {
if(!((self__.root == null))){
return self__.root.kv_reduce(f,init__$1);
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap((function (){var obj9412 = {};
return obj9412;
})(),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if((self__.has_nil_QMARK_) && ((v === self__.nil_val))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return !((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = ((!((self__.root == null)))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashMap(meta__$1,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9429 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9430 = cljs.core.next(es);
ret = G__9429;
es = G__9430;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__9431 = null;
var G__9431__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9431__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9431 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9431__2.call(this,self__,k);
case 3:
return G__9431__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9431.cljs$core$IFn$_invoke$arity$2 = G__9431__2;
G__9431.cljs$core$IFn$_invoke$arity$3 = G__9431__3;
return G__9431;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args9394){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9394)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/PersistentHashMap");
});

cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__9432 = (i + (2));
var G__9433 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__9432;
ret = G__9433;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__9434 = (i + (1));
var G__9435 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(ks[i]),(vs[i]));
i = G__9434;
out = G__9435;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 258;
this.cljs$lang$protocol_mask$partition1$ = 56;
})
cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((function (){var G__9436 = o;
if(G__9436){
var bit__4563__auto__ = (G__9436.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4563__auto__) || (G__9436.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__9436.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9436);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9436);
}
})()){
return tcoll.assoc_BANG_((function (){var G__9437 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9437) : cljs.core.key.call(null,G__9437));
})(),(function (){var G__9438 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9438) : cljs.core.val.call(null,G__9438));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__4402__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4402__auto__)){
var e = temp__4402__auto__;
var G__9441 = cljs.core.next(es);
var G__9442 = tcoll__$1.assoc_BANG_((function (){var G__9439 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9439) : cljs.core.key.call(null,G__9439));
})(),(function (){var G__9440 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9440) : cljs.core.val.call(null,G__9440));
})());
es = G__9441;
tcoll__$1 = G__9442;
continue;
} else {
return tcoll__$1;
}
break;
}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(cljs.core.truth_((removed_leaf_QMARK_[(0)]))){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/TransientHashMap");
});

cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if(!((t == null))){
var G__9443 = ((ascending_QMARK_)?t.left:t.right);
var G__9444 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__9443;
stack__$1 = G__9444;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374862;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if(!((next_stack == null))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMapSeq(meta__$1,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/PersistentTreeMapSeq");
});

cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if(((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if(((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = ((!((node.left == null)))?cljs$core$tree_map_kv_reduce(node.left,f,init):init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__9457 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9457) : cljs.core.deref.call(null,G__9457));
} else {
var init__$2 = (function (){var G__9458 = init__$1;
var G__9459 = node.key;
var G__9460 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9458,G__9459,G__9460) : f.call(null,G__9458,G__9459,G__9460));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9461 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9461) : cljs.core.deref.call(null,G__9461));
} else {
var init__$3 = ((!((node.right == null)))?cljs$core$tree_map_kv_reduce(node.right,f,init__$2):init__$2);
if(cljs.core.reduced_QMARK_(init__$3)){
var G__9462 = init__$3;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9462) : cljs.core.deref.call(null,G__9462));
} else {
return init__$3;
}
}
}
});

/**
* @constructor
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__9464 = null;
var G__9464__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9464__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9464 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9464__2.call(this,self__,k);
case 3:
return G__9464__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9464.cljs$core$IFn$_invoke$arity$2 = G__9464__2;
G__9464.cljs$core$IFn$_invoke$arity$3 = G__9464__3;
return G__9464;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args9463){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9463)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/BlackNode");
});

cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));

/**
* @constructor
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__9466 = null;
var G__9466__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9466__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9466 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9466__2.call(this,self__,k);
case 3:
return G__9466__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9466.cljs$core$IFn$_invoke$arity$2 = G__9466__2;
G__9466.cljs$core$IFn$_invoke$arity$3 = G__9466__3;
return G__9466;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args9465){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9465)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/RedNode");
});

cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__9479 = k;
var G__9480 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9479,G__9480) : comp.call(null,G__9479,G__9480));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = cljs$core$tree_map_add(comp,tree.left,k,v,found);
if(!((ins == null))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = cljs$core$tree_map_add(comp,tree.right,k,v,found);
if(!((ins == null))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,cljs$core$tree_map_append(left.right,right),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,cljs$core$tree_map_append(left,right.left),right.right,null));
} else {
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if(!((tree == null))){
var c = (function (){var G__9499 = k;
var G__9500 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9499,G__9500) : comp.call(null,G__9499,G__9500));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = cljs$core$tree_map_remove(comp,tree.left,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = cljs$core$tree_map_remove(comp,tree.right,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (function (){var G__9511 = k;
var G__9512 = tk;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9511,G__9512) : comp.call(null,G__9511,G__9512));
})();
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,cljs$core$tree_map_replace(comp,tree.left,k,v),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,cljs$core$tree_map_replace(comp,tree.right,k,v));

}
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9514 = cljs.core.seq(coll);
var chunk__9515 = null;
var count__9516 = (0);
var i__9517 = (0);
while(true){
if((i__9517 < count__9516)){
var vec__9518 = chunk__9515.cljs$core$IIndexed$_nth$arity$2(null,i__9517);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9518,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9518,(1),null);
var G__9519_9531 = v;
var G__9520_9532 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9519_9531,G__9520_9532) : f.call(null,G__9519_9531,G__9520_9532));

var G__9533 = seq__9514;
var G__9534 = chunk__9515;
var G__9535 = count__9516;
var G__9536 = (i__9517 + (1));
seq__9514 = G__9533;
chunk__9515 = G__9534;
count__9516 = G__9535;
i__9517 = G__9536;
continue;
} else {
var temp__4404__auto__ = cljs.core.seq(seq__9514);
if(temp__4404__auto__){
var seq__9514__$1 = temp__4404__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9514__$1)){
var c__4674__auto__ = cljs.core.chunk_first(seq__9514__$1);
var G__9537 = cljs.core.chunk_rest(seq__9514__$1);
var G__9538 = c__4674__auto__;
var G__9539 = cljs.core.count(c__4674__auto__);
var G__9540 = (0);
seq__9514 = G__9537;
chunk__9515 = G__9538;
count__9516 = G__9539;
i__9517 = G__9540;
continue;
} else {
var vec__9521 = cljs.core.first(seq__9514__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9521,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9521,(1),null);
var G__9522_9541 = v;
var G__9523_9542 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9522_9541,G__9523_9542) : f.call(null,G__9522_9541,G__9523_9542));

var G__9543 = cljs.core.next(seq__9514__$1);
var G__9544 = null;
var G__9545 = (0);
var G__9546 = (0);
seq__9514 = G__9543;
chunk__9515 = G__9544;
count__9516 = G__9545;
i__9517 = G__9546;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9524 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9524) : cljs.core.keys.call(null,G__9524));
})());
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9525 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9525) : cljs.core.vals.call(null,G__9525));
})());
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__9526 = k;
var G__9527 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__9526,G__9527) : self__.comp.call(null,G__9526,G__9527));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__9547 = t.left;
t = G__9547;
continue;
} else {
var G__9548 = t.right;
t = G__9548;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if(!((n == null))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if(!((self__.tree == null))){
return cljs.core.tree_map_kv_reduce(self__.tree,f,init);
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((coll__$1.entry_at(k) == null));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,meta__$1,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9549 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9550 = cljs.core.next(es);
ret = G__9549;
es = G__9550;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__9551 = null;
var G__9551__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9551__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9551 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9551__2.call(this,self__,k);
case 3:
return G__9551__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9551.cljs$core$IFn$_invoke$arity$2 = G__9551__2;
G__9551.cljs$core$IFn$_invoke$arity$3 = G__9551__3;
return G__9551;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args9513){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9513)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__9528 = k;
var G__9529 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__9528,G__9529) : self__.comp.call(null,G__9528,G__9529));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__9552 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__9553 = t.left;
stack = G__9552;
t = G__9553;
continue;
} else {
var G__9554 = stack;
var G__9555 = t.right;
stack = G__9554;
t = G__9555;
continue;
}
} else {
if((c > (0))){
var G__9556 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__9557 = t.right;
stack = G__9556;
t = G__9557;
continue;
} else {
var G__9558 = stack;
var G__9559 = t.left;
stack = G__9558;
t = G__9559;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
var G__9530 = entry;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9530) : cljs.core.key.call(null,G__9530));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/PersistentTreeMap");
});

cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
/**
 * keyval => key val
 * Returns a new hash map with supplied mappings.
 */
cljs.core.hash_map = (function cljs$core$hash_map(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__9561 = cljs.core.nnext(in$);
var G__9562 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9561;
out = G__9562;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});

cljs.core.hash_map.cljs$lang$maxFixedArity = (0);

cljs.core.hash_map.cljs$lang$applyTo = (function (seq9560){
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9560));
});
/**
 * keyval => key val
 * Returns a new array map with supplied mappings.
 */
cljs.core.array_map = (function cljs$core$array_map(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var arr = ((((keyvals instanceof cljs.core.IndexedSeq)) && ((keyvals.i === (0))))?keyvals.arr:cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals));
return cljs.core.PersistentArrayMap.fromArray(arr,true,false);
});

cljs.core.array_map.cljs$lang$maxFixedArity = (0);

cljs.core.array_map.cljs$lang$applyTo = (function (seq9563){
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9563));
});
/**
 * keyval => key val
 * Returns a new object map with supplied mappings.
 */
cljs.core.obj_map = (function cljs$core$obj_map(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var ks = [];
var obj = (function (){var obj9566 = {};
return obj9566;
})();
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

(obj[cljs.core.first(kvs)] = cljs.core.second(kvs));

var G__9567 = cljs.core.nnext(kvs);
kvs = G__9567;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
});

cljs.core.obj_map.cljs$lang$maxFixedArity = (0);

cljs.core.obj_map.cljs$lang$applyTo = (function (seq9564){
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9564));
});
/**
 * keyval => key val
 * Returns a new sorted map with supplied mappings.
 */
cljs.core.sorted_map = (function cljs$core$sorted_map(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__9569 = cljs.core.nnext(in$);
var G__9570 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9569;
out = G__9570;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_map.cljs$lang$applyTo = (function (seq9568){
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9568));
});
/**
 * keyval => key val
 * Returns a new sorted map with supplied mappings, using the supplied comparator.
 */
cljs.core.sorted_map_by = (function cljs$core$sorted_map_by(){
var argseq__4929__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4929__auto__);
});

cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__9573 = cljs.core.nnext(in$);
var G__9574 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9573;
out = G__9574;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_map_by.cljs$lang$applyTo = (function (seq9571){
var G__9572 = cljs.core.first(seq9571);
var seq9571__$1 = cljs.core.next(seq9571);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(G__9572,seq9571__$1);
});

/**
* @constructor
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9575 = self__.mseq;
if(G__9575){
var bit__4563__auto__ = (G__9575.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4563__auto__) || (G__9575.cljs$core$INext$)){
return true;
} else {
if((!G__9575.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9575);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9575);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,self__._meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9576 = self__.mseq;
if(G__9576){
var bit__4563__auto__ = (G__9576.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4563__auto__) || (G__9576.cljs$core$INext$)){
return true;
} else {
if((!G__9576.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9576);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9576);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.KeySeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.KeySeq(self__.mseq,new_meta));
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/KeySeq");
});

cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
/**
 * Returns a sequence of the map's keys.
 */
cljs.core.keys = (function cljs$core$keys(hash_map){
var temp__4404__auto__ = cljs.core.seq(hash_map);
if(temp__4404__auto__){
var mseq = temp__4404__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9577 = self__.mseq;
if(G__9577){
var bit__4563__auto__ = (G__9577.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4563__auto__) || (G__9577.cljs$core$INext$)){
return true;
} else {
if((!G__9577.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9577);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9577);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,self__._meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9578 = self__.mseq;
if(G__9578){
var bit__4563__auto__ = (G__9578.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4563__auto__) || (G__9578.cljs$core$INext$)){
return true;
} else {
if((!G__9578.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9578);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9578);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.ValSeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ValSeq(self__.mseq,new_meta));
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/ValSeq");
});

cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
/**
 * Returns a sequence of the map's values.
 */
cljs.core.vals = (function cljs$core$vals(hash_map){
var temp__4404__auto__ = cljs.core.seq(hash_map);
if(temp__4404__auto__){
var mseq = temp__4404__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 * the first.  If a key occurs in more than one map, the mapping from
 * the latter (left-to-right) will be the mapping in the result.
 */
cljs.core.merge = (function cljs$core$merge(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__9579_SHARP_,p2__9580_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__3889__auto__ = p1__9579_SHARP_;
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__9580_SHARP_);
}),maps);
} else {
return null;
}
});

cljs.core.merge.cljs$lang$maxFixedArity = (0);

cljs.core.merge.cljs$lang$applyTo = (function (seq9581){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9581));
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 * the first.  If a key occurs in more than one map, the mapping(s)
 * from the latter (left-to-right) will be combined with the mapping in
 * the result by calling (f val-in-result val-in-latter).
 */
cljs.core.merge_with = (function cljs$core$merge_with(){
var argseq__4929__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4929__auto__);
});

cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.first(e);
var v = cljs.core.second(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9584 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9585 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9584,G__9585) : f.call(null,G__9584,G__9585));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__3889__auto__ = m1;
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
});

cljs.core.merge_with.cljs$lang$maxFixedArity = (1);

cljs.core.merge_with.cljs$lang$applyTo = (function (seq9582){
var G__9583 = cljs.core.first(seq9582);
var seq9582__$1 = cljs.core.next(seq9582);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(G__9583,seq9582__$1);
});
/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185));
var G__9586 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__9587 = cljs.core.next(keys);
ret = G__9586;
keys = G__9587;
continue;
} else {
return cljs.core.with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9590 = cljs.core.seq(coll);
var chunk__9591 = null;
var count__9592 = (0);
var i__9593 = (0);
while(true){
if((i__9593 < count__9592)){
var vec__9594 = chunk__9591.cljs$core$IIndexed$_nth$arity$2(null,i__9593);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9594,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9594,(1),null);
var G__9595_9600 = v;
var G__9596_9601 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9595_9600,G__9596_9601) : f.call(null,G__9595_9600,G__9596_9601));

var G__9602 = seq__9590;
var G__9603 = chunk__9591;
var G__9604 = count__9592;
var G__9605 = (i__9593 + (1));
seq__9590 = G__9602;
chunk__9591 = G__9603;
count__9592 = G__9604;
i__9593 = G__9605;
continue;
} else {
var temp__4404__auto__ = cljs.core.seq(seq__9590);
if(temp__4404__auto__){
var seq__9590__$1 = temp__4404__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9590__$1)){
var c__4674__auto__ = cljs.core.chunk_first(seq__9590__$1);
var G__9606 = cljs.core.chunk_rest(seq__9590__$1);
var G__9607 = c__4674__auto__;
var G__9608 = cljs.core.count(c__4674__auto__);
var G__9609 = (0);
seq__9590 = G__9606;
chunk__9591 = G__9607;
count__9592 = G__9608;
i__9593 = G__9609;
continue;
} else {
var vec__9597 = cljs.core.first(seq__9590__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9597,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9597,(1),null);
var G__9598_9610 = v;
var G__9599_9611 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9598_9610,G__9599_9611) : f.call(null,G__9598_9610,G__9599_9611));

var G__9612 = cljs.core.next(seq__9590__$1);
var G__9613 = null;
var G__9614 = (0);
var G__9615 = (0);
seq__9590 = G__9612;
chunk__9591 = G__9613;
count__9592 = G__9614;
i__9593 = G__9615;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core._contains_key_QMARK_(self__.hash_map,v)){
return v;
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__9588_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__9588_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(meta__$1,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__9616 = null;
var G__9616__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9616__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9616 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9616__2.call(this,self__,k);
case 3:
return G__9616__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9616.cljs$core$IFn$_invoke$arity$2 = G__9616__2;
G__9616.cljs$core$IFn$_invoke$arity$3 = G__9616__3;
return G__9616;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args9589){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9589)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/PersistentHashSet");
});

cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__9617 = (i + (1));
var G__9618 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__9617;
out = G__9618;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__9619 = (i + (1));
var G__9620 = cljs.core._conj_BANG_(out,(items[i]));
i = G__9619;
out = G__9620;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition1$ = 136;
this.cljs$lang$protocol_mask$partition0$ = 259;
})
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.call = (function() {
var G__9622 = null;
var G__9622__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__9622__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__9622 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9622__2.call(this,self__,k);
case 3:
return G__9622__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9622.cljs$core$IFn$_invoke$arity$2 = G__9622__2;
G__9622.cljs$core$IFn$_invoke$arity$3 = G__9622__3;
return G__9622;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args9621){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9621)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/TransientHashSet");
});

cljs.core.__GT_TransientHashSet = (function cljs$core$__GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9625 = cljs.core.seq(coll);
var chunk__9626 = null;
var count__9627 = (0);
var i__9628 = (0);
while(true){
if((i__9628 < count__9627)){
var vec__9629 = chunk__9626.cljs$core$IIndexed$_nth$arity$2(null,i__9628);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9629,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9629,(1),null);
var G__9630_9635 = v;
var G__9631_9636 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9630_9635,G__9631_9636) : f.call(null,G__9630_9635,G__9631_9636));

var G__9637 = seq__9625;
var G__9638 = chunk__9626;
var G__9639 = count__9627;
var G__9640 = (i__9628 + (1));
seq__9625 = G__9637;
chunk__9626 = G__9638;
count__9627 = G__9639;
i__9628 = G__9640;
continue;
} else {
var temp__4404__auto__ = cljs.core.seq(seq__9625);
if(temp__4404__auto__){
var seq__9625__$1 = temp__4404__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9625__$1)){
var c__4674__auto__ = cljs.core.chunk_first(seq__9625__$1);
var G__9641 = cljs.core.chunk_rest(seq__9625__$1);
var G__9642 = c__4674__auto__;
var G__9643 = cljs.core.count(c__4674__auto__);
var G__9644 = (0);
seq__9625 = G__9641;
chunk__9626 = G__9642;
count__9627 = G__9643;
i__9628 = G__9644;
continue;
} else {
var vec__9632 = cljs.core.first(seq__9625__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9632,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9632,(1),null);
var G__9633_9645 = v;
var G__9634_9646 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9633_9645,G__9634_9646) : f.call(null,G__9633_9645,G__9634_9646));

var G__9647 = cljs.core.next(seq__9625__$1);
var G__9648 = null;
var G__9649 = (0);
var G__9650 = (0);
seq__9625 = G__9647;
chunk__9626 = G__9648;
count__9627 = G__9649;
i__9628 = G__9650;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if(!((n == null))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__9623_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__9623_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(meta__$1,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__9651 = null;
var G__9651__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9651__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9651 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9651__2.call(this,self__,k);
case 3:
return G__9651__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9651.cljs$core$IFn$_invoke$arity$2 = G__9651__2;
G__9651.cljs$core$IFn$_invoke$arity$3 = G__9651__3;
return G__9651;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args9624){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9624)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/PersistentTreeSet");
});

cljs.core.__GT_PersistentTreeSet = (function cljs$core$__GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
cljs.core.set_from_indexed_seq = (function cljs$core$set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__4768__auto__ = arr;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < a__4768__auto__.length)){
var G__9652 = (i + (1));
var G__9653 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,(arr[i]));
i = G__9652;
res = G__9653;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
 * Returns a set of the distinct elements of coll.
 */
cljs.core.set = (function cljs$core$set(coll){
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if(((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0)))){
return cljs.core.set_from_indexed_seq(in$);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if(!((in$__$1 == null))){
var G__9654 = in$__$1.cljs$core$INext$_next$arity$1(null);
var G__9655 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,in$__$1.cljs$core$ISeq$_first$arity$1(null));
in$__$1 = G__9654;
out = G__9655;
continue;
} else {
return out.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
}
break;
}

}
}
});
/**
 * Returns a new hash set with supplied keys.  Any equal keys are
 * handled as if by repeated uses of conj.
 */
cljs.core.hash_set = (function cljs$core$hash_set(){
var G__9658 = arguments.length;
switch (G__9658) {
case 0:
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,0),(0)));
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4941__auto__);

}
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.set(keys);
});

cljs.core.hash_set.cljs$lang$applyTo = (function (seq9656){
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9656));
});

cljs.core.hash_set.cljs$lang$maxFixedArity = 0;
/**
 * Returns a new sorted set with supplied keys.
 */
cljs.core.sorted_set = (function cljs$core$sorted_set(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
});

cljs.core.sorted_set.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_set.cljs$lang$applyTo = (function (seq9660){
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9660));
});
/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 */
cljs.core.sorted_set_by = (function cljs$core$sorted_set_by(){
var argseq__4929__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4929__auto__);
});

cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
});

cljs.core.sorted_set_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_set_by.cljs$lang$applyTo = (function (seq9661){
var G__9662 = cljs.core.first(seq9661);
var seq9661__$1 = cljs.core.next(seq9661);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(G__9662,seq9661__$1);
});
/**
 * Given a map of replacement pairs and a vector/collection, returns a
 * vector/seq with any elements = a key in smap replaced with the
 * corresponding val in smap.  Returns a transducer when no collection
 * is provided.
 */
cljs.core.replace = (function cljs$core$replace(){
var G__9666 = arguments.length;
switch (G__9666) {
case 1:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__9663_SHARP_){
var temp__4402__auto__ = cljs.core.find(smap,p1__9663_SHARP_);
if(cljs.core.truth_(temp__4402__auto__)){
var e = temp__4402__auto__;
return cljs.core.val(e);
} else {
return p1__9663_SHARP_;
}
}));
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__4402__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__4402__auto__)){
var e = temp__4402__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__9664_SHARP_){
var temp__4402__auto__ = cljs.core.find(smap,p1__9664_SHARP_);
if(cljs.core.truth_(temp__4402__auto__)){
var e = temp__4402__auto__;
return cljs.core.second(e);
} else {
return p1__9664_SHARP_;
}
}),coll);
}
});

cljs.core.replace.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the elements of coll with duplicates removed
 */
cljs.core.distinct = (function cljs$core$distinct(){
var G__9669 = arguments.length;
switch (G__9669) {
case 0:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__9681 = null;
var G__9681__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9681__1 = (function (result){
var G__9670 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9670) : rf.call(null,G__9670));
});
var G__9681__2 = (function (result,input){
if(cljs.core.contains_QMARK_((function (){var G__9671 = seen;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9671) : cljs.core.deref.call(null,G__9671));
})(),input)){
return result;
} else {
cljs.core._vreset_BANG_(seen,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(seen),input));

var G__9672 = result;
var G__9673 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9672,G__9673) : rf.call(null,G__9672,G__9673));
}
});
G__9681 = function(result,input){
switch(arguments.length){
case 0:
return G__9681__0.call(this);
case 1:
return G__9681__1.call(this,result);
case 2:
return G__9681__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9681.cljs$core$IFn$_invoke$arity$0 = G__9681__0;
G__9681.cljs$core$IFn$_invoke$arity$1 = G__9681__1;
G__9681.cljs$core$IFn$_invoke$arity$2 = G__9681__2;
return G__9681;
})()
;})(seen))
});
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var step = (function cljs$core$step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__9678,seen__$1){
while(true){
var vec__9679 = p__9678;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9679,(0),null);
var xs__$1 = vec__9679;
var temp__4404__auto__ = cljs.core.seq(xs__$1);
if(temp__4404__auto__){
var s = temp__4404__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__9682 = cljs.core.rest(s);
var G__9683 = seen__$1;
p__9678 = G__9682;
seen__$1 = G__9683;
continue;
} else {
return cljs.core.cons(f,cljs$core$step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});

cljs.core.distinct.cljs$lang$maxFixedArity = 1;
/**
 * Return a seq of all but the last item in coll, in linear time
 */
cljs.core.butlast = (function cljs$core$butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__9684 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__9685 = cljs.core.next(s__$1);
ret = G__9684;
s__$1 = G__9685;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
 * Returns the name String of a string, symbol or keyword.
 */
cljs.core.name = (function cljs$core$name(x){
if((function (){var G__9687 = x;
if(G__9687){
var bit__4556__auto__ = (G__9687.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4556__auto__) || (G__9687.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error([cljs.core.str("Doesn't support name: "),cljs.core.str(x)].join('')));
}
}
});
/**
 * Returns a map with the keys mapped to the corresponding vals.
 */
cljs.core.zipmap = (function cljs$core$zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if((ks) && (vs)){
var G__9688 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__9689 = cljs.core.next(ks);
var G__9690 = cljs.core.next(vs);
map = G__9688;
ks = G__9689;
vs = G__9690;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
 * Returns the x for which (k x), a number, is greatest.
 */
cljs.core.max_key = (function cljs$core$max_key(){
var G__9698 = arguments.length;
switch (G__9698) {
case 2:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4941__auto__);

}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((function (){var G__9699 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9699) : k.call(null,G__9699));
})() > (function (){var G__9700 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9700) : k.call(null,G__9700));
})())){
return x;
} else {
return y;
}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__9691_SHARP_,p2__9692_SHARP_){
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,p1__9691_SHARP_,p2__9692_SHARP_);
}),cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.max_key.cljs$lang$applyTo = (function (seq9693){
var G__9694 = cljs.core.first(seq9693);
var seq9693__$1 = cljs.core.next(seq9693);
var G__9695 = cljs.core.first(seq9693__$1);
var seq9693__$2 = cljs.core.next(seq9693__$1);
var G__9696 = cljs.core.first(seq9693__$2);
var seq9693__$3 = cljs.core.next(seq9693__$2);
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(G__9694,G__9695,G__9696,seq9693__$3);
});

cljs.core.max_key.cljs$lang$maxFixedArity = 3;
/**
 * Returns the x for which (k x), a number, is least.
 */
cljs.core.min_key = (function cljs$core$min_key(){
var G__9709 = arguments.length;
switch (G__9709) {
case 2:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4941__auto__);

}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((function (){var G__9710 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9710) : k.call(null,G__9710));
})() < (function (){var G__9711 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9711) : k.call(null,G__9711));
})())){
return x;
} else {
return y;
}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__9702_SHARP_,p2__9703_SHARP_){
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,p1__9702_SHARP_,p2__9703_SHARP_);
}),cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.min_key.cljs$lang$applyTo = (function (seq9704){
var G__9705 = cljs.core.first(seq9704);
var seq9704__$1 = cljs.core.next(seq9704);
var G__9706 = cljs.core.first(seq9704__$1);
var seq9704__$2 = cljs.core.next(seq9704__$1);
var G__9707 = cljs.core.first(seq9704__$2);
var seq9704__$3 = cljs.core.next(seq9704__$2);
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(G__9705,G__9706,G__9707,seq9704__$3);
});

cljs.core.min_key.cljs$lang$maxFixedArity = 3;

/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
})
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/ArrayList");
});

cljs.core.__GT_ArrayList = (function cljs$core$__GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function cljs$core$array_list(){
return (new cljs.core.ArrayList([]));
});
/**
 * Returns a lazy sequence of lists like partition, but may include
 * partitions with fewer than n items at the end.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_all = (function cljs$core$partition_all(){
var G__9714 = arguments.length;
switch (G__9714) {
case 1:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__9721 = null;
var G__9721__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9721__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__9715 = result;
var G__9716 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9715,G__9716) : rf.call(null,G__9715,G__9716));
})());
})());
var G__9717 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9717) : rf.call(null,G__9717));
});
var G__9721__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

var G__9718 = result;
var G__9719 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9718,G__9719) : rf.call(null,G__9718,G__9719));
} else {
return result;
}
});
G__9721 = function(result,input){
switch(arguments.length){
case 0:
return G__9721__0.call(this);
case 1:
return G__9721__1.call(this,result);
case 2:
return G__9721__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9721.cljs$core$IFn$_invoke$arity$0 = G__9721__0;
G__9721.cljs$core$IFn$_invoke$arity$1 = G__9721__1;
G__9721.cljs$core$IFn$_invoke$arity$2 = G__9721__2;
return G__9721;
})()
;})(a))
});
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4404__auto__ = cljs.core.seq(coll);
if(temp__4404__auto__){
var s = temp__4404__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_all.cljs$lang$maxFixedArity = 3;
/**
 * Returns a lazy sequence of successive items from coll while
 * (pred item) returns true. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.take_while = (function cljs$core$take_while(){
var G__9723 = arguments.length;
switch (G__9723) {
case 1:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__9730 = null;
var G__9730__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9730__1 = (function (result){
var G__9724 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9724) : rf.call(null,G__9724));
});
var G__9730__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__9725 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9725) : pred.call(null,G__9725));
})())){
var G__9726 = result;
var G__9727 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9726,G__9727) : rf.call(null,G__9726,G__9727));
} else {
return cljs.core.reduced(result);
}
});
G__9730 = function(result,input){
switch(arguments.length){
case 0:
return G__9730__0.call(this);
case 1:
return G__9730__1.call(this,result);
case 2:
return G__9730__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9730.cljs$core$IFn$_invoke$arity$0 = G__9730__0;
G__9730.cljs$core$IFn$_invoke$arity$1 = G__9730__1;
G__9730.cljs$core$IFn$_invoke$arity$2 = G__9730__2;
return G__9730;
})()
});
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4404__auto__ = cljs.core.seq(coll);
if(temp__4404__auto__){
var s = temp__4404__auto__;
if(cljs.core.truth_((function (){var G__9728 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9728) : pred.call(null,G__9728));
})())){
return cljs.core.cons(cljs.core.first(s),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take_while.cljs$lang$maxFixedArity = 2;
cljs.core.mk_bound_fn = (function cljs$core$mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__9735 = (function (){var G__9737 = cljs.core._entry_key(sc,e);
var G__9738 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9737,G__9738) : comp.call(null,G__9737,G__9738));
})();
var G__9736 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__9735,G__9736) : test.call(null,G__9735,G__9736));
});
});
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 * >=. Returns a seq of those entries with keys ek for
 * which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.subseq = (function cljs$core$subseq(){
var G__9740 = arguments.length;
switch (G__9740) {
case 3:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_,cljs.core._GT__EQ_], true).call(null,test))){
var temp__4404__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__4404__auto__)){
var vec__9741 = temp__4404__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9741,(0),null);
var s = vec__9741;
if(cljs.core.truth_((function (){var G__9742 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__9742) : include.call(null,G__9742));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4404__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__4404__auto__)){
var vec__9743 = temp__4404__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9743,(0),null);
var s = vec__9743;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,start_test,start_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.subseq.cljs$lang$maxFixedArity = 5;
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 * >=. Returns a reverse seq of those entries with keys ek for
 * which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.rsubseq = (function cljs$core$rsubseq(){
var G__9746 = arguments.length;
switch (G__9746) {
case 3:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_,cljs.core._LT__EQ_], true).call(null,test))){
var temp__4404__auto__ = cljs.core._sorted_seq_from(sc,key,false);
if(cljs.core.truth_(temp__4404__auto__)){
var vec__9747 = temp__4404__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9747,(0),null);
var s = vec__9747;
if(cljs.core.truth_((function (){var G__9748 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__9748) : include.call(null,G__9748));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,false));
}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4404__auto__ = cljs.core._sorted_seq_from(sc,end_key,false);
if(cljs.core.truth_(temp__4404__auto__)){
var vec__9749 = temp__4404__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9749,(0),null);
var s = vec__9749;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,end_test,end_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.rsubseq.cljs$lang$maxFixedArity = 5;

/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
})
cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
});

cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
self__.i = (self__.i + self__.step);

return ret;
});

cljs.core.RangeIterator.cljs$lang$type = true;

cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";

cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/RangeIterator");
});

cljs.core.__GT_RangeIterator = (function cljs$core$__GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
return not_found;
}
}
});

cljs.core.Range.prototype.cljs$core$IIterable$ = true;

cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
});

cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
});

cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(cljs.core.not(cljs.core._seq(rng__$1))){
return (0);
} else {
var G__9751 = ((self__.end - self__.start) / self__.step);
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__9751) : Math.ceil.call(null,G__9751));
}
});

cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__4305__auto__ = self__.__hash;
if(!((h__4305__auto__ == null))){
return h__4305__auto__;
} else {
var h__4305__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
self__.__hash = h__4305__auto____$1;

return h__4305__auto____$1;
}
});

cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential(rng__$1,other);
});

cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1,f);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = (function (){var G__9752 = ret;
var G__9753 = i;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9752,G__9753) : f.call(null,G__9752,G__9753));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
var G__9754 = ret__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9754) : cljs.core.deref.call(null,G__9754));
} else {
var G__9755 = (i + self__.step);
var G__9756 = ret__$1;
i = G__9755;
ret = G__9756;
continue;
}
} else {
return ret;
}
break;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((cljs.core._seq(rng__$1) == null)){
return null;
} else {
return self__.start;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(!((cljs.core._seq(rng__$1) == null))){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if((self__.start < self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.start > self__.end)){
return rng__$1;
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta__$1){
var self__ = this;
var rng__$1 = this;
return (new cljs.core.Range(meta__$1,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons(o,rng__$1);
});

cljs.core.Range.cljs$lang$type = true;

cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";

cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/Range");
});

cljs.core.__GT_Range = (function cljs$core$__GT_Range(meta,start,end,step,__hash){
return (new cljs.core.Range(meta,start,end,step,__hash));
});

(cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
/**
 * Returns a lazy seq of nums from start (inclusive) to end
 * (exclusive), by step, where start defaults to 0, step to 1,
 * and end to infinity.
 */
cljs.core.range = (function cljs$core$range(){
var G__9758 = arguments.length;
switch (G__9758) {
case 0:
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.range.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),Number.MAX_VALUE,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$1 = (function (end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});

cljs.core.range.cljs$lang$maxFixedArity = 3;
/**
 * Returns a lazy seq of every nth item in coll.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.take_nth = (function cljs$core$take_nth(){
var G__9761 = arguments.length;
switch (G__9761) {
case 1:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__9766 = null;
var G__9766__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9766__1 = (function (result){
var G__9762 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9762) : rf.call(null,G__9762));
});
var G__9766__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
if((cljs.core.rem(i,n) === (0))){
var G__9763 = result;
var G__9764 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9763,G__9764) : rf.call(null,G__9763,G__9764));
} else {
return result;
}
});
G__9766 = function(result,input){
switch(arguments.length){
case 0:
return G__9766__0.call(this);
case 1:
return G__9766__1.call(this,result);
case 2:
return G__9766__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9766.cljs$core$IFn$_invoke$arity$0 = G__9766__0;
G__9766.cljs$core$IFn$_invoke$arity$1 = G__9766__1;
G__9766.cljs$core$IFn$_invoke$arity$2 = G__9766__2;
return G__9766;
})()
;})(ia))
});
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4404__auto__ = cljs.core.seq(coll);
if(temp__4404__auto__){
var s = temp__4404__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2(n,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.take_nth.cljs$lang$maxFixedArity = 2;
/**
 * Returns a vector of [(take-while pred coll) (drop-while pred coll)]
 */
cljs.core.split_with = (function cljs$core$split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,coll),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred,coll)], null);
});
/**
 * Applies f to each value in coll, splitting it each time f returns a
 * new value.  Returns a lazy seq of partitions.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_by = (function cljs$core$partition_by(){
var G__9769 = arguments.length;
switch (G__9769) {
case 1:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var a = cljs.core.array_list();
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (a,pa){
return (function() {
var G__9780 = null;
var G__9780__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9780__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__9770 = result;
var G__9771 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9770,G__9771) : rf.call(null,G__9770,G__9771));
})());
})());
var G__9772 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9772) : rf.call(null,G__9772));
});
var G__9780__2 = (function (result,input){
var pval = (function (){var G__9773 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9773) : cljs.core.deref.call(null,G__9773));
})();
var val = (function (){var G__9774 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9774) : f.call(null,G__9774));
})();
cljs.core.vreset_BANG_(pa,val);

if((cljs.core.keyword_identical_QMARK_(pval,new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,pval))){
a.add(input);

return result;
} else {
var v = cljs.core.vec(a.toArray());
a.clear();

var ret = (function (){var G__9775 = result;
var G__9776 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9775,G__9776) : rf.call(null,G__9775,G__9776));
})();
if(cljs.core.reduced_QMARK_(ret)){
} else {
a.add(input);
}

return ret;
}
});
G__9780 = function(result,input){
switch(arguments.length){
case 0:
return G__9780__0.call(this);
case 1:
return G__9780__1.call(this,result);
case 2:
return G__9780__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9780.cljs$core$IFn$_invoke$arity$0 = G__9780__0;
G__9780.cljs$core$IFn$_invoke$arity$1 = G__9780__1;
G__9780.cljs$core$IFn$_invoke$arity$2 = G__9780__2;
return G__9780;
})()
;})(a,pa))
});
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4404__auto__ = cljs.core.seq(coll);
if(temp__4404__auto__){
var s = temp__4404__auto__;
var fst = cljs.core.first(s);
var fv = (function (){var G__9777 = fst;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9777) : f.call(null,G__9777));
})();
var run = cljs.core.cons(fst,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (fst,fv,s,temp__4404__auto__){
return (function (p1__9767_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv,(function (){var G__9778 = p1__9767_SHARP_;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9778) : f.call(null,G__9778));
})());
});})(fst,fv,s,temp__4404__auto__))
,cljs.core.next(s)));
return cljs.core.cons(run,cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run),s))));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_by.cljs$lang$maxFixedArity = 2;
/**
 * Returns a map from distinct items in coll to the number of times
 * they appear.
 */
cljs.core.frequencies = (function cljs$core$frequencies(coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (counts,x){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts,x,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts,x,(0)) + (1)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Returns a lazy seq of the intermediate values of the reduction (as
 * per reduce) of coll by f, starting with init.
 */
cljs.core.reductions = (function cljs$core$reductions(){
var G__9782 = arguments.length;
switch (G__9782) {
case 2:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4402__auto__ = cljs.core.seq(coll);
if(temp__4402__auto__){
var s = temp__4402__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.rest(s));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
}
}),null,null));
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$3 = (function (f,init,coll){
return cljs.core.cons(init,(new cljs.core.LazySeq(null,(function (){
var temp__4404__auto__ = cljs.core.seq(coll);
if(temp__4404__auto__){
var s = temp__4404__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,(function (){var G__9783 = init;
var G__9784 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9783,G__9784) : f.call(null,G__9783,G__9784));
})(),cljs.core.rest(s));
} else {
return null;
}
}),null,null)));
});

cljs.core.reductions.cljs$lang$maxFixedArity = 3;
/**
 * Takes a set of functions and returns a fn that is the juxtaposition
 * of those fns.  The returned fn takes a variable number of args, and
 * returns a vector containing the result of applying each fn to the
 * args (left-to-right).
 * ((juxt a b c) x) => [(a x) (b x) (c x)]
 */
cljs.core.juxt = (function cljs$core$juxt(){
var G__9801 = arguments.length;
switch (G__9801) {
case 1:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4941__auto__);

}
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function() {
var G__9845 = null;
var G__9845__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})()],null));
});
var G__9845__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9802 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9802) : f.call(null,G__9802));
})()],null));
});
var G__9845__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9803 = x;
var G__9804 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9803,G__9804) : f.call(null,G__9803,G__9804));
})()],null));
});
var G__9845__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9805 = x;
var G__9806 = y;
var G__9807 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9805,G__9806,G__9807) : f.call(null,G__9805,G__9806,G__9807));
})()],null));
});
var G__9845__4 = (function() { 
var G__9846__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args)],null));
};
var G__9846 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9847__i = 0, G__9847__a = new Array(arguments.length -  3);
while (G__9847__i < G__9847__a.length) {G__9847__a[G__9847__i] = arguments[G__9847__i + 3]; ++G__9847__i;}
  args = new cljs.core.IndexedSeq(G__9847__a,0);
} 
return G__9846__delegate.call(this,x,y,z,args);};
G__9846.cljs$lang$maxFixedArity = 3;
G__9846.cljs$lang$applyTo = (function (arglist__9848){
var x = cljs.core.first(arglist__9848);
arglist__9848 = cljs.core.next(arglist__9848);
var y = cljs.core.first(arglist__9848);
arglist__9848 = cljs.core.next(arglist__9848);
var z = cljs.core.first(arglist__9848);
var args = cljs.core.rest(arglist__9848);
return G__9846__delegate(x,y,z,args);
});
G__9846.cljs$core$IFn$_invoke$arity$variadic = G__9846__delegate;
return G__9846;
})()
;
G__9845 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9845__0.call(this);
case 1:
return G__9845__1.call(this,x);
case 2:
return G__9845__2.call(this,x,y);
case 3:
return G__9845__3.call(this,x,y,z);
default:
var G__9849 = null;
if (arguments.length > 3) {
var G__9850__i = 0, G__9850__a = new Array(arguments.length -  3);
while (G__9850__i < G__9850__a.length) {G__9850__a[G__9850__i] = arguments[G__9850__i + 3]; ++G__9850__i;}
G__9849 = new cljs.core.IndexedSeq(G__9850__a,0);
}
return G__9845__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9845.cljs$lang$maxFixedArity = 3;
G__9845.cljs$lang$applyTo = G__9845__4.cljs$lang$applyTo;
G__9845.cljs$core$IFn$_invoke$arity$0 = G__9845__0;
G__9845.cljs$core$IFn$_invoke$arity$1 = G__9845__1;
G__9845.cljs$core$IFn$_invoke$arity$2 = G__9845__2;
G__9845.cljs$core$IFn$_invoke$arity$3 = G__9845__3;
G__9845.cljs$core$IFn$_invoke$arity$variadic = G__9845__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9845;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__9851 = null;
var G__9851__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})()],null));
});
var G__9851__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9808 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9808) : f.call(null,G__9808));
})(),(function (){var G__9809 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9809) : g.call(null,G__9809));
})()],null));
});
var G__9851__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9810 = x;
var G__9811 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9810,G__9811) : f.call(null,G__9810,G__9811));
})(),(function (){var G__9812 = x;
var G__9813 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__9812,G__9813) : g.call(null,G__9812,G__9813));
})()],null));
});
var G__9851__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9814 = x;
var G__9815 = y;
var G__9816 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9814,G__9815,G__9816) : f.call(null,G__9814,G__9815,G__9816));
})(),(function (){var G__9817 = x;
var G__9818 = y;
var G__9819 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__9817,G__9818,G__9819) : g.call(null,G__9817,G__9818,G__9819));
})()],null));
});
var G__9851__4 = (function() { 
var G__9852__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args)],null));
};
var G__9852 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9853__i = 0, G__9853__a = new Array(arguments.length -  3);
while (G__9853__i < G__9853__a.length) {G__9853__a[G__9853__i] = arguments[G__9853__i + 3]; ++G__9853__i;}
  args = new cljs.core.IndexedSeq(G__9853__a,0);
} 
return G__9852__delegate.call(this,x,y,z,args);};
G__9852.cljs$lang$maxFixedArity = 3;
G__9852.cljs$lang$applyTo = (function (arglist__9854){
var x = cljs.core.first(arglist__9854);
arglist__9854 = cljs.core.next(arglist__9854);
var y = cljs.core.first(arglist__9854);
arglist__9854 = cljs.core.next(arglist__9854);
var z = cljs.core.first(arglist__9854);
var args = cljs.core.rest(arglist__9854);
return G__9852__delegate(x,y,z,args);
});
G__9852.cljs$core$IFn$_invoke$arity$variadic = G__9852__delegate;
return G__9852;
})()
;
G__9851 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9851__0.call(this);
case 1:
return G__9851__1.call(this,x);
case 2:
return G__9851__2.call(this,x,y);
case 3:
return G__9851__3.call(this,x,y,z);
default:
var G__9855 = null;
if (arguments.length > 3) {
var G__9856__i = 0, G__9856__a = new Array(arguments.length -  3);
while (G__9856__i < G__9856__a.length) {G__9856__a[G__9856__i] = arguments[G__9856__i + 3]; ++G__9856__i;}
G__9855 = new cljs.core.IndexedSeq(G__9856__a,0);
}
return G__9851__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9851.cljs$lang$maxFixedArity = 3;
G__9851.cljs$lang$applyTo = G__9851__4.cljs$lang$applyTo;
G__9851.cljs$core$IFn$_invoke$arity$0 = G__9851__0;
G__9851.cljs$core$IFn$_invoke$arity$1 = G__9851__1;
G__9851.cljs$core$IFn$_invoke$arity$2 = G__9851__2;
G__9851.cljs$core$IFn$_invoke$arity$3 = G__9851__3;
G__9851.cljs$core$IFn$_invoke$arity$variadic = G__9851__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9851;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__9857 = null;
var G__9857__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})(),(function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})()],null));
});
var G__9857__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9820 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9820) : f.call(null,G__9820));
})(),(function (){var G__9821 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9821) : g.call(null,G__9821));
})(),(function (){var G__9822 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__9822) : h.call(null,G__9822));
})()],null));
});
var G__9857__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9823 = x;
var G__9824 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9823,G__9824) : f.call(null,G__9823,G__9824));
})(),(function (){var G__9825 = x;
var G__9826 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__9825,G__9826) : g.call(null,G__9825,G__9826));
})(),(function (){var G__9827 = x;
var G__9828 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__9827,G__9828) : h.call(null,G__9827,G__9828));
})()],null));
});
var G__9857__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9829 = x;
var G__9830 = y;
var G__9831 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9829,G__9830,G__9831) : f.call(null,G__9829,G__9830,G__9831));
})(),(function (){var G__9832 = x;
var G__9833 = y;
var G__9834 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__9832,G__9833,G__9834) : g.call(null,G__9832,G__9833,G__9834));
})(),(function (){var G__9835 = x;
var G__9836 = y;
var G__9837 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__9835,G__9836,G__9837) : h.call(null,G__9835,G__9836,G__9837));
})()],null));
});
var G__9857__4 = (function() { 
var G__9858__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args)],null));
};
var G__9858 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9859__i = 0, G__9859__a = new Array(arguments.length -  3);
while (G__9859__i < G__9859__a.length) {G__9859__a[G__9859__i] = arguments[G__9859__i + 3]; ++G__9859__i;}
  args = new cljs.core.IndexedSeq(G__9859__a,0);
} 
return G__9858__delegate.call(this,x,y,z,args);};
G__9858.cljs$lang$maxFixedArity = 3;
G__9858.cljs$lang$applyTo = (function (arglist__9860){
var x = cljs.core.first(arglist__9860);
arglist__9860 = cljs.core.next(arglist__9860);
var y = cljs.core.first(arglist__9860);
arglist__9860 = cljs.core.next(arglist__9860);
var z = cljs.core.first(arglist__9860);
var args = cljs.core.rest(arglist__9860);
return G__9858__delegate(x,y,z,args);
});
G__9858.cljs$core$IFn$_invoke$arity$variadic = G__9858__delegate;
return G__9858;
})()
;
G__9857 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9857__0.call(this);
case 1:
return G__9857__1.call(this,x);
case 2:
return G__9857__2.call(this,x,y);
case 3:
return G__9857__3.call(this,x,y,z);
default:
var G__9861 = null;
if (arguments.length > 3) {
var G__9862__i = 0, G__9862__a = new Array(arguments.length -  3);
while (G__9862__i < G__9862__a.length) {G__9862__a[G__9862__i] = arguments[G__9862__i + 3]; ++G__9862__i;}
G__9861 = new cljs.core.IndexedSeq(G__9862__a,0);
}
return G__9857__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9857.cljs$lang$maxFixedArity = 3;
G__9857.cljs$lang$applyTo = G__9857__4.cljs$lang$applyTo;
G__9857.cljs$core$IFn$_invoke$arity$0 = G__9857__0;
G__9857.cljs$core$IFn$_invoke$arity$1 = G__9857__1;
G__9857.cljs$core$IFn$_invoke$arity$2 = G__9857__2;
G__9857.cljs$core$IFn$_invoke$arity$3 = G__9857__3;
G__9857.cljs$core$IFn$_invoke$arity$variadic = G__9857__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9857;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic = (function (f,g,h,fs){
var fs__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f,g,h,fs);
return ((function (fs__$1){
return (function() {
var G__9863 = null;
var G__9863__0 = (function (){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9786_SHARP_,p2__9787_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9786_SHARP_,(function (){return (p2__9787_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p2__9787_SHARP_.cljs$core$IFn$_invoke$arity$0() : p2__9787_SHARP_.call(null));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9863__1 = (function (x){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9788_SHARP_,p2__9789_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9788_SHARP_,(function (){var G__9838 = x;
return (p2__9789_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p2__9789_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9838) : p2__9789_SHARP_.call(null,G__9838));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9863__2 = (function (x,y){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9790_SHARP_,p2__9791_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9790_SHARP_,(function (){var G__9839 = x;
var G__9840 = y;
return (p2__9791_SHARP_.cljs$core$IFn$_invoke$arity$2 ? p2__9791_SHARP_.cljs$core$IFn$_invoke$arity$2(G__9839,G__9840) : p2__9791_SHARP_.call(null,G__9839,G__9840));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9863__3 = (function (x,y,z){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9792_SHARP_,p2__9793_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9792_SHARP_,(function (){var G__9841 = x;
var G__9842 = y;
var G__9843 = z;
return (p2__9793_SHARP_.cljs$core$IFn$_invoke$arity$3 ? p2__9793_SHARP_.cljs$core$IFn$_invoke$arity$3(G__9841,G__9842,G__9843) : p2__9793_SHARP_.call(null,G__9841,G__9842,G__9843));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9863__4 = (function() { 
var G__9864__delegate = function (x,y,z,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9794_SHARP_,p2__9795_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9794_SHARP_,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(p2__9795_SHARP_,x,y,z,args));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
};
var G__9864 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9865__i = 0, G__9865__a = new Array(arguments.length -  3);
while (G__9865__i < G__9865__a.length) {G__9865__a[G__9865__i] = arguments[G__9865__i + 3]; ++G__9865__i;}
  args = new cljs.core.IndexedSeq(G__9865__a,0);
} 
return G__9864__delegate.call(this,x,y,z,args);};
G__9864.cljs$lang$maxFixedArity = 3;
G__9864.cljs$lang$applyTo = (function (arglist__9866){
var x = cljs.core.first(arglist__9866);
arglist__9866 = cljs.core.next(arglist__9866);
var y = cljs.core.first(arglist__9866);
arglist__9866 = cljs.core.next(arglist__9866);
var z = cljs.core.first(arglist__9866);
var args = cljs.core.rest(arglist__9866);
return G__9864__delegate(x,y,z,args);
});
G__9864.cljs$core$IFn$_invoke$arity$variadic = G__9864__delegate;
return G__9864;
})()
;
G__9863 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9863__0.call(this);
case 1:
return G__9863__1.call(this,x);
case 2:
return G__9863__2.call(this,x,y);
case 3:
return G__9863__3.call(this,x,y,z);
default:
var G__9867 = null;
if (arguments.length > 3) {
var G__9868__i = 0, G__9868__a = new Array(arguments.length -  3);
while (G__9868__i < G__9868__a.length) {G__9868__a[G__9868__i] = arguments[G__9868__i + 3]; ++G__9868__i;}
G__9867 = new cljs.core.IndexedSeq(G__9868__a,0);
}
return G__9863__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9863.cljs$lang$maxFixedArity = 3;
G__9863.cljs$lang$applyTo = G__9863__4.cljs$lang$applyTo;
G__9863.cljs$core$IFn$_invoke$arity$0 = G__9863__0;
G__9863.cljs$core$IFn$_invoke$arity$1 = G__9863__1;
G__9863.cljs$core$IFn$_invoke$arity$2 = G__9863__2;
G__9863.cljs$core$IFn$_invoke$arity$3 = G__9863__3;
G__9863.cljs$core$IFn$_invoke$arity$variadic = G__9863__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9863;
})()
;})(fs__$1))
});

cljs.core.juxt.cljs$lang$applyTo = (function (seq9796){
var G__9797 = cljs.core.first(seq9796);
var seq9796__$1 = cljs.core.next(seq9796);
var G__9798 = cljs.core.first(seq9796__$1);
var seq9796__$2 = cljs.core.next(seq9796__$1);
var G__9799 = cljs.core.first(seq9796__$2);
var seq9796__$3 = cljs.core.next(seq9796__$2);
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic(G__9797,G__9798,G__9799,seq9796__$3);
});

cljs.core.juxt.cljs$lang$maxFixedArity = 3;
/**
 * When lazy sequences are produced via functions that have side
 * effects, any effects other than those needed to produce the first
 * element in the seq do not occur until the seq is consumed. dorun can
 * be used to force any effects. Walks through the successive nexts of
 * the seq, does not retain the head and returns nil.
 */
cljs.core.dorun = (function cljs$core$dorun(){
var G__9870 = arguments.length;
switch (G__9870) {
case 1:
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.dorun.cljs$core$IFn$_invoke$arity$1 = (function (coll){
while(true){
if(cljs.core.seq(coll)){
var G__9872 = cljs.core.next(coll);
coll = G__9872;
continue;
} else {
return null;
}
break;
}
});

cljs.core.dorun.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
while(true){
if((cljs.core.seq(coll)) && ((n > (0)))){
var G__9873 = (n - (1));
var G__9874 = cljs.core.next(coll);
n = G__9873;
coll = G__9874;
continue;
} else {
return null;
}
break;
}
});

cljs.core.dorun.cljs$lang$maxFixedArity = 2;
/**
 * When lazy sequences are produced via functions that have side
 * effects, any effects other than those needed to produce the first
 * element in the seq do not occur until the seq is consumed. doall can
 * be used to force any effects. Walks through the successive nexts of
 * the seq, retains the head and returns it, thus causing the entire
 * seq to reside in memory at one time.
 */
cljs.core.doall = (function cljs$core$doall(){
var G__9876 = arguments.length;
switch (G__9876) {
case 1:
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.doall.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.doall.cljs$core$IFn$_invoke$arity$1 = (function (coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(coll);

return coll;
});

cljs.core.doall.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$2(n,coll);

return coll;
});

cljs.core.doall.cljs$lang$maxFixedArity = 2;
/**
 * Returns true if x is a JavaScript RegExp instance.
 */
cljs.core.regexp_QMARK_ = (function cljs$core$regexp_QMARK_(x){
return (x instanceof RegExp);
});
/**
 * Returns the result of (re-find re s) if re fully matches s.
 */
cljs.core.re_matches = (function cljs$core$re_matches(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(matches),s)){
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
} else {
return null;
}
} else {
throw (new TypeError("re-matches must match against a string."));
}
});
/**
 * Returns the first regex match, if any, of s to re, using
 * re.exec(s). Returns a vector, containing first the matching
 * substring, then any capturing groups if the regular expression contains
 * capturing groups.
 */
cljs.core.re_find = (function cljs$core$re_find(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if((matches == null)){
return null;
} else {
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
}
} else {
throw (new TypeError("re-find must match against a string."));
}
});
/**
 * Returns a lazy sequence of successive matches of re in s.
 */
cljs.core.re_seq = (function cljs$core$re_seq(re,s){
var match_data = cljs.core.re_find(re,s);
var match_idx = s.search(re);
var match_str = ((cljs.core.coll_QMARK_(match_data))?cljs.core.first(match_data):match_data);
var post_match = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(match_idx + cljs.core.count(match_str)));
if(cljs.core.truth_(match_data)){
return (new cljs.core.LazySeq(null,((function (match_data,match_idx,match_str,post_match){
return (function (){
return cljs.core.cons(match_data,((cljs.core.seq(post_match))?cljs$core$re_seq(re,post_match):null));
});})(match_data,match_idx,match_str,post_match))
,null,null));
} else {
return null;
}
});
/**
 * Returns an instance of RegExp which has compiled the provided string.
 */
cljs.core.re_pattern = (function cljs$core$re_pattern(s){
if((s instanceof RegExp)){
return s;
} else {
var vec__9881 = cljs.core.re_find(/^\(\?([idmsux]*)\)/,s);
var prefix = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9881,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9881,(1),null);
var pattern = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,cljs.core.count(prefix));
return (new RegExp(pattern,(function (){var or__3889__auto__ = flags;
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return "";
}
})()));
}
});
cljs.core.pr_sequential_writer = (function cljs$core$pr_sequential_writer(writer,print_one,begin,sep,end,opts,coll){
var _STAR_print_level_STAR_9889 = cljs.core._STAR_print_level_STAR_;
cljs.core._STAR_print_level_STAR_ = (((cljs.core._STAR_print_level_STAR_ == null))?null:(cljs.core._STAR_print_level_STAR_ - (1)));

try{if((!((cljs.core._STAR_print_level_STAR_ == null))) && ((cljs.core._STAR_print_level_STAR_ < (0)))){
return cljs.core._write(writer,"#");
} else {
cljs.core._write(writer,begin);

if((new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) === (0))){
if(cljs.core.seq(coll)){
cljs.core._write(writer,(function (){var or__3889__auto__ = new cljs.core.Keyword(null,"more-marker","more-marker",-14717935).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return "...";
}
})());
} else {
}
} else {
if(cljs.core.seq(coll)){
var G__9890_9896 = cljs.core.first(coll);
var G__9891_9897 = writer;
var G__9892_9898 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__9890_9896,G__9891_9897,G__9892_9898) : print_one.call(null,G__9890_9896,G__9891_9897,G__9892_9898));
} else {
}

var coll_9899__$1 = cljs.core.next(coll);
var n_9900 = (new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) - (1));
while(true){
if((coll_9899__$1) && (((n_9900 == null)) || (!((n_9900 === (0)))))){
cljs.core._write(writer,sep);

var G__9893_9901 = cljs.core.first(coll_9899__$1);
var G__9894_9902 = writer;
var G__9895_9903 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__9893_9901,G__9894_9902,G__9895_9903) : print_one.call(null,G__9893_9901,G__9894_9902,G__9895_9903));

var G__9904 = cljs.core.next(coll_9899__$1);
var G__9905 = (n_9900 - (1));
coll_9899__$1 = G__9904;
n_9900 = G__9905;
continue;
} else {
if((cljs.core.seq(coll_9899__$1)) && ((n_9900 === (0)))){
cljs.core._write(writer,sep);

cljs.core._write(writer,(function (){var or__3889__auto__ = new cljs.core.Keyword(null,"more-marker","more-marker",-14717935).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return "...";
}
})());
} else {
}
}
break;
}
}

return cljs.core._write(writer,end);
}
}finally {cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_9889;
}});
cljs.core.write_all = (function cljs$core$write_all(){
var argseq__4929__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4929__auto__);
});

cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic = (function (writer,ss){
var seq__9908 = cljs.core.seq(ss);
var chunk__9909 = null;
var count__9910 = (0);
var i__9911 = (0);
while(true){
if((i__9911 < count__9910)){
var s = chunk__9909.cljs$core$IIndexed$_nth$arity$2(null,i__9911);
cljs.core._write(writer,s);

var G__9912 = seq__9908;
var G__9913 = chunk__9909;
var G__9914 = count__9910;
var G__9915 = (i__9911 + (1));
seq__9908 = G__9912;
chunk__9909 = G__9913;
count__9910 = G__9914;
i__9911 = G__9915;
continue;
} else {
var temp__4404__auto__ = cljs.core.seq(seq__9908);
if(temp__4404__auto__){
var seq__9908__$1 = temp__4404__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9908__$1)){
var c__4674__auto__ = cljs.core.chunk_first(seq__9908__$1);
var G__9916 = cljs.core.chunk_rest(seq__9908__$1);
var G__9917 = c__4674__auto__;
var G__9918 = cljs.core.count(c__4674__auto__);
var G__9919 = (0);
seq__9908 = G__9916;
chunk__9909 = G__9917;
count__9910 = G__9918;
i__9911 = G__9919;
continue;
} else {
var s = cljs.core.first(seq__9908__$1);
cljs.core._write(writer,s);

var G__9920 = cljs.core.next(seq__9908__$1);
var G__9921 = null;
var G__9922 = (0);
var G__9923 = (0);
seq__9908 = G__9920;
chunk__9909 = G__9921;
count__9910 = G__9922;
i__9911 = G__9923;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.write_all.cljs$lang$maxFixedArity = (1);

cljs.core.write_all.cljs$lang$applyTo = (function (seq9906){
var G__9907 = cljs.core.first(seq9906);
var seq9906__$1 = cljs.core.next(seq9906);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(G__9907,seq9906__$1);
});
cljs.core.string_print = (function cljs$core$string_print(x){
(cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.core._STAR_print_fn_STAR_.call(null,x));

return null;
});
cljs.core.flush = (function cljs$core$flush(){
return null;
});
cljs.core.char_escapes = (function (){var obj9925 = {"\"":"\\\"","\\":"\\\\","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};
return obj9925;
})();
cljs.core.quote_string = (function cljs$core$quote_string(s){
return [cljs.core.str("\""),cljs.core.str(s.replace((function (){var G__9928 = "[\\\\\"\b\f\n\r\t]";
var G__9929 = "g";
return RegExp(G__9928,G__9929);
})(),(function (match){
return (cljs.core.char_escapes[match]);
}))),cljs.core.str("\"")].join('');
});
cljs.core.pr_writer_impl = (function cljs$core$pr_writer_impl(obj,writer,opts){
if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if((void 0 === obj)){
return cljs.core._write(writer,"#<undefined>");
} else {
if(cljs.core.truth_((function (){var and__3877__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.core.truth_(and__3877__auto__)){
var and__3877__auto____$1 = (function (){var G__9943 = obj;
if(G__9943){
var bit__4563__auto__ = (G__9943.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4563__auto__) || (G__9943.cljs$core$IMeta$)){
return true;
} else {
if((!G__9943.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__9943);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__9943);
}
})();
if(and__3877__auto____$1){
return cljs.core.meta(obj);
} else {
return and__3877__auto____$1;
}
} else {
return and__3877__auto__;
}
})())){
cljs.core._write(writer,"^");

var G__9944_9954 = cljs.core.meta(obj);
var G__9945_9955 = writer;
var G__9946_9956 = opts;
(cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3(G__9944_9954,G__9945_9955,G__9946_9956) : cljs.core.pr_writer.call(null,G__9944_9954,G__9945_9955,G__9946_9956));

cljs.core._write(writer," ");
} else {
}

if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if(obj.cljs$lang$type){
return obj.cljs$lang$ctorPrWriter(obj,writer,opts);
} else {
if((function (){var G__9947 = obj;
if(G__9947){
var bit__4556__auto__ = (G__9947.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4556__auto__) || (G__9947.cljs$core$IPrintWithWriter$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,opts);
} else {
if(((cljs.core.type(obj) === Boolean)) || (typeof obj === 'number')){
return cljs.core._write(writer,[cljs.core.str(obj)].join(''));
} else {
if(cljs.core.object_QMARK_(obj)){
cljs.core._write(writer,"#js ");

var G__9948 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (k){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),(obj[k])], null);
}),cljs.core.js_keys(obj));
var G__9949 = cljs.core.pr_writer;
var G__9950 = writer;
var G__9951 = opts;
return (cljs.core.print_map.cljs$core$IFn$_invoke$arity$4 ? cljs.core.print_map.cljs$core$IFn$_invoke$arity$4(G__9948,G__9949,G__9950,G__9951) : cljs.core.print_map.call(null,G__9948,G__9949,G__9950,G__9951));
} else {
if(cljs.core.array_QMARK_(obj)){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#js ["," ","]",opts,obj);
} else {
if(cljs.core.truth_((function (){var G__9952 = obj;
return goog.isString(G__9952);
})())){
if(cljs.core.truth_(new cljs.core.Keyword(null,"readably","readably",1129599760).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core._write(writer,cljs.core.quote_string(obj));
} else {
return cljs.core._write(writer,obj);
}
} else {
if(cljs.core.fn_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));
} else {
if((obj instanceof Date)){
var normalize = (function (n,len){
var ns = [cljs.core.str(n)].join('');
while(true){
if((cljs.core.count(ns) < len)){
var G__9957 = [cljs.core.str("0"),cljs.core.str(ns)].join('');
ns = G__9957;
continue;
} else {
return ns;
}
break;
}
});
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#inst \"",[cljs.core.str(obj.getUTCFullYear())].join(''),"-",normalize((obj.getUTCMonth() + (1)),(2)),"-",normalize(obj.getUTCDate(),(2)),"T",normalize(obj.getUTCHours(),(2)),":",normalize(obj.getUTCMinutes(),(2)),":",normalize(obj.getUTCSeconds(),(2)),".",normalize(obj.getUTCMilliseconds(),(3)),"-","00:00\""], 0));
} else {
if(cljs.core.truth_(cljs.core.regexp_QMARK_(obj))){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#\"",obj.source,"\""], 0));
} else {
if((function (){var G__9953 = obj;
if(G__9953){
var bit__4563__auto__ = (G__9953.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4563__auto__) || (G__9953.cljs$core$IPrintWithWriter$)){
return true;
} else {
if((!G__9953.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__9953);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__9953);
}
})()){
return cljs.core._pr_writer(obj,writer,opts);
} else {
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));

}
}
}
}
}
}
}
}
}
}
}

}
}
});
/**
 * Prefer this to pr-seq, because it makes the printing function
 * configurable, allowing efficient implementations such as appending
 * to a StringBuffer.
 */
cljs.core.pr_writer = (function cljs$core$pr_writer(obj,writer,opts){
var temp__4402__auto__ = new cljs.core.Keyword(null,"alt-impl","alt-impl",670969595).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4402__auto__)){
var alt_impl = temp__4402__auto__;
var G__9961 = obj;
var G__9962 = writer;
var G__9963 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"fallback-impl","fallback-impl",-1501286995),cljs.core.pr_writer_impl);
return (alt_impl.cljs$core$IFn$_invoke$arity$3 ? alt_impl.cljs$core$IFn$_invoke$arity$3(G__9961,G__9962,G__9963) : alt_impl.call(null,G__9961,G__9962,G__9963));
} else {
return cljs.core.pr_writer_impl(obj,writer,opts);
}
});
cljs.core.pr_seq_writer = (function cljs$core$pr_seq_writer(objs,writer,opts){
cljs.core.pr_writer(cljs.core.first(objs),writer,opts);

var seq__9968 = cljs.core.seq(cljs.core.next(objs));
var chunk__9969 = null;
var count__9970 = (0);
var i__9971 = (0);
while(true){
if((i__9971 < count__9970)){
var obj = chunk__9969.cljs$core$IIndexed$_nth$arity$2(null,i__9971);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__9972 = seq__9968;
var G__9973 = chunk__9969;
var G__9974 = count__9970;
var G__9975 = (i__9971 + (1));
seq__9968 = G__9972;
chunk__9969 = G__9973;
count__9970 = G__9974;
i__9971 = G__9975;
continue;
} else {
var temp__4404__auto__ = cljs.core.seq(seq__9968);
if(temp__4404__auto__){
var seq__9968__$1 = temp__4404__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9968__$1)){
var c__4674__auto__ = cljs.core.chunk_first(seq__9968__$1);
var G__9976 = cljs.core.chunk_rest(seq__9968__$1);
var G__9977 = c__4674__auto__;
var G__9978 = cljs.core.count(c__4674__auto__);
var G__9979 = (0);
seq__9968 = G__9976;
chunk__9969 = G__9977;
count__9970 = G__9978;
i__9971 = G__9979;
continue;
} else {
var obj = cljs.core.first(seq__9968__$1);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__9980 = cljs.core.next(seq__9968__$1);
var G__9981 = null;
var G__9982 = (0);
var G__9983 = (0);
seq__9968 = G__9980;
chunk__9969 = G__9981;
count__9970 = G__9982;
i__9971 = G__9983;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.core.pr_sb_with_opts = (function cljs$core$pr_sb_with_opts(objs,opts){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
cljs.core.pr_seq_writer(objs,writer,opts);

writer.cljs$core$IWriter$_flush$arity$1(null);

return sb;
});
/**
 * Prints a sequence of objects to a string, observing all the
 * options given in opts
 */
cljs.core.pr_str_with_opts = (function cljs$core$pr_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "";
} else {
return [cljs.core.str(cljs.core.pr_sb_with_opts(objs,opts))].join('');
}
});
/**
 * Same as pr-str-with-opts followed by (newline)
 */
cljs.core.prn_str_with_opts = (function cljs$core$prn_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "\n";
} else {
var sb = cljs.core.pr_sb_with_opts(objs,opts);
sb.append("\n");

return [cljs.core.str(sb)].join('');
}
});
/**
 * Prints a sequence of objects using string-print, observing all
 * the options given in opts
 */
cljs.core.pr_with_opts = (function cljs$core$pr_with_opts(objs,opts){
return cljs.core.string_print(cljs.core.pr_str_with_opts(objs,opts));
});
cljs.core.newline = (function cljs$core$newline(opts){
cljs.core.string_print("\n");

if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939)))){
return cljs.core.flush();
} else {
return null;
}
});
/**
 * pr to a string, returning it. Fundamental entrypoint to IPrintWithWriter.
 */
cljs.core.pr_str = (function cljs$core$pr_str(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.pr_str.cljs$lang$maxFixedArity = (0);

cljs.core.pr_str.cljs$lang$applyTo = (function (seq9984){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9984));
});
/**
 * Same as pr-str followed by (newline)
 */
cljs.core.prn_str = (function cljs$core$prn_str(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.prn_str.cljs$lang$maxFixedArity = (0);

cljs.core.prn_str.cljs$lang$applyTo = (function (seq9985){
return cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9985));
});
/**
 * Prints the object(s) using string-print.  Prints the
 * object(s), separated by spaces if there is more than one.
 * By default, pr and prn print in a way that objects can be
 * read by the reader
 */
cljs.core.pr = (function cljs$core$pr(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.pr.cljs$lang$maxFixedArity = (0);

cljs.core.pr.cljs$lang$applyTo = (function (seq9986){
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9986));
});
/**
 * Prints the object(s) using string-print.
 * print and println produce output for human consumption.
 * @param {...*} var_args
 */
cljs.core.print = (function() { 
var cljs$core$cljs_core_print__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs$core$cljs_core_print = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__9987__i = 0, G__9987__a = new Array(arguments.length -  0);
while (G__9987__i < G__9987__a.length) {G__9987__a[G__9987__i] = arguments[G__9987__i + 0]; ++G__9987__i;}
  objs = new cljs.core.IndexedSeq(G__9987__a,0);
} 
return cljs$core$cljs_core_print__delegate.call(this,objs);};
cljs$core$cljs_core_print.cljs$lang$maxFixedArity = 0;
cljs$core$cljs_core_print.cljs$lang$applyTo = (function (arglist__9988){
var objs = cljs.core.seq(arglist__9988);
return cljs$core$cljs_core_print__delegate(objs);
});
cljs$core$cljs_core_print.cljs$core$IFn$_invoke$arity$variadic = cljs$core$cljs_core_print__delegate;
return cljs$core$cljs_core_print;
})()
;
/**
 * print to a string, returning it
 */
cljs.core.print_str = (function cljs$core$print_str(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
});

cljs.core.print_str.cljs$lang$maxFixedArity = (0);

cljs.core.print_str.cljs$lang$applyTo = (function (seq9989){
return cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9989));
});
/**
 * Same as print followed by (newline)
 */
cljs.core.println = (function cljs$core$println(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
});

cljs.core.println.cljs$lang$maxFixedArity = (0);

cljs.core.println.cljs$lang$applyTo = (function (seq9990){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9990));
});
/**
 * println to a string, returning it
 */
cljs.core.println_str = (function cljs$core$println_str(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
});

cljs.core.println_str.cljs$lang$maxFixedArity = (0);

cljs.core.println_str.cljs$lang$applyTo = (function (seq9991){
return cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9991));
});
/**
 * Same as pr followed by (newline).
 */
cljs.core.prn = (function cljs$core$prn(){
var argseq__4929__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(argseq__4929__auto__);
});

cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
cljs.core.pr_with_opts(objs,cljs.core.pr_opts());

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
});

cljs.core.prn.cljs$lang$maxFixedArity = (0);

cljs.core.prn.cljs$lang$applyTo = (function (seq9992){
return cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq9992));
});
cljs.core.print_map = (function cljs$core$print_map(m,print_one,writer,opts){
return cljs.core.pr_sequential_writer(writer,(function (e,w,opts__$1){
var G__9999_10005 = cljs.core.key(e);
var G__10000_10006 = w;
var G__10001_10007 = opts__$1;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__9999_10005,G__10000_10006,G__10001_10007) : print_one.call(null,G__9999_10005,G__10000_10006,G__10001_10007));

cljs.core._write(w," ");

var G__10002 = cljs.core.val(e);
var G__10003 = w;
var G__10004 = opts__$1;
return (print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__10002,G__10003,G__10004) : print_one.call(null,G__10002,G__10003,G__10004));
}),"{",", ","}",opts,cljs.core.seq(m));
});
cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Volatile: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#'");

return cljs.core.pr_writer(a__$1.sym,writer,opts);
});

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Atom: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core._write(writer,"()");
});

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#queue ["," ","]",opts,cljs.core.seq(coll__$1));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.List.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.List.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});
cljs.core.Symbol.prototype.cljs$core$IComparable$ = true;

cljs.core.Symbol.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_symbols(x__$1,y);
});

cljs.core.Keyword.prototype.cljs$core$IComparable$ = true;

cljs.core.Keyword.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_keywords(x__$1,y);
});

cljs.core.Subvec.prototype.cljs$core$IComparable$ = true;

cljs.core.Subvec.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});
/**
 * Atomically sets the metadata for a namespace/var/ref/agent/atom to be:
 * 
 * (apply f its-current-meta args)
 * 
 * f must be free of side-effects
 */
cljs.core.alter_meta_BANG_ = (function cljs$core$alter_meta_BANG_(){
var argseq__4929__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4929__auto__);
});

cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (iref,f,args){
return iref.meta = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,iref.meta,args);
});

cljs.core.alter_meta_BANG_.cljs$lang$maxFixedArity = (2);

cljs.core.alter_meta_BANG_.cljs$lang$applyTo = (function (seq10008){
var G__10009 = cljs.core.first(seq10008);
var seq10008__$1 = cljs.core.next(seq10008);
var G__10010 = cljs.core.first(seq10008__$1);
var seq10008__$2 = cljs.core.next(seq10008__$1);
return cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10009,G__10010,seq10008__$2);
});
/**
 * Atomically resets the metadata for an atom
 */
cljs.core.reset_meta_BANG_ = (function cljs$core$reset_meta_BANG_(iref,m){
return iref.meta = m;
});
/**
 * Alpha - subject to change.
 * 
 * Adds a watch function to an atom reference. The watch fn must be a
 * fn of 4 args: a key, the reference, its old-state, its
 * new-state. Whenever the reference's state might have been changed,
 * any registered watches will have their functions called. The watch
 * fn will be called synchronously. Note that an atom's state
 * may have changed again prior to the fn call, so use old/new-state
 * rather than derefing the reference. Keys must be unique per
 * reference, and can be used to remove the watch with remove-watch,
 * but are otherwise considered opaque by the watch mechanism.  Bear in
 * mind that regardless of the result or action of the watch fns the
 * atom's value will change.  Example:
 * 
 * (def a (atom 0))
 * (add-watch a :inc (fn [k r o n] (assert (== 0 n))))
 * (swap! a inc)
 * ;; Assertion Error
 * (deref a)
 * ;=> 1
 */
cljs.core.add_watch = (function cljs$core$add_watch(iref,key,f){
cljs.core._add_watch(iref,key,f);

return iref;
});
/**
 * Alpha - subject to change.
 * 
 * Removes a watch (set by add-watch) from a reference
 */
cljs.core.remove_watch = (function cljs$core$remove_watch(iref,key){
cljs.core._remove_watch(iref,key);

return iref;
});
cljs.core.gensym_counter = null;
/**
 * Returns a new symbol with a unique name. If a prefix string is
 * supplied, the name is prefix# where # is some unique number. If
 * prefix is not supplied, the prefix is 'G__'.
 */
cljs.core.gensym = (function cljs$core$gensym(){
var G__10012 = arguments.length;
switch (G__10012) {
case 0:
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.gensym.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("G__");
});

cljs.core.gensym.cljs$core$IFn$_invoke$arity$1 = (function (prefix_string){
if((cljs.core.gensym_counter == null)){
cljs.core.gensym_counter = (function (){var G__10013 = (0);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10013) : cljs.core.atom.call(null,G__10013));
})();
} else {
}

return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str(prefix_string),cljs.core.str(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.gensym_counter,cljs.core.inc))].join(''));
});

cljs.core.gensym.cljs$lang$maxFixedArity = 1;
cljs.core.fixture1 = (1);
cljs.core.fixture2 = (2);

/**
* @constructor
*/
cljs.core.Delay = (function (f,value){
this.f = f;
this.value = value;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 1;
})
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.f)){
self__.value = (function (){return (self__.f.cljs$core$IFn$_invoke$arity$0 ? self__.f.cljs$core$IFn$_invoke$arity$0() : self__.f.call(null));
})();

self__.f = null;
} else {
}

return self__.value;
});

cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (d){
var self__ = this;
var d__$1 = this;
return cljs.core.not(self__.f);
});

cljs.core.Delay.cljs$lang$type = true;

cljs.core.Delay.cljs$lang$ctorStr = "cljs.core/Delay";

cljs.core.Delay.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/Delay");
});

cljs.core.__GT_Delay = (function cljs$core$__GT_Delay(f,value){
return (new cljs.core.Delay(f,value));
});

/**
 * returns true if x is a Delay created with delay
 */
cljs.core.delay_QMARK_ = (function cljs$core$delay_QMARK_(x){
return (x instanceof cljs.core.Delay);
});
/**
 * If x is a Delay, returns the (possibly cached) value of its expression, else returns x
 */
cljs.core.force = (function cljs$core$force(x){
if(cljs.core.delay_QMARK_(x)){
var G__10016 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10016) : cljs.core.deref.call(null,G__10016));
} else {
return x;
}
});
/**
 * Returns true if a value has been produced for a promise, delay, future or lazy sequence.
 */
cljs.core.realized_QMARK_ = (function cljs$core$realized_QMARK_(d){
return cljs.core._realized_QMARK_(d);
});
cljs.core.preserving_reduced = (function cljs$core$preserving_reduced(rf){
return (function (p1__10017_SHARP_,p2__10018_SHARP_){
var ret = (function (){var G__10021 = p1__10017_SHARP_;
var G__10022 = p2__10018_SHARP_;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10021,G__10022) : rf.call(null,G__10021,G__10022));
})();
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.reduced(ret);
} else {
return ret;
}
});
});
/**
 * A transducer which concatenates the contents of each input, which must be a
 * collection, into the reduction.
 */
cljs.core.cat = (function cljs$core$cat(rf){
var rf1 = cljs.core.preserving_reduced(rf);
return ((function (rf1){
return (function() {
var G__10025 = null;
var G__10025__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10025__1 = (function (result){
var G__10024 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10024) : rf.call(null,G__10024));
});
var G__10025__2 = (function (result,input){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf1,result,input);
});
G__10025 = function(result,input){
switch(arguments.length){
case 0:
return G__10025__0.call(this);
case 1:
return G__10025__1.call(this,result);
case 2:
return G__10025__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10025.cljs$core$IFn$_invoke$arity$0 = G__10025__0;
G__10025.cljs$core$IFn$_invoke$arity$1 = G__10025__1;
G__10025.cljs$core$IFn$_invoke$arity$2 = G__10025__2;
return G__10025;
})()
;})(rf1))
});
/**
 * Returns a lazy sequence removing consecutive duplicates in coll.
 * Returns a transducer when no collection is provided.
 */
cljs.core.dedupe = (function cljs$core$dedupe(){
var G__10027 = arguments.length;
switch (G__10027) {
case 0:
return cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.dedupe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (pa){
return (function() {
var G__10033 = null;
var G__10033__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10033__1 = (function (result){
var G__10028 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10028) : rf.call(null,G__10028));
});
var G__10033__2 = (function (result,input){
var prior = (function (){var G__10029 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10029) : cljs.core.deref.call(null,G__10029));
})();
cljs.core.vreset_BANG_(pa,input);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(prior,input)){
return result;
} else {
var G__10030 = result;
var G__10031 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10030,G__10031) : rf.call(null,G__10030,G__10031));
}
});
G__10033 = function(result,input){
switch(arguments.length){
case 0:
return G__10033__0.call(this);
case 1:
return G__10033__1.call(this,result);
case 2:
return G__10033__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10033.cljs$core$IFn$_invoke$arity$0 = G__10033__0;
G__10033.cljs$core$IFn$_invoke$arity$1 = G__10033__1;
G__10033.cljs$core$IFn$_invoke$arity$2 = G__10033__2;
return G__10033;
})()
;})(pa))
});
});

cljs.core.dedupe.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0(),coll);
});

cljs.core.dedupe.cljs$lang$maxFixedArity = 1;
/**
 * Returns items from coll with random probability of prob (0.0 -
 * 1.0).  Returns a transducer when no collection is provided.
 */
cljs.core.random_sample = (function cljs$core$random_sample(){
var G__10035 = arguments.length;
switch (G__10035) {
case 1:
return cljs.core.random_sample.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.random_sample.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.random_sample.cljs$core$IFn$_invoke$arity$1 = (function (prob){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}));
});

cljs.core.random_sample.cljs$core$IFn$_invoke$arity$2 = (function (prob,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}),coll);
});

cljs.core.random_sample.cljs$lang$maxFixedArity = 2;

/**
* @constructor
*/
cljs.core.Eduction = (function (xform,coll){
this.xform = xform;
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 2173173760;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Eduction.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.seq(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(self__.xform,self__.coll));
});

cljs.core.Eduction.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f,init){
var self__ = this;
var ___$1 = this;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(self__.xform,f,init,self__.coll);
});

cljs.core.Eduction.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll__$1,writer,opts){
var self__ = this;
var coll__$2 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$2);
});

cljs.core.Eduction.cljs$lang$type = true;

cljs.core.Eduction.cljs$lang$ctorStr = "cljs.core/Eduction";

cljs.core.Eduction.cljs$lang$ctorPrWriter = (function (this__4468__auto__,writer__4469__auto__,opt__4470__auto__){
return cljs.core._write(writer__4469__auto__,"cljs.core/Eduction");
});

cljs.core.__GT_Eduction = (function cljs$core$__GT_Eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});

(cljs.core.Eduction.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4865__auto__ = this;
return cljs.core.es6_iterator(this__4865__auto__);
}));
/**
 * Returns a reducible/iterable/seqable application of
 * the transducer to the items in coll. Note that these applications
 * will be performed every time iterator/seq/reduce is called.
 */
cljs.core.eduction = (function cljs$core$eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});
/**
 * Runs the supplied procedure (via reduce), for purposes of side
 * effects, on successive items in the collection. Returns nil
 */
cljs.core.run_BANG_ = (function cljs$core$run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__10038_SHARP_,p2__10037_SHARP_){
var G__10040 = p2__10037_SHARP_;
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(G__10040) : proc.call(null,G__10040));
}),null,coll);
});

cljs.core.IEncodeJS = (function (){var obj10042 = {};
return obj10042;
})();

/**
 * Recursively transforms clj values to JavaScript
 */
cljs.core._clj__GT_js = (function cljs$core$_clj__GT_js(x){
if((function (){var and__3877__auto__ = x;
if(and__3877__auto__){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1;
} else {
return and__3877__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1(x);
} else {
var x__4525__auto__ = (((x == null))?null:x);
return (function (){var or__3889__auto__ = (cljs.core._clj__GT_js[(function (){var G__10046 = x__4525__auto__;
return goog.typeOf(G__10046);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._clj__GT_js["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-clj->js",x);
}
}
})().call(null,x);
}
});

/**
 * Transforms map keys to valid JavaScript keys. Arbitrary keys are
 * encoded to their string representation via (pr-str x)
 */
cljs.core._key__GT_js = (function cljs$core$_key__GT_js(x){
if((function (){var and__3877__auto__ = x;
if(and__3877__auto__){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1;
} else {
return and__3877__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1(x);
} else {
var x__4525__auto__ = (((x == null))?null:x);
return (function (){var or__3889__auto__ = (cljs.core._key__GT_js[(function (){var G__10050 = x__4525__auto__;
return goog.typeOf(G__10050);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._key__GT_js["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-key->js",x);
}
}
})().call(null,x);
}
});

cljs.core.key__GT_js = (function cljs$core$key__GT_js(k){
if((function (){var G__10053 = k;
if(G__10053){
var bit__4563__auto__ = null;
if(cljs.core.truth_((function (){var or__3889__auto__ = bit__4563__auto__;
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return G__10053.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__10053.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10053);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10053);
}
})()){
return cljs.core._clj__GT_js(k);
} else {
if((typeof k === 'string') || (typeof k === 'number') || ((k instanceof cljs.core.Keyword)) || ((k instanceof cljs.core.Symbol))){
var G__10054 = k;
return (cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1 ? cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1(G__10054) : cljs.core.clj__GT_js.call(null,G__10054));
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([k], 0));
}
}
});
/**
 * Recursively transforms ClojureScript values to JavaScript.
 * sets/vectors/lists become Arrays, Keywords and Symbol become Strings,
 * Maps become Objects. Arbitrary keys are encoded to by key->js.
 */
cljs.core.clj__GT_js = (function cljs$core$clj__GT_js(x){
if((x == null)){
return null;
} else {
if((function (){var G__10070 = x;
if(G__10070){
var bit__4563__auto__ = null;
if(cljs.core.truth_((function (){var or__3889__auto__ = bit__4563__auto__;
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return G__10070.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__10070.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10070);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10070);
}
})()){
return cljs.core._clj__GT_js(x);
} else {
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if((x instanceof cljs.core.Symbol)){
return [cljs.core.str(x)].join('');
} else {
if(cljs.core.map_QMARK_(x)){
var m = (function (){var obj10072 = {};
return obj10072;
})();
var seq__10073_10083 = cljs.core.seq(x);
var chunk__10074_10084 = null;
var count__10075_10085 = (0);
var i__10076_10086 = (0);
while(true){
if((i__10076_10086 < count__10075_10085)){
var vec__10077_10087 = chunk__10074_10084.cljs$core$IIndexed$_nth$arity$2(null,i__10076_10086);
var k_10088 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10077_10087,(0),null);
var v_10089 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10077_10087,(1),null);
(m[cljs.core.key__GT_js(k_10088)] = cljs$core$clj__GT_js(v_10089));

var G__10090 = seq__10073_10083;
var G__10091 = chunk__10074_10084;
var G__10092 = count__10075_10085;
var G__10093 = (i__10076_10086 + (1));
seq__10073_10083 = G__10090;
chunk__10074_10084 = G__10091;
count__10075_10085 = G__10092;
i__10076_10086 = G__10093;
continue;
} else {
var temp__4404__auto___10094 = cljs.core.seq(seq__10073_10083);
if(temp__4404__auto___10094){
var seq__10073_10095__$1 = temp__4404__auto___10094;
if(cljs.core.chunked_seq_QMARK_(seq__10073_10095__$1)){
var c__4674__auto___10096 = cljs.core.chunk_first(seq__10073_10095__$1);
var G__10097 = cljs.core.chunk_rest(seq__10073_10095__$1);
var G__10098 = c__4674__auto___10096;
var G__10099 = cljs.core.count(c__4674__auto___10096);
var G__10100 = (0);
seq__10073_10083 = G__10097;
chunk__10074_10084 = G__10098;
count__10075_10085 = G__10099;
i__10076_10086 = G__10100;
continue;
} else {
var vec__10078_10101 = cljs.core.first(seq__10073_10095__$1);
var k_10102 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10078_10101,(0),null);
var v_10103 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10078_10101,(1),null);
(m[cljs.core.key__GT_js(k_10102)] = cljs$core$clj__GT_js(v_10103));

var G__10104 = cljs.core.next(seq__10073_10095__$1);
var G__10105 = null;
var G__10106 = (0);
var G__10107 = (0);
seq__10073_10083 = G__10104;
chunk__10074_10084 = G__10105;
count__10075_10085 = G__10106;
i__10076_10086 = G__10107;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x)){
var arr = [];
var seq__10079_10108 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$clj__GT_js,x));
var chunk__10080_10109 = null;
var count__10081_10110 = (0);
var i__10082_10111 = (0);
while(true){
if((i__10082_10111 < count__10081_10110)){
var x_10112__$1 = chunk__10080_10109.cljs$core$IIndexed$_nth$arity$2(null,i__10082_10111);
arr.push(x_10112__$1);

var G__10113 = seq__10079_10108;
var G__10114 = chunk__10080_10109;
var G__10115 = count__10081_10110;
var G__10116 = (i__10082_10111 + (1));
seq__10079_10108 = G__10113;
chunk__10080_10109 = G__10114;
count__10081_10110 = G__10115;
i__10082_10111 = G__10116;
continue;
} else {
var temp__4404__auto___10117 = cljs.core.seq(seq__10079_10108);
if(temp__4404__auto___10117){
var seq__10079_10118__$1 = temp__4404__auto___10117;
if(cljs.core.chunked_seq_QMARK_(seq__10079_10118__$1)){
var c__4674__auto___10119 = cljs.core.chunk_first(seq__10079_10118__$1);
var G__10120 = cljs.core.chunk_rest(seq__10079_10118__$1);
var G__10121 = c__4674__auto___10119;
var G__10122 = cljs.core.count(c__4674__auto___10119);
var G__10123 = (0);
seq__10079_10108 = G__10120;
chunk__10080_10109 = G__10121;
count__10081_10110 = G__10122;
i__10082_10111 = G__10123;
continue;
} else {
var x_10124__$1 = cljs.core.first(seq__10079_10118__$1);
arr.push(x_10124__$1);

var G__10125 = cljs.core.next(seq__10079_10118__$1);
var G__10126 = null;
var G__10127 = (0);
var G__10128 = (0);
seq__10079_10108 = G__10125;
chunk__10080_10109 = G__10126;
count__10081_10110 = G__10127;
i__10082_10111 = G__10128;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x;

}
}
}
}
}
}
});

cljs.core.IEncodeClojure = (function (){var obj10130 = {};
return obj10130;
})();

/**
 * Transforms JavaScript values to Clojure
 */
cljs.core._js__GT_clj = (function cljs$core$_js__GT_clj(x,options){
if((function (){var and__3877__auto__ = x;
if(and__3877__auto__){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2;
} else {
return and__3877__auto__;
}
})()){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2(x,options);
} else {
var x__4525__auto__ = (((x == null))?null:x);
return (function (){var or__3889__auto__ = (cljs.core._js__GT_clj[(function (){var G__10134 = x__4525__auto__;
return goog.typeOf(G__10134);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._js__GT_clj["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeClojure.-js->clj",x);
}
}
})().call(null,x,options);
}
});

/**
 * Recursively transforms JavaScript arrays into ClojureScript
 * vectors, and JavaScript objects into ClojureScript maps.  With
 * option ':keywordize-keys true' will convert object fields from
 * strings to keywords.
 */
cljs.core.js__GT_clj = (function cljs$core$js__GT_clj(){
var G__10138 = arguments.length;
switch (G__10138) {
case 1:
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,1),(0)));
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4941__auto__);

}
});

cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1 = (function (x){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),false], null)], 0));
});

cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic = (function (x,opts){
var map__10139 = opts;
var map__10139__$1 = ((cljs.core.seq_QMARK_(map__10139))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10139):map__10139);
var keywordize_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10139__$1,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252));
var keyfn = (cljs.core.truth_(keywordize_keys)?cljs.core.keyword:cljs.core.str);
var f = ((function (map__10139,map__10139__$1,keywordize_keys,keyfn){
return (function cljs$core$thisfn(x__$1){
if((function (){var G__10155 = x__$1;
if(G__10155){
var bit__4563__auto__ = null;
if(cljs.core.truth_((function (){var or__3889__auto__ = bit__4563__auto__;
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return G__10155.cljs$core$IEncodeClojure$;
}
})())){
return true;
} else {
if((!G__10155.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__10155);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__10155);
}
})()){
return cljs.core._js__GT_clj(x__$1,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array_map,opts));
} else {
if(cljs.core.seq_QMARK_(x__$1)){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$thisfn,x__$1));
} else {
if(cljs.core.coll_QMARK_(x__$1)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.empty(x__$1),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$thisfn,x__$1));
} else {
if(cljs.core.array_QMARK_(x__$1)){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$thisfn,x__$1));
} else {
if((cljs.core.type(x__$1) === Object)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4643__auto__ = ((function (map__10139,map__10139__$1,keywordize_keys,keyfn){
return (function cljs$core$thisfn_$_iter__10156(s__10157){
return (new cljs.core.LazySeq(null,((function (map__10139,map__10139__$1,keywordize_keys,keyfn){
return (function (){
var s__10157__$1 = s__10157;
while(true){
var temp__4404__auto__ = cljs.core.seq(s__10157__$1);
if(temp__4404__auto__){
var s__10157__$2 = temp__4404__auto__;
if(cljs.core.chunked_seq_QMARK_(s__10157__$2)){
var c__4641__auto__ = cljs.core.chunk_first(s__10157__$2);
var size__4642__auto__ = cljs.core.count(c__4641__auto__);
var b__10159 = cljs.core.chunk_buffer(size__4642__auto__);
if((function (){var i__10158 = (0);
while(true){
if((i__10158 < size__4642__auto__)){
var k = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4641__auto__,i__10158);
cljs.core.chunk_append(b__10159,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__10164 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__10164) : keyfn.call(null,G__10164));
})(),cljs$core$thisfn((x__$1[k]))], null));

var G__10167 = (i__10158 + (1));
i__10158 = G__10167;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__10159),cljs$core$thisfn_$_iter__10156(cljs.core.chunk_rest(s__10157__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__10159),null);
}
} else {
var k = cljs.core.first(s__10157__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__10165 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__10165) : keyfn.call(null,G__10165));
})(),cljs$core$thisfn((x__$1[k]))], null),cljs$core$thisfn_$_iter__10156(cljs.core.rest(s__10157__$2)));
}
} else {
return null;
}
break;
}
});})(map__10139,map__10139__$1,keywordize_keys,keyfn))
,null,null));
});})(map__10139,map__10139__$1,keywordize_keys,keyfn))
;
return iter__4643__auto__(cljs.core.js_keys(x__$1));
})());
} else {
return x__$1;

}
}
}
}
}
});})(map__10139,map__10139__$1,keywordize_keys,keyfn))
;
return f(x);
});

cljs.core.js__GT_clj.cljs$lang$applyTo = (function (seq10135){
var G__10136 = cljs.core.first(seq10135);
var seq10135__$1 = cljs.core.next(seq10135);
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(G__10136,seq10135__$1);
});

cljs.core.js__GT_clj.cljs$lang$maxFixedArity = 1;
/**
 * Returns a memoized version of a referentially transparent function. The
 * memoized version of the function keeps a cache of the mapping from arguments
 * to results and, when calls with the same arguments are repeated often, has
 * higher performance at the expense of higher memory use.
 */
cljs.core.memoize = (function cljs$core$memoize(f){
var mem = (function (){var G__10170 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10170) : cljs.core.atom.call(null,G__10170));
})();
return ((function (mem){
return (function() { 
var G__10172__delegate = function (args){
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$3((function (){var G__10171 = mem;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10171) : cljs.core.deref.call(null,G__10171));
})(),args,cljs.core.lookup_sentinel);
if((v === cljs.core.lookup_sentinel)){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(mem,cljs.core.assoc,args,ret);

return ret;
} else {
return v;
}
};
var G__10172 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__10173__i = 0, G__10173__a = new Array(arguments.length -  0);
while (G__10173__i < G__10173__a.length) {G__10173__a[G__10173__i] = arguments[G__10173__i + 0]; ++G__10173__i;}
  args = new cljs.core.IndexedSeq(G__10173__a,0);
} 
return G__10172__delegate.call(this,args);};
G__10172.cljs$lang$maxFixedArity = 0;
G__10172.cljs$lang$applyTo = (function (arglist__10174){
var args = cljs.core.seq(arglist__10174);
return G__10172__delegate(args);
});
G__10172.cljs$core$IFn$_invoke$arity$variadic = G__10172__delegate;
return G__10172;
})()
;
;})(mem))
});
/**
 * trampoline can be used to convert algorithms requiring mutual
 * recursion without stack consumption. Calls f with supplied args, if
 * any. If f returns a fn, calls that fn with no arguments, and
 * continues to repeat, until the return value is not a fn, then
 * returns that non-fn value. Note that if you want to return a fn as a
 * final value, you must wrap it in some data structure and unpack it
 * after trampoline returns.
 */
cljs.core.trampoline = (function cljs$core$trampoline(){
var G__10178 = arguments.length;
switch (G__10178) {
case 1:
return cljs.core.trampoline.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__4941__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,1),(0)));
return cljs.core.trampoline.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4941__auto__);

}
});

cljs.core.trampoline.cljs$core$IFn$_invoke$arity$1 = (function (f){
while(true){
var ret = (function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})();
if(cljs.core.fn_QMARK_(ret)){
var G__10180 = ret;
f = G__10180;
continue;
} else {
return ret;
}
break;
}
});

cljs.core.trampoline.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.trampoline.cljs$core$IFn$_invoke$arity$1((function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}));
});

cljs.core.trampoline.cljs$lang$applyTo = (function (seq10175){
var G__10176 = cljs.core.first(seq10175);
var seq10175__$1 = cljs.core.next(seq10175);
return cljs.core.trampoline.cljs$core$IFn$_invoke$arity$variadic(G__10176,seq10175__$1);
});

cljs.core.trampoline.cljs$lang$maxFixedArity = 1;
/**
 * Returns a random floating point number between 0 (inclusive) and
 * n (default 1) (exclusive).
 */
cljs.core.rand = (function cljs$core$rand(){
var G__10182 = arguments.length;
switch (G__10182) {
case 0:
return cljs.core.rand.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.rand.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.rand.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.rand.cljs$core$IFn$_invoke$arity$1((1));
});

cljs.core.rand.cljs$core$IFn$_invoke$arity$1 = (function (n){
return ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
});

cljs.core.rand.cljs$lang$maxFixedArity = 1;
/**
 * Returns a random integer between 0 (inclusive) and n (exclusive).
 */
cljs.core.rand_int = (function cljs$core$rand_int(n){
var G__10185 = ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__10185) : Math.floor.call(null,G__10185));
});
/**
 * Return a random element of the (sequential) collection. Will have
 * the same performance characteristics as nth for the given
 * collection.
 */
cljs.core.rand_nth = (function cljs$core$rand_nth(coll){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.rand_int(cljs.core.count(coll)));
});
/**
 * Returns a map of the elements of coll keyed by the result of
 * f on each element. The value at each key will be a vector of the
 * corresponding elements, in the order they appeared in coll.
 */
cljs.core.group_by = (function cljs$core$group_by(f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret,x){
var k = (function (){var G__10187 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10187) : f.call(null,G__10187));
})();
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.PersistentVector.EMPTY),x));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Creates a hierarchy object for use with derive, isa? etc.
 */
cljs.core.make_hierarchy = (function cljs$core$make_hierarchy(){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"descendants","descendants",1824886031),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),cljs.core.PersistentArrayMap.EMPTY], null);
});
cljs.core._global_hierarchy = null;
cljs.core.get_global_hierarchy = (function cljs$core$get_global_hierarchy(){
if((cljs.core._global_hierarchy == null)){
cljs.core._global_hierarchy = (function (){var G__10189 = cljs.core.make_hierarchy();
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10189) : cljs.core.atom.call(null,G__10189));
})();
} else {
}

return cljs.core._global_hierarchy;
});
cljs.core.swap_global_hierarchy_BANG_ = (function cljs$core$swap_global_hierarchy_BANG_(){
var argseq__4929__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4929__auto__);
});

cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.swap_BANG_,cljs.core.get_global_hierarchy(),f,args);
});

cljs.core.swap_global_hierarchy_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.swap_global_hierarchy_BANG_.cljs$lang$applyTo = (function (seq10190){
var G__10191 = cljs.core.first(seq10190);
var seq10190__$1 = cljs.core.next(seq10190);
return cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10191,seq10190__$1);
});
/**
 * Returns true if (= child parent), or child is directly or indirectly derived from
 * parent, either via a JavaScript type inheritance relationship or a
 * relationship established via derive. h must be a hierarchy obtained
 * from make-hierarchy, if not supplied defaults to the global
 * hierarchy
 */
cljs.core.isa_QMARK_ = (function cljs$core$isa_QMARK_(){
var G__10193 = arguments.length;
switch (G__10193) {
case 2:
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (child,parent){
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__10194 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10194) : cljs.core.deref.call(null,G__10194));
})(),child,parent);
});

cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (h,child,parent){
var or__3889__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(child,parent);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h).call(null,child),parent);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
var and__3877__auto__ = cljs.core.vector_QMARK_(parent);
if(and__3877__auto__){
var and__3877__auto____$1 = cljs.core.vector_QMARK_(child);
if(and__3877__auto____$1){
var and__3877__auto____$2 = (cljs.core.count(parent) === cljs.core.count(child));
if(and__3877__auto____$2){
var ret = true;
var i = (0);
while(true){
if((!(ret)) || ((i === cljs.core.count(parent)))){
return ret;
} else {
var G__10220 = cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3(h,(function (){var G__10217 = i;
return (child.cljs$core$IFn$_invoke$arity$1 ? child.cljs$core$IFn$_invoke$arity$1(G__10217) : child.call(null,G__10217));
})(),(function (){var G__10218 = i;
return (parent.cljs$core$IFn$_invoke$arity$1 ? parent.cljs$core$IFn$_invoke$arity$1(G__10218) : parent.call(null,G__10218));
})());
var G__10221 = (i + (1));
ret = G__10220;
i = G__10221;
continue;
}
break;
}
} else {
return and__3877__auto____$2;
}
} else {
return and__3877__auto____$1;
}
} else {
return and__3877__auto__;
}
}
}
});

cljs.core.isa_QMARK_.cljs$lang$maxFixedArity = 3;
/**
 * Returns the immediate parents of tag, either via a JavaScript type
 * inheritance relationship or a relationship established via derive. h
 * must be a hierarchy obtained from make-hierarchy, if not supplied
 * defaults to the global hierarchy
 */
cljs.core.parents = (function cljs$core$parents(){
var G__10223 = arguments.length;
switch (G__10223) {
case 1:
return cljs.core.parents.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.parents.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.parents.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return cljs.core.parents.cljs$core$IFn$_invoke$arity$2((function (){var G__10224 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10224) : cljs.core.deref.call(null,G__10224));
})(),tag);
});

cljs.core.parents.cljs$core$IFn$_invoke$arity$2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag));
});

cljs.core.parents.cljs$lang$maxFixedArity = 2;
/**
 * Returns the immediate and indirect parents of tag, either via a JavaScript type
 * inheritance relationship or a relationship established via derive. h
 * must be a hierarchy obtained from make-hierarchy, if not supplied
 * defaults to the global hierarchy
 */
cljs.core.ancestors = (function cljs$core$ancestors(){
var G__10227 = arguments.length;
switch (G__10227) {
case 1:
return cljs.core.ancestors.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.ancestors.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.ancestors.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return cljs.core.ancestors.cljs$core$IFn$_invoke$arity$2((function (){var G__10228 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10228) : cljs.core.deref.call(null,G__10228));
})(),tag);
});

cljs.core.ancestors.cljs$core$IFn$_invoke$arity$2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag));
});

cljs.core.ancestors.cljs$lang$maxFixedArity = 2;
/**
 * Returns the immediate and indirect children of tag, through a
 * relationship established via derive. h must be a hierarchy obtained
 * from make-hierarchy, if not supplied defaults to the global
 * hierarchy. Note: does not work on JavaScript type inheritance
 * relationships.
 */
cljs.core.descendants = (function cljs$core$descendants(){
var G__10231 = arguments.length;
switch (G__10231) {
case 1:
return cljs.core.descendants.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.descendants.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.descendants.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return cljs.core.descendants.cljs$core$IFn$_invoke$arity$2((function (){var G__10232 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10232) : cljs.core.deref.call(null,G__10232));
})(),tag);
});

cljs.core.descendants.cljs$core$IFn$_invoke$arity$2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),tag));
});

cljs.core.descendants.cljs$lang$maxFixedArity = 2;
/**
 * Establishes a parent/child relationship between parent and
 * tag. Parent must be a namespace-qualified symbol or keyword and
 * child can be either a namespace-qualified symbol or keyword or a
 * class. h must be a hierarchy obtained from make-hierarchy, if not
 * supplied defaults to, and modifies, the global hierarchy.
 */
cljs.core.derive = (function cljs$core$derive(){
var G__10235 = arguments.length;
switch (G__10235) {
case 2:
return cljs.core.derive.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.derive.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.derive.cljs$core$IFn$_invoke$arity$2 = (function (tag,parent){
if(cljs.core.truth_(cljs.core.namespace(parent))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"namespace","namespace",1263021155,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.derive,cljs.core.array_seq([tag,parent], 0));

return null;
});

cljs.core.derive.cljs$core$IFn$_invoke$arity$3 = (function (h,tag,parent){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(tag,parent)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"tag","tag",350170304,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

var tp = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var td = new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h);
var ta = new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h);
var tf = ((function (tp,td,ta){
return (function (m,source,sources,target,targets){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (tp,td,ta){
return (function (ret,k){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.get.cljs$core$IFn$_invoke$arity$3(targets,k,cljs.core.PersistentHashSet.EMPTY),cljs.core.cons(target,(function (){var G__10236 = target;
return (targets.cljs$core$IFn$_invoke$arity$1 ? targets.cljs$core$IFn$_invoke$arity$1(G__10236) : targets.call(null,G__10236));
})())));
});})(tp,td,ta))
,m,cljs.core.cons(source,(function (){var G__10237 = source;
return (sources.cljs$core$IFn$_invoke$arity$1 ? sources.cljs$core$IFn$_invoke$arity$1(G__10237) : sources.call(null,G__10237));
})()));
});})(tp,td,ta))
;
var or__3889__auto__ = ((cljs.core.contains_QMARK_((function (){var G__10241 = tag;
return (tp.cljs$core$IFn$_invoke$arity$1 ? tp.cljs$core$IFn$_invoke$arity$1(G__10241) : tp.call(null,G__10241));
})(),parent))?null:(function (){
if(cljs.core.contains_QMARK_((function (){var G__10242 = tag;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__10242) : ta.call(null,G__10242));
})(),parent)){
throw (new Error([cljs.core.str(tag),cljs.core.str("already has"),cljs.core.str(parent),cljs.core.str("as ancestor")].join('')));
} else {
}

if(cljs.core.contains_QMARK_((function (){var G__10243 = parent;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__10243) : ta.call(null,G__10243));
})(),tag)){
throw (new Error([cljs.core.str("Cyclic derivation:"),cljs.core.str(parent),cljs.core.str("has"),cljs.core.str(tag),cljs.core.str("as ancestor")].join('')));
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(tp,tag,cljs.core.PersistentHashSet.EMPTY),parent)),new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),tf(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag,td,parent,ta),new cljs.core.Keyword(null,"descendants","descendants",1824886031),tf(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),parent,ta,tag,td)], null);
})()
);
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return h;
}
});

cljs.core.derive.cljs$lang$maxFixedArity = 3;
/**
 * Removes a parent/child relationship between parent and
 * tag. h must be a hierarchy obtained from make-hierarchy, if not
 * supplied defaults to, and modifies, the global hierarchy.
 */
cljs.core.underive = (function cljs$core$underive(){
var G__10249 = arguments.length;
switch (G__10249) {
case 2:
return cljs.core.underive.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.underive.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.underive.cljs$core$IFn$_invoke$arity$2 = (function (tag,parent){
cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.underive,cljs.core.array_seq([tag,parent], 0));

return null;
});

cljs.core.underive.cljs$core$IFn$_invoke$arity$3 = (function (h,tag,parent){
var parentMap = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var childsParents = (cljs.core.truth_((function (){var G__10250 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__10250) : parentMap.call(null,G__10250));
})())?cljs.core.disj.cljs$core$IFn$_invoke$arity$2((function (){var G__10251 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__10251) : parentMap.call(null,G__10251));
})(),parent):cljs.core.PersistentHashSet.EMPTY);
var newParents = (cljs.core.truth_(cljs.core.not_empty(childsParents))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(parentMap,tag,childsParents):cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(parentMap,tag));
var deriv_seq = cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (parentMap,childsParents,newParents){
return (function (p1__10245_SHARP_){
return cljs.core.cons(cljs.core.first(p1__10245_SHARP_),cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(cljs.core.first(p1__10245_SHARP_),cljs.core.second(p1__10245_SHARP_)));
});})(parentMap,childsParents,newParents))
,cljs.core.seq(newParents)));
if(cljs.core.contains_QMARK_((function (){var G__10252 = tag;
return (parentMap.cljs$core$IFn$_invoke$arity$1 ? parentMap.cljs$core$IFn$_invoke$arity$1(G__10252) : parentMap.call(null,G__10252));
})(),parent)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (parentMap,childsParents,newParents,deriv_seq){
return (function (p1__10246_SHARP_,p2__10247_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.derive,p1__10246_SHARP_,p2__10247_SHARP_);
});})(parentMap,childsParents,newParents,deriv_seq))
,cljs.core.make_hierarchy(),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),deriv_seq));
} else {
return h;
}
});

cljs.core.underive.cljs$lang$maxFixedArity = 3;
cljs.core.reset_cache = (function cljs$core$reset_cache(method_cache,method_table,cached_hierarchy,hierarchy){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(method_cache,(function (_){
var G__10256 = method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10256) : cljs.core.deref.call(null,G__10256));
}));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cached_hierarchy,(function (_){
var G__10257 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10257) : cljs.core.deref.call(null,G__10257));
}));
});
cljs.core.prefers_STAR_ = (function cljs$core$prefers_STAR_(x,y,prefer_table){
var xprefs = (function (){var G__10273 = prefer_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10273) : cljs.core.deref.call(null,G__10273));
})().call(null,x);
var or__3889__auto__ = (cljs.core.truth_((function (){var and__3877__auto__ = xprefs;
if(cljs.core.truth_(and__3877__auto__)){
var G__10275 = y;
return (xprefs.cljs$core$IFn$_invoke$arity$1 ? xprefs.cljs$core$IFn$_invoke$arity$1(G__10275) : xprefs.call(null,G__10275));
} else {
return and__3877__auto__;
}
})())?true:null);
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (function (){var ps = cljs.core.parents.cljs$core$IFn$_invoke$arity$1(y);
while(true){
if((cljs.core.count(ps) > (0))){
if(cljs.core.truth_(cljs$core$prefers_STAR_(x,cljs.core.first(ps),prefer_table))){
} else {
}

var G__10276 = cljs.core.rest(ps);
ps = G__10276;
continue;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(or__3889__auto____$1)){
return or__3889__auto____$1;
} else {
var or__3889__auto____$2 = (function (){var ps = cljs.core.parents.cljs$core$IFn$_invoke$arity$1(x);
while(true){
if((cljs.core.count(ps) > (0))){
if(cljs.core.truth_(cljs$core$prefers_STAR_(cljs.core.first(ps),y,prefer_table))){
} else {
}

var G__10277 = cljs.core.rest(ps);
ps = G__10277;
continue;
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(or__3889__auto____$2)){
return or__3889__auto____$2;
} else {
return false;
}
}
}
});
cljs.core.dominates = (function cljs$core$dominates(x,y,prefer_table){
var or__3889__auto__ = cljs.core.prefers_STAR_(x,y,prefer_table);
if(cljs.core.truth_(or__3889__auto__)){
return or__3889__auto__;
} else {
return cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$2(x,y);
}
});
cljs.core.find_and_cache_best_method = (function cljs$core$find_and_cache_best_method(name,dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy){
var best_entry = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (be,p__10291){
var vec__10292 = p__10291;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10292,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10292,(1),null);
var e = vec__10292;
if(cljs.core.isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__10293 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10293) : cljs.core.deref.call(null,G__10293));
})(),dispatch_val,k)){
var be2 = (cljs.core.truth_((function (){var or__3889__auto__ = (be == null);
if(or__3889__auto__){
return or__3889__auto__;
} else {
return cljs.core.dominates(k,cljs.core.first(be),prefer_table);
}
})())?e:be);
if(cljs.core.truth_(cljs.core.dominates(cljs.core.first(be2),k,prefer_table))){
} else {
throw (new Error([cljs.core.str("Multiple methods in multimethod '"),cljs.core.str(name),cljs.core.str("' match dispatch value: "),cljs.core.str(dispatch_val),cljs.core.str(" -> "),cljs.core.str(k),cljs.core.str(" and "),cljs.core.str(cljs.core.first(be2)),cljs.core.str(", and neither is preferred")].join('')));
}

return be2;
} else {
return be;
}
}),null,(function (){var G__10294 = method_table;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10294) : cljs.core.deref.call(null,G__10294));
})());
if(cljs.core.truth_(best_entry)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var G__10295 = cached_hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10295) : cljs.core.deref.call(null,G__10295));
})(),(function (){var G__10296 = hierarchy;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10296) : cljs.core.deref.call(null,G__10296));
})())){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(method_cache,cljs.core.assoc,dispatch_val,cljs.core.second(best_entry));

return cljs.core.second(best_entry);
} else {
cljs.core.reset_cache(method_cache,method_table,cached_hierarchy,hierarchy);

return cljs$core$find_and_cache_best_method(name,dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy);
}
} else {
return null;
}
});

cljs.core.IMultiFn = (function (){var obj10298 = {};
return obj10298;
})();

cljs.core._reset = (function cljs$core$_reset(mf){
if((function (){var and__3877__auto__ = mf;
if(and__3877__auto__){
return mf.cljs$core$IMultiFn$_reset$arity$1;
} else {
return and__3877__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_reset$arity$1(mf);
} else {
var x__4525__auto__ = (((mf == null))?null:mf);
return (function (){var or__3889__auto__ = (cljs.core._reset[(function (){var G__10302 = x__4525__auto__;
return goog.typeOf(G__10302);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._reset["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-reset",mf);
}
}
})().call(null,mf);
}
});

cljs.core._add_method = (function cljs$core$_add_method(mf,dispatch_val,method){
if((function (){var and__3877__auto__ = mf;
if(and__3877__auto__){
return mf.cljs$core$IMultiFn$_add_method$arity$3;
} else {
return and__3877__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_add_method$arity$3(mf,dispatch_val,method);
} else {
var x__4525__auto__ = (((mf == null))?null:mf);
return (function (){var or__3889__auto__ = (cljs.core._add_method[(function (){var G__10306 = x__4525__auto__;
return goog.typeOf(G__10306);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._add_method["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-add-method",mf);
}
}
})().call(null,mf,dispatch_val,method);
}
});

cljs.core._remove_method = (function cljs$core$_remove_method(mf,dispatch_val){
if((function (){var and__3877__auto__ = mf;
if(and__3877__auto__){
return mf.cljs$core$IMultiFn$_remove_method$arity$2;
} else {
return and__3877__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf,dispatch_val);
} else {
var x__4525__auto__ = (((mf == null))?null:mf);
return (function (){var or__3889__auto__ = (cljs.core._remove_method[(function (){var G__10310 = x__4525__auto__;
return goog.typeOf(G__10310);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._remove_method["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-remove-method",mf);
}
}
})().call(null,mf,dispatch_val);
}
});

cljs.core._prefer_method = (function cljs$core$_prefer_method(mf,dispatch_val,dispatch_val_y){
if((function (){var and__3877__auto__ = mf;
if(and__3877__auto__){
return mf.cljs$core$IMultiFn$_prefer_method$arity$3;
} else {
return and__3877__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf,dispatch_val,dispatch_val_y);
} else {
var x__4525__auto__ = (((mf == null))?null:mf);
return (function (){var or__3889__auto__ = (cljs.core._prefer_method[(function (){var G__10314 = x__4525__auto__;
return goog.typeOf(G__10314);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._prefer_method["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-prefer-method",mf);
}
}
})().call(null,mf,dispatch_val,dispatch_val_y);
}
});

cljs.core._get_method = (function cljs$core$_get_method(mf,dispatch_val){
if((function (){var and__3877__auto__ = mf;
if(and__3877__auto__){
return mf.cljs$core$IMultiFn$_get_method$arity$2;
} else {
return and__3877__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_get_method$arity$2(mf,dispatch_val);
} else {
var x__4525__auto__ = (((mf == null))?null:mf);
return (function (){var or__3889__auto__ = (cljs.core._get_method[(function (){var G__10318 = x__4525__auto__;
return goog.typeOf(G__10318);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._get_method["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-get-method",mf);
}
}
})().call(null,mf,dispatch_val);
}
});

cljs.core._methods = (function cljs$core$_methods(mf){
if((function (){var and__3877__auto__ = mf;
if(and__3877__auto__){
return mf.cljs$core$IMultiFn$_methods$arity$1;
} else {
return and__3877__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_methods$arity$1(mf);
} else {
var x__4525__auto__ = (((mf == null))?null:mf);
return (function (){var or__3889__auto__ = (cljs.core._methods[(function (){var G__10322 = x__4525__auto__;
return goog.typeOf(G__10322);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._methods["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-methods",mf);
}
}
})().call(null,mf);
}
});

cljs.core._prefers = (function cljs$core$_prefers(mf){
if((function (){var and__3877__auto__ = mf;
if(and__3877__auto__){
return mf.cljs$core$IMultiFn$_prefers$arity$1;
} else {
return and__3877__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_prefers$arity$1(mf);
} else {
var x__4525__auto__ = (((mf == null))?null:mf);
return (function (){var or__3889__auto__ = (cljs.core._prefers[(function (){var G__10326 = x__4525__auto__;
return goog.typeOf(G__10326);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._prefers["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-prefers",mf);
}
}
})().call(null,mf);
}
});

cljs.core._default_dispatch_val = (function cljs$core$_default_dispatch_val(mf){
if((function (){var and__3877__auto__ = mf;
if(and__3877__auto__){
return mf.cljs$core$IMultiFn$_default_dispatch_val$arity$1;
} else {
return and__3877__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_default_dispatch_val$arity$1(mf);
} else {
var x__4525__auto__ = (((mf == null))?null:mf);
return (function (){var or__3889__auto__ = (cljs.core._default_dispatch_val[(function (){var G__10330 = x__4525__auto__;
return goog.typeOf(G__10330);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._default_dispatch_val["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-default-dispatch-val",mf);
}
}
})().call(null,mf);
}
});

cljs.core._dispatch_fn = (function cljs$core$_dispatch_fn(mf){
if((function (){var and__3877__auto__ = mf;
if(and__3877__auto__){
return mf.cljs$core$IMultiFn$_dispatch_fn$arity$1;
} else {
return and__3877__auto__;
}
})()){
return mf.cljs$core$IMultiFn$_dispatch_fn$arity$1(mf);
} else {
var x__4525__auto__ = (((mf == null))?null:mf);
return (function (){var or__3889__auto__ = (cljs.core._dispatch_fn[(function (){var G__10334 = x__4525__auto__;
return goog.typeOf(G__10334);
})()]);
if(or__3889__auto__){
return or__3889__auto__;
} else {
var or__3889__auto____$1 = (cljs.core._dispatch_fn["_"]);
if(or__3889__auto____$1){
return or__3889__auto____$1;
} else {
throw cljs.core.missing_protocol("IMultiFn.-dispatch-fn",mf);
}
}
})().call(null,mf);
}
});

cljs.core.throw_no_method_error = (function cljs$core$throw_no_method_error(name,dispatch_val){
throw (new Error([cljs.core.str("No method in multimethod '"),cljs.core.str(name),cljs.core.str("' for dispatch value: "),cljs.core.str(dispatch_val)].join('')));
});

/**
* @constructor
*/
cljs.core.MultiFn = (function (name,dispatch_fn,default_dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy){
this.name = name;
this.dispatch_fn = dispatch_fn;
this.default_dispatch_val = default_dispatch_val;
this.hierarchy = hierarchy;
this.method_table = method_table;
this.prefer_table = prefer_table;
this.method_cache = method_cache;
this.cached_hierarchy = cached_hierarchy;
this.cljs$lang$protocol_mask$partition0$ = 4194305;
this.cljs$lang$protocol_mask$partition1$ = 4352;
})
cljs.core.MultiFn.prototype.call = (function() {
var G__11183 = null;
var G__11183__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$0 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$0() : self__.dispatch_fn.call(null));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

return (target_fn.cljs$core$IFn$_invoke$arity$0 ? target_fn.cljs$core$IFn$_invoke$arity$0() : target_fn.call(null));
});
var G__11183__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10336 = a;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$1 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$1(G__10336) : self__.dispatch_fn.call(null,G__10336));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10337 = a;
return (target_fn.cljs$core$IFn$_invoke$arity$1 ? target_fn.cljs$core$IFn$_invoke$arity$1(G__10337) : target_fn.call(null,G__10337));
});
var G__11183__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10338 = a;
var G__10339 = b;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$2 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$2(G__10338,G__10339) : self__.dispatch_fn.call(null,G__10338,G__10339));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10340 = a;
var G__10341 = b;
return (target_fn.cljs$core$IFn$_invoke$arity$2 ? target_fn.cljs$core$IFn$_invoke$arity$2(G__10340,G__10341) : target_fn.call(null,G__10340,G__10341));
});
var G__11183__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10342 = a;
var G__10343 = b;
var G__10344 = c;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$3 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$3(G__10342,G__10343,G__10344) : self__.dispatch_fn.call(null,G__10342,G__10343,G__10344));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10345 = a;
var G__10346 = b;
var G__10347 = c;
return (target_fn.cljs$core$IFn$_invoke$arity$3 ? target_fn.cljs$core$IFn$_invoke$arity$3(G__10345,G__10346,G__10347) : target_fn.call(null,G__10345,G__10346,G__10347));
});
var G__11183__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10348 = a;
var G__10349 = b;
var G__10350 = c;
var G__10351 = d;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$4 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$4(G__10348,G__10349,G__10350,G__10351) : self__.dispatch_fn.call(null,G__10348,G__10349,G__10350,G__10351));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10352 = a;
var G__10353 = b;
var G__10354 = c;
var G__10355 = d;
return (target_fn.cljs$core$IFn$_invoke$arity$4 ? target_fn.cljs$core$IFn$_invoke$arity$4(G__10352,G__10353,G__10354,G__10355) : target_fn.call(null,G__10352,G__10353,G__10354,G__10355));
});
var G__11183__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10356 = a;
var G__10357 = b;
var G__10358 = c;
var G__10359 = d;
var G__10360 = e;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$5 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$5(G__10356,G__10357,G__10358,G__10359,G__10360) : self__.dispatch_fn.call(null,G__10356,G__10357,G__10358,G__10359,G__10360));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10361 = a;
var G__10362 = b;
var G__10363 = c;
var G__10364 = d;
var G__10365 = e;
return (target_fn.cljs$core$IFn$_invoke$arity$5 ? target_fn.cljs$core$IFn$_invoke$arity$5(G__10361,G__10362,G__10363,G__10364,G__10365) : target_fn.call(null,G__10361,G__10362,G__10363,G__10364,G__10365));
});
var G__11183__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10366 = a;
var G__10367 = b;
var G__10368 = c;
var G__10369 = d;
var G__10370 = e;
var G__10371 = f;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$6 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$6(G__10366,G__10367,G__10368,G__10369,G__10370,G__10371) : self__.dispatch_fn.call(null,G__10366,G__10367,G__10368,G__10369,G__10370,G__10371));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10372 = a;
var G__10373 = b;
var G__10374 = c;
var G__10375 = d;
var G__10376 = e;
var G__10377 = f;
return (target_fn.cljs$core$IFn$_invoke$arity$6 ? target_fn.cljs$core$IFn$_invoke$arity$6(G__10372,G__10373,G__10374,G__10375,G__10376,G__10377) : target_fn.call(null,G__10372,G__10373,G__10374,G__10375,G__10376,G__10377));
});
var G__11183__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10378 = a;
var G__10379 = b;
var G__10380 = c;
var G__10381 = d;
var G__10382 = e;
var G__10383 = f;
var G__10384 = g;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$7 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$7(G__10378,G__10379,G__10380,G__10381,G__10382,G__10383,G__10384) : self__.dispatch_fn.call(null,G__10378,G__10379,G__10380,G__10381,G__10382,G__10383,G__10384));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10385 = a;
var G__10386 = b;
var G__10387 = c;
var G__10388 = d;
var G__10389 = e;
var G__10390 = f;
var G__10391 = g;
return (target_fn.cljs$core$IFn$_invoke$arity$7 ? target_fn.cljs$core$IFn$_invoke$arity$7(G__10385,G__10386,G__10387,G__10388,G__10389,G__10390,G__10391) : target_fn.call(null,G__10385,G__10386,G__10387,G__10388,G__10389,G__10390,G__10391));
});
var G__11183__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10392 = a;
var G__10393 = b;
var G__10394 = c;
var G__10395 = d;
var G__10396 = e;
var G__10397 = f;
var G__10398 = g;
var G__10399 = h;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$8 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$8(G__10392,G__10393,G__10394,G__10395,G__10396,G__10397,G__10398,G__10399) : self__.dispatch_fn.call(null,G__10392,G__10393,G__10394,G__10395,G__10396,G__10397,G__10398,G__10399));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10400 = a;
var G__10401 = b;
var G__10402 = c;
var G__10403 = d;
var G__10404 = e;
var G__10405 = f;
var G__10406 = g;
var G__10407 = h;
return (target_fn.cljs$core$IFn$_invoke$arity$8 ? target_fn.cljs$core$IFn$_invoke$arity$8(G__10400,G__10401,G__10402,G__10403,G__10404,G__10405,G__10406,G__10407) : target_fn.call(null,G__10400,G__10401,G__10402,G__10403,G__10404,G__10405,G__10406,G__10407));
});
var G__11183__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10408 = a;
var G__10409 = b;
var G__10410 = c;
var G__10411 = d;
var G__10412 = e;
var G__10413 = f;
var G__10414 = g;
var G__10415 = h;
var G__10416 = i;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$9 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$9(G__10408,G__10409,G__10410,G__10411,G__10412,G__10413,G__10414,G__10415,G__10416) : self__.dispatch_fn.call(null,G__10408,G__10409,G__10410,G__10411,G__10412,G__10413,G__10414,G__10415,G__10416));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10417 = a;
var G__10418 = b;
var G__10419 = c;
var G__10420 = d;
var G__10421 = e;
var G__10422 = f;
var G__10423 = g;
var G__10424 = h;
var G__10425 = i;
return (target_fn.cljs$core$IFn$_invoke$arity$9 ? target_fn.cljs$core$IFn$_invoke$arity$9(G__10417,G__10418,G__10419,G__10420,G__10421,G__10422,G__10423,G__10424,G__10425) : target_fn.call(null,G__10417,G__10418,G__10419,G__10420,G__10421,G__10422,G__10423,G__10424,G__10425));
});
var G__11183__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10426 = a;
var G__10427 = b;
var G__10428 = c;
var G__10429 = d;
var G__10430 = e;
var G__10431 = f;
var G__10432 = g;
var G__10433 = h;
var G__10434 = i;
var G__10435 = j;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$10 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$10(G__10426,G__10427,G__10428,G__10429,G__10430,G__10431,G__10432,G__10433,G__10434,G__10435) : self__.dispatch_fn.call(null,G__10426,G__10427,G__10428,G__10429,G__10430,G__10431,G__10432,G__10433,G__10434,G__10435));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10436 = a;
var G__10437 = b;
var G__10438 = c;
var G__10439 = d;
var G__10440 = e;
var G__10441 = f;
var G__10442 = g;
var G__10443 = h;
var G__10444 = i;
var G__10445 = j;
return (target_fn.cljs$core$IFn$_invoke$arity$10 ? target_fn.cljs$core$IFn$_invoke$arity$10(G__10436,G__10437,G__10438,G__10439,G__10440,G__10441,G__10442,G__10443,G__10444,G__10445) : target_fn.call(null,G__10436,G__10437,G__10438,G__10439,G__10440,G__10441,G__10442,G__10443,G__10444,G__10445));
});
var G__11183__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10446 = a;
var G__10447 = b;
var G__10448 = c;
var G__10449 = d;
var G__10450 = e;
var G__10451 = f;
var G__10452 = g;
var G__10453 = h;
var G__10454 = i;
var G__10455 = j;
var G__10456 = k;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$11 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$11(G__10446,G__10447,G__10448,G__10449,G__10450,G__10451,G__10452,G__10453,G__10454,G__10455,G__10456) : self__.dispatch_fn.call(null,G__10446,G__10447,G__10448,G__10449,G__10450,G__10451,G__10452,G__10453,G__10454,G__10455,G__10456));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10457 = a;
var G__10458 = b;
var G__10459 = c;
var G__10460 = d;
var G__10461 = e;
var G__10462 = f;
var G__10463 = g;
var G__10464 = h;
var G__10465 = i;
var G__10466 = j;
var G__10467 = k;
return (target_fn.cljs$core$IFn$_invoke$arity$11 ? target_fn.cljs$core$IFn$_invoke$arity$11(G__10457,G__10458,G__10459,G__10460,G__10461,G__10462,G__10463,G__10464,G__10465,G__10466,G__10467) : target_fn.call(null,G__10457,G__10458,G__10459,G__10460,G__10461,G__10462,G__10463,G__10464,G__10465,G__10466,G__10467));
});
var G__11183__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10468 = a;
var G__10469 = b;
var G__10470 = c;
var G__10471 = d;
var G__10472 = e;
var G__10473 = f;
var G__10474 = g;
var G__10475 = h;
var G__10476 = i;
var G__10477 = j;
var G__10478 = k;
var G__10479 = l;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$12 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$12(G__10468,G__10469,G__10470,G__10471,G__10472,G__10473,G__10474,G__10475,G__10476,G__10477,G__10478,G__10479) : self__.dispatch_fn.call(null,G__10468,G__10469,G__10470,G__10471,G__10472,G__10473,G__10474,G__10475,G__10476,G__10477,G__10478,G__10479));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10480 = a;
var G__10481 = b;
var G__10482 = c;
var G__10483 = d;
var G__10484 = e;
var G__10485 = f;
var G__10486 = g;
var G__10487 = h;
var G__10488 = i;
var G__10489 = j;
var G__10490 = k;
var G__10491 = l;
return (target_fn.cljs$core$IFn$_invoke$arity$12 ? target_fn.cljs$core$IFn$_invoke$arity$12(G__10480,G__10481,G__10482,G__10483,G__10484,G__10485,G__10486,G__10487,G__10488,G__10489,G__10490,G__10491) : target_fn.call(null,G__10480,G__10481,G__10482,G__10483,G__10484,G__10485,G__10486,G__10487,G__10488,G__10489,G__10490,G__10491));
});
var G__11183__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10492 = a;
var G__10493 = b;
var G__10494 = c;
var G__10495 = d;
var G__10496 = e;
var G__10497 = f;
var G__10498 = g;
var G__10499 = h;
var G__10500 = i;
var G__10501 = j;
var G__10502 = k;
var G__10503 = l;
var G__10504 = m;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$13 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$13(G__10492,G__10493,G__10494,G__10495,G__10496,G__10497,G__10498,G__10499,G__10500,G__10501,G__10502,G__10503,G__10504) : self__.dispatch_fn.call(null,G__10492,G__10493,G__10494,G__10495,G__10496,G__10497,G__10498,G__10499,G__10500,G__10501,G__10502,G__10503,G__10504));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10505 = a;
var G__10506 = b;
var G__10507 = c;
var G__10508 = d;
var G__10509 = e;
var G__10510 = f;
var G__10511 = g;
var G__10512 = h;
var G__10513 = i;
var G__10514 = j;
var G__10515 = k;
var G__10516 = l;
var G__10517 = m;
return (target_fn.cljs$core$IFn$_invoke$arity$13 ? target_fn.cljs$core$IFn$_invoke$arity$13(G__10505,G__10506,G__10507,G__10508,G__10509,G__10510,G__10511,G__10512,G__10513,G__10514,G__10515,G__10516,G__10517) : target_fn.call(null,G__10505,G__10506,G__10507,G__10508,G__10509,G__10510,G__10511,G__10512,G__10513,G__10514,G__10515,G__10516,G__10517));
});
var G__11183__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10518 = a;
var G__10519 = b;
var G__10520 = c;
var G__10521 = d;
var G__10522 = e;
var G__10523 = f;
var G__10524 = g;
var G__10525 = h;
var G__10526 = i;
var G__10527 = j;
var G__10528 = k;
var G__10529 = l;
var G__10530 = m;
var G__10531 = n;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$14 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$14(G__10518,G__10519,G__10520,G__10521,G__10522,G__10523,G__10524,G__10525,G__10526,G__10527,G__10528,G__10529,G__10530,G__10531) : self__.dispatch_fn.call(null,G__10518,G__10519,G__10520,G__10521,G__10522,G__10523,G__10524,G__10525,G__10526,G__10527,G__10528,G__10529,G__10530,G__10531));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10532 = a;
var G__10533 = b;
var G__10534 = c;
var G__10535 = d;
var G__10536 = e;
var G__10537 = f;
var G__10538 = g;
var G__10539 = h;
var G__10540 = i;
var G__10541 = j;
var G__10542 = k;
var G__10543 = l;
var G__10544 = m;
var G__10545 = n;
return (target_fn.cljs$core$IFn$_invoke$arity$14 ? target_fn.cljs$core$IFn$_invoke$arity$14(G__10532,G__10533,G__10534,G__10535,G__10536,G__10537,G__10538,G__10539,G__10540,G__10541,G__10542,G__10543,G__10544,G__10545) : target_fn.call(null,G__10532,G__10533,G__10534,G__10535,G__10536,G__10537,G__10538,G__10539,G__10540,G__10541,G__10542,G__10543,G__10544,G__10545));
});
var G__11183__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10546 = a;
var G__10547 = b;
var G__10548 = c;
var G__10549 = d;
var G__10550 = e;
var G__10551 = f;
var G__10552 = g;
var G__10553 = h;
var G__10554 = i;
var G__10555 = j;
var G__10556 = k;
var G__10557 = l;
var G__10558 = m;
var G__10559 = n;
var G__10560 = o;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$15 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$15(G__10546,G__10547,G__10548,G__10549,G__10550,G__10551,G__10552,G__10553,G__10554,G__10555,G__10556,G__10557,G__10558,G__10559,G__10560) : self__.dispatch_fn.call(null,G__10546,G__10547,G__10548,G__10549,G__10550,G__10551,G__10552,G__10553,G__10554,G__10555,G__10556,G__10557,G__10558,G__10559,G__10560));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10561 = a;
var G__10562 = b;
var G__10563 = c;
var G__10564 = d;
var G__10565 = e;
var G__10566 = f;
var G__10567 = g;
var G__10568 = h;
var G__10569 = i;
var G__10570 = j;
var G__10571 = k;
var G__10572 = l;
var G__10573 = m;
var G__10574 = n;
var G__10575 = o;
return (target_fn.cljs$core$IFn$_invoke$arity$15 ? target_fn.cljs$core$IFn$_invoke$arity$15(G__10561,G__10562,G__10563,G__10564,G__10565,G__10566,G__10567,G__10568,G__10569,G__10570,G__10571,G__10572,G__10573,G__10574,G__10575) : target_fn.call(null,G__10561,G__10562,G__10563,G__10564,G__10565,G__10566,G__10567,G__10568,G__10569,G__10570,G__10571,G__10572,G__10573,G__10574,G__10575));
});
var G__11183__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10576 = a;
var G__10577 = b;
var G__10578 = c;
var G__10579 = d;
var G__10580 = e;
var G__10581 = f;
var G__10582 = g;
var G__10583 = h;
var G__10584 = i;
var G__10585 = j;
var G__10586 = k;
var G__10587 = l;
var G__10588 = m;
var G__10589 = n;
var G__10590 = o;
var G__10591 = p;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$16 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$16(G__10576,G__10577,G__10578,G__10579,G__10580,G__10581,G__10582,G__10583,G__10584,G__10585,G__10586,G__10587,G__10588,G__10589,G__10590,G__10591) : self__.dispatch_fn.call(null,G__10576,G__10577,G__10578,G__10579,G__10580,G__10581,G__10582,G__10583,G__10584,G__10585,G__10586,G__10587,G__10588,G__10589,G__10590,G__10591));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10592 = a;
var G__10593 = b;
var G__10594 = c;
var G__10595 = d;
var G__10596 = e;
var G__10597 = f;
var G__10598 = g;
var G__10599 = h;
var G__10600 = i;
var G__10601 = j;
var G__10602 = k;
var G__10603 = l;
var G__10604 = m;
var G__10605 = n;
var G__10606 = o;
var G__10607 = p;
return (target_fn.cljs$core$IFn$_invoke$arity$16 ? target_fn.cljs$core$IFn$_invoke$arity$16(G__10592,G__10593,G__10594,G__10595,G__10596,G__10597,G__10598,G__10599,G__10600,G__10601,G__10602,G__10603,G__10604,G__10605,G__10606,G__10607) : target_fn.call(null,G__10592,G__10593,G__10594,G__10595,G__10596,G__10597,G__10598,G__10599,G__10600,G__10601,G__10602,G__10603,G__10604,G__10605,G__10606,G__10607));
});
var G__11183__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10608 = a;
var G__10609 = b;
var G__10610 = c;
var G__10611 = d;
var G__10612 = e;
var G__10613 = f;
var G__10614 = g;
var G__10615 = h;
var G__10616 = i;
var G__10617 = j;
var G__10618 = k;
var G__10619 = l;
var G__10620 = m;
var G__10621 = n;
var G__10622 = o;
var G__10623 = p;
var G__10624 = q;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$17 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$17(G__10608,G__10609,G__10610,G__10611,G__10612,G__10613,G__10614,G__10615,G__10616,G__10617,G__10618,G__10619,G__10620,G__10621,G__10622,G__10623,G__10624) : self__.dispatch_fn.call(null,G__10608,G__10609,G__10610,G__10611,G__10612,G__10613,G__10614,G__10615,G__10616,G__10617,G__10618,G__10619,G__10620,G__10621,G__10622,G__10623,G__10624));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10625 = a;
var G__10626 = b;
var G__10627 = c;
var G__10628 = d;
var G__10629 = e;
var G__10630 = f;
var G__10631 = g;
var G__10632 = h;
var G__10633 = i;
var G__10634 = j;
var G__10635 = k;
var G__10636 = l;
var G__10637 = m;
var G__10638 = n;
var G__10639 = o;
var G__10640 = p;
var G__10641 = q;
return (target_fn.cljs$core$IFn$_invoke$arity$17 ? target_fn.cljs$core$IFn$_invoke$arity$17(G__10625,G__10626,G__10627,G__10628,G__10629,G__10630,G__10631,G__10632,G__10633,G__10634,G__10635,G__10636,G__10637,G__10638,G__10639,G__10640,G__10641) : target_fn.call(null,G__10625,G__10626,G__10627,G__10628,G__10629,G__10630,G__10631,G__10632,G__10633,G__10634,G__10635,G__10636,G__10637,G__10638,G__10639,G__10640,G__10641));
});
var G__11183__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10642 = a;
var G__10643 = b;
var G__10644 = c;
var G__10645 = d;
var G__10646 = e;
var G__10647 = f;
var G__10648 = g;
var G__10649 = h;
var G__10650 = i;
var G__10651 = j;
var G__10652 = k;
var G__10653 = l;
var G__10654 = m;
var G__10655 = n;
var G__10656 = o;
var G__10657 = p;
var G__10658 = q;
var G__10659 = r;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$18 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$18(G__10642,G__10643,G__10644,G__10645,G__10646,G__10647,G__10648,G__10649,G__10650,G__10651,G__10652,G__10653,G__10654,G__10655,G__10656,G__10657,G__10658,G__10659) : self__.dispatch_fn.call(null,G__10642,G__10643,G__10644,G__10645,G__10646,G__10647,G__10648,G__10649,G__10650,G__10651,G__10652,G__10653,G__10654,G__10655,G__10656,G__10657,G__10658,G__10659));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10660 = a;
var G__10661 = b;
var G__10662 = c;
var G__10663 = d;
var G__10664 = e;
var G__10665 = f;
var G__10666 = g;
var G__10667 = h;
var G__10668 = i;
var G__10669 = j;
var G__10670 = k;
var G__10671 = l;
var G__10672 = m;
var G__10673 = n;
var G__10674 = o;
var G__10675 = p;
var G__10676 = q;
var G__10677 = r;
return (target_fn.cljs$core$IFn$_invoke$arity$18 ? target_fn.cljs$core$IFn$_invoke$arity$18(G__10660,G__10661,G__10662,G__10663,G__10664,G__10665,G__10666,G__10667,G__10668,G__10669,G__10670,G__10671,G__10672,G__10673,G__10674,G__10675,G__10676,G__10677) : target_fn.call(null,G__10660,G__10661,G__10662,G__10663,G__10664,G__10665,G__10666,G__10667,G__10668,G__10669,G__10670,G__10671,G__10672,G__10673,G__10674,G__10675,G__10676,G__10677));
});
var G__11183__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10678 = a;
var G__10679 = b;
var G__10680 = c;
var G__10681 = d;
var G__10682 = e;
var G__10683 = f;
var G__10684 = g;
var G__10685 = h;
var G__10686 = i;
var G__10687 = j;
var G__10688 = k;
var G__10689 = l;
var G__10690 = m;
var G__10691 = n;
var G__10692 = o;
var G__10693 = p;
var G__10694 = q;
var G__10695 = r;
var G__10696 = s;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$19 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$19(G__10678,G__10679,G__10680,G__10681,G__10682,G__10683,G__10684,G__10685,G__10686,G__10687,G__10688,G__10689,G__10690,G__10691,G__10692,G__10693,G__10694,G__10695,G__10696) : self__.dispatch_fn.call(null,G__10678,G__10679,G__10680,G__10681,G__10682,G__10683,G__10684,G__10685,G__10686,G__10687,G__10688,G__10689,G__10690,G__10691,G__10692,G__10693,G__10694,G__10695,G__10696));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10697 = a;
var G__10698 = b;
var G__10699 = c;
var G__10700 = d;
var G__10701 = e;
var G__10702 = f;
var G__10703 = g;
var G__10704 = h;
var G__10705 = i;
var G__10706 = j;
var G__10707 = k;
var G__10708 = l;
var G__10709 = m;
var G__10710 = n;
var G__10711 = o;
var G__10712 = p;
var G__10713 = q;
var G__10714 = r;
var G__10715 = s;
return (target_fn.cljs$core$IFn$_invoke$arity$19 ? target_fn.cljs$core$IFn$_invoke$arity$19(G__10697,G__10698,G__10699,G__10700,G__10701,G__10702,G__10703,G__10704,G__10705,G__10706,G__10707,G__10708,G__10709,G__10710,G__10711,G__10712,G__10713,G__10714,G__10715) : target_fn.call(null,G__10697,G__10698,G__10699,G__10700,G__10701,G__10702,G__10703,G__10704,G__10705,G__10706,G__10707,G__10708,G__10709,G__10710,G__10711,G__10712,G__10713,G__10714,G__10715));
});
var G__11183__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = (function (){var G__10716 = a;
var G__10717 = b;
var G__10718 = c;
var G__10719 = d;
var G__10720 = e;
var G__10721 = f;
var G__10722 = g;
var G__10723 = h;
var G__10724 = i;
var G__10725 = j;
var G__10726 = k;
var G__10727 = l;
var G__10728 = m;
var G__10729 = n;
var G__10730 = o;
var G__10731 = p;
var G__10732 = q;
var G__10733 = r;
var G__10734 = s;
var G__10735 = t;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$20 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$20(G__10716,G__10717,G__10718,G__10719,G__10720,G__10721,G__10722,G__10723,G__10724,G__10725,G__10726,G__10727,G__10728,G__10729,G__10730,G__10731,G__10732,G__10733,G__10734,G__10735) : self__.dispatch_fn.call(null,G__10716,G__10717,G__10718,G__10719,G__10720,G__10721,G__10722,G__10723,G__10724,G__10725,G__10726,G__10727,G__10728,G__10729,G__10730,G__10731,G__10732,G__10733,G__10734,G__10735));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10736 = a;
var G__10737 = b;
var G__10738 = c;
var G__10739 = d;
var G__10740 = e;
var G__10741 = f;
var G__10742 = g;
var G__10743 = h;
var G__10744 = i;
var G__10745 = j;
var G__10746 = k;
var G__10747 = l;
var G__10748 = m;
var G__10749 = n;
var G__10750 = o;
var G__10751 = p;
var G__10752 = q;
var G__10753 = r;
var G__10754 = s;
var G__10755 = t;
return (target_fn.cljs$core$IFn$_invoke$arity$20 ? target_fn.cljs$core$IFn$_invoke$arity$20(G__10736,G__10737,G__10738,G__10739,G__10740,G__10741,G__10742,G__10743,G__10744,G__10745,G__10746,G__10747,G__10748,G__10749,G__10750,G__10751,G__10752,G__10753,G__10754,G__10755) : target_fn.call(null,G__10736,G__10737,G__10738,G__10739,G__10740,G__10741,G__10742,G__10743,G__10744,G__10745,G__10746,G__10747,G__10748,G__10749,G__10750,G__10751,G__10752,G__10753,G__10754,G__10755));
});
var G__11183__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var mf = self____$1;
var dispatch_val = cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.dispatch_fn,a,b,c,d,cljs.core.array_seq([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(target_fn,a,b,c,d,cljs.core.array_seq([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
G__11183 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__11183__1.call(this,self__);
case 2:
return G__11183__2.call(this,self__,a);
case 3:
return G__11183__3.call(this,self__,a,b);
case 4:
return G__11183__4.call(this,self__,a,b,c);
case 5:
return G__11183__5.call(this,self__,a,b,c,d);
case 6:
return G__11183__6.call(this,self__,a,b,c,d,e);
case 7:
return G__11183__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__11183__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__11183__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__11183__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__11183__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__11183__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__11183__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__11183__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__11183__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__11183__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__11183__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__11183__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__11183__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__11183__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__11183__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__11183__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__11183.cljs$core$IFn$_invoke$arity$1 = G__11183__1;
G__11183.cljs$core$IFn$_invoke$arity$2 = G__11183__2;
G__11183.cljs$core$IFn$_invoke$arity$3 = G__11183__3;
G__11183.cljs$core$IFn$_invoke$arity$4 = G__11183__4;
G__11183.cljs$core$IFn$_invoke$arity$5 = G__11183__5;
G__11183.cljs$core$IFn$_invoke$arity$6 = G__11183__6;
G__11183.cljs$core$IFn$_invoke$arity$7 = G__11183__7;
G__11183.cljs$core$IFn$_invoke$arity$8 = G__11183__8;
G__11183.cljs$core$IFn$_invoke$arity$9 = G__11183__9;
G__11183.cljs$core$IFn$_invoke$arity$10 = G__11183__10;
G__11183.cljs$core$IFn$_invoke$arity$11 = G__11183__11;
G__11183.cljs$core$IFn$_invoke$arity$12 = G__11183__12;
G__11183.cljs$core$IFn$_invoke$arity$13 = G__11183__13;
G__11183.cljs$core$IFn$_invoke$arity$14 = G__11183__14;
G__11183.cljs$core$IFn$_invoke$arity$15 = G__11183__15;
G__11183.cljs$core$IFn$_invoke$arity$16 = G__11183__16;
G__11183.cljs$core$IFn$_invoke$arity$17 = G__11183__17;
G__11183.cljs$core$IFn$_invoke$arity$18 = G__11183__18;
G__11183.cljs$core$IFn$_invoke$arity$19 = G__11183__19;
G__11183.cljs$core$IFn$_invoke$arity$20 = G__11183__20;
G__11183.cljs$core$IFn$_invoke$arity$21 = G__11183__21;
G__11183.cljs$core$IFn$_invoke$arity$22 = G__11183__22;
return G__11183;
})()
;

cljs.core.MultiFn.prototype.apply = (function (self__,args10335){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10335)));
});

cljs.core.MultiFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var mf = this;
var dispatch_val = (function (){return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$0 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$0() : self__.dispatch_fn.call(null));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

return (target_fn.cljs$core$IFn$_invoke$arity$0 ? target_fn.cljs$core$IFn$_invoke$arity$0() : target_fn.call(null));
});

cljs.core.MultiFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var mf = this;
var dispatch_val = (function (){var G__10756 = a;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$1 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$1(G__10756) : self__.dispatch_fn.call(null,G__10756));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10757 = a;
return (target_fn.cljs$core$IFn$_invoke$arity$1 ? target_fn.cljs$core$IFn$_invoke$arity$1(G__10757) : target_fn.call(null,G__10757));
});

cljs.core.MultiFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var mf = this;
var dispatch_val = (function (){var G__10758 = a;
var G__10759 = b;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$2 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$2(G__10758,G__10759) : self__.dispatch_fn.call(null,G__10758,G__10759));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10760 = a;
var G__10761 = b;
return (target_fn.cljs$core$IFn$_invoke$arity$2 ? target_fn.cljs$core$IFn$_invoke$arity$2(G__10760,G__10761) : target_fn.call(null,G__10760,G__10761));
});

cljs.core.MultiFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var mf = this;
var dispatch_val = (function (){var G__10762 = a;
var G__10763 = b;
var G__10764 = c;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$3 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$3(G__10762,G__10763,G__10764) : self__.dispatch_fn.call(null,G__10762,G__10763,G__10764));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10765 = a;
var G__10766 = b;
var G__10767 = c;
return (target_fn.cljs$core$IFn$_invoke$arity$3 ? target_fn.cljs$core$IFn$_invoke$arity$3(G__10765,G__10766,G__10767) : target_fn.call(null,G__10765,G__10766,G__10767));
});

cljs.core.MultiFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var mf = this;
var dispatch_val = (function (){var G__10768 = a;
var G__10769 = b;
var G__10770 = c;
var G__10771 = d;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$4 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$4(G__10768,G__10769,G__10770,G__10771) : self__.dispatch_fn.call(null,G__10768,G__10769,G__10770,G__10771));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10772 = a;
var G__10773 = b;
var G__10774 = c;
var G__10775 = d;
return (target_fn.cljs$core$IFn$_invoke$arity$4 ? target_fn.cljs$core$IFn$_invoke$arity$4(G__10772,G__10773,G__10774,G__10775) : target_fn.call(null,G__10772,G__10773,G__10774,G__10775));
});

cljs.core.MultiFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var mf = this;
var dispatch_val = (function (){var G__10776 = a;
var G__10777 = b;
var G__10778 = c;
var G__10779 = d;
var G__10780 = e;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$5 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$5(G__10776,G__10777,G__10778,G__10779,G__10780) : self__.dispatch_fn.call(null,G__10776,G__10777,G__10778,G__10779,G__10780));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10781 = a;
var G__10782 = b;
var G__10783 = c;
var G__10784 = d;
var G__10785 = e;
return (target_fn.cljs$core$IFn$_invoke$arity$5 ? target_fn.cljs$core$IFn$_invoke$arity$5(G__10781,G__10782,G__10783,G__10784,G__10785) : target_fn.call(null,G__10781,G__10782,G__10783,G__10784,G__10785));
});

cljs.core.MultiFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var mf = this;
var dispatch_val = (function (){var G__10786 = a;
var G__10787 = b;
var G__10788 = c;
var G__10789 = d;
var G__10790 = e;
var G__10791 = f;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$6 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$6(G__10786,G__10787,G__10788,G__10789,G__10790,G__10791) : self__.dispatch_fn.call(null,G__10786,G__10787,G__10788,G__10789,G__10790,G__10791));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10792 = a;
var G__10793 = b;
var G__10794 = c;
var G__10795 = d;
var G__10796 = e;
var G__10797 = f;
return (target_fn.cljs$core$IFn$_invoke$arity$6 ? target_fn.cljs$core$IFn$_invoke$arity$6(G__10792,G__10793,G__10794,G__10795,G__10796,G__10797) : target_fn.call(null,G__10792,G__10793,G__10794,G__10795,G__10796,G__10797));
});

cljs.core.MultiFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var mf = this;
var dispatch_val = (function (){var G__10798 = a;
var G__10799 = b;
var G__10800 = c;
var G__10801 = d;
var G__10802 = e;
var G__10803 = f;
var G__10804 = g;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$7 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$7(G__10798,G__10799,G__10800,G__10801,G__10802,G__10803,G__10804) : self__.dispatch_fn.call(null,G__10798,G__10799,G__10800,G__10801,G__10802,G__10803,G__10804));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10805 = a;
var G__10806 = b;
var G__10807 = c;
var G__10808 = d;
var G__10809 = e;
var G__10810 = f;
var G__10811 = g;
return (target_fn.cljs$core$IFn$_invoke$arity$7 ? target_fn.cljs$core$IFn$_invoke$arity$7(G__10805,G__10806,G__10807,G__10808,G__10809,G__10810,G__10811) : target_fn.call(null,G__10805,G__10806,G__10807,G__10808,G__10809,G__10810,G__10811));
});

cljs.core.MultiFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var mf = this;
var dispatch_val = (function (){var G__10812 = a;
var G__10813 = b;
var G__10814 = c;
var G__10815 = d;
var G__10816 = e;
var G__10817 = f;
var G__10818 = g;
var G__10819 = h;
return (self__.dispatch_fn.cljs$core$IFn$_invoke$arity$8 ? self__.dispatch_fn.cljs$core$IFn$_invoke$arity$8(G__10812,G__10813,G__10814,G__10815,G__10816,G__10817,G__10818,G__10819) : self__.dispatch_fn.call(null,G__10812,G__10813,G__10814,G__10815,G__10816,G__10817,G__10818,G__10819));
})();
var target_fn = mf.cljs$core$IMultiFn$_get_method$arity$2(null,dispatch_val);
if(cljs.core.truth_(target_fn)){
} else {
cljs.core.throw_no_method_error(self__.name,dispatch_val);
}

var G__10820 = a;
var G__10821 = b;
var G__10822 = c;
var G__10823 = d;
var G__10824 = e;
var G__10825 = f;
var G__10826 = g;
var G__10827 = h;
return (target_fn.cljs$core$IFn$_invoke$arity$8 ? target_fn.cljs$core$IFn$_invoke$arity$8(G__10820,G__10821,G__10822,G__10823,G__10824,G__10825,G__10826,G__10827) : target_fn.call(null,G__10820,G__10821,G__10822,G__10823,G__10824,G__10825,G__10826,G__10827));
});

cljs.core.MultiFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var mf = this;
var dispatch_val = (function (){var G__10828 = a;
var G__10829 = b;
var G__10830 = c;
var G__10831 = d;
var G__10832 = e;
var G__10833 = f;
var