/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.jsonbeans;

import com.esotericsoftware.jsonbeans.JsonException;
import com.esotericsoftware.jsonbeans.JsonReader;
import com.esotericsoftware.jsonbeans.JsonValue;
import com.esotericsoftware.jsonbeans.JsonWriter;
import com.esotericsoftware.jsonbeans.ObjectMap;
import com.esotericsoftware.jsonbeans.OutputType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Json {
    private static final boolean debug = false;
    private JsonWriter writer;
    private String typeName = "class";
    private boolean usePrototypes = true;
    private OutputType outputType;
    private final ObjectMap<Class, ObjectMap<String, FieldMetadata>> typeToFields = new ObjectMap();
    private final ObjectMap<String, Class> tagToClass = new ObjectMap();
    private final ObjectMap<Class, String> classToTag = new ObjectMap();
    private final ObjectMap<Class, Serializer> classToSerializer = new ObjectMap();
    private final ObjectMap<Class, Object[]> classToDefaultValues = new ObjectMap();
    private boolean ignoreUnknownFields;

    public Json() {
        this.outputType = OutputType.minimal;
    }

    public Json(OutputType outputType) {
        this.outputType = outputType;
    }

    public void setIgnoreUnknownFields(boolean bl) {
        this.ignoreUnknownFields = bl;
    }

    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    public void addClassTag(String string, Class clazz) {
        this.tagToClass.put(string, clazz);
        this.classToTag.put(clazz, string);
    }

    public Class getClass(String string) {
        Class clazz = this.tagToClass.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JsonException(classNotFoundException);
        }
    }

    public String getTag(Class clazz) {
        String string = this.classToTag.get(clazz);
        if (string != null) {
            return string;
        }
        return clazz.getName();
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public <T> void setSerializer(Class<T> clazz, Serializer<T> serializer) {
        this.classToSerializer.put(clazz, serializer);
    }

    public <T> Serializer<T> getSerializer(Class<T> clazz) {
        return this.classToSerializer.get(clazz);
    }

    public void setUsePrototypes(boolean bl) {
        this.usePrototypes = bl;
    }

    public void setElementType(Class clazz, String string, Class clazz2) {
        FieldMetadata fieldMetadata;
        ObjectMap<String, FieldMetadata> objectMap = this.typeToFields.get(clazz);
        if (objectMap == null) {
            objectMap = this.cacheFields(clazz);
        }
        if ((fieldMetadata = objectMap.get(string)) == null) {
            throw new JsonException("Field not found: " + string + " (" + clazz.getName() + ")");
        }
        fieldMetadata.elementType = clazz2;
    }

    private ObjectMap<String, FieldMetadata> cacheFields(Class clazz) {
        ArrayList arrayList = new ArrayList();
        for (Class clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            Collections.addAll(arrayList, clazz2.getDeclaredFields());
        }
        ObjectMap<String, FieldMetadata> objectMap = new ObjectMap<String, FieldMetadata>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Field field = (Field)arrayList.get(i);
            int n2 = field.getModifiers();
            if (Modifier.isTransient(n2) || Modifier.isStatic(n2) || field.isSynthetic()) continue;
            if (!field.isAccessible()) {
                try {
                    field.setAccessible(true);
                }
                catch (AccessControlException accessControlException) {
                    continue;
                }
            }
            objectMap.put(field.getName(), new FieldMetadata(field));
        }
        this.typeToFields.put(clazz, objectMap);
        return objectMap;
    }

    public String toJson(Object object) {
        return this.toJson(object, object == null ? null : object.getClass(), (Class)null);
    }

    public String toJson(Object object, Class clazz) {
        return this.toJson(object, clazz, (Class)null);
    }

    public String toJson(Object object, Class clazz, Class clazz2) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(object, clazz, clazz2, stringWriter);
        return stringWriter.toString();
    }

    public void toJson(Object object, File file) {
        this.toJson(object, object == null ? null : object.getClass(), null, file);
    }

    public void toJson(Object object, Class clazz, File file) {
        this.toJson(object, clazz, null, file);
    }

    public void toJson(Object object, Class clazz, Class clazz2, File file) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            this.toJson(object, clazz, clazz2, fileWriter);
        }
        catch (Exception exception) {
            throw new JsonException("Error writing file: " + file, exception);
        }
        finally {
            try {
                if (fileWriter != null) {
                    ((Writer)fileWriter).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void toJson(Object object, Writer writer) {
        this.toJson(object, object == null ? null : object.getClass(), null, writer);
    }

    public void toJson(Object object, Class clazz, Writer writer) {
        this.toJson(object, clazz, null, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toJson(Object object, Class clazz, Class clazz2, Writer writer) {
        this.setWriter(writer);
        try {
            this.writeValue(object, clazz, clazz2);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception exception) {}
            this.writer = null;
        }
    }

    public void setWriter(Writer writer) {
        if (!(writer instanceof JsonWriter)) {
            writer = new JsonWriter(writer);
        }
        this.writer = (JsonWriter)writer;
        this.writer.setOutputType(this.outputType);
    }

    public JsonWriter getWriter() {
        return this.writer;
    }

    public void writeFields(Object object) {
        Class<?> clazz = object.getClass();
        Object[] objectArray = this.getDefaultValues(clazz);
        ObjectMap<String, FieldMetadata> objectMap = this.typeToFields.get(clazz);
        if (objectMap == null) {
            objectMap = this.cacheFields(clazz);
        }
        int n = 0;
        for (FieldMetadata fieldMetadata : new ObjectMap.Values<FieldMetadata>(objectMap)) {
            Object object2;
            Field field = fieldMetadata.field;
            try {
                Object object3 = field.get(object);
                if (objectArray != null) {
                    object2 = objectArray[n++];
                    if (object3 == null && object2 == null || object3 != null && object2 != null && object3.equals(object2)) continue;
                }
                this.writer.name(field.getName());
                this.writeValue(object3, field.getType(), fieldMetadata.elementType);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JsonException("Error accessing field: " + field.getName() + " (" + clazz.getName() + ")", illegalAccessException);
            }
            catch (JsonException jsonException) {
                jsonException.addTrace(field + " (" + clazz.getName() + ")");
                throw jsonException;
            }
            catch (Exception exception) {
                object2 = new JsonException(exception);
                ((JsonException)object2).addTrace(field + " (" + clazz.getName() + ")");
                throw object2;
            }
        }
    }

    private Object[] getDefaultValues(Class clazz) {
        Object object;
        if (!this.usePrototypes) {
            return null;
        }
        if (this.classToDefaultValues.containsKey(clazz)) {
            return this.classToDefaultValues.get(clazz);
        }
        try {
            object = this.newInstance(clazz);
        }
        catch (Exception exception) {
            this.classToDefaultValues.put(clazz, null);
            return null;
        }
        ObjectMap<String, FieldMetadata> objectMap = this.typeToFields.get(clazz);
        if (objectMap == null) {
            objectMap = this.cacheFields(clazz);
        }
        Object[] objectArray = new Object[objectMap.size];
        this.classToDefaultValues.put(clazz, objectArray);
        int n = 0;
        for (FieldMetadata fieldMetadata : objectMap.values()) {
            Field field = fieldMetadata.field;
            try {
                objectArray[n++] = field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JsonException("Error accessing field: " + field.getName() + " (" + clazz.getName() + ")", illegalAccessException);
            }
            catch (JsonException jsonException) {
                jsonException.addTrace(field + " (" + clazz.getName() + ")");
                throw jsonException;
            }
            catch (RuntimeException runtimeException) {
                JsonException jsonException = new JsonException(runtimeException);
                jsonException.addTrace(field + " (" + clazz.getName() + ")");
                throw jsonException;
            }
        }
        return objectArray;
    }

    public void writeField(Object object, String string) {
        this.writeField(object, string, string, null);
    }

    public void writeField(Object object, String string, Class clazz) {
        this.writeField(object, string, string, clazz);
    }

    public void writeField(Object object, String string, String string2) {
        this.writeField(object, string, string2, null);
    }

    public void writeField(Object object, String string, String string2, Class clazz) {
        FieldMetadata fieldMetadata;
        Class<?> clazz2 = object.getClass();
        ObjectMap<String, FieldMetadata> objectMap = this.typeToFields.get(clazz2);
        if (objectMap == null) {
            objectMap = this.cacheFields(clazz2);
        }
        if ((fieldMetadata = objectMap.get(string)) == null) {
            throw new JsonException("Field not found: " + string + " (" + clazz2.getName() + ")");
        }
        Field field = fieldMetadata.field;
        if (clazz == null) {
            clazz = fieldMetadata.elementType;
        }
        try {
            this.writer.name(string2);
            this.writeValue(field.get(object), field.getType(), clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JsonException("Error accessing field: " + field.getName() + " (" + clazz2.getName() + ")", illegalAccessException);
        }
        catch (JsonException jsonException) {
            jsonException.addTrace(field + " (" + clazz2.getName() + ")");
            throw jsonException;
        }
        catch (Exception exception) {
            JsonException jsonException = new JsonException(exception);
            jsonException.addTrace(field + " (" + clazz2.getName() + ")");
            throw jsonException;
        }
    }

    public void writeValue(String string, Object object) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        if (object == null) {
            this.writeValue(object, null, null);
        } else {
            this.writeValue(object, object.getClass(), null);
        }
    }

    public void writeValue(String string, Object object, Class clazz) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        this.writeValue(object, clazz, null);
    }

    public void writeValue(String string, Object object, Class clazz, Class clazz2) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        this.writeValue(object, clazz, clazz2);
    }

    public void writeValue(Object object) {
        if (object == null) {
            this.writeValue(object, null, null);
        } else {
            this.writeValue(object, object.getClass(), null);
        }
    }

    public void writeValue(Object object, Class clazz) {
        this.writeValue(object, clazz, null);
    }

    public void writeValue(Object object, Class clazz, Class clazz2) {
        try {
            if (object == null) {
                this.writer.value(null);
                return;
            }
            if (clazz != null && clazz.isPrimitive() || clazz == String.class || clazz == Integer.class || clazz == Boolean.class || clazz == Float.class || clazz == Long.class || clazz == Double.class || clazz == Short.class || clazz == Byte.class || clazz == Character.class) {
                this.writer.value(object);
                return;
            }
            Class<?> clazz3 = object.getClass();
            if (clazz3.isPrimitive() || clazz3 == String.class || clazz3 == Integer.class || clazz3 == Boolean.class || clazz3 == Float.class || clazz3 == Long.class || clazz3 == Double.class || clazz3 == Short.class || clazz3 == Byte.class || clazz3 == Character.class) {
                this.writeObjectStart(clazz3, null);
                this.writeValue("value", object);
                this.writeObjectEnd();
                return;
            }
            if (object instanceof Serializable) {
                this.writeObjectStart(clazz3, clazz);
                ((Serializable)object).write(this);
                this.writeObjectEnd();
                return;
            }
            Serializer serializer = this.classToSerializer.get(clazz3);
            if (serializer != null) {
                serializer.write(this, object, clazz);
                return;
            }
            if (object instanceof Collection) {
                if (clazz != null && clazz3 != clazz && clazz3 != ArrayList.class) {
                    throw new JsonException("Serialization of a Collection other than the known type is not supported.\nKnown type: " + clazz + "\nActual type: " + clazz3);
                }
                this.writeArrayStart();
                for (Object e : (Collection)object) {
                    this.writeValue(e, clazz2, null);
                }
                this.writeArrayEnd();
                return;
            }
            if (clazz3.isArray()) {
                if (clazz2 == null) {
                    clazz2 = clazz3.getComponentType();
                }
                int n = Array.getLength(object);
                this.writeArrayStart();
                for (int i = 0; i < n; ++i) {
                    this.writeValue(Array.get(object, i), clazz2, null);
                }
                this.writeArrayEnd();
                return;
            }
            if (object instanceof ObjectMap) {
                if (clazz == null) {
                    clazz = ObjectMap.class;
                }
                this.writeObjectStart(clazz3, clazz);
                for (ObjectMap.Entry entry : ((ObjectMap)object).entries()) {
                    this.writer.name(this.convertToString(entry.key));
                    this.writeValue(entry.value, clazz2, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (object instanceof Map) {
                if (clazz == null) {
                    clazz = HashMap.class;
                }
                this.writeObjectStart(clazz3, clazz);
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    this.writer.name(this.convertToString(entry.getKey()));
                    this.writeValue(entry.getValue(), clazz2, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (Enum.class.isAssignableFrom(clazz3)) {
                this.writer.value(object);
                return;
            }
            this.writeObjectStart(clazz3, clazz);
            this.writeFields(object);
            this.writeObjectEnd();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public void writeObjectStart(String string) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        this.writeObjectStart();
    }

    public void writeObjectStart(String string, Class clazz, Class clazz2) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        this.writeObjectStart(clazz, clazz2);
    }

    public void writeObjectStart() {
        try {
            this.writer.object();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public void writeObjectStart(Class clazz, Class clazz2) {
        try {
            this.writer.object();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        if (clazz2 == null || clazz2 != clazz) {
            this.writeType(clazz);
        }
    }

    public void writeObjectEnd() {
        try {
            this.writer.pop();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public void writeArrayStart(String string) {
        try {
            this.writer.name(string);
            this.writer.array();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public void writeArrayStart() {
        try {
            this.writer.array();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public void writeArrayEnd() {
        try {
            this.writer.pop();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public void writeType(Class clazz) {
        if (this.typeName == null) {
            return;
        }
        String string = this.classToTag.get(clazz);
        if (string == null) {
            string = clazz.getName();
        }
        try {
            this.writer.set(this.typeName, string);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public <T> T fromJson(Class<T> clazz, Reader reader) {
        return this.readValue(clazz, null, new JsonReader().parse(reader));
    }

    public <T> T fromJson(Class<T> clazz, Class clazz2, Reader reader) {
        return this.readValue(clazz, clazz2, new JsonReader().parse(reader));
    }

    public <T> T fromJson(Class<T> clazz, InputStream inputStream) {
        return this.readValue(clazz, null, new JsonReader().parse(inputStream));
    }

    public <T> T fromJson(Class<T> clazz, Class clazz2, InputStream inputStream) {
        return this.readValue(clazz, clazz2, new JsonReader().parse(inputStream));
    }

    public <T> T fromJson(Class<T> clazz, File file) {
        try {
            return this.readValue(clazz, null, new JsonReader().parse(file));
        }
        catch (Exception exception) {
            throw new JsonException("Error reading file: " + file, exception);
        }
    }

    public <T> T fromJson(Class<T> clazz, Class clazz2, File file) {
        try {
            return this.readValue(clazz, clazz2, new JsonReader().parse(file));
        }
        catch (Exception exception) {
            throw new JsonException("Error reading file: " + file, exception);
        }
    }

    public <T> T fromJson(Class<T> clazz, char[] cArray, int n, int n2) {
        return this.readValue(clazz, null, new JsonReader().parse(cArray, n, n2));
    }

    public <T> T fromJson(Class<T> clazz, Class clazz2, char[] cArray, int n, int n2) {
        return this.readValue(clazz, clazz2, new JsonReader().parse(cArray, n, n2));
    }

    public <T> T fromJson(Class<T> clazz, String string) {
        return this.readValue(clazz, null, new JsonReader().parse(string));
    }

    public <T> T fromJson(Class<T> clazz, Class clazz2, String string) {
        return this.readValue(clazz, clazz2, new JsonReader().parse(string));
    }

    public void readField(Object object, String string, JsonValue jsonValue) {
        this.readField(object, string, string, null, jsonValue);
    }

    public void readField(Object object, String string, Class clazz, JsonValue jsonValue) {
        this.readField(object, string, string, clazz, jsonValue);
    }

    public void readField(Object object, String string, String string2, JsonValue jsonValue) {
        this.readField(object, string, string2, null, jsonValue);
    }

    public void readField(Object object, String string, String string2, Class clazz, JsonValue jsonValue) {
        FieldMetadata fieldMetadata;
        Class<?> clazz2 = object.getClass();
        ObjectMap<String, FieldMetadata> objectMap = this.typeToFields.get(clazz2);
        if (objectMap == null) {
            objectMap = this.cacheFields(clazz2);
        }
        if ((fieldMetadata = objectMap.get(string)) == null) {
            throw new JsonException("Field not found: " + string + " (" + clazz2.getName() + ")");
        }
        Field field = fieldMetadata.field;
        JsonValue jsonValue2 = jsonValue.get(string2);
        if (jsonValue2 == null) {
            return;
        }
        if (clazz == null) {
            clazz = fieldMetadata.elementType;
        }
        try {
            field.set(object, this.readValue(field.getType(), clazz, jsonValue2));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JsonException("Error accessing field: " + field.getName() + " (" + clazz2.getName() + ")", illegalAccessException);
        }
        catch (JsonException jsonException) {
            jsonException.addTrace(field.getName() + " (" + clazz2.getName() + ")");
            throw jsonException;
        }
        catch (RuntimeException runtimeException) {
            JsonException jsonException = new JsonException(runtimeException);
            jsonException.addTrace(field.getName() + " (" + clazz2.getName() + ")");
            throw jsonException;
        }
    }

    public void readFields(Object object, JsonValue jsonValue) {
        Class<?> clazz = object.getClass();
        ObjectMap<String, FieldMetadata> objectMap = this.typeToFields.get(clazz);
        if (objectMap == null) {
            objectMap = this.cacheFields(clazz);
        }
        for (JsonValue jsonValue2 = jsonValue.child(); jsonValue2 != null; jsonValue2 = jsonValue2.next()) {
            FieldMetadata fieldMetadata = objectMap.get(jsonValue2.name());
            if (fieldMetadata == null) {
                if (this.ignoreUnknownFields) continue;
                throw new JsonException("Field not found: " + jsonValue2.name() + " (" + clazz.getName() + ")");
            }
            Field field = fieldMetadata.field;
            try {
                field.set(object, this.readValue(field.getType(), fieldMetadata.elementType, jsonValue2));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JsonException("Error accessing field: " + field.getName() + " (" + clazz.getName() + ")", illegalAccessException);
            }
            catch (JsonException jsonException) {
                jsonException.addTrace(field.getName() + " (" + clazz.getName() + ")");
                throw jsonException;
            }
            catch (RuntimeException runtimeException) {
                JsonException jsonException = new JsonException(runtimeException);
                jsonException.addTrace(field.getName() + " (" + clazz.getName() + ")");
                throw jsonException;
            }
        }
    }

    public <T> T readValue(String string, Class<T> clazz, JsonValue jsonValue) {
        return this.readValue(clazz, null, jsonValue.get(string));
    }

    public <T> T readValue(String string, Class<T> clazz, T t, JsonValue jsonValue) {
        JsonValue jsonValue2 = jsonValue.get(string);
        if (jsonValue2 == null) {
            return t;
        }
        return this.readValue(clazz, null, jsonValue2);
    }

    public <T> T readValue(String string, Class<T> clazz, Class clazz2, JsonValue jsonValue) {
        return this.readValue(clazz, clazz2, jsonValue.get(string));
    }

    public <T> T readValue(String string, Class<T> clazz, Class clazz2, T t, JsonValue jsonValue) {
        JsonValue jsonValue2 = jsonValue.get(string);
        if (jsonValue2 == null) {
            return t;
        }
        return this.readValue(clazz, clazz2, jsonValue2);
    }

    public <T> T readValue(Class<T> clazz, Class clazz2, T t, JsonValue jsonValue) {
        return this.readValue(clazz, clazz2, jsonValue);
    }

    public <T> T readValue(Class<T> clazz, JsonValue jsonValue) {
        return this.readValue(clazz, null, jsonValue);
    }

    public <T> T readValue(Class<T> clazz, Class object, JsonValue jsonValue) {
        Object object2;
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue.isObject()) {
            Object object3;
            Object object4;
            block50: {
                String string;
                String string2 = string = this.typeName == null ? null : jsonValue.getString(this.typeName, null);
                if (string != null) {
                    jsonValue.remove(this.typeName);
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = this.tagToClass.get(string);
                        if (clazz != null) break block50;
                        throw new JsonException(classNotFoundException);
                    }
                }
            }
            if (clazz == String.class || clazz == Integer.class || clazz == Boolean.class || clazz == Float.class || clazz == Long.class || clazz == Double.class || clazz == Short.class || clazz == Byte.class || clazz == Character.class) {
                return this.readValue("value", clazz, jsonValue);
            }
            if (clazz != null) {
                object4 = this.classToSerializer.get(clazz);
                if (object4 != null) {
                    return object4.read(this, jsonValue, clazz);
                }
                object3 = this.newInstance(clazz);
                if (object3 instanceof Serializable) {
                    ((Serializable)object3).read(this, jsonValue);
                    return (T)object3;
                }
                if (object3 instanceof HashMap) {
                    HashMap hashMap = (HashMap)object3;
                    for (JsonValue jsonValue2 = jsonValue.child(); jsonValue2 != null; jsonValue2 = jsonValue2.next()) {
                        hashMap.put(jsonValue2.name(), this.readValue((Class<T>)object, null, jsonValue2));
                    }
                    return (T)hashMap;
                }
            } else {
                return (T)jsonValue;
            }
            if (object3 instanceof ObjectMap) {
                object4 = (ObjectMap)object3;
                for (JsonValue jsonValue3 = jsonValue.child(); jsonValue3 != null; jsonValue3 = jsonValue3.next()) {
                    ((ObjectMap)object4).put(jsonValue3.name(), this.readValue((Class<T>)object, null, jsonValue3));
                }
                return (T)object4;
            }
            this.readFields(object3, jsonValue);
            return (T)object3;
        }
        if (clazz != null && (object2 = this.classToSerializer.get(clazz)) != null) {
            return object2.read(this, jsonValue, clazz);
        }
        if (jsonValue.isArray()) {
            if (List.class.isAssignableFrom(clazz)) {
                object2 = clazz == null ? new ArrayList() : (List)this.newInstance(clazz);
                for (JsonValue jsonValue4 = jsonValue.child(); jsonValue4 != null; jsonValue4 = jsonValue4.next()) {
                    object2.add(this.readValue((Class<T>)object, null, jsonValue4));
                }
                return (T)object2;
            }
            if (clazz.isArray()) {
                object2 = clazz.getComponentType();
                if (object == null) {
                    object = object2;
                }
                Object object5 = Array.newInstance(object2, jsonValue.size());
                int n = 0;
                for (JsonValue jsonValue5 = jsonValue.child(); jsonValue5 != null; jsonValue5 = jsonValue5.next()) {
                    Array.set(object5, n++, this.readValue((Class<T>)object, null, jsonValue5));
                }
                return (T)object5;
            }
            throw new JsonException("Unable to convert value to required type: " + jsonValue + " (" + clazz.getName() + ")");
        }
        if (jsonValue.isNumber()) {
            try {
                if (clazz == null || clazz == Float.TYPE || clazz == Float.class) {
                    return (T)Float.valueOf(jsonValue.asFloat());
                }
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    return (T)Integer.valueOf(jsonValue.asInt());
                }
                if (clazz == Long.TYPE || clazz == Long.class) {
                    return (T)Long.valueOf(jsonValue.asLong());
                }
                if (clazz == Double.TYPE || clazz == Double.class) {
                    return (T)Double.valueOf(jsonValue.asFloat());
                }
                if (clazz == String.class) {
                    return (T)Float.toString(jsonValue.asFloat());
                }
                if (clazz == Short.TYPE || clazz == Short.class) {
                    return (T)Short.valueOf((short)jsonValue.asInt());
                }
                if (clazz == Byte.TYPE || clazz == Byte.class) {
                    return (T)Byte.valueOf((byte)jsonValue.asInt());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            jsonValue = new JsonValue(jsonValue.asString());
        }
        if (jsonValue.isBoolean()) {
            try {
                if (clazz == null || clazz == Boolean.TYPE || clazz == Boolean.class) {
                    return (T)Boolean.valueOf(jsonValue.asBoolean());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            jsonValue = new JsonValue(jsonValue.asString());
        }
        if (jsonValue.isString()) {
            object2 = jsonValue.asString();
            if (clazz == null || clazz == String.class) {
                return (T)object2;
            }
            try {
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    return (T)Integer.valueOf((String)object2);
                }
                if (clazz == Float.TYPE || clazz == Float.class) {
                    return (T)Float.valueOf((String)object2);
                }
                if (clazz == Long.TYPE || clazz == Long.class) {
                    return (T)Long.valueOf((String)object2);
                }
                if (clazz == Double.TYPE || clazz == Double.class) {
                    return (T)Double.valueOf((String)object2);
                }
                if (clazz == Short.TYPE || clazz == Short.class) {
                    return (T)Short.valueOf((String)object2);
                }
                if (clazz == Byte.TYPE || clazz == Byte.class) {
                    return (T)Byte.valueOf((String)object2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return (T)Boolean.valueOf((String)object2);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return (T)Character.valueOf(((String)object2).charAt(0));
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                T[] TArray = clazz.getEnumConstants();
                int n = TArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!((String)object2).equals(TArray[i].toString())) continue;
                    return TArray[i];
                }
            }
            if (clazz == CharSequence.class) {
                return (T)object2;
            }
            throw new JsonException("Unable to convert value to required type: " + jsonValue + " (" + clazz.getName() + ")");
        }
        return null;
    }

    private String convertToString(Object object) {
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        return String.valueOf(object);
    }

    private Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            Exception exception2;
            try {
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (clazz.isArray()) {
                    throw new JsonException("Encountered JSON object when expected array of type: " + clazz.getName(), exception);
                }
                if (clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
                    throw new JsonException("Class cannot be created (non-static member class): " + clazz.getName(), exception);
                }
                throw new JsonException("Class cannot be created (missing no-arg constructor): " + clazz.getName(), exception);
            }
            catch (Exception exception3) {
                exception2 = exception3;
            }
            throw new JsonException("Error constructing instance of class: " + clazz.getName(), exception2);
        }
    }

    public String prettyPrint(Object object) {
        return this.prettyPrint(object, 0);
    }

    public String prettyPrint(String string) {
        return this.prettyPrint(string, 0);
    }

    public String prettyPrint(Object object, int n) {
        return this.prettyPrint(this.toJson(object), n);
    }

    public String prettyPrint(String string, int n) {
        return new JsonReader().parse(string).prettyPrint(this.outputType, n);
    }

    public static interface Serializable {
        public void write(Json var1);

        public void read(Json var1, JsonValue var2);
    }

    public static abstract class ReadOnlySerializer<T>
    implements Serializer<T> {
        @Override
        public void write(Json json, T t, Class clazz) {
        }

        @Override
        public abstract T read(Json var1, JsonValue var2, Class var3);
    }

    public static interface Serializer<T> {
        public void write(Json var1, T var2, Class var3);

        public T read(Json var1, JsonValue var2, Class var3);
    }

    private static class FieldMetadata {
        Field field;
        Class elementType;

        public FieldMetadata(Field field) {
            Type[] typeArray;
            this.field = field;
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType && (typeArray = ((ParameterizedType)type).getActualTypeArguments()).length == 1) {
                Type type2 = typeArray[0];
                if (type2 instanceof Class) {
                    this.elementType = (Class)type2;
                } else if (type2 instanceof ParameterizedType) {
                    this.elementType = (Class)((ParameterizedType)type2).getRawType();
                }
            }
        }
    }
}

