/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.jsonbeans;

import com.esotericsoftware.jsonbeans.JsonException;
import com.esotericsoftware.jsonbeans.JsonValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;

public class JsonReader {
    private static final byte[] _json_actions = JsonReader.init__json_actions_0();
    private static final short[] _json_key_offsets = JsonReader.init__json_key_offsets_0();
    private static final char[] _json_trans_keys = JsonReader.init__json_trans_keys_0();
    private static final byte[] _json_single_lengths = JsonReader.init__json_single_lengths_0();
    private static final byte[] _json_range_lengths = JsonReader.init__json_range_lengths_0();
    private static final short[] _json_index_offsets = JsonReader.init__json_index_offsets_0();
    private static final byte[] _json_trans_targs = JsonReader.init__json_trans_targs_0();
    private static final byte[] _json_trans_actions = JsonReader.init__json_trans_actions_0();
    private static final byte[] _json_eof_actions = JsonReader.init__json_eof_actions_0();
    static final int json_start = 1;
    static final int json_first_final = 72;
    static final int json_error = 0;
    static final int json_en_object = 8;
    static final int json_en_array = 46;
    static final int json_en_main = 1;
    private final ArrayList<JsonValue> elements = new ArrayList(8);
    private JsonValue root;
    private JsonValue current;

    public JsonValue parse(String string) {
        char[] cArray = string.toCharArray();
        return this.parse(cArray, 0, cArray.length);
    }

    public JsonValue parse(Reader reader) {
        try {
            int n;
            char[] cArray = new char[1024];
            int n2 = 0;
            while ((n = reader.read(cArray, n2, cArray.length - n2)) != -1) {
                if (n == 0) {
                    char[] cArray2 = new char[cArray.length * 2];
                    System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                    cArray = cArray2;
                    continue;
                }
                n2 += n;
            }
            JsonValue jsonValue = this.parse(cArray, 0, n2);
            return jsonValue;
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public JsonValue parse(InputStream inputStream) {
        try {
            return this.parse(new InputStreamReader(inputStream, "ISO-8859-1"));
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public JsonValue parse(File file) {
        try {
            return this.parse(new FileInputStream(file));
        }
        catch (Exception exception) {
            throw new JsonException("Error parsing file: " + file, exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    public JsonValue parse(char[] var1_1, int var2_2, int var3_3) {
        var5_4 = var2_2;
        var7_6 = var6_5 = var3_3;
        var8_7 = 0;
        var9_8 = new int[4];
        var10_9 = 0;
        var11_10 = new ArrayList<String>(8);
        var12_11 = false;
        var13_12 = false;
        var14_13 = null;
        var15_14 = false;
        if (var15_14) {
            System.out.println();
        }
        try {
            var4_15 = 1;
            var8_7 = 0;
            var17_16 = 0;
            var21_17 = 0;
            block31: while (true) {
                switch (var21_17) {
                    case 0: {
                        if (var5_4 == var6_5) {
                            var21_17 = 4;
                            continue block31;
                        }
                        if (var4_15 == 0) {
                            var21_17 = 5;
                            continue block31;
                        }
                    }
                    case 1: {
                        var20_26 = JsonReader._json_key_offsets[var4_15];
                        var17_16 = JsonReader._json_index_offsets[var4_15];
                        var16_18 = JsonReader._json_single_lengths[var4_15];
                        if (var16_18 <= 0) ** GOTO lbl46
                        var22_27 = var20_26;
                        var24_43 = var20_26 + var16_18 - 1;
                        while (var24_43 >= var22_27) {
                            var23_37 = var22_27 + (var24_43 - var22_27 >> 1);
                            if (var1_1[var5_4] < JsonReader._json_trans_keys[var23_37]) {
                                var24_43 = var23_37 - 1;
                                continue;
                            }
                            if (var1_1[var5_4] > JsonReader._json_trans_keys[var23_37]) {
                                var22_27 = var23_37 + 1;
                                continue;
                            }
                            var17_16 += var23_37 - var20_26;
                            ** GOTO lbl60
                        }
                        var20_26 += var16_18;
                        var17_16 += var16_18;
lbl46:
                        // 2 sources

                        if ((var16_18 = JsonReader._json_range_lengths[var4_15]) > 0) {
                            var22_27 = var20_26;
                            var24_43 = var20_26 + (var16_18 << 1) - 2;
                            while (var24_43 >= var22_27) {
                                var23_37 = var22_27 + (var24_43 - var22_27 >> 1 & -2);
                                if (var1_1[var5_4] < JsonReader._json_trans_keys[var23_37]) {
                                    var24_43 = var23_37 - 2;
                                    continue;
                                }
                                if (var1_1[var5_4] > JsonReader._json_trans_keys[var23_37 + 1]) {
                                    var22_27 = var23_37 + 2;
                                    continue;
                                }
                                var17_16 += var23_37 - var20_26 >> 1;
                                ** GOTO lbl60
                            }
                            var17_16 += var16_18;
                        }
lbl60:
                        // 5 sources

                        var4_15 = JsonReader._json_trans_targs[var17_16];
                        if (JsonReader._json_trans_actions[var17_16] != 0) {
                            var18_24 = JsonReader._json_trans_actions[var17_16];
                            var19_25 = JsonReader._json_actions[var18_24++];
                            while (var19_25-- > 0) {
                                switch (JsonReader._json_actions[var18_24++]) {
                                    case 0: {
                                        var10_9 = var5_4;
                                        var12_11 = false;
                                        var13_12 = false;
                                        break;
                                    }
                                    case 1: {
                                        var12_11 = true;
                                        break;
                                    }
                                    case 2: {
                                        var22_28 = new String(var1_1, var10_9, var5_4 - var10_9);
                                        var10_9 = var5_4;
                                        if (var12_11) {
                                            var22_28 = this.unescape(var22_28);
                                        }
                                        if (var15_14) {
                                            System.out.println("name: " + var22_28);
                                        }
                                        var11_10.add(var22_28);
                                        break;
                                    }
                                    case 3: {
                                        if (var13_12) break;
                                        var22_29 = new String(var1_1, var10_9, var5_4 - var10_9);
                                        var10_9 = var5_4;
                                        if (var12_11) {
                                            var22_29 = this.unescape(var22_29);
                                        }
                                        v0 = var23_38 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var15_14) {
                                            System.out.println("string: " + var23_38 + "=" + var22_29);
                                        }
                                        this.string(var23_38, var22_29);
                                        break;
                                    }
                                    case 4: {
                                        var22_30 = new String(var1_1, var10_9, var5_4 - var10_9);
                                        var10_9 = var5_4;
                                        v1 = var23_39 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var15_14) {
                                            System.out.println("double: " + var23_39 + "=" + Double.parseDouble(var22_30));
                                        }
                                        this.number(var23_39, Double.parseDouble(var22_30));
                                        break;
                                    }
                                    case 5: {
                                        var22_31 = new String(var1_1, var10_9, var5_4 - var10_9);
                                        var10_9 = var5_4;
                                        v2 = var23_40 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var15_14) {
                                            System.out.println("long: " + var23_40 + "=" + Long.parseLong(var22_31));
                                        }
                                        this.number(var23_40, Long.parseLong(var22_31));
                                        break;
                                    }
                                    case 6: {
                                        v3 = var22_32 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var15_14) {
                                            System.out.println("boolean: " + var22_32 + "=true");
                                        }
                                        this.bool(var22_32, true);
                                        var13_12 = true;
                                        break;
                                    }
                                    case 7: {
                                        v4 = var22_33 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var15_14) {
                                            System.out.println("boolean: " + var22_33 + "=false");
                                        }
                                        this.bool(var22_33, false);
                                        var13_12 = true;
                                        break;
                                    }
                                    case 8: {
                                        v5 = var22_34 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var15_14) {
                                            System.out.println("null: " + var22_34);
                                        }
                                        this.string(var22_34, null);
                                        var13_12 = true;
                                        break;
                                    }
                                    case 9: {
                                        v6 = var22_35 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var15_14) {
                                            System.out.println("startObject: " + var22_35);
                                        }
                                        this.startObject(var22_35);
                                        if (var8_7 == var9_8.length) {
                                            var23_41 = new int[var9_8.length * 2];
                                            System.arraycopy(var9_8, 0, var23_41, 0, var9_8.length);
                                            var9_8 = var23_41;
                                        }
                                        var9_8[var8_7++] = var4_15;
                                        var4_15 = 8;
                                        var21_17 = 2;
                                        continue block31;
                                    }
                                    case 10: {
                                        if (var15_14) {
                                            System.out.println("endObject");
                                        }
                                        this.pop();
                                        var4_15 = var9_8[--var8_7];
                                        var21_17 = 2;
                                        continue block31;
                                    }
                                    case 11: {
                                        v7 = var22_36 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                        if (var15_14) {
                                            System.out.println("startArray: " + var22_36);
                                        }
                                        this.startArray(var22_36);
                                        if (var8_7 == var9_8.length) {
                                            var23_42 = new int[var9_8.length * 2];
                                            System.arraycopy(var9_8, 0, var23_42, 0, var9_8.length);
                                            var9_8 = var23_42;
                                        }
                                        var9_8[var8_7++] = var4_15;
                                        var4_15 = 46;
                                        var21_17 = 2;
                                        continue block31;
                                    }
                                    case 12: {
                                        if (var15_14) {
                                            System.out.println("endArray");
                                        }
                                        this.pop();
                                        var4_15 = var9_8[--var8_7];
                                        var21_17 = 2;
                                        continue block31;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (var4_15 == 0) {
                            var21_17 = 5;
                            continue block31;
                        }
                        if (++var5_4 != var6_5) {
                            var21_17 = 1;
                            continue block31;
                        }
                    }
                    case 4: {
                        if (var5_4 != var7_6) break block31;
                        var22_27 = JsonReader._json_eof_actions[var4_15];
                        var23_37 = JsonReader._json_actions[var22_27++];
                        while (var23_37-- > 0) {
                            switch (JsonReader._json_actions[var22_27++]) {
                                case 3: {
                                    if (var13_12) break;
                                    var24_45 = new String(var1_1, var10_9, var5_4 - var10_9);
                                    var10_9 = var5_4;
                                    if (var12_11) {
                                        var24_45 = this.unescape(var24_45);
                                    }
                                    v8 = var25_51 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                    if (var15_14) {
                                        System.out.println("string: " + var25_51 + "=" + var24_45);
                                    }
                                    this.string(var25_51, var24_45);
                                    break;
                                }
                                case 4: {
                                    var24_46 = new String(var1_1, var10_9, var5_4 - var10_9);
                                    var10_9 = var5_4;
                                    v9 = var25_51 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                    if (var15_14) {
                                        System.out.println("double: " + var25_51 + "=" + Double.parseDouble(var24_46));
                                    }
                                    this.number(var25_51, Double.parseDouble(var24_46));
                                    break;
                                }
                                case 5: {
                                    var24_47 = new String(var1_1, var10_9, var5_4 - var10_9);
                                    var10_9 = var5_4;
                                    v10 = var25_51 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                    if (var15_14) {
                                        System.out.println("long: " + var25_51 + "=" + Long.parseLong(var24_47));
                                    }
                                    this.number(var25_51, Long.parseLong(var24_47));
                                    break;
                                }
                                case 6: {
                                    v11 = var24_48 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                    if (var15_14) {
                                        System.out.println("boolean: " + var24_48 + "=true");
                                    }
                                    this.bool(var24_48, true);
                                    var13_12 = true;
                                    break;
                                }
                                case 7: {
                                    v12 = var24_49 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                    if (var15_14) {
                                        System.out.println("boolean: " + var24_49 + "=false");
                                    }
                                    this.bool(var24_49, false);
                                    var13_12 = true;
                                    break;
                                }
                                case 8: {
                                    v13 = var24_50 = var11_10.size() > 0 ? (String)var11_10.remove(var11_10.size() - 1) : null;
                                    if (var15_14) {
                                        System.out.println("null: " + var24_50);
                                    }
                                    this.string(var24_50, null);
                                    var13_12 = true;
                                }
                            }
                        }
                        break block31;
                    }
                }
                break;
            }
        }
        catch (RuntimeException var16_19) {
            var14_13 = var16_19;
        }
        if (var5_4 < var6_5) {
            var16_21 = 1;
            for (var17_16 = 0; var17_16 < var5_4; ++var17_16) {
                if (var1_1[var17_16] != '\n') continue;
                ++var16_21;
            }
            throw new JsonException("Error parsing JSON on line " + var16_21 + " near: " + new String(var1_1, var5_4, var6_5 - var5_4), var14_13);
        }
        if (!this.elements.isEmpty()) {
            var16_22 = this.elements.get(this.elements.size() - 1);
            this.elements.clear();
            if (var16_22 != null && var16_22.isObject()) {
                throw new JsonException("Error parsing JSON, unmatched brace.");
            }
            throw new JsonException("Error parsing JSON, unmatched bracket.");
        }
        var16_23 = this.root;
        this.root = null;
        return var16_23;
    }

    private static byte[] init__json_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 9, 1, 10, 1, 11, 1, 12, 2, 0, 2, 2, 0, 3, 2, 3, 10, 2, 3, 12, 2, 4, 10, 2, 4, 12, 2, 5, 10, 2, 5, 12, 2, 6, 3, 2, 7, 3, 2, 8, 3, 3, 6, 3, 10, 3, 6, 3, 12, 3, 7, 3, 10, 3, 7, 3, 12, 3, 8, 3, 10, 3, 8, 3, 12};
    }

    private static short[] init__json_key_offsets_0() {
        return new short[]{0, 0, 18, 20, 22, 31, 33, 37, 39, 54, 56, 58, 62, 80, 82, 84, 89, 103, 110, 112, 115, 123, 127, 129, 135, 144, 151, 153, 161, 170, 174, 176, 183, 191, 199, 207, 215, 222, 230, 238, 246, 253, 261, 269, 277, 284, 293, 313, 315, 317, 322, 341, 348, 350, 358, 367, 371, 373, 380, 388, 396, 404, 412, 419, 427, 435, 443, 450, 458, 466, 474, 481, 490, 493, 500, 506, 513, 518, 526, 534, 542, 550, 557, 565, 573, 581, 588, 596, 604, 612, 619, 619};
    }

    private static char[] init__json_trans_keys_0() {
        return new char[]{' ', '\"', '$', '-', '[', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', '0', '9', '+', '-', '0', '9', '0', '9', ' ', '\"', '$', ',', '-', '_', '}', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ':', '\t', '\r', ' ', '\"', '$', '-', '[', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ',', '}', '\t', '\r', ' ', '\"', '$', '-', '_', '}', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', ' ', ',', ':', ']', '}', '\t', '\r', '0', '9', '.', '0', '9', ' ', ':', 'E', 'e', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', ':', '\t', '\r', '0', '9', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', ',', ':', ']', '}', '\t', '\r', '0', '9', ' ', ',', '.', '}', '\t', '\r', '0', '9', ' ', ',', 'E', 'e', '}', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', ',', '}', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', '\"', '$', ',', '-', '[', ']', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ',', ']', '\t', '\r', ' ', '\"', '$', '-', '[', ']', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', ' ', ',', ':', ']', '}', '\t', '\r', '0', '9', ' ', ',', '.', ']', '\t', '\r', '0', '9', ' ', ',', 'E', ']', 'e', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', ',', ']', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', '.', '\t', '\r', '0', '9', ' ', 'E', 'e', '\t', '\r', '0', '9', ' ', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', '\u0000'};
    }

    private static byte[] init__json_single_lengths_0() {
        return new byte[]{0, 10, 2, 2, 7, 0, 2, 0, 7, 2, 2, 2, 10, 2, 2, 3, 6, 5, 0, 1, 4, 2, 0, 2, 7, 5, 0, 4, 5, 2, 0, 3, 6, 6, 6, 6, 5, 6, 6, 6, 5, 6, 6, 6, 5, 7, 12, 2, 2, 3, 11, 5, 0, 4, 5, 2, 0, 3, 6, 6, 6, 6, 5, 6, 6, 6, 5, 6, 6, 6, 5, 7, 1, 5, 2, 3, 1, 6, 6, 6, 6, 5, 6, 6, 6, 5, 6, 6, 6, 5, 0, 0};
    }

    private static byte[] init__json_range_lengths_0() {
        return new byte[]{0, 4, 0, 0, 1, 1, 1, 1, 4, 0, 0, 1, 4, 0, 0, 1, 4, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 0, 0, 1, 4, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0};
    }

    private static short[] init__json_index_offsets_0() {
        return new short[]{0, 0, 15, 18, 21, 30, 32, 36, 38, 50, 53, 56, 60, 75, 78, 81, 86, 97, 104, 106, 109, 116, 120, 122, 127, 136, 143, 145, 152, 160, 164, 166, 172, 180, 188, 196, 204, 211, 219, 227, 235, 242, 250, 258, 266, 273, 282, 299, 302, 305, 310, 326, 333, 335, 342, 350, 354, 356, 362, 370, 378, 386, 394, 401, 409, 417, 425, 432, 440, 448, 456, 463, 472, 475, 482, 487, 493, 497, 505, 513, 521, 529, 536, 544, 552, 560, 567, 575, 583, 591, 598, 599};
    }

    private static byte[] init__json_trans_targs_0() {
        return new byte[]{1, 2, 73, 5, 72, 73, 77, 82, 86, 72, 1, 74, 73, 73, 0, 72, 4, 3, 72, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 74, 0, 7, 7, 76, 0, 76, 0, 8, 9, 17, 16, 18, 17, 90, 8, 17, 17, 17, 0, 11, 45, 10, 11, 45, 10, 11, 12, 11, 0, 12, 13, 25, 26, 15, 25, 32, 37, 41, 15, 12, 27, 25, 25, 0, 15, 24, 14, 15, 24, 14, 15, 16, 90, 15, 0, 16, 9, 17, 18, 17, 90, 16, 17, 17, 17, 0, 11, 0, 12, 0, 0, 11, 17, 19, 0, 20, 19, 0, 11, 12, 21, 21, 11, 20, 0, 22, 22, 23, 0, 23, 0, 11, 12, 11, 23, 0, 14, 14, 14, 14, 14, 14, 14, 14, 0, 15, 16, 0, 0, 90, 15, 25, 27, 0, 15, 16, 28, 90, 15, 27, 0, 15, 16, 29, 29, 90, 15, 28, 0, 30, 30, 31, 0, 31, 0, 15, 16, 90, 15, 31, 0, 15, 16, 0, 0, 33, 90, 15, 25, 15, 16, 0, 0, 34, 90, 15, 25, 15, 16, 0, 0, 35, 90, 15, 25, 15, 16, 0, 0, 36, 90, 15, 25, 15, 16, 0, 0, 90, 15, 25, 15, 16, 0, 0, 38, 90, 15, 25, 15, 16, 0, 0, 39, 90, 15, 25, 15, 16, 0, 0, 40, 90, 15, 25, 15, 16, 0, 0, 90, 15, 25, 15, 16, 0, 0, 42, 90, 15, 25, 15, 16, 0, 0, 43, 90, 15, 25, 15, 16, 0, 0, 44, 90, 15, 25, 15, 16, 0, 0, 90, 15, 25, 10, 10, 10, 10, 10, 10, 10, 10, 0, 46, 47, 51, 50, 52, 49, 91, 51, 58, 63, 67, 49, 46, 53, 51, 51, 0, 49, 71, 48, 49, 71, 48, 49, 50, 91, 49, 0, 50, 47, 51, 52, 49, 91, 51, 58, 63, 67, 49, 50, 53, 51, 51, 0, 49, 50, 0, 91, 0, 49, 51, 53, 0, 49, 50, 54, 91, 49, 53, 0, 49, 50, 55, 91, 55, 49, 54, 0, 56, 56, 57, 0, 57, 0, 49, 50, 91, 49, 57, 0, 49, 50, 0, 91, 59, 0, 49, 51, 49, 50, 0, 91, 60, 0, 49, 51, 49, 50, 0, 91, 61, 0, 49, 51, 49, 50, 0, 91, 62, 0, 49, 51, 49, 50, 0, 91, 0, 49, 51, 49, 50, 0, 91, 64, 0, 49, 51, 49, 50, 0, 91, 65, 0, 49, 51, 49, 50, 0, 91, 66, 0, 49, 51, 49, 50, 0, 91, 0, 49, 51, 49, 50, 0, 91, 68, 0, 49, 51, 49, 50, 0, 91, 69, 0, 49, 51, 49, 50, 0, 91, 70, 0, 49, 51, 49, 50, 0, 91, 0, 49, 51, 48, 48, 48, 48, 48, 48, 48, 48, 0, 72, 72, 0, 72, 0, 0, 0, 0, 72, 73, 72, 75, 72, 74, 0, 72, 6, 6, 72, 75, 0, 72, 72, 76, 0, 72, 0, 0, 0, 78, 0, 72, 73, 72, 0, 0, 0, 79, 0, 72, 73, 72, 0, 0, 0, 80, 0, 72, 73, 72, 0, 0, 0, 81, 0, 72, 73, 72, 0, 0, 0, 0, 72, 73, 72, 0, 0, 0, 83, 0, 72, 73, 72, 0, 0, 0, 84, 0, 72, 73, 72, 0, 0, 0, 85, 0, 72, 73, 72, 0, 0, 0, 0, 72, 73, 72, 0, 0, 0, 87, 0, 72, 73, 72, 0, 0, 0, 88, 0, 72, 73, 72, 0, 0, 0, 89, 0, 72, 73, 72, 0, 0, 0, 0, 72, 73, 0, 0, 0};
    }

    private static byte[] init__json_trans_actions_0() {
        return new byte[]{0, 0, 1, 1, 17, 1, 1, 1, 1, 13, 0, 1, 1, 1, 0, 24, 1, 1, 7, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 15, 0, 1, 1, 1, 0, 21, 1, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 17, 1, 1, 1, 1, 13, 0, 1, 1, 1, 0, 24, 1, 1, 7, 0, 0, 0, 0, 15, 0, 0, 0, 0, 1, 1, 1, 15, 0, 1, 1, 1, 0, 5, 0, 5, 0, 0, 5, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 7, 7, 0, 0, 27, 7, 0, 0, 0, 11, 11, 0, 39, 11, 0, 0, 9, 9, 0, 0, 33, 9, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 33, 9, 0, 0, 7, 7, 0, 0, 0, 27, 7, 0, 7, 7, 0, 0, 0, 27, 7, 0, 7, 7, 0, 0, 0, 27, 7, 0, 7, 7, 0, 0, 0, 27, 7, 0, 48, 48, 0, 0, 62, 48, 0, 7, 7, 0, 0, 0, 27, 7, 0, 7, 7, 0, 0, 0, 27, 7, 0, 7, 7, 0, 0, 0, 27, 7, 0, 51, 51, 0, 0, 70, 51, 0, 7, 7, 0, 0, 0, 27, 7, 0, 7, 7, 0, 0, 0, 27, 7, 0, 7, 7, 0, 0, 0, 27, 7, 0, 45, 45, 0, 0, 54, 45, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 1, 0, 1, 17, 19, 1, 1, 1, 1, 13, 0, 1, 1, 1, 0, 24, 1, 1, 7, 0, 0, 0, 0, 19, 0, 0, 0, 0, 1, 1, 17, 19, 1, 1, 1, 1, 13, 0, 1, 1, 1, 0, 7, 7, 0, 30, 0, 7, 0, 0, 0, 11, 11, 0, 42, 11, 0, 0, 9, 9, 0, 36, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 36, 9, 0, 0, 7, 7, 0, 30, 0, 0, 7, 0, 7, 7, 0, 30, 0, 0, 7, 0, 7, 7, 0, 30, 0, 0, 7, 0, 7, 7, 0, 30, 0, 0, 7, 0, 48, 48, 0, 66, 0, 48, 0, 7, 7, 0, 30, 0, 0, 7, 0, 7, 7, 0, 30, 0, 0, 7, 0, 7, 7, 0, 30, 0, 0, 7, 0, 51, 51, 0, 74, 0, 51, 0, 7, 7, 0, 30, 0, 0, 7, 0, 7, 7, 0, 30, 0, 0, 7, 0, 7, 7, 0, 30, 0, 0, 7, 0, 45, 45, 0, 58, 0, 45, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 7, 0, 0, 0, 0, 7, 0, 11, 0, 11, 0, 0, 9, 0, 0, 9, 0, 0, 9, 9, 0, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 48, 0, 0, 0, 0, 48, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 51, 0, 0, 0, 0, 51, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 45, 0, 0, 0, 0, 45, 0, 0, 0, 0};
    }

    private static byte[] init__json_eof_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 11, 9, 9, 7, 7, 7, 7, 48, 7, 7, 7, 51, 7, 7, 7, 45, 0, 0};
    }

    private void addChild(String string, JsonValue jsonValue) {
        jsonValue.setName(string);
        if (this.current.isArray() || this.current.isObject()) {
            this.current.addChild(jsonValue);
        } else {
            this.root = this.current;
        }
    }

    protected void startObject(String string) {
        JsonValue jsonValue = new JsonValue(JsonValue.ValueType.object);
        if (this.current != null) {
            this.addChild(string, jsonValue);
        }
        this.elements.add(jsonValue);
        this.current = jsonValue;
    }

    protected void startArray(String string) {
        JsonValue jsonValue = new JsonValue(JsonValue.ValueType.array);
        if (this.current != null) {
            this.addChild(string, jsonValue);
        }
        this.elements.add(jsonValue);
        this.current = jsonValue;
    }

    protected void pop() {
        this.root = this.elements.remove(this.elements.size() - 1);
        this.current = !this.elements.isEmpty() ? this.elements.get(this.elements.size() - 1) : null;
    }

    protected void string(String string, String string2) {
        this.addChild(string, new JsonValue(string2));
    }

    protected void number(String string, double d) {
        this.addChild(string, new JsonValue(d));
    }

    protected void number(String string, long l) {
        this.addChild(string, new JsonValue(l));
    }

    protected void bool(String string, boolean bl) {
        this.addChild(string, new JsonValue(bl));
    }

    private String unescape(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 16);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) != '\\') {
                stringBuilder.append(c);
                continue;
            }
            if (n2 == n) break;
            if ((c = string.charAt(n2++)) == 'u') {
                stringBuilder.append(Character.toChars(Integer.parseInt(string.substring(n2, n2 + 4), 16)));
                n2 += 4;
                continue;
            }
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    break;
                }
                case 'b': {
                    c = '\b';
                    break;
                }
                case 'f': {
                    c = '\f';
                    break;
                }
                case 'n': {
                    c = '\n';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                default: {
                    throw new JsonException("Illegal escaped character: \\" + c);
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

