/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.jsonbeans;

import com.esotericsoftware.jsonbeans.JsonException;
import com.esotericsoftware.jsonbeans.OutputType;

public class JsonValue {
    private String name;
    private ValueType type;
    private String stringValue;
    private Boolean booleanValue;
    private Double doubleValue;
    private long longValue;
    private JsonValue child;
    private JsonValue next;
    private JsonValue prev;

    public JsonValue(ValueType valueType) {
        this.type = valueType;
    }

    public JsonValue(String string) {
        this.set(string);
    }

    public JsonValue(double d) {
        this.set(d);
    }

    public JsonValue(long l) {
        this.set(l);
    }

    public JsonValue(boolean bl) {
        this.set(bl);
    }

    public JsonValue get(int n) {
        JsonValue jsonValue = this.child;
        while (jsonValue != null && n > 0) {
            --n;
            jsonValue = jsonValue.next;
        }
        return jsonValue;
    }

    public JsonValue get(String string) {
        JsonValue jsonValue = this.child;
        while (jsonValue != null && !jsonValue.name.equalsIgnoreCase(string)) {
            jsonValue = jsonValue.next;
        }
        return jsonValue;
    }

    public JsonValue require(int n) {
        JsonValue jsonValue = this.child;
        while (jsonValue != null && n > 0) {
            --n;
            jsonValue = jsonValue.next;
        }
        if (jsonValue == null) {
            throw new IllegalArgumentException("Child not found with index: " + n);
        }
        return jsonValue;
    }

    public JsonValue require(String string) {
        JsonValue jsonValue = this.child;
        while (jsonValue != null && !jsonValue.name.equalsIgnoreCase(string)) {
            jsonValue = jsonValue.next;
        }
        if (jsonValue == null) {
            throw new IllegalArgumentException("Child not found with name: " + string);
        }
        return jsonValue;
    }

    public JsonValue remove(int n) {
        JsonValue jsonValue = this.get(n);
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue.prev == null) {
            this.child = jsonValue.next;
            if (this.child != null) {
                this.child.prev = null;
            }
        } else {
            jsonValue.prev.next = jsonValue.next;
            if (jsonValue.next != null) {
                jsonValue.next.prev = jsonValue.prev;
            }
        }
        return jsonValue;
    }

    public JsonValue remove(String string) {
        JsonValue jsonValue = this.get(string);
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue.prev == null) {
            this.child = jsonValue.next;
            if (this.child != null) {
                this.child.prev = null;
            }
        } else {
            jsonValue.prev.next = jsonValue.next;
            if (jsonValue.next != null) {
                jsonValue.next.prev = jsonValue.prev;
            }
        }
        return jsonValue;
    }

    public int size() {
        JsonValue jsonValue = this.child;
        int n = 0;
        while (jsonValue != null) {
            ++n;
            jsonValue = jsonValue.next;
        }
        return n;
    }

    public String asString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        if (this.doubleValue != null) {
            if (this.doubleValue == (double)this.longValue) {
                return Long.toString(this.longValue);
            }
            return Double.toString(this.doubleValue);
        }
        if (this.booleanValue != null) {
            return Boolean.toString(this.booleanValue);
        }
        if (this.type == ValueType.nullValue) {
            return null;
        }
        throw new IllegalStateException("Value cannot be converted to string: " + (Object)((Object)this.type));
    }

    public float asFloat() {
        if (this.doubleValue != null) {
            return this.doubleValue.floatValue();
        }
        if (this.stringValue != null) {
            try {
                return Float.parseFloat(this.stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.booleanValue != null) {
            return this.booleanValue != false ? 1.0f : 0.0f;
        }
        throw new IllegalStateException("Value cannot be converted to float: " + (Object)((Object)this.type));
    }

    public double asDouble() {
        if (this.doubleValue != null) {
            return this.doubleValue;
        }
        if (this.stringValue != null) {
            try {
                return Double.parseDouble(this.stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.booleanValue != null) {
            return this.booleanValue != false ? 1.0 : 0.0;
        }
        throw new IllegalStateException("Value cannot be converted to double: " + (Object)((Object)this.type));
    }

    public long asLong() {
        if (this.doubleValue != null) {
            return this.longValue;
        }
        if (this.stringValue != null) {
            try {
                return Long.parseLong(this.stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.booleanValue != null) {
            return this.booleanValue != false ? 1L : 0L;
        }
        throw new IllegalStateException("Value cannot be converted to long: " + (Object)((Object)this.type));
    }

    public int asInt() {
        if (this.doubleValue != null) {
            return (int)this.longValue;
        }
        if (this.stringValue != null) {
            try {
                return Integer.parseInt(this.stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.booleanValue != null) {
            return this.booleanValue != false ? 1 : 0;
        }
        throw new IllegalStateException("Value cannot be converted to int: " + (Object)((Object)this.type));
    }

    public boolean asBoolean() {
        if (this.booleanValue != null) {
            return this.booleanValue;
        }
        if (this.doubleValue != null) {
            return this.longValue == 0L;
        }
        if (this.stringValue != null) {
            return this.stringValue.equalsIgnoreCase("true");
        }
        throw new IllegalStateException("Value cannot be converted to boolean: " + (Object)((Object)this.type));
    }

    public JsonValue getChild(String string) {
        JsonValue jsonValue = this.get(string);
        return jsonValue == null ? null : jsonValue.child;
    }

    public String getString(String string, String string2) {
        JsonValue jsonValue = this.get(string);
        return jsonValue == null || !jsonValue.isValue() || jsonValue.isNull() ? string2 : jsonValue.asString();
    }

    public float getFloat(String string, float f) {
        JsonValue jsonValue = this.get(string);
        return jsonValue == null || !jsonValue.isValue() ? f : jsonValue.asFloat();
    }

    public double getDouble(String string, double d) {
        JsonValue jsonValue = this.get(string);
        return jsonValue == null || !jsonValue.isValue() ? d : jsonValue.asDouble();
    }

    public long getLong(String string, long l) {
        JsonValue jsonValue = this.get(string);
        return jsonValue == null || !jsonValue.isValue() ? l : jsonValue.asLong();
    }

    public int getInt(String string, int n) {
        JsonValue jsonValue = this.get(string);
        return jsonValue == null || !jsonValue.isValue() ? n : jsonValue.asInt();
    }

    public boolean getBoolean(String string, boolean bl) {
        JsonValue jsonValue = this.get(string);
        return jsonValue == null || !jsonValue.isValue() ? bl : jsonValue.asBoolean();
    }

    public String getString(String string) {
        JsonValue jsonValue = this.get(string);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: " + string);
        }
        return jsonValue.asString();
    }

    public float getFloat(String string) {
        JsonValue jsonValue = this.get(string);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: " + string);
        }
        return jsonValue.asFloat();
    }

    public double getDouble(String string) {
        JsonValue jsonValue = this.get(string);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: " + string);
        }
        return jsonValue.asDouble();
    }

    public long getLong(String string) {
        JsonValue jsonValue = this.get(string);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: " + string);
        }
        return jsonValue.asLong();
    }

    public int getInt(String string) {
        JsonValue jsonValue = this.get(string);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: " + string);
        }
        return jsonValue.asInt();
    }

    public boolean getBoolean(String string) {
        JsonValue jsonValue = this.get(string);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: " + string);
        }
        return jsonValue.asBoolean();
    }

    public String getString(int n) {
        JsonValue jsonValue = this.get(n);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asString();
    }

    public float getFloat(int n) {
        JsonValue jsonValue = this.get(n);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asFloat();
    }

    public double getDouble(int n) {
        JsonValue jsonValue = this.get(n);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asDouble();
    }

    public long getLong(int n) {
        JsonValue jsonValue = this.get(n);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asLong();
    }

    public int getInt(int n) {
        JsonValue jsonValue = this.get(n);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asInt();
    }

    public boolean getBoolean(int n) {
        JsonValue jsonValue = this.get(n);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asBoolean();
    }

    public ValueType type() {
        return this.type;
    }

    public void setType(ValueType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.type = valueType;
    }

    public boolean isArray() {
        return this.type == ValueType.array;
    }

    public boolean isObject() {
        return this.type == ValueType.object;
    }

    public boolean isString() {
        return this.type == ValueType.stringValue;
    }

    public boolean isNumber() {
        return this.type == ValueType.doubleValue || this.type == ValueType.longValue;
    }

    public boolean isDouble() {
        return this.type == ValueType.doubleValue;
    }

    public boolean isLong() {
        return this.type == ValueType.longValue;
    }

    public boolean isBoolean() {
        return this.type == ValueType.booleanValue;
    }

    public boolean isNull() {
        return this.type == ValueType.nullValue;
    }

    public boolean isValue() {
        switch (this.type) {
            case stringValue: 
            case doubleValue: 
            case longValue: 
            case booleanValue: 
            case nullValue: {
                return true;
            }
        }
        return false;
    }

    public String name() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public JsonValue child() {
        return this.child;
    }

    public void addChild(JsonValue jsonValue) {
        JsonValue jsonValue2 = this.child;
        if (jsonValue2 == null) {
            this.child = jsonValue;
            return;
        }
        while (true) {
            if (jsonValue2.next == null) {
                jsonValue2.next = jsonValue;
                jsonValue.prev = jsonValue2;
                return;
            }
            jsonValue2 = jsonValue2.next;
        }
    }

    public JsonValue next() {
        return this.next;
    }

    public void setNext(JsonValue jsonValue) {
        this.next = jsonValue;
    }

    public JsonValue prev() {
        return this.prev;
    }

    public void setPrev(JsonValue jsonValue) {
        this.prev = jsonValue;
    }

    public void set(String string) {
        this.stringValue = string;
        this.type = string == null ? ValueType.nullValue : ValueType.stringValue;
    }

    public void set(double d) {
        this.doubleValue = d;
        this.longValue = (long)d;
        this.type = ValueType.doubleValue;
    }

    public void set(long l) {
        this.longValue = l;
        this.doubleValue = l;
        this.type = ValueType.longValue;
    }

    public void set(boolean bl) {
        this.booleanValue = bl;
        this.type = ValueType.booleanValue;
    }

    public String toString() {
        return this.prettyPrint(OutputType.minimal, 0);
    }

    public String prettyPrint(OutputType outputType, int n) {
        StringBuilder stringBuilder = new StringBuilder(512);
        this.prettyPrint(this, stringBuilder, outputType, 0, n);
        return stringBuilder.toString();
    }

    private void prettyPrint(JsonValue jsonValue, StringBuilder stringBuilder, OutputType outputType, int n, int n2) {
        if (jsonValue.isObject()) {
            if (jsonValue.child() == null) {
                stringBuilder.append("{}");
            } else {
                boolean bl = !JsonValue.isFlat(jsonValue);
                int n3 = stringBuilder.length();
                block0: while (true) {
                    stringBuilder.append(bl ? "{\n" : "{ ");
                    boolean bl2 = false;
                    for (JsonValue jsonValue2 = jsonValue.child(); jsonValue2 != null; jsonValue2 = jsonValue2.next()) {
                        if (bl) {
                            JsonValue.indent(n, stringBuilder);
                        }
                        stringBuilder.append(outputType.quoteName(jsonValue2.name()));
                        stringBuilder.append(": ");
                        this.prettyPrint(jsonValue2, stringBuilder, outputType, n + 1, n2);
                        if (jsonValue2.next() != null) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(bl ? (char)'\n' : ' ');
                        if (bl || stringBuilder.length() - n3 <= n2) continue;
                        stringBuilder.setLength(n3);
                        bl = true;
                        continue block0;
                    }
                    break;
                }
                if (bl) {
                    JsonValue.indent(n - 1, stringBuilder);
                }
                stringBuilder.append('}');
            }
        } else if (jsonValue.isArray()) {
            if (jsonValue.child() == null) {
                stringBuilder.append("[]");
            } else {
                boolean bl = !JsonValue.isFlat(jsonValue);
                int n4 = stringBuilder.length();
                block2: while (true) {
                    stringBuilder.append(bl ? "[\n" : "[ ");
                    for (JsonValue jsonValue3 = jsonValue.child(); jsonValue3 != null; jsonValue3 = jsonValue3.next()) {
                        if (bl) {
                            JsonValue.indent(n, stringBuilder);
                        }
                        this.prettyPrint(jsonValue3, stringBuilder, outputType, n + 1, n2);
                        if (jsonValue3.next() != null) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(bl ? (char)'\n' : ' ');
                        if (bl || stringBuilder.length() - n4 <= n2) continue;
                        stringBuilder.setLength(n4);
                        bl = true;
                        continue block2;
                    }
                    break;
                }
                if (bl) {
                    JsonValue.indent(n - 1, stringBuilder);
                }
                stringBuilder.append(']');
            }
        } else if (jsonValue.isString()) {
            stringBuilder.append(outputType.quoteValue(jsonValue.asString()));
        } else if (jsonValue.isDouble()) {
            long l;
            double d = jsonValue.asDouble();
            stringBuilder.append(d == (double)(l = jsonValue.asLong()) ? (double)l : d);
        } else if (jsonValue.isLong()) {
            stringBuilder.append(jsonValue.asLong());
        } else if (jsonValue.isBoolean()) {
            stringBuilder.append(jsonValue.asBoolean());
        } else if (jsonValue.isNull()) {
            stringBuilder.append("null");
        } else {
            throw new JsonException("Unknown object type: " + jsonValue);
        }
    }

    private static boolean isFlat(JsonValue jsonValue) {
        for (JsonValue jsonValue2 = jsonValue.child(); jsonValue2 != null; jsonValue2 = jsonValue2.next()) {
            if (!jsonValue2.isObject() && !jsonValue2.isArray()) continue;
            return false;
        }
        return true;
    }

    private static void indent(int n, StringBuilder stringBuilder) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('\t');
        }
    }

    public static enum ValueType {
        object,
        array,
        stringValue,
        doubleValue,
        longValue,
        booleanValue,
        nullValue;

    }
}

